-- Adminer 4.7.6 MySQL dump

SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';

DROP TABLE IF EXISTS `ad_advb_cl_contacts`;
CREATE TABLE `ad_advb_cl_contacts` (
  `idx` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `phone_number` varchar(30) NOT NULL,
  `business_name` varchar(200) DEFAULT NULL,
  `first_name` varchar(100) DEFAULT NULL,
  `last_name` varchar(100) DEFAULT NULL,
  `email` varchar(150) DEFAULT NULL,
  `address` text,
  `city` varchar(200) DEFAULT NULL,
  `state` varchar(200) DEFAULT NULL,
  `zip` varchar(30) DEFAULT NULL,
  `website` varchar(200) DEFAULT NULL,
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `opt_out` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idx`),
  UNIQUE KEY `phone_number` (`phone_number`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS `ad_advb_cl_link`;
CREATE TABLE `ad_advb_cl_link` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `contact_idx` int(255) NOT NULL,
  `list_idx` int(255) NOT NULL,
  `date_added` datetime NOT NULL,
  `add_type` varchar(100) NOT NULL DEFAULT 'Added Manually',
  PRIMARY KEY (`id`),
  UNIQUE KEY `list_idx` (`list_idx`,`contact_idx`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS `ad_advb_cl_notes`;
CREATE TABLE `ad_advb_cl_notes` (
  `idx` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `contact_idx` int(10) NOT NULL,
  `note` text NOT NULL,
  `type` enum('Manual','VoiceBroadcast','AutoDialer') DEFAULT NULL,
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`idx`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS `ad_advb_contacts`;
CREATE TABLE `ad_advb_contacts` (
  `idx` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `contact_of` varchar(30) NOT NULL,
  `campaign_idx` int(10) NOT NULL,
  `contact_number` varchar(45) NOT NULL,
  `call_status` varchar(20) NOT NULL DEFAULT 'pending',
  `phone_code` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idx`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS `ad_advb_contact_lists`;
CREATE TABLE `ad_advb_contact_lists` (
  `idx` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `list_name` varchar(30) NOT NULL,
  `status` varchar(1) NOT NULL DEFAULT '1',
  `last_updated` datetime NOT NULL,
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `user` varchar(50) DEFAULT NULL,
  `shared` tinyint(1) NOT NULL DEFAULT '0',
  `optin_keyword` varchar(50) DEFAULT NULL,
  `optin_number` varchar(50) DEFAULT NULL,
  `optin_response` varchar(255) DEFAULT NULL,
  `vb_opt_out_content` longtext NOT NULL,
  `vb_opt_out_type` varchar(100) NOT NULL,
  `vb_opt_out_voice` varchar(100) NOT NULL,
  `vb_opt_out_language` varchar(100) NOT NULL,
  `vb_opt_out_key` varchar(1) NOT NULL,
  `sms_opt_out_message` varchar(160) NOT NULL,
  `sms_opt_out_trigger` varchar(20) NOT NULL,
  PRIMARY KEY (`idx`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS `ad_ad_call_log`;
CREATE TABLE `ad_ad_call_log` (
  `idx` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `campaign_idx` int(10) DEFAULT NULL,
  `from` varchar(45) NOT NULL,
  `to` varchar(45) DEFAULT NULL,
  `duration` varchar(45) DEFAULT NULL,
  `response` varchar(30) DEFAULT NULL,
  `code` int(50) DEFAULT '0',
  `user` varchar(50) DEFAULT NULL,
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `recording_url` longtext,
  `company_id` int(11) DEFAULT NULL,
  `CallSid` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`idx`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS `ad_ad_campaigns`;
CREATE TABLE `ad_ad_campaigns` (
  `idx` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `campaign_name` varchar(100) DEFAULT NULL,
  `phone_number` varchar(45) NOT NULL,
  `contacts_list_idx` bigint(20) NOT NULL,
  `voicemail_messages` longtext NOT NULL,
  `voicemail_message_mp3` longtext,
  `voicemail_message_mp3_2` longtext NOT NULL,
  `voicemail_message_mp3_3` longtext NOT NULL,
  `voicemail_message_mp3_4` longtext NOT NULL,
  `call_script_tokens` longtext,
  `call_script_text` longtext,
  `calls_status` varchar(30) DEFAULT NULL,
  `progress` varchar(20) DEFAULT NULL,
  `last_ran` varchar(50) DEFAULT NULL,
  `user` varchar(50) DEFAULT NULL,
  `shared` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idx`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS `ad_callscripts`;
CREATE TABLE `ad_callscripts` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) unsigned DEFAULT NULL,
  `contents` longtext,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `ad_vb_call_log`;
CREATE TABLE `ad_vb_call_log` (
  `idx` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `campaign_idx` int(10) DEFAULT NULL,
  `from` varchar(45) NOT NULL,
  `to` varchar(45) DEFAULT NULL,
  `duration` varchar(45) DEFAULT NULL,
  `response` varchar(30) DEFAULT NULL,
  `code` varchar(50) DEFAULT NULL,
  `user` int(50) DEFAULT '0',
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `recording_url` longtext,
  PRIMARY KEY (`idx`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS `ad_vb_campaigns`;
CREATE TABLE `ad_vb_campaigns` (
  `idx` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `voicemail_only` tinyint(1) NOT NULL,
  `live_answer_only` bigint(20) NOT NULL,
  `campaign_name` varchar(100) DEFAULT NULL,
  `type` enum('VoiceBroadcast','SMSBroadcast','AutoResponder') NOT NULL DEFAULT 'VoiceBroadcast',
  `list_id` int(10) unsigned DEFAULT '0',
  `phone_number` varchar(45) NOT NULL,
  `sms_message` longtext NOT NULL,
  `live_answer_content` longtext NOT NULL,
  `live_answer_type` varchar(100) NOT NULL,
  `live_answer_voice` varchar(100) NOT NULL,
  `live_answer_language` varchar(100) NOT NULL,
  `voicemail_message_content` longtext NOT NULL,
  `voicemail_message_type` varchar(100) NOT NULL,
  `voicemail_message_voice` varchar(100) NOT NULL,
  `voicemail_message_language` varchar(100) NOT NULL,
  `allow_ivr` tinyint(1) NOT NULL,
  `ivr_key` char(1) NOT NULL,
  `ivr_phone_number` varchar(100) NOT NULL,
  `calls_status` varchar(30) DEFAULT NULL,
  `progress` varchar(20) DEFAULT NULL,
  `last_ran` varchar(50) DEFAULT NULL,
  `when_to_run` varchar(50) DEFAULT NULL,
  `user` int(11) DEFAULT NULL,
  `shared` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idx`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS `ad_vb_sequences`;
CREATE TABLE `ad_vb_sequences` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `campaign_id` int(11) unsigned NOT NULL,
  `type` enum('VoiceBroadcast','SMSBroadcast') NOT NULL DEFAULT 'VoiceBroadcast',
  `name` varchar(255) NOT NULL DEFAULT '',
  `days_after` int(11) NOT NULL DEFAULT '1',
  `time` varchar(40) NOT NULL DEFAULT '',
  `delay` varchar(20) NOT NULL,
  `sms_message` longtext,
  `live_answer_content` longtext NOT NULL,
  `live_answer_type` varchar(100) NOT NULL,
  `live_answer_voice` varchar(100) NOT NULL,
  `live_answer_language` varchar(100) NOT NULL,
  `voicemail_message_content` longtext NOT NULL,
  `voicemail_message_type` varchar(100) NOT NULL,
  `voicemail_message_voice` varchar(100) NOT NULL,
  `voicemail_message_language` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS `ad_vb_sequence_schedule`;
CREATE TABLE `ad_vb_sequence_schedule` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `sequence_id` int(11) unsigned NOT NULL,
  `cron_id` int(11) unsigned NOT NULL,
  `contact_id` int(11) unsigned NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS `blacklists`;
CREATE TABLE `blacklists` (
  `idx` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `numbers` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`idx`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `blacklists` (`idx`, `name`, `numbers`) VALUES
(1,	'Ryan',	',+18002306683,+19137257745,+12059776518,+19142450200,+13232844271,+12059776418,+12013514306,+16308691252,+18003437390,+16308691704,+12059776553,+16614385192,+15405047582,+12065382819,+18632742134,+16092255807,+14253126795,+14156535232,+14156535106,+12068020945,+16308691253,+14252472180,+17073462162,+18189752109,+17204509647,+16193639182,+19167588638,+12096747029,+16193639195,+14242177798,+17603308490,+16692384268,+19167588657,+12096747068,+17603731800,+13472058424,+16107312322,+19139714000,+13144803978,+14253914657,+17033763876,+16283336311,+16616315240,+16612054251,+15852473996,+13129863604,+15303929043,+12096747072,+19137257613,+13143322294,+19545913357,+16692384271,+12096747034,+19723018434,+13038024665,+12132983777,+12545370675,+14049616127,+17603308529,+16283336480,+19032656023,+14802148368,+16193639125,+19167588615,+19097481313,+14084252233,+14242177867,+12096747111,+14803853956,+19166340632,+14049616136,+16692384350,+13145698822,+17542012511,+15106402620,+19167588637,+16283336327,+16692384296,+16612997240,+16193639162,+17148885660,+12096747039,+19167588684,+18582390391,+18312233188,+17149554611,+16469309547,+14242064551,+19169039423,+16283336472,+14082170872,+14797514820,+17603308202,+12096747011,+16193199377,+16283336316,+19093453540,+16507133186,+16615780655,+18184461049,+14242034299,+13852491870,+16502886913,+18184461032,+19169251124,+13218327622,+16193576113,+16692384325,+18184461185,+18053015277,+17606918630,+19167588619,+17405214546,+12096747071,+19167588612,+19168600135,+13072176267,+16193639165,+16017484003,+14084714296,+12096747063,+16283336441,+18172930035,+17077066217,+12096747094,+19166008129,+2395806023,+19097639338,+16193639153,+12096747110,+17606918368,+17142032544,+16196846214,+14109882954,+14242177806,+15302989246,+19493451269,+19547732526,+12096747020,+13237987164,+18004298363,+12096747032,+16193639164,+17733186609,+14088199782,+19163811266,+16692384322,+13237987339,+17606918181,+14088199775,+18052108752,+12625015586,+14088199776,+19095710014,+14086855820,+17604445575,+12096747122,+19174774078,+16318565625,+14088199771,+19162466350,+19165475140,+12096747014,+18183215831,+13197343400,+18057387148,+18052563686,+12096747006,+15104555872,+19162466592,+12096747037,+15103610465,+13472058439,+18182103952,+19167588642,+14252762566,+14242066870,+16283336456,+16193639219,+13105963575,+13104094979,+13609473179,+19162459572,+18007941404,+16692384313,+16619005850,+13232852378,+18183717796,+12096747064,+16692384361,+19162457026,+19162466427,+19098103656,+18052420301,+19168496753,+19167588651,+16692384321,+19162466981,+16193639197,+13237987338,+16692384283,+18559092274,+16193639129,+12096747016,+18003246956,+16692384311,+14242177818,+19493596862,+19515306007,+19253930739,+18582051834,+13189007977,+15304445505,+19167588643,+15302901417,+17608579523,+15302901343,+18057387151,+15302901330,+12096747128,+16692384305,+16613241195,+14156535217,+16016641410,+17603308325,+19547732510,+15302901345,+16193639225,+15302901658,+15302901322,+16612470112,+13022890555,+18005454315,+12028005635,+18019032310,+15614598200,+17196242378,+18589970426,+13074596510,+18449271818,+13232722924,+17207707169,+19167991398,+16198289064,+16192024256,+17205000279,+14044005495,+19143431947,+19143317292,+13234868668,+15162467115,+14026852560,+13477539209,+13177156266,+18662458848,+19167588598,+17602390079,+19493262432,+18058621018,+18186550005,+14152663364,+15162467112,+17606918336,+18668322889,+19167588617,+13606692049,+16197730607,+17602998449,+18162054290,+17604785077,+16693500005,+15103136703,+17603028534,+14254958950,+19168070009,+14243950503,+14243060372,+18182804783,+15103136707,+12132140509,+17603726463,+17196242392,+16613715405,+16613018768,+19166806170,+15622693023,+19514485615,+13107298068,+16783921540,+12482438465,+12678106052,+12482438457,+12068995059,+13178037027,+13022618145,+14015432134,+12028510553,+12015471008,+18182247087,+17472465196,+13237987341,+12138057232,+14154631881,+16504667666,+14432589393,+17603308023,+19095420900,+16693335858,+14159805347,+13852491364,+17144972234,+17173089980,+12139854556,+12532015562,+14699304413,+13133568495,+14252333167,+12532015566,+17182850497,+16096231455,+12532015563,+14252335169,+12142152668,+16095757098,+14154814952,+17144972165,+17603308803,+19495564519,+19317400131,+16502886531,+19059183089,+14256573881,+12062081044,+19495654634,+19494306778,+16195050000,+19495654574,+14246722194,+19514210023,+19168881884,+18007574791,+19164781992,+14803865536,+18184846351,+19059183107,+18008609592,+12082847718,+18002528140,+12059776406,+14802075654,+17602578223,+13239225733,+13039638772,+16692207896,+19495654740,+14156500629,+19495564356,+17608579402,+17608827090,+19493810831,+18009137959,+14256575365,+19495367496,+12818143165,+16617275033,+14152267855,+18002471353,+16195167886,+19132762537,+13607120329,+16502787000,+17863457954,+18622291931,+120878161232,+12293384908,+19164142961,+13852491292,+19166750195,+15625665050,+13236730720,+17603308998,+17603308731,+14256512468,+18880114417,+15619815918,+12147183718,+12149570400,+19842694800,+18888343039,+13022233108,+14242315591,+18177568233,+18173759370,+18173753395,+14808404730,+12108228272,+19492151369,+14243131088,+18052585676,+18002485275,+16308691703,+13233319273,+18774925621,+16106296428,+19162370239,+16025332617,+18774614266,+18778894546,+18880125017,+16092255799,+18557933877,+13607121110,+12062071678,+912261014512,+18032239288,+13237913249,+266696687,+14152663393,+18002395701,+14072780836,+15805429233,+14693669560,+17603726466,+19514040081,+16197283566,+17753769222,+13464021215,+12293386004,+19514470383,+17378742833,+13463152370,+19165997525,+18454131105,+17576659121,+18565431151,+13052227913,+17624356727,+16282352079,+16822367585,+14696847991,+17049120283,+18006446415,+17023318335,+16262532629,+19166968594,+12142836076,+19568626925,+12148457570,+14253290788,+14696194257,+18327156360,+18476863308,+14052014241,+19168210799,+12103346000,+16236066866,+19722744219,+17862093341,+14695186129,+19728832626,+16477494087,+14152347308,+18175807276,+12146692982,+14693630104,+14696202320,+14693372478,+12143979029,+18184838863,+18587241024,+19165861538,+19032178547,+14067977255,+19255184890,+1611,+13852639390,+15028836070,+19254183036,+14053063888,+19108494234,+14807255663,+19043980080,+14054458894,+19402201979,+15802226936,+15202000526,+14696438279,+12144580624,+18177566508,+18172010914,+18777657446,+12147961784,+19726945069,+12084720214,+12144993065,+12147664078,+12146793304,+17208880025,+19728650201,+18143770204,+19256342735,+19257870281,+14053812375,+13013964127,+17605680170,+12145415830,+18169124021,+14696848504,+15054809069,+14805625290,+15414350766,+14052466623,+14695351139,+18177566446,+19493260156,+14695373858,+19722520084,+12543080030,+17209412006,+17735469489,+14707697697,+19252157071,+19252011899,+12407016460,+19165873460,+14076055047,+12062824100,+18177565414,+19728701992,+12144053124,+17738773667,+14152136503,+14152184805,+12407096091,+13012674558,+18433434725,+18433738345,+18433779543,+18009168800,+17812151594,+15419620131,+15052193011,+14694432807,+12144292080,+12542140066,+19725135350,+19252116581,+19252051140,+17144648728,+13012815308,+14044764576,+16614954124,+18448065577,+18177563018,+17028102020,+17029113157,+17029163877,+17136359103,+18163072214,+14029359013,+18002255662,+14023976600,+19405354517,+18444021199,+15125421542,+16194354154,+18178212307,+18174266582,+12056708644,+15182270841,+15102289964,+18003472688,+13017444518,+15622464302,+14054768087,+19727927777,+19723048880,+17028858872,+13239939889,+16194360908,+12154500182,+15105194430,+15108475673,+14152139492,+14152139174,+19282376128,+15102373321,+15102362484,+19252048163,+12024956123,+16233320850,+19165845440,+17029165771,+16194362844,+13239808981,+19722037172,+12149803852,+16092469263,+19252126962,+14087738809,+15202103599,+14049903007,+16782497741,+12145029295,+19722520055,+15595542241,+17154903283,+18175229964,+12148385469,+12094027313,+15102392711,+12542247957,+19186065711,+12149447356,+15052221319,+19499452133,+15102395843,+14158524913,+14153652062,+16672230244,+13256926334,+12254143051,+15052191230,+18176966042,+14699682291,+17138103931,+18432149989,+18002251388,+17075424739,+17704604281,+17372200490,+18179926134,+17157691290,+15037497107,+14153967171,+19252313869,+18433725666,+16194582065,+18173431735,+13609143804,+15053886183,+19166937435,+12064600324,+15616382006,+17854228984,+18436418488,+19255840363,+16782493700,+14052472229,+14698127177,+12813007341,+19166359101,+19166322573,+14693317857,+17063503334,+16194343594,+19728836124,+19162739789,+15037497100,+18003913000,+17704694461,+12813093980,+12813055247,+12812388006,+16788907448,+16786685638,+16787458408,+18174028253,+16198268872,+16193147724,+16198233047,+16465682984,+16198241482,+16199961760,+16194865013,+16193912402,+16193912414,+16193147723,+16199961744,+19156035299,+16193912428,+18002669981,+16193147737,+13032281500,+18302793408,+12107140401,+19178410729,+14695384938,+12142821783,+19142153044,+19725259821,+17134290145,+12409009351,+15592490105,+15036087549,+19177769418,+16787095828,+12813064414,+17132544740,+18332795319,+15052077570,+15054314518,+17704692147,+16788016586,+17704755040,+19403048708,+17029130982,+12524298597,+19166950566,+19163783388,+17138935995,+15032814161,+17157604734,+15419260002,+18009309066,+12404373964,+13018258231,+16782026441,+14052540694,+18323064360,+17029122796,+18582210194,+16194358700,+18582470743,+14358908930,+14157957978,+19253725852,+19252022683,+17042472047,+14802009701,+16193091435,+19166324735,+19166319042,+15038289688,+19402201776,+19259338693,+17738690815,+14256911255,+15129100999,+12145384707,+14696600696,+17622350670,+16464937714,+19252318457,+19252311891,+14158568587,+15592160383,+14158562754,+18889801532,+14698818527,+12122010750,+17026029141,+16194733577,+16194800943,+18562455766,+15056660778,+15752142651,+18663436666,+12014411276,+14696783840,+19724728149,+15132013684,+14158574749,+19163028666,+14158533769,+14158758924,+18582581546,+15102302893,+13173429844,+16193924543,+16197938158,+16197638444,+19727584433,+442030144455,+12144291986,+15126990829,+19727427251,+18002255345,+19122644289,+12404576992,+16023033202,+14807023618,+12568601679,+14158721875,+18312277783,+15034822789,+18473219287,+13342651678,+15122495303,+16192708653,+16196957316,+16198499848,+12816915086,+14702807285,+16196320074,+14047479012,+15102398008,+15103617197,+12813053952,+14326140219,+16462312428,+17023744822,+16129790984,+16129790887,+19197247388,+16196212916,+16197442706,+18172982604,+18438683778,+19493981745,+18888806020,+18009106704,+17785848685,+12147908231,+19405141526,+17157604935,+12138046724,+12566323500,+14056737087,+14054798699,+17133663024,+16785945649,+14693319190,+17755604428,+14043482750,+14057372199,+12817465550,+18437909013,+18005976827,+10000000000,+18438064409,+15187309592,+13472521199,+17182858345,+16082999446,+17134178164,+18176739134,+18644798508,+18322827796,+18645138217,+12024952433,+15402538686,+14158719714,+18667802280,+12814436112,+16786214044,+17707905826,+13126382701,+18179125637,+18176171645,+18172088591,+14303161345,+17073884207,+13258643294,+18009227898,+14094970527,+14422595467,+18648968412,+13855290840,+18178846574,+12107452154,+18004079059,+18179322649,+14086007153,+17028308764,+17865780443,+19255686231,+18003250778,+14064128924,+19723478071,+14062236754,+14099040310,+12147105513,+16784278765,+19196283251,+17135217158,+19195490610,+19194708347,+19197393013,+19194349283,+15707940628,+16786605356,+19197267890,+19197915902,+12145576271,+12148860652,+19739303858,+14692177082,+19722968998,+13472604654,+12515896816,+17027716047,+17022004116,+19194121178,+19197268009,+17135748860,+13033213469,+17137216320,+16787167771,+16788221885,+19197057307,+19195464380,+19192048694,+19196599402,+13218952295,+12025076619,+19195583810,+19195514309,+19198813078,+19194708053,+12147102102,+19728037493,+12813698614,+16012868298,+17133828636,+12142289970,+12146455200,+19894229536,+12136602063,+15052195774,+12134528839,+14256911294,+14699934170,+12024580611,+18006800733,+15713424070,+15165307310,+17135594005,+16822051547,+19197267669,+19195739760,+19193263381,+19197096601,+19197969194,+18000003899,+40395909,+18325201029,+17135675410,+13463424347,+12817219284,+17133109590,+12129612050,+18323180349,+18562303018,+18562302300,+19193721617,+19197244230,+19169705491,+19195691620,+12146166438,+13139192378,+13865182756,+12069772943,+12065273254,+13073357698,+12069945281,+19168578805,+19165661278,+19165763493,+12026574085,+12024955011,+18438993870,+18436568700,+18032360532,+17022872006,+17026726770,+17029113256,+15615413124,+17131186056,+16198027897,+16192317633,+15618078579,+14692054093,+13234869142,+14057451051,+19724574666,+17027645192,+17867852818,+12484796249,+16194346227,+15203919224,+16786582717,+17143853500,+16139653849,+13613322644,+16232313130,+16784335563,+14703644989,+14235056867,+16784338118,+16784337044,+14043076000,+16784336478,+16784337627,+16786582671,+16781889463,+16784875881,+16788553938,+16785068899,+16782355043,+16785068881,+14702033169,+16782497137,+16788951689,+17132342486,+15302605122,+18002200007,+15107468084,+15104788114,+18009359935,+14158572331,+14099327411,+15103866921,+14707412025,+13524585287,+15614371279,+19258711013,+19253001219,+18007723360,+18007720669,+14809239701,+14802372074,+14804520360,+14807413260,+14803538496,+14804325994,+14808852796,+14804585543,+13602278175,+17134849406,+14693509673,+18654075187,+18653996898,+19192066660,+19196810793,+16207401070,+19195612859,+14056738958,+14056735821,+14056738667,+14056735927,+12024952651,+18326482750,+17742206399,+14104527582,+19842694780,+17136715391,+17136575067,+13073357726,+13073357719,+13073357718,+13073357683,+12146863118,+18584960740,+18174884089,+14695061711,+12057534645,+14702034807,+17027420840,+14252472781,+19252310803,+19253106199,+18447309957,+17076732650,+15032144400,+19253721999,+19186159755,+16192712950,+15102992098,+17136100518,+16786582665,+18594950257,+18437799303,+17602179119,+17202628070,+15612556572,+19728853504,+19724663134,+18173608828,+18174016479,+12147182417,+19253937865,+19164793869,+14063930283,+19562296700,+17023448948,+12146826740');

DROP TABLE IF EXISTS `calls`;
CREATE TABLE `calls` (
  `Index` bigint(255) unsigned NOT NULL AUTO_INCREMENT,
  `CallSid` char(34) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `OriginalCallSid` char(34) COLLATE utf8_unicode_ci NOT NULL,
  `DateCreated` datetime DEFAULT NULL,
  `ToCountry` longtext COLLATE utf8_unicode_ci,
  `ToZip` longtext COLLATE utf8_unicode_ci,
  `ToState` longtext COLLATE utf8_unicode_ci,
  `ToCity` longtext COLLATE utf8_unicode_ci,
  `FromCountry` longtext COLLATE utf8_unicode_ci,
  `FromZip` longtext COLLATE utf8_unicode_ci,
  `ApiVersion` longtext COLLATE utf8_unicode_ci,
  `Direction` longtext COLLATE utf8_unicode_ci,
  `CallStatus` longtext COLLATE utf8_unicode_ci,
  `AccountSid` longtext COLLATE utf8_unicode_ci,
  `CallerID` longtext COLLATE utf8_unicode_ci,
  `CallTo` longtext COLLATE utf8_unicode_ci,
  `CallFrom` longtext COLLATE utf8_unicode_ci,
  `Status` longtext COLLATE utf8_unicode_ci,
  `StartTime` datetime DEFAULT NULL,
  `EndTime` datetime DEFAULT NULL,
  `Duration` int(11) DEFAULT NULL,
  `FromCity` longtext COLLATE utf8_unicode_ci,
  `FromState` longtext COLLATE utf8_unicode_ci,
  `DialCallSid` longtext COLLATE utf8_unicode_ci,
  `DialCallTo` longtext COLLATE utf8_unicode_ci,
  `DialCallStatus` longtext COLLATE utf8_unicode_ci,
  `DialCallDuration` int(11) DEFAULT NULL,
  `RecordingUrl` longtext COLLATE utf8_unicode_ci,
  `PhoneCode` bigint(20) unsigned DEFAULT '0',
  `SpId` int(11) DEFAULT NULL,
  `participants` text COLLATE utf8_unicode_ci NOT NULL,
  `Department` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`Index`),
  KEY `SpId` (`SpId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `calls` (`Index`, `CallSid`, `OriginalCallSid`, `DateCreated`, `ToCountry`, `ToZip`, `ToState`, `ToCity`, `FromCountry`, `FromZip`, `ApiVersion`, `Direction`, `CallStatus`, `AccountSid`, `CallerID`, `CallTo`, `CallFrom`, `Status`, `StartTime`, `EndTime`, `Duration`, `FromCity`, `FromState`, `DialCallSid`, `DialCallTo`, `DialCallStatus`, `DialCallDuration`, `RecordingUrl`, `PhoneCode`, `SpId`, `participants`, `Department`) VALUES
(1,	'CA5f8a28030e901febe980e5d784e9b944',	'',	'2015-12-28 18:30:31',	'US',	'59105',	'MT',	'BILLINGS',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18002306683',	'+14062151971',	'+18002306683',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA5f8a28030e901febe980e5d784e9b944',	'+16197649267',	'completed',	95,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE7a87517b8e21d332b5745acf5af8a420',	0,	0,	'',	''),
(2,	'CAc24e6c79b52cf2a248827b8352be4f1a',	'',	'2015-12-30 18:36:21',	'US',	'59105',	'MT',	'BILLINGS',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18002306683',	'+14062151971',	'+18002306683',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CAc24e6c79b52cf2a248827b8352be4f1a',	'+16197649267',	'completed',	73,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REca116d7e98bbe47e554de0e12a8edff7',	0,	0,	'',	''),
(3,	'CAc0f227edee8432361d948f4e94098d0c',	'',	'2016-01-01 17:45:56',	'US',	'59105',	'MT',	'BILLINGS',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18002306683',	'+14062151971',	'+18002306683',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CAc0f227edee8432361d948f4e94098d0c',	'+16197649267',	'completed',	81,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE9032178f3d7e9cf1e8356f7942badbea',	0,	0,	'',	''),
(4,	'CA069994c58551284f0d49c563107a2669',	'',	'2016-01-05 03:30:20',	'US',	'59105',	'MT',	'BILLINGS',	'US',	'59903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14062509831',	'+14062151971',	'+14062509831',	NULL,	NULL,	NULL,	NULL,	'KALISPELL',	'MT',	'CA069994c58551284f0d49c563107a2669',	'+16197649267',	'completed',	37,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd5cadfdf9f5067ea1aa84d5687e3161c',	0,	0,	'',	''),
(5,	'CA50129db40699af6bed8e3216c5971055',	'',	'2016-01-05 03:31:22',	'US',	'59105',	'MT',	'BILLINGS',	'US',	'59903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14062509831',	'+14062151971',	'+14062509831',	NULL,	NULL,	NULL,	NULL,	'KALISPELL',	'MT',	'CA50129db40699af6bed8e3216c5971055',	'+16197649267',	'completed',	107,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3bd9290a85858bfed9dc0583f50d8769',	0,	0,	'',	''),
(6,	'CA53ce39cfbd041421ffd728b231cfe67b',	'',	'2016-01-19 16:23:46',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'20388',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12024558888',	'+16612439350',	'+12024558888',	NULL,	NULL,	NULL,	NULL,	'WASHINGTON',	'DC',	'CA53ce39cfbd041421ffd728b231cfe67b',	'+14062509831',	'completed',	28,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE59a3827d7ead0e7e1898112385e068e3',	0,	0,	'',	''),
(7,	'CAc3ab793804c803cb2083455cdf36f149',	'',	'2016-01-19 16:36:28',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'20388',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12024558888',	'+19162627163',	'+12024558888',	NULL,	NULL,	NULL,	NULL,	'WASHINGTON',	'DC',	'CAc3ab793804c803cb2083455cdf36f149',	'+14062509831',	'completed',	22,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE98c804de4528da029caf4053aee4d2f9',	0,	0,	'',	''),
(8,	'CAcc73d8c8f5969a8fd2a2adc55f2a7464',	'',	'2016-01-23 23:08:06',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'20388',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12024558888',	'+14252338984',	'+12024558888',	NULL,	NULL,	NULL,	NULL,	'WASHINGTON',	'DC',	'CAcc73d8c8f5969a8fd2a2adc55f2a7464',	'+14062509831',	'completed',	25,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf923a7ff9a0fef92893387a49c7fa5b2',	0,	0,	'',	''),
(9,	'CAed177b4d216ab32ee756a6fc3a49a00e',	'',	'2016-01-26 16:14:31',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18003437390',	'+19162627163',	'+18003437390',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CAed177b4d216ab32ee756a6fc3a49a00e',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(10,	'CAa42219b105bad887bfacf58f2a516984',	'',	'2016-01-26 16:46:42',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'66941',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19137257745',	'+19162627163',	'+19137257745',	NULL,	NULL,	NULL,	NULL,	'KANSAS CITY',	'KS',	'CAa42219b105bad887bfacf58f2a516984',	'+14062509831',	'completed',	66,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE48bd30b9ebd4e1094bf9d5adde91cf82',	0,	0,	'',	''),
(11,	'CA7cdce6842e22a7bb7dee9af02d93334b',	'',	'2016-01-26 19:45:37',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'35242',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12059776518',	'+19162627163',	'+12059776518',	NULL,	NULL,	NULL,	NULL,	'BIRMINGHAM',	'AL',	'CA7cdce6842e22a7bb7dee9af02d93334b',	'+14062509831',	'completed',	40,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE722ed64c95ade4610b83ac960c8145c3',	0,	0,	'',	''),
(12,	'CA6025665085249a8743ed77ddaa06e05d',	'',	'2016-01-26 23:50:55',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'35242',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12059776518',	'+19162627163',	'+12059776518',	NULL,	NULL,	NULL,	NULL,	'BIRMINGHAM',	'AL',	'CA6025665085249a8743ed77ddaa06e05d',	'+14062509831',	'completed',	41,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE154fbd508fc59fdbcec52d7de0905160',	0,	0,	'',	''),
(13,	'CA226d14c525db15f073cd9685cc3aaf49',	'',	'2016-01-28 14:43:49',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'10536',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19162627163',	'+19142450200',	NULL,	NULL,	NULL,	NULL,	'YORKTOWN',	'NY',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(14,	'CAf9808bd8e51aa129c0b150546cbb172b',	'',	'2016-01-28 15:57:55',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'33136',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17863580429',	'+19162627163',	'+17863580429',	NULL,	NULL,	NULL,	NULL,	'MIAMI',	'FL',	'CAf9808bd8e51aa129c0b150546cbb172b',	'+14062509831',	'completed',	6,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3bd51fe27f37b82791e2932e04f03839',	0,	0,	'',	''),
(15,	'CA12e9bdb0220642ae3707aea5fafe4494',	'',	'2016-01-28 16:42:33',	'US',	'',	'CA',	'',	'US',	'35242',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12059776418',	'+19513741928',	'+12059776418',	NULL,	NULL,	NULL,	NULL,	'BIRMINGHAM',	'AL',	'CA12e9bdb0220642ae3707aea5fafe4494',	'+14062509831',	'completed',	44,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE9c92a01c4047fd356b60cd9ff91c68bb',	0,	0,	'',	''),
(16,	'CA73f1297fd3ee3ad71a574ee489a45d17',	'',	'2016-01-28 17:13:42',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'10536',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19142450200',	'+19162627163',	'+19142450200',	NULL,	NULL,	NULL,	NULL,	'YORKTOWN',	'NY',	'CA73f1297fd3ee3ad71a574ee489a45d17',	'+14062509831',	'completed',	14,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa17b26b3db15f1bb041ef04e9fdec3a4',	0,	0,	'',	''),
(17,	'CA3d8bce7a9008fd5aba3f4c371c1876b0',	'',	'2016-01-28 17:14:24',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'10536',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19142450200',	'+19162627163',	'+19142450200',	NULL,	NULL,	NULL,	NULL,	'YORKTOWN',	'NY',	'CA3d8bce7a9008fd5aba3f4c371c1876b0',	'+14062509831',	'completed',	33,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REae751ff5abf40c8cae84f3ac95d10767',	0,	0,	'',	''),
(18,	'CAb688a32037272e846a80746e279a3459',	'',	'2016-01-28 18:31:26',	'US',	'',	'CA',	'',	'US',	'90004',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13232844271',	'+19513741928',	'+13232844271',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CAb688a32037272e846a80746e279a3459',	'+14062509831',	'completed',	42,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE16859a259fa4f1bbda4272769ead0867',	0,	0,	'',	''),
(19,	'CA5f18e98808d6e2610a0a3f920c2194a8',	'',	'2016-01-29 06:06:34',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'07601',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12013514306',	'+19162627163',	'+12013514306',	NULL,	NULL,	NULL,	NULL,	'HACKENSACK',	'NJ',	'CA5f18e98808d6e2610a0a3f920c2194a8',	'+14062509831',	'completed',	58,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE54da6dfa4395fc0fe0a200ac0dd5db40',	0,	0,	'',	''),
(20,	'CA0d5069db5e28c06cf631482a99a979e4',	'',	'2016-01-29 16:33:44',	'US',	'',	'CA',	'',	'US',	'92506',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19515654562',	'+19513741928',	'+19515654562',	NULL,	NULL,	NULL,	NULL,	'RIVERSIDE',	'CA',	'CA0d5069db5e28c06cf631482a99a979e4',	'+14062509831',	'completed',	55,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE343c8a6b2de9a0f95dcff0d3c73e8d8b',	0,	0,	'',	''),
(21,	'CA241293677507aa0b79dbdf9dccda638c',	'',	'2016-01-29 17:31:49',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18779618684',	'+16612439350',	'+18779618684',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA241293677507aa0b79dbdf9dccda638c',	'+14062509831',	'completed',	77,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REca15b037eaa1e20d29c5f34d59522e4c',	0,	0,	'',	''),
(22,	'CAddc671b4264c7e78c096fb0cf92e4c21',	'',	'2016-01-29 18:31:15',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'32254',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19043870215',	'+16612439350',	'+19043870215',	NULL,	NULL,	NULL,	NULL,	'JACKSONVILLE',	'FL',	'CAddc671b4264c7e78c096fb0cf92e4c21',	'+14062509831',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf84e4b2dc1aeb5a65ae6f98edef7a63b',	0,	0,	'',	''),
(23,	'CAe130c796a9c05c893dbae3318728ef2e',	'',	'2016-01-29 22:09:33',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'35242',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12059776553',	'+16612439350',	'+12059776553',	NULL,	NULL,	NULL,	NULL,	'BIRMINGHAM',	'AL',	'CAe130c796a9c05c893dbae3318728ef2e',	'+14062509831',	'completed',	12,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE50948ed6932bd636a0f8ae7307c31a3e',	0,	0,	'',	''),
(24,	'CAbcb4d3b1545681ab39238b2c16bcc735',	'',	'2016-01-29 23:09:28',	'US',	'',	'CA',	'',	'US',	'92506',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19515654562',	'+19513741928',	'+19515654562',	NULL,	NULL,	NULL,	NULL,	'RIVERSIDE',	'CA',	'CAbcb4d3b1545681ab39238b2c16bcc735',	'+14062509831',	'completed',	4,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REbeed92ee7ab41152b3a02b0c3de1ddda',	0,	0,	'',	''),
(25,	'CAe2e550d7ebf2725b3ec2a48227131437',	'',	'2016-01-30 05:36:23',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18003437390',	'+14252338984',	'+18003437390',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CAe2e550d7ebf2725b3ec2a48227131437',	'+14062509831',	'completed',	25,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REedf49b60d2bb22d0340dd0c8777ae68e',	0,	0,	'',	''),
(26,	'CA1b9889bc4fba4820b34968a39e05a7f9',	'',	'2016-02-01 15:55:40',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'60517',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16308691704',	'+16612439350',	'+16308691704',	NULL,	NULL,	NULL,	NULL,	'DOWNERS GROVE',	'IL',	'CA1b9889bc4fba4820b34968a39e05a7f9',	'+14062509831',	'completed',	4,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE1bd02ddfe4508a252dcb1869aa671727',	0,	0,	'',	''),
(27,	'CA569e8953740bc654f65e4046c9399d89',	'',	'2016-02-01 16:24:39',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'60517',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16308691252',	'+19162627163',	'+16308691252',	NULL,	NULL,	NULL,	NULL,	'DOWNERS GROVE',	'IL',	'CA569e8953740bc654f65e4046c9399d89',	'+14062509831',	'completed',	4,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE61e1945956c38459f98dbfa73ca3ffc2',	0,	0,	'',	''),
(28,	'CA3749abda2cd191d97175ff5b6419bda2',	'',	'2016-02-01 17:28:19',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'91733',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16262131631',	'+14252338984',	'+16262131631',	NULL,	NULL,	NULL,	NULL,	'EL MONTE',	'CA',	'CA3749abda2cd191d97175ff5b6419bda2',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(29,	'CAe88bec05d0edaba6dd43b65fca4d2b0f',	'',	'2016-02-01 17:55:09',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'93280',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16614385192',	'+16612439350',	'+16614385192',	NULL,	NULL,	NULL,	NULL,	'WASCO',	'CA',	'CAe88bec05d0edaba6dd43b65fca4d2b0f',	'+14062509831',	'completed',	30,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE62bf01b2c2be0973f8b19777a50031b7',	0,	0,	'',	''),
(30,	'CA1f7b3d585a07e60dc79cc56c421b546b',	'',	'2016-02-01 21:20:20',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'33619',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18632742134',	'+14252338984',	'+18632742134',	NULL,	NULL,	NULL,	NULL,	'TAMPA',	'FL',	'CA1f7b3d585a07e60dc79cc56c421b546b',	'+14062509831',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE240d2da8e7b36bd9dcf2861e280914b8',	0,	0,	'',	''),
(31,	'CA20a4fdf937c473d5d4896240f2376566',	'',	'2016-02-01 21:21:01',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'33619',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18632742134',	'+14252338984',	'+18632742134',	NULL,	NULL,	NULL,	NULL,	'TAMPA',	'FL',	'CA20a4fdf937c473d5d4896240f2376566',	'+14062509831',	'completed',	21,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd7ef050032ec3aa63126e9e5455995a7',	0,	0,	'',	''),
(32,	'CA94f0cf43eff910839a321c3dad9f091b',	'',	'2016-02-01 21:46:57',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14156535232',	'+19162627163',	'+14156535232',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA94f0cf43eff910839a321c3dad9f091b',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(33,	'CAf0801ec0ba759b33773aa9378c395101',	'',	'2016-02-01 22:19:47',	'US',	'',	'CA',	'',	'US',	'92506',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19515654562',	'+19513741928',	'+19515654562',	NULL,	NULL,	NULL,	NULL,	'RIVERSIDE',	'CA',	'CAf0801ec0ba759b33773aa9378c395101',	'+14062509831',	'completed',	4,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf93b140ec4624774fb15f00286917776',	0,	0,	'',	''),
(34,	'CAd181969f913fb9843f534ac6ec0b5cb0',	'',	'2016-02-02 17:01:09',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12065382819',	'+14252338984',	'+12065382819',	NULL,	NULL,	NULL,	NULL,	'',	'WA',	'CAd181969f913fb9843f534ac6ec0b5cb0',	'+14062509831',	'completed',	16,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE48b23a255fcfb2682ffd5287bc7cbd38',	0,	0,	'',	''),
(35,	'CA063ebfe67b8e49bfa5e7cc96ae358766',	'',	'2016-02-02 17:30:34',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12065382819',	'+14252338984',	'+12065382819',	NULL,	NULL,	NULL,	NULL,	'',	'WA',	'CA063ebfe67b8e49bfa5e7cc96ae358766',	'+14062509831',	'completed',	47,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE28b9d70d8d7c628ec15e3811dfaafd4e',	0,	0,	'',	''),
(36,	'CA2a5d9733ebda9f5dbb0d76dc47923101',	'',	'2016-02-02 17:43:40',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'22603',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15405047582',	'+14252338984',	'+15405047582',	NULL,	NULL,	NULL,	NULL,	'WINCHESTER',	'VA',	'CA2a5d9733ebda9f5dbb0d76dc47923101',	'+14062509831',	'completed',	17,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE9724395cd2b44187584fd0110b26408f',	0,	0,	'',	''),
(37,	'CAe5d2be4b0a1a2fbf6a4a875ed24df7a7',	'',	'2016-02-02 21:02:35',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'08232',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16092255807',	'+16612439350',	'+16092255807',	NULL,	NULL,	NULL,	NULL,	'PLEASANTVILLE',	'NJ',	'CAe5d2be4b0a1a2fbf6a4a875ed24df7a7',	'+14062509831',	'no-answer',	6,	NULL,	0,	0,	'',	''),
(38,	'CA7b7122464126c1e661f2a01548bffdba',	'',	'2016-02-03 17:42:15',	'US',	'',	'CA',	'',	'US',	'60517',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16308691709',	'+19513741928',	'+16308691709',	NULL,	NULL,	NULL,	NULL,	'DOWNERS GROVE',	'IL',	'CA7b7122464126c1e661f2a01548bffdba',	'+14062509831',	'completed',	4,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REbbe4c9cc2b84835653347fad353135a2',	0,	0,	'',	''),
(39,	'CA70918c2175c4de7bc14d020b6d542155',	'',	'2016-02-03 18:20:20',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'98201',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14253126795',	'+14252338984',	'+14253126795',	NULL,	NULL,	NULL,	NULL,	'EVERETT',	'WA',	'CA70918c2175c4de7bc14d020b6d542155',	'+14062509831',	'completed',	44,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE7ce55e6eaa07a2103de5f308a6816aaf',	0,	0,	'',	''),
(40,	'CA3495dbd71d525872841a1defabb3fc9c',	'',	'2016-02-04 22:25:05',	'US',	'',	'CA',	'',	'US',	'92544',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19516589747',	'+19513741928',	'+19516589747',	NULL,	NULL,	NULL,	NULL,	'HEMET',	'CA',	'CA3495dbd71d525872841a1defabb3fc9c',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(41,	'CAc0644c8d3f806a836ee01e308bf59b6f',	'',	'2016-02-05 18:22:37',	'US',	'',	'CA',	'',	'US',	'92506',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19515654562',	'+19513741928',	'+19515654562',	NULL,	NULL,	NULL,	NULL,	'RIVERSIDE',	'CA',	'CAc0644c8d3f806a836ee01e308bf59b6f',	'+14062509831',	'completed',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE44de2164814ba270734880c7a17c2859',	0,	0,	'',	''),
(42,	'CAc371f0c58088138ee228b5522b6eb08d',	'',	'2016-02-08 19:29:44',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'60517',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16308691727',	'+19162627163',	'+16308691727',	NULL,	NULL,	NULL,	NULL,	'DOWNERS GROVE',	'IL',	'CAc371f0c58088138ee228b5522b6eb08d',	'+14062509831',	'completed',	4,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE1374a1d48690c610cb8df80299394963',	0,	0,	'',	''),
(43,	'CAe3d5541708a57bb3cace656d8adb5ffe',	'',	'2016-02-09 16:10:59',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14156535232',	'+19162627163',	'+14156535232',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAe3d5541708a57bb3cace656d8adb5ffe',	'+14062509831',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE84e82e6980770907287cb3386262af43',	0,	0,	'',	''),
(44,	'CAc38f5530d1423a811498727e762ff954',	'',	'2016-02-09 22:13:33',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14156535106',	'+14252338984',	'+14156535106',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAc38f5530d1423a811498727e762ff954',	'+14062509831',	'completed',	45,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REeda5afa3611d03d0b61054c38a119076',	0,	0,	'',	''),
(45,	'CAfd73ac361e9a874620e5a68b296528d7',	'',	'2016-02-10 22:06:35',	'US',	'',	'CA',	'',	'US',	'92506',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19515654562',	'+19513741928',	'+19515654562',	NULL,	NULL,	NULL,	NULL,	'RIVERSIDE',	'CA',	'CAfd73ac361e9a874620e5a68b296528d7',	'+14062509831',	'completed',	53,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE891a6e140a41132c376cf818d336d87e',	0,	0,	'',	''),
(46,	'CAb7577c4db4196b0eacee9063c4409874',	'',	'2016-02-10 22:18:20',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'60517',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16308691253',	'+19162627163',	'+16308691253',	NULL,	NULL,	NULL,	NULL,	'DOWNERS GROVE',	'IL',	'CAb7577c4db4196b0eacee9063c4409874',	'+14062509831',	'completed',	3,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE73cc8a7eaf755e52efbec3b72bb10364',	0,	0,	'',	''),
(47,	'CAa8d5948e23c38965aee64f36a9f16bbd',	'',	'2016-02-11 19:15:31',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14156535106',	'+14252338984',	'+14156535106',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAa8d5948e23c38965aee64f36a9f16bbd',	'+14062509831',	'completed',	19,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc223f049fcd0dc0a79ec79e2d30effc8',	0,	0,	'',	''),
(48,	'CA01b2397514455f4ba4b734518eab44f1',	'',	'2016-02-12 00:17:27',	'US',	'',	'CA',	'',	'US',	'92506',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19515654562',	'+19513741928',	'+19515654562',	NULL,	NULL,	NULL,	NULL,	'RIVERSIDE',	'CA',	'CA01b2397514455f4ba4b734518eab44f1',	'+14062509831',	'completed',	3,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REcab34b941c4485d01fb31d268de927f5',	0,	0,	'',	''),
(49,	'CAeb7e817782454a09bf03e1f66c735b1f',	'',	'2016-02-12 23:01:32',	'US',	'',	'CA',	'',	'US',	'92506',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19515654562',	'+19513741928',	'+19515654562',	NULL,	NULL,	NULL,	NULL,	'RIVERSIDE',	'CA',	'CAeb7e817782454a09bf03e1f66c735b1f',	'+14062509831',	'completed',	6,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE53cfb470865e3b69a1e4a0d38b5387ba',	0,	0,	'',	''),
(50,	'CAfa0751c559224fac1ea4a6cde6241c6a',	'',	'2016-02-15 19:31:27',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'60517',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16308691253',	'+16612439350',	'+16308691253',	NULL,	NULL,	NULL,	NULL,	'DOWNERS GROVE',	'IL',	'CAfa0751c559224fac1ea4a6cde6241c6a',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(51,	'CAda64f8320b0c9584d3735439f0c9a8fd',	'',	'2016-02-15 20:08:29',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'98131',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12068020945',	'+14252338984',	'+12068020945',	NULL,	NULL,	NULL,	NULL,	'SEATTLE',	'WA',	'CAda64f8320b0c9584d3735439f0c9a8fd',	'+14062509831',	'completed',	76,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE79db2e765ebc8a1452125165ae27b4b6',	0,	0,	'',	''),
(52,	'CA26df550c45d2ba58a671343366ceb7ac',	'',	'2016-02-16 18:48:15',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14156535232',	'+19162627163',	'+14156535232',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA26df550c45d2ba58a671343366ceb7ac',	'+14062509831',	'completed',	41,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe9384ca7c7858a25f01569cd461bb338',	0,	0,	'',	''),
(53,	'CAf749b1b2cc17d3374c84711069467f98',	'',	'2016-02-16 19:26:47',	'US',	'',	'CA',	'',	'US',	'90017',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19515753110',	'+19513741928',	'+19515753110',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CAf749b1b2cc17d3374c84711069467f98',	'+14062509831',	'completed',	30,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3d4ec74da9b5e385c84e625059393c5d',	0,	0,	'',	''),
(54,	'CA9c95b9f7ea9604f4d3a539f0411f72be',	'',	'2016-02-17 23:42:06',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'98402',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14252472180',	'+19162627163',	'+14252472180',	NULL,	NULL,	NULL,	NULL,	'TACOMA',	'WA',	'CA9c95b9f7ea9604f4d3a539f0411f72be',	'+14062509831',	'completed',	47,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3688b3cc1db55ab8767de49611843370',	0,	0,	'',	''),
(55,	'CA1798bdce40c39506f0f5ddcd8fdb14ba',	'',	'2016-02-19 19:22:24',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17073462162',	'+19162627163',	'+17073462162',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA1798bdce40c39506f0f5ddcd8fdb14ba',	'+14062509831',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE9ebacae8adaa0ac18dd7ae1ad808eeed',	0,	0,	'',	''),
(56,	'CAd8c3a1bad9f1cd18c74f04398783a6ce',	'',	'2016-02-22 23:07:30',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19167588638',	'+19162627163',	'+19167588638',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAd8c3a1bad9f1cd18c74f04398783a6ce',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(57,	'CA9a9a483a149a35ea275fbaa12b63ab40',	'',	'2016-02-23 21:08:12',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19167588638',	'+19162627163',	'+19167588638',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA9a9a483a149a35ea275fbaa12b63ab40',	'+14062509831',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE92bb310851823c36999e1897bb5ea4b6',	0,	0,	'',	''),
(58,	'CA9aa4427a2bba1e9169e5113501fc2455',	'',	'2016-02-24 23:44:27',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'91934',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16193639182',	'+19162627163',	'+16193639182',	NULL,	NULL,	NULL,	NULL,	'PINE VALLEY',	'CA',	'CA9aa4427a2bba1e9169e5113501fc2455',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(59,	'CA8c218c2ce5a7c12d40e02e869ddbe7b5',	'',	'2016-02-24 23:57:20',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'91934',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16193639182',	'+14252338984',	'+16193639182',	NULL,	NULL,	NULL,	NULL,	'PINE VALLEY',	'CA',	'CA8c218c2ce5a7c12d40e02e869ddbe7b5',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(60,	'CAaeb149d561ad4dfd3900393056f5603e',	'',	'2016-02-26 23:12:06',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17204509647',	'+19162627163',	'+17204509647',	NULL,	NULL,	NULL,	NULL,	'',	'CO',	'CAaeb149d561ad4dfd3900393056f5603e',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(61,	'CAc58925e08af613227e3d6decdfd38c0b',	'',	'2016-02-29 22:19:41',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'91335',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18189752109',	'+19162627163',	'+18189752109',	NULL,	NULL,	NULL,	NULL,	'RESEDA',	'CA',	'CAc58925e08af613227e3d6decdfd38c0b',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(62,	'CAea76f7042aa96fb40d5e333900456e62',	'',	'2016-02-29 23:34:38',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'91335',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18189752109',	'+14252338984',	'+18189752109',	NULL,	NULL,	NULL,	NULL,	'RESEDA',	'CA',	'CAea76f7042aa96fb40d5e333900456e62',	'+14062509831',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf8a6c91d3840213e6d33706af74de16f',	0,	0,	'',	''),
(63,	'CAfad165068359b971d7a63aee28bacfbf',	'',	'2016-03-01 20:51:49',	'US',	'',	'CA',	'',	'US',	'90017',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19515753110',	'+19513741928',	'+19515753110',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CAfad165068359b971d7a63aee28bacfbf',	'+14062509831',	'completed',	79,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REce20cda361fbd978a9e9280dea99034f',	0,	0,	'',	''),
(64,	'CA5c05fbdbc5b4d25c6fa9598b89225775',	'',	'2016-03-01 22:37:54',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'91934',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16193639195',	'+19162627163',	'+16193639195',	NULL,	NULL,	NULL,	NULL,	'PINE VALLEY',	'CA',	'CA5c05fbdbc5b4d25c6fa9598b89225775',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(65,	'CA371499d50fc74c5238b3fec7e818df24',	'',	'2016-03-02 19:17:04',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747029',	'+19162627163',	'+12096747029',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CA371499d50fc74c5238b3fec7e818df24',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(66,	'CA66f7a44e874db1ac9809ceccb5160a60',	'',	'2016-03-02 22:13:14',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747029',	'+14252338984',	'+12096747029',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CA66f7a44e874db1ac9809ceccb5160a60',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(67,	'CAc95820418e31bd96b7da2f7d85cd09d2',	'',	'2016-03-03 19:11:22',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'93501',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17603731800',	'+16612439350',	'+17603731800',	NULL,	NULL,	NULL,	NULL,	'CALIF CITY',	'CA',	'CAc95820418e31bd96b7da2f7d85cd09d2',	'+14062509831',	'completed',	12,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE79947f9f08f5e3ac0a846e6eecbe7319',	0,	0,	'',	''),
(68,	'CA193d854d1aa3c923c34139eff8ee188e',	'',	'2016-03-03 19:11:57',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'91934',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16193639226',	'+14252338984',	'+16193639226',	NULL,	NULL,	NULL,	NULL,	'PINE VALLEY',	'CA',	'CA193d854d1aa3c923c34139eff8ee188e',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(69,	'CA4aaf49a81815a829182d43303d447b56',	'',	'2016-03-03 21:24:10',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'91934',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16193639226',	'+19162627163',	'+16193639226',	NULL,	NULL,	NULL,	NULL,	'PINE VALLEY',	'CA',	'CA4aaf49a81815a829182d43303d447b56',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(70,	'CA8520102ab063df44a20270bb27089425',	'',	'2016-03-03 22:39:05',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12066419486',	'+14252338984',	'+12066419486',	NULL,	NULL,	NULL,	NULL,	'',	'WA',	'CA8520102ab063df44a20270bb27089425',	'+14062509831',	'completed',	6,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE1a312675728791146f1ceea2168a6979',	0,	0,	'',	''),
(71,	'CAa6cf6fdf2fe7f8cea378012cbe3e2ed7',	'',	'2016-03-03 23:47:30',	'US',	'',	'CA',	'',	'US',	'59903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14062509831',	'+19513741928',	'+14062509831',	NULL,	NULL,	NULL,	NULL,	'KALISPELL',	'MT',	'CAa6cf6fdf2fe7f8cea378012cbe3e2ed7',	'+14068623454',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE48dafe479eec505ca8349d7fc6a0dd45',	0,	0,	'',	''),
(72,	'CA8d4e7a992492e9082c88ef9ce3135c18',	'',	'2016-03-04 18:19:18',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'92614',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14242177798',	'+14252338984',	'+14242177798',	NULL,	NULL,	NULL,	NULL,	'IRVINE',	'CA',	'CA8d4e7a992492e9082c88ef9ce3135c18',	'+18668390198',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE268d05415dfb9a540cd7c6dd36c8bd38',	0,	0,	'',	''),
(73,	'CAafe239bd6ca361c60b206f8301817e26',	'',	'2016-03-04 20:02:17',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'92614',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14242177798',	'+19162627163',	'+14242177798',	NULL,	NULL,	NULL,	NULL,	'IRVINE',	'CA',	'CAafe239bd6ca361c60b206f8301817e26',	'+14062509831',	'no-answer',	6,	NULL,	0,	0,	'',	''),
(74,	'CAb7e6d6f480c7f939616d37f20f916368',	'',	'2016-03-07 17:08:35',	'US',	'',	'CA',	'',	'US',	'92084',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17603308490',	'+19513741928',	'+17603308490',	NULL,	NULL,	NULL,	NULL,	'VISTA',	'CA',	'CAb7e6d6f480c7f939616d37f20f916368',	'+19517356815',	'completed',	66,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf0062f756e34f4d7cbf1a7ef353efc98',	0,	0,	'',	''),
(75,	'CA4d59ab8213459e8a764a059c5b0bc037',	'',	'2016-03-07 22:55:29',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16692384268',	'+19162627163',	'+16692384268',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA4d59ab8213459e8a764a059c5b0bc037',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(76,	'CAe2dd9bf11116750a0790738638d0456c',	'',	'2016-03-07 23:26:22',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16692384268',	'+19162627163',	'+16692384268',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAe2dd9bf11116750a0790738638d0456c',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(77,	'CAae1070f0f3057c6ddb4c7e7532c743a9',	'',	'2016-03-07 23:33:10',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16692384268',	'+14252338984',	'+16692384268',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAae1070f0f3057c6ddb4c7e7532c743a9',	'+18668390198',	'completed',	4,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc7d51e4435feb0f364a300f44faeed70',	0,	0,	'',	''),
(78,	'CAf1a542a4747da24f296bdf9c08533ff8',	'',	'2016-03-08 22:27:57',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19167588657',	'+14252338984',	'+19167588657',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAf1a542a4747da24f296bdf9c08533ff8',	'+18668390198',	'no-answer',	7,	NULL,	0,	0,	'',	''),
(79,	'CA9792ade2565ee848f0256f924162a0fa',	'',	'2016-03-08 23:31:52',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19167588657',	'+19162627163',	'+19167588657',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA9792ade2565ee848f0256f924162a0fa',	'+14062509831',	'no-answer',	6,	NULL,	0,	0,	'',	''),
(80,	'CA948236f3be71975ffabc5f3c4f363e05',	'',	'2016-03-09 17:49:44',	'US',	'',	'CA',	'',	'US',	'19405',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16107312322',	'+19513741928',	'+16107312322',	NULL,	NULL,	NULL,	NULL,	'NORRISTOWN',	'PA',	'CA948236f3be71975ffabc5f3c4f363e05',	'+19517356815',	'completed',	234,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE365a70134c832233a103fc5d8d923faa',	0,	0,	'',	''),
(81,	'CA01be9c35c4d2d41acc0eb9f51576c813',	'',	'2016-03-09 19:43:54',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747068',	'+14252338984',	'+12096747068',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CA01be9c35c4d2d41acc0eb9f51576c813',	'+18668390198',	'no-answer',	8,	NULL,	0,	0,	'',	''),
(82,	'CAf8179869d47f7ddbf94cdd29a75f5f12',	'',	'2016-03-09 20:42:13',	'US',	'',	'CA',	'',	'US',	'10523',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13472058424',	'+19513741928',	'+13472058424',	NULL,	NULL,	NULL,	NULL,	'ELMSFORD',	'NY',	'CAf8179869d47f7ddbf94cdd29a75f5f12',	'+19517356815',	'completed',	6,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE71e988fc06f3c380b8bdb1678a97a07f',	0,	0,	'',	''),
(83,	'CA21bb3cc35645a6771d36af30806dbd72',	'',	'2016-03-09 21:48:04',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747068',	'+19162627163',	'+12096747068',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CA21bb3cc35645a6771d36af30806dbd72',	'+14062509831',	'no-answer',	6,	NULL,	0,	0,	'',	''),
(84,	'CA4146a2ade1fa393761634eda83cf4911',	'',	'2016-03-10 16:59:02',	'US',	'',	'CA',	'',	'US',	'66062',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19139714000',	'+19513741928',	'+19139714000',	NULL,	NULL,	NULL,	NULL,	'OLATHE',	'KS',	'CA4146a2ade1fa393761634eda83cf4911',	'+19517356815',	'completed',	14,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE9d30e9a22c3d90c0d418c1c0c09e6b21',	0,	0,	'',	''),
(85,	'CA3714cc5a5a1b46a6cd04062d732b3fc2',	'',	'2016-03-10 17:05:16',	'US',	'',	'CA',	'',	'US',	'63105',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13144803978',	'+19513741928',	'+13144803978',	NULL,	NULL,	NULL,	NULL,	'SAINT LOUIS',	'MO',	'CA3714cc5a5a1b46a6cd04062d732b3fc2',	'+19517356815',	'completed',	4,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc54fe2d8b8cb8bc8cca85408578d078a',	0,	0,	'',	''),
(86,	'CAc15512a4a28f54e23f8a8307ac2bddfc',	'',	'2016-03-11 15:41:31',	'US',	'',	'CA',	'',	'US',	'20190',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17033763876',	'+19513741928',	'+17033763876',	NULL,	NULL,	NULL,	NULL,	'HERNDON',	'VA',	'CAc15512a4a28f54e23f8a8307ac2bddfc',	'+19517356815',	'completed',	399,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4554ec1d35afbb903220770d0fa85f61',	0,	0,	'',	''),
(87,	'CA34ae8273a25f6304e733dcfbe262edb9',	'',	'2016-03-11 18:23:58',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'94103',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16283336311',	'+19162627163',	'+16283336311',	NULL,	NULL,	NULL,	NULL,	'San Francisco',	'CA',	'CA34ae8273a25f6304e733dcfbe262edb9',	'+14062509831',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb0b0d87c9d69c2704cec3659d2dccaf4',	0,	0,	'',	''),
(88,	'CA984186412589aa189479a45a262d6149',	'',	'2016-03-11 22:51:24',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'98074',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14253914657',	'+14252338984',	'+14253914657',	NULL,	NULL,	NULL,	NULL,	'ISSAQUAH',	'WA',	'CA984186412589aa189479a45a262d6149',	'+18668390198',	'completed',	34,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REedcc9c6aeda99ed5c64ae5d143370cb1',	0,	0,	'',	''),
(89,	'CAc46eff915a023c02d8519e9ee5ada17a',	'',	'2016-03-14 15:22:46',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'14606',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15852473996',	'+14252338984',	'+15852473996',	NULL,	NULL,	NULL,	NULL,	'ROCHESTER',	'NY',	'CAc46eff915a023c02d8519e9ee5ada17a',	'+18668390198',	'completed',	32,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3d27a726822690fce167d770bd135dfb',	0,	0,	'',	''),
(90,	'CAa56a080eeb8b2961239a3e6e6e9d25f4',	'',	'2016-03-14 16:48:56',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'60610',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13129863604',	'+14252338984',	'+13129863604',	NULL,	NULL,	NULL,	NULL,	'CHICAGO',	'IL',	'CAa56a080eeb8b2961239a3e6e6e9d25f4',	'+18668390198',	'completed',	44,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb6fbe6a9e1ac71858d2edbfbc95640b3',	0,	0,	'',	''),
(91,	'CAc8c053252bcf3505e17e1a38b84d8700',	'',	'2016-03-14 17:17:33',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'93312',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16612054251',	'+16612439350',	'+16612054251',	NULL,	NULL,	NULL,	NULL,	'BAKERSFIELD',	'CA',	'CAc8c053252bcf3505e17e1a38b84d8700',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(92,	'CA8745148b31f16a2a77e10d14697f33f6',	'',	'2016-03-14 17:17:39',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'93308',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16616315240',	'+16612439350',	'+16616315240',	NULL,	NULL,	NULL,	NULL,	'BAKERSFIELD',	'CA',	'CA8745148b31f16a2a77e10d14697f33f6',	'+14062509831',	'completed',	17,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE12204ffd99908d09e6cebc00e3cdaeb9',	0,	0,	'',	''),
(93,	'CA1600773738b454045b7f914403ea3ab0',	'',	'2016-03-14 18:11:46',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'95602',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15303929043',	'+14252338984',	'+15303929043',	NULL,	NULL,	NULL,	NULL,	'AUBURN',	'CA',	'CA1600773738b454045b7f914403ea3ab0',	'+18668390198',	'no-answer',	6,	NULL,	0,	0,	'',	''),
(94,	'CAc74167d8aefd2dc428f8a33ea3812dd1',	'',	'2016-03-14 20:44:13',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95602',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15303929043',	'+19162627163',	'+15303929043',	NULL,	NULL,	NULL,	NULL,	'AUBURN',	'CA',	'CAc74167d8aefd2dc428f8a33ea3812dd1',	'+14062509831',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE9ecfc038625235b527de950280478da3',	0,	0,	'',	''),
(95,	'CA29a5f59958d2b6dcd62d5d7e218e4465',	'',	'2016-03-15 21:23:10',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747072',	'+14252338984',	'+12096747072',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CA29a5f59958d2b6dcd62d5d7e218e4465',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(96,	'CA0cd49596989e3ecf63056738f469c7aa',	'',	'2016-03-15 21:49:20',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747072',	'+19162627163',	'+12096747072',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CA0cd49596989e3ecf63056738f469c7aa',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(97,	'CAb88171f791804289f3c0b3ba5a561b3d',	'',	'2016-03-16 17:52:42',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'66941',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19137257613',	'+16612439350',	'+19137257613',	NULL,	NULL,	NULL,	NULL,	'KANSAS CITY',	'KS',	'CAb88171f791804289f3c0b3ba5a561b3d',	'+14062509831',	'completed',	53,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4e337e8df2a6c5dcf5660797f914a57b',	0,	0,	'',	''),
(98,	'CA64b501f16caa73b2f27c2f55a4725de1',	'',	'2016-03-16 18:20:01',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16692384271',	'+19162627163',	'+16692384271',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA64b501f16caa73b2f27c2f55a4725de1',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(99,	'CAba0ba8ce639df7b30f8b4660093fdc2e',	'',	'2016-03-16 18:23:00',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16692384271',	'+14252338984',	'+16692384271',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAba0ba8ce639df7b30f8b4660093fdc2e',	'+14062509831',	'completed',	4,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REfff0973418baf793a19ef89287bd7d47',	0,	0,	'',	''),
(100,	'CAe622a57b57e260a021015c9a7502da51',	'',	'2016-03-16 19:06:01',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'63043',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13143322294',	'+16612439350',	'+13143322294',	NULL,	NULL,	NULL,	NULL,	'MARYLAND HEIGHTS',	'MO',	'CAe622a57b57e260a021015c9a7502da51',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(101,	'CAbc9c85a2b0fdaf681c25aa620434d0a2',	'',	'2016-03-16 21:59:40',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'33316',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19545913357',	'+16612439350',	'+19545913357',	NULL,	NULL,	NULL,	NULL,	'FORT LAUDERDALE',	'FL',	'CAbc9c85a2b0fdaf681c25aa620434d0a2',	'+14062509831',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe4bd95d870aabfc9297ab54af7aceea3',	0,	0,	'',	''),
(102,	'CA9e89478b7ee2049633a1e7ec58e1c5b7',	'',	'2016-03-17 16:41:06',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747034',	'+19162627163',	'+12096747034',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CA9e89478b7ee2049633a1e7ec58e1c5b7',	'+14062509831',	'completed',	6,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REdaef69b632943c27987f31bf5d91605d',	0,	0,	'',	''),
(103,	'CAc666a094c37cdb45be09fde46cefa43e',	'',	'2016-03-17 16:52:56',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747034',	'+14252338984',	'+12096747034',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CAc666a094c37cdb45be09fde46cefa43e',	'+14062509831',	'no-answer',	7,	NULL,	0,	0,	'',	''),
(104,	'CAe07bf9ad2227d0b848fab7de504c3ace',	'',	'2016-03-17 17:37:22',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'75251',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19723018434',	'+14252338984',	'+19723018434',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CAe07bf9ad2227d0b848fab7de504c3ace',	'+14062509831',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REbf04942a56a98e45f4438236176cd29f',	0,	0,	'',	''),
(105,	'CAbc95925792a0c8cdeb184e87230c2a20',	'',	'2016-03-17 20:45:47',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'85021',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14802148368',	'+16612439350',	'+14802148368',	NULL,	NULL,	NULL,	NULL,	'PHOENIX',	'AZ',	'CAbc95925792a0c8cdeb184e87230c2a20',	'+14062509831',	'completed',	40,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc997ad8dfd6fece644216c140ed33ae4',	0,	0,	'',	''),
(106,	'CAef99fa5535d13f2738b685f79d94260b',	'',	'2016-03-17 20:48:13',	'US',	'',	'CA',	'',	'US',	'80138',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13038024665',	'+19513741928',	'+13038024665',	NULL,	NULL,	NULL,	NULL,	'DENVER',	'CO',	'CAef99fa5535d13f2738b685f79d94260b',	'+14062509831',	'completed',	60,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE77434b78220e0132e7e4727f977b4b8c',	0,	0,	'',	''),
(107,	'CA314b9f86272e5c9151042dc3dc13f3fd',	'',	'2016-03-18 17:31:43',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12132983777',	'+14252338984',	'+12132983777',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA314b9f86272e5c9151042dc3dc13f3fd',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(108,	'CAa3587563926790680a6757c7dd7d6acf',	'',	'2016-03-18 18:42:16',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12132983777',	'+19162627163',	'+12132983777',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAa3587563926790680a6757c7dd7d6acf',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(109,	'CA57a5a0715f151e51bcae896511a488a4',	'',	'2016-03-18 20:53:47',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'90017',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17606918149',	'+16612439350',	'+17606918149',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA57a5a0715f151e51bcae896511a488a4',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(110,	'CA2b889617af224629697533d52a118c13',	'',	'2016-03-21 15:10:04',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'30260',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14049616127',	'+14252338984',	'+14049616127',	NULL,	NULL,	NULL,	NULL,	'ATLANTA',	'GA',	'CA2b889617af224629697533d52a118c13',	'+14062509831',	'completed',	37,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE572bea9b809f42bbf8e14abd688a91e5',	0,	0,	'',	''),
(111,	'CA67904ae891f6895e221547d1fa3991a6',	'',	'2016-03-21 18:03:32',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'94103',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16283336480',	'+19162627163',	'+16283336480',	NULL,	NULL,	NULL,	NULL,	'San Francisco',	'CA',	'CA67904ae891f6895e221547d1fa3991a6',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(112,	'CA3c9cf5b3a79d6d3cc0ccc445741ddd5d',	'',	'2016-03-21 20:47:02',	'US',	'',	'CA',	'',	'US',	'92084',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17603308529',	'+19513741928',	'+17603308529',	NULL,	NULL,	NULL,	NULL,	'VISTA',	'CA',	'CA3c9cf5b3a79d6d3cc0ccc445741ddd5d',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(113,	'CAb06716b678f98f54f116c571e56accbc',	'',	'2016-03-21 20:48:36',	'US',	'',	'CA',	'',	'US',	'92084',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19513741928',	'+17603308529',	NULL,	NULL,	NULL,	NULL,	'VISTA',	'CA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(114,	'CA21eaa08ed95a9d09fb45ebf16bc93c30',	'',	'2016-03-21 21:50:51',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'76704',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12545370675',	'+16612439350',	'+12545370675',	NULL,	NULL,	NULL,	NULL,	'WACO',	'TX',	'CA21eaa08ed95a9d09fb45ebf16bc93c30',	'+14062509831',	'completed',	48,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE02ed487e224a82299f43443b460908b5',	0,	0,	'',	''),
(115,	'CA6c6e5bac898bf6708d6cf7116e9aebbe',	'',	'2016-03-21 21:53:42',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'76704',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12545370675',	'+16612439350',	'+12545370675',	NULL,	NULL,	NULL,	NULL,	'WACO',	'TX',	'CA6c6e5bac898bf6708d6cf7116e9aebbe',	'+14062509831',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE5d58ee444122f5d1299278f74ab3713f',	0,	0,	'',	''),
(116,	'CA72ad70c95d40d33e9787059c51b4af0b',	'',	'2016-03-21 23:03:24',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'75633',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19032656023',	'+19162627163',	'+19032656023',	NULL,	NULL,	NULL,	NULL,	'CARTHAGE',	'TX',	'CA72ad70c95d40d33e9787059c51b4af0b',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(117,	'CA5d614b90369f075a3523266ca34ac635',	'',	'2016-03-22 17:30:33',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'85021',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14802148368',	'+16612439350',	'+14802148368',	NULL,	NULL,	NULL,	NULL,	'PHOENIX',	'AZ',	'CA5d614b90369f075a3523266ca34ac635',	'+14062509831',	'completed',	45,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3eb7a629fa3e60331257322cdda9a400',	0,	0,	'',	''),
(118,	'CA81227bc43609a25b68ea2e68e69e8cc7',	'',	'2016-03-22 17:36:14',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19167588615',	'+19162627163',	'+19167588615',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA81227bc43609a25b68ea2e68e69e8cc7',	'+14062509831',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE95d72005bba0e9985bed241072144ece',	0,	0,	'',	''),
(119,	'CA899e4337d89b827984e7b1f178ff3fa9',	'',	'2016-03-22 18:16:43',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19167588615',	'+14252338984',	'+19167588615',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA899e4337d89b827984e7b1f178ff3fa9',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(120,	'CAbbf81ad10c486e1c8b9527b5ae941ae1',	'',	'2016-03-22 22:31:21',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19167588615',	'+14252338984',	'+19167588615',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAbbf81ad10c486e1c8b9527b5ae941ae1',	'+14062509831',	'no-answer',	7,	NULL,	0,	0,	'',	''),
(121,	'CA1130b52b5459c2449fcb101d3c2683a7',	'',	'2016-03-22 23:04:16',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19167588615',	'+19162627163',	'+19167588615',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA1130b52b5459c2449fcb101d3c2683a7',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(122,	'CAcd44d5942fcf1f974475a1caf95f72ba',	'',	'2016-03-23 04:25:07',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95111',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14084252233',	'+19162627163',	'+14084252233',	NULL,	NULL,	NULL,	NULL,	'SAN JOSE',	'CA',	'CAcd44d5942fcf1f974475a1caf95f72ba',	'+14062509831',	'completed',	12,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REebdcd76155e6cbed81c07719b84402e8',	0,	0,	'',	''),
(123,	'CAe88dc3991f8a6e92047465341db56751',	'',	'2016-03-23 16:48:31',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'92374',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19097481313',	'+19162627163',	'+19097481313',	NULL,	NULL,	NULL,	NULL,	'REDLANDS',	'CA',	'CAe88dc3991f8a6e92047465341db56751',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(124,	'CA6ac7a1941589bcdf26a06c5547417cc0',	'',	'2016-03-23 22:33:30',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'91934',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16193639125',	'+19162627163',	'+16193639125',	NULL,	NULL,	NULL,	NULL,	'PINE VALLEY',	'CA',	'CA6ac7a1941589bcdf26a06c5547417cc0',	'+14062509831',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REdc1441e395a55b00361d732e0efa4aa7',	0,	0,	'',	''),
(125,	'CA1534b052f866a81db8fd21db0687ce42',	'',	'2016-03-23 22:33:39',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'91934',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16193639125',	'+14252338984',	'+16193639125',	NULL,	NULL,	NULL,	NULL,	'PINE VALLEY',	'CA',	'CA1534b052f866a81db8fd21db0687ce42',	'+14062509831',	'no-answer',	7,	NULL,	0,	0,	'',	''),
(126,	'CA15a12f5946dfb149bab1c11d479acc28',	'',	'2016-03-24 21:51:00',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'85210',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14803853956',	'+14252338984',	'+14803853956',	NULL,	NULL,	NULL,	NULL,	'PHOENIX',	'AZ',	'CA15a12f5946dfb149bab1c11d479acc28',	'+14062509831',	'completed',	44,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe23ac41828294632e60dc11180132b71',	0,	0,	'',	''),
(127,	'CA1818e72886204735e6b26180c68b2adb',	'',	'2016-03-24 22:56:51',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747111',	'+14252338984',	'+12096747111',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CA1818e72886204735e6b26180c68b2adb',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(128,	'CAee0464f972a128806ad512d23ed82215',	'',	'2016-03-25 15:04:21',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'30260',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14049616136',	'+19162627163',	'+14049616136',	NULL,	NULL,	NULL,	NULL,	'ATLANTA',	'GA',	'CAee0464f972a128806ad512d23ed82215',	'+14062509831',	'completed',	47,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe001724d04c62e7c1b8be952e5452e9e',	0,	0,	'',	''),
(129,	'CA41f957d2e5f3d6652b18641adb953e6e',	'',	'2016-03-25 20:27:09',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19166340632',	'+19162627163',	'+19166340632',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA41f957d2e5f3d6652b18641adb953e6e',	'+14062509831',	'completed',	50,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE1fcdb470937a93ad99a42f00747e9d5c',	0,	0,	'',	''),
(130,	'CAd52de332964216256ee297b4e07c8197',	'',	'2016-03-25 20:29:04',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'92614',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14242177867',	'+19162627163',	'+14242177867',	NULL,	NULL,	NULL,	NULL,	'IRVINE',	'CA',	'CAd52de332964216256ee297b4e07c8197',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(131,	'CA58f1cc275296307e91c86073add5aa1f',	'',	'2016-03-25 21:27:00',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'92614',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14242177867',	'+14252338984',	'+14242177867',	NULL,	NULL,	NULL,	NULL,	'IRVINE',	'CA',	'CA58f1cc275296307e91c86073add5aa1f',	'+14062509831',	'completed',	2,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REfba59f4e5c15ee33e017d919e99c8d81',	0,	0,	'',	''),
(132,	'CA7826eb993003951c05397e407efebfa1',	'',	'2016-03-28 18:09:27',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'93307',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16617481986',	'+16612439350',	'+16617481986',	NULL,	NULL,	NULL,	NULL,	'BAKERSFIELD',	'CA',	'CA7826eb993003951c05397e407efebfa1',	'+14062509831',	'completed',	49,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE58c64359fc9b4b3503cf71929241f6fd',	0,	0,	'',	''),
(133,	'CAc84997ab35900b3fcc3b120abe7a3acf',	'',	'2016-03-28 21:36:00',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16692384350',	'+19162627163',	'+16692384350',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAc84997ab35900b3fcc3b120abe7a3acf',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(134,	'CAcf6a751571517f4edb4b1bcd8894872f',	'',	'2016-03-28 22:40:42',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16692384350',	'+14252338984',	'+16692384350',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAcf6a751571517f4edb4b1bcd8894872f',	'+14062509831',	'completed',	2,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE61cec6f9f2e2cd1917a4c373555092a4',	0,	0,	'',	''),
(135,	'CA574f65d6ff18fba9fe90643217c46ae0',	'',	'2016-03-29 16:18:17',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'63043',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13145698822',	'+19162627163',	'+13145698822',	NULL,	NULL,	NULL,	NULL,	'LADUE',	'MO',	'CA574f65d6ff18fba9fe90643217c46ae0',	'+14062509831',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE8070edef2ca7e03d00e327e1f990daef',	0,	0,	'',	''),
(136,	'CA20ad3c88abdc8140c846dbd75de66180',	'',	'2016-03-29 17:37:20',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17542012511',	'+19513741928',	'+17542012511',	NULL,	NULL,	NULL,	NULL,	'',	'FL',	'CA20ad3c88abdc8140c846dbd75de66180',	'+14062509831',	'completed',	15,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE213990e3a75a46f359030df38a8994f2',	0,	0,	'',	''),
(137,	'CA82dd40e7ca000811a967a047bfd3ea8c',	'',	'2016-03-29 18:11:08',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17542012511',	'+19513741928',	'+17542012511',	NULL,	NULL,	NULL,	NULL,	'',	'FL',	'CA82dd40e7ca000811a967a047bfd3ea8c',	'+14062509831',	'completed',	15,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE89a52e8763c1a1f4a131c81bc3f26103',	0,	0,	'',	''),
(138,	'CA7414643f28412f9e0faedf950dd0d662',	'',	'2016-03-29 19:13:28',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15106402620',	'+16612439350',	'+15106402620',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA7414643f28412f9e0faedf950dd0d662',	'+14062509831',	'completed',	40,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE121edb7fd1342174e09f89f8b0e11692',	0,	0,	'',	''),
(139,	'CAf8acfbee940cb8b64f0b1ebeebb0794a',	'',	'2016-03-29 22:21:26',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'94103',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16283336327',	'+19162627163',	'+16283336327',	NULL,	NULL,	NULL,	NULL,	'San Francisco',	'CA',	'CAf8acfbee940cb8b64f0b1ebeebb0794a',	'+14062509831',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc88439ce6ef66516eb13660444f98e47',	0,	0,	'',	''),
(140,	'CA92aa6fee7b65f0f47b18705bcd5ced28',	'',	'2016-03-29 22:45:52',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'94103',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16283336327',	'+14252338984',	'+16283336327',	NULL,	NULL,	NULL,	NULL,	'San Francisco',	'CA',	'CA92aa6fee7b65f0f47b18705bcd5ced28',	'+14062509831',	'completed',	1,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REeadbc2231bb979b290d0f316f366794e',	0,	0,	'',	''),
(141,	'CAf6d1f356bd54b6dc33b4a6aec6b1827e',	'',	'2016-03-30 22:20:11',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19167588637',	'+19162627163',	'+19167588637',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAf6d1f356bd54b6dc33b4a6aec6b1827e',	'+14062509831',	'completed',	1,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REbea9e8e3e0df56d511dde5a9954025c4',	0,	0,	'',	''),
(142,	'CAba63d9c37704a5ed719884939756cc16',	'',	'2016-03-30 22:59:33',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19167588637',	'+14252338984',	'+19167588637',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAba63d9c37704a5ed719884939756cc16',	'+14062509831',	'completed',	12,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf54549b12be996c5d50f5fbcb9206265',	0,	0,	'',	''),
(143,	'CAd4199b71e33c3a0c853f99c2cca5f33e',	'',	'2016-03-31 22:20:21',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16692384296',	'+19162627163',	'+16692384296',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAd4199b71e33c3a0c853f99c2cca5f33e',	'+14062509831',	'completed',	1,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE8156f47fe6f4b1d9751940fe48f54aed',	0,	0,	'',	''),
(144,	'CAbadd092ba788b5883de2fc812b581219',	'',	'2016-04-01 17:37:45',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15184171662',	'+19162627163',	'+15184171662',	NULL,	NULL,	NULL,	NULL,	'',	'NY',	'CAbadd092ba788b5883de2fc812b581219',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(145,	'CAa3c36d04d22d06cec27ca8b34c22a9f8',	'',	'2016-04-01 19:28:14',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'59903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14062509831',	'+16612439350',	'+14062509831',	NULL,	NULL,	NULL,	NULL,	'KALISPELL',	'MT',	'CAa3c36d04d22d06cec27ca8b34c22a9f8',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(146,	'CAb4a5169444bdc96d70d436f3d573433f',	'',	'2016-04-01 19:29:26',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'59601',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14068711391',	'+16612439350',	'+14068711391',	NULL,	NULL,	NULL,	NULL,	'HELENA',	'MT',	'CAb4a5169444bdc96d70d436f3d573433f',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(147,	'CAabcb5d953934290e17a8db8fdeeb8a10',	'',	'2016-04-01 19:30:30',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'59601',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14068711391',	'+16612439350',	'+14068711391',	NULL,	NULL,	NULL,	NULL,	'HELENA',	'MT',	'CAabcb5d953934290e17a8db8fdeeb8a10',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(148,	'CAc12f3578910ddd03b5ab333dd9eb60af',	'',	'2016-04-01 19:33:35',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'59601',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14068711391',	'+16612439350',	'+14068711391',	NULL,	NULL,	NULL,	NULL,	'HELENA',	'MT',	'CAc12f3578910ddd03b5ab333dd9eb60af',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(149,	'CA4daae6da7cc9ec9d774f62e995f6d28e',	'',	'2016-04-01 19:36:42',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'59601',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14068711391',	'+16612439350',	'+14068711391',	NULL,	NULL,	NULL,	NULL,	'HELENA',	'MT',	'CA4daae6da7cc9ec9d774f62e995f6d28e',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(150,	'CA6f997f49573c0808416048fc43f29166',	'',	'2016-04-01 19:37:09',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'59601',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14068711391',	'+16612439350',	'+14068711391',	NULL,	NULL,	NULL,	NULL,	'HELENA',	'MT',	'CA6f997f49573c0808416048fc43f29166',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(151,	'CAbd27591d67cc60df4cc3796c77160f3e',	'',	'2016-04-01 19:37:37',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'59601',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14068711391',	'+16612439350',	'+14068711391',	NULL,	NULL,	NULL,	NULL,	'HELENA',	'MT',	'CAbd27591d67cc60df4cc3796c77160f3e',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(152,	'CA5a99ac815410172aacf3f1a7bcd3834c',	'',	'2016-04-01 20:03:19',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'59601',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14068711391',	'+14252338984',	'+14068711391',	NULL,	NULL,	NULL,	NULL,	'HELENA',	'MT',	'CA5a99ac815410172aacf3f1a7bcd3834c',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(153,	'CA2ffe7aa6cb4c4a97b34468908e332502',	'',	'2016-04-01 20:58:54',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'33445',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15619084968',	'+16612439350',	'+15619084968',	NULL,	NULL,	NULL,	NULL,	'DELRAY BEACH',	'FL',	'CA2ffe7aa6cb4c4a97b34468908e332502',	'+14062509831',	'completed',	17,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd99c95f61ee73fa4f8639ca431c89b52',	0,	0,	'',	''),
(154,	'CA39dd01fc6c48704d0b5ce4706bfe1cb1',	'',	'2016-04-01 21:00:34',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'33445',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15619084968',	'+16612439350',	'+15619084968',	NULL,	NULL,	NULL,	NULL,	'DELRAY BEACH',	'FL',	'CA39dd01fc6c48704d0b5ce4706bfe1cb1',	'+14062509831',	'completed',	14,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE36973928d91329bf3d4161de1246d0b8',	0,	0,	'',	''),
(155,	'CA44b49c7e08b1d32817b5d348b6cdad12',	'',	'2016-04-01 21:04:25',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'33445',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15619084968',	'+16612439350',	'+15619084968',	NULL,	NULL,	NULL,	NULL,	'DELRAY BEACH',	'FL',	'CA44b49c7e08b1d32817b5d348b6cdad12',	'+14062509831',	'completed',	23,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4f1ac43351e7f43ddf2f40b7f9408d21',	0,	0,	'',	''),
(156,	'CA0c92568da155a51756bd9f12f0865bdf',	'',	'2016-04-01 21:47:29',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'59903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14062509831',	'+19162627163',	'+14062509831',	NULL,	NULL,	NULL,	NULL,	'KALISPELL',	'MT',	'CAd4cf6be8e0f9c00cc72c6da6d1485ad1',	'+14062509831',	'voicemail',	4,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3329d23d0f88b41bcfcd6f00358ffbec',	0,	0,	'',	''),
(157,	'CA0845a347d148bdfd3e1d7240354dc752',	'',	'2016-04-02 01:06:22',	'US',	'',	'CA',	'',	'US',	'59903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14062509831',	'+19513741928',	'+14062509831',	NULL,	NULL,	NULL,	NULL,	'KALISPELL',	'MT',	'CAfb7ea0176865e8a4c5f5ede430a8bc9d',	'+14062509831',	'voicemail',	26,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd16c88a3ad2f437e334767986a5c4537',	0,	0,	'',	''),
(158,	'CAe88c6d26ce36400b6a9b5c18bbd6e6cb',	'',	'2016-04-02 01:14:01',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'59601',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14068711391',	'+19162627163',	'+14068711391',	NULL,	NULL,	NULL,	NULL,	'HELENA',	'MT',	'CA711af4d739561ed11a0287c223b1238e',	'+14062509831',	'voicemail',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4718d062f254f971f421c66462ee122b',	0,	0,	'',	''),
(159,	'CAd7c2d3c2a0b074f3710f39ca9e79c51c',	'',	'2016-04-02 01:14:59',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'59601',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14068711391',	'+14252338984',	'+14068711391',	NULL,	NULL,	NULL,	NULL,	'HELENA',	'MT',	'CA8db2c00038dedd85b9420f0c5f8d040f',	'+14062509831',	'voicemail',	6,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4357703b088466bb37cdb0d0e72527dc',	0,	0,	'',	''),
(160,	'CAc16bead8283d85fc20703e0f8ade7207',	'',	'2016-04-02 01:15:50',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'59601',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14068711391',	'+16612439350',	'+14068711391',	NULL,	NULL,	NULL,	NULL,	'HELENA',	'MT',	'CA389de1f87eb5347cca0411b5a27f5f89',	'+14062509831',	'voicemail',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4988ca6ff4e54922e0d7933ee3a87082',	0,	0,	'',	''),
(161,	'CAc2e9b45d296b24545a72099463255cb1',	'',	'2016-04-02 01:16:34',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'59601',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14068711391',	'+16612439350',	'+14068711391',	NULL,	NULL,	NULL,	NULL,	'HELENA',	'MT',	'CAc2e9b45d296b24545a72099463255cb1',	'+14062509831',	'completed',	16,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE8558d97ff5d736d6c1f863f644377761',	0,	0,	'',	''),
(162,	'CA3b4823d2292097ebd3d3bba74c7a024a',	'',	'2016-04-02 01:17:13',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'59601',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14068711391',	'+14252338984',	'+14068711391',	NULL,	NULL,	NULL,	NULL,	'HELENA',	'MT',	'CA3b4823d2292097ebd3d3bba74c7a024a',	'+14062509831',	'completed',	15,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb5e8d5dddcb18d86c938efed66eb406e',	0,	0,	'',	''),
(163,	'CAf63c8b44898a6e1d6a9e28bc778d5415',	'',	'2016-04-02 01:18:03',	'US',	'',	'CA',	'',	'US',	'59601',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14068711391',	'+19513741928',	'+14068711391',	NULL,	NULL,	NULL,	NULL,	'HELENA',	'MT',	'CAf63c8b44898a6e1d6a9e28bc778d5415',	'+14062509831',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa19b4a4201c55d674387b25dcf3597bb',	0,	0,	'',	''),
(164,	'CAb20936b0be8c0675b900c1d59fb4dec8',	'',	'2016-04-02 01:18:40',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'59601',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14068711391',	'+19162627163',	'+14068711391',	NULL,	NULL,	NULL,	NULL,	'HELENA',	'MT',	'CAb20936b0be8c0675b900c1d59fb4dec8',	'+14062509831',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE99c05c9f2afc215af4fe21cacf976c0e',	0,	0,	'',	''),
(165,	'CA2ad6b4039ca6a40b8d3f91b0f21b4755',	'',	'2016-04-02 01:22:11',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'59601',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14068711391',	'+19162627163',	'+14068711391',	NULL,	NULL,	NULL,	NULL,	'HELENA',	'MT',	'CAdcdd84f06a622fcaa0b59a5062f5d18b',	'+14062509831',	'voicemail',	3,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf725c929af7b42d53e6a274d9b132564',	0,	0,	'',	''),
(166,	'CAdb67af654c9516a204ec6cd0d1caf4d1',	'',	'2016-04-04 16:23:24',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'91321',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16612997240',	'+16612439350',	'+16612997240',	NULL,	NULL,	NULL,	NULL,	'CANYON COUNTRY',	'CA',	'CA3f7b28a4914ea9c0d3527d9e9dd7ccc1',	'+14062509831',	'voicemail',	23,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf72bfab07aa5216e73da1d7dbb1f2b96',	0,	0,	'',	''),
(167,	'CAce598b0a3d0e6718e32584e3766f8764',	'',	'2016-04-04 22:21:05',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'91934',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16193639162',	'+19162627163',	'+16193639162',	NULL,	NULL,	NULL,	NULL,	'PINE VALLEY',	'CA',	'CAce598b0a3d0e6718e32584e3766f8764',	'+14062509831',	'completed',	12,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb0c546b7e53d04422a6699b7a2915c7f',	0,	0,	'',	''),
(168,	'CA9b432a175e3ec6c1b235f3850ecbece8',	'',	'2016-04-05 16:30:25',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95827',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19164389071',	'+19162627163',	'+19164389071',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CA18e598511315d9b03361dd8a2139fb64',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(169,	'CA1cf97248a8021702b52703e6a7b18762',	'',	'2016-04-05 18:50:13',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'98201',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+14252338984',	'+14253126074',	NULL,	NULL,	NULL,	NULL,	'EVERETT',	'WA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(170,	'CAdbbb7e11bc18d80b244a5971852dc7dc',	'',	'2016-04-05 20:11:10',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'94019',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16507133186',	'+14252338984',	'+16507133186',	NULL,	NULL,	NULL,	NULL,	'HALF MOON BAY',	'CA',	'CAdbbb7e11bc18d80b244a5971852dc7dc',	'+14062509831',	'completed',	12,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc88785d27abd20c52b2f183944fb407c',	0,	0,	'',	''),
(171,	'CA03bcd09f697e63124f02f17c3d8ed28c',	'',	'2016-04-05 22:57:50',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19167588684',	'+19162627163',	'+19167588684',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAad8a80c891ab928b21d564acbd044dc0',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(172,	'CA63a28b4852eac90cc8877d9313f15bd0',	'',	'2016-04-06 22:14:48',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'94103',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16283336463',	'+19162627163',	'+16283336463',	NULL,	NULL,	NULL,	NULL,	'San Francisco',	'CA',	'CA63a28b4852eac90cc8877d9313f15bd0',	'+14062509831',	'completed',	2,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE8ae2d182723b0cd8f676f62a52a6321a',	0,	0,	'',	''),
(173,	'CA56ee626a1e3b538e291b858e6619ce43',	'',	'2016-04-06 22:45:37',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19165812635',	'+19162627163',	'+19165812635',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAb8ce34fbf028d72001c0426428c670c3',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(174,	'CAd544da7dcfccd8bb2ed8138cb8e5dad9',	'',	'2016-04-08 22:39:04',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19167588684',	'+19162627163',	'+19167588684',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAd544da7dcfccd8bb2ed8138cb8e5dad9',	'+14062509831',	'completed',	2,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3335dcd8edad6414c97421f08221d031',	0,	0,	'',	''),
(175,	'CAeda0715c3a066aea0a12bc7c6ae8975d',	'',	'2016-04-11 18:11:52',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'92835',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17148885660',	'+14252338984',	'+17148885660',	NULL,	NULL,	NULL,	NULL,	'FULLERTON',	'CA',	'CAeda0715c3a066aea0a12bc7c6ae8975d',	'+14062509831',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REfc1b4a86007a0332acd49afe590031b5',	0,	0,	'',	''),
(176,	'CA921ac8d2b503eb2d696cac36736682d2',	'',	'2016-04-11 22:35:07',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747039',	'+19162627163',	'+12096747039',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CA921ac8d2b503eb2d696cac36736682d2',	'+14062509831',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf7de45526011a7004f1b0c063f9afef4',	0,	0,	'',	''),
(177,	'CAb93ae39d84d14fe4f7ab37e4a4b99d1f',	'',	'2016-04-12 18:49:52',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'90017',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14242064551',	'+14252338984',	'+14242064551',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CAb93ae39d84d14fe4f7ab37e4a4b99d1f',	'+14062509831',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE18d37777047d815228470d2fbe18fe0e',	0,	0,	'',	''),
(178,	'CA65abbc7f2d0ae78b14399ec66a2fe76d',	'',	'2016-04-12 22:39:30',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15304887031',	'+19162627163',	'+15304887031',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAe91d2be27f1f7f62e08e690cb9ec27bd',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(179,	'CA35f10adaf0ffdfdfbe1bbcbe980aaf9b',	'',	'2016-04-12 22:54:55',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'90017',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14242064551',	'+19162627163',	'+14242064551',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA6c0a18263ff885e8704751b3e0191c15',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(180,	'CA5c2c18817e5cec263722f490a5d4d71c',	'',	'2016-04-13 15:41:32',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18582390391',	'+19162627163',	'+18582390391',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA5c2c18817e5cec263722f490a5d4d71c',	'+14062509831',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE2e5ba1b2dd03ec910eafead9163c218a',	0,	0,	'',	''),
(181,	'CA8ecd1eb61373c4935330350524db942f',	'',	'2016-04-13 17:42:33',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'93960',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18312233188',	'+19162627163',	'+18312233188',	NULL,	NULL,	NULL,	NULL,	'SOLEDAD',	'CA',	'CAbfe091e94ed7abf20412749f6fd9d004',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(182,	'CAf680609ea74e98396804ab4c0b6571b4',	'',	'2016-04-13 18:18:58',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16469309547',	'+14252338984',	'+16469309547',	NULL,	NULL,	NULL,	NULL,	'',	'NY',	'CA8cef415e699b351ef7b724698e36c1d8',	'+14062509831',	'voicemail',	26,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb5567f0ab8af4dbd645b79e0e5d1fd0a',	0,	0,	'',	''),
(183,	'CAd57a052353bc908ed6bec83f5e07fc3f',	'',	'2016-04-13 18:56:15',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'92704',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17149554611',	'+19162627163',	'+17149554611',	NULL,	NULL,	NULL,	NULL,	'SANTA ANA',	'CA',	'CAd57a052353bc908ed6bec83f5e07fc3f',	'+14062509831',	'completed',	1,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE7463d7b05c662dcb93b29c894a654d87',	0,	0,	'',	''),
(184,	'CAb31def814e64d3f331d976c069f3dc86',	'',	'2016-04-13 21:14:28',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95816',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19169039423',	'+19162627163',	'+19169039423',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CAb31def814e64d3f331d976c069f3dc86',	'+14062509831',	'completed',	17,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb7f92d444850cbd2b2c23b9c81b2efde',	0,	0,	'',	''),
(185,	'CAa2beeb2131ec341ffb1dd2abf1290520',	'',	'2016-04-13 23:00:42',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16692384302',	'+19162627163',	'+16692384302',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAa2beeb2131ec341ffb1dd2abf1290520',	'+14062509831',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REce5fce8c854875a6ec116f1970be8a0a',	0,	0,	'',	''),
(186,	'CAe3d9c77f83a735b99e704a7851d7b136',	'',	'2016-04-14 16:40:03',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95126',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19162627163',	'+14082605665',	NULL,	NULL,	NULL,	NULL,	'SAN JOSE',	'CA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(187,	'CAa921475a942c1689d1950038a1dfe2f9',	'',	'2016-04-14 22:03:19',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19167588670',	'+19162627163',	'+19167588670',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA82b16c93eca8cb80cf41dc233ee6869e',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(188,	'CAdb24aebace949a395c95fa1a3e5fa64f',	'',	'2016-04-15 00:40:59',	'US',	'72704',	'AR',	'FAYETTEVILLE',	'US',	'72762',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14797514820',	'+14793160852',	'+14797514820',	NULL,	NULL,	NULL,	NULL,	'SPRINGDALE',	'AR',	'CAdb24aebace949a395c95fa1a3e5fa64f',	'+14793811531',	'completed',	19,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REbe3df8ac154d82ccf10b31815d951801',	0,	0,	'',	''),
(189,	'CA168ca085a9ac0c4e973f60487d68432b',	'',	'2016-04-15 23:15:45',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'91040',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18184461172',	'+14252338984',	'+18184461172',	NULL,	NULL,	NULL,	NULL,	'SUNLAND',	'CA',	'CA168ca085a9ac0c4e973f60487d68432b',	'+14062509831',	'completed',	14,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE7dc0a49a424161ee57dcc1f2ca00757c',	0,	0,	'',	''),
(190,	'CAdaedc7ff7b18d2c901f6abf307ffcce7',	'',	'2016-04-15 23:33:14',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'91040',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18184461172',	'+19162627163',	'+18184461172',	NULL,	NULL,	NULL,	NULL,	'SUNLAND',	'CA',	'CAdaedc7ff7b18d2c901f6abf307ffcce7',	'+14062509831',	'completed',	14,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE5540ea7fadf16bd28c221936f80022c5',	0,	0,	'',	''),
(191,	'CAbf031e62e7b415d8e2addfd603f8b8d4',	'',	'2016-04-18 16:09:18',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'94108',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14082170872',	'+14252338984',	'+14082170872',	NULL,	NULL,	NULL,	NULL,	'SAN FRANCISCO',	'CA',	'CAbf031e62e7b415d8e2addfd603f8b8d4',	'+14062509831',	'completed',	14,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE57601d86bc311d8f2d2e3666427cdbfe',	0,	0,	'',	''),
(192,	'CA6f6a057a2f922e97d332195667f56f17',	'',	'2016-04-18 17:26:08',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'94103',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16283336472',	'+19162627163',	'+16283336472',	NULL,	NULL,	NULL,	NULL,	'San Francisco',	'CA',	'CA5e1dc0825b184c32726c4be4d39d5ccc',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(193,	'CAe2264400101c74e48eb61fa0020c158f',	'',	'2016-04-18 19:47:03',	'US',	'',	'CA',	'',	'US',	'92084',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17603308202',	'+19513741928',	'+17603308202',	NULL,	NULL,	NULL,	NULL,	'VISTA',	'CA',	'CAe2264400101c74e48eb61fa0020c158f',	'+14062509831',	'completed',	35,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE7aef8ef1578ec7b4f7b61d2d0d360449',	0,	0,	'',	''),
(194,	'CA49b43302d81730aec6966a64430e5053',	'',	'2016-04-18 23:33:35',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'94108',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14082170872',	'+19162627163',	'+14082170872',	NULL,	NULL,	NULL,	NULL,	'SAN FRANCISCO',	'CA',	'CA49b43302d81730aec6966a64430e5053',	'+14062509831',	'completed',	14,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE9613dfd8cd552316ef611bb26957bd7a',	0,	0,	'',	''),
(195,	'CA48a6e71aac225b8287d3185574c7212e',	'',	'2016-04-19 22:29:15',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747011',	'+19162627163',	'+12096747011',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CA48a6e71aac225b8287d3185574c7212e',	'+14062509831',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb2d13d177e5b095eeb23abcce5b076f8',	0,	0,	'',	''),
(196,	'CA2378a3bf72399eea8819f7deb06f3aec',	'',	'2016-04-19 23:18:33',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'92118',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16193199377',	'+14252338984',	'+16193199377',	NULL,	NULL,	NULL,	NULL,	'CORONADO',	'CA',	'CA2378a3bf72399eea8819f7deb06f3aec',	'+14062509831',	'completed',	14,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa81b6454a97c0ba0904f2e827fa90c27',	0,	0,	'',	''),
(197,	'CA46c3598f45cd05f5568e4a3d4708f208',	'',	'2016-04-19 23:35:19',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'92118',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16193199377',	'+19162627163',	'+16193199377',	NULL,	NULL,	NULL,	NULL,	'CORONADO',	'CA',	'CA46c3598f45cd05f5568e4a3d4708f208',	'+14062509831',	'completed',	12,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE8960572f3ee966d9d224741cf601c75f',	0,	0,	'',	''),
(198,	'CAb923c9b5d20a15ecd37cf54f482550fc',	'',	'2016-04-20 20:39:21',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'94103',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16283336316',	'+19162627163',	'+16283336316',	NULL,	NULL,	NULL,	NULL,	'San Francisco',	'CA',	'CAb923c9b5d20a15ecd37cf54f482550fc',	'+14062509831',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE6bb8121c314b464d13535c89284441d6',	0,	0,	'',	''),
(199,	'CA82fc91ab5c473587aaeefb63a53afaee',	'',	'2016-04-20 23:03:53',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19093453540',	'+19162627163',	'+19093453540',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA82fc91ab5c473587aaeefb63a53afaee',	'+14062509831',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE752194bc35194dce2eae464cb6820c68',	0,	0,	'',	''),
(200,	'CA4cbc2bbae449f96add5cf3d04a249970',	'',	'2016-04-21 16:46:06',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'94019',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16507133186',	'+14252338984',	'+16507133186',	NULL,	NULL,	NULL,	NULL,	'HALF MOON BAY',	'CA',	'CA292c831d2c3caf3d1543fb1310de94b6',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(201,	'CA8748307b7ac9dd82e033a4682d6b9212',	'',	'2016-04-21 21:47:45',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16692384341',	'+19162627163',	'+16692384341',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAa931acde586c5d0c566497f07993b7b9',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(202,	'CAc0b06fdf4c44d33fc7c3166b2b358478',	'',	'2016-04-21 22:55:20',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'91040',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18184461049',	'+19162627163',	'+18184461049',	NULL,	NULL,	NULL,	NULL,	'SUNLAND',	'CA',	'CAc0b06fdf4c44d33fc7c3166b2b358478',	'+14062509831',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE6c141c0e40d28310dab468e667101184',	0,	0,	'',	''),
(203,	'CAa37623760ff4411e478552eb4de82c52',	'',	'2016-04-21 23:35:01',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'91040',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18184461049',	'+14252338984',	'+18184461049',	NULL,	NULL,	NULL,	NULL,	'SUNLAND',	'CA',	'CAa37623760ff4411e478552eb4de82c52',	'+14062509831',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE7da0a616caf7b8caaf097d0358605863',	0,	0,	'',	''),
(204,	'CA85da7bcf5af6db08790d7c40007be374',	'',	'2016-04-22 18:58:43',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'90017',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14242034299',	'+19162627163',	'+14242034299',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA155dcd4ffe7d9a88fdc16413ee46352c',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(205,	'CA6f002a5fd33f917c03f56191ee0710c5',	'',	'2016-04-22 19:04:20',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'90017',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14242034299',	'+19162627163',	'+14242034299',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA35ae4bfe4fb1c43e7c494364e94f307f',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(206,	'CA875682743969bd03c287d5505fd0ffb2',	'',	'2016-04-22 21:22:32',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19513741928',	'+13852491870',	NULL,	NULL,	NULL,	NULL,	'SALT LAKE CITY',	'UT',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(207,	'CA1e9dc0ed1ef98e52b3d134101f320e0c',	'',	'2016-04-22 21:49:47',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'90017',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14242034299',	'+14252338984',	'+14242034299',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA1b0a753e5ffad2190211519c7c600d37',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(208,	'CA71896e64a94418b61f04c7dc67309bee',	'',	'2016-04-22 22:59:43',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'93305',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16615780655',	'+16612439350',	'+16615780655',	NULL,	NULL,	NULL,	NULL,	'BAKERSFIELD',	'CA',	'CA71896e64a94418b61f04c7dc67309bee',	'+14062509831',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe36c492e5ee2df9cd935ca627b8b25a7',	0,	0,	'',	''),
(209,	'CA1c7c0738398acf5a07643bcaea107118',	'',	'2016-04-22 23:04:17',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'90017',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14242034299',	'+14252338984',	'+14242034299',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA1c7c0738398acf5a07643bcaea107118',	'+14062509831',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REde84997c9368bd0c338de95e97750105',	0,	0,	'',	''),
(210,	'CAe0c356015f690f70330105352d982107',	'',	'2016-04-25 15:19:48',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'94403',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16502886913',	'+19162627163',	'+16502886913',	NULL,	NULL,	NULL,	NULL,	'SAN MATEO',	'CA',	'CAe0c356015f690f70330105352d982107',	'+14062509831',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE904da4f3c0f8eb9bca71be47390fac97',	0,	0,	'',	''),
(211,	'CAd2a1bd442a7561a427a9b4861f93abe1',	'',	'2016-04-26 18:02:24',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'91040',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18184461032',	'+14252338984',	'+18184461032',	NULL,	NULL,	NULL,	NULL,	'SUNLAND',	'CA',	'CAd2a1bd442a7561a427a9b4861f93abe1',	'+14062509831',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc5954f35a3240774ffbd04693c21b5d1',	0,	0,	'',	''),
(212,	'CA18a6d5e0ee7be81721ed87de6b988ee9',	'',	'2016-04-26 18:46:17',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95834',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19169251124',	'+19162627163',	'+19169251124',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CA18a6d5e0ee7be81721ed87de6b988ee9',	'+14062509831',	'completed',	49,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc8ce05d377f1cbe615062e445a2f6152',	0,	0,	'',	''),
(213,	'CA787513f1d6e7f48fdd65ed3ce90aac33',	'',	'2016-04-26 21:19:18',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'91040',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18184461032',	'+19162627163',	'+18184461032',	NULL,	NULL,	NULL,	NULL,	'SUNLAND',	'CA',	'CA787513f1d6e7f48fdd65ed3ce90aac33',	'+14062509831',	'completed',	4,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE5982659e338326a7dd72b32267fbcdba',	0,	0,	'',	''),
(214,	'CA29248ef3771546a11e11fddd6f1fd01c',	'',	'2016-04-26 21:25:58',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'32773',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13218327622',	'+19162627163',	'+13218327622',	NULL,	NULL,	NULL,	NULL,	'SANFORD',	'FL',	'CA29248ef3771546a11e11fddd6f1fd01c',	'+14062509831',	'completed',	14,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE7b29c3e5cb88d4338c0bd97beb8fcb96',	0,	0,	'',	''),
(215,	'CAf6027f1286d97d6dc2f6b109d4e49051',	'',	'2016-04-26 22:32:37',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19167588612',	'+19162627163',	'+19167588612',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAf6027f1286d97d6dc2f6b109d4e49051',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(216,	'CA858ef45faff0bebfce1a3f503e73ad81',	'',	'2016-04-27 17:48:58',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95628',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19168600135',	'+19162627163',	'+19168600135',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CA858ef45faff0bebfce1a3f503e73ad81',	'+14062509831',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3f7b29422d8b0962b1838789337b62bd',	0,	0,	'',	''),
(217,	'CA5f1c2e95b0f1188cb61b64fd51f3b46f',	'',	'2016-04-27 18:30:05',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16692384325',	'+14252338984',	'+16692384325',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA45570891a2f2c2347754740f17bdaf70',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(218,	'CAf2e9ae5cdfb6607642ce95dc86ad646c',	'',	'2016-04-27 20:57:14',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16692384325',	'+19162627163',	'+16692384325',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA72afa069a3754ad348ba60d15939a81b',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(219,	'CA7367ed85a30cb75bf77ae8a2924a4358',	'',	'2016-04-28 17:48:40',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95628',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19168600135',	'+19162627163',	'+19168600135',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CAa7f77e0943f77938cbcbb40af0c1204f',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(220,	'CA8dc50de63b6e147038420abbfd22d709',	'',	'2016-04-28 21:55:36',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'90017',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17606918630',	'+16612439350',	'+17606918630',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA09bbef67d31d81d1782f1cb02929df6e',	'+14062509831',	'voicemail',	19,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE164e8122d47b70d36ad69dcd95691de6',	0,	0,	'',	''),
(221,	'CA80608551ee9b1c0cb9bf76b0098aaa55',	'',	'2016-04-28 22:15:11',	'US',	'',	'CA',	'',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747071',	'+19513741928',	'+12096747071',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CA1bbb7ad192c944f01ae5ffcfd4c3d2d7',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(222,	'CA53030ff77ae8fc3ef747f9892f531c6e',	'',	'2016-04-28 23:23:35',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16193576113',	'+19513741928',	'+16193576113',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA53030ff77ae8fc3ef747f9892f531c6e',	'+14062509831',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE7e08e022b1b9cdf17768971dc0b50127',	0,	0,	'',	''),
(223,	'CA8c397c940bf74fe637514c3f09e2c764',	'',	'2016-04-28 23:23:39',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16193576113',	'+14252338984',	'+16193576113',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA8c397c940bf74fe637514c3f09e2c764',	'+14062509831',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE07fec3ed45bb2f97c7eca3bc98a4b8e7',	0,	0,	'',	''),
(224,	'CAe9188fe73fb8eef0152b24ba384b0892',	'',	'2016-04-29 17:35:33',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'91040',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18184461185',	'+14252338984',	'+18184461185',	NULL,	NULL,	NULL,	NULL,	'SUNLAND',	'CA',	'CAe50a6be8729abdff389f50ee228b7b35',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(225,	'CAd70a2357e595b1151764b7f438b379c8',	'',	'2016-04-29 19:20:36',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'90017',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17606918630',	'+16612439350',	'+17606918630',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CAd70a2357e595b1151764b7f438b379c8',	'+14062509831',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa00c8eab89677296b8f2b6926af899cc',	0,	0,	'',	''),
(226,	'CAd0df2e97faaf901c0039b5ba9d929d5f',	'',	'2016-04-29 20:19:56',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19167588619',	'+19513741928',	'+19167588619',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAd0df2e97faaf901c0039b5ba9d929d5f',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(227,	'CA337f61ec2987e669d4bfe1e94cf766cf',	'',	'2016-04-29 20:42:12',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19167588619',	'+19162627163',	'+19167588619',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAa1d3f5e4c32a09165649d7b032fbe607',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(228,	'CAe47711204e30eaabd87a7a6b03a347be',	'',	'2016-04-29 22:55:51',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'90017',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18053015277',	'+19162627163',	'+18053015277',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CAe47711204e30eaabd87a7a6b03a347be',	'+14062509831',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb6848623a59def825b2de4b4c9a3cb1f',	0,	0,	'',	''),
(229,	'CA2d0616ecfe79f68f23e27b14627d71d1',	'',	'2016-04-29 23:04:00',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'90017',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18053015277',	'+14252338984',	'+18053015277',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA830d4651dc26032e12011618e91b30ea',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(230,	'CA772aff16bc8aa229e5c037975c697aeb',	'',	'2016-04-30 16:50:13',	'US',	'',	'CA',	'',	'US',	'43821',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19513741928',	'+17405214546',	NULL,	NULL,	NULL,	NULL,	'DRESDEN',	'OH',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(231,	'CA03e712cf651214db1a65d63b0075570a',	'',	'2016-05-02 22:21:46',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'91934',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16193639165',	'+19162627163',	'+16193639165',	NULL,	NULL,	NULL,	NULL,	'PINE VALLEY',	'CA',	'CAe3b90dbca8bf50606aef5a2e44269b45',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(232,	'CAe74db926b23fa2b963cedef606a4659d',	'',	'2016-05-02 22:30:24',	'US',	'',	'CA',	'',	'US',	'91934',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16193639165',	'+19513741928',	'+16193639165',	NULL,	NULL,	NULL,	NULL,	'PINE VALLEY',	'CA',	'CA87e445c1b208af174c9b202b0960d2d4',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(233,	'CA60df78b02d27660441864926f2d0b2dc',	'',	'2016-05-02 23:15:30',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'94107',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14084714296',	'+19162627163',	'+14084714296',	NULL,	NULL,	NULL,	NULL,	'SAN FRANCISCO',	'CA',	'CA60df78b02d27660441864926f2d0b2dc',	'+14062509831',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe82dac1b15211820c1078f653e278053',	0,	0,	'',	''),
(234,	'CAddf5333cc65bb7c65e97a193bfcc83bd',	'',	'2016-05-03 15:29:02',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'82834',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13072176267',	'+16612439350',	'+13072176267',	NULL,	NULL,	NULL,	NULL,	'BUFFALO',	'WY',	'CA4d00e44c03e4700837152f618ddb4839',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(235,	'CAdd6ef079ebcead5a9873fc2111b516f2',	'',	'2016-05-03 15:29:04',	'US',	'',	'CA',	'',	'US',	'39601',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16017484003',	'+19513741928',	'+16017484003',	NULL,	NULL,	NULL,	NULL,	'BROOKHAVEN',	'MS',	'CAdd6ef079ebcead5a9873fc2111b516f2',	'+14062509831',	'completed',	2,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REabe7d270bbfe5d4f0c0663eace03aec1',	0,	0,	'',	''),
(236,	'CA42f79d335371cc20eb4e0fc7ce328597',	'',	'2016-05-03 16:33:01',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'39601',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16017484003',	'+19162627163',	'+16017484003',	NULL,	NULL,	NULL,	NULL,	'BROOKHAVEN',	'MS',	'CA2e8b346a914b69bd9f002fd56e87bcc4',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(237,	'CA3334a3b7b97022b3cdd7303c3aa1494d',	'',	'2016-05-03 21:29:14',	'US',	'',	'CA',	'',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747063',	'+19513741928',	'+12096747063',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CAc0c68a241090f5a2ad8331666883a8ce',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(238,	'CA323219ea0e2d58617914df3368017d5b',	'',	'2016-05-03 21:48:31',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747063',	'+19162627163',	'+12096747063',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CA323219ea0e2d58617914df3368017d5b',	'+14062509831',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE8b49e831a785a346b79b388b5fe311ab',	0,	0,	'',	''),
(239,	'CA38d4de95357c9cd24912c4e38d43710f',	'',	'2016-05-04 21:06:44',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'76028',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18172930035',	'+16612439350',	'+18172930035',	NULL,	NULL,	NULL,	NULL,	'FORT WORTH',	'TX',	'CA50d2a1dcba14d796db80263f82f0b204',	'+14062509831',	'voicemail',	3,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE93d1f15ba04df95a421811e51b01cf01',	0,	0,	'',	''),
(240,	'CAa6821a0f8d436ae082990eaf87af40a0',	'',	'2016-05-04 22:42:34',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'94103',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16283336441',	'+19162627163',	'+16283336441',	NULL,	NULL,	NULL,	NULL,	'San Francisco',	'CA',	'CAa6821a0f8d436ae082990eaf87af40a0',	'+14062509831',	'completed',	6,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REcad80bf00a526e3942ec1d4f641535bd',	0,	0,	'',	''),
(241,	'CA5263464f8f8b829aa454d520b4e9b9d9',	'',	'2016-05-05 22:30:33',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95113',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17077066217',	'+19162627163',	'+17077066217',	NULL,	NULL,	NULL,	NULL,	'SAN JOSE',	'CA',	'CA5263464f8f8b829aa454d520b4e9b9d9',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(242,	'CA8e5e887f3c90fbb098ccd13c465f5b0c',	'',	'2016-05-06 21:29:24',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747094',	'+19162627163',	'+12096747094',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CA8e5e887f3c90fbb098ccd13c465f5b0c',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(243,	'CA36565c08314a458589515eb4e2cf3136',	'',	'2016-05-07 22:00:37',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'54727',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17158280033',	'+14252338984',	'+17158280033',	NULL,	NULL,	NULL,	NULL,	'EAU CLAIRE',	'WI',	'CA36565c08314a458589515eb4e2cf3136',	'+14062509831',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REbb79e4ab001f3985f811fc71f1eea15f',	0,	0,	'',	''),
(244,	'CA1f02a5d3bbd8d45e0e14e308e30d185e',	'',	'2016-05-09 17:29:49',	'US',	'95822',	'CA',	'SACRAMENTO',	'ST',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+2395806023',	'+19162627163',	'+2395806023',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA1f02a5d3bbd8d45e0e14e308e30d185e',	'+14062509831',	'no-answer',	6,	NULL,	0,	0,	'',	''),
(245,	'CA7e51a5aa18de0ac49d8f9fffe3258606',	'',	'2016-05-09 19:12:54',	'US',	'',	'CA',	'',	'US',	'92614',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19097639338',	'+19513741928',	'+19097639338',	NULL,	NULL,	NULL,	NULL,	'IRVINE',	'CA',	'CA7e51a5aa18de0ac49d8f9fffe3258606',	'+14062509831',	'completed',	12,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE533885a65ed28100ab525e1aacb4904a',	0,	0,	'',	''),
(246,	'CAa5c0965e9b3c67d2479e7046710aad20',	'',	'2016-05-09 22:20:38',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95842',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19166008129',	'+19162627163',	'+19166008129',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CAa5c0965e9b3c67d2479e7046710aad20',	'+14062509831',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE280d1b5071f83c259ea68cd081518857',	0,	0,	'',	''),
(247,	'CA64c31ac07583777cbdaa6e1fbd2b1d37',	'',	'2016-06-12 16:02:29',	'US',	'59105',	'MT',	'BILLINGS',	'US',	'59903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14062509831',	'+14062151971',	'+14062509831',	NULL,	NULL,	NULL,	NULL,	'KALISPELL',	'MT',	'CA64c31ac07583777cbdaa6e1fbd2b1d37',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(248,	'CAdba84f2fd382e4d44a5bb1481341c212',	'',	'2016-06-12 16:09:17',	'US',	'59105',	'MT',	'BILLINGS',	'US',	'59601',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14068711391',	'+14062151971',	'+14068711391',	NULL,	NULL,	NULL,	NULL,	'HELENA',	'MT',	'CAdba84f2fd382e4d44a5bb1481341c212',	'+14062509831',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE95250fdd767c249713f87b54c7ac889c',	0,	0,	'',	''),
(249,	'CAe59b1e37b5827d11eaf3a12f3a5d14d7',	'',	'2016-06-12 17:11:24',	'US',	'59105',	'MT',	'BILLINGS',	'US',	'59903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14062509831',	'+14062151971',	'+14062509831',	NULL,	NULL,	NULL,	NULL,	'KALISPELL',	'MT',	'CAe59b1e37b5827d11eaf3a12f3a5d14d7',	'+14062509831',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE5bdac231e02b063ee287e3030aa0bbb0',	0,	0,	'',	''),
(250,	'CA4914c730d09c1dae29d12e64a0ed0b47',	'',	'2016-06-12 17:12:07',	'US',	'59105',	'MT',	'BILLINGS',	'US',	'59903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14062509831',	'+14062151971',	'+14062509831',	NULL,	NULL,	NULL,	NULL,	'KALISPELL',	'MT',	'CA4914c730d09c1dae29d12e64a0ed0b47',	'+14062509831',	'completed',	3,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc866289c50fee7b480d0b3f66d464785',	0,	0,	'',	''),
(251,	'CA7191cdcaccca29576f2cf854e7d84c6a',	'',	'2016-06-12 17:12:55',	'US',	'59105',	'MT',	'BILLINGS',	'US',	'59903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14062509831',	'+14062151971',	'+14062509831',	NULL,	NULL,	NULL,	NULL,	'KALISPELL',	'MT',	'CA7191cdcaccca29576f2cf854e7d84c6a',	'+14062509831',	'completed',	12,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4a83a61be74bc84c92f1d117d0b841a1',	0,	0,	'',	''),
(252,	'CA82772b18f4d5eb82b97ebc1a94b9b942',	'',	'2016-06-12 17:13:27',	'US',	'59105',	'MT',	'BILLINGS',	'US',	'59903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14062509831',	'+14062151971',	'+14062509831',	NULL,	NULL,	NULL,	NULL,	'KALISPELL',	'MT',	'CA82772b18f4d5eb82b97ebc1a94b9b942',	'+14062509831',	'completed',	5190,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REacf50236a1d74187876ffd2739434fb8',	0,	0,	'',	''),
(253,	'CA53b7f9afecd417b6c81dea5138887846',	'',	'2016-06-13 18:18:15',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19162627163',	'+12096747110',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(254,	'CA36d3084a9878589964fc9deedbdecdce',	'',	'2016-06-13 19:03:08',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'92614',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17142032544',	'+16612439350',	'+17142032544',	NULL,	NULL,	NULL,	NULL,	'IRVINE',	'CA',	'CA36d3084a9878589964fc9deedbdecdce',	'+14062509831',	'completed',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REcf2ba7d32390762185913d8f585cc472',	0,	0,	'',	''),
(255,	'CA10c0eb97063e4495a9c6b0342aa1ced9',	'',	'2016-06-13 20:43:28',	'US',	'',	'CA',	'',	'US',	'90017',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17606918368',	'+19513741928',	'+17606918368',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA10c0eb97063e4495a9c6b0342aa1ced9',	'+14062509831',	'completed',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE496abdaf045ef01f1c0bd35ce762fee9',	0,	0,	'',	''),
(256,	'CAf897bc4f24ed5db0e53a48003fe52ab3',	'',	'2016-06-13 21:58:05',	'US',	'',	'CA',	'',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747110',	'+19513741928',	'+12096747110',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CAf897bc4f24ed5db0e53a48003fe52ab3',	'+14062509831',	'completed',	4,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc4e74ad35edc148d0cc998ec4ff50dab',	0,	0,	'',	''),
(257,	'CA323dbc23756fae08187cdb03c4aa7d25',	'',	'2016-06-13 22:02:05',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'92123',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16196846214',	'+14252338984',	'+16196846214',	NULL,	NULL,	NULL,	NULL,	'SAN DIEGO',	'CA',	'CA323dbc23756fae08187cdb03c4aa7d25',	'+14062509831',	'completed',	12,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd7bf3181c7bf6801279c41680907abc8',	0,	0,	'',	''),
(258,	'CA68b1c0112c63a8cddf396fc510b4031a',	'',	'2016-06-14 17:16:05',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'91934',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16193639153',	'+19162627163',	'+16193639153',	NULL,	NULL,	NULL,	NULL,	'PINE VALLEY',	'CA',	'CA68b1c0112c63a8cddf396fc510b4031a',	'+14062509831',	'no-answer',	6,	NULL,	0,	0,	'',	''),
(259,	'CA14ae74c5c294b0ed458044021b9a6eea',	'',	'2016-06-14 17:52:27',	'US',	'30345',	'GA',	'MARIETTA',	'US',	'59601',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14068711391',	'+16784987292',	'+14068711391',	NULL,	NULL,	NULL,	NULL,	'HELENA',	'MT',	'CA14ae74c5c294b0ed458044021b9a6eea',	'+14062509831',	'completed',	15,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4ea21f33283536e6e5f87c57c5d221dd',	0,	0,	'',	''),
(260,	'CA8162124362f9d71c44b9895864c64285',	'',	'2016-06-14 17:53:37',	'US',	'30345',	'GA',	'MARIETTA',	'US',	'59601',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14068711391',	'+16784987292',	'+14068711391',	NULL,	NULL,	NULL,	NULL,	'HELENA',	'MT',	'CA8162124362f9d71c44b9895864c64285',	'+14062509831',	'completed',	12,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE358c1b9a95ef7128739863311807edad',	0,	0,	'',	''),
(261,	'CAf0fd80304a2e13cf329889c83fd21a66',	'',	'2016-06-14 17:54:29',	'US',	'30345',	'GA',	'MARIETTA',	'US',	'59601',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14068711391',	'+16784987292',	'+14068711391',	NULL,	NULL,	NULL,	NULL,	'HELENA',	'MT',	'CAf0fd80304a2e13cf329889c83fd21a66',	'+14062509831',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4ecdee03d7d38904bcd537827f59e3df',	0,	0,	'',	''),
(262,	'CA6d4d97eaff40489daddfbb98514b2c5e',	'',	'2016-06-14 17:59:04',	'US',	'30345',	'GA',	'MARIETTA',	'US',	'59601',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14068711391',	'+16784987292',	'+14068711391',	NULL,	NULL,	NULL,	NULL,	'HELENA',	'MT',	'CA6d4d97eaff40489daddfbb98514b2c5e',	'+14062509831',	'completed',	4,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE0b04e8ea3504f9eea19e0c029e7d48c7',	0,	0,	'',	''),
(263,	'CA7d67aed08741ee8ce85f8739c19fcf70',	'',	'2016-06-14 18:02:22',	'US',	'30345',	'GA',	'MARIETTA',	'US',	'59601',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14068711391',	'+16784987292',	'+14068711391',	NULL,	NULL,	NULL,	NULL,	'HELENA',	'MT',	'CA7d67aed08741ee8ce85f8739c19fcf70',	'+14062509831',	'completed',	4,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa932182590b607cbdaf4395262173eaf',	0,	0,	'',	''),
(264,	'CA5b02ddbd999cbcb77f9ea89cfedc00b4',	'',	'2016-06-14 18:02:54',	'US',	'30345',	'GA',	'MARIETTA',	'US',	'59601',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14068711391',	'+16784987292',	'+14068711391',	NULL,	NULL,	NULL,	NULL,	'HELENA',	'MT',	'CA5b02ddbd999cbcb77f9ea89cfedc00b4',	'+14062509831',	'completed',	3,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE8722518fa7862492da40b72ca3af95c6',	0,	0,	'',	''),
(265,	'CAbbe660ab9a75ce07e30fea6f7338e049',	'',	'2016-06-14 18:04:11',	'US',	'30345',	'GA',	'MARIETTA',	'US',	'59601',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14068711391',	'+16784987292',	'+14068711391',	NULL,	NULL,	NULL,	NULL,	'HELENA',	'MT',	'CAbbe660ab9a75ce07e30fea6f7338e049',	'+14062509831',	'completed',	49,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE348a8e9f97531dfb88eecf712dd08454',	0,	0,	'',	''),
(266,	'CA678123941a93a807454a627d3e253ffd',	'',	'2016-06-14 18:05:22',	'US',	'30345',	'GA',	'MARIETTA',	'US',	'59601',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14068711391',	'+16784987292',	'+14068711391',	NULL,	NULL,	NULL,	NULL,	'HELENA',	'MT',	'CA678123941a93a807454a627d3e253ffd',	'+14062509831',	'completed',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REcbc3bf6d19c171206250ecd358e9f30b',	0,	0,	'',	''),
(267,	'CA04f6c8b51c5e7afc8edfaa9786f20f7b',	'',	'2016-06-14 18:06:45',	'US',	'30345',	'GA',	'MARIETTA',	'US',	'59601',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14068711391',	'+16784987292',	'+14068711391',	NULL,	NULL,	NULL,	NULL,	'HELENA',	'MT',	'CA04f6c8b51c5e7afc8edfaa9786f20f7b',	'+14062509831',	'completed',	4,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE65b93d468f2880dbc97a348b1377aa06',	0,	0,	'',	''),
(268,	'CA3ec2a865fbbda4868c162b707e8e3a17',	'',	'2016-06-14 21:52:39',	'US',	'',	'CA',	'',	'US',	'21737',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14109882954',	'+19513741928',	'+14109882954',	NULL,	NULL,	NULL,	NULL,	'COLUMBIA',	'MD',	'CA3ec2a865fbbda4868c162b707e8e3a17',	'+14062509831',	'completed',	25,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REcf776a61c42d4c3e7ed5597f70011fe4',	0,	0,	'',	''),
(269,	'CA054093d81df39a06a9fd24d1840547ae',	'',	'2016-06-15 17:13:35',	'US',	'',	'CA',	'',	'US',	'92614',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14242177806',	'+19513741928',	'+14242177806',	NULL,	NULL,	NULL,	NULL,	'IRVINE',	'CA',	'CA709ffdb345f23076ea43325b33e502f3',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(270,	'CA970e974eb245dc604054c05651e0bd84',	'',	'2016-06-16 15:16:19',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19493451269',	'+19162627163',	'+19493451269',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA970e974eb245dc604054c05651e0bd84',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(271,	'CA07460e96e077f1cbfed82b7b084a6d8a',	'',	'2016-06-16 16:35:40',	'US',	'',	'CA',	'',	'US',	'95616',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15302989246',	'+19513741928',	'+15302989246',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CA74fa0a0fc417993c53b1d9e19c9efb2d',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(272,	'CAb913e4e43b02da40652152026c9159b1',	'',	'2016-06-16 17:18:05',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'95616',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15302989246',	'+16612439350',	'+15302989246',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CAc68ee471b51419abbcdfc7ca8fb5709e',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(273,	'CA9a2cdf4694c7665df7a7c70bcf5a2da7',	'',	'2016-06-16 18:32:57',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'33069',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19547732526',	'+16612439350',	'+19547732526',	NULL,	NULL,	NULL,	NULL,	'POMPANO BEACH',	'FL',	'CA9a2cdf4694c7665df7a7c70bcf5a2da7',	'+14062509831',	'completed',	38,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE91594236bc64cd2c056fa5e57ccf9b01',	0,	0,	'',	''),
(274,	'CA47c09cf9a3b6f0b6ef53426456bb9859',	'',	'2016-06-16 22:34:03',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'95616',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15302989246',	'+14252338984',	'+15302989246',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CA7198a5c35d3ede81533a7e72321dc517',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(275,	'CA14464303220eeae1bf1988d1268c79ae',	'',	'2016-06-16 22:46:10',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95616',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15302989246',	'+19162627163',	'+15302989246',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CA14464303220eeae1bf1988d1268c79ae',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(276,	'CAc56bee16fd9c8b3a839adca51089851d',	'',	'2016-06-17 16:35:11',	'US',	'30308',	'GA',	'ATLANTA',	'US',	'31211',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14787147580',	'+12294695960',	'+14787147580',	NULL,	NULL,	NULL,	NULL,	'MACON',	'GA',	'CAc56bee16fd9c8b3a839adca51089851d',	'+12294694862',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(277,	'CAf5c6df2d4da15ea4554e828144e1c1ce',	'',	'2016-06-17 17:27:30',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747020',	'+16612439350',	'+12096747020',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CA5a797c56e264e01928d1435941a62323',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(278,	'CA1c2c3072830c7eb58f0c954fd8f4bca5',	'',	'2016-06-17 17:32:31',	'US',	'',	'CA',	'',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747020',	'+19513741928',	'+12096747020',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CA186618e6347242115147940a9104371f',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(279,	'CA1a30fc4185e6d0427e9c6dfa52222846',	'',	'2016-06-17 18:58:29',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747020',	'+14252338984',	'+12096747020',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CAfcb97e2e13ff349cd8b6b782ed4c2819',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(280,	'CAebb7fb305b81b76daf11595e9336dd48',	'',	'2016-06-17 23:55:31',	'US',	'59105',	'MT',	'BILLINGS',	'US',	'59601',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14068711391',	'+14062151971',	'+14068711391',	NULL,	NULL,	NULL,	NULL,	'HELENA',	'MT',	'CAebb7fb305b81b76daf11595e9336dd48',	'+14068850281',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(281,	'CA4a794f9ae3b3e60639d69f65f5342333',	'',	'2016-06-20 16:57:50',	'US',	'',	'CA',	'',	'US',	'91934',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16193639164',	'+19513741928',	'+16193639164',	NULL,	NULL,	NULL,	NULL,	'PINE VALLEY',	'CA',	'CA4a794f9ae3b3e60639d69f65f5342333',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(282,	'CA61c1a5ac2eb8ee8f0f1f2ff6fb711473',	'',	'2016-06-20 20:41:28',	'US',	'',	'CA',	'',	'US',	'97707',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15414080192',	'+19513741928',	'+15414080192',	NULL,	NULL,	NULL,	NULL,	'BEND',	'OR',	'CA222d0269e4b22231314f2a8c8136bbd4',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(283,	'CAb1bfb1d3d2aecfb3b216cc2110ea4ab2',	'',	'2016-06-20 21:18:08',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'91934',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16193639164',	'+14252338984',	'+16193639164',	NULL,	NULL,	NULL,	NULL,	'PINE VALLEY',	'CA',	'CA0eedfbc23a56a98f83a41f35f117c06c',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(284,	'CAe29203525996a73e73af2a2768f9721f',	'',	'2016-06-20 22:01:36',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'91934',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16193639164',	'+19162627163',	'+16193639164',	NULL,	NULL,	NULL,	NULL,	'PINE VALLEY',	'CA',	'CAe29203525996a73e73af2a2768f9721f',	'+14062509831',	'completed',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE966d05a4ce34bee2211916bd58eaa722',	0,	0,	'',	''),
(285,	'CAbffcb862e1a75323d3aabcaa8cc55eb0',	'',	'2016-06-21 03:10:46',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18004298363',	'+19513741928',	'+18004298363',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CAbffcb862e1a75323d3aabcaa8cc55eb0',	'+14062509831',	'completed',	66,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE114f12bfed264ae82e6be783aa6cdce4',	0,	0,	'',	''),
(286,	'CA2ea8ebfad894284044c9223459a621c0',	'',	'2016-06-21 16:54:44',	'US',	'',	'CA',	'',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747032',	'+19513741928',	'+12096747032',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CA2ea8ebfad894284044c9223459a621c0',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(287,	'CA8927e6f29d3471ef84fdeb2f46b1cacf',	'',	'2016-06-21 16:54:59',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747032',	'+16612439350',	'+12096747032',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CA8927e6f29d3471ef84fdeb2f46b1cacf',	'+14062509831',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa3a4e1d5c937590d80da3838c60025c8',	0,	0,	'',	''),
(288,	'CAe7b6f50f1dd7babb6873c5295607b6d8',	'',	'2016-06-21 22:55:26',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747032',	'+14252338984',	'+12096747032',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CA336bc2cbf5a1bfd82c6d639e90413695',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(289,	'CAf4d572817589182911d43c8b76ac461e',	'',	'2016-06-22 16:50:23',	'US',	'',	'CA',	'',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747032',	'+19513741928',	'+12096747032',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CAf4d572817589182911d43c8b76ac461e',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(290,	'CA84dd45a01c92b8273bbed8241054e621',	'',	'2016-06-22 17:37:29',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747032',	'+16612439350',	'+12096747032',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CA92150fdea25301f47c1e844847a5a5a5',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(291,	'CAca238d785f9636e2f3cf40160dd0ea98',	'',	'2016-06-22 18:12:25',	'US',	'30345',	'GA',	'MARIETTA',	'US',	'59601',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14068711391',	'+16784987292',	'+14068711391',	NULL,	NULL,	NULL,	NULL,	'HELENA',	'MT',	'CAca238d785f9636e2f3cf40160dd0ea98',	'+17703723780',	'no-answer',	7,	NULL,	0,	0,	'',	''),
(292,	'CA2cd14c04d5000cdf21e90f63b12e7876',	'',	'2016-06-22 20:55:56',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'60706',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17733186609',	'+16612439350',	'+17733186609',	NULL,	NULL,	NULL,	NULL,	'CHICAGO',	'IL',	'CA675bb3f3cf4d5960948c5ab69d19ce4e',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(293,	'CAef606509b0d835a9b5188fb66b339e0d',	'',	'2016-06-22 21:39:31',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'91403',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13237987164',	'+19162627163',	'+13237987164',	NULL,	NULL,	NULL,	NULL,	'SHERMAN OAKS',	'CA',	'CAef606509b0d835a9b5188fb66b339e0d',	'+14062509831',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe251518cb5513671a73db4767ab48969',	0,	0,	'',	''),
(294,	'CAf9ba14d0302b60c194d1b94dac6a1dc4',	'',	'2016-06-22 21:39:37',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'91403',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13237987164',	'+19162627163',	'+13237987164',	NULL,	NULL,	NULL,	NULL,	'SHERMAN OAKS',	'CA',	'CAf9ba14d0302b60c194d1b94dac6a1dc4',	'+14062509831',	'completed',	12,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE8d992a50946d315f83574efd9aa50f9d',	0,	0,	'',	''),
(295,	'CAd497ba1735d26e369313d827460f64ef',	'',	'2016-06-22 21:39:40',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'91403',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13237987164',	'+19162627163',	'+13237987164',	NULL,	NULL,	NULL,	NULL,	'SHERMAN OAKS',	'CA',	'CAd497ba1735d26e369313d827460f64ef',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(296,	'CA06698668da3384f3b03c92a0615a489a',	'',	'2016-06-22 21:39:44',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'91403',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13237987164',	'+19162627163',	'+13237987164',	NULL,	NULL,	NULL,	NULL,	'SHERMAN OAKS',	'CA',	'CA06698668da3384f3b03c92a0615a489a',	'+14062509831',	'completed',	12,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE045372adb5061e9038ea4f921f9d1d29',	0,	0,	'',	''),
(297,	'CAf4a040c8980207dd393fca30f3bc35ee',	'',	'2016-06-23 20:28:35',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'94525',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15104555830',	'+19162627163',	'+15104555830',	NULL,	NULL,	NULL,	NULL,	'CROCKETT',	'CA',	'CAf4a040c8980207dd393fca30f3bc35ee',	'+14062509831',	'no-answer',	6,	NULL,	0,	0,	'',	''),
(298,	'CAec5c31fa91f57d9aae5c58a1adbdf9be',	'',	'2016-06-24 16:43:01',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14088199782',	'+19513741928',	'+14088199782',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAec5c31fa91f57d9aae5c58a1adbdf9be',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(299,	'CAe60d0d49fc39f7a5e52e3d430f20f8d6',	'',	'2016-06-24 20:27:55',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14088199782',	'+19162627163',	'+14088199782',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAe60d0d49fc39f7a5e52e3d430f20f8d6',	'+14062509831',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE59a34119829223a029d85927e9dfe4c0',	0,	0,	'',	''),
(300,	'CAdf89cf73cdf55089c4a2797dcd2a8108',	'',	'2016-06-24 20:27:58',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14088199782',	'+19162627163',	'+14088199782',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAdf89cf73cdf55089c4a2797dcd2a8108',	'+14062509831',	'completed',	12,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE41b7b39ba9e5ddbb5bde36e908511a99',	0,	0,	'',	''),
(301,	'CA84a3dd0aa89537dfc1e3ed1f7ae5b196',	'',	'2016-06-24 20:28:05',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14088199782',	'+19162627163',	'+14088199782',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA84a3dd0aa89537dfc1e3ed1f7ae5b196',	'+14062509831',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE1ba10203a60f1721256420396ba48f20',	0,	0,	'',	''),
(302,	'CA8b635a1e2313b240cde0c1273d927f16',	'',	'2016-06-24 20:28:07',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14088199782',	'+19162627163',	'+14088199782',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAbb379baaafcbe23175f81157d699678a',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(303,	'CA8c7afab7aada470fb266f6c68a8b6923',	'',	'2016-06-25 15:44:37',	'US',	'71101',	'LA',	'SHREVEPORT',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14694581223',	'+13187717327',	'+14694581223',	NULL,	NULL,	NULL,	NULL,	'',	'TX',	'CA8c7afab7aada470fb266f6c68a8b6923',	'+13186316433',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(304,	'CAa4a5847e5c6689b925b1a7fc2e0d9090',	'',	'2016-06-26 00:48:36',	'US',	'',	'TX',	'',	'US',	'75052',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14696882355',	'+14692069333',	'+14696882355',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CAa4a5847e5c6689b925b1a7fc2e0d9090',	'+14695102722',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE564d7c5d6191d8019e47db687154e8be',	0,	0,	'',	''),
(305,	'CA3b50cc942d51f27201a7157d2304d5b3',	'',	'2016-06-27 16:28:42',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16692384322',	'+19513741928',	'+16692384322',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA9032a30be7af01f3e82290b0bfe137e2',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(306,	'CA461be33b6a0fa564dcdb69d55571ce41',	'',	'2016-06-27 18:10:30',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16692384322',	'+19162627163',	'+16692384322',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA461be33b6a0fa564dcdb69d55571ce41',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(307,	'CA1572a55d3a85f6fe1d5e2ddb3f95e064',	'',	'2016-06-27 18:41:40',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95829',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19163811266',	'+19162627163',	'+19163811266',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CA1572a55d3a85f6fe1d5e2ddb3f95e064',	'+14062509831',	'completed',	57,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE40f04d17e70cc32a46c4307a591691b4',	0,	0,	'',	''),
(308,	'CAdfadca0ff0015fef359d0225dbec06af',	'',	'2016-06-28 16:49:01',	'US',	'',	'CA',	'',	'US',	'91403',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13237987339',	'+19513741928',	'+13237987339',	NULL,	NULL,	NULL,	NULL,	'SHERMAN OAKS',	'CA',	'CA0dfdbd932828fd03f4512a096088df8d',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(309,	'CAd8f6ddf8bdcacadc06005e6048d51ae9',	'',	'2016-06-28 17:18:53',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'90017',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17606918181',	'+16612439350',	'+17606918181',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CAcd0671557b46ebd4e19b5f3305045edb',	'+14062509831',	'voicemail',	3,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE19ef024a785f4324f77f9a8f2a04cde5',	0,	0,	'',	''),
(310,	'CA948ab7eac62bbfa7577ce0acf3132d1d',	'',	'2016-06-28 18:29:47',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'94040',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16502295993',	'+19162627163',	'+16502295993',	NULL,	NULL,	NULL,	NULL,	'FREMONT',	'CA',	'CA948ab7eac62bbfa7577ce0acf3132d1d',	'+14062509831',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE6954d6e4b845fb9b5bcfdd42eb1f5ee9',	0,	0,	'',	''),
(311,	'CA27800041002cbe177198d8aad70a0432',	'',	'2016-06-28 18:51:40',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'94040',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16502295993',	'+14252338984',	'+16502295993',	NULL,	NULL,	NULL,	NULL,	'FREMONT',	'CA',	'CA27800041002cbe177198d8aad70a0432',	'+14062509831',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4f47809a32d8088e0e5a315bf50273ce',	0,	0,	'',	''),
(312,	'CA8b776dadd3f4cde5eea19850ea107d0b',	'',	'2016-06-29 16:13:55',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14088199775',	'+19513741928',	'+14088199775',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA550d08349ecaac089501ce51f9d16d1a',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(313,	'CA2d7934da988f501e77bfc617333968c0',	'',	'2016-06-29 16:58:13',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14088199775',	'+19162627163',	'+14088199775',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA2d7934da988f501e77bfc617333968c0',	'+14062509831',	'no-answer',	6,	NULL,	0,	0,	'',	''),
(314,	'CA36d4e47b75a7e8ce417e6f8b150ec596',	'',	'2016-06-29 17:34:15',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'90017',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18052108752',	'+19162627163',	'+18052108752',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA36d4e47b75a7e8ce417e6f8b150ec596',	'+14062509831',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe4579bd10b48af5681d4fdbf88a02cd0',	0,	0,	'',	''),
(315,	'CA5689c39a452bed0c9924ef92e0d9775f',	'',	'2016-06-29 17:53:29',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'10523',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13472058439',	'+14252338984',	'+13472058439',	NULL,	NULL,	NULL,	NULL,	'ELMSFORD',	'NY',	'CAd45f80a259723786009c8716883b0f57',	'+14062509831',	'voicemail',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE0632b9bb5aa094ca2637d5d9a15d4450',	0,	0,	'',	''),
(316,	'CAa1aa818a21df469283964596b74e8bd1',	'',	'2016-07-01 18:22:46',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'59903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14062509831',	'+14062099330',	'+14062509831',	NULL,	NULL,	NULL,	NULL,	'KALISPELL',	'MT',	'CAa1aa818a21df469283964596b74e8bd1',	'+14062509831',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REea289879f9f343adbd18d8558cee3a18',	0,	0,	'',	''),
(317,	'CAc0194f3b000c433535e697a8f7e192b6',	'',	'2016-07-01 18:25:17',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'59903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+14062099330',	'+14062509831',	NULL,	NULL,	NULL,	NULL,	'KALISPELL',	'MT',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(318,	'CAcad9824109fa393d9a633f1be722f1f0',	'',	'2016-07-01 18:25:21',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'59903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14062509831',	'+14062099330',	'+14062509831',	NULL,	NULL,	NULL,	NULL,	'KALISPELL',	'MT',	'CAcad9824109fa393d9a633f1be722f1f0',	'+14062509831',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE0c9ce19165371ddfd10b7a08f2ab0849',	0,	0,	'',	''),
(319,	'CA9ffe15ff6b4a39e5a1bd448c8603c82c',	'',	'2016-07-01 22:31:23',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'70118',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15043352818',	'+14062099330',	'+15043352818',	NULL,	NULL,	NULL,	NULL,	'NEW ORLEANS',	'LA',	'CA9ffe15ff6b4a39e5a1bd448c8603c82c',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(320,	'CAf8ab06ec16e235c5da072fc1435638f5',	'',	'2016-07-05 05:38:13',	'US',	'27587',	'NC',	'WAKE FOREST',	'US',	'53213',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12625015586',	'+19194352674',	'+12625015586',	NULL,	NULL,	NULL,	NULL,	'MILWAUKEE',	'WI',	'CAf8ab06ec16e235c5da072fc1435638f5',	'+19199318240',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf3147cefc637bb8e2811af5c37007926',	0,	0,	'',	''),
(321,	'CA9246d84015e50d7fd4d867542ec938b8',	'',	'2016-07-05 05:39:22',	'US',	'27587',	'NC',	'WAKE FOREST',	'US',	'53213',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12625015586',	'+19194352674',	'+12625015586',	NULL,	NULL,	NULL,	NULL,	'MILWAUKEE',	'WI',	'CA9246d84015e50d7fd4d867542ec938b8',	'+19199318240',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(322,	'CAab98d1388fcd20d15f695e8257d5b5d6',	'',	'2016-07-05 16:40:12',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14088199776',	'+19513741928',	'+14088199776',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA5a7b49a4502b69759745795491b5571c',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(323,	'CAa46bd1f9207008fa01299ae625cef8a2',	'',	'2016-07-05 17:08:56',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14088199776',	'+16612439350',	'+14088199776',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAa46bd1f9207008fa01299ae625cef8a2',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(324,	'CAca38a9ab53856111f674342b0e02748b',	'',	'2016-07-05 20:47:04',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14088199776',	'+19162627163',	'+14088199776',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAca38a9ab53856111f674342b0e02748b',	'+14062509831',	'no-answer',	6,	NULL,	0,	0,	'',	''),
(325,	'CA59b5842df316f2368c8165b3230afd74',	'',	'2016-07-05 21:41:50',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19095710014',	'+19513741928',	'+19095710014',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA59b5842df316f2368c8165b3230afd74',	'+14062509831',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE89b7c7c84821b42ea0e8731b41a2969d',	0,	0,	'',	''),
(326,	'CAd7c0da531863d06b32650dd31a24307a',	'',	'2016-07-05 22:34:29',	'US',	'30308',	'GA',	'ATLANTA',	'US',	'30308',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12294694174',	'+12294695960',	'+12294694174',	NULL,	NULL,	NULL,	NULL,	'ATLANTA',	'GA',	'CAd7c0da531863d06b32650dd31a24307a',	'+12294697257',	'completed',	42,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe6a759367b928138d98ff6a130293698',	0,	0,	'',	''),
(327,	'CA386993618f4379a48dd318e239c3d73c',	'',	'2016-07-06 16:44:48',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747122',	'+16612439350',	'+12096747122',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CA5d07f2d3ad13ac53bc7b92a386659564',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(328,	'CA56d3b17b6342e2ad36583cc8e796a23a',	'',	'2016-07-06 16:54:20',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'92008',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17604445575',	'+16612439350',	'+17604445575',	NULL,	NULL,	NULL,	NULL,	'CARLSBAD',	'CA',	'CA56d3b17b6342e2ad36583cc8e796a23a',	'+14062509831',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE7c9965ea540c5999d2f061abb3308cb6',	0,	0,	'',	''),
(329,	'CAc1e675c6e9f7484bc06a257a099c78dc',	'',	'2016-07-06 17:17:56',	'US',	'',	'CA',	'',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747122',	'+19513741928',	'+12096747122',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CAc1e675c6e9f7484bc06a257a099c78dc',	'+14062509831',	'no-answer',	6,	NULL,	0,	0,	'',	''),
(330,	'CA02bb8d08bd867b48d873d1fda1537483',	'',	'2016-07-06 17:48:51',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'92008',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17604445575',	'+19162627163',	'+17604445575',	NULL,	NULL,	NULL,	NULL,	'CARLSBAD',	'CA',	'CA055eae562ee5ccd850aaabb067498041',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(331,	'CAd4f5e1de3196ea22395f82b8b3cf3bc6',	'',	'2016-07-06 19:21:15',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'11946',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16318565625',	'+14252338984',	'+16318565625',	NULL,	NULL,	NULL,	NULL,	'HAMPTON BAYS',	'NY',	'CA5b45711b2bcdb178d86c0653930d9bc4',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(332,	'CA735c254de7df64c00cce110ad688384f',	'',	'2016-07-06 19:21:34',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'11946',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16318565625',	'+14252338984',	'+16318565625',	NULL,	NULL,	NULL,	NULL,	'HAMPTON BAYS',	'NY',	'CA4c5029b78b206adcb52a8cb8f83414c7',	'+14062509831',	'voicemail',	15,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf8a2ef0e6b7452c93d8f5e0798e416fa',	0,	0,	'',	''),
(333,	'CA76b5dc62ca7534cd1dd85bcd48b4e3ae',	'',	'2016-07-06 19:32:06',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'10199',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+16612439350',	'+19174774078',	NULL,	NULL,	NULL,	NULL,	'NEW YORK',	'NY',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(334,	'CAb331772a5afdb7a6d83d7e3b3fa4cc62',	'',	'2016-07-06 19:33:48',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'10199',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19174774078',	'+14252338984',	'+19174774078',	NULL,	NULL,	NULL,	NULL,	'NEW YORK',	'NY',	'CA29077f5a52268178d7d9d542e289f9c0',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(335,	'CAd8432503226434ec566a211ff8971ca7',	'',	'2016-07-06 20:21:30',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'94087',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14086855820',	'+19162627163',	'+14086855820',	NULL,	NULL,	NULL,	NULL,	'SUNNYVALE',	'CA',	'CA1d13cc1771bd630d878ceed5d9dc5f65',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(336,	'CA146b92e046a43ea98a8eb4104c28f767',	'',	'2016-07-07 16:36:24',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14088199771',	'+16612439350',	'+14088199771',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA146b92e046a43ea98a8eb4104c28f767',	'+14062509831',	'no-answer',	6,	NULL,	0,	0,	'',	''),
(337,	'CA8d0e43108a12db2448cfc01cd1a9f846',	'',	'2016-07-07 17:18:10',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14088199771',	'+19513741928',	'+14088199771',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA0073e8336aa635b8fdc57db81285bbee',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(338,	'CA84fe68f58165f08fdc5dcf073f541893',	'',	'2016-07-07 17:52:48',	'US',	'',	'CA',	'',	'US',	'52403',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13197343400',	'+19513741928',	'+13197343400',	NULL,	NULL,	NULL,	NULL,	'CEDAR RAPIDS',	'IA',	'CA84fe68f58165f08fdc5dcf073f541893',	'+14062509831',	'completed',	67,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE0108d26f79adc8b966d400ba52c2feaf',	0,	0,	'',	''),
(339,	'CAb7636f1314bc1501451ae33dab1511d4',	'',	'2016-07-08 14:30:30',	'US',	'71101',	'LA',	'SHREVEPORT',	'US',	'02906',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14017093451',	'+13187717327',	'+14017093451',	NULL,	NULL,	NULL,	NULL,	'PROVIDENCE',	'RI',	'CAb7636f1314bc1501451ae33dab1511d4',	'+13186316433',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(340,	'CA464f53445667cd48d7a2c48400e84734',	'',	'2016-07-08 14:46:14',	'US',	'29579',	'SC',	'MYRTLE BEACH',	'US',	'28501',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12522684632',	'+18434924725',	'+12522684632',	NULL,	NULL,	NULL,	NULL,	'KINSTON',	'NC',	'CA464f53445667cd48d7a2c48400e84734',	'+18435039494',	'completed',	417,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE19a0187035e0abbd2f1fe29fd7555796',	0,	0,	'',	''),
(341,	'CAe7b83959d3ed230f738e346e369844aa',	'',	'2016-07-08 16:41:19',	'US',	'',	'CA',	'',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747014',	'+19513741928',	'+12096747014',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CA1020d80a4a3bae09423776a6b3bba275',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(342,	'CA2a109421c8d73387c85a24058276a932',	'',	'2016-07-08 17:53:06',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747014',	'+19162627163',	'+12096747014',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CA2a109421c8d73387c85a24058276a932',	'+14062509831',	'completed',	6,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE1429d68e99282f61c3a6ba045c73f260',	0,	0,	'',	''),
(343,	'CA7866b1dba01334a89ed9b144d0b385f8',	'',	'2016-07-08 21:14:01',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19165475140',	'+19162627163',	'+19165475140',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA7866b1dba01334a89ed9b144d0b385f8',	'+14062509831',	'completed',	23,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4440b2e6ac7bd8f71a2c922c8ad9b4ea',	0,	0,	'',	''),
(344,	'CA415e4912ff03443602458c59e6227aeb',	'',	'2016-07-08 21:17:57',	'US',	'',	'CA',	'',	'US',	'91602',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18183215831',	'+19513741928',	'+18183215831',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA415e4912ff03443602458c59e6227aeb',	'+14062509831',	'completed',	26,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd6a0e163b044d398dd61762012649b9b',	0,	0,	'',	''),
(345,	'CA7d3efaa7477361f2d2ca2cfa770cfa71',	'',	'2016-07-08 22:33:56',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19162466350',	'+19162627163',	'+19162466350',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA7d3efaa7477361f2d2ca2cfa770cfa71',	'+14062509831',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE149e2989da19d8b23093447dfd31ca77',	0,	0,	'',	''),
(346,	'CAe8c3a517471985abe82d8fcf353a24e9',	'',	'2016-07-08 23:21:33',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19162466350',	'+14252338984',	'+19162466350',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAaa297d4da91c9259afbd860dc3b65156',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(347,	'CA0c1c9bd7684f89d56e4b164b71e9d705',	'',	'2016-07-11 16:19:27',	'US',	'',	'CA',	'',	'US',	'93012',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18057387148',	'+19513741928',	'+18057387148',	NULL,	NULL,	NULL,	NULL,	'CAMARILLO',	'CA',	'CA829582bdd07280bcc60d380a06c89b19',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(348,	'CAf9cc7f6ba3f2bf85ace7709ec82b86a3',	'',	'2016-07-11 16:32:35',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'93012',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18057387148',	'+16612439350',	'+18057387148',	NULL,	NULL,	NULL,	NULL,	'CAMARILLO',	'CA',	'CAf9cc7f6ba3f2bf85ace7709ec82b86a3',	'+14062509831',	'no-answer',	6,	NULL,	0,	0,	'',	''),
(349,	'CA13e6c1747be0125b377b37175426771e',	'',	'2016-07-11 17:08:29',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'93012',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18057387148',	'+19162627163',	'+18057387148',	NULL,	NULL,	NULL,	NULL,	'CAMARILLO',	'CA',	'CA40eac53f809311e838e2c00b44b7e6d5',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(350,	'CAd37c1d88814f88c99179a3c0991c12df',	'',	'2016-07-11 22:39:29',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'93001',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18052563686',	'+19162627163',	'+18052563686',	NULL,	NULL,	NULL,	NULL,	'VENTURA',	'CA',	'CAcbc68a905f1b5e8215a08eeb280fb771',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(351,	'CA00896486164f9893cb5a731e11b78960',	'',	'2016-07-11 22:55:44',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'93001',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18052563686',	'+14252338984',	'+18052563686',	NULL,	NULL,	NULL,	NULL,	'VENTURA',	'CA',	'CA3b68c63b3edabdad2c22f1fd8a892720',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(352,	'CA1f3c4b728a06650e6a6e75dd48ba34a8',	'',	'2016-07-12 17:10:16',	'US',	'',	'CA',	'',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747006',	'+19513741928',	'+12096747006',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CA1f3c4b728a06650e6a6e75dd48ba34a8',	'+14062509831',	'no-answer',	6,	NULL,	0,	0,	'',	''),
(353,	'CA4fe593660d7921d42cfdde6de104a7c1',	'',	'2016-07-12 22:53:17',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19162466592',	'+19162627163',	'+19162466592',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA4fe593660d7921d42cfdde6de104a7c1',	'+14062509831',	'completed',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE52586c4d04a38139ee00561a1d58af21',	0,	0,	'',	''),
(354,	'CA8f05d9289a9cca7afb5ff71e25da964d',	'',	'2016-07-12 23:33:54',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19162466592',	'+14252338984',	'+19162466592',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAb2ffbd91d7b03e6696b631b92f90fea3',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(355,	'CA90f78e3c7747e28a709535d9fbf1f5e2',	'',	'2016-07-13 16:31:37',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'94525',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15104555872',	'+16612439350',	'+15104555872',	NULL,	NULL,	NULL,	NULL,	'CROCKETT',	'CA',	'CA90f78e3c7747e28a709535d9fbf1f5e2',	'+14062509831',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REaf368e2473c1302feb4ef3fa8c310c8e',	0,	0,	'',	''),
(356,	'CAe2125451f5f4895c5a64817280364c69',	'',	'2016-07-13 16:36:08',	'US',	'',	'CA',	'',	'US',	'94525',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15104555872',	'+19513741928',	'+15104555872',	NULL,	NULL,	NULL,	NULL,	'CROCKETT',	'CA',	'CAe2125451f5f4895c5a64817280364c69',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(357,	'CAca009611732a1f6e74e02fcbe1e0c874',	'',	'2016-07-13 17:30:35',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'94525',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15104555872',	'+19162627163',	'+15104555872',	NULL,	NULL,	NULL,	NULL,	'CROCKETT',	'CA',	'CAca009611732a1f6e74e02fcbe1e0c874',	'+14062509831',	'no-answer',	6,	NULL,	0,	0,	'',	''),
(358,	'CA5e04e678e0315a8f0a77249538536cc0',	'',	'2016-07-13 18:05:46',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'94525',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15104555872',	'+14252338984',	'+15104555872',	NULL,	NULL,	NULL,	NULL,	'CROCKETT',	'CA',	'CA5e04e678e0315a8f0a77249538536cc0',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(359,	'CAd2d090d8240060a0bd3146f5a74fd241',	'',	'2016-07-13 20:24:59',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'33069',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19547732534',	'+16612439350',	'+19547732534',	NULL,	NULL,	NULL,	NULL,	'POMPANO BEACH',	'FL',	'CAd2d090d8240060a0bd3146f5a74fd241',	'+14062509831',	'completed',	1,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE8cc1ce812bd94619c455d3d4c8141619',	0,	0,	'',	''),
(360,	'CA9135b710a3ba2c09395d6a6d5e40e335',	'',	'2016-07-13 21:38:42',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'10523',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13472058439',	'+14252338984',	'+13472058439',	NULL,	NULL,	NULL,	NULL,	'ELMSFORD',	'NY',	'CA9135b710a3ba2c09395d6a6d5e40e335',	'+14062509831',	'completed',	29,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd44d5768263b9da671b0f65671b5ff60',	0,	0,	'',	''),
(361,	'CA51b15fd943a1dbd374e64745a2888651',	'',	'2016-07-13 22:48:05',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'94609',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15103610465',	'+14252338984',	'+15103610465',	NULL,	NULL,	NULL,	NULL,	'EL SOBRANTE',	'CA',	'CA51b15fd943a1dbd374e64745a2888651',	'+14062509831',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3d3130ee6d9386716cd3d778e07af8fb',	0,	0,	'',	''),
(362,	'CAde016e71b2c6c9afa461814add254f92',	'',	'2016-07-13 23:23:23',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'94609',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15103610465',	'+19162627163',	'+15103610465',	NULL,	NULL,	NULL,	NULL,	'EL SOBRANTE',	'CA',	'CAde016e71b2c6c9afa461814add254f92',	'+14062509831',	'completed',	3,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REcd4bdab0c514d780aa4f6ccd9f0cc050',	0,	0,	'',	''),
(363,	'CA94f9cd3215d17d2d6edd6d977fb780cf',	'',	'2016-07-14 16:33:44',	'US',	'',	'CA',	'',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747037',	'+19513741928',	'+12096747037',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CA94f9cd3215d17d2d6edd6d977fb780cf',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(364,	'CA15a531c285e2c92988335e8494529fbc',	'',	'2016-07-14 17:23:29',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747037',	'+16612439350',	'+12096747037',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CA15a531c285e2c92988335e8494529fbc',	'+14062509831',	'completed',	6,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE59a670278266fa64335f5fa9de3e44b2',	0,	0,	'',	''),
(365,	'CA30ebef13b3f0acffcf42d7591384d367',	'',	'2016-07-14 18:02:34',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747037',	'+19162627163',	'+12096747037',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CA30ebef13b3f0acffcf42d7591384d367',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(366,	'CA7cf90aabb0d5c33281277016605cd419',	'',	'2016-07-14 22:39:15',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'90014',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18182103952',	'+19162627163',	'+18182103952',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA7cf90aabb0d5c33281277016605cd419',	'+14062509831',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE388267f9d4c186b38b4110d7bf090cbf',	0,	0,	'',	''),
(367,	'CA5f2d6ac514bd34586468242ee150838a',	'',	'2016-07-15 16:36:08',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19167588642',	'+19513741928',	'+19167588642',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA2edb7f41c37ccf24c281f1cae8c3b8ec',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(368,	'CA9da99d0f1534e819ff1cc224c6de4497',	'',	'2016-07-15 16:50:38',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19167588642',	'+16612439350',	'+19167588642',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAb6b1783a9ee3d480a13c9ac9cf94b865',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(369,	'CA9b34cd1b9f7e5f2a11be8dadba8fb8a7',	'',	'2016-07-15 18:13:50',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19167588642',	'+14252338984',	'+19167588642',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA52cf6b3ac82b170843b5a84a22a99202',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(370,	'CA28348887924b8412d78e91b8578947b3',	'',	'2016-07-15 18:13:55',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19167588642',	'+19162627163',	'+19167588642',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAcbaa105b666ee69b8061081f9eb4377c',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(371,	'CA4223b8b96942d5caf327c471cf87ac8a',	'',	'2016-07-15 19:12:44',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'98102',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14252762566',	'+14252338984',	'+14252762566',	NULL,	NULL,	NULL,	NULL,	'SEATTLE',	'WA',	'CA4223b8b96942d5caf327c471cf87ac8a',	'+14062509831',	'completed',	55,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf7839847b1be64fdc97f8f4f0f8ab1ac',	0,	0,	'',	''),
(372,	'CA6dc89a80f788497f8566e83c627062b6',	'',	'2016-07-15 21:28:19',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'90017',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14242066870',	'+14252338984',	'+14242066870',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CAbbafbc4ae41d5086c025fffa19437437',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(373,	'CAafda89431c018fc843d5c11f48ff168a',	'',	'2016-07-16 18:46:33',	'US',	'27587',	'NC',	'WAKE FOREST',	'US',	'27569',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19197356035',	'+19194352674',	'+19197356035',	NULL,	NULL,	NULL,	NULL,	'GOLDSBORO',	'NC',	'CAafda89431c018fc843d5c11f48ff168a',	'+19199318240',	'completed',	6,	NULL,	0,	0,	'',	''),
(374,	'CAa643ceb377eaf373f27ac5afd73733b5',	'',	'2016-07-18 16:22:44',	'US',	'',	'CA',	'',	'US',	'94103',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16283336456',	'+19513741928',	'+16283336456',	NULL,	NULL,	NULL,	NULL,	'San Francisco',	'CA',	'CAa643ceb377eaf373f27ac5afd73733b5',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(375,	'CA33bdc27bbe0e9d0ef0b372db5df430f1',	'',	'2016-07-18 16:24:43',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'94103',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16283336456',	'+16612439350',	'+16283336456',	NULL,	NULL,	NULL,	NULL,	'San Francisco',	'CA',	'CA33bdc27bbe0e9d0ef0b372db5df430f1',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(376,	'CA451f18ec2875205a88fbdc1f122681d8',	'',	'2016-07-18 23:04:01',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13609473179',	'+19513741928',	'+13609473179',	NULL,	NULL,	NULL,	NULL,	'',	'WA',	'CA451f18ec2875205a88fbdc1f122681d8',	'+14062509831',	'completed',	16,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REfa3db52dd5b77534d383922bccba0574',	0,	0,	'',	''),
(377,	'CA3beee488b0b768014416b42348ebe751',	'',	'2016-07-18 23:27:33',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19162459572',	'+19162627163',	'+19162459572',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA3beee488b0b768014416b42348ebe751',	'+14062509831',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE79f8e07fc6fd434103dbdf6aabb8222a',	0,	0,	'',	''),
(378,	'CAc961caf0b6bfc17beb3e02566e4a9213',	'',	'2016-07-19 16:31:50',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'90048',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13105963575',	'+16612439350',	'+13105963575',	NULL,	NULL,	NULL,	NULL,	'BEVERLY HILLS',	'CA',	'CAc961caf0b6bfc17beb3e02566e4a9213',	'+14062509831',	'no-answer',	6,	NULL,	0,	0,	'',	''),
(379,	'CA72f94a7b44b6f9f9a700b6c13f76527e',	'',	'2016-07-19 16:50:29',	'US',	'',	'CA',	'',	'US',	'90048',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13105963575',	'+19513741928',	'+13105963575',	NULL,	NULL,	NULL,	NULL,	'BEVERLY HILLS',	'CA',	'CAabb602be7329d77e72587322c9cc9a1c',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(380,	'CA4266c04730fed6604dca06829803592c',	'',	'2016-07-19 17:35:59',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'90048',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13105963575',	'+19162627163',	'+13105963575',	NULL,	NULL,	NULL,	NULL,	'BEVERLY HILLS',	'CA',	'CA4266c04730fed6604dca06829803592c',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(381,	'CA401169bca1fcbacff643165d30cdda45',	'',	'2016-07-19 18:16:53',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'90015',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13104094979',	'+14252338984',	'+13104094979',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CAb547328429876e0b6bed2121183b757d',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(382,	'CAf55e2df8c94a1f7503e4e346476a7e4e',	'',	'2016-07-20 16:29:36',	'US',	'',	'CA',	'',	'US',	'91934',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16193639219',	'+19513741928',	'+16193639219',	NULL,	NULL,	NULL,	NULL,	'PINE VALLEY',	'CA',	'CAf55e2df8c94a1f7503e4e346476a7e4e',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(383,	'CA42d9b0a6d5ac2fe2cb5f5b5f8018a68b',	'',	'2016-07-20 16:49:10',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'91934',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16193639219',	'+16612439350',	'+16193639219',	NULL,	NULL,	NULL,	NULL,	'PINE VALLEY',	'CA',	'CA42d9b0a6d5ac2fe2cb5f5b5f8018a68b',	'+14062509831',	'no-answer',	6,	NULL,	0,	0,	'',	''),
(384,	'CA6f75d1ef9dd3ee92bd2cdb64d9cf0e91',	'',	'2016-07-20 17:38:29',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'91934',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16193639219',	'+19162627163',	'+16193639219',	NULL,	NULL,	NULL,	NULL,	'PINE VALLEY',	'CA',	'CA4366574419c78df7d82cbccd1306876d',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(385,	'CAee4f98e928019c4f87a539d4117f9f6e',	'',	'2016-07-20 19:20:46',	'US',	'59105',	'MT',	'BILLINGS',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18007941404',	'+14062151971',	'+18007941404',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CAee4f98e928019c4f87a539d4117f9f6e',	'+14068850281',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(386,	'CA8b576f686d4388e5aec8d15f735a121b',	'',	'2016-07-20 21:04:46',	'US',	'',	'CA',	'',	'US',	'91406',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18183717796',	'+19513741928',	'+18183717796',	NULL,	NULL,	NULL,	NULL,	'VAN NUYS',	'CA',	'CA8b576f686d4388e5aec8d15f735a121b',	'+14062509831',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REdcd3c540df4a6943729eebbd26cf79e1',	0,	0,	'',	''),
(387,	'CA179960af02cb92c88540cf0fad2f6fc7',	'',	'2016-07-21 17:20:38',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16692384313',	'+16612439350',	'+16692384313',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA179960af02cb92c88540cf0fad2f6fc7',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(388,	'CA3d60ec7c8d318d4497ae47417c80e6ab',	'',	'2016-07-21 18:15:31',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16692384313',	'+14252338984',	'+16692384313',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA3d60ec7c8d318d4497ae47417c80e6ab',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(389,	'CA7fc9176913baa56f696a9df095b49d08',	'',	'2016-07-21 18:33:09',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16692384313',	'+19162627163',	'+16692384313',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA7fc9176913baa56f696a9df095b49d08',	'+14062509831',	'no-answer',	6,	NULL,	0,	0,	'',	''),
(390,	'CAe575e1ce6408f9ae697d57c5c9c3bcd2',	'',	'2016-07-21 19:19:42',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'93386',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16619005850',	'+16612439350',	'+16619005850',	NULL,	NULL,	NULL,	NULL,	'BAKERSFIELD',	'CA',	'CA906cf796cd9dfc7ae9715f6420b3b543',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(391,	'CA721f9459626b222ecc21356c5a075912',	'',	'2016-07-21 23:31:13',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'90017',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13232852378',	'+14252338984',	'+13232852378',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CAdd6c90bed310509eb59b2e2ab54f8c5e',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(392,	'CAd9243708b8956cddb0dc3a96454de24c',	'',	'2016-07-22 17:11:15',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19162457026',	'+19162627163',	'+19162457026',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAd9243708b8956cddb0dc3a96454de24c',	'+14062509831',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE317982964fd40489a17080adaf46db42',	0,	0,	'',	''),
(393,	'CA57f3b343fae996739a82ae6ad19e12d5',	'',	'2016-07-22 23:37:55',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19162457026',	'+14252338984',	'+19162457026',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA57f3b343fae996739a82ae6ad19e12d5',	'+14062509831',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE874de9af62b1d38c2f66b81ad5d4c7a9',	0,	0,	'',	''),
(394,	'CAfc85853a3e89851f4c56552dc3a23b31',	'',	'2016-07-23 17:35:58',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'59602',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14062042199',	'+14062099330',	'+14062042199',	NULL,	NULL,	NULL,	NULL,	'HELENA',	'MT',	'CAfc85853a3e89851f4c56552dc3a23b31',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(395,	'CA5f619fb8f182652c638f873bd9ef6054',	'',	'2016-07-23 21:45:04',	'US',	'27587',	'NC',	'WAKE FOREST',	'US',	'27707',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19196411035',	'+19194352674',	'+19196411035',	NULL,	NULL,	NULL,	NULL,	'DURHAM',	'NC',	'CA5f619fb8f182652c638f873bd9ef6054',	'+19199318240',	'completed',	6,	NULL,	0,	0,	'',	''),
(396,	'CA60ceeb842ce79e86e28e8579658eaf19',	'',	'2016-07-24 22:58:41',	'US',	'',	'CA',	'',	'US',	'92359',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19513741928',	'+19098103656',	NULL,	NULL,	NULL,	NULL,	'MENTONE',	'CA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(397,	'CA11239602eb210079058a6595009a9eb1',	'',	'2016-07-24 22:59:29',	'US',	'',	'CA',	'',	'US',	'92359',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19098103656',	'+19513741928',	'+19098103656',	NULL,	NULL,	NULL,	NULL,	'MENTONE',	'CA',	'CA11239602eb210079058a6595009a9eb1',	'+14062509831',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE2ea2dc93c9a99beeb820b9a0449b110b',	0,	0,	'',	''),
(398,	'CA007dd88df959d3b2b73ad7782b7c6b42',	'',	'2016-07-25 17:09:46',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747064',	'+16612439350',	'+12096747064',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CA007dd88df959d3b2b73ad7782b7c6b42',	'+14062509831',	'completed',	6,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE43172e045f9f9fb26fbd0f21ca58813d',	0,	0,	'',	''),
(399,	'CA7060464e071bbeb10833a9a664f02301',	'',	'2016-07-25 17:29:32',	'US',	'',	'CA',	'',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747064',	'+19513741928',	'+12096747064',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CA7060464e071bbeb10833a9a664f02301',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(400,	'CAf933282a5fac38db29e812b5fb901117',	'',	'2016-07-25 18:25:19',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747064',	'+19162627163',	'+12096747064',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CA7b1065259672f4b217d38105d55e6c02',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(401,	'CA55b233c29c02eb7bb6fbccf08352925e',	'',	'2016-07-25 22:11:15',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19162466427',	'+14252338984',	'+19162466427',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA55b233c29c02eb7bb6fbccf08352925e',	'+14062509831',	'completed',	12,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE9978b7e68cdf9ad1e585df0d7486bb7c',	0,	0,	'',	''),
(402,	'CA81007e835d1fa0284a6f881c4f670a53',	'',	'2016-07-25 23:16:38',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19162466427',	'+19162627163',	'+19162466427',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAa9f6297aa62bc4bb336fd774ccae458a',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(403,	'CA1c45245aa6e90c5db4f0a171d7f1bdf9',	'',	'2016-07-26 20:40:31',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16692384361',	'+16612439350',	'+16692384361',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAf76a96c2062b62a8d6d45c0f54bec9a6',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(404,	'CAfa0d92ed645eae782fec56ebf353ac8f',	'',	'2016-07-26 21:36:39',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16692384361',	'+19513741928',	'+16692384361',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAcf347a28f6ce6750bc8eb17d6a1b420b',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(405,	'CA5ef6e6f5c3c2942a0dbf2b60def16c9c',	'',	'2016-07-26 23:13:01',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'90017',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18052420301',	'+14252338984',	'+18052420301',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA5ef6e6f5c3c2942a0dbf2b60def16c9c',	'+14062509831',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE971646c80ff0d89e6a0ce66c62d4a63c',	0,	0,	'',	''),
(406,	'CA827f97d0417fa4888b2b2f6354f06ba3',	'',	'2016-07-26 23:16:52',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95842',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19168496753',	'+19162627163',	'+19168496753',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CAe17d858a06321563c9253c7d33b429c8',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(407,	'CA31807145c75ffe641b9df8f3c4e53a40',	'',	'2016-07-26 23:19:53',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'90017',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18052420301',	'+19162627163',	'+18052420301',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CAb8597db3492c663ca21098cdc2298dd8',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(408,	'CAa2f53bb818454e5f3681a0472d68177d',	'',	'2016-07-27 19:29:14',	'US',	'30345',	'GA',	'MARIETTA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18559092274',	'+16784987292',	'+18559092274',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CAa2f53bb818454e5f3681a0472d68177d',	'+17703723780',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE73c98d0b1de5fff812b8dff92f8b79b0',	0,	0,	'',	''),
(409,	'CA10dd7b1f6530cfdf3f57e306acd2f3de',	'',	'2016-07-27 20:21:19',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19167588651',	'+19513741928',	'+19167588651',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA10dd7b1f6530cfdf3f57e306acd2f3de',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(410,	'CA41441f1d1f0098b641d4e8e32eed2ed9',	'',	'2016-07-27 20:35:04',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19167588651',	'+16612439350',	'+19167588651',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA41441f1d1f0098b641d4e8e32eed2ed9',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(411,	'CA35f4bd97beb73adda0905c4eae608bba',	'',	'2016-07-27 21:39:20',	'US',	'30345',	'GA',	'MARIETTA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18559092274',	'+16784987292',	'+18559092274',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA35f4bd97beb73adda0905c4eae608bba',	'+17703723780',	'completed',	30,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc741c3ef96ce5f392896ff5e44ff839f',	0,	0,	'',	''),
(412,	'CAe42b28d792578627bf0008495b02023b',	'',	'2016-07-27 21:52:25',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19167588651',	'+14252338984',	'+19167588651',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAecbfa80d0766067bdfec83cae8edc443',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(413,	'CAe21f514984dca321a758b9428dbaf3f2',	'',	'2016-07-27 22:03:47',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19167588651',	'+19162627163',	'+19167588651',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA597a2220e009aa5d0225eea7f418463a',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(414,	'CAcb59aa338d161338164ba6ac7e2bb488',	'',	'2016-07-28 18:47:27',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19162466981',	'+19162627163',	'+19162466981',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAca1007a3485c87a77e6433d6ad76eb7a',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(415,	'CA1d6ba5dd84404d62b36d509f17b616ea',	'',	'2016-07-28 20:29:05',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16692384321',	'+16612439350',	'+16692384321',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA1d6ba5dd84404d62b36d509f17b616ea',	'+14062509831',	'no-answer',	6,	NULL,	0,	0,	'',	''),
(416,	'CAfa9b91bfda983070aae5c69a17de21a1',	'',	'2016-07-28 20:48:24',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16692384321',	'+19513741928',	'+16692384321',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA048e7c1ec9206bf00cce1d531d1c2f46',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(417,	'CA1927584d25f6405abcb1efd5fe08820a',	'',	'2016-07-28 22:42:41',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16692384321',	'+19162627163',	'+16692384321',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA1927584d25f6405abcb1efd5fe08820a',	'+14062509831',	'no-answer',	6,	NULL,	0,	0,	'',	''),
(418,	'CAaee7fbcaa9953e1450b08e5440d216d8',	'',	'2016-07-28 23:02:21',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19162466981',	'+14252338984',	'+19162466981',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAaee7fbcaa9953e1450b08e5440d216d8',	'+14062509831',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE93bdd1a2123f31b7d429de23d0857307',	0,	0,	'',	''),
(419,	'CA92e06d56fc742e84beb44d072a1fc212',	'',	'2016-07-29 18:26:27',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'91934',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16193639197',	'+16612439350',	'+16193639197',	NULL,	NULL,	NULL,	NULL,	'PINE VALLEY',	'CA',	'CA92e06d56fc742e84beb44d072a1fc212',	'+14062509831',	'no-answer',	6,	NULL,	0,	0,	'',	''),
(420,	'CA98b86b3cd146d90ba074650b4a274d69',	'',	'2016-07-29 22:15:41',	'US',	'30308',	'GA',	'ATLANTA',	'US',	'31643',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12293058083',	'+12294695960',	'+12293058083',	NULL,	NULL,	NULL,	NULL,	'QUITMAN',	'GA',	'CA98b86b3cd146d90ba074650b4a274d69',	'+12294697257',	'completed',	15,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE65edede81a7ff168bbe1ae9c2c1560ef',	0,	0,	'',	''),
(421,	'CAe578519aaf4bf2c43c156014a3dfafda',	'',	'2016-07-29 22:16:11',	'US',	'30308',	'GA',	'ATLANTA',	'US',	'31643',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12293058083',	'+12294695960',	'+12293058083',	NULL,	NULL,	NULL,	NULL,	'QUITMAN',	'GA',	'CAe578519aaf4bf2c43c156014a3dfafda',	'+12294697257',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(422,	'CA2e4bda64131080a9a285f350414af053',	'',	'2016-08-01 18:28:30',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16692384283',	'+19513741928',	'+16692384283',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA2e4bda64131080a9a285f350414af053',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(423,	'CA72e000310d8f8362552806b447df5f65',	'',	'2016-08-01 18:47:01',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16692384283',	'+16612439350',	'+16692384283',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA72e000310d8f8362552806b447df5f65',	'+14062509831',	'no-answer',	6,	NULL,	0,	0,	'',	''),
(424,	'CAdead93337ba38895764942270495c31f',	'',	'2016-08-01 20:41:18',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16692384283',	'+19162627163',	'+16692384283',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA4ba5a89cfcbcdaf8591b79bc50b34d49',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(425,	'CA96dbab37cd98102567cb18b8e61501d8',	'',	'2016-08-01 20:51:19',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16692384283',	'+14252338984',	'+16692384283',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAc4ce64b54bd30a2530af38f9d1f81ffa',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(426,	'CA8fad71be933c2ba6997332656befd4e0',	'',	'2016-08-02 18:20:13',	'US',	'',	'CA',	'',	'US',	'91403',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13237987338',	'+19513741928',	'+13237987338',	NULL,	NULL,	NULL,	NULL,	'SHERMAN OAKS',	'CA',	'CA821bb0a43e2b2a5c25560650557b4330',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(427,	'CA494b8af07bff139f60e065d94d8101ac',	'',	'2016-08-02 18:26:50',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'91403',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13237987338',	'+16612439350',	'+13237987338',	NULL,	NULL,	NULL,	NULL,	'SHERMAN OAKS',	'CA',	'CAdd8df46dd5730e2b5ae353ffae494192',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(428,	'CAab10116c11f328c4023207e0de79fc86',	'',	'2016-08-03 22:32:26',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'91934',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16193639129',	'+16612439350',	'+16193639129',	NULL,	NULL,	NULL,	NULL,	'PINE VALLEY',	'CA',	'CAab10116c11f328c4023207e0de79fc86',	'+14062509831',	'completed',	4,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE8de71d79476d52da71f740ccf8b54447',	0,	0,	'',	''),
(429,	'CA710af7cbfbf17085e9c3e553b6abf053',	'',	'2016-08-03 22:41:54',	'US',	'',	'CA',	'',	'US',	'91934',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16193639129',	'+19513741928',	'+16193639129',	NULL,	NULL,	NULL,	NULL,	'PINE VALLEY',	'CA',	'CA710af7cbfbf17085e9c3e553b6abf053',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(430,	'CA85f8226e82f7608a0039c426389531de',	'',	'2016-08-04 20:00:44',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18003246956',	'+19513741928',	'+18003246956',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA4288f8d29f8de6707721a6971d869a34',	'+14062509831',	'voicemail',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE9d6d7c9a46124a58c9e461bb7100d99c',	0,	0,	'',	''),
(431,	'CAd3dd9afdf473fbae7834a521fddb7c97',	'',	'2016-08-04 20:25:01',	'US',	'',	'CA',	'',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747016',	'+19513741928',	'+12096747016',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CAd3dd9afdf473fbae7834a521fddb7c97',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(432,	'CA73810c3cbd73adbc78e5784beb496a6a',	'',	'2016-08-04 20:58:02',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747016',	'+16612439350',	'+12096747016',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CA73810c3cbd73adbc78e5784beb496a6a',	'+14062509831',	'completed',	6,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE0352e5eef03d9a4f70894cc41dfbafac',	0,	0,	'',	''),
(433,	'CAe3ab1a4f81c0b800c2b2abb7217e303c',	'',	'2016-08-05 18:23:22',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12094075029',	'+16612439350',	'+12094075029',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA8ee41bcd51e2fe13d19216f74b923bfc',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(434,	'CAac74a3cd67846d96ea1b533d9120bb06',	'',	'2016-08-05 20:37:35',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12094075029',	'+19513741928',	'+12094075029',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAac74a3cd67846d96ea1b533d9120bb06',	'+14062509831',	'no-answer',	4,	NULL,	0,	0,	'',	''),
(435,	'CA9de59d334ac6cc636edfd5a9246768a7',	'',	'2016-08-05 21:07:39',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12094075029',	'+19162627163',	'+12094075029',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA9de59d334ac6cc636edfd5a9246768a7',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(436,	'CA9f9aa07a79ebc4b7c10fc6419f3e4704',	'',	'2016-08-06 14:51:44',	'US',	'59105',	'MT',	'BILLINGS',	'US',	'59404',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14065643003',	'+14062151971',	'+14065643003',	NULL,	NULL,	NULL,	NULL,	'GREAT FALLS',	'MT',	'CA9f9aa07a79ebc4b7c10fc6419f3e4704',	'+14068850281',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE0be358f4fa9ea7292a622ddc7329c784',	0,	0,	'',	''),
(437,	'CA64cf98a5549b30c9a2f0d2752226d0bd',	'',	'2016-08-15 18:51:57',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16692384311',	'+16612439350',	'+16692384311',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA64cf98a5549b30c9a2f0d2752226d0bd',	'+14062509831',	'no-answer',	6,	NULL,	0,	0,	'',	''),
(438,	'CAcb3ef871de3138911a4e6b96f19d6f90',	'',	'2016-08-15 18:53:37',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16692384311',	'+19513741928',	'+16692384311',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAcb3ef871de3138911a4e6b96f19d6f90',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(439,	'CA7b2ec33d535d8f8bc35bedcde57ba794',	'',	'2016-08-15 20:51:45',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16692384311',	'+14252338984',	'+16692384311',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA7b2ec33d535d8f8bc35bedcde57ba794',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(440,	'CA132bf1f5c0870f93dbc44701c5ce2a75',	'',	'2016-08-15 23:29:00',	'US',	'',	'CA',	'',	'US',	'93444',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18059315906',	'+18053945786',	'+18059315906',	NULL,	NULL,	NULL,	NULL,	'NIPOMO',	'CA',	'CA132bf1f5c0870f93dbc44701c5ce2a75',	'+18053544241',	'completed',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE683fa78467afc518d77b555a9d05b086',	0,	0,	'',	''),
(441,	'CAbf987186bfa20b9822cca313cb521d05',	'',	'2016-08-16 18:29:50',	'US',	'',	'CA',	'',	'US',	'92614',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14242177818',	'+19513741928',	'+14242177818',	NULL,	NULL,	NULL,	NULL,	'IRVINE',	'CA',	'CAbf987186bfa20b9822cca313cb521d05',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(442,	'CA529d9e9dca5ec852d5dc00aaba8a3166',	'',	'2016-08-16 18:35:23',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'92614',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14242177818',	'+16612439350',	'+14242177818',	NULL,	NULL,	NULL,	NULL,	'IRVINE',	'CA',	'CA529d9e9dca5ec852d5dc00aaba8a3166',	'+14062509831',	'no-answer',	6,	NULL,	0,	0,	'',	''),
(443,	'CA818107d1e44cb7975ac6cef1ebc16abb',	'',	'2016-08-16 19:01:46',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19253930739',	'+19162627163',	'+19253930739',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA818107d1e44cb7975ac6cef1ebc16abb',	'+14062509831',	'completed',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4e29257d8ce115cd9c66a3f33d8af71c',	0,	0,	'',	''),
(444,	'CA75c6dce9e784944d84a2357993efeabb',	'',	'2016-08-16 20:43:59',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'92614',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14242177818',	'+14252338984',	'+14242177818',	NULL,	NULL,	NULL,	NULL,	'IRVINE',	'CA',	'CA3f2265659426402cb409b49e9df408fd',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(445,	'CA78874ef1b5dae187751c42befeb6c27b',	'',	'2016-08-17 16:55:32',	'US',	'71101',	'LA',	'SHREVEPORT',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13189007977',	'+13187717327',	'+13189007977',	NULL,	NULL,	NULL,	NULL,	'',	'LA',	'CA78874ef1b5dae187751c42befeb6c27b',	'+13186316433',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(446,	'CA51b704582a6687b295d9194ea799dd70',	'',	'2016-08-17 17:48:44',	'US',	'',	'CA',	'',	'US',	'92506',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19515306007',	'+19513741928',	'+19515306007',	NULL,	NULL,	NULL,	NULL,	'RIVERSIDE',	'CA',	'CA51b704582a6687b295d9194ea799dd70',	'+14062509831',	'completed',	18,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REbb44dbfe143917b9183d7126470fd60b',	0,	0,	'',	''),
(447,	'CAe358e755b888f12b8e8acc59edd72cd5',	'',	'2016-08-17 17:49:43',	'US',	'',	'CA',	'',	'US',	'92506',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19515306007',	'+19513741928',	'+19515306007',	NULL,	NULL,	NULL,	NULL,	'RIVERSIDE',	'CA',	'CAe358e755b888f12b8e8acc59edd72cd5',	'+14062509831',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3a342cb6e24f2ff303e977112b0966c5',	0,	0,	'',	''),
(448,	'CA2e4af55a831096889139f08ca33578b6',	'',	'2016-08-17 20:36:14',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19493596862',	'+19513741928',	'+19493596862',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA2e4af55a831096889139f08ca33578b6',	'+14062509831',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE5b86b626297195ee7b47ef9245cedd45',	0,	0,	'',	''),
(449,	'CA0783ceaf41dd97aef242138c3e11a0ef',	'',	'2016-08-17 21:04:22',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19493596862',	'+16612439350',	'+19493596862',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA0783ceaf41dd97aef242138c3e11a0ef',	'+14062509831',	'no-answer',	6,	NULL,	0,	0,	'',	''),
(450,	'CAf1f76917d9778c0081c562f922bf01ee',	'',	'2016-08-18 20:08:50',	'US',	'',	'CA',	'',	'US',	'92199',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18582051834',	'+19513741928',	'+18582051834',	NULL,	NULL,	NULL,	NULL,	'SAN DIEGO',	'CA',	'CAf1f76917d9778c0081c562f922bf01ee',	'+14062509831',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa0ea594e85b24ebcfb67ac25dcd6b2c6',	0,	0,	'',	''),
(451,	'CA2a92761c359de3849fc902a385559c65',	'',	'2016-08-18 20:36:11',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'92199',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18582051834',	'+16612439350',	'+18582051834',	NULL,	NULL,	NULL,	NULL,	'SAN DIEGO',	'CA',	'CA2a92761c359de3849fc902a385559c65',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(452,	'CA4689b35ffe454bd5cea92d4cfb310262',	'',	'2016-08-18 20:56:44',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'92199',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18582051834',	'+14252338984',	'+18582051834',	NULL,	NULL,	NULL,	NULL,	'SAN DIEGO',	'CA',	'CA4689b35ffe454bd5cea92d4cfb310262',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(453,	'CA26b7185ed1d8f17ef4defa77ba6cd192',	'',	'2016-08-19 18:12:11',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15304445505',	'+16612439350',	'+15304445505',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAbccfe8a4ac603c59bedff4514ad27b12',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(454,	'CA33faa5296cac326a0cd8099155316352',	'',	'2016-08-19 18:14:22',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15304445505',	'+19513741928',	'+15304445505',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA33faa5296cac326a0cd8099155316352',	'+14062509831',	'completed',	4,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE8f3044ab22c6ed2e27b034da5cc1b5ec',	0,	0,	'',	''),
(455,	'CAac9c252bb2b1f6353531b60f38d12b7a',	'',	'2016-08-19 21:52:47',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15304445505',	'+19162627163',	'+15304445505',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA32039349c6516904ef4fd942ae7d8629',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(456,	'CA20d008dff13a6d48ce51add74746a252',	'',	'2016-08-22 18:40:04',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19167588643',	'+16612439350',	'+19167588643',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA20d008dff13a6d48ce51add74746a252',	'+14062509831',	'no-answer',	6,	NULL,	0,	0,	'',	''),
(457,	'CAf8ed608a1045681539946b29e0fa00b3',	'',	'2016-08-22 18:50:33',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19167588643',	'+19513741928',	'+19167588643',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAf8ed608a1045681539946b29e0fa00b3',	'+14062509831',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE126fb480a7fface8486c9c4bba1186aa',	0,	0,	'',	''),
(458,	'CA29dbacb6d8dbf57b3dc699d25bfec9ad',	'',	'2016-08-23 18:49:51',	'US',	'',	'CA',	'',	'US',	'95910',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15302901417',	'+19513741928',	'+15302901417',	NULL,	NULL,	NULL,	NULL,	'ALLEGHANY',	'CA',	'CA29dbacb6d8dbf57b3dc699d25bfec9ad',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(459,	'CA0a30f6cdf27083e88ec358046bca9113',	'',	'2016-08-23 20:18:21',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'95910',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15302901417',	'+16612439350',	'+15302901417',	NULL,	NULL,	NULL,	NULL,	'ALLEGHANY',	'CA',	'CA0a30f6cdf27083e88ec358046bca9113',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(460,	'CA107a3572d4b1f586c3421881e18fc70d',	'',	'2016-08-24 03:12:47',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18002157671',	'+19513741928',	'+18002157671',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA107a3572d4b1f586c3421881e18fc70d',	'+14062509831',	'completed',	66,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4a7d076fde10c8a98c5d8dcc6700e389',	0,	0,	'',	''),
(461,	'CAd2852db897066aaaf95e678c193d4950',	'',	'2016-08-24 18:38:57',	'US',	'',	'CA',	'',	'US',	'93203',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16612470132',	'+19513741928',	'+16612470132',	NULL,	NULL,	NULL,	NULL,	'ARVIN',	'CA',	'CAd2852db897066aaaf95e678c193d4950',	'+14062509831',	'completed',	3,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa8eb021dd200d5136c5b172ef08a1138',	0,	0,	'',	''),
(462,	'CA51c6cf5d9d196286bf8a2953a5e0f46c',	'',	'2016-08-24 18:47:24',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'93203',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16612470132',	'+16612439350',	'+16612470132',	NULL,	NULL,	NULL,	NULL,	'ARVIN',	'CA',	'CA51c6cf5d9d196286bf8a2953a5e0f46c',	'+14062509831',	'no-answer',	6,	NULL,	0,	0,	'',	''),
(463,	'CAa88369856922cee72b84a59efa5aed76',	'',	'2016-08-24 20:57:52',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'93203',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16612470132',	'+19162627163',	'+16612470132',	NULL,	NULL,	NULL,	NULL,	'ARVIN',	'CA',	'CA1428a0c2b29de8e574066426505638aa',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(464,	'CAcceb4b2fa29021e9a9e6d61c0ab5f3d8',	'',	'2016-08-25 20:46:42',	'US',	'',	'CA',	'',	'US',	'95910',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15302901343',	'+19513741928',	'+15302901343',	NULL,	NULL,	NULL,	NULL,	'ALLEGHANY',	'CA',	'CAcceb4b2fa29021e9a9e6d61c0ab5f3d8',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(465,	'CA647c6056093322222fc26082d95434d2',	'',	'2016-08-25 21:17:35',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'95910',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15302901343',	'+16612439350',	'+15302901343',	NULL,	NULL,	NULL,	NULL,	'ALLEGHANY',	'CA',	'CA647c6056093322222fc26082d95434d2',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(466,	'CAe70d5d236a8ada3c42b37ba10ace75b4',	'',	'2016-08-25 23:20:39',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'92004',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17608579523',	'+16612439350',	'+17608579523',	NULL,	NULL,	NULL,	NULL,	'RANCHITA',	'CA',	'CA1a3bd01d493d4dda18bfdb0b45a01192',	'+14062509831',	'voicemail',	20,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE45333a83d427a4fd7ee0199f9595d261',	0,	0,	'',	''),
(467,	'CA66e2f8aa9a469a5461c1d365535c99d6',	'',	'2016-08-26 20:24:35',	'US',	'',	'CA',	'',	'US',	'93012',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18057387151',	'+19513741928',	'+18057387151',	NULL,	NULL,	NULL,	NULL,	'CAMARILLO',	'CA',	'CA66e2f8aa9a469a5461c1d365535c99d6',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(468,	'CA60fe8d8c3f6cf4454489dc2535156927',	'',	'2016-08-26 20:25:44',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'93012',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18057387151',	'+16612439350',	'+18057387151',	NULL,	NULL,	NULL,	NULL,	'CAMARILLO',	'CA',	'CA60fe8d8c3f6cf4454489dc2535156927',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(469,	'CAf9ea8b7b089996a23e47150f72e85dda',	'',	'2016-08-26 22:57:53',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'93012',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18057387151',	'+19162627163',	'+18057387151',	NULL,	NULL,	NULL,	NULL,	'CAMARILLO',	'CA',	'CAa700dc407a14a0c85c54b0a8d989df0b',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(470,	'CA0c0a4109d949bfded1b692c2e90ffe17',	'',	'2016-08-29 20:35:17',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'95910',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15302901330',	'+16612439350',	'+15302901330',	NULL,	NULL,	NULL,	NULL,	'ALLEGHANY',	'CA',	'CA6e48eee99861d122342db8a557994aa1',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(471,	'CA96ba7f8c927efc2c66335cfebe22bd80',	'',	'2016-08-29 20:38:45',	'US',	'',	'CA',	'',	'US',	'95910',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15302901330',	'+19513741928',	'+15302901330',	NULL,	NULL,	NULL,	NULL,	'ALLEGHANY',	'CA',	'CA96ba7f8c927efc2c66335cfebe22bd80',	'+14062509831',	'completed',	6,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe0bb43aba8727d6b425206ce25966815',	0,	0,	'',	''),
(472,	'CAcb6c0e63c8eb01e0c81f23a4c4d262ec',	'',	'2016-08-29 23:35:30',	'US',	'',	'CA',	'',	'US',	'92084',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19513741928',	'+17603308325',	NULL,	NULL,	NULL,	NULL,	'VISTA',	'CA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(473,	'CAdacf738edb8bcdf56c07184836408534',	'',	'2016-08-30 19:41:19',	'US',	'',	'CA',	'',	'US',	'92084',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17603308325',	'+19513741928',	'+17603308325',	NULL,	NULL,	NULL,	NULL,	'VISTA',	'CA',	'CAdacf738edb8bcdf56c07184836408534',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(474,	'CA9b8801f63a86dab9cd0b6db59f769602',	'',	'2016-08-30 20:01:57',	'US',	'',	'CA',	'',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747128',	'+19513741928',	'+12096747128',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CA9b8801f63a86dab9cd0b6db59f769602',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(475,	'CAe04a0e64bdce711ab3196c91423f72f1',	'',	'2016-08-30 20:27:43',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747128',	'+16612439350',	'+12096747128',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CAe04a0e64bdce711ab3196c91423f72f1',	'+14062509831',	'no-answer',	6,	NULL,	0,	0,	'',	''),
(476,	'CA84a415f6ce0c2ceaafbdf3516b081f35',	'',	'2016-08-30 21:46:45',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747128',	'+19162627163',	'+12096747128',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CA84a415f6ce0c2ceaafbdf3516b081f35',	'+14062509831',	'no-answer',	6,	NULL,	0,	0,	'',	''),
(477,	'CAd3d0d4b7a0c41b4d5fcb0ec8ca5faacf',	'',	'2016-08-30 22:05:13',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747128',	'+14252338984',	'+12096747128',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CAd3d0d4b7a0c41b4d5fcb0ec8ca5faacf',	'+14062509831',	'no-answer',	6,	NULL,	0,	0,	'',	''),
(478,	'CA49aebea1ed22ac2de34674fd9702e682',	'',	'2016-08-31 15:24:35',	'US',	'39216',	'MS',	'JACKSON',	'US',	'39073',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16016641410',	'+16013688049',	'+16016641410',	NULL,	NULL,	NULL,	NULL,	'JACKSON',	'MS',	'CA49aebea1ed22ac2de34674fd9702e682',	'+16014545243',	'completed',	33,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE700793514472374ddab0eb78fd89ff63',	0,	0,	'',	''),
(479,	'CA3738e08a971627f0fdbb53fade952091',	'',	'2016-08-31 20:54:19',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16692384305',	'+19513741928',	'+16692384305',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA3738e08a971627f0fdbb53fade952091',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(480,	'CAc81ddf10613bb7b24399ba35f1fb1b15',	'',	'2016-08-31 20:57:21',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16692384305',	'+16612439350',	'+16692384305',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAc81ddf10613bb7b24399ba35f1fb1b15',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(481,	'CAd88bb3fcd7ccfa0e978a2c0710ed4cea',	'',	'2016-08-31 21:37:05',	'US',	'',	'CA',	'',	'US',	'92084',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17603308325',	'+19513741928',	'+17603308325',	NULL,	NULL,	NULL,	NULL,	'VISTA',	'CA',	'CA4ab69540d41916e05aa0fb94beb9db51',	'+14062509831',	'voicemail',	2,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE7c0b315d5db53d463874e4023f7d2b33',	0,	0,	'',	''),
(482,	'CA1535fee8dcc9eddd6e28b98e6eb790ff',	'',	'2016-08-31 21:43:36',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'93306',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16613241195',	'+16612439350',	'+16613241195',	NULL,	NULL,	NULL,	NULL,	'BAKERSFIELD',	'CA',	'CAe035ae5f3bbfaa409820bc2267335070',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(483,	'CAc686190839e1b4182b4194a9c51bd33e',	'',	'2016-08-31 22:39:19',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16692384305',	'+19162627163',	'+16692384305',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAc686190839e1b4182b4194a9c51bd33e',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(484,	'CA4fbc5a1f5c9fdb307e00ac7b70b77d5d',	'',	'2016-08-31 23:59:19',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+14252338984',	'+14156535217',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(485,	'CAd1cb0643d54fe364fa43facac2b2fb60',	'',	'2016-08-31 23:59:26',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14156535217',	'+14252338984',	'+14156535217',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAd1cb0643d54fe364fa43facac2b2fb60',	'+14062509831',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE9ffad6cb3df4e432519c711610c4001e',	0,	0,	'',	''),
(486,	'CAc8ec5047040a4373c09023c662aecdc1',	'',	'2016-08-31 23:59:53',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14156535217',	'+14252338984',	'+14156535217',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAc8ec5047040a4373c09023c662aecdc1',	'+14062509831',	'completed',	55,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE559e869c4cfac569d5e6e371ea376e7a',	0,	0,	'',	''),
(487,	'CA0443f44ac63545d625ae0f1e82bd4c42',	'',	'2016-09-02 18:22:45',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'33069',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19547732510',	'+16612439350',	'+19547732510',	NULL,	NULL,	NULL,	NULL,	'POMPANO BEACH',	'FL',	'CA0443f44ac63545d625ae0f1e82bd4c42',	'+14062509831',	'completed',	34,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE00ce79b257c15e6ffe2c00d3a0e637af',	0,	0,	'',	''),
(488,	'CA0990c51aa1ee11843838fb6df42828aa',	'',	'2016-09-02 19:16:55',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'95910',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15302901345',	'+16612439350',	'+15302901345',	NULL,	NULL,	NULL,	NULL,	'ALLEGHANY',	'CA',	'CA13f62f966fe2462c0ec19bb6fe1aae51',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(489,	'CA5f1714c79d04837244afec63661ad281',	'',	'2016-09-02 19:22:16',	'US',	'',	'CA',	'',	'US',	'95910',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15302901345',	'+19513741928',	'+15302901345',	NULL,	NULL,	NULL,	NULL,	'ALLEGHANY',	'CA',	'CA5f1714c79d04837244afec63661ad281',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(490,	'CAe4d02817c4cdedad94d60106a8f12a44',	'',	'2016-09-06 20:58:03',	'US',	'',	'CA',	'',	'US',	'93203',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16612470112',	'+19513741928',	'+16612470112',	NULL,	NULL,	NULL,	NULL,	'ARVIN',	'CA',	'CA79f078ab4cb4c9ed5954d9362d70010a',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(491,	'CA54422dfd669ebbeb20652ee60ccdc523',	'',	'2016-09-06 21:24:25',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'93203',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16612470112',	'+14252338984',	'+16612470112',	NULL,	NULL,	NULL,	NULL,	'ARVIN',	'CA',	'CA3daa92de254f10d3bbfedc171df5b265',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(492,	'CAa92b652fed421d17f6cede51cdf520b5',	'',	'2016-09-07 21:33:14',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'91934',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16193639225',	'+16612439350',	'+16193639225',	NULL,	NULL,	NULL,	NULL,	'PINE VALLEY',	'CA',	'CAa92b652fed421d17f6cede51cdf520b5',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(493,	'CA22e1d156c3ae1d81a43846766638c005',	'',	'2016-09-07 21:47:19',	'US',	'',	'CA',	'',	'US',	'91934',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16193639225',	'+19513741928',	'+16193639225',	NULL,	NULL,	NULL,	NULL,	'PINE VALLEY',	'CA',	'CA06a46228c9de471805c2a8827c6a3508',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(494,	'CA047f335c96fb37aafedba265ee362bde',	'',	'2016-09-07 22:19:18',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'91934',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16193639225',	'+14252338984',	'+16193639225',	NULL,	NULL,	NULL,	NULL,	'PINE VALLEY',	'CA',	'CA207be2263a497da612d5e0a6b0c2b768',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(495,	'CAff4080c25040be0107f511663a3805f8',	'',	'2016-09-08 21:06:11',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'95910',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15302901658',	'+16612439350',	'+15302901658',	NULL,	NULL,	NULL,	NULL,	'ALLEGHANY',	'CA',	'CAff4080c25040be0107f511663a3805f8',	'+14062509831',	'no-answer',	6,	NULL,	0,	0,	'',	''),
(496,	'CA90dc3c0334120bf68082ffa4b29e4164',	'',	'2016-09-08 21:12:25',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'95910',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15302901658',	'+14252338984',	'+15302901658',	NULL,	NULL,	NULL,	NULL,	'ALLEGHANY',	'CA',	'CA90dc3c0334120bf68082ffa4b29e4164',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(497,	'CA0cd9f5f7501c98ef1b6a32ea38ec225e',	'',	'2016-09-09 03:44:40',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18005454315',	'+19513741928',	'+18005454315',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA0cd9f5f7501c98ef1b6a32ea38ec225e',	'+14062509831',	'completed',	66,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE8915c476b90adff3debc489cd419bfef',	0,	0,	'',	''),
(498,	'CA6538d060e5a3e9d10ad21fe1551d443f',	'',	'2016-09-09 18:54:55',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'21842',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13022890555',	'+14252338984',	'+13022890555',	NULL,	NULL,	NULL,	NULL,	'FELTON',	'DE',	'CA6538d060e5a3e9d10ad21fe1551d443f',	'+14062509831',	'completed',	40,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb10e7e059e166d9b0907be15b561fadb',	0,	0,	'',	''),
(499,	'CA4aaf98f6b75c200702d00f032da237d1',	'',	'2016-09-09 20:51:02',	'US',	'',	'CA',	'',	'US',	'95910',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15302901322',	'+19513741928',	'+15302901322',	NULL,	NULL,	NULL,	NULL,	'ALLEGHANY',	'CA',	'CA4aaf98f6b75c200702d00f032da237d1',	'+14062509831',	'no-answer',	6,	NULL,	0,	0,	'',	''),
(500,	'CAa5c710c85ed9330d38d43a23fc1927da',	'',	'2016-09-09 20:56:17',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'95910',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15302901322',	'+16612439350',	'+15302901322',	NULL,	NULL,	NULL,	NULL,	'ALLEGHANY',	'CA',	'CAa5c710c85ed9330d38d43a23fc1927da',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(501,	'CA88a1b294e015b27837b9ee7eb3f579c8',	'',	'2016-09-11 21:55:51',	'US',	'59105',	'MT',	'BILLINGS',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18006464697',	'+14062151971',	'+18006464697',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA88a1b294e015b27837b9ee7eb3f579c8',	'+14068850281',	'completed',	3,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe14ba7bf6eabd22473eca0ed7e28de27',	0,	0,	'',	''),
(502,	'CAec8ab0e8f158e7072953b684ed2070e3',	'',	'2016-09-12 20:40:31',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16692384358',	'+16612439350',	'+16692384358',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAf184ac13188a8649100739a07a54af16',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(503,	'CA9d99180c11ae2717157f76edcc3301ea',	'',	'2016-09-12 21:21:38',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16692384358',	'+19513741928',	'+16692384358',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA9d99180c11ae2717157f76edcc3301ea',	'+14062509831',	'completed',	4,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE67b288e1bb3a4caec64208df5a2da2ae',	0,	0,	'',	''),
(504,	'CA388d97f03c61524c3b62c114ae9dc7b7',	'',	'2016-09-12 21:43:59',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95822',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19162623731',	'+19162627163',	'+19162623731',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CA388d97f03c61524c3b62c114ae9dc7b7',	'+14062509831',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa49c6e57c306cbc52ff947cf3a76087d',	0,	0,	'',	''),
(505,	'CA5d82a70ca714702a1dfbb727120942ce',	'',	'2016-09-12 22:18:57',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16692384358',	'+14252338984',	'+16692384358',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA293af45e81496436d9647bbae826f937',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(506,	'CAfaa69e2a187329a5c77638273469117e',	'',	'2016-09-13 14:37:52',	'US',	'',	'CA',	'',	'US',	'46534',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15743760535',	'+19513741928',	'+15743760535',	NULL,	NULL,	NULL,	NULL,	'KNOX',	'IN',	'CAfaa69e2a187329a5c77638273469117e',	'+14062509831',	'completed',	12,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4fd655ffc4f2454b79ac28d79af1ec55',	0,	0,	'',	''),
(507,	'CAe16fd1907519d8f7b5348f850cf05c6c',	'',	'2016-09-13 14:38:38',	'US',	'',	'CA',	'',	'US',	'46534',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15743760535',	'+19513741928',	'+15743760535',	NULL,	NULL,	NULL,	NULL,	'KNOX',	'IN',	'CAe16fd1907519d8f7b5348f850cf05c6c',	'+14062509831',	'completed',	4,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf0183057a5abfc54aaa5a3dd377c99b7',	0,	0,	'',	''),
(508,	'CA3c672e78cd0225aab19a2d68716b83c0',	'',	'2016-09-13 18:39:04',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'95910',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15302901444',	'+16612439350',	'+15302901444',	NULL,	NULL,	NULL,	NULL,	'ALLEGHANY',	'CA',	'CA3c672e78cd0225aab19a2d68716b83c0',	'+14062509831',	'no-answer',	6,	NULL,	0,	0,	'',	''),
(509,	'CA5e7ed296b304a31356ee71d76c52cf55',	'',	'2016-09-13 21:29:56',	'US',	'',	'CA',	'',	'US',	'95910',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15302901444',	'+19513741928',	'+15302901444',	NULL,	NULL,	NULL,	NULL,	'ALLEGHANY',	'CA',	'CA5e7ed296b304a31356ee71d76c52cf55',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(510,	'CA0c702752fdbefac3953b36b4d32c0c15',	'',	'2016-09-14 03:18:10',	'US',	'59105',	'MT',	'BILLINGS',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18002695953',	'+14062151971',	'+18002695953',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA0c702752fdbefac3953b36b4d32c0c15',	'+14068850281',	'completed',	3,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE477a37fe4e9eca4718fc81302a13ea6d',	0,	0,	'',	''),
(511,	'CA76291f9a020d0e66e7a548df94b56476',	'',	'2016-09-14 17:39:56',	'US',	'30308',	'GA',	'ATLANTA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12294747287',	'+12294695960',	'+12294747287',	NULL,	NULL,	NULL,	NULL,	'',	'GA',	'CA76291f9a020d0e66e7a548df94b56476',	'+12294697257',	'completed',	28,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe768a9f3b78269b2103456ae75f19e9c',	0,	0,	'',	''),
(512,	'CAe333d389b9874ace30d77913a69082a4',	'',	'2016-09-14 20:59:17',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'94103',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16283336427',	'+16612439350',	'+16283336427',	NULL,	NULL,	NULL,	NULL,	'San Francisco',	'CA',	'CAd5be7589f0ac58e6020a9f2cbbab1cba',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(513,	'CA2c7a1c5f4c5b87481c964768a00d944e',	'',	'2016-09-15 20:21:25',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12028005635',	'+14062099330',	'+12028005635',	NULL,	NULL,	NULL,	NULL,	'',	'District Of Columbia',	'CA2c7a1c5f4c5b87481c964768a00d944e',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(514,	'CA37654459fcef7ac2373c919f76aac091',	'',	'2016-09-15 20:28:16',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19167588603',	'+16612439350',	'+19167588603',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAa05c299b98f38c6c0a704bca957b42b6',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(515,	'CA12c161591eeeab2c414dd1a7131e8535',	'',	'2016-09-15 21:07:28',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19167588603',	'+19513741928',	'+19167588603',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAc8efd122b0fbb343e0aa3dc7f1e90344',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(516,	'CAfe9d3b92f7c3848740c3c6d5278892d0',	'',	'2016-09-16 21:10:04',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16692384334',	'+16612439350',	'+16692384334',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA8843767894e511ab001f7f036af9919f',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(517,	'CA8bb23ae1d32a1eac2301824ec49cdd98',	'',	'2016-09-16 21:17:12',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16692384334',	'+19513741928',	'+16692384334',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA8bb23ae1d32a1eac2301824ec49cdd98',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(518,	'CA5619fa15d4efcc1d03232ca09ebfac9d',	'',	'2016-09-17 14:53:03',	'US',	'71101',	'LA',	'SHREVEPORT',	'US',	'34788',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13525048263',	'+13187717327',	'+13525048263',	NULL,	NULL,	NULL,	NULL,	'LEESBURG',	'FL',	'CA5619fa15d4efcc1d03232ca09ebfac9d',	'+13186316433',	'completed',	16,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4871b90d65340f1443948a5e935fcefd',	0,	0,	'',	''),
(519,	'CAd5d654c8f0f2dcbacfbf27b416dd4261',	'',	'2016-09-17 14:53:46',	'US',	'71101',	'LA',	'SHREVEPORT',	'US',	'34788',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13525048263',	'+13187717327',	'+13525048263',	NULL,	NULL,	NULL,	NULL,	'LEESBURG',	'FL',	'CAd5d654c8f0f2dcbacfbf27b416dd4261',	'+13186316433',	'completed',	18,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4779050bf54888f7b2b733a7b2947c7e',	0,	0,	'',	''),
(520,	'CA2196a820ae799a15b00d9f3e706e9e78',	'',	'2016-09-17 22:32:34',	'US',	'59105',	'MT',	'BILLINGS',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18009876519',	'+14062151971',	'+18009876519',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA2196a820ae799a15b00d9f3e706e9e78',	'+14068850281',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(521,	'CAc937576bfbc32d6a5583fb615a48b064',	'',	'2016-09-19 20:34:34',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'94103',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16283336421',	'+16612439350',	'+16283336421',	NULL,	NULL,	NULL,	NULL,	'San Francisco',	'CA',	'CAc937576bfbc32d6a5583fb615a48b064',	'+14062509831',	'completed',	1,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE560a24aaacf84222687ee5912e850d49',	0,	0,	'',	''),
(522,	'CAa01a8d6bfb9e02a78d0f59bff8f89744',	'',	'2016-09-19 22:44:24',	'US',	'',	'CA',	'',	'US',	'94103',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16283336421',	'+19513741928',	'+16283336421',	NULL,	NULL,	NULL,	NULL,	'San Francisco',	'CA',	'CAb16044811e9b1fd8ec1bc08e1f789aa5',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(523,	'CA2eac92411fbfb556d586bd7d624f2ad1',	'',	'2016-09-20 20:27:19',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19167588693',	'+19513741928',	'+19167588693',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA2eac92411fbfb556d586bd7d624f2ad1',	'+14062509831',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE26d18cdf67a6f4db60a0b67ee87c1d1e',	0,	0,	'',	''),
(524,	'CA50077b9a75f8a4a04dc293997db4a896',	'',	'2016-09-20 20:33:35',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19167588693',	'+16612439350',	'+19167588693',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA2300e3f1bb5e9008429d44d464ac583b',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(525,	'CA72aa12176ef66afbeff2a32ff6e3a36e',	'',	'2016-09-20 21:53:18',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14252094997',	'+14252338984',	'+14252094997',	NULL,	NULL,	NULL,	NULL,	'',	'WA',	'CA2626e6689a0e3c8d6d40a522c4b3632b',	'+14062509831',	'voicemail',	32,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE92d0ce67a7ee68b29fceca6f8fa7b244',	0,	0,	'',	''),
(526,	'CA16f782263eb85db360d09aa261b83c74',	'',	'2016-09-20 22:05:21',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19167588693',	'+14252338984',	'+19167588693',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA16f782263eb85db360d09aa261b83c74',	'+14062509831',	'completed',	3,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE5a933e6c3790f7268c755443a03e5b9f',	0,	0,	'',	''),
(527,	'CAa43223f9f4e50b20662e07cc5485baf3',	'',	'2016-09-20 22:30:14',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19167588693',	'+19162627163',	'+19167588693',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAa43223f9f4e50b20662e07cc5485baf3',	'+14062509831',	'completed',	2,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd65eefe8d34b4275c47db00f7b54f114',	0,	0,	'',	''),
(528,	'CA958c47c1dd3d9f8ba644c652ef43881b',	'',	'2016-09-21 21:56:56',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19167588693',	'+19513741928',	'+19167588693',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAc2b07c4d3611b92584128b932d793c72',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(529,	'CA0b02b497c4595dedd74c7d2c30329a44',	'',	'2016-09-21 22:04:48',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19167588693',	'+16612439350',	'+19167588693',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA7b12bad6c176d40e4e3b6519e933fa4e',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(530,	'CA82171a525463b5774905e7f4cdd933bb',	'',	'2016-09-22 17:37:50',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'46240',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13177156266',	'+19162627163',	'+13177156266',	NULL,	NULL,	NULL,	NULL,	'INDIANAPOLIS',	'IN',	'CA1bc0ca3f5679ef9672761cb4ab9074ab',	'+14062509831',	'voicemail',	15,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3b0f595da646f63b2857513c13738a0b',	0,	0,	'',	''),
(531,	'CA91ac161a0aea3bab58dcd8af8d8ad157',	'',	'2016-09-22 18:11:58',	'US',	'',	'CA',	'',	'US',	'46278',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19513741928',	'+13178039458',	NULL,	NULL,	NULL,	NULL,	'INDIANAPOLIS',	'IN',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(532,	'CA46eddccd635ef47a18233f5a0c77278d',	'',	'2016-09-22 18:37:48',	'US',	'59105',	'MT',	'BILLINGS',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18009876519',	'+14062151971',	'+18009876519',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA46eddccd635ef47a18233f5a0c77278d',	'+14068850281',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(533,	'CA74b96061f8ffc5200676e868b2ba1e05',	'',	'2016-09-22 20:08:23',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'46278',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13178083429',	'+14252338984',	'+13178083429',	NULL,	NULL,	NULL,	NULL,	'INDIANAPOLIS',	'IN',	'CAb98567b0f4cb5e804b8332a97dda615f',	'+14062509831',	'voicemail',	15,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE9c534bf459bd22cb07892f1de1b32496',	0,	0,	'',	''),
(534,	'CA3c59c661ec7b1f442ecf003a37342788',	'',	'2016-09-22 21:29:33',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747031',	'+16612439350',	'+12096747031',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CA3c59c661ec7b1f442ecf003a37342788',	'+14062509831',	'completed',	1,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa102a9cf48678216b95f3d19f424beb8',	0,	0,	'',	''),
(535,	'CAbb46b234f64933f1b621abeaa8f1841a',	'',	'2016-09-22 22:34:04',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747031',	'+19162627163',	'+12096747031',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CAed6c2e5db934a16464ad5ea8f59af78b',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(536,	'CA96d6cfea110c094661e964937225f4ea',	'',	'2016-09-23 21:06:22',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747031',	'+16612439350',	'+12096747031',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CA51fbb6ffbae4d81336f7d3f02bc95459',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(537,	'CAc40ae0546e21505071f0ba2602029d22',	'',	'2016-09-23 21:25:31',	'US',	'',	'CA',	'',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747031',	'+19513741928',	'+12096747031',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CA34e05a3e607569ecc9305a7acbdcf0b9',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(538,	'CAcc219edf05897a9fec84bee44315e51e',	'',	'2016-09-26 03:24:47',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18006464697',	'+19513741928',	'+18006464697',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CAcc219edf05897a9fec84bee44315e51e',	'+14062509831',	'completed',	80,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE8463da22b36b5d3a4aeecbbec29bd9a1',	0,	0,	'',	''),
(539,	'CA2fcfe0ec05c12a5f359394fc8e4fd829',	'',	'2016-09-26 22:27:08',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'94103',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16283336421',	'+16612439350',	'+16283336421',	NULL,	NULL,	NULL,	NULL,	'San Francisco',	'CA',	'CAc4cfc355a5e52277286b01480820fdb9',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(540,	'CA6421d28a0862cf816af3225e42b57a9d',	'',	'2016-09-26 22:32:04',	'US',	'',	'CA',	'',	'US',	'94103',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16283336421',	'+19513741928',	'+16283336421',	NULL,	NULL,	NULL,	NULL,	'San Francisco',	'CA',	'CA72dc09ef82e4ae299b5a93a6f3c672fb',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(541,	'CAb9d75862adf8353eaa11172b4b210030',	'',	'2016-09-27 18:09:14',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12094075146',	'+16612439350',	'+12094075146',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA4746acf9c75d1e867989c93e2b88c712',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(542,	'CA01d12fda814db930f7318fd5b0853f60',	'',	'2016-09-27 20:03:32',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'33301',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17542296614',	'+19162627163',	'+17542296614',	NULL,	NULL,	NULL,	NULL,	'FORT LAUDERDALE',	'FL',	'CA01d12fda814db930f7318fd5b0853f60',	'+14062509831',	'completed',	68,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE9a35a4748a03aa42bcb7886aa9ab5e16',	0,	0,	'',	''),
(543,	'CA477d773799933be421318627ac12aff4',	'',	'2016-09-27 20:38:28',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12094075146',	'+19513741928',	'+12094075146',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA8bade34c086cb7b553f53c02183c5eb3',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(544,	'CA9dbe420c02a99db87378340d4d696d6e',	'',	'2016-09-28 20:51:21',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19167588603',	'+19513741928',	'+19167588603',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA9dbe420c02a99db87378340d4d696d6e',	'+14062509831',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE11bdaf586c3e4876d0546373215d0136',	0,	0,	'',	''),
(545,	'CAdcb0da96199279a4f93561b666c75e17',	'',	'2016-09-28 20:51:24',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19167588603',	'+16612439350',	'+19167588603',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA9311265043ebd00a867e19984c8f557b',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(546,	'CA4d3e94c3fe037630bf2631eba45b9f52',	'',	'2016-09-28 21:43:19',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19167588603',	'+19162627163',	'+19167588603',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA1072047816a79212a7705e169464e986',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(547,	'CA2b4b7e3f620e7a3c6f360f2a528db403',	'',	'2016-09-29 19:46:22',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'30329',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14044005495',	'+14062099330',	'+14044005495',	NULL,	NULL,	NULL,	NULL,	'ATLANTA',	'GA',	'CA2b4b7e3f620e7a3c6f360f2a528db403',	'+14062509831',	'completed',	6,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE7b37ab747b4b0ada8ba8714d034d9aeb',	0,	0,	'',	''),
(548,	'CAcc48767fb73029e03409b9567730e1d9',	'',	'2016-09-29 19:56:36',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'93305',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16616954448',	'+16612439350',	'+16616954448',	NULL,	NULL,	NULL,	NULL,	'BAKERSFIELD',	'CA',	'CA5bb26333afb3e07313b6177abe634f8e',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(549,	'CA11fdfd94395f3bb1242f540c512370a2',	'',	'2016-09-30 18:53:14',	'US',	'',	'CA',	'',	'US',	'95910',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15302901498',	'+19513741928',	'+15302901498',	NULL,	NULL,	NULL,	NULL,	'ALLEGHANY',	'CA',	'CA2057fc36600fba7141662eb22943933a',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(550,	'CA0573b5067a273689f25c8c53f5e39387',	'',	'2016-09-30 20:04:44',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'95910',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15302901498',	'+16612439350',	'+15302901498',	NULL,	NULL,	NULL,	NULL,	'ALLEGHANY',	'CA',	'CAb043091ffdcbb67eeff723d61c6c7bc1',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(551,	'CA87534593d85b44740311f5c777dc9d8a',	'',	'2016-10-03 21:19:25',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'91934',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16193639167',	'+16612439350',	'+16193639167',	NULL,	NULL,	NULL,	NULL,	'PINE VALLEY',	'CA',	'CAf4953575c55170320084afbe8370841f',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(552,	'CAb2cff42fcdf3f7bde28654ae4848417e',	'',	'2016-10-03 21:22:07',	'US',	'',	'CA',	'',	'US',	'91934',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16193639167',	'+19513741928',	'+16193639167',	NULL,	NULL,	NULL,	NULL,	'PINE VALLEY',	'CA',	'CAa96452d0e55c3cf92f25f2eeb5c4d9cd',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(553,	'CA382940effa7476013732e3cbdfb7f5f2',	'',	'2016-10-04 18:51:47',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19166806168',	'+19513741928',	'+19166806168',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA2197816793193c1413515cc1d07bff7b',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(554,	'CA68c47333baace83ccb5b0da4577ba206',	'',	'2016-10-04 20:19:16',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19166806168',	'+16612439350',	'+19166806168',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAae68cd0632588790b1e4f895bda0ee64',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(555,	'CAefd29092d9e3c481bfeeb2d0369a0f99',	'',	'2016-10-04 22:30:45',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'94611',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15103887715',	'+19162627163',	'+15103887715',	NULL,	NULL,	NULL,	NULL,	'OAKLAND',	'CA',	'CAefd29092d9e3c481bfeeb2d0369a0f99',	'+14062509831',	'completed',	25,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE0dea26b19d882449e52b83c52e5e6ca4',	0,	0,	'',	''),
(556,	'CA2ad668529a584872c32a518a02602c5f',	'',	'2016-10-04 22:31:50',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'94611',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15103887715',	'+19162627163',	'+15103887715',	NULL,	NULL,	NULL,	NULL,	'OAKLAND',	'CA',	'CA2ad668529a584872c32a518a02602c5f',	'+14062509831',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE8a6c8b94da62537d72e3bd79c10e1262',	0,	0,	'',	''),
(557,	'CAff80b9a436dfeaad7d5b7abb1fbeb666',	'',	'2016-10-04 22:52:59',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19166806168',	'+19162627163',	'+19166806168',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA9a29b89d7863dbc24490ce4c9e212996',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(558,	'CA3965b04345c3858f4f7a1ec8850949d4',	'',	'2016-10-04 22:53:05',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19166806168',	'+19162627163',	'+19166806168',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA3965b04345c3858f4f7a1ec8850949d4',	'+14062509831',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REbff704490d16ac1c9c7511c690b4a790',	0,	0,	'',	''),
(559,	'CA291d08b56e2b0c082d925a39f5b968c2',	'',	'2016-10-05 17:22:38',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'06410',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12036516048',	'+14252338984',	'+12036516048',	NULL,	NULL,	NULL,	NULL,	'CHESHIRE',	'CT',	'CA291d08b56e2b0c082d925a39f5b968c2',	'+14062509831',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE056dfc0ca7fcb0abeb4954d36756954d',	0,	0,	'',	''),
(560,	'CA27ce64db94b520f4e0b884cba72582bd',	'',	'2016-10-05 20:21:27',	'US',	'',	'CA',	'',	'US',	'91934',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16193639158',	'+19513741928',	'+16193639158',	NULL,	NULL,	NULL,	NULL,	'PINE VALLEY',	'CA',	'CAa14544a3c83dfd01bf33408627a0b12e',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(561,	'CA8e5326719a67fe2d2271285a826788fb',	'',	'2016-10-05 20:36:11',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'91934',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16193639158',	'+16612439350',	'+16193639158',	NULL,	NULL,	NULL,	NULL,	'PINE VALLEY',	'CA',	'CA33a51dbb9ac0c98eef668c12a7dc0e4f',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(562,	'CA53e84feb7185dafc74da24674a7c1560',	'',	'2016-10-05 20:53:02',	'US',	'',	'CA',	'',	'US',	'92398',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19513741928',	'+17602578201',	NULL,	NULL,	NULL,	NULL,	'NEWBERRY SPRINGS',	'CA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(563,	'CA5822317f10b7b9203e0ef7d31ee9fa32',	'',	'2016-10-05 21:51:49',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'91934',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16193639158',	'+19162627163',	'+16193639158',	NULL,	NULL,	NULL,	NULL,	'PINE VALLEY',	'CA',	'CAd584085ec339e582d8c40c7d9a7f98d3',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(564,	'CAe8ff8616140e890b1eb7b62287c2f0c3',	'',	'2016-10-06 14:13:50',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95818',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19165889132',	'+19162627163',	'+19165889132',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CAe8ff8616140e890b1eb7b62287c2f0c3',	'+14062509831',	'completed',	3,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa0efe7d26cbb0ea86f37b1a014cffe3f',	0,	0,	'',	''),
(565,	'CA2f6ce6e277e1c6556d81fa4a44c6e258',	'',	'2016-10-06 14:32:40',	'US',	'',	'CA',	'',	'US',	'95818',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19165889132',	'+19513741928',	'+19165889132',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CA7de07b3e21aac1fbcd322b2588deaddb',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(566,	'CAd819eb875158a03c1f0c718a2e43f8f1',	'',	'2016-10-06 16:29:29',	'US',	'',	'CA',	'',	'US',	'92398',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17602578201',	'+19513741928',	'+17602578201',	NULL,	NULL,	NULL,	NULL,	'NEWBERRY SPRINGS',	'CA',	'CA8e0e34dabeac439e9bcab68d2e45e85d',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(567,	'CA5a41950fd516b02da7e7284dcbe0d34f',	'',	'2016-10-06 17:21:19',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16023623812',	'+14252338984',	'+16023623812',	NULL,	NULL,	NULL,	NULL,	'',	'AZ',	'CA78af19ffe50162a7c8fe11b9c0e642a0',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(568,	'CAef8f6c64e35c021de99647e968ad28a5',	'',	'2016-10-06 17:58:49',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19513392152',	'+19513741928',	'+19513392152',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA68b9e6ca9da1356bfaaeb3934e37b9b7',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(569,	'CA44428d0d11edfe449ccc5f50cf5647f3',	'',	'2016-10-06 18:01:03',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19513741928',	'+19513392152',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(570,	'CA92e8a2ef46fc42a413ff3e4cc9e8e90c',	'',	'2016-10-06 18:21:58',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18003787262',	'+19513741928',	'+18003787262',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA92e8a2ef46fc42a413ff3e4cc9e8e90c',	'+14062509831',	'completed',	48,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REec10c4f897ed7e92e5a90a50fa8f45f8',	0,	0,	'',	''),
(571,	'CA6db622f85434081099862875e5b73cb4',	'',	'2016-10-06 20:48:42',	'US',	'',	'CA',	'',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747101',	'+19513741928',	'+12096747101',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CAf07e38ab3c78615557f6c738b62351c2',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(572,	'CAe8c34349ae38cfe9c286b373d431b51f',	'',	'2016-10-06 22:11:54',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747101',	'+16612439350',	'+12096747101',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CA9554d9510e49d223d204a45610f2cc2c',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(573,	'CAa44600c60f5fa2514e68b1bca058d090',	'',	'2016-10-07 19:44:07',	'US',	'',	'CA',	'',	'US',	'92398',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19513741928',	'+17602578201',	NULL,	NULL,	NULL,	NULL,	'NEWBERRY SPRINGS',	'CA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(574,	'CAd06a06fef4de27d71005aec5ce388b5c',	'',	'2016-10-07 20:39:14',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13236120187',	'+19513741928',	'+13236120187',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA996b0376b61472a9b49f52b3782f99f0',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(575,	'CAa0580d33a86ff655971587e53d408e46',	'',	'2016-10-07 20:59:38',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13236120187',	'+16612439350',	'+13236120187',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAa42a928d1b6b5c9d26a4859214c60c78',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(576,	'CA4e95d8df44eb25f59c7fc61158a41cd2',	'',	'2016-10-07 21:25:04',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13236120187',	'+14252338984',	'+13236120187',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA6a38227f6ec44e493fd651d8ddc1f0f3',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(577,	'CAf2e290af3e70e031af79aeebd310f4fc',	'',	'2016-10-07 21:47:11',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13236120187',	'+19162627163',	'+13236120187',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA5da2163c51bc29b1edbd6c99586e19cb',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(578,	'CA2b71ec12d14368715e3a9e63ceb7f848',	'',	'2016-10-10 19:49:22',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'80239',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13032147352',	'+16612439350',	'+13032147352',	NULL,	NULL,	NULL,	NULL,	'AURORA',	'CO',	'CA2b71ec12d14368715e3a9e63ceb7f848',	'+14062509831',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE01cf6857885d1bcabaacd651ee361d5a',	0,	0,	'',	''),
(579,	'CA5ecdd7afa385b97e73fc95381d6cfd2e',	'',	'2016-10-10 20:51:49',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'90071',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13236010353',	'+16612439350',	'+13236010353',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CAa8c921748e70d8fae3878a51b5057b78',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(580,	'CA73815390a9eaad4684c7649c418aac5f',	'',	'2016-10-10 22:06:01',	'US',	'',	'CA',	'',	'US',	'90071',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13236010353',	'+19513741928',	'+13236010353',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA64b20da8f5d94cdeb69f9a261309d630',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(581,	'CA0c6ab2a4db7465a3d038cb6b89d8c236',	'',	'2016-10-11 00:07:57',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17867241910',	'+14252338984',	'+17867241910',	NULL,	NULL,	NULL,	NULL,	'',	'FL',	'CA0c6ab2a4db7465a3d038cb6b89d8c236',	'+14062509831',	'completed',	22,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE08505bb93250df49f272fce0478db6eb',	0,	0,	'',	''),
(582,	'CA06dc590b246457626ebfe719edaf89f6',	'',	'2016-10-11 20:29:35',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17078421007',	'+16612439350',	'+17078421007',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAd0c7dcc2a770e1a798e3ae5126b547dd',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(583,	'CAcc675d00ff9f3c1bd557b56a0ccca4ca',	'',	'2016-10-11 21:23:46',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17078421007',	'+19513741928',	'+17078421007',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAcc675d00ff9f3c1bd557b56a0ccca4ca',	'+14062509831',	'completed',	4,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE757cc9f7491d8a4e99d83a3a8a66d63b',	0,	0,	'',	''),
(584,	'CA4d6e87b472209cf6aa8b277bcd31eb57',	'',	'2016-10-11 21:29:19',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'30360',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16784531924',	'+14062099330',	'+16784531924',	NULL,	NULL,	NULL,	NULL,	'ACWORTH',	'GA',	'CA4d6e87b472209cf6aa8b277bcd31eb57',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(585,	'CAa5c5676079337bf0535cdd5361cc581a',	'',	'2016-10-11 21:29:26',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'30360',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16784531924',	'+14062099330',	'+16784531924',	NULL,	NULL,	NULL,	NULL,	'ACWORTH',	'GA',	'CAa5c5676079337bf0535cdd5361cc581a',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(586,	'CA65539dc7b75b2364451cd9cd52d9351b',	'',	'2016-10-11 22:25:53',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'81020',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17194663960',	'+14252338984',	'+17194663960',	NULL,	NULL,	NULL,	NULL,	'COLORADO SPRINGS',	'CO',	'CA506d513b055797c75560971a0bacf76f',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(587,	'CAeb97871c5b1f2f061636154cce61df57',	'',	'2016-10-12 15:28:09',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'48001',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15865042205',	'+19162627163',	'+15865042205',	NULL,	NULL,	NULL,	NULL,	'WARREN',	'MI',	'CAeb97871c5b1f2f061636154cce61df57',	'+14062509831',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf48dcc7b8b2c6558a8f66a706cbb3ea0',	0,	0,	'',	''),
(588,	'CA47b1ad5be9e2886a2d057a8944f8e941',	'',	'2016-10-12 17:26:39',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'80239',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13032147352',	'+16612439350',	'+13032147352',	NULL,	NULL,	NULL,	NULL,	'AURORA',	'CO',	'CA47b1ad5be9e2886a2d057a8944f8e941',	'+14062509831',	'completed',	21,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE74e3a402390834641c924156b152b88e',	0,	0,	'',	''),
(589,	'CA019ba28bcfe57d9fb135e24c68b5feeb',	'',	'2016-10-12 19:09:59',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'48001',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15865042205',	'+19162627163',	'+15865042205',	NULL,	NULL,	NULL,	NULL,	'WARREN',	'MI',	'CA019ba28bcfe57d9fb135e24c68b5feeb',	'+14062509831',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE71fad0b0892830f47f4531d70e22f9ff',	0,	0,	'',	''),
(590,	'CAcc7d18db02652c46c1462951e119a0e4',	'',	'2016-10-12 19:54:13',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'46240',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13177156266',	'+19162627163',	'+13177156266',	NULL,	NULL,	NULL,	NULL,	'INDIANAPOLIS',	'IN',	'CAf416a6be0a1ae30950ce6b40a409275a',	'+14062509831',	'voicemail',	28,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REcf3645d0ba387c70c55d0bc911746149',	0,	0,	'',	''),
(591,	'CA3ef4a1e0769186c278ee01655ce8f8f2',	'',	'2016-10-12 20:22:26',	'US',	'',	'CA',	'',	'US',	'90065',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12132598181',	'+19513741928',	'+12132598181',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA3ef4a1e0769186c278ee01655ce8f8f2',	'+14062509831',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE0744d52eb2db0cbc5842f4621d410e9e',	0,	0,	'',	''),
(592,	'CA4be4a3664ec60d6181ef4fa1184dd967',	'',	'2016-10-12 20:30:30',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'90065',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12132598181',	'+16612439350',	'+12132598181',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CAce9d888a067264197d5a7963741bc124',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(593,	'CA1330a6ce6a4fc8efee0594c85be974fb',	'',	'2016-10-12 21:22:57',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'92111',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17607565223',	'+16612439350',	'+17607565223',	NULL,	NULL,	NULL,	NULL,	'SAN DIEGO',	'CA',	'CAc56c1821370ee6e0afbff8e627dd2e0d',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(594,	'CA3c9f74e436900e4e7ba11e7037ee5000',	'',	'2016-10-12 22:27:13',	'US',	'',	'CA',	'',	'US',	'92806',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17142159818',	'+19513741928',	'+17142159818',	NULL,	NULL,	NULL,	NULL,	'ANAHEIM',	'CA',	'CA25345ca53ec0b0dbfab6e15d2ba1e0ac',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(595,	'CAe008e0aa344e8457c6f11dd2ffac3463',	'',	'2016-10-13 18:23:51',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19093134449',	'+19513741928',	'+19093134449',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAe008e0aa344e8457c6f11dd2ffac3463',	'+14062509831',	'completed',	1,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REfae959335df1183a29138fca73f8e37f',	0,	0,	'',	''),
(596,	'CA41fbb3cc63a62e6f305ecf507da699d0',	'',	'2016-10-13 20:57:46',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13237010304',	'+16612439350',	'+13237010304',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA53eaa196f4c4c911d4eb8aed4edc6f0c',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(597,	'CAdfb99d2f3acbea489644d9145bb04901',	'',	'2016-10-13 21:25:51',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13237010304',	'+19513741928',	'+13237010304',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAdb27496abc7750fbc391d17f02ecbb0f',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(598,	'CAb340970c87d79d4a4b3ba62dc61be682',	'',	'2016-10-13 22:17:55',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13237010304',	'+19162627163',	'+13237010304',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA9a5fddf32f411520b076d0c711a171af',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(599,	'CA4b29dde3cb31931bc64833e591239e32',	'',	'2016-10-13 23:06:25',	'US',	'',	'CA',	'',	'US',	'90014',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18182103969',	'+19513741928',	'+18182103969',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA340dbc50801e746f2ec312acd1ad0886',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(600,	'CAdab7678d61b560d37c8d3056877ec5ad',	'',	'2016-10-14 17:05:26',	'US',	'',	'CA',	'',	'US',	'92806',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17142159836',	'+19513741928',	'+17142159836',	NULL,	NULL,	NULL,	NULL,	'ANAHEIM',	'CA',	'CAdab7678d61b560d37c8d3056877ec5ad',	'+14062509831',	'completed',	12,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE8969f990c0fe135b357fa9c76ac6daf2',	0,	0,	'',	''),
(601,	'CA40046b66a970f628c8405eca94d28a24',	'',	'2016-10-14 17:07:12',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19093134449',	'+19513741928',	'+19093134449',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA2361559f09ade1458d99c55b48baf6f5',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(602,	'CA1c32a6498dc9e646df03aa11385fbea5',	'',	'2016-10-14 20:19:20',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15309558009',	'+16612439350',	'+15309558009',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA3eae7c392a5a4df0a855336125be8066',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(603,	'CA3595bcdc90b940bf179ac75e43a44312',	'',	'2016-10-14 20:27:31',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15309558009',	'+19513741928',	'+15309558009',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA82d05e665c2d30e1564aff84786d5e28',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(604,	'CA609acd6a2c6a08f294af6e7cf95e89e2',	'',	'2016-10-14 21:54:58',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15309558009',	'+19162627163',	'+15309558009',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAb4aeb8bc34e8691bb5b16826d2e684b5',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(605,	'CAb5829234844fc6afd9a153fa5e8dc8f0',	'',	'2016-10-17 16:32:48',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'92111',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+16612439350',	'+17607565223',	NULL,	NULL,	NULL,	NULL,	'SAN DIEGO',	'CA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(606,	'CA751df00deca541cf5b1090b568f827b0',	'',	'2016-10-17 17:05:22',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'98188',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12069305105',	'+14252338984',	'+12069305105',	NULL,	NULL,	NULL,	NULL,	'SEATTLE',	'WA',	'CA751df00deca541cf5b1090b568f827b0',	'+14062509831',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE1d6c50f9f6d7a74daad4a3dab2654b79',	0,	0,	'',	''),
(607,	'CAf8d0afa65300f34da39926998dfe1d81',	'',	'2016-10-17 20:06:18',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15107563038',	'+19513741928',	'+15107563038',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA868b0a4c7b2df79584d6c9dbe53e6fc9',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(608,	'CA962292a7abe56b9cdc0fd311fe82a20c',	'',	'2016-10-17 20:08:44',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15107563038',	'+16612439350',	'+15107563038',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAca1f722e9a9bf2269ac417ac8392ff2d',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(609,	'CA9cd8a21dd257cc6b0a7be446fbf81da7',	'',	'2016-10-17 21:44:51',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19093134449',	'+19513741928',	'+19093134449',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA9cd8a21dd257cc6b0a7be446fbf81da7',	'+14062509831',	'completed',	4,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE1aa73dfba910c5639c91a2cddfeed921',	0,	0,	'',	''),
(610,	'CA2dc3849601bf0813e717e1df34965b8e',	'',	'2016-10-17 21:48:30',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15107563038',	'+19162627163',	'+15107563038',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAc4c84c0e9af3c0f321b00c41f948b2fe',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(611,	'CAd3dc6372dcd4ebf38348ddf804dc0ca2',	'',	'2016-10-17 22:35:33',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19162490725',	'+19513741928',	'+19162490725',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAe5b9e8e595c6bee4380a79a485585244',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(612,	'CAd34ff2eedb7340eb8abf1992f3cb3c71',	'',	'2016-10-18 17:16:01',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19093134449',	'+19513741928',	'+19093134449',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA7620e29e4018c284a0c39c1a536e2bed',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(613,	'CA627276712ba73058b9289d5c2ea3aa62',	'',	'2016-10-18 20:54:13',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'93257',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15597194008',	'+19162627163',	'+15597194008',	NULL,	NULL,	NULL,	NULL,	'PORTERVILLE',	'CA',	'CA26922c3a2b6db0fb9cefc15351739139',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(614,	'CA7ddafc630402475a8d5fd3dabda7c3a1',	'',	'2016-10-18 21:21:39',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'93257',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15597194008',	'+16612439350',	'+15597194008',	NULL,	NULL,	NULL,	NULL,	'PORTERVILLE',	'CA',	'CA2aadfef320a7bf2e93c4ecf1ddb14080',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(615,	'CAfe1c21ba6710b44155227b8bb0738435',	'',	'2016-10-18 21:41:56',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'93257',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15597194008',	'+14252338984',	'+15597194008',	NULL,	NULL,	NULL,	NULL,	'PORTERVILLE',	'CA',	'CAe3f94e96fb0b82eb3a71f2d599ffba0b',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(616,	'CAa6e7da1e01d11b64f8f0322607f17240',	'',	'2016-10-18 21:45:49',	'US',	'',	'CA',	'',	'US',	'93257',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15597194008',	'+19513741928',	'+15597194008',	NULL,	NULL,	NULL,	NULL,	'PORTERVILLE',	'CA',	'CAea3abbfc6f83fb07e2b97bc03886fffb',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(617,	'CA911ebe0dc4b92b2646cec0b3882110c1',	'',	'2016-10-18 22:24:15',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13852491338',	'+19513741928',	'+13852491338',	NULL,	NULL,	NULL,	NULL,	'SALT LAKE CITY',	'UT',	'CA0d83dcd306b3a8282b97a322c5d50754',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(618,	'CA189b345a66e912931b76642c9bbd7b4d',	'',	'2016-10-18 22:35:45',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13852491294',	'+19513741928',	'+13852491294',	NULL,	NULL,	NULL,	NULL,	'SALT LAKE CITY',	'UT',	'CA1607811dccd220cadbc7107a7a9b56cf',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(619,	'CAf48f55f86db5dbf1d87004a98eddf23d',	'',	'2016-10-18 22:42:00',	'US',	'',	'CA',	'',	'US',	'93409',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18052504344',	'+19513741928',	'+18052504344',	NULL,	NULL,	NULL,	NULL,	'SAN LUIS OBISPO',	'CA',	'CAf48f55f86db5dbf1d87004a98eddf23d',	'+14062509831',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REab7cd7b13c3f5df1bf944d7e6dd6ac99',	0,	0,	'',	''),
(620,	'CAe44385b0525ac8292f17c5a1488b4cb7',	'',	'2016-10-19 15:28:38',	'US',	'',	'CA',	'',	'US',	'92411',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19095203246',	'+19513741928',	'+19095203246',	NULL,	NULL,	NULL,	NULL,	'SAN BERNARDINO',	'CA',	'CAe4d2a54acb5070e32a6d142d7d5a9b14',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(621,	'CA8e6b05bf75c329ffab339a47a3c32a7a',	'',	'2016-10-19 17:13:29',	'US',	'',	'CA',	'',	'US',	'90014',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18182104271',	'+19513741928',	'+18182104271',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA8e6b05bf75c329ffab339a47a3c32a7a',	'+14062509831',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE5bf161f306c0ee635d3f3e06ebcf1500',	0,	0,	'',	''),
(622,	'CA3b8d1a6f3d142acbec3778fab3a81e52',	'',	'2016-10-19 18:25:30',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13238971099',	'+19513741928',	'+13238971099',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA3b8d1a6f3d142acbec3778fab3a81e52',	'+14062509831',	'completed',	3,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE6a2fd3dbdfa31b4a4329a05487b481e9',	0,	0,	'',	''),
(623,	'CAd3bf325cc28c65f1a057d98e1313be3f',	'',	'2016-10-19 18:35:35',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'11946',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16318565443',	'+19162627163',	'+16318565443',	NULL,	NULL,	NULL,	NULL,	'HAMPTON BAYS',	'NY',	'CA741b0ef5cda14bfcae917fdd167ca1b6',	'+14062509831',	'voicemail',	23,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe7792f85b4ca81ee0ee95e87e9162117',	0,	0,	'',	''),
(624,	'CA5e93aee3b7beb58e8b30d9769c4825b5',	'',	'2016-10-19 18:36:12',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13238971099',	'+16612439350',	'+13238971099',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA038d5820b44d73adc41767b07e78b29b',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(625,	'CAef50e08df85984cd29cac045022ab168',	'',	'2016-10-20 16:34:15',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'84601',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18019328310',	'+16612439350',	'+18019328310',	NULL,	NULL,	NULL,	NULL,	'PROVO',	'UT',	'CAb98aaa85fe30ebcc52a54c3abc314608',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(626,	'CA2568ae210dfe3ddd6c550ae40994005c',	'',	'2016-10-20 16:38:30',	'US',	'',	'CA',	'',	'US',	'20176',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15713195884',	'+19513741928',	'+15713195884',	NULL,	NULL,	NULL,	NULL,	'LEESBURG',	'VA',	'CAd63809815a7f13d10309a833abac9372',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(627,	'CA800fe092ac12d1b5804e73fafd36fcc9',	'',	'2016-10-20 16:44:28',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'92128',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18588790008',	'+19162627163',	'+18588790008',	NULL,	NULL,	NULL,	NULL,	'RANCHO BERNARDO',	'CA',	'CA93b087f067893edb67a96fd572f1ac29',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(628,	'CA883c02a1cc90bba44f82699af25a657b',	'',	'2016-10-20 18:19:01',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'92128',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18588790008',	'+16612439350',	'+18588790008',	NULL,	NULL,	NULL,	NULL,	'RANCHO BERNARDO',	'CA',	'CA7c36bb9c9b06b4e488779ba7a5ed00a7',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(629,	'CA01c28ca1ca862ccce777e59a2f560ee8',	'',	'2016-10-20 18:55:29',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19162490330',	'+19513741928',	'+19162490330',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA01c28ca1ca862ccce777e59a2f560ee8',	'+14062509831',	'completed',	14,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4f89c8750ebbcbba5c6664778db767c9',	0,	0,	'',	''),
(630,	'CAe1dd8e386acc09595027be15e62174fa',	'',	'2016-10-20 19:59:28',	'US',	'',	'CA',	'',	'US',	'92128',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18588790008',	'+19513741928',	'+18588790008',	NULL,	NULL,	NULL,	NULL,	'RANCHO BERNARDO',	'CA',	'CAe1dd8e386acc09595027be15e62174fa',	'+14062509831',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE51c7f3825d35002c8ed19682bf1c0f4a',	0,	0,	'',	''),
(631,	'CA7cca7872680462c61430eaea36d27d6c',	'',	'2016-10-20 20:59:52',	'US',	'',	'CA',	'',	'US',	'92545',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19513063352',	'+19513741928',	'+19513063352',	NULL,	NULL,	NULL,	NULL,	'HEMET',	'CA',	'CA3e57d5b46a9de9fd3d2ffb69a703477d',	'+14062509831',	'voicemail',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE71a854c1776b917562dcdd1bbbbf4f8c',	0,	0,	'',	''),
(632,	'CA1589ce9c2ad9d7efadfd70c01326031c',	'',	'2016-10-20 21:35:53',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'92128',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18588790008',	'+19162627163',	'+18588790008',	NULL,	NULL,	NULL,	NULL,	'RANCHO BERNARDO',	'CA',	'CAbe1ef77f585fb4452bb6794fa74fc3b2',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(633,	'CA00040f26f763d1374863da29e8dd2ed0',	'',	'2016-10-21 15:51:20',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95818',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19165889132',	'+19162627163',	'+19165889132',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CA00040f26f763d1374863da29e8dd2ed0',	'+14062509831',	'completed',	2,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REaf02a74a94ae1cb19fcf987fda3691d2',	0,	0,	'',	''),
(634,	'CA9b2e247ca4934137df3d607bdab4c48d',	'',	'2016-10-21 16:17:36',	'US',	'',	'CA',	'',	'US',	'95818',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19165889132',	'+19513741928',	'+19165889132',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CAf391c0e35562d30fffd33e711df8c0d8',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(635,	'CA091a3fc91cb896bcc6dfc2fbfa8842c4',	'',	'2016-10-21 18:14:45',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15595450042',	'+19513741928',	'+15595450042',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA6609f2788b107af06a414bff2adf95bb',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(636,	'CAd16942d2d33ab6ea3662398a9ba47489',	'',	'2016-10-21 18:40:00',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15595450042',	'+16612439350',	'+15595450042',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA9b38bf26bbd185e893943a1a57174917',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(637,	'CA5413746e2fb31a06aa49862d5b1523d8',	'',	'2016-10-21 22:51:11',	'US',	'',	'CA',	'',	'US',	'90014',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18182104137',	'+19513741928',	'+18182104137',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA5413746e2fb31a06aa49862d5b1523d8',	'+14062509831',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE9ecad260f047b3c6491eaf34997ff4d2',	0,	0,	'',	''),
(638,	'CAc92d9fd225c2f3739f5c353ab672b9cf',	'',	'2016-10-24 18:32:46',	'US',	'',	'CA',	'',	'US',	'90014',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18182104285',	'+19513741928',	'+18182104285',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CAc92d9fd225c2f3739f5c353ab672b9cf',	'+14062509831',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE647b71e2fa6c743a73f8de578ce7054f',	0,	0,	'',	''),
(639,	'CAad194b59bea291bdc6970ed09214716c',	'',	'2016-10-24 18:47:38',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'91762',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19094629066',	'+16612439350',	'+19094629066',	NULL,	NULL,	NULL,	NULL,	'ONTARIO',	'CA',	'CAc2c7b081bfece64f0551015b5ddbc7ba',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(640,	'CA11c2daf0ea43a5ce71e080979b59b991',	'',	'2016-10-24 20:05:47',	'US',	'',	'CA',	'',	'US',	'91762',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19094629066',	'+19513741928',	'+19094629066',	NULL,	NULL,	NULL,	NULL,	'ONTARIO',	'CA',	'CA9a5b3ca880bce9dd9ea9dc70c6be4b4e',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(641,	'CA8cb9dbcb3b6f86bc05c02b1991386bee',	'',	'2016-10-25 17:12:22',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19162490534',	'+19513741928',	'+19162490534',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA8cb9dbcb3b6f86bc05c02b1991386bee',	'+14062509831',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE9e10b1ec23d9e5468a923d22625f9cd6',	0,	0,	'',	''),
(642,	'CAafc1779e4ff62e72b79080db8a0c9948',	'',	'2016-10-25 17:18:52',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'94531',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19257790397',	'+19162627163',	'+19257790397',	NULL,	NULL,	NULL,	NULL,	'ANTIOCH',	'CA',	'CAafc1779e4ff62e72b79080db8a0c9948',	'+14062509831',	'completed',	31,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4e7095b95d0a425e443eb6e78b8ed25f',	0,	0,	'',	''),
(643,	'CAfbb2d4ee02f43cd1d3b8e5b2335be25f',	'',	'2016-10-25 17:48:49',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95833',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19168694444',	'+19162627163',	'+19168694444',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CA6d926560afa764329d11dfc3cb924c7f',	'+14062509831',	'voicemail',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE334b1c162bb2bfb2b60dfd898fa9d181',	0,	0,	'',	''),
(644,	'CAf5f30f54d5c2c36a540baa93ad5cc76e',	'',	'2016-10-25 18:11:27',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18058621017',	'+16612439350',	'+18058621017',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA616a8c408974f3f4bc099e85bccc1403',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(645,	'CA1bfe22eff53342f7507b65671ada2d6a',	'',	'2016-10-25 18:21:41',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18058621017',	'+19513741928',	'+18058621017',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA6bc788a350b6cb25ba1de5eb9520dd3c',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(646,	'CA76bd846188f51f51bc1f738b9446644f',	'',	'2016-10-25 21:23:27',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18058621017',	'+19162627163',	'+18058621017',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA6e5be677b798deae4e1db34f2a356ebd',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(647,	'CAfa363e0b713a0b0aa44bc130929644cc',	'',	'2016-10-25 21:48:59',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18058621017',	'+14252338984',	'+18058621017',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAf505760d1cd91420dd4d59d5afa3f126',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(648,	'CA883789844d31eb283e23772106c36478',	'',	'2016-10-26 16:20:01',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'85204',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+14252338984',	'+16026353216',	NULL,	NULL,	NULL,	NULL,	'PHOENIX',	'AZ',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(649,	'CAa38442221cbb6e2fa4fee19317cd745c',	'',	'2016-10-26 17:27:15',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'94089',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14087735573',	'+19162627163',	'+14087735573',	NULL,	NULL,	NULL,	NULL,	'SUNNYVALE',	'CA',	'CAe324bfe81d28280cf757a5cbeb05819a',	'+14062509831',	'voicemail',	18,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE40870452e896938217700a91b3bf8e94',	0,	0,	'',	''),
(650,	'CA966072cdaf68d4afb1e8971ea8226123',	'',	'2016-10-26 18:44:42',	'US',	'',	'CA',	'',	'US',	'90017',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12133547167',	'+19513741928',	'+12133547167',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CAbbe57a550df7d948c283f90ce0c56533',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(651,	'CA6e50ee35961ade4c2416093d711f7d01',	'',	'2016-10-26 18:50:19',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'90017',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12133547167',	'+16612439350',	'+12133547167',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CAbe06ca4862ba9a3e591114a2b1205b9e',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(652,	'CAdc6ab429008a9844ac0d3b0f44b3b1fd',	'',	'2016-10-26 20:28:45',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'90017',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12133547167',	'+14252338984',	'+12133547167',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CAe6e89cc544cc415659827902dbf5423d',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(653,	'CA42d40817d479683dbf7d97f6491ee815',	'',	'2016-10-26 21:02:15',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'90017',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12133547167',	'+19162627163',	'+12133547167',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CAa26b063a4018abf1b421b35ba9b84b02',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(654,	'CA0b834b1d4b395cb7b598f0bb760d07a5',	'',	'2016-10-26 23:15:30',	'US',	'',	'CA',	'',	'US',	'92806',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17142159168',	'+19513741928',	'+17142159168',	NULL,	NULL,	NULL,	NULL,	'ANAHEIM',	'CA',	'CAc06b8bcface90184dbc68a324c4ab81f',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(655,	'CA4d15f6c052fd959ec99dd53be36e0037',	'',	'2016-10-27 18:49:23',	'US',	'',	'CA',	'',	'US',	'46278',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13178039458',	'+19513741928',	'+13178039458',	NULL,	NULL,	NULL,	NULL,	'INDIANAPOLIS',	'IN',	'CA4d15f6c052fd959ec99dd53be36e0037',	'+14062509831',	'completed',	61,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb8b51a6feb5b52094c403aa6fe1e5c39',	0,	0,	'',	''),
(656,	'CAce6afa966e75cad80a51ebd9f6acca35',	'',	'2016-10-27 18:54:51',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'94060',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16502976056',	'+14252338984',	'+16502976056',	NULL,	NULL,	NULL,	NULL,	'PESCADERO',	'CA',	'CA56e1a9b36b2c4a5813f34ea6a22d797d',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(657,	'CA472b30ad7b4c64ddfd0edfa8e7fd871a',	'',	'2016-10-27 22:36:32',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'90077',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13232722924',	'+16612439350',	'+13232722924',	NULL,	NULL,	NULL,	NULL,	'BEVERLY HILLS',	'CA',	'CA472b30ad7b4c64ddfd0edfa8e7fd871a',	'+14062509831',	'completed',	59,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE958b5377238946caaac20924c925a7ec',	0,	0,	'',	''),
(658,	'CAd361c3e0a7ae9768074c931e94fa4385',	'',	'2016-10-27 22:43:56',	'US',	'',	'CA',	'',	'US',	'90250',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13104967338',	'+19513741928',	'+13104967338',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CAd361c3e0a7ae9768074c931e94fa4385',	'+14062509831',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE9c878c98cd5d6c276afed0a5763a5700',	0,	0,	'',	''),
(659,	'CAcca43f9eeda0122db18a377739ddac1c',	'',	'2016-10-28 20:18:08',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13852491338',	'+19513741928',	'+13852491338',	NULL,	NULL,	NULL,	NULL,	'SALT LAKE CITY',	'UT',	'CAedfe360e1a7db9410147fb22d608e84b',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(660,	'CA384bb1d3210b33b718715d5b04f91c42',	'',	'2016-10-28 20:49:53',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'89074',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17023318671',	'+14252338984',	'+17023318671',	NULL,	NULL,	NULL,	NULL,	'HENDERSON',	'NV',	'CAd95eff9a4c1b56fdf38b7a15b70ea370',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(661,	'CAb9068a9d6ccfba0e76623c01b31e0824',	'',	'2016-10-28 23:07:11',	'US',	'',	'CA',	'',	'US',	'90017',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17142487314',	'+19513741928',	'+17142487314',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CAb9068a9d6ccfba0e76623c01b31e0824',	'+14062509831',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE283819af0af731e28d248b3e8f232e50',	0,	0,	'',	''),
(662,	'CA206fb662d3c733a752091ede5d2610f6',	'',	'2016-10-31 03:40:26',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'93304',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16616167879',	'+16612439350',	'+16616167879',	NULL,	NULL,	NULL,	NULL,	'BAKERSFIELD',	'CA',	'CA206fb662d3c733a752091ede5d2610f6',	'+14062509831',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE61ede471b99e87374b7b631420b6d016',	0,	0,	'',	''),
(663,	'CAc0e02bf741ac1dd359f93e2b34608576',	'',	'2016-10-31 17:26:57',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95630',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19169042972',	'+19162627163',	'+19169042972',	NULL,	NULL,	NULL,	NULL,	'FAIR OAKS',	'CA',	'CAf808b45c1c490dbe076576f2536848f0',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(664,	'CA821d9bcf0a9ad87e391cf14b9875e9bf',	'',	'2016-10-31 17:35:17',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17549993008',	'+19162627163',	'+17549993008',	NULL,	NULL,	NULL,	NULL,	'',	'FL',	'CA63087fd320f7470889f68ecb55ebaa4c',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(665,	'CA003d9ff5048ec009c8f6959d03ad93f2',	'',	'2016-10-31 17:42:13',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'98001',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12063006368',	'+14252338984',	'+12063006368',	NULL,	NULL,	NULL,	NULL,	'SEATTLE',	'WA',	'CA9ad7d79ec06cd150e9b79c857728479f',	'+14062509831',	'voicemail',	19,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd1047c8335251dd2972796dff6a7ed66',	0,	0,	'',	''),
(666,	'CA431270edb60a931672434bc1b7a04e33',	'',	'2016-10-31 18:09:23',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17549993008',	'+19513741928',	'+17549993008',	NULL,	NULL,	NULL,	NULL,	'',	'FL',	'CA431270edb60a931672434bc1b7a04e33',	'+14062509831',	'completed',	4,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa945627f62924e90f8b604c10fc57f56',	0,	0,	'',	''),
(667,	'CA87ac2a89d6484e8ccfcf2d0a77e905ca',	'',	'2016-10-31 22:55:21',	'US',	'',	'CA',	'',	'US',	'90014',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18182104146',	'+19513741928',	'+18182104146',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA4805dd3ef886b4238f69e7a9a8c7f9c4',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(668,	'CAca638915c66517e408b0b6e51c185c1e',	'',	'2016-11-01 16:17:25',	'US',	'',	'CA',	'',	'US',	'90017',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17142488476',	'+19513741928',	'+17142488476',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CAca638915c66517e408b0b6e51c185c1e',	'+14062509831',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3aa934102741b1d514265605085961c7',	0,	0,	'',	''),
(669,	'CA76e6098e3f5cf8c0437cbeb11aed5e7b',	'',	'2016-11-01 20:58:01',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'43162',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16146420808',	'+14252338984',	'+16146420808',	NULL,	NULL,	NULL,	NULL,	'W JEFFERSON',	'OH',	'CA2b964662eba5f4430a569efbf869d126',	'+14062509831',	'voicemail',	29,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REbacfcc9a03c4c951aa52d4244285a989',	0,	0,	'',	''),
(670,	'CA770c7f4ca1a4cfa12d27c3f45de6f8b4',	'',	'2016-11-02 16:16:16',	'US',	'',	'CA',	'',	'US',	'90014',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18182103938',	'+19513741928',	'+18182103938',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA770c7f4ca1a4cfa12d27c3f45de6f8b4',	'+14062509831',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE1014f00e65530417490eb70cb955ecae',	0,	0,	'',	''),
(671,	'CA998d2bf6d04cd68e07e4206f52908c74',	'',	'2016-11-02 20:36:25',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'95910',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15302901046',	'+14252338984',	'+15302901046',	NULL,	NULL,	NULL,	NULL,	'ALLEGHANY',	'CA',	'CAbe97b8950d8d938ecb790b96e0540a8c',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(672,	'CAeb14674bf00fa4a8b41c56ff3917b811',	'',	'2016-11-03 18:34:02',	'US',	'',	'CA',	'',	'US',	'90715',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13104056615',	'+19513741928',	'+13104056615',	NULL,	NULL,	NULL,	NULL,	'LAKEWOOD',	'CA',	'CAeb14674bf00fa4a8b41c56ff3917b811',	'+14062509831',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE6f2d0ff8aa7c49f6f40ce1501088efc4',	0,	0,	'',	''),
(673,	'CA4b844e83aa57b779983850d8dab8e964',	'',	'2016-11-03 20:13:24',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'94615',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15103190030',	'+14252338984',	'+15103190030',	NULL,	NULL,	NULL,	NULL,	'OAKLAND',	'CA',	'CAeb8d7ebbfcaefe9f278be35451307281',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(674,	'CA8a0569ec43d3d029b1387b12fe11649f',	'',	'2016-11-03 22:05:43',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16615251033',	'+16612439350',	'+16615251033',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAd7718be35598de242c20ef429043d0ab',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(675,	'CAe55860553d25b10d934ec90998016c11',	'',	'2016-11-04 15:46:46',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'92092',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18585313162',	'+14252338984',	'+18585313162',	NULL,	NULL,	NULL,	NULL,	'LA JOLLA',	'CA',	'CAe55860553d25b10d934ec90998016c11',	'+14062509831',	'completed',	73,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE2a5128d40f4740b41aa3b4cb472791b0',	0,	0,	'',	''),
(676,	'CAb4b805dac3453bdc624c3002df6d7e62',	'',	'2016-11-04 16:33:39',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'46278',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13178083429',	'+14252338984',	'+13178083429',	NULL,	NULL,	NULL,	NULL,	'INDIANAPOLIS',	'IN',	'CA734ccad9e3b8c4ee62742c1e7dd14811',	'+14062509831',	'voicemail',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REcd0a22eda95ecf197c7412b503223cc7',	0,	0,	'',	''),
(677,	'CA7a9466a572ba77cf4fa56436b6783ded',	'',	'2016-11-04 19:04:07',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19513741928',	'+19093134466',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(678,	'CAefc6f91cc078b9cf9e777861e96dc0e8',	'',	'2016-11-04 20:21:40',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'95249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096747119',	'+14252338984',	'+12096747119',	NULL,	NULL,	NULL,	NULL,	'SAN ANDREAS',	'CA',	'CAd95e495ba76f4cff9f60e49321af6951',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(679,	'CAc071f4af77f2ed2fc03c8c648d76405e',	'',	'2016-11-04 22:38:35',	'US',	'',	'CA',	'',	'US',	'90014',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18182104355',	'+19513741928',	'+18182104355',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CAc071f4af77f2ed2fc03c8c648d76405e',	'+14062509831',	'completed',	2,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE9eed518e2b91efaedfe44249c3fd7776',	0,	0,	'',	''),
(680,	'CAf62703d241652da0242569f0142275d1',	'',	'2016-11-07 19:37:26',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95814',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19164768920',	'+19162627163',	'+19164768920',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CAf62703d241652da0242569f0142275d1',	'+14062509831',	'completed',	58,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REed17ce8fee5f0599c60b069307511964',	0,	0,	'',	''),
(681,	'CA5b233d10bb03c45add285ca8ee1d1587',	'',	'2016-11-07 21:20:45',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'95565',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17077975007',	'+14252338984',	'+17077975007',	NULL,	NULL,	NULL,	NULL,	'BRIDGEVILLE',	'CA',	'CA5afead776bce7785f21e22fbd2095650',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(682,	'CAd4aa041367e25cc713d1f59c2673a6f4',	'',	'2016-11-07 23:26:59',	'US',	'',	'CA',	'',	'US',	'90250',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13106229399',	'+19513741928',	'+13106229399',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA5e689a47ca2ee53e20786ea874f94029',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(683,	'CAd42ec486317fe4c8e74516a79bb006ce',	'',	'2016-11-08 05:22:14',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18007558108',	'+19513741928',	'+18007558108',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CAd42ec486317fe4c8e74516a79bb006ce',	'+14062509831',	'completed',	70,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE0bc5fdc19bfcd2aee06b5335d8062097',	0,	0,	'',	''),
(684,	'CA685798de9af29f532b6abc9ae8b0483e',	'',	'2016-11-08 17:15:07',	'US',	'',	'CA',	'',	'US',	'90014',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18182104350',	'+19513741928',	'+18182104350',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA82c161bd558e6d2941821d55940cb2e1',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(685,	'CA0d683be1f5201a3a3d5e9a3589ac0c2c',	'',	'2016-11-09 23:58:31',	'US',	'',	'CA',	'',	'US',	'90014',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13108531149',	'+19513741928',	'+13108531149',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA0d683be1f5201a3a3d5e9a3589ac0c2c',	'+14062509831',	'completed',	14,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE537e863443627f2765778b9dc9a5f2e7',	0,	0,	'',	''),
(686,	'CAbfa5e3133152823886a1643a604d9909',	'',	'2016-11-11 00:22:13',	'US',	'',	'CA',	'',	'US',	'90014',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18182104426',	'+19513741928',	'+18182104426',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CAbfa5e3133152823886a1643a604d9909',	'+14062509831',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE785b14affefe4c40ba4054a751142529',	0,	0,	'',	''),
(687,	'CAf3c48ab00e56e5bf3d6c2a2b556f5100',	'',	'2016-11-11 16:54:45',	'US',	'',	'CA',	'',	'US',	'90265',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13108784238',	'+19513741928',	'+13108784238',	NULL,	NULL,	NULL,	NULL,	'GARDENA',	'CA',	'CAf3c48ab00e56e5bf3d6c2a2b556f5100',	'+14062509831',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3b7d5df04af5e9c97ad9c91136be4ea5',	0,	0,	'',	''),
(688,	'CA08faa77ef47aac916fc3320a2aac99b1',	'',	'2016-11-11 18:25:04',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'91780',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13232839094',	'+16612439350',	'+13232839094',	NULL,	NULL,	NULL,	NULL,	'ALHAMBRA',	'CA',	'CA08faa77ef47aac916fc3320a2aac99b1',	'+14062509831',	'completed',	18,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE46fbd6bcf1dd787b43ed6f7e5884de6a',	0,	0,	'',	''),
(689,	'CA998acd287b7e73f07149578e37984715',	'',	'2016-11-11 18:25:43',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'91780',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+16612439350',	'+13232839094',	NULL,	NULL,	NULL,	NULL,	'ALHAMBRA',	'CA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(690,	'CAfa4f1076323e5e7d81ebd93639ee9526',	'',	'2016-11-12 16:07:20',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19143431947',	'+14062099330',	'+19143431947',	NULL,	NULL,	NULL,	NULL,	'',	'NY',	'CAfa4f1076323e5e7d81ebd93639ee9526',	'+14062509831',	'completed',	1,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REbfc51395aaceee4b56d3538c3d4f2a8e',	0,	0,	'',	''),
(691,	'CA53ee7914e1ac3f60b8e0d2d96515b3ee',	'',	'2016-11-14 00:40:33',	'US',	'',	'CA',	'',	'US',	'90249',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16262613018',	'+19513741928',	'+16262613018',	NULL,	NULL,	NULL,	NULL,	'WEST COVINA',	'CA',	'CA9315c85dec2c005ceb395aaed6c9fad6',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(692,	'CA6b4f7c9703f175b9af82e0bd438d45e9',	'',	'2016-11-14 16:02:05',	'US',	'',	'CA',	'',	'US',	'90014',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18182104157',	'+19513741928',	'+18182104157',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA6b4f7c9703f175b9af82e0bd438d45e9',	'+14062509831',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE1622dadf17ab315ba5e1336021d4ac00',	0,	0,	'',	''),
(693,	'CAb3c7cad045d0f63e36c132af9b7b3246',	'',	'2016-11-15 00:20:46',	'US',	'',	'CA',	'',	'US',	'90017',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17142488825',	'+19513741928',	'+17142488825',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CAb3c7cad045d0f63e36c132af9b7b3246',	'+14062509831',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE796bb33bd676f2595c2f8492ff5d593a',	0,	0,	'',	''),
(694,	'CA55852afb85249144afaf6b097c454c55',	'',	'2016-11-15 19:02:20',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13852491294',	'+19513741928',	'+13852491294',	NULL,	NULL,	NULL,	NULL,	'SALT LAKE CITY',	'UT',	'CA55852afb85249144afaf6b097c454c55',	'+14062509831',	'completed',	1,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE38ec5f6482a0b408313d5c1ce513c3e6',	0,	0,	'',	''),
(695,	'CAd4e13465918b270733481bd7925d795e',	'',	'2016-11-15 23:25:01',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19162490446',	'+19513741928',	'+19162490446',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAd4e13465918b270733481bd7925d795e',	'+14062509831',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE2581657e2dc2db28b9826ec47ed356bb',	0,	0,	'',	''),
(696,	'CAee096f10cbc3c89ebdb91ade3b554aa0',	'',	'2016-11-16 00:19:42',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15862991040',	'+19513741928',	'+15862991040',	NULL,	NULL,	NULL,	NULL,	'',	'MI',	'CA2b80a08b174272db79f230042b3686da',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(697,	'CAf53962ef45eeeefcf4cab857d1977aac',	'',	'2016-11-16 23:51:59',	'US',	'',	'CA',	'',	'US',	'90017',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17142488103',	'+19513741928',	'+17142488103',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CAf53962ef45eeeefcf4cab857d1977aac',	'+14062509831',	'completed',	14,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE25e0f2d2e361df33cc8f62393d4815aa',	0,	0,	'',	''),
(698,	'CA12159854f853d1550e18ca1ea327f6d4',	'',	'2016-11-17 18:07:40',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19162490718',	'+19513741928',	'+19162490718',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA12159854f853d1550e18ca1ea327f6d4',	'+14062509831',	'completed',	14,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa9fd1418e512f172767cfef1e5c12418',	0,	0,	'',	''),
(699,	'CA6d2debb73417c2cd1e7e953c2a9823f0',	'',	'2016-11-17 19:15:18',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'94062',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16503007998',	'+14252338984',	'+16503007998',	NULL,	NULL,	NULL,	NULL,	'WOODSIDE',	'CA',	'CA216e60a5bdbac03783b58720f2354690',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(700,	'CA5ed906022de1e82baca44fcb9f114783',	'',	'2016-11-17 23:38:14',	'US',	'',	'CA',	'',	'US',	'93555',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19513741928',	'+17608827091',	NULL,	NULL,	NULL,	NULL,	'RIDGECREST',	'CA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(701,	'CA7ad608bcf678159c09e5287e2f10eeb2',	'',	'2016-11-18 21:27:19',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'94506',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19252397508',	'+14252338984',	'+19252397508',	NULL,	NULL,	NULL,	NULL,	'DANVILLE',	'CA',	'CA45c691530ae4766dc716b41000e86200',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(702,	'CA91898069c5d43b1ccf0602a59bef8aaa',	'',	'2016-11-18 21:40:20',	'US',	'',	'CA',	'',	'US',	'93555',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17608827091',	'+19513741928',	'+17608827091',	NULL,	NULL,	NULL,	NULL,	'RIDGECREST',	'CA',	'CAfe951bc934f380455e11a67fe0806f02',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(703,	'CA38c41dcce157e00721f5d88dedef1111',	'',	'2016-11-19 00:05:19',	'US',	'',	'CA',	'',	'US',	'90014',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18182103981',	'+19513741928',	'+18182103981',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA38c41dcce157e00721f5d88dedef1111',	'+14062509831',	'completed',	14,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REcba236164fa609c6b6a2575d11241482',	0,	0,	'',	''),
(704,	'CA155537b425c549ed74e1adde8e71c9ad',	'',	'2016-11-19 17:47:57',	'US',	'',	'CA',	'',	'US',	'92704',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19512873468',	'+19513741928',	'+19512873468',	NULL,	NULL,	NULL,	NULL,	'SANTA ANA',	'CA',	'CA155537b425c549ed74e1adde8e71c9ad',	'+14062509831',	'completed',	14,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REedea1a8a337ebd674d87ecd787784e3e',	0,	0,	'',	''),
(705,	'CA6796e09a6db3ff6999c038ea9f6b758f',	'',	'2016-11-21 21:44:22',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'12402',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19143317292',	'+14062099330',	'+19143317292',	NULL,	NULL,	NULL,	NULL,	'KINGSTON',	'NY',	'CA6796e09a6db3ff6999c038ea9f6b758f',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(706,	'CAecc5190040d86dc955618e2f9c8c2ee8',	'',	'2016-11-21 23:53:25',	'US',	'',	'CA',	'',	'US',	'93555',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17608827091',	'+19513741928',	'+17608827091',	NULL,	NULL,	NULL,	NULL,	'RIDGECREST',	'CA',	'CAecc5190040d86dc955618e2f9c8c2ee8',	'+14062509831',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REcd1132b02db8b9f2d8e12a7dac29092d',	0,	0,	'',	''),
(707,	'CAeaaa592c852518a6a54482f39379da84',	'',	'2016-11-21 23:53:30',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19162490691',	'+19513741928',	'+19162490691',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAeaaa592c852518a6a54482f39379da84',	'+14062509831',	'completed',	14,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE442f2f12a4d43934a5fc221090102bb2',	0,	0,	'',	''),
(708,	'CAc3d9e0290752120f2e3d6eff0ddf4540',	'',	'2016-11-22 19:27:21',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'94062',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16503008014',	'+14252338984',	'+16503008014',	NULL,	NULL,	NULL,	NULL,	'WOODSIDE',	'CA',	'CAc3d9e0290752120f2e3d6eff0ddf4540',	'+14062509831',	'completed',	3,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe1e854b848e7b0048e6186cf48868e9c',	0,	0,	'',	''),
(709,	'CA4517ffc15283beedf6fb768802383971',	'',	'2016-11-22 23:47:59',	'US',	'',	'CA',	'',	'US',	'90014',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18182104327',	'+19513741928',	'+18182104327',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA4517ffc15283beedf6fb768802383971',	'+14062509831',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE1f564fb05ecfcd4cab7f7a1060911015',	0,	0,	'',	''),
(710,	'CA89169589c7c9d81ad1232a8bcb01181e',	'',	'2016-11-23 17:15:22',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'90077',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13232722924',	'+16612439350',	'+13232722924',	NULL,	NULL,	NULL,	NULL,	'BEVERLY HILLS',	'CA',	'CA89169589c7c9d81ad1232a8bcb01181e',	'+14062509831',	'completed',	49,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE665b64a294635c8f79d2565b9b89779e',	0,	0,	'',	''),
(711,	'CA526aab6d91af573a05cc7b938240110c',	'',	'2016-11-23 18:04:52',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'80903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17196242350',	'+16612439350',	'+17196242350',	NULL,	NULL,	NULL,	NULL,	'COLORADO SPRINGS',	'CO',	'CA526aab6d91af573a05cc7b938240110c',	'+14062509831',	'completed',	15,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc6524d9ebe02a7634ef3219215798563',	0,	0,	'',	''),
(712,	'CA630bff6c74b31e3c4f23ddd5dcf2b024',	'',	'2016-11-28 19:37:47',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'91950',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16197730607',	'+16612439350',	'+16197730607',	NULL,	NULL,	NULL,	NULL,	'NATIONAL CITY',	'CA',	'CA630bff6c74b31e3c4f23ddd5dcf2b024',	'+14062509831',	'completed',	69,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE89a902c7af180c695c13cba335b8c566',	0,	0,	'',	''),
(713,	'CA059d236d42fb843b8c1d8f13314c4dae',	'',	'2016-11-28 19:59:17',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'91950',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16197730607',	'+19162627163',	'+16197730607',	NULL,	NULL,	NULL,	NULL,	'NATIONAL CITY',	'CA',	'CA059d236d42fb843b8c1d8f13314c4dae',	'+14062509831',	'completed',	69,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa03268223ac4d51b93fe53529cd7e9bd',	0,	0,	'',	''),
(714,	'CA32dc01f575427814fd986d4bf06c9e87',	'',	'2016-11-28 21:10:43',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'94041',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+14252338984',	'+16504312191',	NULL,	NULL,	NULL,	NULL,	'MT VIEW',	'CA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(715,	'CAfe0a39041cb80bf6776d451eb51dd971',	'',	'2016-11-28 21:10:44',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'94041',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16504312191',	'+14252338984',	'+16504312191',	NULL,	NULL,	NULL,	NULL,	'MT VIEW',	'CA',	'CAfe0a39041cb80bf6776d451eb51dd971',	'+14062509831',	'completed',	1,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REbec86c86108092fe8bc15482c6fe82e3',	0,	0,	'',	''),
(716,	'CAde33f3f99936a849eff4ac28ac984056',	'',	'2016-11-29 17:25:14',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'91950',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16197730607',	'+14252338984',	'+16197730607',	NULL,	NULL,	NULL,	NULL,	'NATIONAL CITY',	'CA',	'CAde33f3f99936a849eff4ac28ac984056',	'+14062509831',	'completed',	72,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa0d2e102e9fc8ede4f214fc49d909d15',	0,	0,	'',	''),
(717,	'CA0fc0b4b1707f7fd45f377b868ef989f9',	'',	'2016-11-29 17:30:55',	'US',	'',	'CA',	'',	'US',	'91950',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16197730607',	'+19513741928',	'+16197730607',	NULL,	NULL,	NULL,	NULL,	'NATIONAL CITY',	'CA',	'CA0fc0b4b1707f7fd45f377b868ef989f9',	'+14062509831',	'completed',	71,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe3fe835c9349ef07a78ade8ef67b0699',	0,	0,	'',	''),
(718,	'CA0d5dec51369b1fa5d0efdfa950b3fa8f',	'',	'2016-11-29 19:29:16',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17473001524',	'+14252338984',	'+17473001524',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA0d5dec51369b1fa5d0efdfa950b3fa8f',	'+14062509831',	'completed',	2,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb83a2454cbc806a39216b066d00ae295',	0,	0,	'',	''),
(719,	'CA6764187b19b13fd94b012473f614fa25',	'',	'2016-11-30 00:02:11',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19162490639',	'+19513741928',	'+19162490639',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA6764187b19b13fd94b012473f614fa25',	'+14062509831',	'completed',	14,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE0166d398ed9f7ad12755607a1b349766',	0,	0,	'',	''),
(720,	'CAc1b041d5feaad19a5a54d4a635e961c1',	'',	'2016-11-30 20:11:42',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'45327',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19377038518',	'+14252338984',	'+19377038518',	NULL,	NULL,	NULL,	NULL,	'DAYTON',	'OH',	'CA70a3c1620a8ebbd0cd58fc78e68055e8',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(721,	'CA4b15e9b0f7ee832e585c5ed2537b4583',	'',	'2016-12-01 16:40:17',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'80903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17196242350',	'+16612439350',	'+17196242350',	NULL,	NULL,	NULL,	NULL,	'COLORADO SPRINGS',	'CO',	'CAa7e1c983e3c43c049b60b3711fc5fb8c',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(722,	'CA716823e778371af07570094c1b645bf0',	'',	'2016-12-01 23:04:21',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'46278',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13178083429',	'+14252338984',	'+13178083429',	NULL,	NULL,	NULL,	NULL,	'INDIANAPOLIS',	'IN',	'CA716823e778371af07570094c1b645bf0',	'+14062509831',	'completed',	33,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE0fa93b750355d8af1c3281e4c3f70b37',	0,	0,	'',	''),
(723,	'CAadebacb0c45406f22cadea511f4b0571',	'',	'2016-12-02 16:09:09',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'45327',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19377038518',	'+14252338984',	'+19377038518',	NULL,	NULL,	NULL,	NULL,	'DAYTON',	'OH',	'CAadebacb0c45406f22cadea511f4b0571',	'+14062509831',	'completed',	42,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE061c719761ba2ababa9380d11b63f075',	0,	0,	'',	''),
(724,	'CA42da6c3c694bf96b52b4f8f12be2f45d',	'',	'2016-12-02 16:46:04',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'80903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17196242350',	'+16612439350',	'+17196242350',	NULL,	NULL,	NULL,	NULL,	'COLORADO SPRINGS',	'CO',	'CAe603078b7baa18539380b7951916641e',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(725,	'CA82e2a2af05e3c8215f442fc034318786',	'',	'2016-12-02 17:03:42',	'US',	'',	'CA',	'',	'US',	'90014',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18182104014',	'+19513741928',	'+18182104014',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA82e2a2af05e3c8215f442fc034318786',	'+14062509831',	'completed',	14,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE0301920155258930323d231bc9a97edc',	0,	0,	'',	''),
(726,	'CA801ba323fcfa3e03c5dbb82ab7056698',	'',	'2016-12-02 19:42:20',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18632401739',	'+14252338984',	'+18632401739',	NULL,	NULL,	NULL,	NULL,	'',	'FL',	'CA801ba323fcfa3e03c5dbb82ab7056698',	'+14062509831',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE2b79ecb618892adf06828a8b6b377c02',	0,	0,	'',	''),
(727,	'CAa7ce8a769615ee821b46679b71ed9b12',	'',	'2016-12-02 21:47:03',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14245264024',	'+14252338984',	'+14245264024',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA2875cc16a33007e1ea560224bf531481',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(728,	'CAc1e6470eb3524db54b06dd598497f412',	'',	'2016-12-05 21:49:30',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'94041',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16504312769',	'+14252338984',	'+16504312769',	NULL,	NULL,	NULL,	NULL,	'MT VIEW',	'CA',	'CAc1e6470eb3524db54b06dd598497f412',	'+14062509831',	'completed',	3,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE1cf1931c65d1be253a7de38c084d9061',	0,	0,	'',	''),
(729,	'CA449484254c59fcd2f4bf0dca8da96262',	'',	'2016-12-05 21:55:58',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'45327',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19377038518',	'+14252338984',	'+19377038518',	NULL,	NULL,	NULL,	NULL,	'DAYTON',	'OH',	'CA449484254c59fcd2f4bf0dca8da96262',	'+14062509831',	'completed',	42,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE8dab78d0f2d8c7c88bbe21e21e4246ec',	0,	0,	'',	''),
(730,	'CA93190f9afba8e64604ec0fcaffbc47c1',	'',	'2016-12-05 21:57:21',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'45327',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19377038518',	'+14252338984',	'+19377038518',	NULL,	NULL,	NULL,	NULL,	'DAYTON',	'OH',	'CA93190f9afba8e64604ec0fcaffbc47c1',	'+14062509831',	'completed',	12,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE314615073d43c777e2ab26d84e0db1d8',	0,	0,	'',	''),
(731,	'CA2b39b3e743865dc655fb71a7fbdbb560',	'',	'2016-12-05 21:57:40',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'45327',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+14252338984',	'+19377038518',	NULL,	NULL,	NULL,	NULL,	'DAYTON',	'OH',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(732,	'CAa55fa51ea917152e39ba84aebdd30480',	'',	'2016-12-06 19:55:21',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14243053327',	'+14252338984',	'+14243053327',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAa55fa51ea917152e39ba84aebdd30480',	'+14062509831',	'completed',	2,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE8450146b07659ebe7707417b7d95a409',	0,	0,	'',	''),
(733,	'CA059ea4b6c5828bfaed8478d864878e33',	'',	'2016-12-07 00:23:16',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13234868668',	'+14062099330',	'+13234868668',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA059ea4b6c5828bfaed8478d864878e33',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(734,	'CAd01d57f6fdc8242b594870474012e539',	'',	'2016-12-07 19:11:02',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'90011',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13237651044',	'+14252338984',	'+13237651044',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CAd01d57f6fdc8242b594870474012e539',	'+14062509831',	'completed',	3,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE5dee0fa42ba39c0c2f1967dfaf4488cc',	0,	0,	'',	''),
(735,	'CA2f9589d0127f46d866568c28a0af29ef',	'',	'2016-12-07 22:59:54',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18632401739',	'+14252338984',	'+18632401739',	NULL,	NULL,	NULL,	NULL,	'',	'FL',	'CA2f9589d0127f46d866568c28a0af29ef',	'+14062509831',	'completed',	1,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REed09890d2f78999beeaebbaec6615681',	0,	0,	'',	''),
(736,	'CA4a07f36203a1dd0909adba0e45ffd535',	'',	'2016-12-08 17:01:58',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'91950',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16197730607',	'+19162627163',	'+16197730607',	NULL,	NULL,	NULL,	NULL,	'NATIONAL CITY',	'CA',	'CA4a07f36203a1dd0909adba0e45ffd535',	'+14062509831',	'completed',	96,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REac74f60449d69a852da1794df5dc4b76',	0,	0,	'',	''),
(737,	'CA6280a19459105dda2caa9049e4e62dc2',	'',	'2016-12-08 17:36:31',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19165007359',	'+19162627163',	'+19165007359',	NULL,	NULL,	NULL,	NULL,	'Elk Grove',	'CA',	'CA6280a19459105dda2caa9049e4e62dc2',	'+14062509831',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe670d38a38d6bd16d7cd447d551b440f',	0,	0,	'',	''),
(738,	'CA4cecba0febf51ddc1e3b91d8295bdf86',	'',	'2016-12-08 18:04:38',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'91950',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16197730607',	'+16612439350',	'+16197730607',	NULL,	NULL,	NULL,	NULL,	'NATIONAL CITY',	'CA',	'CA4cecba0febf51ddc1e3b91d8295bdf86',	'+14062509831',	'completed',	95,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE7dca4b67712f23ccb88fdff0e7b8455e',	0,	0,	'',	''),
(739,	'CAf15bfb8b8135b63cbd13ea70132e1397',	'',	'2016-12-08 19:25:29',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'91950',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16197730607',	'+14252338984',	'+16197730607',	NULL,	NULL,	NULL,	NULL,	'NATIONAL CITY',	'CA',	'CAf15bfb8b8135b63cbd13ea70132e1397',	'+14062509831',	'completed',	70,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE320b55aa38afc46cad8f5394235d3f1b',	0,	0,	'',	''),
(740,	'CA37c8d9298c90537cf1b4f005b7def9e9',	'',	'2016-12-08 19:32:29',	'US',	'',	'CA',	'',	'US',	'91950',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16197730607',	'+19513741928',	'+16197730607',	NULL,	NULL,	NULL,	NULL,	'NATIONAL CITY',	'CA',	'CA37c8d9298c90537cf1b4f005b7def9e9',	'+14062509831',	'completed',	72,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE6a6d377e940bbb8d3d6c2a0d0eb53c7b',	0,	0,	'',	''),
(741,	'CAb88c33f2195ffdd37ec7d59bc7bff7fc',	'',	'2016-12-08 21:17:10',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14243913101',	'+14252338984',	'+14243913101',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAb88c33f2195ffdd37ec7d59bc7bff7fc',	'+14062509831',	'completed',	3,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa9a66f8e1f6cd95b01483ba6e3801441',	0,	0,	'',	''),
(742,	'CAe1c2f633a1f7874add260f142553ffc1',	'',	'2016-12-08 22:47:42',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13852491356',	'+19513741928',	'+13852491356',	NULL,	NULL,	NULL,	NULL,	'SALT LAKE CITY',	'UT',	'CA5edc4f594c1278d77f11dd5610669a2a',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(743,	'CA293fb1672f07973e4bc117c3bf72cd07',	'',	'2016-12-09 18:20:23',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14243913101',	'+14252338984',	'+14243913101',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA293fb1672f07973e4bc117c3bf72cd07',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(744,	'CA84fa6add9251827d984e3a41f79c5364',	'',	'2016-12-09 23:48:20',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14807298472',	'+14252338984',	'+14807298472',	NULL,	NULL,	NULL,	NULL,	'',	'AZ',	'CA84fa6add9251827d984e3a41f79c5364',	'+14062509831',	'completed',	18,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE95627153cfc2838586a027518ff9c26d',	0,	0,	'',	''),
(745,	'CA5ef5859262098190c2e7aa169fafbba9',	'',	'2016-12-12 14:51:14',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'11733',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15162467115',	'+14062099330',	'+15162467115',	NULL,	NULL,	NULL,	NULL,	'EAST SETAUKET',	'NY',	'CA5ef5859262098190c2e7aa169fafbba9',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(746,	'CAd555f8fae32585111342f4e66c149c4f',	'',	'2016-12-12 18:08:16',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'91950',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16197730607',	'+14252338984',	'+16197730607',	NULL,	NULL,	NULL,	NULL,	'NATIONAL CITY',	'CA',	'CAd555f8fae32585111342f4e66c149c4f',	'+14062509831',	'completed',	18,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE66ced3cd73fcc97f31edc988bc81ed74',	0,	0,	'',	''),
(747,	'CA8289c7d86fcbd34474ed692c462057a0',	'',	'2016-12-12 18:13:16',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'91950',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16197730607',	'+19162627163',	'+16197730607',	NULL,	NULL,	NULL,	NULL,	'NATIONAL CITY',	'CA',	'CA8289c7d86fcbd34474ed692c462057a0',	'+14062509831',	'completed',	18,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe381a4a9bf7197670f94a7426f3f8ac6',	0,	0,	'',	''),
(748,	'CA70369887f548637d47bd0b683b6b76a6',	'',	'2016-12-12 18:18:59',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'91950',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16197730607',	'+16612439350',	'+16197730607',	NULL,	NULL,	NULL,	NULL,	'NATIONAL CITY',	'CA',	'CA70369887f548637d47bd0b683b6b76a6',	'+14062509831',	'completed',	18,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE9026b12bb4712d2856723cadc5b92749',	0,	0,	'',	''),
(749,	'CA6597ae51bdaa6a610059279cb1da9c75',	'',	'2016-12-12 19:22:55',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14243591610',	'+14252338984',	'+14243591610',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA6597ae51bdaa6a610059279cb1da9c75',	'+14062509831',	'completed',	2,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4a1eba6c320e58bf2fd36a3cbd5c3755',	0,	0,	'',	''),
(750,	'CA40927d93d81a5d36735b72b9e4ba67db',	'',	'2016-12-13 00:57:30',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'98045',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14253963003',	'+14252338984',	'+14253963003',	NULL,	NULL,	NULL,	NULL,	'NORTH BEND',	'WA',	'CA40927d93d81a5d36735b72b9e4ba67db',	'+14062509831',	'completed',	18,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE77765cab5be2800564ae6b51e16eb7eb',	0,	0,	'',	''),
(751,	'CA40a36fedf3f1a0fce65afec038e4b406',	'',	'2016-12-13 19:27:15',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19165007359',	'+19162627163',	'+19165007359',	NULL,	NULL,	NULL,	NULL,	'Elk Grove',	'CA',	'CA40a36fedf3f1a0fce65afec038e4b406',	'+14062509831',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE8dfba09dbbf1f6f12b6377c545ee3a58',	0,	0,	'',	''),
(752,	'CA4e56450c9d9b9e22d7d2fc6f33e64f12',	'',	'2016-12-13 19:46:48',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13239225760',	'+14252338984',	'+13239225760',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA4e56450c9d9b9e22d7d2fc6f33e64f12',	'+14062509831',	'completed',	1,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE38b0adcf00fe034f9b5538a2c11bf079',	0,	0,	'',	''),
(753,	'CAce7e7e25fc94ccebc75abf844336c6aa',	'',	'2016-12-14 19:18:37',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13237010665',	'+14252338984',	'+13237010665',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAce7e7e25fc94ccebc75abf844336c6aa',	'+14062509831',	'completed',	2,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4a1045ab5cac5bf59e965272b13a4caf',	0,	0,	'',	''),
(754,	'CA00591b1914e6c79359b6664d6a34b67b',	'',	'2016-12-15 16:43:42',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'90077',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13232722924',	'+16612439350',	'+13232722924',	NULL,	NULL,	NULL,	NULL,	'BEVERLY HILLS',	'CA',	'CA00591b1914e6c79359b6664d6a34b67b',	'+14062509831',	'completed',	18,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE82aa595a1f5cb5a5e77f4e269923f042',	0,	0,	'',	''),
(755,	'CAe38bf8e1c12d1625fabefcf649fa65d0',	'',	'2016-12-15 17:53:45',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19165007359',	'+19162627163',	'+19165007359',	NULL,	NULL,	NULL,	NULL,	'Elk Grove',	'CA',	'CAe38bf8e1c12d1625fabefcf649fa65d0',	'+14062509831',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd1982fe40867a894a1fd7abad1788039',	0,	0,	'',	''),
(756,	'CA81bab584517c184215f30096bc3d616d',	'',	'2016-12-15 19:25:16',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14243017947',	'+14252338984',	'+14243017947',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA81bab584517c184215f30096bc3d616d',	'+14062509831',	'completed',	1,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE37d67c82d720f18a2ca2af1a61d55a9a',	0,	0,	'',	''),
(757,	'CAf4f52709205b4f1535bd7eee952a8b66',	'',	'2016-12-16 17:16:47',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'91950',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16197730607',	'+19162627163',	'+16197730607',	NULL,	NULL,	NULL,	NULL,	'NATIONAL CITY',	'CA',	'CAf4f52709205b4f1535bd7eee952a8b66',	'+14062509831',	'completed',	18,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE1ecbfeaf3f8bae7ea78812884b8108d5',	0,	0,	'',	''),
(758,	'CA0f63257c96723b2530f77e98f4974726',	'',	'2016-12-16 17:25:38',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'91950',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16197730607',	'+14252338984',	'+16197730607',	NULL,	NULL,	NULL,	NULL,	'NATIONAL CITY',	'CA',	'CA0f63257c96723b2530f77e98f4974726',	'+14062509831',	'completed',	18,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb3c6cb654dfb59312e1fe5214b7c8e77',	0,	0,	'',	''),
(759,	'CA4d1b9a9144902145922d27d28117713b',	'',	'2016-12-16 18:32:49',	'US',	'',	'CA',	'',	'US',	'91950',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16197730607',	'+19513741928',	'+16197730607',	NULL,	NULL,	NULL,	NULL,	'NATIONAL CITY',	'CA',	'CA4d1b9a9144902145922d27d28117713b',	'+14062509831',	'completed',	18,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb0e6faf27be923c83d70eefd49a2e435',	0,	0,	'',	''),
(760,	'CAe665cc8331a76cf327d04705a0233af1',	'',	'2016-12-16 18:55:46',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'91950',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16197730607',	'+16612439350',	'+16197730607',	NULL,	NULL,	NULL,	NULL,	'NATIONAL CITY',	'CA',	'CAe665cc8331a76cf327d04705a0233af1',	'+14062509831',	'completed',	18,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE7b948e8408b7400aade98a7604a7f5d3',	0,	0,	'',	''),
(761,	'CA6bba824eb8a176cca953f43016c340c3',	'',	'2016-12-16 19:17:36',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'95404',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17073293011',	'+14252338984',	'+17073293011',	NULL,	NULL,	NULL,	NULL,	'SANTA ROSA',	'CA',	'CA6bba824eb8a176cca953f43016c340c3',	'+14062509831',	'completed',	1,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb3c77e5f68b7f8a9905033d06099151b',	0,	0,	'',	''),
(762,	'CA1f37de1f3291732bcf7b5942d7a9cfb4',	'',	'2016-12-19 19:52:09',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13239225769',	'+14252338984',	'+13239225769',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA1f37de1f3291732bcf7b5942d7a9cfb4',	'+14062509831',	'completed',	2,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE59522ed8b780e5f3919244b0c2694b0d',	0,	0,	'',	''),
(763,	'CAaf6005012e62791c03daf367c720e710',	'',	'2016-12-20 22:29:32',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13852491338',	'+19513741928',	'+13852491338',	NULL,	NULL,	NULL,	NULL,	'SALT LAKE CITY',	'UT',	'CAaf6005012e62791c03daf367c720e710',	'+14062509831',	'completed',	2,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE680404609ad69926ded498e0758f2b5d',	0,	0,	'',	''),
(764,	'CAed9189a4821129f44a4a25e0df83e820',	'',	'2016-12-21 18:22:05',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'90077',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13232722924',	'+16612439350',	'+13232722924',	NULL,	NULL,	NULL,	NULL,	'BEVERLY HILLS',	'CA',	'CAed9189a4821129f44a4a25e0df83e820',	'+14062509831',	'completed',	47,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe22d7eeb902fba10263e5cd5a575880e',	0,	0,	'',	''),
(765,	'CA8161a1c03b68d83b35326a70cd0abcbb',	'',	'2016-12-22 20:15:29',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'85204',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+14252338984',	'+16026353216',	NULL,	NULL,	NULL,	NULL,	'PHOENIX',	'AZ',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(766,	'CAcb0266c6e32464294866fbdbb28d653e',	'',	'2016-12-23 19:17:41',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'68788',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14026852560',	'+14062099330',	'+14026852560',	NULL,	NULL,	NULL,	NULL,	'OAKLAND',	'NE',	'CAcb0266c6e32464294866fbdbb28d653e',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(767,	'CA74036faf7b0ae42b3179d57d8b57aa5f',	'',	'2016-12-23 19:42:34',	'US',	'',	'CA',	'',	'US',	'90024',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13102549377',	'+19513741928',	'+13102549377',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA74036faf7b0ae42b3179d57d8b57aa5f',	'+14062509831',	'completed',	14,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc4ffa7ff2883788e12f6f9bd1b614d8a',	0,	0,	'',	''),
(768,	'CA2df2c749c5aa0275f6c3947dfb42aa13',	'',	'2016-12-30 19:37:04',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'94062',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16503008029',	'+14252338984',	'+16503008029',	NULL,	NULL,	NULL,	NULL,	'WOODSIDE',	'CA',	'CA2df2c749c5aa0275f6c3947dfb42aa13',	'+14062509831',	'completed',	3,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf0d8bc2b0b6562cbea638c9276b9a73b',	0,	0,	'',	''),
(769,	'CA53f42b0f098d0569d36dcf5024eaa2dd',	'',	'2017-01-03 19:14:06',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'91950',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16197730607',	'+14252338984',	'+16197730607',	NULL,	NULL,	NULL,	NULL,	'NATIONAL CITY',	'CA',	'CA53f42b0f098d0569d36dcf5024eaa2dd',	'+14062509831',	'completed',	98,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE6253ca1c6ae357f4e5744f593bb25ec4',	0,	0,	'',	''),
(770,	'CAa452574c5d3a5a17c5a3179d5ae5ace8',	'',	'2017-01-03 19:45:56',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'91950',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16197730607',	'+16612439350',	'+16197730607',	NULL,	NULL,	NULL,	NULL,	'NATIONAL CITY',	'CA',	'CAa452574c5d3a5a17c5a3179d5ae5ace8',	'+14062509831',	'completed',	96,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE7976c404b9d52f91634a5e1e5e6e0b45',	0,	0,	'',	''),
(771,	'CAc424e75647ea4eb210f875389f79f2e4',	'',	'2017-01-03 19:46:55',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'91950',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16197730607',	'+19162627163',	'+16197730607',	NULL,	NULL,	NULL,	NULL,	'NATIONAL CITY',	'CA',	'CAc424e75647ea4eb210f875389f79f2e4',	'+14062509831',	'completed',	98,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd555644e8155efd7e78071fa18f09f72',	0,	0,	'',	''),
(772,	'CAc8311eb15eaa240be59f2d9e95536cab',	'',	'2017-01-03 19:58:43',	'US',	'',	'CA',	'',	'US',	'91950',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16197730607',	'+19513741928',	'+16197730607',	NULL,	NULL,	NULL,	NULL,	'NATIONAL CITY',	'CA',	'CAc8311eb15eaa240be59f2d9e95536cab',	'+14062509831',	'completed',	98,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE66e5e4c3c46567aaa6e094c6e1a39bc5',	0,	0,	'',	''),
(773,	'CA005fa0b8488bc6af541dbf8ce39d55b5',	'',	'2017-01-06 05:40:09',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18006544053',	'+19513741928',	'+18006544053',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA005fa0b8488bc6af541dbf8ce39d55b5',	'+14062509831',	'completed',	68,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE50da126d826c93a21a8713785731a60d',	0,	0,	'',	''),
(774,	'CA752270ba0c7da7d2a723919c6367a780',	'',	'2017-01-06 22:57:55',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'84104',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+16612439350',	'+18019032310',	NULL,	NULL,	NULL,	NULL,	'SALT LAKE CITY',	'UT',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(775,	'CAa4507ad3acaae40ebc153ccd77e98ce6',	'',	'2017-01-09 15:03:17',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'11374',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13477539209',	'+14062099330',	'+13477539209',	NULL,	NULL,	NULL,	NULL,	'REGO PARK',	'NY',	'CAa4507ad3acaae40ebc153ccd77e98ce6',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(776,	'CA8151a65cab86cff89c784a7ef3d2c34a',	'',	'2017-01-09 23:11:17',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18449271818',	'+16612439350',	'+18449271818',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA8151a65cab86cff89c784a7ef3d2c34a',	'+14062509831',	'completed',	17,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb7a25acd3f0eff77e1c6136e3fe9f9a1',	0,	0,	'',	''),
(777,	'CA89c8651dd8f91b396840e96665a2fc01',	'',	'2017-01-09 23:11:53',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'82007',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13074596510',	'+16612439350',	'+13074596510',	NULL,	NULL,	NULL,	NULL,	'CHEYENNE',	'WY',	'CA89c8651dd8f91b396840e96665a2fc01',	'+14062509831',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REcd33b15f9886584d4f74c3022175a27b',	0,	0,	'',	''),
(778,	'CAba3b1165c1469e7cdf479dddf8789706',	'',	'2017-01-10 23:19:53',	'US',	'',	'CA',	'',	'US',	'90017',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17606918405',	'+19513741928',	'+17606918405',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CAba3b1165c1469e7cdf479dddf8789706',	'+14062509831',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REff045589d5f4c1f58ee050a9c18a0306',	0,	0,	'',	''),
(779,	'CA3c1668f279e1cd7ad825fe28e9a91ddb',	'',	'2017-01-12 21:29:08',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'92371',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17602490751',	'+14252338984',	'+17602490751',	NULL,	NULL,	NULL,	NULL,	'WRIGHTWOOD',	'CA',	'CA3c1668f279e1cd7ad825fe28e9a91ddb',	'+14062509831',	'completed',	1,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE8d71411f7fc7ef16d63e6f6d099706c5',	0,	0,	'',	''),
(780,	'CAf336b54b0bd96d4f20850cbd53138612',	'',	'2017-01-13 22:44:55',	'US',	'',	'CA',	'',	'US',	'90017',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17606918405',	'+19513741928',	'+17606918405',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CAf336b54b0bd96d4f20850cbd53138612',	'+14062509831',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE27ad98380ce8c6f98e32d1dd669c4366',	0,	0,	'',	''),
(781,	'CAdc3ce0db63272e6a5e5c67b7dd778c4a',	'',	'2017-01-17 16:10:39',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'92123',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18589970426',	'+14252338984',	'+18589970426',	NULL,	NULL,	NULL,	NULL,	'SAN DIEGO',	'CA',	'CAdc3ce0db63272e6a5e5c67b7dd778c4a',	'+14062509831',	'completed',	63,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE0d73dd0d300bf871c82bcf703802e6d1',	0,	0,	'',	''),
(782,	'CA333394eb7be3614ab03263175bf494ec',	'',	'2017-01-17 16:32:16',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'92123',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18589970426',	'+19162627163',	'+18589970426',	NULL,	NULL,	NULL,	NULL,	'SAN DIEGO',	'CA',	'CA333394eb7be3614ab03263175bf494ec',	'+14062509831',	'completed',	63,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd29df125dc41e20effa99536e01ac7ae',	0,	0,	'',	''),
(783,	'CA2d9241eb453709efec29af47fa37cf1a',	'',	'2017-01-17 16:40:12',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'92123',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18589970426',	'+16612439350',	'+18589970426',	NULL,	NULL,	NULL,	NULL,	'SAN DIEGO',	'CA',	'CA2d9241eb453709efec29af47fa37cf1a',	'+14062509831',	'completed',	63,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe35e321e793ab522a56c6319fe41a586',	0,	0,	'',	''),
(784,	'CA61ef15da70e5c2f96b385a6cf8016ce0',	'',	'2017-01-17 17:01:09',	'US',	'',	'CA',	'',	'US',	'92123',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18589970426',	'+19513741928',	'+18589970426',	NULL,	NULL,	NULL,	NULL,	'SAN DIEGO',	'CA',	'CA61ef15da70e5c2f96b385a6cf8016ce0',	'+14062509831',	'completed',	63,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REfbfa7c6f4f8171898e2f22b836396d87',	0,	0,	'',	''),
(785,	'CAa71828432ea7739231ff5373301111bc',	'',	'2017-01-17 18:47:48',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'91934',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16192024256',	'+19162627163',	'+16192024256',	NULL,	NULL,	NULL,	NULL,	'BOULEVARD',	'CA',	'CAa71828432ea7739231ff5373301111bc',	'+14062509831',	'completed',	22,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe5106ec8eb0bcfdc44b11a77cf8b0632',	0,	0,	'',	''),
(786,	'CA5e0a86bcf5d06a9f1e42a3f4f7ec74f5',	'',	'2017-01-17 19:46:56',	'US',	'',	'CA',	'',	'US',	'90017',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17606918405',	'+19513741928',	'+17606918405',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA5e0a86bcf5d06a9f1e42a3f4f7ec74f5',	'+14062509831',	'completed',	36,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE12453e5367ae425cec460181878015a3',	0,	0,	'',	''),
(787,	'CAa736407f6138e6a8499b4a52bb55297b',	'',	'2017-01-20 21:12:52',	'US',	'',	'CA',	'',	'US',	'35124',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12056057613',	'+19513741928',	'+12056057613',	NULL,	NULL,	NULL,	NULL,	'ALABASTER',	'AL',	'CA42914758cc91395c7b0ecbae05e96cc4',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(788,	'CA758f19fb75e3452031aef8b52bf5b502',	'',	'2017-01-23 17:31:17',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'92123',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18589970426',	'+14252338984',	'+18589970426',	NULL,	NULL,	NULL,	NULL,	'SAN DIEGO',	'CA',	'CA758f19fb75e3452031aef8b52bf5b502',	'+14062509831',	'completed',	63,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE5c26b12a88cb34fd1cc7020c4e5b5316',	0,	0,	'',	''),
(789,	'CAa89e405f55b55ad8a363380f20c40800',	'',	'2017-01-23 17:39:05',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'92123',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18589970426',	'+19162627163',	'+18589970426',	NULL,	NULL,	NULL,	NULL,	'SAN DIEGO',	'CA',	'CAa89e405f55b55ad8a363380f20c40800',	'+14062509831',	'completed',	63,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb1f137445f294205f7f980fe1395ca2e',	0,	0,	'',	''),
(790,	'CA23d1c3d8785bcf386da9a6b4ae9607c2',	'',	'2017-01-23 17:39:18',	'US',	'',	'CA',	'',	'US',	'92123',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18589970426',	'+19513741928',	'+18589970426',	NULL,	NULL,	NULL,	NULL,	'SAN DIEGO',	'CA',	'CA23d1c3d8785bcf386da9a6b4ae9607c2',	'+14062509831',	'completed',	63,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3039f7f20a16bb25536e8b4cfc4e7b71',	0,	0,	'',	''),
(791,	'CAa8fc191529827fa950f587590af31406',	'',	'2017-01-24 23:51:43',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14152663364',	'+19513741928',	'+14152663364',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAd6eddf9a769604f27ea06602ec2bad2d',	'+14062509831',	'voicemail',	15,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE858e623de0a3ee985495833881eedc53',	0,	0,	'',	''),
(792,	'CAdc90df2fdc8fb47b89bb99555617c9d1',	'',	'2017-01-25 19:14:36',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14152663364',	'+19513741928',	'+14152663364',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAdc90df2fdc8fb47b89bb99555617c9d1',	'+14062509831',	'completed',	33,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REbdb7c7ee25a5b5d8ead06b0aeae9b008',	0,	0,	'',	''),
(793,	'CA833664fe22a6cf351b646f2efaf2fa26',	'',	'2017-01-25 22:41:51',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+14252338984',	'+18773106676',	NULL,	NULL,	NULL,	NULL,	'',	'',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(794,	'CA7292127e47daeb171bd95e7ac5c00373',	'',	'2017-01-26 17:59:42',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'94903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14152267855',	'+19162627163',	'+14152267855',	NULL,	NULL,	NULL,	NULL,	'SAN RAFAEL',	'CA',	'CA7292127e47daeb171bd95e7ac5c00373',	'+14062509831',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE04f3724ebf3c96ad1a88ad0abf9cd826',	0,	0,	'',	''),
(795,	'CA475bdb0b7966767efb446f0bfffc7f04',	'',	'2017-01-26 18:00:19',	'US',	'',	'CA',	'',	'US',	'94903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14152267855',	'+19513741928',	'+14152267855',	NULL,	NULL,	NULL,	NULL,	'SAN RAFAEL',	'CA',	'CA475bdb0b7966767efb446f0bfffc7f04',	'+14062509831',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe40d78fdc4ce6cc9a77b53f79291a556',	0,	0,	'',	''),
(796,	'CAfb1d911904e12df665463d7531e0ad5f',	'',	'2017-01-26 18:48:57',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'91934',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16192024256',	'+19162627163',	'+16192024256',	NULL,	NULL,	NULL,	NULL,	'BOULEVARD',	'CA',	'CA929dc836eaeeff3a1330cf2b0d0aaa63',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(797,	'CA73a11f510921b33406c65230c3d82f1b',	'',	'2017-01-26 19:25:59',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19096872077',	'+14252338984',	'+19096872077',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA73a11f510921b33406c65230c3d82f1b',	'+14062509831',	'completed',	2,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE39ea9fb33fcb900c867ae1f1a4ee090e',	0,	0,	'',	''),
(798,	'CA55667c1aa975a756b25d089f23021dbb',	'',	'2017-01-26 21:04:12',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14152663364',	'+19513741928',	'+14152663364',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA55667c1aa975a756b25d089f23021dbb',	'+14062509831',	'completed',	34,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE1385bf8d15b32cf5ae4b984a83cdfd85',	0,	0,	'',	''),
(799,	'CAc8ebe880ffbe8ac6e55b7ad5b81617c7',	'',	'2017-01-27 18:57:11',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14807298472',	'+14252338984',	'+14807298472',	NULL,	NULL,	NULL,	NULL,	'',	'AZ',	'CAc8ebe880ffbe8ac6e55b7ad5b81617c7',	'+14062509831',	'completed',	50,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc23941601214442610a1c7addd9dab51',	0,	0,	'',	''),
(800,	'CA4745484f47f1ba637f956315f4d31c2a',	'',	'2017-01-27 21:11:16',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'80903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17196242378',	'+16612439350',	'+17196242378',	NULL,	NULL,	NULL,	NULL,	'COLORADO SPRINGS',	'CO',	'CA4745484f47f1ba637f956315f4d31c2a',	'+14062509831',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb8a8cc40f9a7721da885148078d7db75',	0,	0,	'',	''),
(801,	'CA28d12a9e7e1ec45f487c28883f704179',	'',	'2017-01-30 22:58:03',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'80903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17196242378',	'+16612439350',	'+17196242378',	NULL,	NULL,	NULL,	NULL,	'COLORADO SPRINGS',	'CO',	'CA28d12a9e7e1ec45f487c28883f704179',	'+14062509831',	'completed',	50,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb45cc6c371e92683a88de63db99e9730',	0,	0,	'',	''),
(802,	'CA14657543f624516a00e0cc44676248e5',	'',	'2017-01-31 16:15:43',	'US',	'',	'CA',	'',	'US',	'92123',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18589970426',	'+19513741928',	'+18589970426',	NULL,	NULL,	NULL,	NULL,	'SAN DIEGO',	'CA',	'CA14657543f624516a00e0cc44676248e5',	'+14062509831',	'completed',	64,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REcab6caee2e358cb7457e38e288f31da3',	0,	0,	'',	''),
(803,	'CA204f93eaf264e71a194ded95c890b11d',	'',	'2017-01-31 16:43:36',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'92123',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18589970426',	'+19162627163',	'+18589970426',	NULL,	NULL,	NULL,	NULL,	'SAN DIEGO',	'CA',	'CA204f93eaf264e71a194ded95c890b11d',	'+14062509831',	'completed',	62,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE00e4ba1cb2af736884b8a7a728a3b521',	0,	0,	'',	''),
(804,	'CAe5ef96a3afe3c2de78e31de0174e92da',	'',	'2017-01-31 16:53:57',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'92123',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18589970426',	'+14252338984',	'+18589970426',	NULL,	NULL,	NULL,	NULL,	'SAN DIEGO',	'CA',	'CAe5ef96a3afe3c2de78e31de0174e92da',	'+14062509831',	'completed',	63,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REda40e07bcb0e78f0bdf62f8ba8c6d697',	0,	0,	'',	''),
(805,	'CAdec56487e10e28d116a0e03cdeb33bb7',	'',	'2017-01-31 18:31:52',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'80903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17196242378',	'+16612439350',	'+17196242378',	NULL,	NULL,	NULL,	NULL,	'COLORADO SPRINGS',	'CO',	'CAdec56487e10e28d116a0e03cdeb33bb7',	'+14062509831',	'completed',	46,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REdbc39daba081f321e40cc2637f77073d',	0,	0,	'',	''),
(806,	'CA8d78edbaf1a54b592837a35537463899',	'',	'2017-01-31 21:19:20',	'US',	'',	'CA',	'',	'US',	'96091',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15303950145',	'+19513741928',	'+15303950145',	NULL,	NULL,	NULL,	NULL,	'LEWISTON',	'CA',	'CA8d78edbaf1a54b592837a35537463899',	'+14062509831',	'completed',	14,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd3ffcbee72930c2cb6b517cc5b2c5ec2',	0,	0,	'',	''),
(807,	'CAd1657307875dddc3d35319c1a13f8a49',	'',	'2017-02-01 16:53:34',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'91941',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16198289064',	'+19162627163',	'+16198289064',	NULL,	NULL,	NULL,	NULL,	'SAN DIEGO',	'CA',	'CA14e42e9a6e3bee0d3962ee882b27a503',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(808,	'CA840dae3532193c354368f363232d4fd3',	'',	'2017-02-01 17:19:46',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'84104',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+16612439350',	'+18019032310',	NULL,	NULL,	NULL,	NULL,	'SALT LAKE CITY',	'UT',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(809,	'CA849244af2b64f1e51194f272f4558c6d',	'',	'2017-02-01 19:50:00',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'30507',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17705199695',	'+14252338984',	'+17705199695',	NULL,	NULL,	NULL,	NULL,	'GAINESVILLE',	'GA',	'CA4dbd5cc2952a55b8f8c86d6773f100f8',	'+14062509831',	'voicemail',	2,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa29695dbb17487bcb1ce50961fa78c3d',	0,	0,	'',	''),
(810,	'CA38bac5ba738d3ad141ae60a4c89c1902',	'',	'2017-02-01 22:07:34',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'84104',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+16612439350',	'+18019032310',	NULL,	NULL,	NULL,	NULL,	'SALT LAKE CITY',	'UT',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(811,	'CA6366c82eea7756d8b1d11fc038cac520',	'',	'2017-02-02 19:03:08',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'84104',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+16612439350',	'+18019032310',	NULL,	NULL,	NULL,	NULL,	'SALT LAKE CITY',	'UT',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(812,	'CA6a66daedfa31e34f42125e003c8a7f10',	'',	'2017-02-02 20:47:36',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'84104',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+16612439350',	'+18019032310',	NULL,	NULL,	NULL,	NULL,	'SALT LAKE CITY',	'UT',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(813,	'CA9a317747e49552ada0befeb76b918e07',	'',	'2017-02-03 17:24:25',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'84104',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+16612439350',	'+18019032310',	NULL,	NULL,	NULL,	NULL,	'SALT LAKE CITY',	'UT',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(814,	'CA23e7e6af8b0f0d93aec03b7b11347a8d',	'',	'2017-02-03 17:36:35',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'33480',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15614598200',	'+16612439350',	'+15614598200',	NULL,	NULL,	NULL,	NULL,	'WEST PALM BEACH',	'FL',	'CA23e7e6af8b0f0d93aec03b7b11347a8d',	'+14062509831',	'completed',	1,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE7e4790572bf042ccec30e99a8ea81463',	0,	0,	'',	''),
(815,	'CAa850caefa6c5d730dc360ed66602af46',	'',	'2017-02-03 17:58:47',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'33480',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15614598200',	'+19162627163',	'+15614598200',	NULL,	NULL,	NULL,	NULL,	'WEST PALM BEACH',	'FL',	'CAa850caefa6c5d730dc360ed66602af46',	'+14062509831',	'completed',	14,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE6e96704690a55995c5ba241354ad9951',	0,	0,	'',	''),
(816,	'CA58fbd8511875b80ff7775fb72e1f4517',	'',	'2017-02-03 18:01:15',	'US',	'',	'CA',	'',	'US',	'33480',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15614598200',	'+19513741928',	'+15614598200',	NULL,	NULL,	NULL,	NULL,	'WEST PALM BEACH',	'FL',	'CA58fbd8511875b80ff7775fb72e1f4517',	'+14062509831',	'completed',	18,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE5128aff36c4c78c695dac6b923e4996a',	0,	0,	'',	''),
(817,	'CA3ba3ef7b7260ccae70d658aa85a5bab3',	'',	'2017-02-03 18:08:31',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'33480',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15614598200',	'+14252338984',	'+15614598200',	NULL,	NULL,	NULL,	NULL,	'WEST PALM BEACH',	'FL',	'CAc98da5f29794714e38577c8f1ea72922',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(818,	'CA53ed56157c87f2b88d96480e8cdf0989',	'',	'2017-02-03 19:35:03',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'84104',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+16612439350',	'+18019032310',	NULL,	NULL,	NULL,	NULL,	'SALT LAKE CITY',	'UT',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(819,	'CA3c5a2e3f92eda055761e927400511a34',	'',	'2017-02-03 20:34:31',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95822',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19162627163',	'+19167991398',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(820,	'CA2b83a50f0315b53199ac47803889556d',	'',	'2017-02-03 20:41:35',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'84104',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+16612439350',	'+18019032310',	NULL,	NULL,	NULL,	NULL,	'SALT LAKE CITY',	'UT',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(821,	'CAef464f144d7e625492ac0b7edaf9dc64',	'',	'2017-02-07 18:02:36',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'92123',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18589970426',	'+14252338984',	'+18589970426',	NULL,	NULL,	NULL,	NULL,	'SAN DIEGO',	'CA',	'CAef464f144d7e625492ac0b7edaf9dc64',	'+14062509831',	'completed',	73,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE993a3c1198685ed6f0eba37ac5a9dbf6',	0,	0,	'',	''),
(822,	'CA26f7c31ac039386360591105dd354318',	'',	'2017-02-07 18:10:17',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19162627163',	'+17207707169',	NULL,	NULL,	NULL,	NULL,	'',	'CO',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(823,	'CA16393116d8c2a6e77364ca9d10e94dbc',	'',	'2017-02-07 18:15:10',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'92123',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18589970426',	'+19162627163',	'+18589970426',	NULL,	NULL,	NULL,	NULL,	'SAN DIEGO',	'CA',	'CA16393116d8c2a6e77364ca9d10e94dbc',	'+14062509831',	'completed',	72,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE9b8f55d7e1d2709ce938f6fcce03971d',	0,	0,	'',	''),
(824,	'CA1fb9ae9e8258e188cc5e1f14004b00c1',	'',	'2017-02-07 18:26:29',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18662458848',	'+19513741928',	'+18662458848',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA1fb9ae9e8258e188cc5e1f14004b00c1',	'+14062509831',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE03010173c1d551197be6150a5a6df1a4',	0,	0,	'',	''),
(825,	'CAfeb973a321d259e4782499c0816fe7c7',	'',	'2017-02-07 18:43:34',	'US',	'',	'CA',	'',	'US',	'92123',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18589970426',	'+19513741928',	'+18589970426',	NULL,	NULL,	NULL,	NULL,	'SAN DIEGO',	'CA',	'CAfeb973a321d259e4782499c0816fe7c7',	'+14062509831',	'completed',	73,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REca255ca285c8fa3f623b08b70b85ef1a',	0,	0,	'',	''),
(826,	'CA4a2b3ce35ea83074fa516210142076e7',	'',	'2017-02-07 20:43:00',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'84104',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+16612439350',	'+18019032310',	NULL,	NULL,	NULL,	NULL,	'SALT LAKE CITY',	'UT',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(827,	'CA02fde0b034fac86fad57cff6fd998a87',	'',	'2017-02-09 18:28:44',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17205000279',	'+14062099330',	'+17205000279',	NULL,	NULL,	NULL,	NULL,	'',	'CO',	'CA02fde0b034fac86fad57cff6fd998a87',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(828,	'CA161c8baf04e9cfe8dde737944d79ad9d',	'',	'2017-02-10 19:33:47',	'US',	'',	'CA',	'',	'US',	'46240',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19513741928',	'+13177156266',	NULL,	NULL,	NULL,	NULL,	'INDIANAPOLIS',	'IN',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(829,	'CA0dbc2af682a30c19f7df2084bfb790e8',	'',	'2017-02-14 18:52:39',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18058621018',	'+14252338984',	'+18058621018',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA0dbc2af682a30c19f7df2084bfb790e8',	'+14062509831',	'completed',	3,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE7680234dc83316074c5b80ad3712dcad',	0,	0,	'',	''),
(830,	'CA274389d73844a624fcc0b31bb9a580cb',	'',	'2017-02-15 21:45:44',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'92673',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19493262432',	'+14252338984',	'+19493262432',	NULL,	NULL,	NULL,	NULL,	'LADERA RANCH',	'CA',	'CA274389d73844a624fcc0b31bb9a580cb',	'+14062509831',	'completed',	3,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe3abf039dc2be9b44b6904ec554dbb83',	0,	0,	'',	''),
(831,	'CAab4cf4255c4f84e35ac90e358677cfcb',	'',	'2017-02-16 19:23:03',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'92065',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17602390079',	'+14252338984',	'+17602390079',	NULL,	NULL,	NULL,	NULL,	'RAMONA',	'CA',	'CA2401569cd6fadc6eb9418288870109ad',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(832,	'CAce8102f8576edc5839005363a63ab923',	'',	'2017-02-17 19:47:33',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19167588598',	'+14252338984',	'+19167588598',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAce8102f8576edc5839005363a63ab923',	'+14062509831',	'completed',	3,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REcdfcbd6bd793b18fcbcab2d1a0cd67a4',	0,	0,	'',	''),
(833,	'CA3662958ca87f293b369ae51a73435c5f',	'',	'2017-02-18 18:25:47',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'59903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14062509831',	'+14062099330',	'+14062509831',	NULL,	NULL,	NULL,	NULL,	'KALISPELL',	'MT',	'CA75fc130f6af862beb9ad604aa4d75340',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(834,	'CA5d043e1429de7bb726e91de2898a3f6e',	'',	'2017-02-18 18:49:22',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'59601',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14068711391',	'+14062099330',	'+14068711391',	NULL,	NULL,	NULL,	NULL,	'HELENA',	'MT',	'CAa35a6b8fa32dc0859ca859f05f947bbd',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(835,	'CA7c9c4740683988ab4449f58c1a93d8f3',	'',	'2017-02-20 15:45:33',	'US',	'83001',	'WY',	'JACKSON',	'US',	'59903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+13072014710',	'+14062509831',	NULL,	NULL,	NULL,	NULL,	'KALISPELL',	'MT',	NULL,	NULL,	'voicemail',	4,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe64fde04c917bf75c5e7100922d7afd2',	0,	0,	'',	''),
(836,	'CA5e9b5214f5ca63b37cd9e576728f778d',	'',	'2017-02-20 15:48:35',	'US',	'83001',	'WY',	'JACKSON',	'US',	'59903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+13072014710',	'+14062509831',	NULL,	NULL,	NULL,	NULL,	'KALISPELL',	'MT',	NULL,	NULL,	'voicemail',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REac270f86561843c23dffe56ede0ce0a6',	0,	0,	'',	''),
(837,	'CAc05eec69835a7f71c2b0677177c951cc',	'',	'2017-02-20 23:06:16',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'91608',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18186550005',	'+14252338984',	'+18186550005',	NULL,	NULL,	NULL,	NULL,	'N HOLLYWOOD',	'CA',	'CAfeb5cf58bc991c85e67f9fe5472c669c',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(838,	'CAd8d171c78001f82f63f0a1303b052371',	'',	'2017-02-21 19:01:05',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14152663364',	'+19513741928',	'+14152663364',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAd8d171c78001f82f63f0a1303b052371',	'+14062509831',	'completed',	40,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE6d743a0d9aa3ed1a74c75fd3138ad7ff',	0,	0,	'',	''),
(839,	'CA958259888d485acce4936a8d94b6c212',	'',	'2017-02-23 00:52:10',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'59903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14062509831',	'+19722036640',	'+14062509831',	NULL,	NULL,	NULL,	NULL,	'KALISPELL',	'MT',	'CA958259888d485acce4936a8d94b6c212',	'+12148780214',	'completed',	85,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REdd7f9bab32390fc30e3aa69031e8a83c',	0,	0,	'',	''),
(840,	'CA4c6547b5e25d99d713075d40dd64ba5c',	'',	'2017-02-23 00:53:53',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'59903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14062509831',	'+19722036640',	'+14062509831',	NULL,	NULL,	NULL,	NULL,	'KALISPELL',	'MT',	'CA4c6547b5e25d99d713075d40dd64ba5c',	'+12148780214',	'completed',	60,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE586f7fe44366fba90a212bc487f30822',	0,	0,	'',	''),
(841,	'CAf59a0d0afbe9dffa2ee50ae43ed43218',	'',	'2017-02-23 00:55:11',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'59903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14062509831',	'+19722036640',	'+14062509831',	NULL,	NULL,	NULL,	NULL,	'KALISPELL',	'MT',	'CAf59a0d0afbe9dffa2ee50ae43ed43218',	'+12148780214',	'completed',	103,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE59b7ed1abba163eff20afce16deb785f',	0,	0,	'',	''),
(842,	'CA44d79b646d8d470d523256462c2a0373',	'',	'2017-02-23 00:57:57',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'59903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14062509831',	'+19722036640',	'+14062509831',	NULL,	NULL,	NULL,	NULL,	'KALISPELL',	'MT',	'CA44d79b646d8d470d523256462c2a0373',	'+12148780214',	'completed',	36,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3d978835dd68a6da62b65021565720a7',	0,	0,	'',	''),
(843,	'CAb7723277db5b76d48c5f8f5e35ec1d1b',	'',	'2017-02-23 00:58:49',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'59903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14062509831',	'+19722036640',	'+14062509831',	NULL,	NULL,	NULL,	NULL,	'KALISPELL',	'MT',	'CAb7723277db5b76d48c5f8f5e35ec1d1b',	'+12148780214',	'completed',	743,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd495bd117c79080eb5e4e499100789aa',	0,	0,	'',	''),
(844,	'CA5582f450f42517d56c94662348a8a60a',	'',	'2017-02-23 15:05:24',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'11733',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+14062099330',	'+15162467112',	NULL,	NULL,	NULL,	NULL,	'EAST SETAUKET',	'NY',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(845,	'CA98726d4e11c87dda62b7c3bb833b9f35',	'',	'2017-02-23 15:05:26',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'11733',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+14062099330',	'+15162467112',	NULL,	NULL,	NULL,	NULL,	'EAST SETAUKET',	'NY',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(846,	'CA7a4c36e52c1b2fea87bd7fde3d6d7f72',	'',	'2017-02-23 15:05:29',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'11733',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+14062099330',	'+15162467112',	NULL,	NULL,	NULL,	NULL,	'EAST SETAUKET',	'NY',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(847,	'CAce684f8e1013d3b1c7ce89c911640e66',	'',	'2017-02-23 20:11:05',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'59903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19722036609',	'+14062509831',	NULL,	NULL,	NULL,	NULL,	'KALISPELL',	'MT',	NULL,	NULL,	'voicemail',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE7d26fe2588df9ee00b64eba2e6ebd397',	0,	0,	'',	''),
(848,	'CA1e7a195f736ffea56460dc757fe50445',	'',	'2017-02-23 20:43:47',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'59903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19722036609',	'+14062509831',	NULL,	NULL,	NULL,	NULL,	'KALISPELL',	'MT',	NULL,	NULL,	'voicemail',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4dbb36799eee46cf8bc2ec82a8533ee8',	0,	0,	'',	''),
(849,	'CAb832c9a5c9976923e9651fd15ca78daf',	'',	'2017-02-23 21:26:00',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75220',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19722036609',	'+12148780214',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	NULL,	NULL,	'voicemail',	15,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE69ae21ae72c3b1e64641f900c93cf5e1',	0,	0,	'',	''),
(850,	'CA835f0e2b2a4c3eca18f0fc0a16a18dea',	'',	'2017-02-23 21:31:07',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75220',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19722036609',	'+12148780214',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	NULL,	NULL,	'voicemail',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4589a86858660afe26200f1d504b4441',	0,	0,	'',	''),
(851,	'CA457d8f5d255eb0795abccb629537309f',	'',	'2017-02-24 02:16:27',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'76140',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19722036609',	'+18172910201',	NULL,	NULL,	NULL,	NULL,	'ARLINGTON',	'TX',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(852,	'CA411207db399da7dd036297685c22937b',	'',	'2017-02-24 02:46:39',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75219',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19722036609',	'+12147233688',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(853,	'CA2bf4131b8d1a1a200302be9c88a5c6ca',	'',	'2017-02-24 09:11:18',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'76088',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19722036609',	'+18174548771',	NULL,	NULL,	NULL,	NULL,	'FORT WORTH',	'TX',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(854,	'CAbaa90bb519671335b5566f3afee12a63',	'',	'2017-02-24 11:55:49',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14063002236',	'+14062099330',	'+14063002236',	NULL,	NULL,	NULL,	NULL,	'',	'MT',	'CAbaa90bb519671335b5566f3afee12a63',	'+14062509831',	'completed',	18,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE5493b3898524d8b2ca0d144320b7d4d6',	0,	0,	'',	''),
(855,	'CA95655fe98fedbd90098702b35ced3adc',	'',	'2017-02-24 11:57:19',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14063002236',	'+14062099330',	'+14063002236',	NULL,	NULL,	NULL,	NULL,	'',	'MT',	'CA95655fe98fedbd90098702b35ced3adc',	'+14062509831',	'completed',	27,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb7ede1f9abefacaea00961cc0af60d57',	0,	0,	'',	''),
(856,	'CAbac62bf7ea42ab55756aeae66f7b241a',	'',	'2017-02-24 12:06:48',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14063002236',	'+14062099330',	'+14063002236',	NULL,	NULL,	NULL,	NULL,	'',	'MT',	'CAbac62bf7ea42ab55756aeae66f7b241a',	'+14062509831',	'completed',	18,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE72f8d74bf3b45e96bb0b2fb0704ad7ab',	0,	0,	'',	''),
(857,	'CAaf540281ef23e464658158235f260e5e',	'',	'2017-02-24 12:07:18',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14063002236',	'+14062099330',	'+14063002236',	NULL,	NULL,	NULL,	NULL,	'',	'MT',	'CAaf540281ef23e464658158235f260e5e',	'+14062509831',	'completed',	37,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE0d35125854ef34cd423c5d7b6cd03b8d',	0,	0,	'',	''),
(858,	'CA00e9530d4275b038d8ba9adeda8beb3d',	'',	'2017-02-24 12:17:51',	'US',	'75050',	'TX',	'GRAND PRAIRIE',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+12143052027',	'+14063002236',	NULL,	NULL,	NULL,	NULL,	'',	'MT',	NULL,	NULL,	'voicemail',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc2c7a446cd06d7e4e6df83754e110960',	0,	0,	'',	''),
(859,	'CAb3491c6703b003596487782d4b64ffc0',	'',	'2017-02-24 12:34:20',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14063002236',	'+14062099330',	'+14063002236',	NULL,	NULL,	NULL,	NULL,	'',	'MT',	'CAb3491c6703b003596487782d4b64ffc0',	'+14062509831',	'completed',	16,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE0b6f03317f5da722789a64fb4fc83272',	0,	0,	'',	''),
(860,	'CAb2cedbdd9f6c7a14136a8d5f970d27ec',	'',	'2017-02-24 12:34:48',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14063002236',	'+14062099330',	'+14063002236',	NULL,	NULL,	NULL,	NULL,	'',	'MT',	'CAb2cedbdd9f6c7a14136a8d5f970d27ec',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(861,	'CA3a84d2fc1b7b944f7de1cbaf4b77ecd7',	'',	'2017-02-24 12:35:32',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14063002236',	'+14062099330',	'+14063002236',	NULL,	NULL,	NULL,	NULL,	'',	'MT',	'CA3a84d2fc1b7b944f7de1cbaf4b77ecd7',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(862,	'CAf195d506c9d56c5704ea731ae5b3370a',	'',	'2017-02-24 12:36:43',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14063002236',	'+14062099330',	'+14063002236',	NULL,	NULL,	NULL,	NULL,	'',	'MT',	'CAf195d506c9d56c5704ea731ae5b3370a',	'+14062509831',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE2a326a7f3343febd740cdbe9c04a6c87',	0,	0,	'',	''),
(863,	'CA198dc60d364e25d34666b32a64f796c9',	'',	'2017-02-24 12:37:10',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14063002236',	'+14062099330',	'+14063002236',	NULL,	NULL,	NULL,	NULL,	'',	'MT',	'CA198dc60d364e25d34666b32a64f796c9',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(864,	'CAcc448bef8935993d47df9cf14c72f014',	'',	'2017-02-24 12:37:53',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14063002236',	'+14062099330',	'+14063002236',	NULL,	NULL,	NULL,	NULL,	'',	'MT',	'CA240208a47994c7b664f38ccb95c4ac65',	'+14062509831',	'voicemail',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE03cda4b9dad1238a4cadd29f917d4d4f',	0,	0,	'',	''),
(865,	'CAfbf6c2d6f7c86f638d076bf9b6c552b7',	'',	'2017-02-24 12:38:50',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14063002236',	'+14062099330',	'+14063002236',	NULL,	NULL,	NULL,	NULL,	'',	'MT',	'CAfbf6c2d6f7c86f638d076bf9b6c552b7',	'+14062509831',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa0d0677bb468789468ff93f82c3f96a9',	0,	0,	'',	''),
(866,	'CA6da9bc940559afd72a371b1ec147d6a9',	'',	'2017-02-24 12:39:13',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14063002236',	'+14062099330',	'+14063002236',	NULL,	NULL,	NULL,	NULL,	'',	'MT',	'CA6ea1016a25c50584d1d14229df464999',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(867,	'CA80cdca83afaeb762f0c05da27ffed23c',	'',	'2017-02-24 12:39:54',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14063002236',	'+14062099330',	'+14063002236',	NULL,	NULL,	NULL,	NULL,	'',	'MT',	'CAe5526057986eb1e115e87d243430cbb9',	'+14062509831',	'voicemail',	2,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe0c5abd9fe6bcec8df9cba5651f38f72',	0,	0,	'',	''),
(868,	'CAfef2d7379425c64f7f1d2132f105e2be',	'',	'2017-02-27 01:35:46',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75052',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19722036609',	'+14695851888',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(869,	'CA9e32630e57ebd4babe59f492246dad39',	'',	'2017-02-28 05:27:26',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18668322889',	'+19513741928',	'+18668322889',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA9e32630e57ebd4babe59f492246dad39',	'+14062509831',	'completed',	71,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REed9f3303ecce782ca2a341d396311f64',	0,	0,	'',	''),
(870,	'CA141d0908b6d8737ae182e3aa1a6cab76',	'',	'2017-02-28 19:47:07',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19167588617',	'+14252338984',	'+19167588617',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA141d0908b6d8737ae182e3aa1a6cab76',	'+14062509831',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REfb343da46b445188869905e745b1fb9e',	0,	0,	'',	''),
(871,	'CAd92b81d13a79bcfd851833c01b0c418d',	'',	'2017-02-28 23:20:04',	'US',	'',	'CA',	'',	'US',	'90017',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17606918336',	'+19513741928',	'+17606918336',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CAd92b81d13a79bcfd851833c01b0c418d',	'+14062509831',	'completed',	53,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE64b76f68ad799cebe50936a761370559',	0,	0,	'',	''),
(872,	'CA4d9f43a1795f47279af9b9e14874785a',	'',	'2017-03-01 19:19:12',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'93283',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17602998449',	'+14252338984',	'+17602998449',	NULL,	NULL,	NULL,	NULL,	'WELDON',	'CA',	'CA4d9f43a1795f47279af9b9e14874785a',	'+14062509831',	'completed',	4,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REfc18c2fd3b2b5978d8fb3c0469338eff',	0,	0,	'',	''),
(873,	'CA5c7ab2b9d1844214f7bdc3c8009fa010',	'',	'2017-03-01 19:33:07',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14063002236',	'+14062099330',	'+14063002236',	NULL,	NULL,	NULL,	NULL,	'',	'MT',	'CA5c7ab2b9d1844214f7bdc3c8009fa010',	'+14062509831',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4db51cc5e836eec7ed5c0d1326db4f98',	0,	0,	'',	''),
(874,	'CAb5f72c246e31215a3329999a7aa43822',	'',	'2017-03-01 19:33:32',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14063002236',	'+14062099330',	'+14063002236',	NULL,	NULL,	NULL,	NULL,	'',	'MT',	'CAb5f72c246e31215a3329999a7aa43822',	'+14062509831',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE7cdd6a3a0be230bbc9424a5642ad0d25',	0,	0,	'',	''),
(875,	'CA4ad4cc9bac0c5a3720eec35e11e08ec8',	'',	'2017-03-01 19:34:16',	'US',	'75050',	'TX',	'GRAND PRAIRIE',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+12143052027',	'+14063002236',	NULL,	NULL,	NULL,	NULL,	'',	'MT',	NULL,	NULL,	'voicemail',	12,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE73bd6ae84710c84278bfe92e796828be',	0,	0,	'',	''),
(876,	'CA7d3be01f33e4df8512b54acf6c49d161',	'',	'2017-03-01 19:36:09',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14063002236',	'+14062099330',	'+14063002236',	NULL,	NULL,	NULL,	NULL,	'',	'MT',	'CA7d3be01f33e4df8512b54acf6c49d161',	'+14062509831',	'completed',	28,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REbd764b159e26120dadab133af4ce3e55',	0,	0,	'',	''),
(877,	'CAe3cbfae19dfd59cd9aaf49e6ec8a8ce8',	'',	'2017-03-01 19:37:32',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14063002236',	'+14062099330',	'+14063002236',	NULL,	NULL,	NULL,	NULL,	'',	'MT',	'CAe3cbfae19dfd59cd9aaf49e6ec8a8ce8',	'+14062509831',	'completed',	29,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REeb7e0ab347f5b6086dbcc3016dac03d5',	0,	0,	'',	''),
(878,	'CAaf5e90ae6109ec45030b94a9c7502583',	'',	'2017-03-01 19:39:38',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14063002236',	'+14062099330',	'+14063002236',	NULL,	NULL,	NULL,	NULL,	'',	'MT',	'CAe3148596b31ad3811f7baa6676b6bfa3',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(879,	'CAe309551260ba9b91bbe657f614ded8b7',	'',	'2017-03-01 19:40:06',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14063002236',	'+14062099330',	'+14063002236',	NULL,	NULL,	NULL,	NULL,	'',	'MT',	'CA704eccf3c0b8b583bdbd9d437f08cbde',	'+14062509831',	'voicemail',	3,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE68c03404e887da1cdf6c407dd9d9ca6a',	0,	0,	'',	''),
(880,	'CAcfbfc4e130cc94d9b485dac92b3913e3',	'',	'2017-03-02 00:50:17',	'US',	'75050',	'TX',	'GRAND PRAIRIE',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+12143052027',	'+18654077039',	NULL,	NULL,	NULL,	NULL,	'',	'TN',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(881,	'CA4870e9afed88706cf86b8c1b3ef982cc',	'',	'2017-03-02 16:49:15',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'20011',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12025169213',	'+14062099330',	'+12025169213',	NULL,	NULL,	NULL,	NULL,	'WASHINGTON',	'DC',	'CA1a095d8cb8d0931a71583aee24a96b3d',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(882,	'CAc6bd75b1142a7492b53e11d93b1d613c',	'',	'2017-03-02 17:51:13',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'91950',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16197730607',	'+14252338984',	'+16197730607',	NULL,	NULL,	NULL,	NULL,	'NATIONAL CITY',	'CA',	'CAc6bd75b1142a7492b53e11d93b1d613c',	'+14062509831',	'completed',	123,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc38afe37f921573a98111315097fc5ee',	0,	0,	'',	''),
(883,	'CA3a3bae45fe99cea1c91216fe2946ef9f',	'',	'2017-03-02 17:53:55',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'91950',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16197730607',	'+16612439350',	'+16197730607',	NULL,	NULL,	NULL,	NULL,	'NATIONAL CITY',	'CA',	'CA3a3bae45fe99cea1c91216fe2946ef9f',	'+14062509831',	'completed',	146,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE0f7786c28acaf4a1f22814ccab64ab94',	0,	0,	'',	''),
(884,	'CAb8d8452d06ac9d996c2f865377d38053',	'',	'2017-03-02 18:05:35',	'US',	'',	'CA',	'',	'US',	'91950',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16197730607',	'+19513741928',	'+16197730607',	NULL,	NULL,	NULL,	NULL,	'NATIONAL CITY',	'CA',	'CAb8d8452d06ac9d996c2f865377d38053',	'+14062509831',	'completed',	151,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa37d1b002dd27370d6edc4e0448f31f1',	0,	0,	'',	''),
(885,	'CAb450edde0e5798f2b0c202cc3788da2a',	'',	'2017-03-02 18:21:29',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'91950',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16197730607',	'+19162627163',	'+16197730607',	NULL,	NULL,	NULL,	NULL,	'NATIONAL CITY',	'CA',	'CAb450edde0e5798f2b0c202cc3788da2a',	'+14062509831',	'completed',	123,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REed332aab9a5f6950702e636bf3aede41',	0,	0,	'',	''),
(886,	'CA6b1798b7f9cbb2bdb6ace2bbfe9ab3ec',	'',	'2017-03-02 19:00:47',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'64501',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+16612439350',	'+18162054290',	NULL,	NULL,	NULL,	NULL,	'ST JOSEPH',	'MO',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(887,	'CA8d796335c02729b5b1fa9087f9f16bcf',	'',	'2017-03-02 19:44:54',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'98273',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13606692049',	'+14252338984',	'+13606692049',	NULL,	NULL,	NULL,	NULL,	'MOUNT VERNON',	'WA',	'CA8d796335c02729b5b1fa9087f9f16bcf',	'+14062509831',	'completed',	3,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE89ddf8b96b2391cd953c8c9ab8275684',	0,	0,	'',	''),
(888,	'CA1e643d6bd39b6e76ec9ba699954a0d52',	'',	'2017-03-03 02:36:50',	'US',	'75050',	'TX',	'GRAND PRAIRIE',	'US',	'35404',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+12143052027',	'+12056571107',	NULL,	NULL,	NULL,	NULL,	'TUSCALOOSA',	'AL',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(889,	'CA0493918837f505ae49d49393257a1838',	'',	'2017-03-03 16:07:55',	'US',	'75050',	'TX',	'GRAND PRAIRIE',	'US',	'97209',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+12143052027',	'+19712459806',	NULL,	NULL,	NULL,	NULL,	'PORTLAND',	'OR',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(890,	'CAbfe2c01f58445c3babb4388888ed4d90',	'',	'2017-03-03 21:34:08',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'93562',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+14252338984',	'+17603028534',	NULL,	NULL,	NULL,	NULL,	'TRONA',	'CA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(891,	'CAe2835fbfbf3f159045f783abcc026735',	'',	'2017-03-06 00:04:21',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'75220',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12148780214',	'+14062099330',	'+12148780214',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CAc5b71330afca33d29bf875f1b5b3648b',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(892,	'CAca9af1f8cd572dd451da9352c6388cf5',	'',	'2017-03-06 13:22:32',	'US',	'75050',	'TX',	'GRAND PRAIRIE',	'US',	'30345',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+12143052027',	'+16783899400',	NULL,	NULL,	NULL,	NULL,	'ATLANTA',	'GA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(893,	'CAbee45524b792f579d807c0b42b8f2c89',	'',	'2017-03-06 22:03:31',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'94564',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+14252338984',	'+15103136703',	NULL,	NULL,	NULL,	NULL,	'HERCULES',	'CA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(894,	'CA595e06f84bba1082b230f26acdd3a173',	'',	'2017-03-07 21:50:19',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95641',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19168070009',	'+19162627163',	'+19168070009',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CA595e06f84bba1082b230f26acdd3a173',	'+14062509831',	'completed',	22,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REac613d986b1b34c4abeab892b4a07f5d',	0,	0,	'',	''),
(895,	'CAbfec75d228b41a9a59e5140252a35fb9',	'',	'2017-03-07 21:52:20',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95641',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19168070009',	'+19162627163',	'+19168070009',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CAbfec75d228b41a9a59e5140252a35fb9',	'+14062509831',	'completed',	79,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa89f9286260eba17e7a6d9aa5e172306',	0,	0,	'',	''),
(896,	'CA9bb513981775d9cf6e2d9bb05acea342',	'',	'2017-03-08 15:04:37',	'US',	'75229',	'TX',	'DALLAS',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+12143607431',	'+14244881098',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(897,	'CA55958a37a746be57446339649318bf88',	'',	'2017-03-08 15:04:40',	'US',	'75229',	'TX',	'DALLAS',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+12143607431',	'+14244881098',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(898,	'CAa7933accd807902dd55c4ce6d2313aec',	'',	'2017-03-08 15:04:43',	'US',	'75229',	'TX',	'DALLAS',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+12143607431',	'+14244881098',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(899,	'CAf528c9ac708a5b8c4609b298fb55d9a5',	'',	'2017-03-08 18:27:49',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16693500005',	'+14252338984',	'+16693500005',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA51bd014076ad85636df4f2e9d3b2ac5a',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(900,	'CA4f0b24d35d2b2b6f741f448e491191f5',	'',	'2017-03-08 21:43:41',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'98101',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14254958950',	'+19162627163',	'+14254958950',	NULL,	NULL,	NULL,	NULL,	'SEATTLE',	'WA',	'CA4f0b24d35d2b2b6f741f448e491191f5',	'+14062509831',	'completed',	58,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE26954a5b499115a7e41fceac3d1bd4ff',	0,	0,	'',	''),
(901,	'CAd63b945f5fa81558bfd35ae5b9f13f0f',	'',	'2017-03-09 02:55:07',	'US',	'75050',	'TX',	'GRAND PRAIRIE',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+12143052027',	'+14063002236',	NULL,	NULL,	NULL,	NULL,	'',	'MT',	NULL,	NULL,	'voicemail',	6,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb1d58d4609230546818fee2ba7e3620d',	0,	0,	'',	''),
(902,	'CA614a5f0ca2e864de713cf558ae266510',	'',	'2017-03-09 02:59:37',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14063002236',	'+14062099330',	'+14063002236',	NULL,	NULL,	NULL,	NULL,	'',	'MT',	'CA614a5f0ca2e864de713cf558ae266510',	'+14062509831',	'completed',	28,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb698b91f7cb160d47cabe6ad689a85ca',	0,	0,	'',	''),
(903,	'CA38fc285871924253285f4218ae891aca',	'',	'2017-03-09 03:00:54',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14063002236',	'+14062099330',	'+14063002236',	NULL,	NULL,	NULL,	NULL,	'',	'MT',	'CA38fc285871924253285f4218ae891aca',	'+14062509831',	'completed',	19,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE306d05558a0acf316bb6f2d0647b5721',	0,	0,	'',	''),
(904,	'CA5faefea4c3d1d1b4d461b446f2eeec6a',	'',	'2017-03-09 03:01:25',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14063002236',	'+14062099330',	'+14063002236',	NULL,	NULL,	NULL,	NULL,	'',	'MT',	'CA5faefea4c3d1d1b4d461b446f2eeec6a',	'+14062509831',	'completed',	23,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE5123c4e99f9914a4349c6e99a770ba7f',	0,	0,	'',	''),
(905,	'CAfd370353a61bfc2e64c2ae2b3ae58e06',	'',	'2017-03-09 03:02:03',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14063002236',	'+14062099330',	'+14063002236',	NULL,	NULL,	NULL,	NULL,	'',	'MT',	'CAfd370353a61bfc2e64c2ae2b3ae58e06',	'+14062509831',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE8b4c4f1c20c92e6532f26cf9a2d16726',	0,	0,	'',	''),
(906,	'CA6f240ad2e582db68a636091d13ddccfb',	'',	'2017-03-09 03:04:45',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14063002236',	'+14062099330',	'+14063002236',	NULL,	NULL,	NULL,	NULL,	'',	'MT',	'CA6f240ad2e582db68a636091d13ddccfb',	'+14062509831',	'completed',	15,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb7ac8d5c1c7b7d49cd38440c58dcbd61',	0,	0,	'',	''),
(907,	'CA18b0282c5a50fba70d6d889b8756135e',	'',	'2017-03-09 03:06:50',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14063002236',	'+14062099330',	'+14063002236',	NULL,	NULL,	NULL,	NULL,	'',	'MT',	'CA18b0282c5a50fba70d6d889b8756135e',	'+14062509831',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE508a887f5f4ad787f4d3a81f47facc66',	0,	0,	'',	''),
(908,	'CA5d45b4bbfb3d0b8bbb08ac53eccb0cc4',	'',	'2017-03-09 03:07:15',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14063002236',	'+14062099330',	'+14063002236',	NULL,	NULL,	NULL,	NULL,	'',	'MT',	'CAb4c5433f25239efafe4ed0a7ec58b288',	'+14062509831',	'voicemail',	6,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE105bf5af5e34da3d24bf4417839f39f7',	0,	0,	'',	''),
(909,	'CAa161e55329522f45f663479445fc64c4',	'',	'2017-03-09 18:17:15',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'93238',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+14252338984',	'+17604785077',	NULL,	NULL,	NULL,	NULL,	'KERNVILLE',	'CA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(910,	'CA0ea4a127981bba3481565a6887381818',	'',	'2017-03-10 21:53:25',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12132140509',	'+14252338984',	'+12132140509',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAd063bd4bff6b89ee292c046d112181cf',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(911,	'CAd3ab0133d234f751ba3b74e31370d708',	'',	'2017-03-13 15:04:06',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'80903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17196242392',	'+16612439350',	'+17196242392',	NULL,	NULL,	NULL,	NULL,	'COLORADO SPRINGS',	'CO',	'CAdbbb2fc38def03c3cd86b73f0a053771',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(912,	'CA0eee6e1d01ca562786f59b17df241461',	'',	'2017-03-13 16:54:24',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'94564',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+14252338984',	'+15103136707',	NULL,	NULL,	NULL,	NULL,	'HERCULES',	'CA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(913,	'CAb4833cb666ae6892c2f2c8fb74a18234',	'',	'2017-03-14 00:54:55',	'US',	'75050',	'TX',	'GRAND PRAIRIE',	'US',	'77963',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+12143052027',	'+13615640741',	NULL,	NULL,	NULL,	NULL,	'YORKTOWN',	'TX',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(914,	'CAb30c0effe9aecde8bfef07011a2ff98c',	'',	'2017-03-14 15:15:59',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'93562',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17603726463',	'+16612439350',	'+17603726463',	NULL,	NULL,	NULL,	NULL,	'TRONA',	'CA',	'CAb30c0effe9aecde8bfef07011a2ff98c',	'+14062509831',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf198ff88ed4717d1b3ad213873f62417',	0,	0,	'',	''),
(915,	'CA0fdbffafd792bf3b977f54513be75265',	'',	'2017-03-14 20:35:30',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'91356',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+14252338984',	'+18182804783',	NULL,	NULL,	NULL,	NULL,	'NORTHRIDGE',	'CA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(916,	'CAcbcb4bf848dc9956ff2fffa410afce63',	'',	'2017-03-14 21:15:37',	'US',	'75050',	'TX',	'GRAND PRAIRIE',	'US',	'75025',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+12143052027',	'+19727278100',	NULL,	NULL,	NULL,	NULL,	'ALLEN',	'TX',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(917,	'CAd3e54207e7241daaa1123241946f1824',	'',	'2017-03-15 06:33:27',	'US',	'75050',	'TX',	'GRAND PRAIRIE',	'US',	'77532',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+12143052027',	'+12818393202',	NULL,	NULL,	NULL,	NULL,	'BAYTOWN',	'TX',	NULL,	NULL,	'voicemail',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE0696a07c893e158e49e365e2a6de7473',	0,	0,	'',	''),
(918,	'CAff753b96c880da21aba729024a015e78',	'',	'2017-03-15 13:47:07',	'US',	'75050',	'TX',	'GRAND PRAIRIE',	'US',	'30340',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+12143052027',	'+16785416020',	NULL,	NULL,	NULL,	NULL,	'BUFORD',	'GA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(919,	'CAb2696aa68eb62778cc3207ac12d7ed58',	'',	'2017-03-15 20:23:05',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14243060372',	'+14252338984',	'+14243060372',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAcccaf2a7b7551ea77d83f74a5ededc2f',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(920,	'CA11e788b495d897add9136954753e56b8',	'',	'2017-03-16 12:55:21',	'US',	'75050',	'TX',	'GRAND PRAIRIE',	'US',	'30022',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+12143052027',	'+17706228878',	NULL,	NULL,	NULL,	NULL,	'DULUTH',	'GA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(921,	'CA799621d167e873b92ea7d01ab4a4d284',	'',	'2017-03-16 14:10:45',	'US',	'75050',	'TX',	'GRAND PRAIRIE',	'US',	'35673',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+12143052027',	'+12563531481',	NULL,	NULL,	NULL,	NULL,	'DECATUR',	'AL',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(922,	'CA1a93ab6b6b8c65223f92814bf9fb47f9',	'',	'2017-03-16 16:35:27',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14243060372',	'+14252338984',	'+14243060372',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA1a93ab6b6b8c65223f92814bf9fb47f9',	'+14062509831',	'completed',	4,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4f9bb50e04499c5034d8340670c6ad0a',	0,	0,	'',	''),
(923,	'CA2f2fab044a5d43e0aa54fe0545d82576',	'',	'2017-03-16 23:40:53',	'US',	'75050',	'TX',	'GRAND PRAIRIE',	'US',	'30054',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+12143052027',	'+17703106458',	NULL,	NULL,	NULL,	NULL,	'ATLANTA',	'GA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(924,	'CAe62a46fec0e804cfbc9e26f30c7c22ea',	'',	'2017-03-17 12:39:51',	'US',	'75050',	'TX',	'GRAND PRAIRIE',	'US',	'28562',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+12143052027',	'+19196361984',	NULL,	NULL,	NULL,	NULL,	'CHAPEL HILL',	'NC',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(925,	'CAec9cf416f08e5de15faba1fdd05b666f',	'',	'2017-03-17 16:12:35',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14243950503',	'+14252338984',	'+14243950503',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAcbb3a0175a5999815e0a9c40e1967e55',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(926,	'CA884f47e06f281fe50837aec18d787c8d',	'',	'2017-03-19 20:05:00',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'11747',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16317731053',	'+14062099330',	'+16317731053',	NULL,	NULL,	NULL,	NULL,	'FARMINGDALE',	'NY',	'CAef74ec766a8f816b42280477d6d2fb5d',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(927,	'CAaa0e54eba87f4372838118002102b779',	'',	'2017-03-20 02:52:54',	'US',	'75050',	'TX',	'GRAND PRAIRIE',	'US',	'77075',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+12143052027',	'+12819100989',	NULL,	NULL,	NULL,	NULL,	'DICKINSON',	'TX',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(928,	'CA0d68113065405c26870f82bd31b6069c',	'',	'2017-03-20 17:10:11',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'90604',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+14252338984',	'+15622693023',	NULL,	NULL,	NULL,	NULL,	'WHITTIER',	'CA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(929,	'CA63d32311f37fe7674b6e31f8a5b177b6',	'',	'2017-03-21 00:47:53',	'US',	'75050',	'TX',	'GRAND PRAIRIE',	'US',	'75081',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+12143052027',	'+18177183672',	NULL,	NULL,	NULL,	NULL,	'RICHARDSON',	'TX',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(930,	'CAa067d5b0c2b6a69dcfaadbecee2540a6',	'',	'2017-03-21 11:02:58',	'US',	'75050',	'TX',	'GRAND PRAIRIE',	'US',	'70615',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+12143052027',	'+13372409330',	NULL,	NULL,	NULL,	NULL,	'LAKE CHARLES',	'LA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(931,	'CAe5e1d66c1a398911981de5f18e9d0fd5',	'',	'2017-03-21 16:32:35',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19166806170',	'+14252338984',	'+19166806170',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAe2980b4d0bc9a53b9c30734fd9b168a4',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(932,	'CAf3fff5044447ce87d38b55d7dc18c6a4',	'',	'2017-03-21 21:01:39',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'93561',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16613018768',	'+16612439350',	'+16613018768',	NULL,	NULL,	NULL,	NULL,	'BAKERSFIELD',	'CA',	'CAf3fff5044447ce87d38b55d7dc18c6a4',	'+14062509831',	'completed',	15,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd9ab2057707eec5cf159fc6f75931dae',	0,	0,	'',	''),
(933,	'CAfb2ce2c4c655144bec162f05d3593053',	'',	'2017-03-22 00:55:06',	'US',	'75050',	'TX',	'GRAND PRAIRIE',	'US',	'30308',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+12143052027',	'+14049218185',	NULL,	NULL,	NULL,	NULL,	'ATLANTA',	'GA',	NULL,	NULL,	'voicemail',	3,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE24be91e1d4676945e0e6f025258e46a5',	0,	0,	'',	''),
(934,	'CAf2d4fc18536ce9a140fe06c79fbeb913',	'',	'2017-03-22 15:06:41',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13143000674',	'+14062099330',	'+13143000674',	NULL,	NULL,	NULL,	NULL,	'',	'MO',	'CA896c2853d6188d3d73b5e4ff1283518c',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(935,	'CAa310dd0c39769621a8eb618a678f37b1',	'',	'2017-03-22 20:27:29',	'US',	'75050',	'TX',	'GRAND PRAIRIE',	'US',	'90004',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+12143052027',	'+12132490215',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(936,	'CA786c52e33ea943c846083d7a6973dd0e',	'',	'2017-03-22 21:20:18',	'US',	'83001',	'WY',	'JACKSON',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+13072014710',	'+14063002236',	NULL,	NULL,	NULL,	NULL,	'',	'MT',	NULL,	NULL,	'voicemail',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE99021b6f61aeea21dc5f9d6d2fdaca62',	0,	0,	'',	''),
(937,	'CA87b20719ea8e3180a0e248984ecea856',	'',	'2017-03-22 21:23:31',	'US',	'83001',	'WY',	'JACKSON',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+13072014710',	'+14063002236',	NULL,	NULL,	NULL,	NULL,	'',	'MT',	NULL,	NULL,	'voicemail',	3,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE5d23596aa34bee40fad7595925f4e4f3',	0,	0,	'',	''),
(938,	'CA1539846a7320eeb96d024870ae950888',	'',	'2017-03-23 20:41:01',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'93307',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16613715405',	'+16612439350',	'+16613715405',	NULL,	NULL,	NULL,	NULL,	'BAKERSFIELD',	'CA',	'CA1539846a7320eeb96d024870ae950888',	'+14062509831',	'completed',	50,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE641d9d2dd5e2575a9c523bb3a5e32fc2',	0,	0,	'',	''),
(939,	'CA789feca593658a65f33460547771b49f',	'',	'2017-03-23 22:07:56',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19514485615',	'+19513741928',	'+19514485615',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAa8f335e20f27672bc0f7fa6e7149099b',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(940,	'CA71ff84f162d3b02f1ef5935db52276d8',	'',	'2017-03-24 19:55:09',	'US',	'75229',	'TX',	'DALLAS',	'US',	'04101',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+12143607431',	'+12072131843',	NULL,	NULL,	NULL,	NULL,	'PORTLAND',	'ME',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(941,	'CAfa903eecf59ec87e3bcf5b60a8692a53',	'',	'2017-03-24 19:55:15',	'US',	'75229',	'TX',	'DALLAS',	'US',	'04101',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+12143607431',	'+12072131843',	NULL,	NULL,	NULL,	NULL,	'PORTLAND',	'ME',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(942,	'CA60a3c62ab5b27fbdf5ab7b395ac1192d',	'',	'2017-03-25 14:41:42',	'US',	'83001',	'WY',	'JACKSON',	'US',	'59903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+13072014710',	'+14062509831',	NULL,	NULL,	NULL,	NULL,	'KALISPELL',	'MT',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(943,	'CA3abdbeb52f60a359c4fe5e27dbfd99e6',	'',	'2017-03-27 17:44:05',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'19713',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+14252338984',	'+13022618145',	NULL,	NULL,	NULL,	NULL,	'BEAR',	'DE',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(944,	'CA0683b11efb951bd1b27a5042b8602ef1',	'',	'2017-03-27 21:40:58',	'US',	'83001',	'WY',	'JACKSON',	'US',	'77632',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+13072014710',	'+14096709171',	NULL,	NULL,	NULL,	NULL,	'ORANGE',	'TX',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(945,	'CAffcffbcacda16672b0bdb4d9c87809ee',	'',	'2017-03-27 22:02:55',	'US',	'83001',	'WY',	'JACKSON',	'US',	'77632',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+13072014710',	'+14096709171',	NULL,	NULL,	NULL,	NULL,	'ORANGE',	'TX',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(946,	'CA4380aa33ef0a23882d9b68c6a39e5844',	'',	'2017-03-28 16:45:32',	'US',	'',	'CA',	'',	'US',	'02861',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14015432134',	'+19513741928',	'+14015432134',	NULL,	NULL,	NULL,	NULL,	'PAWTUCKET',	'RI',	'CA4380aa33ef0a23882d9b68c6a39e5844',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(947,	'CA3015fd74ad909aff59d977a70f001eb6',	'',	'2017-03-28 16:51:51',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'30345',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+16612439350',	'+16783921540',	NULL,	NULL,	NULL,	NULL,	'ATLANTA',	'GA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(948,	'CA74f0143c2c5bf5963ff9719c5febe3bf',	'',	'2017-03-28 21:02:03',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'30345',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+16612439350',	'+16783921540',	NULL,	NULL,	NULL,	NULL,	'ATLANTA',	'GA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(949,	'CAa784daf595763d7743ea300c37ca1c0b',	'',	'2017-03-28 21:20:49',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19162627163',	'+12028510553',	NULL,	NULL,	NULL,	NULL,	'',	'District Of Columbia',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(950,	'CA8b2cd4dff0f5313c74754df7c0c2f95b',	'',	'2017-03-29 18:36:01',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'46278',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13178037027',	'+14252338984',	'+13178037027',	NULL,	NULL,	NULL,	NULL,	'INDIANAPOLIS',	'IN',	'CA8b2cd4dff0f5313c74754df7c0c2f95b',	'+14062509831',	'completed',	38,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE990f4698da8fa3d7c1e2b7a423c439da',	0,	0,	'',	''),
(951,	'CAf19447798f4ac5dbd59492cdfc0ea6b8',	'',	'2017-03-29 19:38:23',	'US',	'83001',	'WY',	'JACKSON',	'US',	'75001',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+13072014710',	'+19728639607',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(952,	'CA948e9381c87f66a621797beeb71acbb8',	'',	'2017-03-29 20:05:07',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12068995059',	'+14252338984',	'+12068995059',	NULL,	NULL,	NULL,	NULL,	'',	'WA',	'CAec150aaa84a1092228b7688cb6322e26',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(953,	'CA29128dd2996c994980f5ad5233d8f914',	'',	'2017-03-30 09:29:33',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'48326',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12482438457',	'+14252338984',	'+12482438457',	NULL,	NULL,	NULL,	NULL,	'AUBURN HILLS',	'MI',	'CA29128dd2996c994980f5ad5233d8f914',	'+14062509831',	'completed',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE12f7e4d7f934714525c6e54ce9d5eb18',	0,	0,	'',	''),
(954,	'CA55853cffc4357481cdfb35fcf644b741',	'',	'2017-03-30 16:12:53',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12678106052',	'+14252338984',	'+12678106052',	NULL,	NULL,	NULL,	NULL,	'',	'PA',	'CA55853cffc4357481cdfb35fcf644b741',	'+14062509831',	'completed',	2,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE76ce2ba311ec10003e4842b54d5038d6',	0,	0,	'',	''),
(955,	'CAa384bca432db6230feea64284aa1b361',	'',	'2017-03-30 18:10:07',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'48326',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12482438465',	'+16612439350',	'+12482438465',	NULL,	NULL,	NULL,	NULL,	'AUBURN HILLS',	'MI',	'CAa384bca432db6230feea64284aa1b361',	'+14062509831',	'completed',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE7cc3cda5ebf9dad5960c551f4003046b',	0,	0,	'',	''),
(956,	'CAbe8c3fd5f4c73b6ce9485baee455293c',	'',	'2017-03-30 19:35:13',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'30345',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+16612439350',	'+16783921540',	NULL,	NULL,	NULL,	NULL,	'ATLANTA',	'GA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(957,	'CA113746847d1381cb7ef8493b98dec8c2',	'',	'2017-03-30 20:47:12',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'30345',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+16612439350',	'+16783921540',	NULL,	NULL,	NULL,	NULL,	'ATLANTA',	'GA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(958,	'CAfca846b20df8c549badc86eedbe29182',	'',	'2017-03-30 21:37:34',	'US',	'83001',	'WY',	'JACKSON',	'US',	'77043',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+13072014710',	'+18328855562',	NULL,	NULL,	NULL,	NULL,	'HOUSTON',	'TX',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(959,	'CAed6faefa55a4e003fb27bfc7bdfbbb03',	'',	'2017-03-30 22:22:45',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'92585',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13107298068',	'+16612439350',	'+13107298068',	NULL,	NULL,	NULL,	NULL,	'BEVERLY HILLS',	'CA',	'CAed6faefa55a4e003fb27bfc7bdfbbb03',	'+14062509831',	'completed',	67,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4282bcfdf7abdaadc4d2c9abf8e139b1',	0,	0,	'',	''),
(960,	'CA1750315fa37ca1fff9bb1ad0d2621714',	'',	'2017-03-31 10:03:21',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'60409',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17087825844',	'+19162627163',	'+17087825844',	NULL,	NULL,	NULL,	NULL,	'CALUMET CITY',	'IL',	'CA1750315fa37ca1fff9bb1ad0d2621714',	'+14062509831',	'completed',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REed0007c06b42b522a825f45c17c0ace2',	0,	0,	'',	''),
(961,	'CAe728479dce200b9cd4bc796a128e561f',	'',	'2017-03-31 18:34:31',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17472465196',	'+19513741928',	'+17472465196',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CAac214dfbb165906a3f59ad454e207c85',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(962,	'CA23c8f19b3f8b8cbb657303d34ca9ef18',	'',	'2017-03-31 21:25:56',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17472465196',	'+16612439350',	'+17472465196',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA23c8f19b3f8b8cbb657303d34ca9ef18',	'+14062509831',	'no-answer',	6,	NULL,	0,	0,	'',	''),
(963,	'CAb66bfdde45fad2b7753037383356e300',	'',	'2017-04-01 22:35:18',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'07307',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12015471008',	'+14062099330',	'+12015471008',	NULL,	NULL,	NULL,	NULL,	'JERSEY CITY',	'NJ',	'CAb66bfdde45fad2b7753037383356e300',	'+14062509831',	'no-answer',	4,	NULL,	0,	0,	'',	''),
(964,	'CAe032256e9df25a9321a922c7c2dd3051',	'',	'2017-04-03 17:15:07',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17472465196',	'+19513741928',	'+17472465196',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CAe032256e9df25a9321a922c7c2dd3051',	'+14062509831',	'completed',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd999c6bf882107dd73d6e753ef475b4b',	0,	0,	'',	''),
(965,	'CAe1230e47678ec57d1403c4db9f846f99',	'',	'2017-04-03 19:50:40',	'US',	'75050',	'TX',	'GRAND PRAIRIE',	'US',	'91367',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+12143052027',	'+18182247087',	NULL,	NULL,	NULL,	NULL,	'CANOGA PARK',	'CA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(966,	'CAeb868443e18aa5e29862c0b3f24a0133',	'',	'2017-04-03 22:56:02',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17472465196',	'+19162627163',	'+17472465196',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CAeb868443e18aa5e29862c0b3f24a0133',	'+14062509831',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE05ec7ac1046e01b7b37de93a84abf17c',	0,	0,	'',	''),
(967,	'CA467807ae614cbaeeb4cab9f9e88c9609',	'',	'2017-04-04 01:34:11',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'20388',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12024558888',	'+16612439350',	'+12024558888',	NULL,	NULL,	NULL,	NULL,	'WASHINGTON',	'DC',	'CA467807ae614cbaeeb4cab9f9e88c9609',	'+14062509831',	'completed',	24,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE213bcc51696483ccb1ddfa82426f37cd',	0,	0,	'',	''),
(968,	'CA3b306ee927302f3752dca0a27c890213',	'',	'2017-04-04 21:10:43',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'91754',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16266421010',	'+19162627163',	'+16266421010',	NULL,	NULL,	NULL,	NULL,	'ALHAMBRA',	'CA',	'CA1c8b9de8a4cca62c6467bb7a3e6be715',	'+14062509831',	'voicemail',	2,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REef963f6cef87488ef4e9dd8d197b8b28',	0,	0,	'',	''),
(969,	'CAb9dfc135788a11d67fe94bdbf583dd82',	'',	'2017-04-05 20:57:37',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'90071',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18186592004',	'+19162627163',	'+18186592004',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA3c7dcc0693a7c270736fd160036741cb',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(970,	'CA13a39378d7de986770be5b400b06eb99',	'',	'2017-04-06 17:34:11',	'US',	'',	'CA',	'',	'US',	'45653',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17403519234',	'+19513741928',	'+17403519234',	NULL,	NULL,	NULL,	NULL,	'PORTSMOUTH',	'OH',	'CAc12a90fc1445a02030db768f00e5f69c',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(971,	'CA4397c06267d8f0354d80915c0cf14a25',	'',	'2017-04-06 20:40:15',	'US',	'',	'CA',	'',	'US',	'48001',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18107346043',	'+19513741928',	'+18107346043',	NULL,	NULL,	NULL,	NULL,	'ALGONAC',	'MI',	'CAfab34fcb6b12452180b38cda0332a604',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(972,	'CAeb7fac4509f0da03feafe90115f9e81d',	'',	'2017-04-06 23:35:13',	'US',	'',	'CA',	'',	'US',	'07105',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19513741928',	'+12012851822',	NULL,	NULL,	NULL,	NULL,	'NEWARK',	'NJ',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(973,	'CAa1b8489dfe8ce9facac17da1120eef35',	'',	'2017-04-07 19:26:07',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'59750',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14062211764',	'+19162627163',	'+14062211764',	NULL,	NULL,	NULL,	NULL,	'BUTTE',	'MT',	'CAa1b8489dfe8ce9facac17da1120eef35',	'+14062509831',	'completed',	4,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3cf568fa675c431ece2369ef388eb022',	0,	0,	'',	''),
(974,	'CA1f2a7556b7e64e44612b13adfdb3be81',	'',	'2017-04-07 20:00:48',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14695706074',	'+14252338984',	'+14695706074',	NULL,	NULL,	NULL,	NULL,	'',	'TX',	'CA1f2a7556b7e64e44612b13adfdb3be81',	'+14062509831',	'completed',	2,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE89cb16cff145f46f677187559943eabc',	0,	0,	'',	''),
(975,	'CA1321b7e94a2836a825b580f28ee43e13',	'',	'2017-04-07 20:16:27',	'US',	'',	'CA',	'',	'US',	'38126',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19017912952',	'+19513741928',	'+19017912952',	NULL,	NULL,	NULL,	NULL,	'MEMPHIS',	'TN',	'CA625d94803ff6096de19781985dbb804f',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(976,	'CA78b3bc31e42b432652b3ac762663839c',	'',	'2017-04-07 20:22:46',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'38126',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19017912952',	'+19162627163',	'+19017912952',	NULL,	NULL,	NULL,	NULL,	'MEMPHIS',	'TN',	'CA38bdbdaddb16662f22d96f8890466c7f',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(977,	'CAf853710b2c1db58c515a45e4ca5f8bcc',	'',	'2017-04-07 20:28:01',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19165007217',	'+19162627163',	'+19165007217',	NULL,	NULL,	NULL,	NULL,	'Elk Grove',	'CA',	'CAf853710b2c1db58c515a45e4ca5f8bcc',	'+14062509831',	'completed',	18,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE99a5efc73100893b8eac8b51e57619b2',	0,	0,	'',	''),
(978,	'CA6cd888b939de30a9062a12cc6cc1fe91',	'',	'2017-04-07 21:03:58',	'US',	'83001',	'WY',	'JACKSON',	'US',	'75041',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+13072014710',	'+19722701085',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	NULL,	NULL,	'voicemail',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE0d366ea6532065f8ade79a8363bc03a0',	0,	0,	'',	''),
(979,	'CA9ec2dd825ff15a02207953d2de7c32de',	'',	'2017-04-07 21:40:20',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+14252338984',	'+14805657404',	NULL,	NULL,	NULL,	NULL,	'',	'AZ',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(980,	'CAdf0c80d8048321f880ce58c6427f98c7',	'',	'2017-04-09 18:21:32',	'US',	'83001',	'WY',	'JACKSON',	'US',	'78744',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+13072014710',	'+15123835960',	NULL,	NULL,	NULL,	NULL,	'AUSTIN',	'TX',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(981,	'CA4aa2c285a03ed7eb8a02aae22957280e',	'',	'2017-04-10 17:12:49',	'US',	'83001',	'WY',	'JACKSON',	'US',	'78744',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+13072014710',	'+15123835960',	NULL,	NULL,	NULL,	NULL,	'AUSTIN',	'TX',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(982,	'CA6492675f73a4709b263c0c65c44d135f',	'',	'2017-04-10 21:04:23',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12532896020',	'+14252338984',	'+12532896020',	NULL,	NULL,	NULL,	NULL,	'',	'WA',	'CA6492675f73a4709b263c0c65c44d135f',	'+14062509831',	'completed',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE10b8a63c73ffdcb8b803f9255ca6030b',	0,	0,	'',	''),
(983,	'CA577a3121a5fcb04ddbc75b9ce833617f',	'',	'2017-04-10 22:53:02',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13852491364',	'+19513741928',	'+13852491364',	NULL,	NULL,	NULL,	NULL,	'SALT LAKE CITY',	'UT',	'CA577a3121a5fcb04ddbc75b9ce833617f',	'+14062509831',	'completed',	2,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE7170ce9b20e16cf1596b8854fb0d8023',	0,	0,	'',	''),
(984,	'CA78568039e1e753d4a994d76e978e9c5d',	'',	'2017-04-11 00:47:56',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'20388',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12024558888',	'+19162627163',	'+12024558888',	NULL,	NULL,	NULL,	NULL,	'WASHINGTON',	'DC',	'CA78568039e1e753d4a994d76e978e9c5d',	'+14062509831',	'completed',	26,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE7ed6f0aa34574c47666222915c191d47',	0,	0,	'',	''),
(985,	'CA00326f7c3cfe2bb6cf8928b1b7a80704',	'',	'2017-04-11 00:51:09',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'20388',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12024558888',	'+19162627163',	'+12024558888',	NULL,	NULL,	NULL,	NULL,	'WASHINGTON',	'DC',	'CA00326f7c3cfe2bb6cf8928b1b7a80704',	'+14062509831',	'completed',	26,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE05a47fe9e4e75aef1ffafb6d47b43be2',	0,	0,	'',	''),
(986,	'CA37937f7ae832a1ba3c0f0571fb1fd2c1',	'',	'2017-04-11 00:58:24',	'US',	'75258',	'TX',	'DALLAS',	'US',	'20388',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+12147613136',	'+12024558888',	NULL,	NULL,	NULL,	NULL,	'WASHINGTON',	'DC',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(987,	'CAb41551886b6460ac3675bdf1daee257e',	'',	'2017-04-11 01:07:37',	'US',	'75258',	'TX',	'DALLAS',	'US',	'20388',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12024558888',	'+12147613136',	'+12024558888',	NULL,	NULL,	NULL,	NULL,	'WASHINGTON',	'DC',	'CAb41551886b6460ac3675bdf1daee257e',	'+14062509831',	'completed',	31,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf1b71019c165046571393dfe15b325a4',	0,	0,	'',	''),
(988,	'CA518d1f4bc3c0ce09d0f5bf0046996421',	'',	'2017-04-11 01:08:25',	'US',	'75258',	'TX',	'DALLAS',	'US',	'20388',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12024558888',	'+12147613136',	'+12024558888',	NULL,	NULL,	NULL,	NULL,	'WASHINGTON',	'DC',	'CA518d1f4bc3c0ce09d0f5bf0046996421',	'+14062509831',	'completed',	30,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE7e857bedb1971b61c53e0dfab81ee10b',	0,	0,	'',	''),
(989,	'CA96b08423b674560ff10416703dfda256',	'',	'2017-04-11 01:13:20',	'US',	'75258',	'TX',	'DALLAS',	'US',	'20388',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12024558888',	'+12147613136',	'+12024558888',	NULL,	NULL,	NULL,	NULL,	'WASHINGTON',	'DC',	'CA96b08423b674560ff10416703dfda256',	'+14062509831',	'completed',	30,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE657d958cd9ef749514be152757017ab3',	0,	0,	'',	''),
(990,	'CA0e844e54457bbb3fd835c233344886ef',	'',	'2017-04-11 17:19:00',	'US',	'83001',	'WY',	'JACKSON',	'US',	'78744',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+13072014710',	'+15123835960',	NULL,	NULL,	NULL,	NULL,	'AUSTIN',	'TX',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(991,	'CA70abbbd00116274f226161595f64adae',	'',	'2017-04-11 20:21:26',	'US',	'75050',	'TX',	'GRAND PRAIRIE',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+12143052027',	'+12163509024',	NULL,	NULL,	NULL,	NULL,	'',	'OH',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(992,	'CA259a6cdeff34316cc5c4245165197b4e',	'',	'2017-04-11 20:33:51',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12532896020',	'+14252338984',	'+12532896020',	NULL,	NULL,	NULL,	NULL,	'',	'WA',	'CA3fd5410f34bdc8e43e0e4b9539490581',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(993,	'CA006a9d70120e2ee97d26e254596bcc0f',	'',	'2017-04-11 23:59:43',	'US',	'83001',	'WY',	'JACKSON',	'US',	'77093',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+13072014710',	'+17133049175',	NULL,	NULL,	NULL,	NULL,	'HOUSTON',	'TX',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(994,	'CAbae01a78cfa64d88406f70a7c996635c',	'',	'2017-04-12 16:02:39',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12532896020',	'+14252338984',	'+12532896020',	NULL,	NULL,	NULL,	NULL,	'',	'WA',	'CAbae01a78cfa64d88406f70a7c996635c',	'+14062509831',	'completed',	1,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REdfdafbcfd80735b4114d4019f174072c',	0,	0,	'',	''),
(995,	'CA8185fea24cd0c9109f696b9aaebd4c68',	'',	'2017-04-12 16:37:25',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16514240478',	'+14252338984',	'+16514240478',	NULL,	NULL,	NULL,	NULL,	'',	'MN',	'CA26a7c536282276cc1c617336f8140d42',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(996,	'CA505bae8d153a35e14e7e06f488482ca0',	'',	'2017-04-12 19:39:32',	'US',	'75050',	'TX',	'GRAND PRAIRIE',	'US',	'20388',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12024558888',	'+12143052027',	'+12024558888',	NULL,	NULL,	NULL,	NULL,	'WASHINGTON',	'DC',	'CA505bae8d153a35e14e7e06f488482ca0',	'+14062509831',	'completed',	30,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE0d83cd5e517ce225f1b8547cb9323203',	0,	0,	'',	''),
(997,	'CA26efbb1ffe4dbeeeabc6791254fd9b62',	'',	'2017-04-12 19:41:39',	'US',	'75050',	'TX',	'GRAND PRAIRIE',	'US',	'20388',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12024558888',	'+12143052027',	'+12024558888',	NULL,	NULL,	NULL,	NULL,	'WASHINGTON',	'DC',	'CA26efbb1ffe4dbeeeabc6791254fd9b62',	'+14062509831',	'completed',	30,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE1b0ac6daffe33f914f3926a9298da0c1',	0,	0,	'',	''),
(998,	'CA44e2ea3f5fa4cd25c8e3c17a1126113e',	'',	'2017-04-12 19:42:58',	'US',	'75050',	'TX',	'GRAND PRAIRIE',	'US',	'20388',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12024558888',	'+12143052027',	'+12024558888',	NULL,	NULL,	NULL,	NULL,	'WASHINGTON',	'DC',	'CAf81b0fb20829f9db7647b6cc60dbc51b',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(999,	'CAde2ee826ed837efa7fa6bd8aec3a4ea5',	'',	'2017-04-12 20:14:58',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'20388',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12024558888',	'+16612439350',	'+12024558888',	NULL,	NULL,	NULL,	NULL,	'WASHINGTON',	'DC',	'CAde2ee826ed837efa7fa6bd8aec3a4ea5',	'+14062509831',	'completed',	27,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE26ac3af434d0ff3d4e00a4caa7711e28',	0,	0,	'',	''),
(1000,	'CA1030a39dc76b8bf7c493f24fde08f9da',	'',	'2017-04-12 22:15:57',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19162627163',	'+18038884150',	NULL,	NULL,	NULL,	NULL,	'',	'SC',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1001,	'CA322ff44468c9ec9590f84baa54446d7f',	'',	'2017-04-13 20:17:30',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12532896020',	'+14252338984',	'+12532896020',	NULL,	NULL,	NULL,	NULL,	'',	'WA',	'CA322ff44468c9ec9590f84baa54446d7f',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(1002,	'CAedef443087325d935888e0fcb0ac50f7',	'',	'2017-04-13 22:01:04',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'20388',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12024558888',	'+19722036640',	'+12024558888',	NULL,	NULL,	NULL,	NULL,	'WASHINGTON',	'DC',	'CAedef443087325d935888e0fcb0ac50f7',	'+12148780214',	'completed',	19,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REdaf02b6cb4cb6ff6c63d5c5dba2b370e',	0,	0,	'',	''),
(1003,	'CA349607a32f65faa89acf3a9ad22f0718',	'',	'2017-04-13 22:02:24',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'20388',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12024558888',	'+19722036640',	'+12024558888',	NULL,	NULL,	NULL,	NULL,	'WASHINGTON',	'DC',	'CA349607a32f65faa89acf3a9ad22f0718',	'+12148780214',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd8caff2b74666f2810e8ce0f562a5c64',	0,	0,	'',	''),
(1004,	'CA49cf99122a51653680095888c23a57e3',	'',	'2017-04-13 22:07:12',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'20388',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12024558888',	'+19722036640',	'+12024558888',	NULL,	NULL,	NULL,	NULL,	'WASHINGTON',	'DC',	'CA49cf99122a51653680095888c23a57e3',	'+14062509831',	'completed',	28,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REcb2978f108b348bf273ec2256c54713e',	0,	0,	'',	''),
(1005,	'CA69a8929b6538bb854173c704569e7a48',	'',	'2017-04-13 22:08:11',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'20388',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12024558888',	'+19722036640',	'+12024558888',	NULL,	NULL,	NULL,	NULL,	'WASHINGTON',	'DC',	'CA69a8929b6538bb854173c704569e7a48',	'+14062509831',	'completed',	30,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE6db5442783024bdec5374daf30643f67',	0,	0,	'',	''),
(1006,	'CA430734e8a5da742c51d410f8a141578d',	'',	'2017-04-13 22:17:24',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'20388',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12024558888',	'+19722036609',	'+12024558888',	NULL,	NULL,	NULL,	NULL,	'WASHINGTON',	'DC',	'CA430734e8a5da742c51d410f8a141578d',	'+14062509831',	'completed',	30,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4fca412bc702b274815bc3b753139470',	0,	0,	'',	''),
(1007,	'CAd95e86fd14579a359ff311bc836b8531',	'',	'2017-04-13 22:18:16',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'20388',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12024558888',	'+19722036609',	'+12024558888',	NULL,	NULL,	NULL,	NULL,	'WASHINGTON',	'DC',	'CAd95e86fd14579a359ff311bc836b8531',	'+14062509831',	'completed',	30,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa134809fddd5d27f717c15dabe1d4c34',	0,	0,	'',	''),
(1008,	'CA9e45c5dfd6ab4818604612f78d52664f',	'',	'2017-04-13 22:20:37',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'20388',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12024558888',	'+14252338984',	'+12024558888',	NULL,	NULL,	NULL,	NULL,	'WASHINGTON',	'DC',	'CA9e45c5dfd6ab4818604612f78d52664f',	'+14062509831',	'completed',	23,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE8dd400de3ef62c5b9aa2b8bf2e239b74',	0,	0,	'',	''),
(1009,	'CA226cf4222865882e0e1d9507c7f146f0',	'',	'2017-04-13 22:21:36',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'20388',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12024558888',	'+14252338984',	'+12024558888',	NULL,	NULL,	NULL,	NULL,	'WASHINGTON',	'DC',	'CA226cf4222865882e0e1d9507c7f146f0',	'+14062509831',	'completed',	22,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc97fdc3f73b415229251d7bfeaf6ee80',	0,	0,	'',	''),
(1010,	'CAd72f1413cdf7e3fccccce14cca62c15f',	'',	'2017-04-14 17:28:49',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'98337',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13607120058',	'+14252338984',	'+13607120058',	NULL,	NULL,	NULL,	NULL,	'BREMERTON',	'WA',	'CA790b44fd5d596e4d6beba1bde805e8e2',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1011,	'CAd3c9762b2a0270d5d5a04f3f30ef2f03',	'',	'2017-04-14 20:23:27',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95765',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19165777567',	'+19162627163',	'+19165777567',	NULL,	NULL,	NULL,	NULL,	'ROSEVILLE',	'CA',	'CAd3c9762b2a0270d5d5a04f3f30ef2f03',	'+14062509831',	'completed',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE1e4c3c2a5a52d4436584a93bfacdebee',	0,	0,	'',	''),
(1012,	'CAba3dccd65d597ad2716e64ba05f82ae3',	'',	'2017-04-14 20:28:24',	'US',	'75050',	'TX',	'GRAND PRAIRIE',	'US',	'91367',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18182247578',	'+12143052027',	'+18182247578',	NULL,	NULL,	NULL,	NULL,	'CANOGA PARK',	'CA',	'CAba3dccd65d597ad2716e64ba05f82ae3',	'+14062509831',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE43dfc39212855a045ebe839b21706633',	0,	0,	'',	''),
(1013,	'CAb989787316b264b69eb01be4c7c8cb49',	'',	'2017-04-14 21:18:38',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'78154',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12108074596',	'+19162627163',	'+12108074596',	NULL,	NULL,	NULL,	NULL,	'SCHERTZ',	'TX',	'CAb989787316b264b69eb01be4c7c8cb49',	'+14062509831',	'completed',	3,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE95eb8fb625b2d523bb152cf8a5d69a2b',	0,	0,	'',	''),
(1014,	'CAd34b119c380918859ef8fa8abc1e4f9c',	'',	'2017-04-14 21:38:05',	'US',	'83001',	'WY',	'JACKSON',	'US',	'20388',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+13072014710',	'+12024558888',	NULL,	NULL,	NULL,	NULL,	'WASHINGTON',	'DC',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1015,	'CA3de9d9bef99dea750dabab7fbfb2fa63',	'',	'2017-04-14 21:40:10',	'US',	'83001',	'WY',	'JACKSON',	'US',	'20388',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+13072014710',	'+12024558888',	NULL,	NULL,	NULL,	NULL,	'WASHINGTON',	'DC',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1016,	'CA341806bbcd3d3833983dbf6436b4c7dc',	'',	'2017-04-14 21:41:35',	'US',	'83001',	'WY',	'JACKSON',	'US',	'20388',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+13072014710',	'+12024558888',	NULL,	NULL,	NULL,	NULL,	'WASHINGTON',	'DC',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1017,	'CAa41646a383f1cfd34e78a4061a784122',	'',	'2017-04-14 21:58:18',	'US',	'',	'CA',	'',	'US',	'20388',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12024558888',	'+19513741928',	'+12024558888',	NULL,	NULL,	NULL,	NULL,	'WASHINGTON',	'DC',	'CAa41646a383f1cfd34e78a4061a784122',	'+14062509831',	'completed',	23,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa3d66060ef244ef5d68c0d136cb3312e',	0,	0,	'',	''),
(1018,	'CAe9dc8ff06f1ab49c399f9a3d00657217',	'',	'2017-04-14 22:15:56',	'US',	'',	'CA',	'',	'US',	'20388',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12024558888',	'+19513741928',	'+12024558888',	NULL,	NULL,	NULL,	NULL,	'WASHINGTON',	'DC',	'CAe9dc8ff06f1ab49c399f9a3d00657217',	'+14062509831',	'completed',	23,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE268d7f66b3432664c0a2f6c8d3169ffb',	0,	0,	'',	''),
(1019,	'CA66d0f938dec08d33919d0a3642a705c4',	'',	'2017-04-14 22:18:46',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'20388',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12024558888',	'+14062099330',	'+12024558888',	NULL,	NULL,	NULL,	NULL,	'WASHINGTON',	'DC',	'CA66d0f938dec08d33919d0a3642a705c4',	'+14062509831',	'completed',	29,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REfbf034cf4db98520657e60ea88160625',	0,	0,	'',	''),
(1020,	'CA514c3928aaa770e32db0bdf95b651e47',	'',	'2017-04-14 22:20:01',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'20388',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12024558888',	'+14062099330',	'+12024558888',	NULL,	NULL,	NULL,	NULL,	'WASHINGTON',	'DC',	'CA514c3928aaa770e32db0bdf95b651e47',	'+14062509831',	'completed',	30,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE9dda7179fee833b398b3c05202fdc023',	0,	0,	'',	''),
(1021,	'CA150041c92de9fb4fce2f2d20a9c56bc0',	'',	'2017-04-15 13:38:44',	'US',	'75229',	'TX',	'DALLAS',	'US',	'20388',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12024558888',	'+12143607431',	'+12024558888',	NULL,	NULL,	NULL,	NULL,	'WASHINGTON',	'DC',	'CA150041c92de9fb4fce2f2d20a9c56bc0',	'+14062509831',	'completed',	31,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE76fecd6822061c7d8b41ccf1269de871',	0,	0,	'',	''),
(1022,	'CA254d14c2ad41d6b5c57c7beacdb505f6',	'',	'2017-04-15 13:39:45',	'US',	'75229',	'TX',	'DALLAS',	'US',	'20388',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12024558888',	'+12143607431',	'+12024558888',	NULL,	NULL,	NULL,	NULL,	'WASHINGTON',	'DC',	'CA254d14c2ad41d6b5c57c7beacdb505f6',	'+14062509831',	'completed',	26,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REca5556f88168b455d06e2b31dc667b47',	0,	0,	'',	''),
(1023,	'CA58e460dd757a3be0e3ffb758a08dfd20',	'',	'2017-04-17 13:43:51',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'95112',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14082284486',	'+14062099330',	'+14082284486',	NULL,	NULL,	NULL,	NULL,	'FREMONT',	'CA',	'CA6e420c6dcf1f500f8533a5184363803f',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1024,	'CA51df3d15a95d773fa45555d463d1844a',	'',	'2017-04-17 17:23:43',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'75247',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13607763258',	'+14252338984',	'+13607763258',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'WA',	'CA51df3d15a95d773fa45555d463d1844a',	'+14062509831',	'completed',	2,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe6cbefc989c6582b65d62a4d3d7fc465',	0,	0,	'',	''),
(1025,	'CAe53e4e9e8e6d89d97ba73e64eb77d149',	'',	'2017-04-17 20:37:12',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'38126',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19017912952',	'+14252338984',	'+19017912952',	NULL,	NULL,	NULL,	NULL,	'MEMPHIS',	'TN',	'CA4cd38c145a63caeebc66810b09dd1f01',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1026,	'CA9d3aca18d5452b791c729ed879972bf3',	'',	'2017-04-18 15:22:29',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+14062099330',	'+12163509024',	NULL,	NULL,	NULL,	NULL,	'',	'OH',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1027,	'CA7375dce588af54ffd7e144c30006b212',	'',	'2017-04-18 15:22:30',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+14062099330',	'+12163509024',	NULL,	NULL,	NULL,	NULL,	'',	'OH',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1028,	'CA81305bc5aff21f0213badcb845574f3d',	'',	'2017-04-18 15:22:31',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12163509024',	'+14062099330',	'+12163509024',	NULL,	NULL,	NULL,	NULL,	'',	'OH',	'CA95a28895b90c0014001e7cc9fc66642e',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1029,	'CAd024ab3ff73010b14e5a0ee50e5c2bf3',	'',	'2017-04-18 15:22:32',	'US',	'59718',	'MT',	'BOZEMAN',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12163509024',	'+14062099330',	'+12163509024',	NULL,	NULL,	NULL,	NULL,	'',	'OH',	'CAb2386016ee58590246c94a6dc036ed17',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1030,	'CAdc85d0c83304058fa0bca8a6410961f6',	'',	'2017-04-18 16:05:30',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15023051314',	'+16612439350',	'+15023051314',	NULL,	NULL,	NULL,	NULL,	'',	'KY',	'CAb1b86364676139712a4918b3c8d5e871',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1031,	'CA4c3c5ac6e48ea24d8558dc45f5214d8e',	'',	'2017-04-18 16:06:20',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'92398',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17602578052',	'+16612439350',	'+17602578052',	NULL,	NULL,	NULL,	NULL,	'NEWBERRY SPRINGS',	'CA',	'CA4c3c5ac6e48ea24d8558dc45f5214d8e',	'+14062509831',	'completed',	34,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc457f69a7f1ae709a22ca534100c914e',	0,	0,	'',	''),
(1032,	'CA1aabef25df8e721d05e4e153947b8b1f',	'',	'2017-04-18 16:09:37',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'75247',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13607763258',	'+14252338984',	'+13607763258',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'WA',	'CAb68d329c0a49f3202583d92b02b9bf0c',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1033,	'CA4c26ee066cd3787f69a6c3abd8298696',	'',	'2017-04-18 20:26:25',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19162925099',	'+19162627163',	'+19162925099',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAf1257eba515f073d99381b022d69aaeb',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1034,	'CA752bff9c461532e4d3abdd105fce2cff',	'',	'2017-04-18 21:48:38',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'92624',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19492012398',	'+19162627163',	'+19492012398',	NULL,	NULL,	NULL,	NULL,	'SAN JUAN CAPISTRANO',	'CA',	'CA752bff9c461532e4d3abdd105fce2cff',	'+14062509831',	'completed',	4,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REbbad9271bdb28f9843465671ba902110',	0,	0,	'',	''),
(1035,	'CA2ccd395f7e7034e6106b915623b5590f',	'',	'2017-04-19 18:19:59',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'75247',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13607763258',	'+14252338984',	'+13607763258',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'WA',	'CA2ccd395f7e7034e6106b915623b5590f',	'+14062509831',	'no-answer',	6,	NULL,	0,	0,	'',	''),
(1036,	'CAa7014f3794de8f55cc3627d222e56a2c',	'',	'2017-04-20 16:33:16',	'US',	'',	'CA',	'',	'US',	'90017',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17606918021',	'+19513741928',	'+17606918021',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CAa7014f3794de8f55cc3627d222e56a2c',	'+14062509831',	'completed',	19,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE192edfc04a10ab2d208169bc16da32c2',	0,	0,	'',	''),
(1037,	'CA2c5da80e84a947ff665b1a96d963d9a0',	'',	'2017-04-21 18:51:30',	'US',	'',	'CA',	'',	'US',	'90017',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17606918021',	'+19513741928',	'+17606918021',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CAf882792fc05351b4ea6b23828da3e7f4',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1038,	'CA1a62baa8b4899c650a35488e95087827',	'',	'2017-04-24 18:15:47',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'91367',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+16612439350',	'+18186683907',	NULL,	NULL,	NULL,	NULL,	'SHERMAN OAKS',	'CA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1039,	'CA598473de60cbb69b2c52fd410836619e',	'',	'2017-04-24 20:36:28',	'US',	'',	'CA',	'',	'US',	'92614',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17142032448',	'+19513741928',	'+17142032448',	NULL,	NULL,	NULL,	NULL,	'IRVINE',	'CA',	'CA598473de60cbb69b2c52fd410836619e',	'+14062509831',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3f2462e45623dcd9b3c022ae0175a8bb',	0,	0,	'',	''),
(1040,	'CA42d289ab75b48fd4bbcf8e3c992e85a4',	'',	'2017-04-25 17:23:05',	'US',	'',	'CA',	'',	'US',	'90503',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13103400860',	'+19513741928',	'+13103400860',	NULL,	NULL,	NULL,	NULL,	'TORRANCE',	'CA',	'CA42d289ab75b48fd4bbcf8e3c992e85a4',	'+14062509831',	'completed',	12,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa6d8d92f0b7148f95d0495d56b01cf2f',	0,	0,	'',	''),
(1041,	'CA072e52efcad173e975545e6fd57f341d',	'',	'2017-04-25 18:26:05',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'91367',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18186683907',	'+16612439350',	'+18186683907',	NULL,	NULL,	NULL,	NULL,	'SHERMAN OAKS',	'CA',	'CAa2b394469d02290e2901311d743d8503',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1042,	'CA9221d45dc40efb3dd0c988e3b61343dd',	'',	'2017-04-26 22:39:19',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14158013362',	'+19513741928',	'+14158013362',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA2544985237edf83dfbafc637b37e25a7',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1043,	'CA969eb6ac034e9789b6e0a7ba92d53301',	'',	'2017-04-27 20:31:38',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'08648',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16095757098',	'+19722036640',	'+16095757098',	NULL,	NULL,	NULL,	NULL,	'TRENTON',	'NJ',	'CA969eb6ac034e9789b6e0a7ba92d53301',	'+14062509831',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE22432d77a02b5d26493302a5fede03a4',	0,	0,	'',	''),
(1044,	'CAee5e738615425f1115e1f165357db4d0',	'',	'2017-04-27 22:43:49',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'98154',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12062948489',	'+14252338984',	'+12062948489',	NULL,	NULL,	NULL,	NULL,	'SEATTLE',	'WA',	'CA00dd81fdcbc804315964f4d9bfe4ef54',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1045,	'CAd471fd9eae25a61253e34d5bae43e453',	'',	'2017-04-27 23:16:25',	'US',	'',	'CA',	'',	'US',	'92614',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17142032599',	'+19513741928',	'+17142032599',	NULL,	NULL,	NULL,	NULL,	'IRVINE',	'CA',	'CAd471fd9eae25a61253e34d5bae43e453',	'+14062509831',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc4061848190613187571a494b8a7add4',	0,	0,	'',	''),
(1046,	'CAa9ae74250c00125200d7010ebc05f41b',	'',	'2017-04-28 17:21:54',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'98154',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12062948489',	'+14252338984',	'+12062948489',	NULL,	NULL,	NULL,	NULL,	'SEATTLE',	'WA',	'CAa9ae74250c00125200d7010ebc05f41b',	'+14062509831',	'completed',	2,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE2a076c40de0b400e22bc6f2d51d29c3f',	0,	0,	'',	''),
(1047,	'CA571ef2ed75a4d4ef04482008f8776076',	'',	'2017-04-28 23:04:58',	'US',	'',	'CA',	'',	'US',	'92806',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17146005686',	'+19513741928',	'+17146005686',	NULL,	NULL,	NULL,	NULL,	'ANAHEIM',	'CA',	'CA571ef2ed75a4d4ef04482008f8776076',	'+14062509831',	'completed',	15,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4ed4b9bdf693f4a610a309e94c4ab746',	0,	0,	'',	''),
(1048,	'CA2bda1fba779b4751e14ee8b1897b6a58',	'',	'2017-05-01 22:19:00',	'US',	'',	'CA',	'',	'US',	'90017',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17142488179',	'+19513741928',	'+17142488179',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA2bda1fba779b4751e14ee8b1897b6a58',	'+14062509831',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE1fe36e5d4609a01b4d3d7871993fd307',	0,	0,	'',	''),
(1049,	'CAa006a2ded69bc79bb523c7474ee72f6b',	'',	'2017-05-01 22:47:32',	'US',	'',	'CA',	'',	'US',	'90017',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17142488179',	'+19513741928',	'+17142488179',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CAa006a2ded69bc79bb523c7474ee72f6b',	'+14062509831',	'completed',	14,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE9a7b87f23bac807240814e774ae135c3',	0,	0,	'',	''),
(1050,	'CAc500051f52e3303e7b5ef87148b288bf',	'',	'2017-05-02 17:56:33',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19492390412',	'+19513741928',	'+19492390412',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAc500051f52e3303e7b5ef87148b288bf',	'+14062509831',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE757d9d67a4bd94a7adf66895b9ca5624',	0,	0,	'',	''),
(1051,	'CA200b8bfecf52d27eda79fa7315effd66',	'',	'2017-05-03 17:53:30',	'US',	'',	'CA',	'',	'US',	'90802',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19092459408',	'+19513741928',	'+19092459408',	NULL,	NULL,	NULL,	NULL,	'LONG BEACH',	'CA',	'CA200b8bfecf52d27eda79fa7315effd66',	'+14062509831',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE7e9bc3bf36a657f9de3d1c5b5e0b5aa7',	0,	0,	'',	''),
(1052,	'CA648ed22585ca26916dba3b50cf1483a5',	'',	'2017-05-03 18:26:01',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12133575425',	'+16612439350',	'+12133575425',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA648ed22585ca26916dba3b50cf1483a5',	'+14062509831',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa0a7891cd9dd2b312f63e9aa8cca8b11',	0,	0,	'',	''),
(1053,	'CA83ac54b5ba8f6ec407b9de813a254946',	'',	'2017-05-03 20:07:43',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13133568058',	'+19162627163',	'+13133568058',	NULL,	NULL,	NULL,	NULL,	'DETROIT',	'MI',	'CA83ac54b5ba8f6ec407b9de813a254946',	'+14062509831',	'completed',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE55bca3e11f4725d5e1a07728c244b3f4',	0,	0,	'',	''),
(1054,	'CA3c38f94e9f1084117ecf15a4265f7528',	'',	'2017-05-03 20:15:40',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13852491364',	'+19513741928',	'+13852491364',	NULL,	NULL,	NULL,	NULL,	'SALT LAKE CITY',	'UT',	'CA3c38f94e9f1084117ecf15a4265f7528',	'+14062509831',	'completed',	3,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REdb618125eb115d732334640d18650c9e',	0,	0,	'',	''),
(1055,	'CAc0c2e9430009c01208efc691ecf29336',	'',	'2017-05-04 16:30:00',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19285827110',	'+19513741928',	'+19285827110',	NULL,	NULL,	NULL,	NULL,	'',	'AZ',	'CAc0c2e9430009c01208efc691ecf29336',	'+14062509831',	'completed',	2,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE0aacee99c942ec7da0a1f4f0107ba340',	0,	0,	'',	''),
(1056,	'CA2d159a98a1f4000d6cbd88e6667efa68',	'',	'2017-05-04 18:26:53',	'US',	'',	'CA',	'',	'US',	'90001',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13232388175',	'+19513741928',	'+13232388175',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA2d159a98a1f4000d6cbd88e6667efa68',	'+14062509831',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE631e9a3f99bfd031d0e66505f4482e86',	0,	0,	'',	''),
(1057,	'CA0c74fce5f8e660fcb57d4544c23852bc',	'',	'2017-05-05 16:08:49',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12532015568',	'+14252338984',	'+12532015568',	NULL,	NULL,	NULL,	NULL,	'',	'WA',	'CA0bf33ab56d6cda2759ae23a9b2e41ff5',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1058,	'CA0338221726f242453b71ba1ee913e4a5',	'',	'2017-05-05 17:44:35',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19096712727',	'+19513741928',	'+19096712727',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA0338221726f242453b71ba1ee913e4a5',	'+14062509831',	'completed',	17,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb345fb1a96ac680da86eb620f1231f7f',	0,	0,	'',	''),
(1059,	'CA6fdcba4c9f08658d6b1e9dd575d2c68e',	'',	'2017-05-05 22:17:37',	'US',	'',	'CA',	'',	'US',	'91761',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19512285582',	'+19513741928',	'+19512285582',	NULL,	NULL,	NULL,	NULL,	'ONTARIO',	'CA',	'CA6fdcba4c9f08658d6b1e9dd575d2c68e',	'+14062509831',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4a9fbf2d75d4df6e60cd8e44adbe3db1',	0,	0,	'',	''),
(1060,	'CA5a5cf4d466bdbec00a0f6fa415d819ce',	'',	'2017-05-08 18:06:35',	'US',	'',	'CA',	'',	'US',	'92614',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17142032576',	'+19513741928',	'+17142032576',	NULL,	NULL,	NULL,	NULL,	'IRVINE',	'CA',	'CA5a5cf4d466bdbec00a0f6fa415d819ce',	'+14062509831',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REad16e3888076b53fbf6ebb8edc6bc856',	0,	0,	'',	''),
(1061,	'CA62ea425e2cdcffb87bd6bf46108b397c',	'',	'2017-05-08 20:12:02',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12532015560',	'+14252338984',	'+12532015560',	NULL,	NULL,	NULL,	NULL,	'',	'WA',	'CA62ea425e2cdcffb87bd6bf46108b397c',	'+14062509831',	'completed',	2,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE227936676efa599701f9266d7318969f',	0,	0,	'',	''),
(1062,	'CA0e646a999f0e42a0c00b9a21656b32cd',	'',	'2017-05-09 17:30:26',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19492390419',	'+19513741928',	'+19492390419',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA0e646a999f0e42a0c00b9a21656b32cd',	'+14062509831',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4882c0013f26c025ffc9994e6fd159b1',	0,	0,	'',	''),
(1063,	'CA3b6d8f8d1cf119b0ab58a9df366dd89f',	'',	'2017-05-10 18:39:54',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12532015564',	'+14252338984',	'+12532015564',	NULL,	NULL,	NULL,	NULL,	'',	'WA',	'CAf59797d0f748577518caeda7b1dab6f6',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1064,	'CAa78c5bc61306aa777e701c61a4a0a0cc',	'',	'2017-05-10 20:14:47',	'US',	'',	'CA',	'',	'US',	'90014',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13232187910',	'+19513741928',	'+13232187910',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CAa78c5bc61306aa777e701c61a4a0a0cc',	'+14062509831',	'completed',	16,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE924a266b617debb6a1248df317159f97',	0,	0,	'',	''),
(1065,	'CA5821828363c43afd35df37c41b322e32',	'',	'2017-05-11 17:18:29',	'US',	'',	'CA',	'',	'US',	'92614',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17142032802',	'+19513741928',	'+17142032802',	NULL,	NULL,	NULL,	NULL,	'IRVINE',	'CA',	'CA5821828363c43afd35df37c41b322e32',	'+14062509831',	'completed',	15,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE351037650d17d853afdc45b5932d89ad',	0,	0,	'',	''),
(1066,	'CAf8bc4a790ec83e5f3c84505963d53cb8',	'',	'2017-05-11 17:35:03',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'28083',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17042735168',	'+19162627163',	'+17042735168',	NULL,	NULL,	NULL,	NULL,	'KANNAPOLIS',	'NC',	'CAf8bc4a790ec83e5f3c84505963d53cb8',	'+14062509831',	'completed',	3,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE39a1c6ed370e71a33f14289b9c678f86',	0,	0,	'',	''),
(1067,	'CA3cac1d7c116163f0ec331655ebe23630',	'',	'2017-05-12 16:11:24',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17207990695',	'+14252338984',	'+17207990695',	NULL,	NULL,	NULL,	NULL,	'',	'CO',	'CA3cac1d7c116163f0ec331655ebe23630',	'+14062509831',	'completed',	3,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE5d595f4ca9b5249af80a7a6dad952403',	0,	0,	'',	''),
(1068,	'CA72c107b31dbaed7ede3e4a8f8f3ab87c',	'',	'2017-05-12 22:55:46',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12532015563',	'+14252338984',	'+12532015563',	NULL,	NULL,	NULL,	NULL,	'',	'WA',	'CA5d061f8fbe59ac5baa6fd9bf87baa08e',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1069,	'CA9169556a3181178a7899fc2f608ae240',	'',	'2017-05-12 23:09:44',	'US',	'',	'CA',	'',	'US',	'90802',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19092459587',	'+19513741928',	'+19092459587',	NULL,	NULL,	NULL,	NULL,	'LONG BEACH',	'CA',	'CA9169556a3181178a7899fc2f608ae240',	'+14062509831',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa2e18fb3c1c15360e0c30ff89f9e5190',	0,	0,	'',	''),
(1070,	'CA42d0cbb04db664e6459ae9b79be73950',	'',	'2017-05-15 16:10:06',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13133568492',	'+16612439350',	'+13133568492',	NULL,	NULL,	NULL,	NULL,	'DETROIT',	'MI',	'CA16d70eb1f7781307f868954959f9319e',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1071,	'CA3d00db0b49c0801094069a8883ec42c4',	'',	'2017-05-15 17:09:50',	'US',	'',	'CA',	'',	'US',	'92614',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17142032772',	'+19513741928',	'+17142032772',	NULL,	NULL,	NULL,	NULL,	'IRVINE',	'CA',	'CA3d00db0b49c0801094069a8883ec42c4',	'+14062509831',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE187f45b62dc04bca9d7da3b2118a56e1',	0,	0,	'',	''),
(1072,	'CAc6f88570a407bceb7c8aa739d08746ad',	'',	'2017-05-15 19:23:24',	'US',	'',	'CA',	'',	'US',	'01609',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19789082184',	'+19513741928',	'+19789082184',	NULL,	NULL,	NULL,	NULL,	'WORCESTER',	'MA',	'CA1e3fb57f67338b1f3868ceed5f2f6155',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1073,	'CA2a41f93bdc029e9d4edda0556790f8d6',	'',	'2017-05-15 21:22:10',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12532015563',	'+14252338984',	'+12532015563',	NULL,	NULL,	NULL,	NULL,	'',	'WA',	'CA2bd47a10f382bd18a8dd758ed0a48213',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1074,	'CA397b807451e1bc40349b4b324c8e2336',	'',	'2017-05-16 20:14:25',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12532015563',	'+14252338984',	'+12532015563',	NULL,	NULL,	NULL,	NULL,	'',	'WA',	'CA44a13ac4d266c390cefb7be0b1597b2b',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1075,	'CA76ea5aeae74ddc42ed20faca5017c5a0',	'',	'2017-05-16 23:09:13',	'US',	'',	'CA',	'',	'US',	'90014',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13232187424',	'+19513741928',	'+13232187424',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA76ea5aeae74ddc42ed20faca5017c5a0',	'+14062509831',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE6fbd1977c0f01fd08a1b27c95af44711',	0,	0,	'',	''),
(1076,	'CAdb48cf0f4efc15e95dbe5747958b338e',	'',	'2017-05-17 15:59:55',	'US',	'',	'CA',	'',	'US',	'90503',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13103401338',	'+19513741928',	'+13103401338',	NULL,	NULL,	NULL,	NULL,	'TORRANCE',	'CA',	'CAdb48cf0f4efc15e95dbe5747958b338e',	'+14062509831',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3da87f193c6d07d22fbecba6aecba5e8',	0,	0,	'',	''),
(1077,	'CAafae6ed8de96c50da86d92878e42bef9',	'',	'2017-05-17 22:14:00',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12532015563',	'+14252338984',	'+12532015563',	NULL,	NULL,	NULL,	NULL,	'',	'WA',	'CAb3feb95e83a5af042c269c1dd59d7a4c',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1078,	'CA9fe38bece91436729eac1ead112304f4',	'',	'2017-05-18 17:20:03',	'US',	'',	'CA',	'',	'US',	'98109',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12062073522',	'+19513741928',	'+12062073522',	NULL,	NULL,	NULL,	NULL,	'SEATTLE',	'WA',	'CA9fe38bece91436729eac1ead112304f4',	'+14062509831',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REdfd04380506b13d8e0b3b81f950942f9',	0,	0,	'',	''),
(1079,	'CAe7c554d32cdb2ba9090cc2b4e82c6b37',	'',	'2017-05-18 19:42:32',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12406331040',	'+19162627163',	'+12406331040',	NULL,	NULL,	NULL,	NULL,	'',	'MD',	'CAed57e3233e8b926e6947a1715ae9bffd',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1080,	'CAb41b278aaed347c74654dc1770c1c105',	'',	'2017-05-18 21:52:39',	'US',	'',	'CA',	'',	'US',	'95816',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19167643977',	'+19513741928',	'+19167643977',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CAb41b278aaed347c74654dc1770c1c105',	'+14062509831',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE092b6782ed288b43a292d271a0a4ce11',	0,	0,	'',	''),
(1081,	'CAea80d921e61dd709edfd8c20fd9a2a71',	'',	'2017-05-19 18:14:03',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19166614080',	'+19513741928',	'+19166614080',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAea80d921e61dd709edfd8c20fd9a2a71',	'+14062509831',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REaff8b7843c43f7d33287c80bb0af18a9',	0,	0,	'',	''),
(1082,	'CAe2a03e08798e00c333f635b1a0a0a00c',	'',	'2017-05-19 20:53:14',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13852491364',	'+19513741928',	'+13852491364',	NULL,	NULL,	NULL,	NULL,	'SALT LAKE CITY',	'UT',	'CA27d71651c4af2f35327977549a1bd5fc',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1083,	'CAfa2eb5c04cb885ec92f64036d31cff4d',	'',	'2017-05-19 22:27:46',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12532015563',	'+14252338984',	'+12532015563',	NULL,	NULL,	NULL,	NULL,	'',	'WA',	'CA69019b9d62ff8b56563c3a3c1fc7b468',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1084,	'CA4c2534f026f0db062ec2b5e7a2a93336',	'',	'2017-05-19 22:55:16',	'US',	'',	'CA',	'',	'US',	'90802',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19092459608',	'+19513741928',	'+19092459608',	NULL,	NULL,	NULL,	NULL,	'LONG BEACH',	'CA',	'CA4c2534f026f0db062ec2b5e7a2a93336',	'+14062509831',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE6daa5c298e87ed1e3c3162dc31b19eb7',	0,	0,	'',	''),
(1085,	'CA5e5165ccfbed35af4065fbced49bbdda',	'',	'2017-05-22 03:44:10',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18005595769',	'+19513741928',	'+18005595769',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA5e5165ccfbed35af4065fbced49bbdda',	'+14062509831',	'completed',	73,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE5114f4ae9d81934c135c217ca9776aec',	0,	0,	'',	''),
(1086,	'CAffaef2f7ee9d6c7dc153caef01c825ef',	'',	'2017-05-22 15:23:25',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19163892999',	'+19513741928',	'+19163892999',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAffaef2f7ee9d6c7dc153caef01c825ef',	'+14062509831',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc611fb27b0fcb7fd4f85472e6dc352fe',	0,	0,	'',	''),
(1087,	'CAc2f9ed74fa1448c0a71bbf5a91304f80',	'',	'2017-05-22 22:30:10',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12532015563',	'+14252338984',	'+12532015563',	NULL,	NULL,	NULL,	NULL,	'',	'WA',	'CA57f352ea3ac3dc2d9953f523a4cff9ad',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1088,	'CA2324b6f2ef6cb13d18323168a2fb6cdb',	'',	'2017-05-23 19:09:46',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19165007413',	'+19162627163',	'+19165007413',	NULL,	NULL,	NULL,	NULL,	'Elk Grove',	'CA',	'CA2324b6f2ef6cb13d18323168a2fb6cdb',	'+14062509831',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE05e24b1823b39207235bf590b3d86750',	0,	0,	'',	''),
(1089,	'CA108cfc526a1ac6b1ffc707ac518df3af',	'',	'2017-05-23 22:19:10',	'US',	'',	'CA',	'',	'US',	'95818',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19165960700',	'+19513741928',	'+19165960700',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CA108cfc526a1ac6b1ffc707ac518df3af',	'+14062509831',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc9445eecbce36d285c7a5eb09c6bbdb8',	0,	0,	'',	''),
(1090,	'CA2c913fd0e64161d808b25240f9ac4a41',	'',	'2017-05-24 17:13:52',	'US',	'',	'CA',	'',	'US',	'95828',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19162889232',	'+19513741928',	'+19162889232',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CA2c913fd0e64161d808b25240f9ac4a41',	'+14062509831',	'completed',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3d135b350ba92fa17030aea5a93978f3',	0,	0,	'',	''),
(1091,	'CA4c7de868fceee576325838194ff225cf',	'',	'2017-05-24 18:04:56',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95814',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19168881884',	'+19162627163',	'+19168881884',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CA53e60b5d063e493655535f3e010cb8e0',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1092,	'CAbed79cfa8793e66379b089498b1592d7',	'',	'2017-05-24 23:14:51',	'US',	'',	'CA',	'',	'US',	'95828',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19162889232',	'+19513741928',	'+19162889232',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CAbed79cfa8793e66379b089498b1592d7',	'+14062509831',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE483fc2ee96db314d2c7d4ee450cb9d53',	0,	0,	'',	''),
(1093,	'CAc76681e1e792a41ad8abfd960f0ca2c7',	'',	'2017-05-25 17:13:15',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17752042387',	'+16612439350',	'+17752042387',	NULL,	NULL,	NULL,	NULL,	'',	'NV',	'CAc5e28883835c683377b78b5fe4a83be8',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1094,	'CA089b316348c58c0a2d800d6e4d28aec1',	'',	'2017-05-25 20:14:56',	'US',	'',	'CA',	'',	'US',	'94304',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16506812141',	'+19513741928',	'+16506812141',	NULL,	NULL,	NULL,	NULL,	'PALO ALTO',	'CA',	'CA089b316348c58c0a2d800d6e4d28aec1',	'+14062509831',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe6cc0540dec1b5505c405b29a2785caa',	0,	0,	'',	''),
(1095,	'CAbf43c2e441028ae047e0eadf8c5aaba9',	'',	'2017-05-26 01:34:27',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'98104',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14252335169',	'+14252338984',	'+14252335169',	NULL,	NULL,	NULL,	NULL,	'TUKWILA',	'WA',	'CAbf43c2e441028ae047e0eadf8c5aaba9',	'+14062509831',	'completed',	20,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE6616785801a333c02d39bff45be579cf',	0,	0,	'',	''),
(1096,	'CA866bdbfe6f9939e934c54db38908923a',	'',	'2017-05-26 16:00:53',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16096231455',	'+14252338984',	'+16096231455',	NULL,	NULL,	NULL,	NULL,	'',	'NJ',	'CA34afb83ea174e35fb4926422a386f703',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1097,	'CA2156a913b6fc0f93e435cc79bb19548c',	'',	'2017-05-26 17:34:21',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13853836022',	'+19513741928',	'+13853836022',	NULL,	NULL,	NULL,	NULL,	'SALT LAKE CITY',	'UT',	'CAf701c40c00d993831f848b62cbfbd3a4',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1098,	'CAc9190b8e259628c4e6d3ce72d7b50f7f',	'',	'2017-05-26 17:38:39',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12532015566',	'+14252338984',	'+12532015566',	NULL,	NULL,	NULL,	NULL,	'',	'WA',	'CA2473f296b0defcce85b5964b8ffe2b54',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1099,	'CAf05f7b70ca56472a3bc90229729dbe8b',	'',	'2017-05-26 19:56:56',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'10004',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17182850497',	'+14252338984',	'+17182850497',	NULL,	NULL,	NULL,	NULL,	'NEW YORK',	'NY',	'CA4a711f40c8f8e727682716ca18ed613b',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1100,	'CAb206b6cffe1ccd9d7a0d86d720312c2e',	'',	'2017-05-26 22:24:26',	'US',	'',	'CA',	'',	'US',	'94122',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14155926368',	'+19513741928',	'+14155926368',	NULL,	NULL,	NULL,	NULL,	'SAN FRANCISCO',	'CA',	'CAb206b6cffe1ccd9d7a0d86d720312c2e',	'+14062509831',	'completed',	14,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd790fcb412b880b8db91219712b60e51',	0,	0,	'',	''),
(1101,	'CAca1676754f36870a6031cf2c03ae425d',	'',	'2017-05-26 23:33:47',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13852491218',	'+19513741928',	'+13852491218',	NULL,	NULL,	NULL,	NULL,	'SALT LAKE CITY',	'UT',	'CAca1676754f36870a6031cf2c03ae425d',	'+14062509831',	'completed',	2,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE11d0d8b2e158de340cbffb11431a6e05',	0,	0,	'',	''),
(1102,	'CA31eb12afcbe842f69d853c6aa67e4757',	'',	'2017-05-30 17:33:01',	'US',	'',	'CA',	'',	'US',	'90011',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13235082471',	'+19513741928',	'+13235082471',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA31eb12afcbe842f69d853c6aa67e4757',	'+14062509831',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REbbdfcaa4958d87f9382dd3abae9770f7',	0,	0,	'',	''),
(1103,	'CA93fd50f2bb5c0a087257cab231c21e02',	'',	'2017-05-30 19:51:56',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'93562',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17603726284',	'+16612439350',	'+17603726284',	NULL,	NULL,	NULL,	NULL,	'TRONA',	'CA',	'CA93fd50f2bb5c0a087257cab231c21e02',	'+14062509831',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE82a4b8fc586f5d94a75f59a755eee525',	0,	0,	'',	''),
(1104,	'CAd9a96499598fdf37d6447795e4e28270',	'',	'2017-05-30 20:08:52',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14805653834',	'+19513741928',	'+14805653834',	NULL,	NULL,	NULL,	NULL,	'',	'AZ',	'CAd9a96499598fdf37d6447795e4e28270',	'+14062509831',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE706a19ffdeb8a3b2d1babf76d45340f6',	0,	0,	'',	''),
(1105,	'CA5265e187f2556da28b914d35bba8fbed',	'',	'2017-05-30 20:44:53',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16312010509',	'+19162627163',	'+16312010509',	NULL,	NULL,	NULL,	NULL,	'',	'NY',	'CAa308f169bc44c28ab434cdc90edd0579',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1106,	'CAae4d760376b7b24a2e590a9b5afc1b40',	'',	'2017-05-30 22:46:00',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17027100905',	'+19513741928',	'+17027100905',	NULL,	NULL,	NULL,	NULL,	'',	'NV',	'CAae4d760376b7b24a2e590a9b5afc1b40',	'+14062509831',	'completed',	12,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE2aca36185be90338199af1272f4ebc5e',	0,	0,	'',	''),
(1107,	'CA6f614810c436c30aa92f2481346aeb9e',	'',	'2017-05-31 17:40:40',	'US',	'',	'CA',	'',	'US',	'97232',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19713404800',	'+19513741928',	'+19713404800',	NULL,	NULL,	NULL,	NULL,	'PORTLAND',	'OR',	'CA6276c02b8d0df8e477193ec2eae76d46',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1108,	'CA38fd9b8492faa24d96e8b0c9dec0c7e1',	'',	'2017-05-31 19:50:28',	'US',	'',	'CA',	'',	'US',	'38954',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16624598030',	'+19513741928',	'+16624598030',	NULL,	NULL,	NULL,	NULL,	'GREENWOOD',	'MS',	'CA38fd9b8492faa24d96e8b0c9dec0c7e1',	'+14062509831',	'completed',	1,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REebf0a85fb0c13cbf088168043ff818f1',	0,	0,	'',	''),
(1109,	'CA25de5821a717add14e848a36e01b7285',	'',	'2017-05-31 20:56:16',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'93562',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17603726284',	'+16612439350',	'+17603726284',	NULL,	NULL,	NULL,	NULL,	'TRONA',	'CA',	'CA25de5821a717add14e848a36e01b7285',	'+14062509831',	'completed',	17,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe593353048831f445d60d748bd26149a',	0,	0,	'',	''),
(1110,	'CA7cfc2971576b3bbd04384a6693f65a03',	'',	'2017-06-01 16:53:51',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12088030217',	'+19513741928',	'+12088030217',	NULL,	NULL,	NULL,	NULL,	'',	'ID',	'CA7cfc2971576b3bbd04384a6693f65a03',	'+14062509831',	'completed',	2,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE5484150aa7e0138694e81a66a88dd7e9',	0,	0,	'',	''),
(1111,	'CA3b1aaba95b1f3ea1c1fbf070c1606800',	'',	'2017-06-01 18:30:52',	'US',	'',	'CA',	'',	'US',	'02911',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19513741928',	'+14012138738',	NULL,	NULL,	NULL,	NULL,	'CAROLINA',	'RI',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1112,	'CAfc80344429867ae084fe2fc2765494f7',	'',	'2017-06-01 18:30:53',	'US',	'',	'CA',	'',	'US',	'02911',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14012138738',	'+19513741928',	'+14012138738',	NULL,	NULL,	NULL,	NULL,	'CAROLINA',	'RI',	'CAfc80344429867ae084fe2fc2765494f7',	'+14062509831',	'completed',	1,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE95cf436c2b596d8f02899e5d68758c56',	0,	0,	'',	''),
(1113,	'CAceeafc720fb1ea4246fc27da4184bb6a',	'',	'2017-06-01 23:05:53',	'US',	'',	'CA',	'',	'US',	'98109',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12062073448',	'+19513741928',	'+12062073448',	NULL,	NULL,	NULL,	NULL,	'SEATTLE',	'WA',	'CAceeafc720fb1ea4246fc27da4184bb6a',	'+14062509831',	'completed',	14,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REcc4c51335755d4fda69ee295addea06c',	0,	0,	'',	''),
(1114,	'CA6544b1024e9833bd0cfd648289b284e7',	'',	'2017-06-02 17:12:46',	'US',	'',	'CA',	'',	'US',	'92123',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16194583832',	'+19513741928',	'+16194583832',	NULL,	NULL,	NULL,	NULL,	'SAN DIEGO',	'CA',	'CA6544b1024e9833bd0cfd648289b284e7',	'+14062509831',	'completed',	16,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REcd9277b64015447cc95e5afc42583955',	0,	0,	'',	''),
(1115,	'CA10827eab9f1b712ceefb3c09b0731c73',	'',	'2017-06-02 19:03:14',	'US',	'',	'CA',	'',	'US',	'92614',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18188624026',	'+19513741928',	'+18188624026',	NULL,	NULL,	NULL,	NULL,	'IRVINE',	'CA',	'CA10827eab9f1b712ceefb3c09b0731c73',	'+14062509831',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE1f8ec84248a6f8718443c8eece20ad59',	0,	0,	'',	''),
(1116,	'CA015b0fb4d6657b967f3e3d56f58109f0',	'',	'2017-06-02 20:52:09',	'US',	'',	'CA',	'',	'US',	'17316',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19513741928',	'+17173089980',	NULL,	NULL,	NULL,	NULL,	'DOVER',	'PA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1117,	'CA15fd9f48dec8356a5fbd299c9b2470d3',	'',	'2017-06-02 20:52:10',	'US',	'',	'CA',	'',	'US',	'17316',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17173089980',	'+19513741928',	'+17173089980',	NULL,	NULL,	NULL,	NULL,	'DOVER',	'PA',	'CA4295a77944c5199c1c890b4743ee41bb',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1118,	'CA47fc8e92d3bc78510fa081c87977e697',	'',	'2017-06-05 17:11:06',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13237940039',	'+19513741928',	'+13237940039',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA47fc8e92d3bc78510fa081c87977e697',	'+14062509831',	'completed',	17,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE904d39c53a26679b4742f5be040eaaed',	0,	0,	'',	''),
(1119,	'CA0e6d298829dc5c45b21438334b971d19',	'',	'2017-06-05 17:46:37',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15014063074',	'+19162627163',	'+15014063074',	NULL,	NULL,	NULL,	NULL,	'',	'AR',	'CA0e6d298829dc5c45b21438334b971d19',	'+14062509831',	'completed',	2,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE00d9db3abbabc90e8658aa57f7059b61',	0,	0,	'',	''),
(1120,	'CA6101767c68aad94a1cc3174e2455e2f8',	'',	'2017-06-05 18:43:10',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17752042378',	'+19513741928',	'+17752042378',	NULL,	NULL,	NULL,	NULL,	'',	'NV',	'CA6101767c68aad94a1cc3174e2455e2f8',	'+14062509831',	'completed',	3,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb8751107172a17fead127d61bda249ad',	0,	0,	'',	''),
(1121,	'CA56a8543b38f925e4caa451172aabca54',	'',	'2017-06-05 19:24:34',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14152663675',	'+19162627163',	'+14152663675',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA56a8543b38f925e4caa451172aabca54',	'+14062509831',	'completed',	15,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd41e5ba4dcf81c1c94e01fcf501da41c',	0,	0,	'',	''),
(1122,	'CAd8447c2b13dadefb15d77eaea775a0c5',	'',	'2017-06-05 21:37:45',	'US',	'',	'CA',	'',	'US',	'17316',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19513741928',	'+17173089980',	NULL,	NULL,	NULL,	NULL,	'DOVER',	'PA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1123,	'CA4ac764b44a17fd23d53a73d7e871a98d',	'',	'2017-06-05 21:37:46',	'US',	'',	'CA',	'',	'US',	'17316',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19513741928',	'+17173089980',	NULL,	NULL,	NULL,	NULL,	'DOVER',	'PA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1124,	'CA0467d56d6a3f73937dc43784a4a8e27f',	'',	'2017-06-06 22:42:50',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19163183983',	'+19513741928',	'+19163183983',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA0467d56d6a3f73937dc43784a4a8e27f',	'+14062509831',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc399ca8a8f5b76181599a3e400812a55',	0,	0,	'',	''),
(1125,	'CA3ac0becc3a41af416a3ea55020b132e3',	'',	'2017-06-07 22:37:16',	'US',	'',	'CA',	'',	'US',	'90017',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12139854556',	'+19513741928',	'+12139854556',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA3ac0becc3a41af416a3ea55020b132e3',	'+14062509831',	'completed',	16,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE9ca07faa9ec29aa6a3452e8b73ca399b',	0,	0,	'',	''),
(1126,	'CAede391c85214595646481f188ed487b3',	'',	'2017-06-08 21:29:09',	'US',	'',	'CA',	'',	'US',	'92084',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17603308023',	'+19513741928',	'+17603308023',	NULL,	NULL,	NULL,	NULL,	'VISTA',	'CA',	'CAede391c85214595646481f188ed487b3',	'+14062509831',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE6b7532dd44916506cc12ef098ca8e0ce',	0,	0,	'',	''),
(1127,	'CA37026334e8bf899bd52d4dd81a92cd81',	'',	'2017-06-08 22:15:47',	'US',	'',	'CA',	'',	'US',	'92868',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17144972234',	'+19513741928',	'+17144972234',	NULL,	NULL,	NULL,	NULL,	'ORANGE',	'CA',	'CA39a0cc56f49f72ddd856a5048499bcd1',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1128,	'CA351ec95e99edafd8b00db7fa039ca721',	'',	'2017-06-08 22:23:36',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13852491364',	'+19513741928',	'+13852491364',	NULL,	NULL,	NULL,	NULL,	'SALT LAKE CITY',	'UT',	'CA351ec95e99edafd8b00db7fa039ca721',	'+14062509831',	'completed',	3,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE54d9b7272782e4bc758d956387db73f8',	0,	0,	'',	''),
(1129,	'CA2c42793e69ed4913e182b6d65021088c',	'',	'2017-06-09 03:13:48',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19513840975',	'+19513741928',	'+19513840975',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA2c42793e69ed4913e182b6d65021088c',	'+14062509831',	'completed',	3,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE6acde79d810f865320a5e89f25a8e465',	0,	0,	'',	''),
(1130,	'CAdc32ab04fc4ffc6fa97b60b19ace318d',	'',	'2017-06-09 23:12:32',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14243659052',	'+19513741928',	'+14243659052',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAdc32ab04fc4ffc6fa97b60b19ace318d',	'+14062509831',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE7a5ba0ee63101a5c25d387d03eb6753a',	0,	0,	'',	''),
(1131,	'CAa4b6aafb6ce1af8394fcff825c13b290',	'',	'2017-06-13 23:15:40',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14159805347',	'+19513741928',	'+14159805347',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAa4b6aafb6ce1af8394fcff825c13b290',	'+14062509831',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE7c8a5fd21c1b68ba684440a993bc083e',	0,	0,	'',	''),
(1132,	'CA7f4b75db004ac8bee2d29f16ccde76e1',	'',	'2017-06-13 23:49:10',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'98104',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14252333167',	'+14252338984',	'+14252333167',	NULL,	NULL,	NULL,	NULL,	'TUKWILA',	'WA',	'CA7f4b75db004ac8bee2d29f16ccde76e1',	'+14062509831',	'completed',	20,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE12a66a07bb04dac209241ce40d2cf607',	0,	0,	'',	''),
(1133,	'CA56157c28029ce6db400e2963ba5bbe82',	'',	'2017-06-14 16:19:05',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13133568495',	'+14252338984',	'+13133568495',	NULL,	NULL,	NULL,	NULL,	'DETROIT',	'MI',	'CA56157c28029ce6db400e2963ba5bbe82',	'+14062509831',	'completed',	3,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE16133a9399f1b76af366bc19d83ddf2a',	0,	0,	'',	''),
(1134,	'CAfc0c5ee7d989091707916a31ac47211d',	'',	'2017-06-14 17:44:12',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'91403',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13237987341',	'+19162627163',	'+13237987341',	NULL,	NULL,	NULL,	NULL,	'SHERMAN OAKS',	'CA',	'CAfc0c5ee7d989091707916a31ac47211d',	'+14062509831',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE59a0a6b3fc650dc5abc10fe7baaf89db',	0,	0,	'',	''),
(1135,	'CA376e36813de20c709f1a105961120994',	'',	'2017-06-14 17:45:24',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16693335858',	'+19513741928',	'+16693335858',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA376e36813de20c709f1a105961120994',	'+14062509831',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4a59839b6555653abde1f429a3715392',	0,	0,	'',	''),
(1136,	'CA47ad1df4afaf4ac6c90452e4967626a5',	'',	'2017-06-14 21:12:22',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14699304413',	'+14252338984',	'+14699304413',	NULL,	NULL,	NULL,	NULL,	'',	'TX',	'CAcc8c575e891145ac2b40d3e6c7d60ce6',	'+14062509831',	'voicemail',	25,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE2186375354771d3f55c059dc3ca7ebdc',	0,	0,	'',	''),
(1137,	'CA885376dcdec70d6df7056d8abb2efc3e',	'',	'2017-06-14 22:40:48',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'91403',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13237987341',	'+19162627163',	'+13237987341',	NULL,	NULL,	NULL,	NULL,	'SHERMAN OAKS',	'CA',	'CA885376dcdec70d6df7056d8abb2efc3e',	'+14062509831',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE928a70ea36ef49d3ebc03b6105e4c19c',	0,	0,	'',	''),
(1138,	'CA1d30f9bc6d23c576e94c9bf103aa6091',	'',	'2017-06-15 22:58:47',	'US',	'',	'CA',	'',	'US',	'90017',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12135998467',	'+19513741928',	'+12135998467',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA4e7a98d4d061c0c3b883981c85d9a06a',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1139,	'CA1ed140b2240bfff914c98c85523861f1',	'',	'2017-06-16 16:59:29',	'US',	'',	'CA',	'',	'US',	'94111',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16504667666',	'+19513741928',	'+16504667666',	NULL,	NULL,	NULL,	NULL,	'SAN FRANCISCO',	'CA',	'CA1ed140b2240bfff914c98c85523861f1',	'+14062509831',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd209f9ac1387f06c3f45c1be6771850d',	0,	0,	'',	''),
(1140,	'CA9467cded94a0904d24a16400d59f5900',	'',	'2017-06-16 21:21:56',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'91403',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13237987341',	'+19162627163',	'+13237987341',	NULL,	NULL,	NULL,	NULL,	'SHERMAN OAKS',	'CA',	'CA20df3b5988c5cb0e2fdda74a0ccebcb6',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1141,	'CA5d60c6ae677499a488e105d1004d0b85',	'',	'2017-06-17 18:00:01',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75243',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12142152668',	'+19722036640',	'+12142152668',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CA5d60c6ae677499a488e105d1004d0b85',	'+14062509831',	'completed',	15,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE612f9f3380dd36fe18337f32d1b91c97',	0,	0,	'',	''),
(1142,	'CA741925188d68a081097142f7af70b940',	'',	'2017-06-19 16:04:08',	'US',	'',	'CA',	'',	'US',	'21601',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14432589393',	'+19513741928',	'+14432589393',	NULL,	NULL,	NULL,	NULL,	'EASTON',	'MD',	'CAdd478b8fb19b47f43546e4cef89aca26',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1143,	'CA6c5d1e4263b63c451ea261c5bea0572b',	'',	'2017-06-19 16:07:49',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'91403',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13237987341',	'+19162627163',	'+13237987341',	NULL,	NULL,	NULL,	NULL,	'SHERMAN OAKS',	'CA',	'CA12dc8964c0786f767406c6c6b1648750',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1144,	'CA2fdf4c735f8f30bd6227a162ee94faa3',	'',	'2017-06-19 19:40:38',	'US',	'',	'CA',	'',	'US',	'92084',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17603308023',	'+19513741928',	'+17603308023',	NULL,	NULL,	NULL,	NULL,	'VISTA',	'CA',	'CA2fdf4c735f8f30bd6227a162ee94faa3',	'+14062509831',	'completed',	1,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REfeb14b858e5031f863eee92b5bd353ac',	0,	0,	'',	''),
(1145,	'CA198b4b41b31e5bd71a80f0ecae79981a',	'',	'2017-06-19 20:56:01',	'US',	'',	'CA',	'',	'US',	'91768',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19513741928',	'+19095420900',	NULL,	NULL,	NULL,	NULL,	'CLAREMONT',	'CA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1146,	'CA852006d459dadf257e488279b52259ee',	'',	'2017-06-19 23:04:12',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14154631881',	'+19513741928',	'+14154631881',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA5261fc2487e1127cc67306ed54981cf3',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1147,	'CAd55ea61e5fb96165bb8624d871858ef8',	'',	'2017-06-20 16:23:42',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17313009214',	'+19162627163',	'+17313009214',	NULL,	NULL,	NULL,	NULL,	'',	'TN',	'CAd55ea61e5fb96165bb8624d871858ef8',	'+14062509831',	'completed',	4,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf66b6fcee3c2587c7dcc79d8a8a960dc',	0,	0,	'',	''),
(1148,	'CA322d76b51708ba98dcec23ecf7b856a8',	'',	'2017-06-20 17:10:33',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19494695616',	'+19513741928',	'+19494695616',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA322d76b51708ba98dcec23ecf7b856a8',	'+14062509831',	'completed',	172,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa7cabfc50208acd3c34e21a2af83c55f',	0,	0,	'',	''),
(1149,	'CA0cae23e24aa1bccb4ec3b2f560c61287',	'',	'2017-06-20 17:42:57',	'US',	'',	'CA',	'',	'US',	'91607',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12138057232',	'+19513741928',	'+12138057232',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA0cae23e24aa1bccb4ec3b2f560c61287',	'+14062509831',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE1556cf71241a38ed7b9fce9af8141f72',	0,	0,	'',	''),
(1150,	'CAbd826d6f5e3d19da79554d493efa3daf',	'',	'2017-06-20 22:15:15',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12532015562',	'+14252338984',	'+12532015562',	NULL,	NULL,	NULL,	NULL,	'',	'WA',	'CAb6ebc453074f589e6349865c4334cfd1',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1151,	'CA9a247237c33f76929af0f718a78bbf7e',	'',	'2017-06-21 16:29:55',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'91403',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13237987341',	'+19162627163',	'+13237987341',	NULL,	NULL,	NULL,	NULL,	'SHERMAN OAKS',	'CA',	'CA9a247237c33f76929af0f718a78bbf7e',	'+14062509831',	'completed',	18,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE94294570275511c736ece20905f27a01',	0,	0,	'',	''),
(1152,	'CAa5f14b1174f375e46bc924c8d23ed641',	'',	'2017-06-21 17:17:12',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19514210023',	'+19162627163',	'+19514210023',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA7a71c31ddb59e5e674870deb52455036',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1153,	'CAf59c03a48e39a1cb6472660466394f5d',	'',	'2017-06-21 18:40:38',	'US',	'83001',	'WY',	'JACKSON',	'US',	'59903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14062509831',	'+13072014710',	'+14062509831',	NULL,	NULL,	NULL,	NULL,	'KALISPELL',	'MT',	'CAf59c03a48e39a1cb6472660466394f5d',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1154,	'CA93b37efa87bcd83d371c9459a41b2671',	'',	'2017-06-21 18:46:36',	'US',	'',	'CA',	'',	'US',	'91403',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13237987341',	'+19513741928',	'+13237987341',	NULL,	NULL,	NULL,	NULL,	'SHERMAN OAKS',	'CA',	'CAf4bba60f4a9627b94751e0045962e565',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1155,	'CA1e7f7a6bc2ba0829b616cf68c266210b',	'',	'2017-06-21 23:21:21',	'US',	'',	'CA',	'',	'US',	'92705',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12137844904',	'+19513741928',	'+12137844904',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA1e7f7a6bc2ba0829b616cf68c266210b',	'+14062509831',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REfaedf6bcfeb8ddf3fed91e01ec5c60f2',	0,	0,	'',	''),
(1156,	'CA36ff753bb39e27a0a8eac61cd4466ab2',	'',	'2017-06-22 15:15:49',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'92411',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19095373353',	'+19162627163',	'+19095373353',	NULL,	NULL,	NULL,	NULL,	'SAN BERNARDINO',	'CA',	'CA36ff753bb39e27a0a8eac61cd4466ab2',	'+14062509831',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REbd813c4a2d6d32c9d068983c62e95842',	0,	0,	'',	''),
(1157,	'CAc40694a4019a42ceaba3c0b46dacd29e',	'',	'2017-06-22 17:10:54',	'US',	'',	'CA',	'',	'US',	'95818',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19169306908',	'+19513741928',	'+19169306908',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CAc40694a4019a42ceaba3c0b46dacd29e',	'+14062509831',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE67eb0137354959ba8c48eedb273e3ab6',	0,	0,	'',	''),
(1158,	'CA673d44711dd09e55c3fe6ac135bca6d7',	'',	'2017-06-22 20:24:17',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+14252338984',	'+14807396787',	NULL,	NULL,	NULL,	NULL,	'',	'AZ',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1159,	'CAc025e2d6800fce72ebe232acf4860079',	'',	'2017-06-23 03:14:53',	'US',	'',	'CA',	'',	'US',	'90066',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19518709698',	'+19513741928',	'+19518709698',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CAc025e2d6800fce72ebe232acf4860079',	'+14062509831',	'completed',	22,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REcc2ef1cc0fc076bad66cc34b6e69a8ac',	0,	0,	'',	''),
(1160,	'CA9a4205aca82a4f6f2981831316003e47',	'',	'2017-06-23 21:37:54',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12532017678',	'+14252338984',	'+12532017678',	NULL,	NULL,	NULL,	NULL,	'',	'WA',	'CAf01aa77efe30d04a2c4002b422871427',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1161,	'CAa2c954a11b4f69a85d31063249b7845a',	'',	'2017-06-23 23:12:58',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16692207103',	'+19513741928',	'+16692207103',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAa2c954a11b4f69a85d31063249b7845a',	'+14062509831',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE1090e01aab3f0976ee6172ab461808e8',	0,	0,	'',	''),
(1162,	'CAda5ecab3411cecdba278ac367588983e',	'',	'2017-06-23 23:12:59',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16692207103',	'+19513741928',	'+16692207103',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA4796ff0b28352a76ec9279f6f0dd0995',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1163,	'CA744aa267fd5e5d7cec9b279a1c33edd8',	'',	'2017-06-26 18:42:26',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'38126',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19017912952',	'+14252338984',	'+19017912952',	NULL,	NULL,	NULL,	NULL,	'MEMPHIS',	'TN',	'CA744aa267fd5e5d7cec9b279a1c33edd8',	'+14062509831',	'completed',	18,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE03c651fef4d539963a2abeba3dd69959',	0,	0,	'',	''),
(1164,	'CA5d8e841a219e17ceb9ab3e91c3b33295',	'',	'2017-06-27 17:29:41',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'57004',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16054960139',	'+16612439350',	'+16054960139',	NULL,	NULL,	NULL,	NULL,	'BERESFORD',	'SD',	'CAaeca1a9df037e7b97302f80c237300eb',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1165,	'CA0457762322ab17d6b36acaccfd7b1a26',	'',	'2017-06-27 18:29:57',	'US',	'',	'CA',	'',	'US',	'56721',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17013545726',	'+19513741928',	'+17013545726',	NULL,	NULL,	NULL,	NULL,	'GRANDFORKS',	'ND',	'CAbc68aca647c69f81e9824f99078a6fc2',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1166,	'CAde1e1f05b1c4d91cc89b76232bde9373',	'',	'2017-06-27 21:17:38',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95818',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15305549036',	'+19162627163',	'+15305549036',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CA640585d02c190d8d8a1d1add82807161',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1167,	'CA63ee4d0162a8ebe848afbbece4d3d708',	'',	'2017-06-28 17:34:02',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19493442541',	'+19513741928',	'+19493442541',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA63ee4d0162a8ebe848afbbece4d3d708',	'+14062509831',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3ee36c943390033d76af1c293045f422',	0,	0,	'',	''),
(1168,	'CA6208797f63df52c047a7a6308fdf1da6',	'',	'2017-06-28 18:26:14',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'92123',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18589970389',	'+14252338984',	'+18589970389',	NULL,	NULL,	NULL,	NULL,	'SAN DIEGO',	'CA',	'CA6208797f63df52c047a7a6308fdf1da6',	'+14062509831',	'completed',	18,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE7fe733cab86675ed4b79bd53eeb63d49',	0,	0,	'',	''),
(1169,	'CA221b3aabeb81917d29d3dd5110043b3b',	'',	'2017-06-28 19:04:26',	'US',	'',	'CA',	'',	'US',	'92122',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16199164481',	'+19513741928',	'+16199164481',	NULL,	NULL,	NULL,	NULL,	'SAN DIEGO',	'CA',	'CA221b3aabeb81917d29d3dd5110043b3b',	'+14062509831',	'completed',	18,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe8112c3b25b30bdfccbffbd73e37ebb9',	0,	0,	'',	''),
(1170,	'CA322f8b04bba2f2cc1f012295ed40cad4',	'',	'2017-06-28 21:17:05',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'92122',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16199164481',	'+19162627163',	'+16199164481',	NULL,	NULL,	NULL,	NULL,	'SAN DIEGO',	'CA',	'CA322f8b04bba2f2cc1f012295ed40cad4',	'+14062509831',	'completed',	18,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE30323f256d6d1207135a42b589ad90de',	0,	0,	'',	''),
(1171,	'CAc0014a62746b9a2a7d107b9043e83718',	'',	'2017-06-28 21:31:07',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'92122',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16199164481',	'+16612439350',	'+16199164481',	NULL,	NULL,	NULL,	NULL,	'SAN DIEGO',	'CA',	'CAc0014a62746b9a2a7d107b9043e83718',	'+14062509831',	'completed',	19,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE1afec0753ee939f1727fdd74a05301a0',	0,	0,	'',	''),
(1172,	'CA5354096cac56068203e6010dd0af8ab9',	'',	'2017-06-28 23:24:13',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14012004338',	'+19513741928',	'+14012004338',	NULL,	NULL,	NULL,	NULL,	'',	'RI',	'CA5354096cac56068203e6010dd0af8ab9',	'+14062509831',	'completed',	1,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE1674a8d8c98780fa5049b803eb730557',	0,	0,	'',	''),
(1173,	'CA34a9334cfb35b4d75682dd2258d29e36',	'',	'2017-06-29 23:14:04',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12064830179',	'+19513741928',	'+12064830179',	NULL,	NULL,	NULL,	NULL,	'',	'WA',	'CA34a9334cfb35b4d75682dd2258d29e36',	'+14062509831',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REab8a33dce980e5db9061335967961d13',	0,	0,	'',	''),
(1174,	'CAf581c5c8cd2a976fe221d484faaed058',	'',	'2017-06-29 23:49:32',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13852491222',	'+19513741928',	'+13852491222',	NULL,	NULL,	NULL,	NULL,	'SALT LAKE CITY',	'UT',	'CAf581c5c8cd2a976fe221d484faaed058',	'+14062509831',	'completed',	2,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE776a0812c4b0c06ba62d8caa2a90f4d0',	0,	0,	'',	''),
(1175,	'CAd9d3054bb1c9623e5fbc5cfa144c9c62',	'',	'2017-06-30 22:18:13',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16693337866',	'+19513741928',	'+16693337866',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAd9d3054bb1c9623e5fbc5cfa144c9c62',	'+14062509831',	'completed',	14,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REdeaefbefb1de6d698f40e80862a02d5d',	0,	0,	'',	''),
(1176,	'CA6825db6b1d520dbf492df71c15d89feb',	'',	'2017-07-02 16:37:40',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'92887',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+16612439350',	'+17143402618',	NULL,	NULL,	NULL,	NULL,	'ANAHEIM',	'CA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1177,	'CA42c09252e0ec06a9b89c9e8767ba27f2',	'',	'2017-07-03 17:22:07',	'US',	'',	'CA',	'',	'US',	'90012',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12139960078',	'+19513741928',	'+12139960078',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA42c09252e0ec06a9b89c9e8767ba27f2',	'+14062509831',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE87a588d614c50b633a3bae97f5f1b026',	0,	0,	'',	''),
(1178,	'CA09b8373c86461599200d65c966b035f1',	'',	'2017-07-05 20:07:35',	'US',	'',	'CA',	'',	'US',	'33445',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15614509093',	'+19513741928',	'+15614509093',	NULL,	NULL,	NULL,	NULL,	'DELRAY BEACH',	'FL',	'CA09b8373c86461599200d65c966b035f1',	'+14062509831',	'completed',	118,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE0eac5010b9be38de1e2a334d01303c71',	0,	0,	'',	''),
(1179,	'CA935002303df789908bae973a5d34655f',	'',	'2017-07-05 23:09:37',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13238949733',	'+19513741928',	'+13238949733',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA935002303df789908bae973a5d34655f',	'+14062509831',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4830f158a1753e65348411121289ca77',	0,	0,	'',	''),
(1180,	'CA94751c1bde0deddd9ec016a0bed0c2a4',	'',	'2017-07-06 02:23:58',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18006718664',	'+19513741928',	'+18006718664',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA9f6d7f1014040ca7bcf531e8fd4a5a3c',	'+14062509831',	'voicemail',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE11a284ccf1511e53c510b0bf8cdb8a82',	0,	0,	'',	''),
(1181,	'CA1b5710720cae49a81a9cdc481d91980b',	'',	'2017-07-06 17:03:57',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14156505350',	'+19513741928',	'+14156505350',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA1b5710720cae49a81a9cdc481d91980b',	'+14062509831',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE345980a90006611c6577c107e4bd73cd',	0,	0,	'',	''),
(1182,	'CA46cf3ffa5482bff4d851607568671a0d',	'',	'2017-07-06 21:40:18',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19495372484',	'+19513741928',	'+19495372484',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA46cf3ffa5482bff4d851607568671a0d',	'+14062509831',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE771aa7b2737e644c9c586a35aa3f2010',	0,	0,	'',	''),
(1183,	'CAaf23dd1c9434899b189901c9e693e2fc',	'',	'2017-07-07 10:40:33',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'93308',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16612439350',	'+16612439350',	'+16612439350',	NULL,	NULL,	NULL,	NULL,	'BAKERSFIELD',	'CA',	'CAaf23dd1c9434899b189901c9e693e2fc',	'+14062509831',	'completed',	4,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf5e68103d54a896b281f4e121ad03c4f',	0,	0,	'',	''),
(1184,	'CA3e6d9386d45d5cd946e64b917e59f843',	'',	'2017-07-07 16:13:11',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95814',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19162627163',	'+19168881884',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1185,	'CA6d6a944e388fbe611b8bf21c51e13954',	'',	'2017-07-07 18:49:10',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14159801235',	'+19513741928',	'+14159801235',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA6d6a944e388fbe611b8bf21c51e13954',	'+14062509831',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE2ff3629b7aa5a96895b1fd346a9726f1',	0,	0,	'',	''),
(1186,	'CAef217105c90b86cfbec56825811649e3',	'',	'2017-07-07 21:50:25',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14422005403',	'+19513741928',	'+14422005403',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA4669eccab59c176f5ec02a59cd69613c',	'+14062509831',	'voicemail',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE86af07774a86e2ff0595fcfc75a326af',	0,	0,	'',	''),
(1187,	'CA3d10aa3a08440b711f32835b255d5435',	'',	'2017-07-10 16:41:01',	'US',	'',	'CA',	'',	'US',	'93274',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15593843472',	'+19513741928',	'+15593843472',	NULL,	NULL,	NULL,	NULL,	'TULARE',	'CA',	'CA3d10aa3a08440b711f32835b255d5435',	'+14062509831',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE6a539c121c182a5c6496c2a78109d3ab',	0,	0,	'',	''),
(1188,	'CAb6213135093a661ed52939c02e47b38e',	'',	'2017-07-10 17:48:02',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19496563713',	'+19513741928',	'+19496563713',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA02d7c76a18b0b484b730ef26828ce2fc',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1189,	'CAbb2998e4294374dfd05a3e9267ca7829',	'',	'2017-07-10 17:58:00',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'30319',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+14252338984',	'+17704150734',	NULL,	NULL,	NULL,	NULL,	'ATLANTA',	'GA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1190,	'CAf3fb4414a6f18da13885df42b9e101d0',	'',	'2017-07-10 18:48:57',	'US',	'',	'CA',	'',	'US',	'93274',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15593843482',	'+19513741928',	'+15593843482',	NULL,	NULL,	NULL,	NULL,	'TULARE',	'CA',	'CAf3fb4414a6f18da13885df42b9e101d0',	'+14062509831',	'completed',	14,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe7cde23f86f8441b4cf1d2da6beda7e4',	0,	0,	'',	''),
(1191,	'CA788b36d3e6c9c7055b892a9dd71f69ad',	'',	'2017-07-10 22:02:34',	'US',	'',	'CA',	'',	'US',	'93618',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15594067682',	'+19513741928',	'+15594067682',	NULL,	NULL,	NULL,	NULL,	'DINUBA',	'CA',	'CA788b36d3e6c9c7055b892a9dd71f69ad',	'+14062509831',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb1d0aa51f7ac1d717385347703d5c24f',	0,	0,	'',	''),
(1192,	'CAc751178628d5745c87d8cb41cf82422b',	'',	'2017-07-11 16:11:55',	'US',	'',	'CA',	'',	'US',	'93618',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15594067691',	'+19513741928',	'+15594067691',	NULL,	NULL,	NULL,	NULL,	'DINUBA',	'CA',	'CAc751178628d5745c87d8cb41cf82422b',	'+14062509831',	'completed',	22,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REafe477888669cf0abf44d05599749567',	0,	0,	'',	''),
(1193,	'CAb9d8db7b7edb2125ca1d272edcdc523a',	'',	'2017-07-11 17:46:16',	'US',	'',	'CA',	'',	'US',	'92805',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17149784899',	'+19513741928',	'+17149784899',	NULL,	NULL,	NULL,	NULL,	'ORANGE',	'CA',	'CAb9d8db7b7edb2125ca1d272edcdc523a',	'+14062509831',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE861a0bc4e028d2fcc4b4336b9c184cc7',	0,	0,	'',	''),
(1194,	'CA96d01f31c8ef658a2867af40acf860fc',	'',	'2017-07-11 18:18:34',	'US',	'',	'CA',	'',	'US',	'93618',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15594067879',	'+19513741928',	'+15594067879',	NULL,	NULL,	NULL,	NULL,	'DINUBA',	'CA',	'CA96d01f31c8ef658a2867af40acf860fc',	'+14062509831',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE2e5ca1275d881290f29bb8601136c8ee',	0,	0,	'',	''),
(1195,	'CA6a2876337af4cd80d31c6d37a1f8967b',	'',	'2017-07-11 20:27:49',	'US',	'',	'CA',	'',	'US',	'93609',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15596440440',	'+19513741928',	'+15596440440',	NULL,	NULL,	NULL,	NULL,	'CARUTHERS',	'CA',	'CAba29246d605de6f4d6748607589ed39f',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1196,	'CA7d0b847a3fe0987a8ecf4ab78847d0fe',	'',	'2017-07-11 22:48:30',	'US',	'',	'CA',	'',	'US',	'93609',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15596440449',	'+19513741928',	'+15596440449',	NULL,	NULL,	NULL,	NULL,	'CARUTHERS',	'CA',	'CAa13328d9f1635a8d8c21ee2c67c1f775',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1197,	'CA9977ad9bd75de8e825333ad5aac0f6c8',	'',	'2017-07-12 20:58:37',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19513741928',	'+13852491294',	NULL,	NULL,	NULL,	NULL,	'SALT LAKE CITY',	'UT',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1198,	'CAdce8533cfe66ce38238ff1ef598ec659',	'',	'2017-07-12 23:15:04',	'US',	'',	'CA',	'',	'US',	'90015',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13239243834',	'+19513741928',	'+13239243834',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA0967b4081a6f6e569295fc8805b9efe9',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1199,	'CA6ee786b3b6c43a05dfbbdbee18232ec1',	'',	'2017-07-13 16:34:21',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18006829265',	'+19162627163',	'+18006829265',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA6ee786b3b6c43a05dfbbdbee18232ec1',	'+14062509831',	'completed',	28,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd8b6bd45b67bfdeeb0751d1f000e784e',	0,	0,	'',	''),
(1200,	'CA32b4ac648319c40c0447a9650f4b4276',	'',	'2017-07-13 22:38:55',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14154231932',	'+19513741928',	'+14154231932',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA32b4ac648319c40c0447a9650f4b4276',	'+14062509831',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb4dc21b584f730323fc1ccccf079e2b0',	0,	0,	'',	''),
(1201,	'CAeda3d10788f0b3b987638c592b3d9262',	'',	'2017-07-14 23:04:44',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13237365546',	'+19513741928',	'+13237365546',	NULL,	NULL,	NULL,	NULL,	'Los Angeles',	'CA',	'CA60b85e23b2463c3245a84fbf8cc0c77a',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1202,	'CA70e161256345af86dec82b512a6e3ef7',	'',	'2017-07-17 17:29:24',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13235534750',	'+19513741928',	'+13235534750',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAc966e09fc8fdb42a0e165092bff4c3c2',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1203,	'CA0afff7381a3034ee62087f564c5898c1',	'',	'2017-07-18 18:25:00',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95818',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15305549036',	'+19162627163',	'+15305549036',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CA0afff7381a3034ee62087f564c5898c1',	'+14062509831',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE467e6baaed1253052101ce9bfcc0fa00',	0,	0,	'',	''),
(1204,	'CAdf0821c26cf634a93fd451d09a2efbf5',	'',	'2017-07-18 21:19:48',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95818',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15305549036',	'+19162627163',	'+15305549036',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CA55f4d7cd7d429e3508aed71d71e9a254',	'+14062509831',	'voicemail',	15,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3316b401800923528053f3d924f86b4f',	0,	0,	'',	''),
(1205,	'CAb67fb5ce6eadc60f8f35698015246773',	'',	'2017-07-18 23:13:40',	'US',	'',	'CA',	'',	'US',	'92123',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16197386190',	'+19513741928',	'+16197386190',	NULL,	NULL,	NULL,	NULL,	'SAN DIEGO',	'CA',	'CAb67fb5ce6eadc60f8f35698015246773',	'+14062509831',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa019ec95ed0eb04336bd3bbf9fe88035',	0,	0,	'',	''),
(1206,	'CA555344f3d8a1f1da1e9b2e2e491135f7',	'',	'2017-07-19 17:33:21',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19496563748',	'+19513741928',	'+19496563748',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA555344f3d8a1f1da1e9b2e2e491135f7',	'+14062509831',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4adbe0b9d1c6a080aaf1169ab71cdf78',	0,	0,	'',	''),
(1207,	'CA52d73499b0a9e5357797c9beb4713c8b',	'',	'2017-07-20 21:38:22',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95818',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15305549036',	'+19162627163',	'+15305549036',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CA52d73499b0a9e5357797c9beb4713c8b',	'+14062509831',	'completed',	32,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE0076a84ad8e232c0f1c8a08c1ad94adb',	0,	0,	'',	''),
(1208,	'CAbfc56018784b82febe3e9ca6e56953c0',	'',	'2017-07-20 23:12:32',	'US',	'',	'CA',	'',	'US',	'98109',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12062079690',	'+19513741928',	'+12062079690',	NULL,	NULL,	NULL,	NULL,	'SEATTLE',	'WA',	'CA9b39ae4538feb317fa772c9dfdaff42b',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1209,	'CA0fb85ec6d3431fb289efeadf5b411eb8',	'',	'2017-07-21 18:27:25',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13235535364',	'+19513741928',	'+13235535364',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA0fb85ec6d3431fb289efeadf5b411eb8',	'+14062509831',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE5df58d7953782474b0a501ecbebbdb2e',	0,	0,	'',	''),
(1210,	'CA1ec0b7eed350418b703a5273a223863a',	'',	'2017-07-24 17:13:14',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19495654911',	'+19513741928',	'+19495654911',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA1ec0b7eed350418b703a5273a223863a',	'+14062509831',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE5f89fe12924a9a7d1aa11d384b7868c5',	0,	0,	'',	''),
(1211,	'CAfa4fcc4f583e2feceb7d06c5c9da0f42',	'',	'2017-07-25 22:16:16',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'80903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17196242298',	'+19162627163',	'+17196242298',	NULL,	NULL,	NULL,	NULL,	'COLORADO SPRINGS',	'CO',	'CAd31146352bf8d68d94159c76785c7d6a',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1212,	'CA1fc706fe025c16cd92ab77ad4cb0ada0',	'',	'2017-07-25 23:09:35',	'US',	'',	'CA',	'',	'US',	'92801',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19499433418',	'+19513741928',	'+19499433418',	NULL,	NULL,	NULL,	NULL,	'ANAHEIM',	'CA',	'CA1fc706fe025c16cd92ab77ad4cb0ada0',	'+14062509831',	'completed',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE935f24b2733c262a26df5eb251281453',	0,	0,	'',	''),
(1213,	'CA09fd325325d6d706472d29f66aa30b64',	'',	'2017-07-27 17:02:44',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14152663428',	'+19513741928',	'+14152663428',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA8542bb7b866b49f566ae70c1737bbcac',	'+14062509831',	'voicemail',	30,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE6234b34322b508c0e4fa3097af227393',	0,	0,	'',	''),
(1214,	'CAfee2fc5e2eb6bb5346c84a796803adb4',	'',	'2017-07-27 17:14:53',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19495372604',	'+19513741928',	'+19495372604',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAfee2fc5e2eb6bb5346c84a796803adb4',	'+14062509831',	'completed',	16,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE9c4716a85a00a60b1a1ff16589d33ccd',	0,	0,	'',	''),
(1215,	'CA1114255f38f9bcc0b69b0fb006c33ade',	'',	'2017-07-27 18:16:50',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'47940',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17657904022',	'+16612439350',	'+17657904022',	NULL,	NULL,	NULL,	NULL,	'DARLINGTON',	'IN',	'CA1114255f38f9bcc0b69b0fb006c33ade',	'+14062509831',	'completed',	15,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE9a62aedbdcf1421dcd63cbf653773d76',	0,	0,	'',	''),
(1216,	'CA8bb093f2f84f13d868822fce55f79faf',	'',	'2017-07-28 21:59:27',	'US',	'93308',	'CA',	'BAKERSFIELD',	'CA',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19059180678',	'+16612439350',	'+19059180678',	NULL,	NULL,	NULL,	NULL,	'RICHMOND HILL',	'ON',	'CA8bb093f2f84f13d868822fce55f79faf',	'+14062509831',	'completed',	36,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb2f1a678596017c8cabdea5ae1cb8441',	0,	0,	'',	''),
(1217,	'CAdb8e4d2cfab0bfc9be172bbccbb621ec',	'',	'2017-07-28 22:57:27',	'US',	'',	'CA',	'',	'US',	'98154',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12062038745',	'+19513741928',	'+12062038745',	NULL,	NULL,	NULL,	NULL,	'SEATTLE',	'WA',	'CAdb8e4d2cfab0bfc9be172bbccbb621ec',	'+14062509831',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3f7ace93139d5bbad783389f6f889004',	0,	0,	'',	''),
(1218,	'CAfc622dd3a2105f972b85e13153ef1ef1',	'',	'2017-07-31 18:34:34',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14152663428',	'+19513741928',	'+14152663428',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAfc622dd3a2105f972b85e13153ef1ef1',	'+14062509831',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd61e712cf09e353e193d2d9cb6250dfc',	0,	0,	'',	''),
(1219,	'CA3b3843ec7b3f30af65b540292af94a9f',	'',	'2017-08-01 18:38:54',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'47940',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17657904022',	'+16612439350',	'+17657904022',	NULL,	NULL,	NULL,	NULL,	'DARLINGTON',	'IN',	'CA3b3843ec7b3f30af65b540292af94a9f',	'+14062509831',	'completed',	17,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE7546be7b8a6371b88a206df9675f8989',	0,	0,	'',	''),
(1220,	'CA93f6885a3331b33fa6c10ed556e0f6ec',	'',	'2017-08-02 17:56:24',	'US',	'',	'CA',	'',	'US',	'90008',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13239978919',	'+19513741928',	'+13239978919',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA93f6885a3331b33fa6c10ed556e0f6ec',	'+14062509831',	'completed',	15,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE5dd81181311576faff97ebfb7089a18d',	0,	0,	'',	''),
(1221,	'CAbcf567c3f6db7fbf44d7c67e751101a8',	'',	'2017-08-07 17:24:32',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19495564519',	'+19513741928',	'+19495564519',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA8a0353a2790281617a4fc69adff47cb9',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1222,	'CA86e378be7d5375189b50d76779695c17',	'',	'2017-08-08 17:54:00',	'US',	'',	'CA',	'',	'US',	'92084',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17603308803',	'+19513741928',	'+17603308803',	NULL,	NULL,	NULL,	NULL,	'VISTA',	'CA',	'CA6b2f1d5de52ea66b0d9be2c1775a6561',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1223,	'CAdf9a82c2fc07129f53087d145a2a8ce6',	'',	'2017-08-09 18:05:53',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+16612439350',	'+19317400131',	NULL,	NULL,	NULL,	NULL,	'',	'TN',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1224,	'CA9bcb09016d903b5a8197ef780af23ab6',	'',	'2017-08-09 20:46:03',	'US',	'',	'CA',	'',	'US',	'92084',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17603308803',	'+19513741928',	'+17603308803',	NULL,	NULL,	NULL,	NULL,	'VISTA',	'CA',	'CA9bcb09016d903b5a8197ef780af23ab6',	'+14062509831',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE795ab8341ce9a3c98f8d5b0ca0b095cb',	0,	0,	'',	''),
(1225,	'CA090278f54899542c11e63f2825931800',	'',	'2017-08-09 23:56:49',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14063002236',	'+19722036640',	'+14063002236',	NULL,	NULL,	NULL,	NULL,	'',	'MT',	'CA090278f54899542c11e63f2825931800',	'+14062509831',	'completed',	12,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE6e29564f427c0175402fda32d8289875',	0,	0,	'',	''),
(1226,	'CA153cdb614bd1052e2348890c88c90a1f',	'',	'2017-08-09 23:57:15',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14063002236',	'+19722036640',	'+14063002236',	NULL,	NULL,	NULL,	NULL,	'',	'MT',	'CA153cdb614bd1052e2348890c88c90a1f',	'+14062509831',	'completed',	16,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE0b65e164139b3903ea556b60b3d33122',	0,	0,	'',	''),
(1227,	'CAafab9090cfad208543fc3468672d7a7b',	'',	'2017-08-10 00:33:47',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'59903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14062509831',	'+19722036640',	'+14062509831',	NULL,	NULL,	NULL,	NULL,	'KALISPELL',	'MT',	'CAafab9090cfad208543fc3468672d7a7b',	'+12143156085',	'completed',	20,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE7313271ca6a0fe2eadefc4778765a8d6',	0,	0,	'',	''),
(1228,	'CA666640f9066bc5e4fab4a741aff91fb1',	'',	'2017-08-10 00:34:22',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'59903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14062509831',	'+19722036640',	'+14062509831',	NULL,	NULL,	NULL,	NULL,	'KALISPELL',	'MT',	'CA666640f9066bc5e4fab4a741aff91fb1',	'+12143156085',	'completed',	484,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE6d487094939854c64ff56d3104135b58',	0,	0,	'',	''),
(1229,	'CA44f0d391a253d6a5117460688e3eb774',	'',	'2017-08-11 16:32:56',	'US',	'',	'CA',	'',	'US',	'92868',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17144972165',	'+19513741928',	'+17144972165',	NULL,	NULL,	NULL,	NULL,	'ORANGE',	'CA',	'CAfbe30a5694fb1e2a6ecd72e272bd6bfc',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1230,	'CA8f7aa16e0aec249b6eb4c1b547595967',	'',	'2017-08-11 17:25:07',	'US',	'95822',	'CA',	'SACRAMENTO',	'CA',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19059183089',	'+19162627163',	'+19059183089',	NULL,	NULL,	NULL,	NULL,	'RICHMOND HILL',	'ON',	'CA8f7aa16e0aec249b6eb4c1b547595967',	'+14062509831',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE845e702f787eff1a82892b44bc46cef3',	0,	0,	'',	''),
(1231,	'CA1b9001926744b68205772233fac82b20',	'',	'2017-08-13 13:22:22',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'94403',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16502886531',	'+19162627163',	'+16502886531',	NULL,	NULL,	NULL,	NULL,	'SAN MATEO',	'CA',	'CA1aae36c4b324e8aafe5972132c0f91de',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1232,	'CAc67f6b21434c73e20bf93e503795a0b8',	'',	'2017-08-14 16:23:27',	'US',	'',	'CA',	'',	'US',	'94937',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14154814952',	'+19513741928',	'+14154814952',	NULL,	NULL,	NULL,	NULL,	'INVERNESS',	'CA',	'CAc67f6b21434c73e20bf93e503795a0b8',	'+14062509831',	'completed',	17,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REac6781d430a8b6c07929de52b4505464',	0,	0,	'',	''),
(1233,	'CAa8da2c5173de85209dac351132920e51',	'',	'2017-08-15 22:43:40',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19495654634',	'+19513741928',	'+19495654634',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAa8da2c5173de85209dac351132920e51',	'+14062509831',	'completed',	17,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa222ee3ae112d2e5925c8b2ee8fb32e3',	0,	0,	'',	''),
(1234,	'CA4845d5637a5a2b08e860d6ab3bf77748',	'',	'2017-08-16 23:11:39',	'US',	'',	'CA',	'',	'US',	'98154',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12062081044',	'+19513741928',	'+12062081044',	NULL,	NULL,	NULL,	NULL,	'SEATTLE',	'WA',	'CA4845d5637a5a2b08e860d6ab3bf77748',	'+14062509831',	'completed',	18,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REafe67b7ca13056b2720d6fb9ebed675e',	0,	0,	'',	''),
(1235,	'CAd343bfe797b7af575404616f70fd2fa3',	'',	'2017-08-17 21:40:11',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'98074',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14256573881',	'+14252338984',	'+14256573881',	NULL,	NULL,	NULL,	NULL,	'REDMOND',	'WA',	'CAd343bfe797b7af575404616f70fd2fa3',	'+14062509831',	'completed',	18,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE8dc433406640edb996a95a2c60a69b83',	0,	0,	'',	''),
(1236,	'CA89300ef75be0d9912c7c238785cf9573',	'',	'2017-08-21 16:40:44',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19494306778',	'+19513741928',	'+19494306778',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAac3f8929deebc7c3b349e7813df3d830',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1237,	'CA44e979965fa37e9e4db2e56333069ea2',	'',	'2017-08-22 17:27:09',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14803865536',	'+19162627163',	'+14803865536',	NULL,	NULL,	NULL,	NULL,	'',	'AZ',	'CA0281a725879d0bfe4350086a3baea4e2',	'+14062509831',	'voicemail',	18,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REad48a96da2ab285f0e309c8d7f5a7956',	0,	0,	'',	''),
(1238,	'CA81fa4be619be9b8653f93acfb09844e7',	'',	'2017-08-22 22:19:06',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95747',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19165800018',	'+19162627163',	'+19165800018',	NULL,	NULL,	NULL,	NULL,	'ROSEVILLE',	'CA',	'CAa5cf45b60d70f7788938e30b1d0a9a90',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1239,	'CA9c9151f04ae0a71c6ad140e40ffdc9d4',	'',	'2017-08-23 16:51:08',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'98154',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12063472220',	'+14252338984',	'+12063472220',	NULL,	NULL,	NULL,	NULL,	'SEATTLE',	'WA',	'CA9c9151f04ae0a71c6ad140e40ffdc9d4',	'+14062509831',	'completed',	2,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE86559af435f57a6cc332fb56f7503bf3',	0,	0,	'',	''),
(1240,	'CA15b0f220d264c8543bd1283efce82671',	'',	'2017-08-23 18:01:08',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18446744455',	'+14252338984',	'+18446744455',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA6b3b132d8d2b29ac52161a4d6e3c107d',	'+14062509831',	'voicemail',	25,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf1f7182ea1c791c2214ef21afed31f1f',	0,	0,	'',	''),
(1241,	'CA4d0219b4757ea5b44e851768e053727c',	'',	'2017-08-24 16:17:29',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+14252338984',	'+15313018042',	NULL,	NULL,	NULL,	NULL,	'',	'NE',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1242,	'CA1432d01526bb256beba2a94ab5aa18f0',	'',	'2017-08-24 20:11:41',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14803865536',	'+19162627163',	'+14803865536',	NULL,	NULL,	NULL,	NULL,	'',	'AZ',	'CA1432d01526bb256beba2a94ab5aa18f0',	'+14062509831',	'completed',	51,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb78c14af411327b7bfd889f6e4600129',	0,	0,	'',	''),
(1243,	'CA92354f8c753ee18d8317d800f9a262f0',	'',	'2017-08-28 20:27:58',	'US',	'83001',	'WY',	'JACKSON',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+13072014710',	'+13127237971',	NULL,	NULL,	NULL,	NULL,	'',	'IL',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1244,	'CA6c4762174b3e9acd8ba214e60ec0dba2',	'',	'2017-08-28 20:28:41',	'US',	'83001',	'WY',	'JACKSON',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+13072014710',	'+13127237971',	NULL,	NULL,	NULL,	NULL,	'',	'IL',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1245,	'CA831b0296fc16d0b851c5981af2df4014',	'',	'2017-08-28 20:41:08',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95626',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19166557845',	'+19162627163',	'+19166557845',	NULL,	NULL,	NULL,	NULL,	'PLEASANT GROVE',	'CA',	'CA831b0296fc16d0b851c5981af2df4014',	'+14062509831',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REfee2a5a778650185c41dd2708e773e79',	0,	0,	'',	''),
(1246,	'CA292f81563209b1e228deea5ea01ef198',	'',	'2017-08-29 21:35:22',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13852491294',	'+19513741928',	'+13852491294',	NULL,	NULL,	NULL,	NULL,	'SALT LAKE CITY',	'UT',	'CA292f81563209b1e228deea5ea01ef198',	'+14062509831',	'completed',	1,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe71626478310cfe97b0c23031e1f0238',	0,	0,	'',	''),
(1247,	'CAb9c40cd08caa99bf7d9f6f0890d147c5',	'',	'2017-08-30 20:37:45',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14803865536',	'+19162627163',	'+14803865536',	NULL,	NULL,	NULL,	NULL,	'',	'AZ',	'CAb9c40cd08caa99bf7d9f6f0890d147c5',	'+14062509831',	'completed',	21,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE2895fdad806542bb8ecda8593bec2eae',	0,	0,	'',	''),
(1248,	'CA364a25160f44474a121cdd4a015b83e2',	'',	'2017-08-31 21:53:28',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14803865536',	'+19162627163',	'+14803865536',	NULL,	NULL,	NULL,	NULL,	'',	'AZ',	'CA364a25160f44474a121cdd4a015b83e2',	'+14062509831',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REea2e4d9efc1e8266fab4fddfd4b3f886',	0,	0,	'',	''),
(1249,	'CA1d67c085ce5588535cc76fb553a39960',	'',	'2017-08-31 21:55:22',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19514210023',	'+19513741928',	'+19514210023',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAc315a22d3f6f2da7dcd53f649d7b62da',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1250,	'CAb44c380d5e4f960d023649a69d5a68be',	'',	'2017-08-31 23:14:42',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'92123',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16195050000',	'+19162627163',	'+16195050000',	NULL,	NULL,	NULL,	NULL,	'SAN DIEGO',	'CA',	'CAb44c380d5e4f960d023649a69d5a68be',	'+14062509831',	'completed',	22,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3cc256487abf6ae80fccf16c2222a739',	0,	0,	'',	''),
(1251,	'CA56063f6af3495306bb914e7a27461b28',	'',	'2017-09-01 00:13:34',	'US',	'',	'CA',	'',	'US',	'90017',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14246722194',	'+19513741928',	'+14246722194',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA03262633569c6b4e8b9c0f63b5ccaa52',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1252,	'CA41b2eb7072e888db78da4883b904b154',	'',	'2017-09-01 16:17:33',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19495654574',	'+19513741928',	'+19495654574',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA41b2eb7072e888db78da4883b904b154',	'+14062509831',	'completed',	17,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE69ab57bab3fbfb23baf99950469d8907',	0,	0,	'',	''),
(1253,	'CAfadd647ee1918cad6fcbbfb941e89751',	'',	'2017-09-02 23:31:44',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'56425',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12183160029',	'+19722036640',	'+12183160029',	NULL,	NULL,	NULL,	NULL,	'BRAINERD',	'MN',	'CAfadd647ee1918cad6fcbbfb941e89751',	'+19728157325',	'completed',	43,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REbc8b2b4b66be4f32c3079abe1f07eb3e',	0,	0,	'',	''),
(1254,	'CAa2e4aa932ba906c1b4f6f787b85e0055',	'',	'2017-09-02 23:33:21',	'US',	'75074',	'TX',	'PLANO',	'US',	'56425',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12183160029',	'+19727377035',	'+12183160029',	NULL,	NULL,	NULL,	NULL,	'BRAINERD',	'MN',	'CAa2e4aa932ba906c1b4f6f787b85e0055',	'+19729894711',	'completed',	40,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE0109f5f04c2e4e6454fbd63bcad7ae14',	0,	0,	'',	''),
(1255,	'CAf20455026f79b7a926db8866ab2eea64',	'',	'2017-09-03 19:48:26',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95758',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19164781992',	'+19162627163',	'+19164781992',	NULL,	NULL,	NULL,	NULL,	'ELK GROVE',	'CA',	'CAf20455026f79b7a926db8866ab2eea64',	'+14062509831',	'completed',	17,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE69f5921196f1e6680786a981fdb584de',	0,	0,	'',	''),
(1256,	'CAbb0a12ee89fe7e701ed4336e43dca13a',	'',	'2017-09-05 03:49:06',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18007574791',	'+19162627163',	'+18007574791',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CAbb0a12ee89fe7e701ed4336e43dca13a',	'+14062509831',	'completed',	70,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE09526204cde4963605aef8b36a367a21',	0,	0,	'',	''),
(1257,	'CA198ff1364a2d347f4a850e35af72301f',	'',	'2017-09-05 16:42:38',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14699013271',	'+19722036640',	'+14699013271',	NULL,	NULL,	NULL,	NULL,	'',	'TX',	'CAa8f3c070ad3ccbaf46b4f22eae19bd4e',	'+19728157325',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1258,	'CAa86f045d818a050cb2787f03924313ce',	'',	'2017-09-06 15:15:56',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95814',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19168881884',	'+19162627163',	'+19168881884',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CAe9a71ce211e8f3571b832671a261881a',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1259,	'CA35aa9cf9823f753cb41adc6b55e8285c',	'',	'2017-09-06 15:49:13',	'US',	'',	'CA',	'',	'US',	'92123',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16195050000',	'+19513741928',	'+16195050000',	NULL,	NULL,	NULL,	NULL,	'SAN DIEGO',	'CA',	'CA35aa9cf9823f753cb41adc6b55e8285c',	'+14062509831',	'completed',	22,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc23f62694ae9e5bb96f468ccdf5377dd',	0,	0,	'',	''),
(1260,	'CA4093dcb352e2bd3710a7bb88f51d1cc9',	'',	'2017-09-06 20:38:43',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'91411',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18184846351',	'+16612439350',	'+18184846351',	NULL,	NULL,	NULL,	NULL,	'SHERMAN OAKS',	'CA',	'CA90b4649ff1ff9bd862b288d185452e3b',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1261,	'CA2559ed01c02cb0259a7b4a3b1661e612',	'',	'2017-09-11 03:12:52',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18008609592',	'+19162627163',	'+18008609592',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA2559ed01c02cb0259a7b4a3b1661e612',	'+14062509831',	'completed',	70,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc689448be6897542b5cfcc0c01549977',	0,	0,	'',	''),
(1262,	'CA64f1920ca635d418fd609d1838c57d6b',	'',	'2017-09-11 19:31:57',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18002528140',	'+19722036640',	'+18002528140',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA64f1920ca635d418fd609d1838c57d6b',	'+19728157325',	'completed',	85,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4a39be9d16b7b3e38f91abb5af3a4b16',	0,	0,	'',	''),
(1263,	'CAc9ff6f3712ed4ac4ad508065bcbd0ed4',	'',	'2017-09-11 19:34:24',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75062',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19728157325',	'+19722036640',	'+19728157325',	NULL,	NULL,	NULL,	NULL,	'IRVING',	'TX',	'CAc9ff6f3712ed4ac4ad508065bcbd0ed4',	'+19728157325',	'completed',	28,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd872200dbd672eb0a8a5b0c09cbb2d71',	0,	0,	'',	''),
(1264,	'CA2cd504b37ad2c0ce20d71fab3130620c',	'',	'2017-09-11 22:41:50',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75062',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19728157325',	'+19722036640',	'+19728157325',	NULL,	NULL,	NULL,	NULL,	'IRVING',	'TX',	'CA2cd504b37ad2c0ce20d71fab3130620c',	'+19728157325',	'completed',	12,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE726808cc514eb0cf5b6ee514b789a859',	0,	0,	'',	''),
(1265,	'CA0e372c1ded4c340bd8789e8d7ab0e212',	'',	'2017-09-12 17:56:01',	'US',	'98104',	'WA',	'TUKWILA',	'CA',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19059183107',	'+14252338984',	'+19059183107',	NULL,	NULL,	NULL,	NULL,	'RICHMOND HILL',	'ON',	'CA3284ecf8f00802fa8807eb19c6001d17',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1266,	'CA2d402ab48d917efa811afcf3a48fb571',	'',	'2017-09-12 23:21:40',	'US',	'83001',	'WY',	'JACKSON',	'US',	'83706',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+13072014710',	'+12082847718',	NULL,	NULL,	NULL,	NULL,	'BOISE',	'ID',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1267,	'CAd20b749e59cfbd00c7ddcd1cf8b6167f',	'',	'2017-09-13 13:38:50',	'US',	'',	'CA',	'',	'US',	'35242',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12059776406',	'+19513741928',	'+12059776406',	NULL,	NULL,	NULL,	NULL,	'BIRMINGHAM',	'AL',	'CAd20b749e59cfbd00c7ddcd1cf8b6167f',	'+14062509831',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE63c15e878ae462da01d3f872e22b1e8f',	0,	0,	'',	''),
(1268,	'CA6b3a19f2a0a59eb790560a978a970d9b',	'',	'2017-09-13 16:58:51',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18002528140',	'+19722036640',	'+18002528140',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA6b3a19f2a0a59eb790560a978a970d9b',	'+19728157325',	'completed',	91,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE2abc6eabb65790e193e07ea18e6c850a',	0,	0,	'',	''),
(1269,	'CAc6be530f96dd1cb41bd4def859525de5',	'',	'2017-09-18 14:31:47',	'US',	'75202',	'TX',	'DALLAS',	'US',	'75230',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12148762606',	'+12149221949',	'+12148762606',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CAc6be530f96dd1cb41bd4def859525de5',	'+12183160029',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1270,	'CA415799eed68b143a7da5bf4976bb595b',	'',	'2017-09-18 21:32:42',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'85021',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14802075654',	'+14252338984',	'+14802075654',	NULL,	NULL,	NULL,	NULL,	'PHOENIX',	'AZ',	'CAe91bbf87396217cd9de62b572036801d',	'+14062509831',	'voicemail',	27,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE29face6fb1850a65a0c8d95d6d011091',	0,	0,	'',	''),
(1271,	'CA366024adafccedb4eab6f37434942754',	'',	'2017-09-19 17:35:17',	'US',	'75202',	'TX',	'DALLAS',	'US',	'75230',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12148761153',	'+12149221949',	'+12148761153',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CA366024adafccedb4eab6f37434942754',	'+12183160029',	'completed',	6,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE059f9cf61ebdcdde287529de7ab133d5',	0,	0,	'',	''),
(1272,	'CA273cf3a572dc6f8531f7eaf1b8f7441c',	'',	'2017-09-20 16:24:30',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13239225733',	'+19513741928',	'+13239225733',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA8a2ac449539f7f32385385f5c810d96b',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1273,	'CAa907e6015de4fe965e2308fb00b2ea9e',	'',	'2017-09-20 19:05:32',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75225',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19722036640',	'+12146836182',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1274,	'CA5889d8101d05aba132a075e97ed3108f',	'',	'2017-09-20 22:56:41',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'92398',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17602578223',	'+16612439350',	'+17602578223',	NULL,	NULL,	NULL,	NULL,	'NEWBERRY SPRINGS',	'CA',	'CAf0afa8fe896c500cb94b9b7432190fa0',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1275,	'CA0f4944b24fa0db8211489132c6f6d7dc',	'',	'2017-09-21 16:31:11',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14156500629',	'+19513741928',	'+14156500629',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA0f4944b24fa0db8211489132c6f6d7dc',	'+14062509831',	'completed',	17,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc114bf4e3e834e26b3d743055a6e16f9',	0,	0,	'',	''),
(1276,	'CA4e6d0d2c5980933f96ddf21d5f39ad6e',	'',	'2017-09-21 23:00:02',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19495654740',	'+19513741928',	'+19495654740',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA4e6d0d2c5980933f96ddf21d5f39ad6e',	'+14062509831',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REcf9580cdaf6e9ae5996a87e1d317fa5d',	0,	0,	'',	''),
(1277,	'CA4ff891b32020133f5f193a33e99e10a8',	'',	'2017-09-22 18:24:09',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'76119',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12144170593',	'+19722036640',	'+12144170593',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CAadd4fcce6c858182440268797bb90fb3',	'+19728157325',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1278,	'CAa7abb00d1a95156a35abae470f08c941',	'',	'2017-09-22 20:04:24',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16692207896',	'+19513741928',	'+16692207896',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAa7abb00d1a95156a35abae470f08c941',	'+14062509831',	'completed',	12,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REde995fddad1bde219e8e2d905546cdbd',	0,	0,	'',	''),
(1279,	'CA0c15815d689cfd3bfeb766d65b3912db',	'',	'2017-09-22 22:26:24',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'80401',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13039638772',	'+16612439350',	'+13039638772',	NULL,	NULL,	NULL,	NULL,	'DENVER',	'CO',	'CAbaeaf5e2fa83853ae466b01a1e21e5b4',	'+14062509831',	'voicemail',	27,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE54ac45526a2f3186554c15f6e63007c7',	0,	0,	'',	''),
(1280,	'CA485343f32787b01593d1a8e96064850c',	'',	'2017-09-23 16:33:05',	'US',	'75244',	'TX',	'DALLAS',	'US',	'20388',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12024558888',	'+19729190409',	'+12024558888',	NULL,	NULL,	NULL,	NULL,	'WASHINGTON',	'DC',	'CA485343f32787b01593d1a8e96064850c',	'+19728157325',	'completed',	23,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe95020dd0713e7a44d4d70cb6c8c1a67',	0,	0,	'',	''),
(1281,	'CAf3adf606a0d9b509ae0060adc8a0e6e7',	'',	'2017-09-25 17:54:14',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19495564356',	'+19513741928',	'+19495564356',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAf3adf606a0d9b509ae0060adc8a0e6e7',	'+14062509831',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE899cb77e46c36bdc65668685aa5d04d7',	0,	0,	'',	''),
(1282,	'CAc1378668fbb0fe9bed7dabdb4592feae',	'',	'2017-09-25 20:52:10',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'92004',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17608579402',	'+16612439350',	'+17608579402',	NULL,	NULL,	NULL,	NULL,	'RANCHITA',	'CA',	'CA5f970f0c874d29aae26e09412487edfd',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1283,	'CA36afced34943183e37b3375bba40343a',	'',	'2017-09-26 21:36:04',	'US',	'',	'CA',	'',	'US',	'93555',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17608827090',	'+19513741928',	'+17608827090',	NULL,	NULL,	NULL,	NULL,	'RIDGECREST',	'CA',	'CA36afced34943183e37b3375bba40343a',	'+14062509831',	'completed',	12,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE0a08219f290f7029f631fcd7fbf93ec2',	0,	0,	'',	''),
(1284,	'CA8db2df78c6fbfd201233e30479f4ead0',	'',	'2017-09-26 23:10:22',	'US',	'',	'CA',	'',	'US',	'90802',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19493810831',	'+19513741928',	'+19493810831',	NULL,	NULL,	NULL,	NULL,	'LONG BEACH',	'CA',	'CA8db2df78c6fbfd201233e30479f4ead0',	'+14062509831',	'completed',	3,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE6b549bc9871886a11fd871ee48bdd7b7',	0,	0,	'',	''),
(1285,	'CAe931c947b4b0b920d6a6c275f69ecc40',	'',	'2017-09-28 02:20:40',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18009137959',	'+19162627163',	'+18009137959',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CAe931c947b4b0b920d6a6c275f69ecc40',	'+14062509831',	'completed',	70,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE7ab79daa28fc03e2a2b73e11c6a8df5c',	0,	0,	'',	''),
(1286,	'CAb0904d17b01241e706848b65e6ebf8a2',	'',	'2017-10-03 18:23:03',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'98074',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14256575365',	'+14252338984',	'+14256575365',	NULL,	NULL,	NULL,	NULL,	'REDMOND',	'WA',	'CAb0904d17b01241e706848b65e6ebf8a2',	'+14062509831',	'completed',	29,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE1ed2b3d67151ad8b4200607f754f87d4',	0,	0,	'',	''),
(1287,	'CA3c9bb415ecdb73f36223ffc3875409e7',	'',	'2017-10-03 23:04:33',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19495367496',	'+19513741928',	'+19495367496',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA3c9bb415ecdb73f36223ffc3875409e7',	'+14062509831',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE299c0bf6fbd6a3788b015ca4c7c3471e',	0,	0,	'',	''),
(1288,	'CAdd6d784f25a59e3f9b51a0d410ffe474',	'',	'2017-10-04 19:33:33',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'77414',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12818143165',	'+19162627163',	'+12818143165',	NULL,	NULL,	NULL,	NULL,	'HOUSTON',	'TX',	'CA922335a8b1c3852831ddf3797a93ddea',	'+14062509831',	'voicemail',	61,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE734b4f3e0dff7093f5609b388fe26ff2',	0,	0,	'',	''),
(1289,	'CA905c6a5a78401d4a39f15e93e51088db',	'',	'2017-10-05 19:00:03',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14692717878',	'+19722036640',	'+14692717878',	NULL,	NULL,	NULL,	NULL,	'',	'TX',	'CA905c6a5a78401d4a39f15e93e51088db',	'+19728157325',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE6cce82a40ee0734a0632cc55a95f9d2a',	0,	0,	'',	''),
(1290,	'CA0eb6f1173a1bc7d7d99d61d905064f7f',	'',	'2017-10-05 20:47:09',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'94903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14152267855',	'+19162627163',	'+14152267855',	NULL,	NULL,	NULL,	NULL,	'SAN RAFAEL',	'CA',	'CAabb5fa41d32d2c57125e0cedfc4099d4',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1291,	'CAb37294499b0abbf0bcf20e77267d904a',	'',	'2017-10-06 16:27:29',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'93535',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16617275033',	'+16612439350',	'+16617275033',	NULL,	NULL,	NULL,	NULL,	'HI VISTA',	'CA',	'CAb37294499b0abbf0bcf20e77267d904a',	'+14062509831',	'completed',	18,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REdcda4baa62ab02d4c15e3d635fb5bd7b',	0,	0,	'',	''),
(1292,	'CA85043c65bda684831a4aa9973b2a5b66',	'',	'2017-10-09 19:42:39',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19132762537',	'+19162627163',	'+19132762537',	NULL,	NULL,	NULL,	NULL,	'',	'KS',	'CA85043c65bda684831a4aa9973b2a5b66',	'+14062509831',	'completed',	41,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REfead856da1b24541a1aa4110e0173525',	0,	0,	'',	''),
(1293,	'CA82bcfc91ed9cfb8fa723f737b3ac827b',	'',	'2017-10-09 21:48:54',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'92124',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16195167886',	'+19162627163',	'+16195167886',	NULL,	NULL,	NULL,	NULL,	'SAN DIEGO',	'CA',	'CA82bcfc91ed9cfb8fa723f737b3ac827b',	'+14062509831',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REbda73dd3de8a73247624fd8401fc5047',	0,	0,	'',	''),
(1294,	'CAde20147885eeb7eb6a736ea33d3197ad',	'',	'2017-10-10 04:34:43',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18002471353',	'+19162627163',	'+18002471353',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CAde20147885eeb7eb6a736ea33d3197ad',	'+14062509831',	'completed',	70,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE44cda9a3fd47afb641e842e4f19e382e',	0,	0,	'',	''),
(1295,	'CA31ae182fc3b2deb51e03ca2839f328c0',	'',	'2017-10-10 22:27:01',	'US',	'83001',	'WY',	'JACKSON',	'US',	'82007',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+13072014710',	'+13072219675',	NULL,	NULL,	NULL,	NULL,	'CHEYENNE',	'WY',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1296,	'CAc985618752ea11fa149ae1341fd2a5fb',	'',	'2017-10-11 22:20:29',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'98337',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13607120329',	'+14252338984',	'+13607120329',	NULL,	NULL,	NULL,	NULL,	'BREMERTON',	'WA',	'CAc985618752ea11fa149ae1341fd2a5fb',	'+14062509831',	'no-answer',	5,	NULL,	0,	0,	'',	''),
(1297,	'CA6eab6a195f5f316f3bda9928fe681533',	'',	'2017-10-12 20:11:05',	'US',	'',	'CA',	'',	'US',	'94402',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16502787000',	'+19513741928',	'+16502787000',	NULL,	NULL,	NULL,	NULL,	'SAN MATEO',	'CA',	'CA6eab6a195f5f316f3bda9928fe681533',	'+14062509831',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REfcf04c0c7b09a34a467b301dce1f3626',	0,	0,	'',	''),
(1298,	'CAbe24c2c55ac9be789ac526ad372a81a6',	'',	'2017-10-12 21:07:00',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'98337',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13607120329',	'+14252338984',	'+13607120329',	NULL,	NULL,	NULL,	NULL,	'BREMERTON',	'WA',	'CAbe24c2c55ac9be789ac526ad372a81a6',	'+14062509831',	'completed',	21,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REba3604ec382977085943ac9ef69af88d',	0,	0,	'',	''),
(1299,	'CAa64a7f787fb5e86854f7b4ae2db53b3e',	'',	'2017-10-19 15:38:39',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19162627163',	'+18622291931',	NULL,	NULL,	NULL,	NULL,	'',	'NJ',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1300,	'CA8d7be558c806db2e22fa5bb42e0588c5',	'',	'2017-10-19 18:30:41',	'US',	'83001',	'WY',	'JACKSON',	'US',	'31705',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+13072014710',	'+12293384908',	NULL,	NULL,	NULL,	NULL,	'ALBANY',	'GA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1301,	'CA304869b07125106357bb3a6ce795a1e1',	'',	'2017-10-23 18:14:01',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75067',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12145298364',	'+19722036640',	'+12145298364',	NULL,	NULL,	NULL,	NULL,	'IRVING',	'TX',	'CA304869b07125106357bb3a6ce795a1e1',	'+19728157325',	'completed',	12,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REff44437d707526b990c4bbcc37517fb9',	0,	0,	'',	''),
(1302,	'CA53f550af3fb34c14709b9729495d49eb',	'',	'2017-10-23 18:16:08',	'US',	'75024',	'TX',	'PLANO',	'US',	'75067',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12145298364',	'+19728051470',	'+12145298364',	NULL,	NULL,	NULL,	NULL,	'IRVING',	'TX',	'CA53f550af3fb34c14709b9729495d49eb',	'+12146824990',	'completed',	507,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE08617c418576fcf9175cf56b8784926b',	0,	0,	'',	''),
(1303,	'CAc57aa67d6e70aa590be1ee4992c48b56',	'',	'2017-10-23 22:52:35',	'US',	'',	'CA',	'',	'US',	'33190',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19513741928',	'+17863457954',	NULL,	NULL,	NULL,	NULL,	'PERRINE',	'FL',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1304,	'CA501908b9e1482f1021e674afb2b51711',	'',	'2017-10-24 18:31:01',	'US',	'',	'CA',	'',	'US',	'33190',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17863457954',	'+19513741928',	'+17863457954',	NULL,	NULL,	NULL,	NULL,	'PERRINE',	'FL',	'CAfb3854cb30271fc806e96ac8bc6a4b97',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1305,	'CAfb2c36e66b4b9bd6cfb2d3777933a8bb',	'',	'2017-10-25 00:05:27',	'',	'',	'',	'',	'',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+13072014710',	'+120878161232',	NULL,	NULL,	NULL,	NULL,	'',	'',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1306,	'CA5fb6d8d4c5f8afd228ca059c8b7f896f',	'',	'2017-10-25 17:08:30',	'US',	'75024',	'TX',	'PLANO',	'US',	'75226',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12146824990',	'+19728051470',	'+12146824990',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CA5fb6d8d4c5f8afd228ca059c8b7f896f',	'+12146824990',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1307,	'CAa0245fa89363f5343929bac987bb7da7',	'',	'2017-10-25 17:08:50',	'US',	'75024',	'TX',	'PLANO',	'US',	'75226',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12146824990',	'+19728051470',	'+12146824990',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CAa0245fa89363f5343929bac987bb7da7',	'+12146824990',	'completed',	38,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc262fff62c687b69d78744117f723ff4',	0,	0,	'',	''),
(1308,	'CA4d8470b8aace5f9b67dea37322f4396f',	'',	'2017-10-25 17:09:46',	'US',	'75024',	'TX',	'PLANO',	'US',	'75226',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12146824990',	'+19728051470',	'+12146824990',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CA4d8470b8aace5f9b67dea37322f4396f',	'+12146824990',	'completed',	27,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE0644046e79bb8e4aa2f266713b9e667c',	0,	0,	'',	''),
(1309,	'CA062278f4aefd9381dcca701e2d0feecd',	'',	'2017-10-25 18:55:19',	'US',	'',	'CA',	'',	'US',	'33190',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19513741928',	'+17863457954',	NULL,	NULL,	NULL,	NULL,	'PERRINE',	'FL',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1310,	'CA5827d966abd862a183bf2a95fd83b440',	'',	'2017-10-26 00:21:33',	'US',	'75202',	'TX',	'DALLAS',	'US',	'59903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14062509831',	'+12149221949',	'+14062509831',	NULL,	NULL,	NULL,	NULL,	'KALISPELL',	'MT',	'CA5827d966abd862a183bf2a95fd83b440',	'+12183160029',	'completed',	26,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE0a8b0fe0d4dda93507d082360b80fba5',	0,	0,	'',	''),
(1311,	'CA33d20647426daa27abdac666004d4abd',	'',	'2017-10-26 00:22:26',	'US',	'75202',	'TX',	'DALLAS',	'US',	'59903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14062509831',	'+12149221949',	'+14062509831',	NULL,	NULL,	NULL,	NULL,	'KALISPELL',	'MT',	'CA33d20647426daa27abdac666004d4abd',	'+12183160029',	'completed',	143,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE5f0a4534c18fdc437d478e547108eaae',	0,	0,	'',	''),
(1312,	'CA470687f95f391904b9a01dddb086c22e',	'',	'2017-10-26 20:26:14',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'95827',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19164142961',	'+16612439350',	'+19164142961',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CA470687f95f391904b9a01dddb086c22e',	'+14062509831',	'completed',	67,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE847b8d69d58691abc6948ad8bef9908f',	0,	0,	'',	''),
(1313,	'CAc7974e3f40eec373feacb7eef6fdc04a',	'',	'2017-10-27 21:13:49',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13852491292',	'+19513741928',	'+13852491292',	NULL,	NULL,	NULL,	NULL,	'SALT LAKE CITY',	'UT',	'CAc7974e3f40eec373feacb7eef6fdc04a',	'+14062509831',	'completed',	4,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb41ee088297c1aa14d44f118acd089a6',	0,	0,	'',	''),
(1314,	'CAa8d30b4d8b5e9807864b8587ee2e50c6',	'',	'2017-10-29 22:41:22',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19722036640',	'+14063002236',	NULL,	NULL,	NULL,	NULL,	'',	'MT',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1315,	'CAee633d3c277be180df4a1034642bcf73',	'',	'2017-10-30 20:04:30',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95677',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19166750195',	'+19162627163',	'+19166750195',	NULL,	NULL,	NULL,	NULL,	'ROSEVILLE',	'CA',	'CAee633d3c277be180df4a1034642bcf73',	'+14062509831',	'completed',	28,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb7c7281e21f922ead7f5e32a464a643e',	0,	0,	'',	''),
(1316,	'CA24d71463fd81f27bb5575c2eb5f775c4',	'',	'2017-10-31 17:53:36',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'90712',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15625665050',	'+16612439350',	'+15625665050',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CAbbcbecf83fa2b00f36f7800d835b4507',	'+14062509831',	'voicemail',	39,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf05c50ed3793cea1ebd94e5c651dd5b4',	0,	0,	'',	''),
(1317,	'CA3383fe02e63acec8f30adac0898b2b44',	'',	'2017-11-01 19:16:49',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13236730720',	'+19162627163',	'+13236730720',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA3383fe02e63acec8f30adac0898b2b44',	'+14062509831',	'completed',	37,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE9dd51de4802658b1577995f22faea794',	0,	0,	'',	''),
(1318,	'CAb8ad792a892f7b1775a05da03f06d2c9',	'',	'2017-11-01 19:31:48',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13236730720',	'+16612439350',	'+13236730720',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAb8ad792a892f7b1775a05da03f06d2c9',	'+14062509831',	'completed',	55,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4166d4912668ec3ee01609239a36868f',	0,	0,	'',	''),
(1319,	'CA6f12a74d0e07b6b951446bafa6b7fabd',	'',	'2017-11-01 19:35:48',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13236730720',	'+19513741928',	'+13236730720',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA6f12a74d0e07b6b951446bafa6b7fabd',	'+14062509831',	'completed',	57,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4f4fd13539de633d9f05dc30f50e455c',	0,	0,	'',	''),
(1320,	'CAd6ed8f1ee6df636c8f27761c81d40071',	'',	'2017-11-01 21:53:52',	'US',	'',	'CA',	'',	'US',	'92084',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17603308998',	'+19513741928',	'+17603308998',	NULL,	NULL,	NULL,	NULL,	'VISTA',	'CA',	'CA83278db56093052633481ea5fccb1b15',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1321,	'CA929b7c520477f599635a98e4f1351adf',	'',	'2017-11-02 19:31:17',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'98029',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14256512468',	'+14252338984',	'+14256512468',	NULL,	NULL,	NULL,	NULL,	'ISSAQUAH',	'WA',	'CAc041d8b6b582d59e3df77d6bc0ee9cc5',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1322,	'CAca6c2db5fd233c3a46c89f2b88e70de7',	'',	'2017-11-02 20:44:46',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'92084',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17603308731',	'+16612439350',	'+17603308731',	NULL,	NULL,	NULL,	NULL,	'VISTA',	'CA',	'CAca6c2db5fd233c3a46c89f2b88e70de7',	'+14062509831',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE2762d49ab2cf6db6f205c8053f1ef1a9',	0,	0,	'',	''),
(1323,	'CA89cb1c2acea49eadf90eca02fdf6fdbb',	'',	'2017-11-03 21:32:54',	'US',	'',	'CA',	'',	'US',	'83713',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12084720214',	'+19513741928',	'+12084720214',	NULL,	NULL,	NULL,	NULL,	'BOISE',	'ID',	'CA4026a9eafb2c5b4cdeb3275a6a4fcf60',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1324,	'CA8ee5e214a4f0896d97ef76778a66002f',	'',	'2017-11-06 15:38:08',	'US',	'75202',	'TX',	'DALLAS',	'US',	'75442',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12149570400',	'+12149221949',	'+12149570400',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CA8ee5e214a4f0896d97ef76778a66002f',	'+12183160029',	'completed',	72,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE1301095c4cd90bb8be4cca8f21afaf0e',	0,	0,	'',	''),
(1325,	'CA7219a487fbcabc194a1a16138f16f09c',	'',	'2017-11-06 22:48:10',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'19977',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13022233108',	'+19162627163',	'+13022233108',	NULL,	NULL,	NULL,	NULL,	'SMYRNA',	'DE',	'CA66ce9dab139e93c8b220aeab289c86e3',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1326,	'CAf733323003d360d02ea6e0d97c5d74f5',	'',	'2017-11-06 23:33:46',	'US',	'75202',	'TX',	'DALLAS',	'US',	'75149',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12147183718',	'+12149221949',	'+12147183718',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CAf733323003d360d02ea6e0d97c5d74f5',	'+12183160029',	'completed',	60,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE8905b25a72b12d10688b2b087682ac4b',	0,	0,	'',	''),
(1327,	'CA6015910f03f9648f14e954425663e2ec',	'',	'2017-11-06 23:46:42',	'US',	'75202',	'TX',	'DALLAS',	'US',	'56425',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12183160029',	'+12149221949',	'+12183160029',	NULL,	NULL,	NULL,	NULL,	'BRAINERD',	'MN',	'CA6015910f03f9648f14e954425663e2ec',	'+12183160029',	'completed',	18,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE90a367711ec45a066bd9e0121370fe43',	0,	0,	'',	''),
(1328,	'CAfc9e0e0ac8e697370f63edbf7b444fed',	'',	'2017-11-07 21:03:00',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75053',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12146953999',	'+19722036640',	'+12146953999',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CAfc9e0e0ac8e697370f63edbf7b444fed',	'+19728157325',	'completed',	1263,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE69c082842a033287f0da5fc77aad26d6',	0,	0,	'',	''),
(1329,	'CA8b20920e73e98eab1a453621a1655ac0',	'',	'2017-11-07 21:07:54',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'56425',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12183160029',	'+19722036640',	'+12183160029',	NULL,	NULL,	NULL,	NULL,	'BRAINERD',	'MN',	'CA8b20920e73e98eab1a453621a1655ac0',	'+19728157325',	'completed',	29,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE6a3b59dccb21fa34832a8c05c6b705f7',	0,	0,	'',	''),
(1330,	'CAb432f749b1a724c21ae1210a2edc101f',	'',	'2017-11-07 21:29:23',	'US',	'75251',	'TX',	'DALLAS',	'US',	'20388',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12024558888',	'+19728517417',	'+12024558888',	NULL,	NULL,	NULL,	NULL,	'WASHINGTON',	'DC',	'CAb432f749b1a724c21ae1210a2edc101f',	'+12147183718',	'completed',	25,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3acbc4dd6f6044fbb0da638cb7ab7630',	0,	0,	'',	''),
(1331,	'CAb4215f9cf57d5b2f69e73cac86bfbecc',	'',	'2017-11-07 21:30:09',	'US',	'75251',	'TX',	'DALLAS',	'US',	'20388',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12024558888',	'+19728517417',	'+12024558888',	NULL,	NULL,	NULL,	NULL,	'WASHINGTON',	'DC',	'CAb4215f9cf57d5b2f69e73cac86bfbecc',	'+12147183718',	'completed',	22,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REfc461eb41d86d866e352b05fad27f63f',	0,	0,	'',	''),
(1332,	'CA7af25e48370eb507ccace033fe2cdfb8',	'',	'2017-11-07 23:11:44',	'US',	'75002',	'TX',	'ALLEN',	'US',	'20388',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12024558888',	'+19729546081',	'+12024558888',	NULL,	NULL,	NULL,	NULL,	'WASHINGTON',	'DC',	'CA7af25e48370eb507ccace033fe2cdfb8',	'+19729546081',	'completed',	26,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4b994983cccd25056563d2ad879cf241',	0,	0,	'',	''),
(1333,	'CAe4ecd6c8106ba857309b684a3bebc110',	'',	'2017-11-07 23:11:46',	'US',	'75002',	'TX',	'ALLEN',	'US',	'75002',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19729546081',	'+19729546081',	'+19729546081',	NULL,	NULL,	NULL,	NULL,	'ALLEN',	'TX',	'CAe4ecd6c8106ba857309b684a3bebc110',	'+19729546081',	'completed',	23,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb0894f2869aa3743bc01904ad9bb0636',	0,	0,	'',	''),
(1334,	'CA45655696d4e635aed03dece1c51529ea',	'',	'2017-11-07 23:11:48',	'US',	'75002',	'TX',	'ALLEN',	'US',	'75002',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19729546081',	'+19729546081',	'+19729546081',	NULL,	NULL,	NULL,	NULL,	'ALLEN',	'TX',	'CA45655696d4e635aed03dece1c51529ea',	'+19729546081',	'completed',	20,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe916837a750208c97e4e36c0a95ff808',	0,	0,	'',	''),
(1335,	'CAec4ffcd90c30f684bca79c4ac94150ed',	'',	'2017-11-07 23:11:50',	'US',	'75002',	'TX',	'ALLEN',	'US',	'75002',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19729546081',	'+19729546081',	'+19729546081',	NULL,	NULL,	NULL,	NULL,	'ALLEN',	'TX',	'CAec4ffcd90c30f684bca79c4ac94150ed',	'+19729546081',	'completed',	18,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE502986dd48daf27daf9ebf40f8373fe7',	0,	0,	'',	''),
(1336,	'CAbf201270d739e52a8796c61d3a4e7b66',	'',	'2017-11-07 23:11:51',	'US',	'75002',	'TX',	'ALLEN',	'US',	'75002',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19729546081',	'+19729546081',	'+19729546081',	NULL,	NULL,	NULL,	NULL,	'ALLEN',	'TX',	'CAbf201270d739e52a8796c61d3a4e7b66',	'+19729546081',	'completed',	15,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb91bd1b555d7109c29d35b2031d2b913',	0,	0,	'',	''),
(1337,	'CAd081163079c5403ba122b8fc6ecf2819',	'',	'2017-11-07 23:11:53',	'US',	'75002',	'TX',	'ALLEN',	'US',	'75002',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19729546081',	'+19729546081',	'+19729546081',	NULL,	NULL,	NULL,	NULL,	'ALLEN',	'TX',	'CAd081163079c5403ba122b8fc6ecf2819',	'+19729546081',	'completed',	12,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE54aff2fbd8fdf1256c1b2bcc8de147fa',	0,	0,	'',	''),
(1338,	'CAfdf66e74193423b4af4d81037a847f2c',	'',	'2017-11-07 23:11:55',	'US',	'75002',	'TX',	'ALLEN',	'US',	'75002',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19729546081',	'+19729546081',	'+19729546081',	NULL,	NULL,	NULL,	NULL,	'ALLEN',	'TX',	'CAfdf66e74193423b4af4d81037a847f2c',	'+19729546081',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc042932bf7a2985ec2b968dc3328f17d',	0,	0,	'',	''),
(1339,	'CAe3b45031fa06d7155a2d0f48df5b7d88',	'',	'2017-11-07 23:11:57',	'US',	'75002',	'TX',	'ALLEN',	'US',	'75002',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19729546081',	'+19729546081',	'+19729546081',	NULL,	NULL,	NULL,	NULL,	'ALLEN',	'TX',	'CAe3b45031fa06d7155a2d0f48df5b7d88',	'+19729546081',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE7294731acc2ff8f8386cc30f4a8f1fd6',	0,	0,	'',	''),
(1340,	'CA632a6f1e0778a8c6f07084f64b39b7b1',	'',	'2017-11-07 23:11:58',	'US',	'75002',	'TX',	'ALLEN',	'US',	'75002',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19729546081',	'+19729546081',	'+19729546081',	NULL,	NULL,	NULL,	NULL,	'ALLEN',	'TX',	'CA632a6f1e0778a8c6f07084f64b39b7b1',	'+19729546081',	'completed',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf0f37191ed78165e1afffd96b148343d',	0,	0,	'',	''),
(1341,	'CAea1d2c191959cf8751f3651cdf002e36',	'',	'2017-11-07 23:12:00',	'US',	'75002',	'TX',	'ALLEN',	'US',	'75002',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19729546081',	'+19729546081',	'+19729546081',	NULL,	NULL,	NULL,	NULL,	'ALLEN',	'TX',	'CAea1d2c191959cf8751f3651cdf002e36',	'+19729546081',	'completed',	2,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3e3f15b11a4993244121b0a48034932d',	0,	0,	'',	''),
(1342,	'CA959f8eb57073551ffa580e2ef8ad6812',	'',	'2017-11-07 23:12:02',	'US',	'75002',	'TX',	'ALLEN',	'US',	'75002',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19729546081',	'+19729546081',	'+19729546081',	NULL,	NULL,	NULL,	NULL,	'ALLEN',	'TX',	'CA959f8eb57073551ffa580e2ef8ad6812',	'+19729546081',	'failed',	NULL,	NULL,	0,	0,	'',	''),
(1343,	'CAe886d2fdb96419253427cc090b1398d6',	'',	'2017-11-08 21:08:04',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'90017',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14242315591',	'+16612439350',	'+14242315591',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA0903667fc87150e028996e356658550a',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1344,	'CAa7e14b27e1786ee92ffea5d2c742a0a2',	'',	'2017-11-08 21:36:38',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18888343039',	'+19513741928',	'+18888343039',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA2e7e8eec2ad39fe32da7a0f226a3b533',	'+14062509831',	'voicemail',	26,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa1905ac5b987746f0a5deaebb956a9c5',	0,	0,	'',	''),
(1345,	'CA0029e32e42efa4b3a6925ab1a5665f0c',	'',	'2017-11-08 22:16:29',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19842694800',	'+19513741928',	'+19842694800',	NULL,	NULL,	NULL,	NULL,	'',	'NC',	'CA9f3dba2c0a69e09359b830bc043520f2',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1346,	'CA17e28f76ce6b9aede28fb759b574a3e0',	'',	'2017-11-08 22:28:22',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'90017',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14242315591',	'+16612439350',	'+14242315591',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA13af3e0adafd248feff974a963d25b31',	'+14062509831',	'voicemail',	19,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REcf9936b88c7308abd9d6d40338fc10f4',	0,	0,	'',	''),
(1347,	'CAde52b3ab1e182b9c802be5b2dff5ab0c',	'',	'2017-11-09 15:49:39',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18880114417',	'+19722036640',	'+18880114417',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CAde52b3ab1e182b9c802be5b2dff5ab0c',	'+19728157325',	'completed',	55,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE8072531b611dc945eefcc4fc09e8f554',	0,	0,	'',	''),
(1348,	'CAa8d74e3524c7ffd336ce13e84bb2094d',	'',	'2017-11-09 15:54:45',	'US',	'75024',	'TX',	'PLANO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18880114417',	'+19728051470',	'+18880114417',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CAa8d74e3524c7ffd336ce13e84bb2094d',	'+12146824990',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1349,	'CAd87bb73a9dcd42c56ce5c933d7025473',	'',	'2017-11-09 15:55:59',	'US',	'75202',	'TX',	'DALLAS',	'US',	'33434',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15619815918',	'+12149221949',	'+15619815918',	NULL,	NULL,	NULL,	NULL,	'BOCA RATON',	'FL',	'CAd87bb73a9dcd42c56ce5c933d7025473',	'+12183160029',	'completed',	147,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3ca0a0a2705cb7ba647f78e4ee817b64',	0,	0,	'',	''),
(1350,	'CAdae77b72a914d927c3b42afebbf9ea9e',	'',	'2017-11-09 15:56:43',	'US',	'75024',	'TX',	'PLANO',	'US',	'75226',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12146824990',	'+19728051470',	'+12146824990',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CAdae77b72a914d927c3b42afebbf9ea9e',	'+12146824990',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1351,	'CA31fd53398e878856380ea7d924ca4c1a',	'',	'2017-11-09 15:57:01',	'US',	'75024',	'TX',	'PLANO',	'US',	'75226',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12146824990',	'+19728051470',	'+12146824990',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CA31fd53398e878856380ea7d924ca4c1a',	'+12146824990',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1352,	'CAc185a2e43b59d67ec146edc11bbfa151',	'',	'2017-11-09 16:03:15',	'US',	'75202',	'TX',	'DALLAS',	'US',	'56425',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12183160029',	'+12149221949',	'+12183160029',	NULL,	NULL,	NULL,	NULL,	'BRAINERD',	'MN',	'CAc185a2e43b59d67ec146edc11bbfa151',	'+12183160029',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1353,	'CAffbf3127734a24d3db77febf23663cbd',	'',	'2017-11-09 16:09:07',	'US',	'75202',	'TX',	'DALLAS',	'US',	'33434',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15619815918',	'+12149221949',	'+15619815918',	NULL,	NULL,	NULL,	NULL,	'BOCA RATON',	'FL',	'CAffbf3127734a24d3db77febf23663cbd',	'+12183160029',	'completed',	88,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf81ac0cfa32a4ad78458df7a417fd4d9',	0,	0,	'',	''),
(1354,	'CA2ba3967613171cec532ec9bcfed02400',	'',	'2017-11-09 16:15:57',	'US',	'75202',	'TX',	'DALLAS',	'US',	'59903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14062509831',	'+12149221949',	'+14062509831',	NULL,	NULL,	NULL,	NULL,	'KALISPELL',	'MT',	'CA2ba3967613171cec532ec9bcfed02400',	'+12183160029',	'completed',	54,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf19f2a22aa8cf1a922033825e13f7738',	0,	0,	'',	''),
(1355,	'CAc97b1d8bda5f86b108c83825409169aa',	'',	'2017-11-09 16:54:06',	'US',	'75201',	'TX',	'DALLAS',	'US',	'20388',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+14696190565',	'+12024558888',	NULL,	NULL,	NULL,	NULL,	'WASHINGTON',	'DC',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1356,	'CA68db344db6afe888d44007786d56e5fa',	'',	'2017-11-09 16:57:11',	'US',	'75201',	'TX',	'DALLAS',	'US',	'20388',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12024558888',	'+14696190565',	'+12024558888',	NULL,	NULL,	NULL,	NULL,	'WASHINGTON',	'DC',	'CA68db344db6afe888d44007786d56e5fa',	'+12146953999',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa788d0907659511f0b7a2898189eb7af',	0,	0,	'',	''),
(1357,	'CA977b9592f93fa4370deac46502844cd4',	'',	'2017-11-09 18:25:28',	'US',	'75152',	'TX',	'PALMER',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14698040826',	'+14692146402',	'+14698040826',	NULL,	NULL,	NULL,	NULL,	'',	'TX',	'CA977b9592f93fa4370deac46502844cd4',	'+12146953999',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1358,	'CA16ca6870ece831762a503dce65776262',	'',	'2017-11-10 03:46:44',	'US',	'75002',	'TX',	'ALLEN',	'US',	'76006',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18179877819',	'+19729546080',	'+18179877819',	NULL,	NULL,	NULL,	NULL,	'ARLINGTON',	'TX',	'CA16ca6870ece831762a503dce65776262',	'+12147183718',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1359,	'CA7de312fde560c5a8e75abcecbf1bcbab',	'',	'2017-11-10 19:15:12',	'US',	'75202',	'TX',	'DALLAS',	'US',	'76210',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19402315995',	'+12149221949',	'+19402315995',	NULL,	NULL,	NULL,	NULL,	'DENTON',	'TX',	'CA7de312fde560c5a8e75abcecbf1bcbab',	'+12183160029',	'completed',	5070,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE851297fd0f87242bb1f71156d84b98a7',	0,	0,	'',	''),
(1360,	'CAe5e3d941707d0de354e885d0e689e262',	'',	'2017-11-10 20:40:24',	'US',	'75202',	'TX',	'DALLAS',	'US',	'76210',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19402315995',	'+12149221949',	'+19402315995',	NULL,	NULL,	NULL,	NULL,	'DENTON',	'TX',	'CAe5e3d941707d0de354e885d0e689e262',	'+12183160029',	'completed',	284,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE0d92695dd9cfc89c726aa51c462111a4',	0,	0,	'',	''),
(1361,	'CAb147e0c91c3a16e519df353e4790c5ef',	'',	'2017-11-14 03:49:00',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18002485275',	'+19162627163',	'+18002485275',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA2913338f6754e863ad8cdb658cb0c07d',	'+14062509831',	'voicemail',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE1dec936277c3eb5db791281e796e8142',	0,	0,	'',	''),
(1362,	'CA45d7384daf5e097f3ec95d1cb4c86731',	'',	'2017-11-14 18:11:17',	'US',	'75201',	'TX',	'DALLAS',	'US',	'78216',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12108228272',	'+14696190565',	'+12108228272',	NULL,	NULL,	NULL,	NULL,	'SAN ANTONIO',	'TX',	'CA45d7384daf5e097f3ec95d1cb4c86731',	'+12146953999',	'completed',	41,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd22ae38a9da1295befe002d9b66ddea7',	0,	0,	'',	''),
(1363,	'CA68a31386eab21a8b9c6a6436607a79a2',	'',	'2017-11-14 18:48:53',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'85256',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14808404730',	'+19722036640',	'+14808404730',	NULL,	NULL,	NULL,	NULL,	'PHOENIX',	'AZ',	'CA68a31386eab21a8b9c6a6436607a79a2',	'+19728157325',	'completed',	83,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc51160066f5830a743976be1db733a25',	0,	0,	'',	''),
(1364,	'CA2e76ab31cf38c051e077fb93d2019b49',	'',	'2017-11-14 22:11:29',	'US',	'75202',	'TX',	'DALLAS',	'US',	'75007',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19724784343',	'+12149221949',	'+19724784343',	NULL,	NULL,	NULL,	NULL,	'CARROLLTON',	'TX',	'CA2e76ab31cf38c051e077fb93d2019b49',	'+12183160029',	'completed',	86,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE63d228b98ec827b94d968ec43b6cd1f3',	0,	0,	'',	''),
(1365,	'CAff6b42c145652e845b67595bf6e5d6b7',	'',	'2017-11-15 18:58:20',	'US',	'75002',	'TX',	'ALLEN',	'US',	'76001',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18173753395',	'+19729546080',	'+18173753395',	NULL,	NULL,	NULL,	NULL,	'ARLINGTON',	'TX',	'CAff6b42c145652e845b67595bf6e5d6b7',	'+12147183718',	'completed',	15,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb88f46d0a6a77676d756b07b94aa2fc6',	0,	0,	'',	''),
(1366,	'CAde6021e115c7078358757cf2e4300312',	'',	'2017-11-15 18:59:44',	'US',	'75002',	'TX',	'ALLEN',	'US',	'76001',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18173753395',	'+19729546080',	'+18173753395',	NULL,	NULL,	NULL,	NULL,	'ARLINGTON',	'TX',	'CAde6021e115c7078358757cf2e4300312',	'+12147183718',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE24554ae9578d0ca853296ff0b132fc5e',	0,	0,	'',	''),
(1367,	'CA06006933933216fddd6abc2e912cd46e',	'',	'2017-11-15 21:57:24',	'US',	'76210',	'TX',	'DENTON',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16504990698',	'+19402203090',	'+16504990698',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA06006933933216fddd6abc2e912cd46e',	'+19402315995',	'completed',	78,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REec0b84bae8c944ca490f3a467377620e',	0,	0,	'',	''),
(1368,	'CA966923526cd2b91253d03e5a029ae41c',	'',	'2017-11-16 15:37:51',	'US',	'75002',	'TX',	'ALLEN',	'US',	'76001',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18173759370',	'+19729546080',	'+18173759370',	NULL,	NULL,	NULL,	NULL,	'ARLINGTON',	'TX',	'CA966923526cd2b91253d03e5a029ae41c',	'+12147183718',	'completed',	44,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE5bd1e8b4f9b3c8dab8cac28395bd09da',	0,	0,	'',	''),
(1369,	'CAe78e3b9650ebe432d7726d4db0387eec',	'',	'2017-11-16 19:01:46',	'US',	'75234',	'TX',	'CARROLLTON',	'US',	'76704',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18177568233',	'+14695578827',	'+18177568233',	NULL,	NULL,	NULL,	NULL,	'GRAPEVINE',	'TX',	'CAe78e3b9650ebe432d7726d4db0387eec',	'+19402315995',	'completed',	25,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe0983c3b2b440ffe09ff26fb53b6e93b',	0,	0,	'',	''),
(1370,	'CA2193e4de34ddd43e4f1d95bef30b3233',	'',	'2017-11-16 22:10:14',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'93004',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18052585676',	'+19162627163',	'+18052585676',	NULL,	NULL,	NULL,	NULL,	'VENTURA',	'CA',	'CAf744893487fd4cc67b586f566082b0f7',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1371,	'CAb3b3afb28a05d0a519f5d84032ff34f0',	'',	'2017-11-17 17:58:07',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19162627163',	'+14243131088',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1372,	'CA78a0d22f936b5ea561223ea7db8a26aa',	'',	'2017-11-18 22:47:15',	'US',	'',	'CA',	'',	'US',	'92630',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19492151369',	'+19513741928',	'+19492151369',	NULL,	NULL,	NULL,	NULL,	'ALISO VIEJO',	'CA',	'CA9a27af6d29faa8497396da9a428f000d',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1373,	'CAfd2121a6290330cdc199d003fadac520',	'',	'2017-11-18 22:47:58',	'US',	'',	'CA',	'',	'US',	'92630',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19492151369',	'+19513741928',	'+19492151369',	NULL,	NULL,	NULL,	NULL,	'ALISO VIEJO',	'CA',	'CA23fe08eb4f8f6e159ad1a4d5f987a0f1',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1374,	'CA7d307f7a695bccf3a3fc1b5d848ed53b',	'',	'2017-11-21 20:26:01',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'60517',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16308691703',	'+14252338984',	'+16308691703',	NULL,	NULL,	NULL,	NULL,	'DOWNERS GROVE',	'IL',	'CAf2f06fb26c0cbbd981e0460188fc1ebc',	'+14062509831',	'voicemail',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE03bb95bb191ac58d482c843e3c38032f',	0,	0,	'',	''),
(1375,	'CA623d14e2efe3eaafcab94e5e371d669f',	'',	'2017-11-22 19:10:49',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18774925621',	'+19513741928',	'+18774925621',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA5b566c319884bbcc896197f4358ffdb4',	'+14062509831',	'voicemail',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc76a42baea9c990152238fbaa6de3202',	0,	0,	'',	''),
(1376,	'CAd663ad77d19f9946be64c33fa597f9bb',	'',	'2017-11-22 21:21:40',	'US',	'',	'CA',	'',	'US',	'90071',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13233319273',	'+19513741928',	'+13233319273',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA95fe0cc393fa601ad613cca47ffd9f9b',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1377,	'CA8565ea23a674a9d31ba20deb5da30479',	'',	'2017-11-24 22:45:23',	'US',	'',	'TX',	'',	'US',	'75146',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19722243364',	'+14697784620',	'+19722243364',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CA8565ea23a674a9d31ba20deb5da30479',	'+12146953999',	'completed',	12,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd236c4668b7c68e814108d6330a03a13',	0,	0,	'',	''),
(1378,	'CAdb083bd52a6106532d47ce21cd527888',	'',	'2017-11-27 14:39:38',	'US',	'75202',	'TX',	'DALLAS',	'US',	'75025',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19726680850',	'+12149221949',	'+19726680850',	NULL,	NULL,	NULL,	NULL,	'FRISCO',	'TX',	'CAdb083bd52a6106532d47ce21cd527888',	'+12183160029',	'completed',	42,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf21dcb59afbd9ef3a0be64f2d26d07f2',	0,	0,	'',	''),
(1379,	'CA93c56dc0a459eb80b8b0d9abc53b813b',	'',	'2017-11-27 15:25:00',	'US',	'75202',	'TX',	'DALLAS',	'US',	'75208',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12146841152',	'+12149221949',	'+12146841152',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CA93c56dc0a459eb80b8b0d9abc53b813b',	'+12183160029',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4f0b517920d6dcfda2c289a7eb9f9257',	0,	0,	'',	''),
(1380,	'CA31381813bb5f96894bd4b472999cb0a7',	'',	'2017-11-27 16:50:57',	'US',	'75202',	'TX',	'DALLAS',	'US',	'75208',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12146841152',	'+12149221949',	'+12146841152',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CA31381813bb5f96894bd4b472999cb0a7',	'+12183160029',	'completed',	20,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3fcebb43f895b6d51ae259f7c44a0d7f',	0,	0,	'',	''),
(1381,	'CA259e5c954c5e565811e967e48092e2ce',	'',	'2017-11-27 18:32:32',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'28110',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17042203163',	'+14252338984',	'+17042203163',	NULL,	NULL,	NULL,	NULL,	'MONROE',	'NC',	'CAc0e9f8f29cf1cbad90f0b4feee2722ad',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1382,	'CA0b105321624eadef956859a40572d8c7',	'',	'2017-11-27 21:06:34',	'US',	'75202',	'TX',	'DALLAS',	'US',	'75025',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19726680850',	'+12149221949',	'+19726680850',	NULL,	NULL,	NULL,	NULL,	'FRISCO',	'TX',	'CA0b105321624eadef956859a40572d8c7',	'+12183160029',	'completed',	15,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE1601934fbe7a90b16a9c313cfff1512b',	0,	0,	'',	''),
(1383,	'CAc5e14e9f8e6ba02b5b54a63b162410ef',	'',	'2017-11-28 15:19:59',	'US',	'75152',	'TX',	'PALMER',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14698040826',	'+14692146402',	'+14698040826',	NULL,	NULL,	NULL,	NULL,	'',	'TX',	'CAc5e14e9f8e6ba02b5b54a63b162410ef',	'+12146953999',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1384,	'CA38e1a2c13c6c6276457e5d1eb722f41a',	'',	'2017-11-28 16:50:27',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'77587',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17138995859',	'+19722036640',	'+17138995859',	NULL,	NULL,	NULL,	NULL,	'HOUSTON',	'TX',	'CA38e1a2c13c6c6276457e5d1eb722f41a',	'+19728157325',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE2ed28da3ad2ff6aab1efbf7393e590b4',	0,	0,	'',	''),
(1385,	'CA27af8a757cba21c5a57888f7e1ed885a',	'',	'2017-11-28 17:11:24',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'76015',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12142447373',	'+19722036640',	'+12142447373',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CA27af8a757cba21c5a57888f7e1ed885a',	'+19728157325',	'completed',	49,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd3b0bca31600e1f5d17b9084d212f09d',	0,	0,	'',	''),
(1386,	'CA592eab30b28af557f1c026b2922fe82b',	'',	'2017-11-28 17:12:43',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'76015',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12142447373',	'+19722036640',	'+12142447373',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CA592eab30b28af557f1c026b2922fe82b',	'+19728157325',	'completed',	528,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa68b07f9f3674e8e35d5725857661beb',	0,	0,	'',	''),
(1387,	'CA0d6b9f1fe82de6bc19217a8cd6524ec3',	'',	'2017-11-28 18:42:24',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'19462',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16106296428',	'+14252338984',	'+16106296428',	NULL,	NULL,	NULL,	NULL,	'CONSHOHOCKEN',	'PA',	'CAb33d547ac95b2f675db8cede13835daa',	'+14062509831',	'voicemail',	18,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3de6c923c25a48cbdb5a218447777576',	0,	0,	'',	''),
(1388,	'CA029b8cbd0df7be01d0e1cb9aa2d08a1f',	'',	'2017-11-28 20:34:39',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14696621715',	'+19722036640',	'+14696621715',	NULL,	NULL,	NULL,	NULL,	'',	'TX',	'CA029b8cbd0df7be01d0e1cb9aa2d08a1f',	'+19728157325',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe00084bbe36177653c379d90d6c0332f',	0,	0,	'',	''),
(1389,	'CAdb542f2a9a48b2877654ba0c2125c3fd',	'',	'2017-11-28 20:37:16',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14696621715',	'+19722036640',	'+14696621715',	NULL,	NULL,	NULL,	NULL,	'',	'TX',	'CAdb542f2a9a48b2877654ba0c2125c3fd',	'+19728157325',	'completed',	246,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe5e1528a7d8d48400e60f1e41863a7a0',	0,	0,	'',	''),
(1390,	'CA73255085201e4338b09c60177f0bf1e8',	'',	'2017-11-28 20:44:15',	'US',	'75024',	'TX',	'PLANO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14696621715',	'+19728051470',	'+14696621715',	NULL,	NULL,	NULL,	NULL,	'',	'TX',	'CA73255085201e4338b09c60177f0bf1e8',	'+12146824990',	'completed',	144,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE5c27d39854e7401be74e2dac86c7dfd9',	0,	0,	'',	''),
(1391,	'CA91526fb04f53d1863b5bc50979a36288',	'',	'2017-11-28 22:30:06',	'US',	'75244',	'TX',	'DALLAS',	'US',	'75063',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19729160923',	'+19729190409',	'+19729160923',	NULL,	NULL,	NULL,	NULL,	'IRVING',	'TX',	'CA91526fb04f53d1863b5bc50979a36288',	'+19728157325',	'completed',	46,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE8b7a1e82f9956da73e3b577339ad67a0',	0,	0,	'',	''),
(1392,	'CAdc9ead6d8becbb41c52c91941ac8b18b',	'',	'2017-11-28 23:29:04',	'US',	'75202',	'TX',	'DALLAS',	'US',	'59903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14062509831',	'+12149221949',	'+14062509831',	NULL,	NULL,	NULL,	NULL,	'KALISPELL',	'MT',	'CAdc9ead6d8becbb41c52c91941ac8b18b',	'+12183160029',	'completed',	29,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE68042ed0254b2f9e14f3afc5f67177cb',	0,	0,	'',	''),
(1393,	'CA6bd9f9e474f68469242f99f4e842499d',	'',	'2017-11-28 23:30:00',	'US',	'75202',	'TX',	'DALLAS',	'US',	'59903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14062509831',	'+12149221949',	'+14062509831',	NULL,	NULL,	NULL,	NULL,	'KALISPELL',	'MT',	'CA6bd9f9e474f68469242f99f4e842499d',	'+12183160029',	'completed',	32,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc3528dbcd21e86014749dd8f3eb33bf4',	0,	0,	'',	''),
(1394,	'CAc096191dad94c214e56d39f4bfc899ba',	'',	'2017-11-28 23:30:51',	'US',	'75202',	'TX',	'DALLAS',	'US',	'59903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14062509831',	'+12149221949',	'+14062509831',	NULL,	NULL,	NULL,	NULL,	'KALISPELL',	'MT',	'CAc096191dad94c214e56d39f4bfc899ba',	'+12183160029',	'completed',	75,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe884f78a21d77c343f757024819504b9',	0,	0,	'',	''),
(1395,	'CAf08022a54fb6a250232c9f32d0e8a448',	'',	'2017-11-28 23:32:21',	'US',	'75202',	'TX',	'DALLAS',	'US',	'59903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14062509831',	'+12149221949',	'+14062509831',	NULL,	NULL,	NULL,	NULL,	'KALISPELL',	'MT',	'CAf08022a54fb6a250232c9f32d0e8a448',	'+12183160029',	'completed',	274,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REef5a88b544f0f9bb3286062cfe7290e4',	0,	0,	'',	''),
(1396,	'CA61c8b12c5c4250178a2e72001bac2705',	'',	'2017-11-29 16:47:40',	'US',	'',	'TX',	'',	'US',	'77039',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12817051277',	'+17133227812',	'+12817051277',	NULL,	NULL,	NULL,	NULL,	'HOUSTON',	'TX',	'CA61c8b12c5c4250178a2e72001bac2705',	'+13462347725',	'completed',	187,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REcb7466590a32e6607ce624a69bf35e0d',	0,	0,	'',	''),
(1397,	'CA92c8ffaaf781ce1fd69f190aafc749b2',	'',	'2017-11-29 18:41:01',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'19462',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16106296428',	'+14252338984',	'+16106296428',	NULL,	NULL,	NULL,	NULL,	'CONSHOHOCKEN',	'PA',	'CAdb290c452d5b491225712491c365d88c',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1398,	'CAbfbf05b5a4c7d60dcfc96b2b31a6328c',	'',	'2017-11-29 19:52:29',	'US',	'',	'TX',	'',	'US',	'77039',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12817051277',	'+17133227812',	'+12817051277',	NULL,	NULL,	NULL,	NULL,	'HOUSTON',	'TX',	'CAbfbf05b5a4c7d60dcfc96b2b31a6328c',	'+13462347725',	'completed',	46,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE0fef33359e37ed9a49167ff0696ff99b',	0,	0,	'',	''),
(1399,	'CAdf0ec94579d53e30d4fcdfa28ae02e44',	'',	'2017-11-29 20:44:25',	'US',	'75244',	'TX',	'DALLAS',	'US',	'75063',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19729160923',	'+19729190409',	'+19729160923',	NULL,	NULL,	NULL,	NULL,	'IRVING',	'TX',	'CAdf0ec94579d53e30d4fcdfa28ae02e44',	'+19728157325',	'completed',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REccd5fb95299905153accb1ecfd5c6b2e',	0,	0,	'',	''),
(1400,	'CA66fba33cd2b9125401cec4102fad32b4',	'',	'2017-11-29 22:35:16',	'US',	'',	'TX',	'',	'US',	'63379',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15738980104',	'+19403040735',	'+15738980104',	NULL,	NULL,	NULL,	NULL,	'ELSBERRY',	'MO',	'CA66fba33cd2b9125401cec4102fad32b4',	'+12146953999',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1401,	'CA99a7b197be12683cda99e975735c75ae',	'',	'2017-11-30 17:08:53',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'85009',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16025332617',	'+19162627163',	'+16025332617',	NULL,	NULL,	NULL,	NULL,	'PHOENIX',	'AZ',	'CAb706ccca4c567797629229d3dec11a12',	'+14062509831',	'voicemail',	32,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf61b1835465db559b5deb991094f28f0',	0,	0,	'',	''),
(1402,	'CA1933dbb4d8c4a9c9352076c91d921698',	'',	'2017-11-30 21:23:15',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18774614266',	'+19513741928',	'+18774614266',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA1933dbb4d8c4a9c9352076c91d921698',	'+14062509831',	'completed',	16,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd0c50128bdc2d752cc63610d8b0d276a',	0,	0,	'',	''),
(1403,	'CA2bd3e3f51b6b50e359eea977dfae1c26',	'',	'2017-12-01 15:32:24',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75287',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12147282420',	'+19722036640',	'+12147282420',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CA2bd3e3f51b6b50e359eea977dfae1c26',	'+19728157325',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE858a5e611e00e2be728f627820536b82',	0,	0,	'',	''),
(1404,	'CA420ceb22a23dd11816f7a884bdff9577',	'',	'2017-12-01 21:29:47',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95818',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19162370239',	'+19162627163',	'+19162370239',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CA9aeaf64df3716b43b54f2582e0ff1cfa',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1405,	'CA7e7d6a9e4a5acda2886e23a6285e24f3',	'',	'2017-12-02 18:21:47',	'US',	'75254',	'TX',	'DALLAS',	'US',	'36107',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13342339762',	'+19728611197',	'+13342339762',	NULL,	NULL,	NULL,	NULL,	'MONTGOMERY',	'AL',	'CA7e7d6a9e4a5acda2886e23a6285e24f3',	'+12147183718',	'completed',	14,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4da81ff19170272530f0d938c8f2f1ac',	0,	0,	'',	''),
(1406,	'CA3ffd6a6b6ac2f2ccc017a8fb3d12a657',	'',	'2017-12-02 22:11:29',	'US',	'',	'TX',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14704143114',	'+19403040735',	'+14704143114',	NULL,	NULL,	NULL,	NULL,	'ATLANTA',	'GA',	'CA3ffd6a6b6ac2f2ccc017a8fb3d12a657',	'+12146953999',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1407,	'CA9125da07fc20bf7c0a66ed8aaed33e18',	'',	'2017-12-04 17:35:03',	'US',	'75024',	'TX',	'PLANO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14696621715',	'+19728051470',	'+14696621715',	NULL,	NULL,	NULL,	NULL,	'',	'TX',	'CA9125da07fc20bf7c0a66ed8aaed33e18',	'+12146824990',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REdc1460cc91dcd74bec5e065077dc6dd8',	0,	0,	'',	''),
(1408,	'CA333095207de909c98d09906a15f4e972',	'',	'2017-12-04 19:19:51',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14696348746',	'+19722036640',	'+14696348746',	NULL,	NULL,	NULL,	NULL,	'',	'TX',	'CA333095207de909c98d09906a15f4e972',	'+19728157325',	'completed',	43,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE10765c4b4e7493dce80811122cbac88b',	0,	0,	'',	''),
(1409,	'CA9ece2f0bfceada00311cf44dccc9dd2b',	'',	'2017-12-04 21:56:53',	'US',	'75202',	'TX',	'DALLAS',	'US',	'75212',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19727954260',	'+12149221949',	'+19727954260',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CA9ece2f0bfceada00311cf44dccc9dd2b',	'+12183160029',	'completed',	38,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe86ca4d9dbfeebd6defafe7b7efa593f',	0,	0,	'',	''),
(1410,	'CAe44e003079f23acd3b995a6b158f0de5',	'',	'2017-12-05 15:03:02',	'US',	'75258',	'TX',	'DALLAS',	'US',	'71118',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13187173545',	'+12147616810',	'+13187173545',	NULL,	NULL,	NULL,	NULL,	'SHREVEPORT',	'LA',	'CAe44e003079f23acd3b995a6b158f0de5',	'+12147096672',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REfd124925fc912ca29fb57b0253eb4901',	0,	0,	'',	''),
(1411,	'CA38e130618dd89e7fa0f74160e552bb61',	'',	'2017-12-05 15:07:42',	'US',	'75258',	'TX',	'DALLAS',	'US',	'71118',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13187173545',	'+12147616810',	'+13187173545',	NULL,	NULL,	NULL,	NULL,	'SHREVEPORT',	'LA',	'CA38e130618dd89e7fa0f74160e552bb61',	'+12147096672',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1412,	'CA6baafa4f4fb47b086575272cd5359e48',	'',	'2017-12-05 17:07:46',	'US',	'75251',	'TX',	'DALLAS',	'US',	'75052',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12146974141',	'+19728517417',	'+12146974141',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CA6baafa4f4fb47b086575272cd5359e48',	'+12147183718',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe10a290850407cdc137658296dc5ff48',	0,	0,	'',	''),
(1413,	'CA80a364f137972f86b8454a2bda651b1f',	'',	'2017-12-05 18:19:52',	'US',	'75202',	'TX',	'DALLAS',	'US',	'34744',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14079220033',	'+12149221949',	'+14079220033',	NULL,	NULL,	NULL,	NULL,	'KISSIMMEE',	'FL',	'CA80a364f137972f86b8454a2bda651b1f',	'+12183160029',	'completed',	12,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE24423d731963225955c438bf1bcc9e35',	0,	0,	'',	''),
(1414,	'CA4bf16aa081511f7f1c2b6ea3c2e4a624',	'',	'2017-12-05 19:15:54',	'US',	'75202',	'TX',	'DALLAS',	'US',	'78213',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12107349203',	'+12149221949',	'+12107349203',	NULL,	NULL,	NULL,	NULL,	'SAN ANTONIO',	'TX',	'CA4bf16aa081511f7f1c2b6ea3c2e4a624',	'+12183160029',	'completed',	1930,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd15eeb6ae35c225d28429f1c81bf7e00',	0,	0,	'',	''),
(1415,	'CAd3f4207445907ecf10c836afe574addf',	'',	'2017-12-05 22:26:57',	'US',	'75251',	'TX',	'DALLAS',	'US',	'75240',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19729786679',	'+19728517417',	'+19729786679',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CAd3f4207445907ecf10c836afe574addf',	'+12147183718',	'completed',	202,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE54904a8d576a7524846b2fe305b20a52',	0,	0,	'',	''),
(1416,	'CAba07a2454335578dd7ef201f9741776d',	'',	'2017-12-05 22:32:49',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'78213',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12107349203',	'+19722036640',	'+12107349203',	NULL,	NULL,	NULL,	NULL,	'SAN ANTONIO',	'TX',	'CAba07a2454335578dd7ef201f9741776d',	'+19728157325',	'busy',	NULL,	NULL,	0,	0,	'',	''),
(1417,	'CA29e6e41271c4960fa93238b8df7bc4b8',	'',	'2017-12-05 22:33:37',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'78258',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12107714552',	'+19722036640',	'+12107714552',	NULL,	NULL,	NULL,	NULL,	'SAN ANTONIO',	'TX',	'CA29e6e41271c4960fa93238b8df7bc4b8',	'+19728157325',	'completed',	745,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE87070e5667a90babf5f3b7e00df0940d',	0,	0,	'',	''),
(1418,	'CA36c6c837cd83c733c5e7cf512a0fa594',	'',	'2017-12-05 22:51:01',	'US',	'75024',	'TX',	'PLANO',	'US',	'78258',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12107714552',	'+19728051470',	'+12107714552',	NULL,	NULL,	NULL,	NULL,	'SAN ANTONIO',	'TX',	'CA36c6c837cd83c733c5e7cf512a0fa594',	'+12146824990',	'completed',	12,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REdb6de3853d694ecd0acd7a98d143f2e4',	0,	0,	'',	''),
(1419,	'CAf92388495ced9e670225a99adbeba33d',	'',	'2017-12-06 17:38:24',	'US',	'',	'TX',	'',	'US',	'30327',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14049788978',	'+14695357756',	'+14049788978',	NULL,	NULL,	NULL,	NULL,	'ATLANTA',	'GA',	'CAf92388495ced9e670225a99adbeba33d',	'+19402315995',	'completed',	407,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE6a88fe6d0e7b5802eacda67b9e5c22bf',	0,	0,	'',	''),
(1420,	'CAf1f6964424fc7adac99284fe21aad38a',	'',	'2017-12-07 09:04:50',	'US',	'',	'TX',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18778894546',	'+14696091523',	'+18778894546',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CAf1f6964424fc7adac99284fe21aad38a',	'+19402315995',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1421,	'CA0ec4ed36a030ec7aadfcf64391842ee6',	'',	'2017-12-07 15:49:57',	'US',	'75202',	'TX',	'DALLAS',	'US',	'59903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14062509831',	'+12149221949',	'+14062509831',	NULL,	NULL,	NULL,	NULL,	'KALISPELL',	'MT',	'CA0ec4ed36a030ec7aadfcf64391842ee6',	'+12183160029',	'completed',	14,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REdf45b385ed4cdeef4df789b574f98e84',	0,	0,	'',	''),
(1422,	'CAa32bc8a9e8715e2656820e0e40d12339',	'',	'2017-12-07 15:50:35',	'US',	'75202',	'TX',	'DALLAS',	'US',	'59903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14062509831',	'+12149221949',	'+14062509831',	NULL,	NULL,	NULL,	NULL,	'KALISPELL',	'MT',	'CAa32bc8a9e8715e2656820e0e40d12339',	'+12183160029',	'completed',	17,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb8784eb0d268ec8cef6a6a06903edad2',	0,	0,	'',	''),
(1423,	'CA7b4f30d345225e17f6c40e3493eb7056',	'',	'2017-12-07 16:19:50',	'US',	'76210',	'TX',	'DENTON',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14692709010',	'+19402203090',	'+14692709010',	NULL,	NULL,	NULL,	NULL,	'',	'TX',	'CA7b4f30d345225e17f6c40e3493eb7056',	'+19402315995',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE6517fb23d5637e4851db3d9a6e4a4583',	0,	0,	'',	''),
(1424,	'CAe78ee291cf6249532eda8efaf5a17019',	'',	'2017-12-07 16:33:48',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'59903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14062509831',	'+19722036640',	'+14062509831',	NULL,	NULL,	NULL,	NULL,	'KALISPELL',	'MT',	'CAe78ee291cf6249532eda8efaf5a17019',	'+19728157325',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1425,	'CA014b607e5296c0fe6ca850bf7b67fa2e',	'',	'2017-12-07 18:23:56',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'56425',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12183160029',	'+19722036640',	'+12183160029',	NULL,	NULL,	NULL,	NULL,	'BRAINERD',	'MN',	'CA014b607e5296c0fe6ca850bf7b67fa2e',	'+19728157325',	'completed',	34,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE0c3497855f091ce556b5ddb25acf5653',	0,	0,	'',	''),
(1426,	'CA5c2052ae494ac4f6baee69c1f1a5a89d',	'',	'2017-12-07 18:31:48',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75048',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19725305200',	'+19722036640',	'+19725305200',	NULL,	NULL,	NULL,	NULL,	'PLANO',	'TX',	'CA5c2052ae494ac4f6baee69c1f1a5a89d',	'+19728157325',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE56d263e505c096a7047bf76419d52ecc',	0,	0,	'',	''),
(1427,	'CAdc2a4d0c886d411caa32b0ba4b671ec2',	'',	'2017-12-07 19:51:57',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'90265',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13105799716',	'+19162627163',	'+13105799716',	NULL,	NULL,	NULL,	NULL,	'MALIBU',	'CA',	'CAdc2a4d0c886d411caa32b0ba4b671ec2',	'+14062509831',	'completed',	60,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE00000a81c1d4a504343173b6182de127',	0,	0,	'',	''),
(1428,	'CA7cdc81f8bf4c9d5dc1cba1c777e8b0f6',	'',	'2017-12-08 16:28:08',	'US',	'',	'TX',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19513881049',	'+19403040735',	'+19513881049',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA7cdc81f8bf4c9d5dc1cba1c777e8b0f6',	'+12146953999',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1429,	'CA816d85a539b1702614e8284aa91f6deb',	'',	'2017-12-08 17:11:14',	'US',	'75202',	'TX',	'DALLAS',	'US',	'46404',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12197811697',	'+12149221949',	'+12197811697',	NULL,	NULL,	NULL,	NULL,	'GARY',	'IN',	'CA816d85a539b1702614e8284aa91f6deb',	'+12183160029',	'completed',	90,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE9e2e004d37200249f791dff8fce98713',	0,	0,	'',	''),
(1430,	'CA30914025cd279730c7d00b9fae1ae3cd',	'',	'2017-12-08 22:25:40',	'US',	'',	'CA',	'',	'US',	'97113',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15036155301',	'+19513741928',	'+15036155301',	NULL,	NULL,	NULL,	NULL,	'HILLSBORO',	'OR',	'CAd8a998f30bf2aeec8c4c8bbcd40c0966',	'+14062509831',	'voicemail',	2,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE94383f0c5273cd9540d6ebf13675b9a2',	0,	0,	'',	''),
(1431,	'CAcd417fe3f72d98c6a803867f547931f7',	'',	'2017-12-08 22:46:27',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14152663393',	'+19513741928',	'+14152663393',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAcd417fe3f72d98c6a803867f547931f7',	'+14062509831',	'completed',	14,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE8678a889cc1125fea0ad3853c8db8e80',	0,	0,	'',	''),
(1432,	'CA39d9f8ab093e291e52d58ebb9e8ae996',	'',	'2017-12-10 03:03:49',	'US',	'95822',	'CA',	'SACRAMENTO',	'LS',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19162627163',	'+266696687',	NULL,	NULL,	NULL,	NULL,	'',	'',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1433,	'CAa8fca29678d316982fcb1a3236ccc613',	'',	'2017-12-11 17:28:49',	'US',	'',	'CA',	'',	'US',	'90265',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13105799716',	'+19513741928',	'+13105799716',	NULL,	NULL,	NULL,	NULL,	'MALIBU',	'CA',	'CAa8fca29678d316982fcb1a3236ccc613',	'+14062509831',	'completed',	64,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE5e62f3ae9ffa84774d9ef799c1c2e27c',	0,	0,	'',	''),
(1434,	'CAaa39148242172f912fe46b83950aed4d',	'',	'2017-12-12 16:13:59',	'US',	'',	'TX',	'',	'US',	'30327',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14049788978',	'+14695357756',	'+14049788978',	NULL,	NULL,	NULL,	NULL,	'ATLANTA',	'GA',	'CAaa39148242172f912fe46b83950aed4d',	'+19402315995',	'completed',	201,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE61f2f5e46861362d351d1b1657453945',	0,	0,	'',	''),
(1435,	'CAc45f2b59bb211a9a64a9a9a5c48c7132',	'',	'2017-12-12 17:28:46',	'US',	'',	'TX',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18454131140',	'+18327064084',	'+18454131140',	NULL,	NULL,	NULL,	NULL,	'',	'NY',	'CAc45f2b59bb211a9a64a9a9a5c48c7132',	'+18327156360',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1436,	'CA9f38c0a90df0e7e4c12db5538003b3e1',	'',	'2017-12-12 19:04:08',	'US',	'75234',	'TX',	'CARROLLTON',	'US',	'76704',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18177569054',	'+14695578827',	'+18177569054',	NULL,	NULL,	NULL,	NULL,	'GRAPEVINE',	'TX',	'CA9f38c0a90df0e7e4c12db5538003b3e1',	'+19402315995',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1437,	'CA7284eee9686f246ee83eddc7fc0d1bcd',	'',	'2017-12-12 21:53:43',	'US',	'75258',	'TX',	'DALLAS',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18880125017',	'+12147613136',	'+18880125017',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA7284eee9686f246ee83eddc7fc0d1bcd',	'+12147096672',	'completed',	124,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE5e19d19912961b89e0cdd2b219243f89',	0,	0,	'',	''),
(1438,	'CAe3fc4e94d8cb3b06aa3331682226fa9a',	'',	'2017-12-12 23:32:52',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'98109',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+14252338984',	'+12062071678',	NULL,	NULL,	NULL,	NULL,	'SEATTLE',	'WA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1439,	'CA245598294e88fad262e7304804cebcd2',	'',	'2017-12-13 00:36:21',	'US',	'',	'CA',	'',	'US',	'92870',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13237913249',	'+19513741928',	'+13237913249',	NULL,	NULL,	NULL,	NULL,	'LOS ANGELES',	'CA',	'CA54c90aba9b410e37c134d920d0c08a67',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1440,	'CAa682167b1f866f9fd40eef0c1cba0f3f',	'',	'2017-12-13 02:39:09',	'US',	'',	'CA',	'',	'LS',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19513741928',	'+266696687',	NULL,	NULL,	NULL,	NULL,	'',	'',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1441,	'CA3606c99d7b861df26f5f5c023383d8fa',	'',	'2017-12-13 12:55:49',	'US',	'',	'TX',	'Houston',	'US',	'77627',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14095199923',	'+13462144636',	'+14095199923',	NULL,	NULL,	NULL,	NULL,	'NEDERLAND',	'TX',	'CA3606c99d7b861df26f5f5c023383d8fa',	'+13462347725',	'completed',	12,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE5ed19364655f28b03783d81d4686abe6',	0,	0,	'',	''),
(1442,	'CAdbba7cb6a7fd57b8b01e2edffdbcee2f',	'',	'2017-12-13 16:01:45',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18880125017',	'+19722036640',	'+18880125017',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CAdbba7cb6a7fd57b8b01e2edffdbcee2f',	'+19728157325',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE68d6c3402ba723460d5ee05a805b7992',	0,	0,	'',	''),
(1443,	'CAa790ff39545962967be8490fbc9461df',	'',	'2017-12-13 16:10:00',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18880125017',	'+19722036640',	'+18880125017',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CAa790ff39545962967be8490fbc9461df',	'+19728157325',	'completed',	65,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE9ac71c1cdda6d7cbc362e4843881fd61',	0,	0,	'',	''),
(1444,	'CA6f79554e14f35ad8b2217482086e1757',	'',	'2017-12-13 17:45:40',	'US',	'75258',	'TX',	'DALLAS',	'US',	'80209',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17209412026',	'+12147613136',	'+17209412026',	NULL,	NULL,	NULL,	NULL,	'DENVER',	'CO',	'CA6f79554e14f35ad8b2217482086e1757',	'+12147096672',	'no-answer',	3,	NULL,	0,	0,	'',	''),
(1445,	'CAe9aec54e6d2f21345bbe4eeac430600e',	'',	'2017-12-13 20:10:18',	'US',	'75258',	'TX',	'DALLAS',	'US',	'08232',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16092255799',	'+12147616810',	'+16092255799',	NULL,	NULL,	NULL,	NULL,	'PLEASANTVILLE',	'NJ',	'CAe9aec54e6d2f21345bbe4eeac430600e',	'+12147096672',	'completed',	75,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE8dd2b837eb5e125708d9e8d90f775343',	0,	0,	'',	''),
(1446,	'CA31756d0debb42a1c43ff4d0e193cabc6',	'',	'2017-12-13 20:13:01',	'US',	'75002',	'TX',	'ALLEN',	'IN',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+912261014512',	'+19729546137',	'+912261014512',	NULL,	NULL,	NULL,	NULL,	'Mumbai',	'Mumbai',	'CA31756d0debb42a1c43ff4d0e193cabc6',	'+19402315995',	'completed',	12,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE06de1152e5430156b6e1089af5b8ca6e',	0,	0,	'',	''),
(1447,	'CA2870e88a53ad6a4650c88275a2bf27fb',	'',	'2017-12-13 20:15:21',	'US',	'75002',	'TX',	'ALLEN',	'IN',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+912261014512',	'+19729546137',	'+912261014512',	NULL,	NULL,	NULL,	NULL,	'Mumbai',	'Mumbai',	'CA2870e88a53ad6a4650c88275a2bf27fb',	'+19402315995',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE9f56e7fdddc5c5fe080cce19035b0eb6',	0,	0,	'',	''),
(1448,	'CAfcaa87efa883c49fe7c2df03c02a8f84',	'',	'2017-12-13 20:16:06',	'US',	'',	'TX',	'',	'IN',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+912261014512',	'+14695356962',	'+912261014512',	NULL,	NULL,	NULL,	NULL,	'Mumbai',	'Mumbai',	'CAfcaa87efa883c49fe7c2df03c02a8f84',	'+19402315995',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf33ab191d87935a04e8ac7f94a16e57e',	0,	0,	'',	''),
(1449,	'CA53490157f22bd8ce2bf1d75e35a93512',	'',	'2017-12-13 23:26:44',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75182',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19722031661',	'+19722036218',	'+19722031661',	NULL,	NULL,	NULL,	NULL,	'SUNNYVALE',	'TX',	'CA53490157f22bd8ce2bf1d75e35a93512',	'+12147183718',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1450,	'CAbe2522f004b3d550725453348bef8239',	'',	'2017-12-14 16:17:50',	'US',	'',	'TX',	'',	'IN',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+912261014512',	'+14695356962',	'+912261014512',	NULL,	NULL,	NULL,	NULL,	'Mumbai',	'Mumbai',	'CAbe2522f004b3d550725453348bef8239',	'+19402315995',	'completed',	33,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE318d18126b00394d34eb0e3d34bd241c',	0,	0,	'',	''),
(1451,	'CA75f64429713ef509e4ef4e51dfff5ca8',	'',	'2017-12-14 18:49:12',	'US',	'',	'TX',	'',	'IN',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+912261014512',	'+14695356962',	'+912261014512',	NULL,	NULL,	NULL,	NULL,	'Mumbai',	'Mumbai',	'CA75f64429713ef509e4ef4e51dfff5ca8',	'+19402315995',	'completed',	34,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE084d65420a6be3ef6986e4cab2f2f3d8',	0,	0,	'',	''),
(1452,	'CA8ad46f9241396367244688c718354073',	'',	'2017-12-14 19:26:57',	'US',	'75202',	'TX',	'DALLAS',	'US',	'87507',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15056909386',	'+12149221949',	'+15056909386',	NULL,	NULL,	NULL,	NULL,	'SANTA FE',	'NM',	'CA8ad46f9241396367244688c718354073',	'+12183160029',	'completed',	46,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE62a5ce624f86dbf247570132fbaf45be',	0,	0,	'',	''),
(1453,	'CA5bc0b945e57d09ffa9dd285e45096c49',	'',	'2017-12-14 19:41:13',	'US',	'75202',	'TX',	'DALLAS',	'US',	'02472',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16172334088',	'+12149221949',	'+16172334088',	NULL,	NULL,	NULL,	NULL,	'WOBURN',	'MA',	'CA5bc0b945e57d09ffa9dd285e45096c49',	'+12183160029',	'completed',	23,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE6a0c9a7bcb436505758a58a106fd3335',	0,	0,	'',	''),
(1454,	'CA9bb3339565a8d57bc0328a12c9bfe018',	'',	'2017-12-14 21:25:44',	'US',	'75152',	'TX',	'PALMER',	'US',	'75062',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14699958980',	'+14692146402',	'+14699958980',	NULL,	NULL,	NULL,	NULL,	'IRVING',	'TX',	'CA9bb3339565a8d57bc0328a12c9bfe018',	'+12146953999',	'completed',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE0649876a1371a513ba423820f79f9c3e',	0,	0,	'',	''),
(1455,	'CAbf0c938afb8127ef19a69c45ed58aeca',	'',	'2017-12-14 22:16:46',	'US',	'75024',	'TX',	'PLANO',	'US',	'95843',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19162243237',	'+19728051470',	'+19162243237',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CAbf0c938afb8127ef19a69c45ed58aeca',	'+12146824990',	'completed',	803,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf58c742e1ba016dfa7c15248cf6f7e46',	0,	0,	'',	''),
(1456,	'CA2b602f868f320c87dda0700a1364d1a8',	'',	'2017-12-14 22:58:32',	'US',	'',	'TX',	'',	'US',	'77554',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14096329171',	'+19403040735',	'+14096329171',	NULL,	NULL,	NULL,	NULL,	'GALVESTON',	'TX',	'CA2b602f868f320c87dda0700a1364d1a8',	'+12146953999',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1457,	'CAed8109701dbad34e8e95269922c73279',	'',	'2017-12-14 23:44:11',	'US',	'75202',	'TX',	'DALLAS',	'US',	'95386',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096060026',	'+12149221949',	'+12096060026',	NULL,	NULL,	NULL,	NULL,	'MODESTO',	'CA',	'CAed8109701dbad34e8e95269922c73279',	'+12183160029',	'completed',	23,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE73a19eafced06b3fd0787741361b678a',	0,	0,	'',	''),
(1458,	'CA645bd27ce10ad2f7219118bd599acfb6',	'',	'2017-12-15 00:32:11',	'US',	'75202',	'TX',	'DALLAS',	'US',	'95386',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096060026',	'+12149221949',	'+12096060026',	NULL,	NULL,	NULL,	NULL,	'MODESTO',	'CA',	'CA645bd27ce10ad2f7219118bd599acfb6',	'+12183160029',	'completed',	29,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb3adeb8f317b04382492faa485e130ca',	0,	0,	'',	''),
(1459,	'CAa6609078bb2cb8eac0af6cdae6aec544',	'',	'2017-12-15 17:08:29',	'US',	'',	'TX',	'',	'US',	'56425',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12183160029',	'+14697784620',	'+12183160029',	NULL,	NULL,	NULL,	NULL,	'BRAINERD',	'MN',	'CAa6609078bb2cb8eac0af6cdae6aec544',	'+12146953999',	'completed',	30,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb182081fe076d7df9df9fd5187dcfb3f',	0,	0,	'',	''),
(1460,	'CAd748791229d82d5960e81c200a7cf90d',	'',	'2017-12-15 17:09:37',	'US',	'',	'TX',	'',	'US',	'56425',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12183160029',	'+14697784620',	'+12183160029',	NULL,	NULL,	NULL,	NULL,	'BRAINERD',	'MN',	'CAd748791229d82d5960e81c200a7cf90d',	'+12146953999',	'completed',	32,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE135f44761e3a67862c5c25ab064ff544',	0,	0,	'',	''),
(1461,	'CAe43e0eef8b3859ecf5b64c05e5393055',	'',	'2017-12-15 17:14:34',	'US',	'75202',	'TX',	'DALLAS',	'US',	'59903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14062509831',	'+12149221949',	'+14062509831',	NULL,	NULL,	NULL,	NULL,	'KALISPELL',	'MT',	'CAe43e0eef8b3859ecf5b64c05e5393055',	'+12183160029',	'completed',	23,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc1b9307df87ad8591200bacf4c0e4a1f',	0,	0,	'',	''),
(1462,	'CAa6a013de70d4496b2a2466dfcce1c984',	'',	'2017-12-15 17:51:27',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14152663393',	'+19513741928',	'+14152663393',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA2ed9445b7a1e1cf7ca70681905b04f59',	'+14062509831',	'voicemail',	46,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb9be546f4a64c913dab4f53728acd671',	0,	0,	'',	''),
(1463,	'CA77635eaa51264ba4105b4fbc8c21cd2b',	'',	'2017-12-15 22:02:29',	'US',	'',	'TX',	'',	'US',	'71106',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13183640636',	'+14695303089',	'+13183640636',	NULL,	NULL,	NULL,	NULL,	'SHREVEPORT',	'LA',	'CA77635eaa51264ba4105b4fbc8c21cd2b',	'+14695853442',	'completed',	44,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf10c71e4f596d0060121605672b82214',	0,	0,	'',	''),
(1464,	'CA110b374fbe121e0ea0e625e5eacb7193',	'',	'2017-12-18 00:47:39',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18002395701',	'+19513741928',	'+18002395701',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA61f71a14deb8bd4339e5e3bf1a625ce0',	'+14062509831',	'voicemail',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa4e2ac6bc145a284e0a642b156c081b8',	0,	0,	'',	''),
(1465,	'CA894f73e03925b5c85e48d27fe3ad7dfb',	'',	'2017-12-18 02:51:09',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75062',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19728152220',	'+19722036218',	'+19728152220',	NULL,	NULL,	NULL,	NULL,	'IRVING',	'TX',	'CA894f73e03925b5c85e48d27fe3ad7dfb',	'+12147183718',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1466,	'CAecaa2d237aed02e0acc6cf0ebdd0de49',	'',	'2017-12-18 17:37:31',	'US',	'',	'TX',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18557933877',	'+19403040735',	'+18557933877',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CAecaa2d237aed02e0acc6cf0ebdd0de49',	'+12146953999',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE84645a24d2764d7107805fc153344bdb',	0,	0,	'',	''),
(1467,	'CAe1b260c6ac3c51642492e5f59391d694',	'',	'2017-12-18 17:37:47',	'US',	'73163',	'OK',	'OKLAHOMA CITY',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18557933877',	'+14052001376',	'+18557933877',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CAe1b260c6ac3c51642492e5f59391d694',	'+14058162887',	'completed',	88,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE302988fadece2cc3a5a4e34124edb1cc',	0,	0,	'',	''),
(1468,	'CA67f2a9487bfbc79d6c77591d26bde735',	'',	'2017-12-18 17:37:54',	'US',	'76227',	'TX',	'AUBREY',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18557933877',	'+19404881693',	'+18557933877',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA67f2a9487bfbc79d6c77591d26bde735',	'+19727954260',	'completed',	77,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe0269d0c61e99952da0e7e7d976f4106',	0,	0,	'',	''),
(1469,	'CA0422248efe4a715e0b1d8c2424f723b3',	'',	'2017-12-18 17:38:41',	'US',	'76210',	'TX',	'DENTON',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18557933877',	'+19402203539',	'+18557933877',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA0422248efe4a715e0b1d8c2424f723b3',	'+19727954260',	'busy',	NULL,	NULL,	0,	0,	'',	''),
(1470,	'CA6dd4dd3bbdd32d081183db1467ab53d3',	'',	'2017-12-18 17:55:25',	'US',	'',	'TX',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18557933877',	'+14692084950',	'+18557933877',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA6dd4dd3bbdd32d081183db1467ab53d3',	'+19727954260',	'completed',	85,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE36c9347ea8fe247d4480f1c03e89e97c',	0,	0,	'',	''),
(1471,	'CA95a5e804d0c2ee16e56933161e3c46d3',	'',	'2017-12-18 17:55:32',	'US',	'75234',	'TX',	'CARROLLTON',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18557933877',	'+14695578827',	'+18557933877',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA95a5e804d0c2ee16e56933161e3c46d3',	'+19402315995',	'completed',	95,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE6c186d83fa21a039d9810f65ff2f2134',	0,	0,	'',	''),
(1472,	'CAea3a839e9eeabfbfa8ad70ba182cb4aa',	'',	'2017-12-18 17:55:43',	'US',	'73149',	'OK',	'OKLAHOMA CITY',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18557933877',	'+14052469760',	'+18557933877',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CAea3a839e9eeabfbfa8ad70ba182cb4aa',	'+14058162887',	'completed',	77,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd2e598b804f6732b59308aa383f6dcf7',	0,	0,	'',	''),
(1473,	'CA9fad2ade3e2494d9b9512d681649e1ea',	'',	'2017-12-18 18:08:32',	'US',	'75201',	'TX',	'DALLAS',	'US',	'29204',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18032239288',	'+14696190565',	'+18032239288',	NULL,	NULL,	NULL,	NULL,	'COLUMBIA',	'SC',	'CA9fad2ade3e2494d9b9512d681649e1ea',	'+12146953999',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE39dd4100b35b7159e088fd93c89f15d3',	0,	0,	'',	''),
(1474,	'CA5422206ba1e8d9bc65db9124c57c8246',	'',	'2017-12-18 21:04:31',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'98337',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13607121110',	'+14252338984',	'+13607121110',	NULL,	NULL,	NULL,	NULL,	'BREMERTON',	'WA',	'CA6b26e532d30e72fde79a2cdd085f4713',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1475,	'CAaaa944ddd370b18f59838ae144fcaf54',	'',	'2017-12-18 21:09:26',	'US',	'',	'CA',	'',	'US',	'32766',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14072780836',	'+19513741928',	'+14072780836',	NULL,	NULL,	NULL,	NULL,	'OVIEDO',	'FL',	'CA6e1e12d027bb215d4b722ef3ae9a44dd',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1476,	'CA61e41df5ec5a9bb271aad0ec870c11ea',	'',	'2017-12-18 21:48:17',	'US',	'73106',	'OK',	'OKLAHOMA CITY',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14708689422',	'+14052125687',	'+14708689422',	NULL,	NULL,	NULL,	NULL,	'ATLANTA',	'GA',	'CA61e41df5ec5a9bb271aad0ec870c11ea',	'+14052014241',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1477,	'CA81e21b3c7e170fc5caa664dc18b7b412',	'',	'2017-12-19 00:10:43',	'US',	'75201',	'TX',	'DALLAS',	'US',	'32216',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19043980080',	'+14696190565',	'+19043980080',	NULL,	NULL,	NULL,	NULL,	'JACKSONVILLE',	'FL',	'CA81e21b3c7e170fc5caa664dc18b7b412',	'+12146953999',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE23930b2accbd6483f6979f8bd58680a6',	0,	0,	'',	''),
(1478,	'CA2f66b9ab26509abb3f0697f045ea822e',	'',	'2017-12-19 19:22:53',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'93308',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16615885855',	'+16612439350',	'+16615885855',	NULL,	NULL,	NULL,	NULL,	'BAKERSFIELD',	'CA',	'CA54972e221f381a95e76567f41e6ca492',	'+14062509831',	'voicemail',	19,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE711e767175b4a51f9f63d79ea2d57eab',	0,	0,	'',	''),
(1479,	'CAe4f6a000edfcafeb073b259158817198',	'',	'2017-12-19 19:57:25',	'US',	'',	'CA',	'',	'US',	'92123',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16197283566',	'+19513741928',	'+16197283566',	NULL,	NULL,	NULL,	NULL,	'SAN DIEGO',	'CA',	'CA0967a46badabee07381c417d921d5acb',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1480,	'CA69aa844ba9d2153703cdb2a086ce12f4',	'',	'2017-12-19 21:12:19',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19514040081',	'+19513741928',	'+19514040081',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAc938d105ca2303d1ee451c3c375f1042',	'+14062509831',	'voicemail',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE8bb13dfca5c2d7b8c8813a8b14613b17',	0,	0,	'',	''),
(1481,	'CAeaf1e20acd9df61223b9cc22a089c443',	'',	'2017-12-19 22:59:32',	'US',	'',	'CA',	'',	'US',	'93562',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17603726466',	'+19513741928',	'+17603726466',	NULL,	NULL,	NULL,	NULL,	'TRONA',	'CA',	'CAe6e5e3391ae011ab67e5a7dc66ad3657',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1482,	'CA3055392e51e60bec72cf9c600d911315',	'',	'2017-12-20 17:22:43',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'76012',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18175229964',	'+19722036640',	'+18175229964',	NULL,	NULL,	NULL,	NULL,	'ARLINGTON',	'TX',	'CA3055392e51e60bec72cf9c600d911315',	'+19728157325',	'completed',	18,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE5651a44aba23b16fa05675236b711e30',	0,	0,	'',	''),
(1483,	'CA2dcfb372e30ee981dde79a8b6cb2f8b6',	'',	'2017-12-20 17:36:26',	'US',	'',	'CA',	'',	'US',	'93562',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17603726466',	'+19513741928',	'+17603726466',	NULL,	NULL,	NULL,	NULL,	'TRONA',	'CA',	'CAc0ee253a487653299d606329eec6b281',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1484,	'CA59ff270badc259f765caff5513c8516e',	'',	'2017-12-20 22:16:28',	'US',	'75152',	'TX',	'PALMER',	'US',	'75094',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14693669560',	'+14692146402',	'+14693669560',	NULL,	NULL,	NULL,	NULL,	'PLANO',	'TX',	'CA59ff270badc259f765caff5513c8516e',	'+12146953999',	'completed',	26,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE8562435c57875e66b6be066d6baa3ac4',	0,	0,	'',	''),
(1485,	'CAfdabfc0ca579bdc0c13212c84d8805f2',	'',	'2017-12-21 00:24:54',	'US',	'92123',	'CA',	'SAN DIEGO',	'US',	'74740',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15805429233',	'+16194323549',	'+15805429233',	NULL,	NULL,	NULL,	NULL,	'ENID',	'OK',	'CAfdabfc0ca579bdc0c13212c84d8805f2',	'+16198233047',	'completed',	39,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE595430e1c52280711b57a3a85f9acfcb',	0,	0,	'',	''),
(1486,	'CA95f20a0fbbe59d28000089dece0e4dfc',	'',	'2017-12-21 15:07:38',	'US',	'75082',	'TX',	'DALLAS',	'US',	'75234',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19728856815',	'+19723625222',	'+19728856815',	NULL,	NULL,	NULL,	NULL,	'PALMER',	'TX',	'CA95f20a0fbbe59d28000089dece0e4dfc',	'+12147183718',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1487,	'CAc281e56b863c8177f2affe028a7d5e69',	'',	'2017-12-21 16:24:52',	'US',	'',	'TX',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13463213245',	'+19403040735',	'+13463213245',	NULL,	NULL,	NULL,	NULL,	'Houston',	'TX',	'CAc281e56b863c8177f2affe028a7d5e69',	'+12146953999',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1488,	'CA357953072c7f135e27e0c3da7eaf2ff9',	'',	'2017-12-21 18:47:31',	'US',	'92123',	'CA',	'SAN DIEGO',	'US',	'19952',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13027868793',	'+16194323549',	'+13027868793',	NULL,	NULL,	NULL,	NULL,	'HARRINGTON',	'DE',	'CA357953072c7f135e27e0c3da7eaf2ff9',	'+16198233047',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1489,	'CA432985c3d6438fa549e10648f31e5509',	'',	'2017-12-21 19:02:30',	'US',	'',	'CA',	'',	'US',	'08648',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16099517197',	'+19165070189',	'+16099517197',	NULL,	NULL,	NULL,	NULL,	'PRINCETON',	'NJ',	'CA432985c3d6438fa549e10648f31e5509',	'+19164825834',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1490,	'CA2146eb3d988ea9ab957decb7a973db14',	'',	'2017-12-21 22:30:11',	'US',	'',	'TX',	'',	'US',	'02199',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17743716158',	'+19403040764',	'+17743716158',	NULL,	NULL,	NULL,	NULL,	'BOSTON',	'MA',	'CA2146eb3d988ea9ab957decb7a973db14',	'+16172334088',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1491,	'CA67de0398df73a568371fe9530c1b2c6f',	'',	'2017-12-21 22:41:07',	'US',	'',	'TX',	'',	'US',	'20613',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12407878914',	'+18327064084',	'+12407878914',	NULL,	NULL,	NULL,	NULL,	'BRANDYWINE',	'MD',	'CA67de0398df73a568371fe9530c1b2c6f',	'+18327156360',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1492,	'CA6c877e7397dc3562f0d85ec43bfb0cb1',	'',	'2017-12-22 00:05:10',	'US',	'92123',	'CA',	'SAN DIEGO',	'US',	'92123',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16194329751',	'+16194323549',	'+16194329751',	NULL,	NULL,	NULL,	NULL,	'SAN DIEGO',	'CA',	'CA6c877e7397dc3562f0d85ec43bfb0cb1',	'+16198233047',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE57020d20fa612cfc8d06fb0467888248',	0,	0,	'',	''),
(1493,	'CA0550341a6eb89deaea33192781b91d78',	'',	'2017-12-22 01:08:53',	'US',	'75234',	'TX',	'CARROLLTON',	'US',	'76704',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18177562110',	'+14695578827',	'+18177562110',	NULL,	NULL,	NULL,	NULL,	'GRAPEVINE',	'TX',	'CA0550341a6eb89deaea33192781b91d78',	'+19402315995',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE6ef9a96ac3bcc5d49bb3ee41917435ea',	0,	0,	'',	''),
(1494,	'CA27debbafc2cff57ca305a0d79dac9172',	'',	'2017-12-22 15:10:59',	'US',	'75152',	'TX',	'PALMER',	'US',	'75062',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14699958980',	'+14692146402',	'+14699958980',	NULL,	NULL,	NULL,	NULL,	'IRVING',	'TX',	'CA27debbafc2cff57ca305a0d79dac9172',	'+12146953999',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1495,	'CA946cfd91e5907479bdaf5bd1f5220907',	'',	'2017-12-22 16:14:27',	'US',	'',	'TX',	'',	'US',	'11751',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16312108967',	'+19403040735',	'+16312108967',	NULL,	NULL,	NULL,	NULL,	'ISLIP',	'NY',	'CA946cfd91e5907479bdaf5bd1f5220907',	'+12146953999',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1496,	'CA3fa049ae76579790a01e43e05a4f46db',	'',	'2017-12-22 16:24:38',	'US',	'76210',	'TX',	'DENTON',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14692709057',	'+19402203539',	'+14692709057',	NULL,	NULL,	NULL,	NULL,	'',	'TX',	'CA3fa049ae76579790a01e43e05a4f46db',	'+19727954260',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1497,	'CAb3d532904dc483570528873bc55fcc89',	'',	'2017-12-23 21:05:44',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95833',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19168027980',	'+19162627163',	'+19168027980',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CAd2e9bb48b74b6dbd477d99955123e1ed',	'+14062509831',	'voicemail',	28,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE95e16a05be463d47cf563e3d357a81e4',	0,	0,	'',	''),
(1498,	'CA6f497d1c828b5813867dd38e50ceb094',	'',	'2017-12-24 15:32:14',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95833',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19168027980',	'+19162627163',	'+19168027980',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CA6f497d1c828b5813867dd38e50ceb094',	'+14062509831',	'completed',	51,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe98ce0ef9ad7813e9c9cc40185139726',	0,	0,	'',	''),
(1499,	'CA10a81f08abaf23598965511b06b4085e',	'',	'2017-12-26 17:35:36',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'31705',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12293386004',	'+19722036659',	'+12293386004',	NULL,	NULL,	NULL,	NULL,	'ALBANY',	'GA',	'CA10a81f08abaf23598965511b06b4085e',	'+12147183718',	'completed',	75,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE6d479fbfe7ae26e8baa4ff6ec22d554f',	0,	0,	'',	''),
(1500,	'CA88077f9b89b9080c57e8cd5b0fb17dfb',	'',	'2017-12-26 19:14:11',	'US',	'',	'TX',	'',	'US',	'75104',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14695231404',	'+14695303089',	'+14695231404',	NULL,	NULL,	NULL,	NULL,	'CEDAR HILL',	'TX',	'CA88077f9b89b9080c57e8cd5b0fb17dfb',	'+14695853442',	'completed',	87,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE38172d93835f04d944c01c5f5dea0b84',	0,	0,	'',	''),
(1501,	'CA2202ab3dde16cdff556072278264bf1f',	'',	'2017-12-26 21:25:58',	'US',	'',	'TX',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18454131105',	'+14696172969',	'+18454131105',	NULL,	NULL,	NULL,	NULL,	'',	'NY',	'CA2202ab3dde16cdff556072278264bf1f',	'+16172334088',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1502,	'CAddf7734259282e9c876c37a08dff599c',	'',	'2017-12-26 22:45:54',	'US',	'75202',	'TX',	'DALLAS',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18135154526',	'+12149221949',	'+18135154526',	NULL,	NULL,	NULL,	NULL,	'',	'FL',	'CAddf7734259282e9c876c37a08dff599c',	'+12183160029',	'completed',	16,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE689f2440d1cc8717505fa007060555ba',	0,	0,	'',	''),
(1503,	'CAfc28e077f07dd6d3f420c7a69dea746c',	'',	'2017-12-27 01:12:14',	'US',	'',	'CA',	'',	'US',	'95842',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19165018751',	'+19165070036',	'+19165018751',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CAfc28e077f07dd6d3f420c7a69dea746c',	'+19166123733',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1504,	'CA516b35431501e33775902dbe9c1aa2a5',	'',	'2017-12-27 16:32:27',	'US',	'88240',	'NM',	'JAL',	'US',	'08026',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18565431151',	'+15053955486',	'+18565431151',	NULL,	NULL,	NULL,	NULL,	'STRATFORD',	'NJ',	'CA516b35431501e33775902dbe9c1aa2a5',	'+15056909386',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1505,	'CAe531398b871607757d54e3ccfc9ece60',	'',	'2017-12-27 18:50:32',	'US',	'95619',	'CA',	'LINCOLN',	'US',	'95838',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19165997525',	'+19162956335',	'+19165997525',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CAe531398b871607757d54e3ccfc9ece60',	'+19163975518',	'completed',	50,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf51e3caddb9f5fa0d06fb8debd7eb3f6',	0,	0,	'',	''),
(1506,	'CA28afa5ddc3c4187a328f3ac29541bd1a',	'',	'2017-12-27 20:31:48',	'US',	'',	'TX',	'',	'US',	'23414',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17576659121',	'+19403040764',	'+17576659121',	NULL,	NULL,	NULL,	NULL,	'PARKSLEY',	'VA',	'CA28afa5ddc3c4187a328f3ac29541bd1a',	'+16172334088',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1507,	'CAe873603e051412d781affa2acb6c4910',	'',	'2017-12-27 20:41:42',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'33155',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13052227913',	'+16612439350',	'+13052227913',	NULL,	NULL,	NULL,	NULL,	'MIAMI',	'FL',	'CA79242d9a95f02dd6ace8667d80a67d06',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1508,	'CAa03199e92453193a9b9efa221f13e6cb',	'',	'2017-12-27 20:42:18',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'33155',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13052227913',	'+16612439350',	'+13052227913',	NULL,	NULL,	NULL,	NULL,	'MIAMI',	'FL',	'CAa03199e92453193a9b9efa221f13e6cb',	'+14062509831',	'completed',	52,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb5b753489e2028aab9d50d773accdb85',	0,	0,	'',	''),
(1509,	'CA74ca33507fbeda19cbeec9c5bd6fa0bc',	'',	'2017-12-27 21:08:29',	'US',	'',	'TX',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12243139245',	'+18327064084',	'+12243139245',	NULL,	NULL,	NULL,	NULL,	'',	'IL',	'CA74ca33507fbeda19cbeec9c5bd6fa0bc',	'+18327156360',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1510,	'CAcd81dcc6dcbc6525ba1e573172dcb7b7',	'',	'2017-12-28 16:41:32',	'US',	'95619',	'CA',	'LINCOLN',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17378742833',	'+19162956531',	'+17378742833',	NULL,	NULL,	NULL,	NULL,	'',	'TX',	'CAcd81dcc6dcbc6525ba1e573172dcb7b7',	'+19163975518',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1511,	'CA5dcf1758ef109947b5036a0c4832acf7',	'',	'2017-12-28 18:21:14',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'33155',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13052227913',	'+19162627163',	'+13052227913',	NULL,	NULL,	NULL,	NULL,	'MIAMI',	'FL',	'CA5dcf1758ef109947b5036a0c4832acf7',	'+14062509831',	'completed',	53,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE5790d4ea459c91e83e04a41b48c3a700',	0,	0,	'',	''),
(1512,	'CAb32900fe56537fc7305c867e24e0e1c6',	'',	'2017-12-28 18:42:45',	'US',	'95619',	'CA',	'LINCOLN',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13463152370',	'+19162956335',	'+13463152370',	NULL,	NULL,	NULL,	NULL,	'Houston',	'TX',	'CAb32900fe56537fc7305c867e24e0e1c6',	'+19163975518',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1513,	'CA4bae898ea354e401f7582d596cec1cb1',	'',	'2017-12-28 19:15:02',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13466171271',	'+19165070036',	'+13466171271',	NULL,	NULL,	NULL,	NULL,	'Houston',	'TX',	'CA4bae898ea354e401f7582d596cec1cb1',	'+19166123733',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1514,	'CA41993487050d5b2048c86b6e6572a9b7',	'',	'2017-12-28 19:25:31',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13464021215',	'+19165849538',	'+13464021215',	NULL,	NULL,	NULL,	NULL,	'Houston',	'TX',	'CA41993487050d5b2048c86b6e6572a9b7',	'+19162243237',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1515,	'CA12501bcd7df4d666f425a7ac92ff4e99',	'',	'2017-12-28 19:44:16',	'US',	'95619',	'CA',	'LINCOLN',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19514470383',	'+19162956531',	'+19514470383',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA12501bcd7df4d666f425a7ac92ff4e99',	'+19163975518',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1516,	'CA4387053132e11830cc1748e6a6ed27d4',	'',	'2017-12-28 19:46:47',	'US',	'',	'CA',	'',	'US',	'30607',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17624356727',	'+19165849127',	'+17624356727',	NULL,	NULL,	NULL,	NULL,	'ATHENS',	'GA',	'CA4387053132e11830cc1748e6a6ed27d4',	'+19166287355',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1517,	'CA9edd1eb9b0b3d896858076b414a095f5',	'',	'2017-12-28 22:47:07',	'US',	'',	'NV',	'',	'US',	'89503',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17753769222',	'+17028307376',	'+17753769222',	NULL,	NULL,	NULL,	NULL,	'RENO',	'NV',	'CA9edd1eb9b0b3d896858076b414a095f5',	'+17252223264',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1518,	'CA3d2ae42e9f37fed2f511edac68967b18',	'',	'2017-12-29 00:24:06',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75182',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19722033614',	'+19722036218',	'+19722033614',	NULL,	NULL,	NULL,	NULL,	'SUNNYVALE',	'TX',	'CA3d2ae42e9f37fed2f511edac68967b18',	'+12147183718',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1519,	'CA93e6cfcea62290f09453b2f8eff61c9b',	'',	'2017-12-29 17:17:12',	'US',	'',	'TX',	'Houston',	'US',	'77032',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18322312071',	'+13462144636',	'+18322312071',	NULL,	NULL,	NULL,	NULL,	'HOUSTON',	'TX',	'CA93e6cfcea62290f09453b2f8eff61c9b',	'+13462347725',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3fa7d1024851080169f5a4dc4c653273',	0,	0,	'',	''),
(1520,	'CA9eff3250be6eacb7e3548f6e28f4bbe5',	'',	'2017-12-29 18:21:20',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'33155',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13052227913',	'+16612439350',	'+13052227913',	NULL,	NULL,	NULL,	NULL,	'MIAMI',	'FL',	'CA9eff3250be6eacb7e3548f6e28f4bbe5',	'+14062509831',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc347e7ba77a5e164cd4b9295924cbf95',	0,	0,	'',	''),
(1521,	'CA16a494438547839f355906dec4c00fdd',	'',	'2017-12-29 18:21:56',	'US',	'93308',	'CA',	'BAKERSFIELD',	'US',	'33155',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13052227913',	'+16612439350',	'+13052227913',	NULL,	NULL,	NULL,	NULL,	'MIAMI',	'FL',	'CA16a494438547839f355906dec4c00fdd',	'+14062509831',	'completed',	2,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb890b5ff9a6cd9ee847c887a66dc65a2',	0,	0,	'',	''),
(1522,	'CA057a30bf18842b6a0647d1c93d6bef00',	'',	'2017-12-29 18:58:04',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'33155',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13052227913',	'+19162627163',	'+13052227913',	NULL,	NULL,	NULL,	NULL,	'MIAMI',	'FL',	'CA057a30bf18842b6a0647d1c93d6bef00',	'+14062509831',	'completed',	52,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc032f114b9b2b36b475ea3ba4fa9b6f7',	0,	0,	'',	''),
(1523,	'CA8ba25bc40dce10bf8c92306c0e4b688e',	'',	'2017-12-29 19:35:41',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16282352079',	'+19166340519',	'+16282352079',	NULL,	NULL,	NULL,	NULL,	'San Francisco',	'CA',	'CA8ba25bc40dce10bf8c92306c0e4b688e',	'+19166287355',	'completed',	2,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REabdd379072c7cddeab33388ee051c3bf',	0,	0,	'',	''),
(1524,	'CA653cc650c05d399751e7708326cf0f94',	'',	'2017-12-30 16:11:04',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75248',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12145439298',	'+19722036640',	'+12145439298',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CA653cc650c05d399751e7708326cf0f94',	'+19728157325',	'completed',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE94dd97ad4f04449a97883d042d647fb6',	0,	0,	'',	''),
(1525,	'CAaa674e15053634fdf693a443dda4dd47',	'',	'2017-12-30 16:11:48',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75248',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12145439298',	'+19722036640',	'+12145439298',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CAaa674e15053634fdf693a443dda4dd47',	'+19728157325',	'completed',	4,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE29138c9d3b70c85e9c6fa9b8301303dd',	0,	0,	'',	''),
(1526,	'CA8e41e5a8c48210a349882331e6021797',	'',	'2018-01-02 17:16:51',	'US',	'',	'TX',	'Houston',	'US',	'77032',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18322312071',	'+13462144636',	'+18322312071',	NULL,	NULL,	NULL,	NULL,	'HOUSTON',	'TX',	'CA8e41e5a8c48210a349882331e6021797',	'+13462347725',	'completed',	101,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE74fef852da7cbc2c69d597d56f89efae',	0,	0,	'',	''),
(1527,	'CA6733f9fb3bc8140f1906b0a5a9739cc1',	'',	'2018-01-02 21:52:02',	'US',	'76210',	'TX',	'DENTON',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12106341177',	'+19405357431',	'+12106341177',	NULL,	NULL,	NULL,	NULL,	'',	'TX',	'CA6733f9fb3bc8140f1906b0a5a9739cc1',	'+16172334088',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1528,	'CAbf435980d742615fa7050ae9752b46dc',	'',	'2018-01-02 22:29:34',	'US',	'',	'AZ',	'',	'US',	'20388',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12024558888',	'+14807250833',	'+12024558888',	NULL,	NULL,	NULL,	NULL,	'WASHINGTON',	'DC',	'CAbf435980d742615fa7050ae9752b46dc',	'+14802390652',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REbdd6678a3bf235e3ba4b7f35e70b1ddf',	0,	0,	'',	''),
(1529,	'CA1dd4eb7bf7e1731d23b2330208e32f60',	'',	'2018-01-02 22:30:55',	'US',	'',	'AZ',	'',	'US',	'20388',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12024558888',	'+14807250833',	'+12024558888',	NULL,	NULL,	NULL,	NULL,	'WASHINGTON',	'DC',	'CA1dd4eb7bf7e1731d23b2330208e32f60',	'+14802390652',	'completed',	19,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE721929a024523fbe53c207c260d78e83',	0,	0,	'',	''),
(1530,	'CA60bd19aa4ebee3b98a52ae97542da366',	'',	'2018-01-02 23:33:01',	'US',	'74110',	'OK',	'TULSA',	'US',	'20388',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12024558888',	'+19186158825',	'+12024558888',	NULL,	NULL,	NULL,	NULL,	'WASHINGTON',	'DC',	'CA60bd19aa4ebee3b98a52ae97542da366',	'+19188009881',	'completed',	25,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE5d131c88adb1fc577df8756f0944997b',	0,	0,	'',	''),
(1531,	'CAf83b97392eb554cb198dd97c9ea1e257',	'',	'2018-01-03 20:28:30',	'US',	'75202',	'TX',	'DALLAS',	'US',	'95386',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096060026',	'+12149221949',	'+12096060026',	NULL,	NULL,	NULL,	NULL,	'MODESTO',	'CA',	'CAf83b97392eb554cb198dd97c9ea1e257',	'+12183160029',	'completed',	59,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE11eea4b0253e4404b1032fae30a2f80f',	0,	0,	'',	''),
(1532,	'CA18938e6178e4c3f2bf5ea9b70f30f39a',	'',	'2018-01-03 21:11:26',	'US',	'98104',	'WA',	'TUKWILA',	'US',	'28078',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17049120283',	'+14252338984',	'+17049120283',	NULL,	NULL,	NULL,	NULL,	'HUNTERSVILLE',	'NC',	'CA7c92e49ef30599040c08f0f9a0cf8183',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1533,	'CAd9cf8c5d02f6002a923941c3d63e3fa5',	'',	'2018-01-04 00:38:34',	'US',	'75202',	'TX',	'DALLAS',	'US',	'95386',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096060026',	'+12149221949',	'+12096060026',	NULL,	NULL,	NULL,	NULL,	'MODESTO',	'CA',	'CAd9cf8c5d02f6002a923941c3d63e3fa5',	'+12183160029',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3223c328d4dc22570e1bb2b7de440cfa',	0,	0,	'',	''),
(1534,	'CA941d23d118df73759fd34d837bf2f0ca',	'',	'2018-01-04 17:37:43',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75225',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12146836182',	'+19722036640',	'+12146836182',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CA941d23d118df73759fd34d837bf2f0ca',	'+19728157325',	'completed',	83,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb6a11414cdffe499a4d58f4ea9a64526',	0,	0,	'',	''),
(1535,	'CA5d60ed82e0b20d38822c405c2f167e18',	'',	'2018-01-04 18:42:05',	'US',	'75254',	'TX',	'DALLAS',	'US',	'75234',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14696847991',	'+19728611197',	'+14696847991',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CA5d60ed82e0b20d38822c405c2f167e18',	'+12147183718',	'completed',	54,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REbbb974f86c5fad5767c357f5e22b6a27',	0,	0,	'',	''),
(1536,	'CAacf3f6059114067372f349639bf2103b',	'',	'2018-01-04 19:08:34',	'US',	'75202',	'TX',	'DALLAS',	'US',	'76012',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18178814663',	'+12149221949',	'+18178814663',	NULL,	NULL,	NULL,	NULL,	'ARLINGTON',	'TX',	'CAacf3f6059114067372f349639bf2103b',	'+12183160029',	'completed',	1911,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd443b543c999951bc404c0cd4091fece',	0,	0,	'',	''),
(1537,	'CAd58127369af0eab1aad2d7bf4f22c73d',	'',	'2018-01-04 20:20:45',	'US',	'75002',	'TX',	'ALLEN',	'US',	'76010',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16822367585',	'+19729546080',	'+16822367585',	NULL,	NULL,	NULL,	NULL,	'ARLINGTON',	'TX',	'CAd58127369af0eab1aad2d7bf4f22c73d',	'+12147183718',	'completed',	19,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE2a85610e23a71f19a5622159e1894d0a',	0,	0,	'',	''),
(1538,	'CA17f43c54bcfcf2487f743b867d6f4d46',	'',	'2018-01-04 21:31:19',	'US',	'75002',	'TX',	'ALLEN',	'US',	'76010',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16822367585',	'+19729546080',	'+16822367585',	NULL,	NULL,	NULL,	NULL,	'ARLINGTON',	'TX',	'CA17f43c54bcfcf2487f743b867d6f4d46',	'+12147183718',	'completed',	26,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf6ad0659e852abe46d564587cb1ac263',	0,	0,	'',	''),
(1539,	'CA650590b0688d5b5cddf7382d8292b64d',	'',	'2018-01-04 21:31:42',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75287',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12147282420',	'+19722036640',	'+12147282420',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CA650590b0688d5b5cddf7382d8292b64d',	'+19728157325',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf07b488ab43f88eea12f5c99e48b6518',	0,	0,	'',	''),
(1540,	'CAc95aea5310d9968096734950ffc4d5f6',	'',	'2018-01-05 04:42:32',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18006446415',	'+19162627163',	'+18006446415',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CAc7210dbb6f076e70a2125a2bcc5b1a98',	'+14062509831',	'voicemail',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE46fa726a3c4ddba20edf510b84c8963a',	0,	0,	'',	''),
(1541,	'CAdb7b0e307423112ec456c68155164aac',	'',	'2018-01-05 17:32:33',	'US',	'75244',	'TX',	'DALLAS',	'US',	'75052',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19722078919',	'+19729190409',	'+19722078919',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CAdb7b0e307423112ec456c68155164aac',	'+19728157325',	'completed',	343,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE8a7f0d37c5ca157ba92edc744e735b77',	0,	0,	'',	''),
(1542,	'CA3749eb5fe54b1ade082f5af32c35f548',	'',	'2018-01-05 20:23:43',	'US',	'',	'NV',	'',	'US',	'89074',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17023318335',	'+17028196450',	'+17023318335',	NULL,	NULL,	NULL,	NULL,	'HENDERSON',	'NV',	'CA3749eb5fe54b1ade082f5af32c35f548',	'+17252223264',	'completed',	47,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE7004bb4d54b38327d9f6dd92a468274e',	0,	0,	'',	''),
(1543,	'CA7fd1f88c0e668b7f45f5a1a36bb896a3',	'',	'2018-01-05 22:14:47',	'US',	'76210',	'TX',	'DENTON',	'US',	'76107',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19404353434',	'+19402932113',	'+19404353434',	NULL,	NULL,	NULL,	NULL,	'FORT WORTH',	'TX',	'CA7fd1f88c0e668b7f45f5a1a36bb896a3',	'+12146953999',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1544,	'CAa34870bec02f76df3c463261e9c4741c',	'',	'2018-01-05 22:17:48',	'US',	'76210',	'TX',	'DENTON',	'US',	'76107',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19404353434',	'+19402932113',	'+19404353434',	NULL,	NULL,	NULL,	NULL,	'FORT WORTH',	'TX',	'CAa34870bec02f76df3c463261e9c4741c',	'+12146953999',	'completed',	577,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE64dd544ccbb3dd15318e58f84e29deeb',	0,	0,	'',	''),
(1545,	'CA865faa0a921aeb86ebe7714f3e05bd15',	'',	'2018-01-06 17:11:26',	'US',	'',	'TX',	'',	'US',	'56425',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12183160029',	'+14697784620',	'+12183160029',	NULL,	NULL,	NULL,	NULL,	'BRAINERD',	'MN',	'CA865faa0a921aeb86ebe7714f3e05bd15',	'+12146953999',	'completed',	362,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE94b68d72cd32369eeeafe6bbd6b31698',	0,	0,	'',	''),
(1546,	'CA4d1ec1b2bc0cc4104edb90b63b650a45',	'',	'2018-01-08 17:20:20',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75225',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12146836182',	'+19722036640',	'+12146836182',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CA4d1ec1b2bc0cc4104edb90b63b650a45',	'+19728157325',	'completed',	36,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE1987b4678184094fec999615b50c337f',	0,	0,	'',	''),
(1547,	'CA77dd5cb4fdb53c5215285057d34b777b',	'',	'2018-01-08 18:19:40',	'US',	'75202',	'TX',	'DALLAS',	'US',	'30336',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14042107184',	'+12149221949',	'+14042107184',	NULL,	NULL,	NULL,	NULL,	'ATLANTA',	'GA',	'CA77dd5cb4fdb53c5215285057d34b777b',	'+12183160029',	'completed',	97,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE29605f88dbd2efa3dfdcb2c6767165f7',	0,	0,	'',	''),
(1548,	'CA631f95b667f46ec710dfae596a0cfc89',	'',	'2018-01-08 18:29:29',	'US',	'73163',	'OK',	'OKLAHOMA CITY',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12026992804',	'+14052001376',	'+12026992804',	NULL,	NULL,	NULL,	NULL,	'',	'DC',	'CA631f95b667f46ec710dfae596a0cfc89',	'+14058162887',	'completed',	6,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE209aeeaecb65fd4b68f1eef3a021afc5',	0,	0,	'',	''),
(1549,	'CAd2694cd6405ca4115dab43d2bc90016d',	'',	'2018-01-09 16:59:57',	'US',	'95619',	'CA',	'LINCOLN',	'US',	'95818',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19168891387',	'+19162956335',	'+19168891387',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CAd2694cd6405ca4115dab43d2bc90016d',	'+19163975518',	'completed',	24,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REfe955af726dedf288fb39f688ed87deb',	0,	0,	'',	''),
(1550,	'CA4c4a7952b583b0f8ec571d274be6eadb',	'',	'2018-01-09 17:01:03',	'US',	'95619',	'CA',	'LINCOLN',	'US',	'95818',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19168891387',	'+19162956335',	'+19168891387',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CA4c4a7952b583b0f8ec571d274be6eadb',	'+19163975518',	'completed',	18,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REba48f1d065f48e301b0b71e9fe282cc0',	0,	0,	'',	''),
(1551,	'CA3e7bb5501d1a46dd38cd042ee6ea2130',	'',	'2018-01-09 23:03:36',	'US',	'',	'NV',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17028324623',	'+17028307376',	'+17028324623',	NULL,	NULL,	NULL,	NULL,	'',	'NV',	'CA3e7bb5501d1a46dd38cd042ee6ea2130',	'+17252223264',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1552,	'CAadb28611847627647f3663ecedd6a2c2',	'',	'2018-01-10 13:58:04',	'US',	'75201',	'TX',	'DALLAS',	'US',	'78705',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15124279057',	'+14696190565',	'+15124279057',	NULL,	NULL,	NULL,	NULL,	'AUSTIN',	'TX',	'CAadb28611847627647f3663ecedd6a2c2',	'+12146953999',	'completed',	538,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa3f6b700292a9270189c41ca5f5d1ffd',	0,	0,	'',	''),
(1553,	'CA9eec3bb356483f6c75b8bdb500ae103a',	'',	'2018-01-10 15:06:55',	'US',	'',	'TX',	'',	'US',	'75052',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14695853442',	'+14695303089',	'+14695853442',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CA9eec3bb356483f6c75b8bdb500ae103a',	'+14695853442',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1554,	'CA0d2c69a6f8ae60c05dc82ecb61cdb58d',	'',	'2018-01-10 19:37:36',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75254',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12147976669',	'+19722036640',	'+12147976669',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CA0d2c69a6f8ae60c05dc82ecb61cdb58d',	'+19728157325',	'completed',	14,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REbe7db826e0e34c0374fb7ebe42e558e4',	0,	0,	'',	''),
(1555,	'CAe777113c189c05d81274d24de3fb70fb',	'',	'2018-01-10 20:50:09',	'US',	'75202',	'TX',	'DALLAS',	'US',	'92506',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19518923026',	'+12149221949',	'+19518923026',	NULL,	NULL,	NULL,	NULL,	'RIVERSIDE',	'CA',	'CAe777113c189c05d81274d24de3fb70fb',	'+12183160029',	'completed',	106,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE7bea60dbc3823739726268029ce64e45',	0,	0,	'',	''),
(1556,	'CA6a1334e462738f2c67a2116152827409',	'',	'2018-01-11 00:27:02',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19166968594',	'+19166940377',	'+19166968594',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA6a1334e462738f2c67a2116152827409',	'+19162243237',	'completed',	12,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4c619cc3f6dd164da3399916914ca51a',	0,	0,	'',	''),
(1557,	'CA8e17003529bbc74df66bc679f675fa3d',	'',	'2018-01-11 01:17:04',	'US',	'75202',	'TX',	'DALLAS',	'US',	'92506',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19518923026',	'+12149221949',	'+19518923026',	NULL,	NULL,	NULL,	NULL,	'RIVERSIDE',	'CA',	'CA8e17003529bbc74df66bc679f675fa3d',	'+12183160029',	'completed',	389,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REdd0743d7268b75c232dff5320125bcea',	0,	0,	'',	''),
(1558,	'CA83fc0322c0a094d53698b5a777028685',	'',	'2018-01-11 01:59:18',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'95818',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19164208381',	'+19162627163',	'+19164208381',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CAdf411bbb33f3e351e978aac338e35b1b',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1559,	'CA4dc726213c53eaecf208d61169c68d6e',	'',	'2018-01-11 18:18:55',	'US',	'75202',	'TX',	'DALLAS',	'US',	'92506',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19518923026',	'+12149221949',	'+19518923026',	NULL,	NULL,	NULL,	NULL,	'RIVERSIDE',	'CA',	'CA4dc726213c53eaecf208d61169c68d6e',	'+12183160029',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REda96b2a2551b9223cacba7676f26acd0',	0,	0,	'',	''),
(1560,	'CAcb4fe146d9a2ea6f39343e6feba63555',	'',	'2018-01-11 19:51:39',	'US',	'75202',	'TX',	'DALLAS',	'US',	'92506',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19518923026',	'+12149221949',	'+19518923026',	NULL,	NULL,	NULL,	NULL,	'RIVERSIDE',	'CA',	'CAcb4fe146d9a2ea6f39343e6feba63555',	'+12183160029',	'completed',	383,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REfe31d9bbb287fa401bcf4db6c9493a34',	0,	0,	'',	''),
(1561,	'CA5bdc53e42f9cd69e7257ef289a8a0e50',	'',	'2018-01-11 20:09:42',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16812145062',	'+19513741928',	'+16812145062',	NULL,	NULL,	NULL,	NULL,	'',	'WV',	'CA1267f1dad6f5328818bb0312fba1d4d8',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1562,	'CA776b8d6e03f73a1b08cb8d425f27e59c',	'',	'2018-01-11 20:25:18',	'US',	'75202',	'TX',	'DALLAS',	'US',	'92506',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19518923026',	'+12149221949',	'+19518923026',	NULL,	NULL,	NULL,	NULL,	'RIVERSIDE',	'CA',	'CA776b8d6e03f73a1b08cb8d425f27e59c',	'+12183160029',	'completed',	106,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE04a3a5e6c2f089087ab9356c4249c068',	0,	0,	'',	''),
(1563,	'CAb7dad36cba1aff0fec6faf4f32a35012',	'',	'2018-01-11 21:22:54',	'US',	'',	'CA',	'',	'US',	'91706',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16262532629',	'+19165071330',	'+16262532629',	NULL,	NULL,	NULL,	NULL,	'GLENDORA',	'CA',	'CAb7dad36cba1aff0fec6faf4f32a35012',	'+19166123733',	'completed',	20,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REeb892e6bc05fc0b4d4e1ebe7362da768',	0,	0,	'',	''),
(1564,	'CAc161e768f68d1ac0d2a3761fde51bdb9',	'',	'2018-01-11 21:23:57',	'US',	'',	'CA',	'',	'US',	'91706',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16262532629',	'+19165071330',	'+16262532629',	NULL,	NULL,	NULL,	NULL,	'GLENDORA',	'CA',	'CAc161e768f68d1ac0d2a3761fde51bdb9',	'+19166123733',	'completed',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb2d3b2be3f31d01ecc379a04c00c5847',	0,	0,	'',	''),
(1565,	'CA51ac6674401529913f5c44fb09b8b170',	'',	'2018-01-12 18:02:13',	'US',	'75202',	'TX',	'DALLAS',	'US',	'76012',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18178814663',	'+12149221949',	'+18178814663',	NULL,	NULL,	NULL,	NULL,	'ARLINGTON',	'TX',	'CA51ac6674401529913f5c44fb09b8b170',	'+12183160029',	'completed',	12,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE6a8c1206da9466109a65ee1562cc964a',	0,	0,	'',	''),
(1566,	'CAe00e760308c6a1d0716227cc49ccd916',	'',	'2018-01-12 20:19:11',	'US',	'75202',	'TX',	'DALLAS',	'US',	'60657',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17739880777',	'+12149221949',	'+17739880777',	NULL,	NULL,	NULL,	NULL,	'CHICAGO',	'IL',	'CAe00e760308c6a1d0716227cc49ccd916',	'+12183160029',	'completed',	25,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE5483b9bcdf0c14e4041415c67ff07699',	0,	0,	'',	''),
(1567,	'CAbfd683e29db6523f57db1fc5d525fd93',	'',	'2018-01-12 20:46:17',	'US',	'75202',	'TX',	'DALLAS',	'US',	'92506',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19518923026',	'+12149221949',	'+19518923026',	NULL,	NULL,	NULL,	NULL,	'RIVERSIDE',	'CA',	'CAbfd683e29db6523f57db1fc5d525fd93',	'+12183160029',	'completed',	680,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa3886475736b47e3f2e2b6834e5385ae',	0,	0,	'',	''),
(1568,	'CA3ef550c083386330477503e942af4f9c',	'',	'2018-01-12 22:13:00',	'US',	'76092',	'TX',	'GRAPEVINE',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16823056018',	'+16822042056',	'+16823056018',	NULL,	NULL,	NULL,	NULL,	'',	'TX',	'CA3ef550c083386330477503e942af4f9c',	'+18178765655',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE2ecd7d935f71ec9dcb4716f1b7dcd757',	0,	0,	'',	''),
(1569,	'CA1de1ae0a39329bf74c10b72663a85350',	'',	'2018-01-12 22:13:36',	'US',	'76092',	'TX',	'GRAPEVINE',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16823056018',	'+16822042056',	'+16823056018',	NULL,	NULL,	NULL,	NULL,	'',	'TX',	'CA1de1ae0a39329bf74c10b72663a85350',	'+18178765655',	'completed',	27,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE5534cb6c5dfe4ac7d2addf1ce7261e74',	0,	0,	'',	''),
(1570,	'CA40e3fd14cef755a9f7c9d5aba879acb4',	'',	'2018-01-12 23:21:26',	'US',	'95822',	'CA',	'SACRAMENTO',	'US',	'90670',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13233204991',	'+19162627163',	'+13233204991',	NULL,	NULL,	NULL,	NULL,	'SANTA FE SPRINGS',	'CA',	'CA250d37ef5e5bb94a4e3f04be5ae700f2',	'+14062509831',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1571,	'CA32a6ac0f23192e8b2878d1a1afa5ef34',	'',	'2018-01-13 18:17:07',	'US',	'75024',	'TX',	'PLANO',	'US',	'75243',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12145776215',	'+19728051470',	'+12145776215',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CA32a6ac0f23192e8b2878d1a1afa5ef34',	'+12146824990',	'completed',	172,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa974900857dd11347a9806c5c7a09038',	0,	0,	'',	''),
(1572,	'CAefa2755d843eb83341863ad2404ca6e4',	'',	'2018-01-15 17:13:56',	'US',	'',	'NV',	'',	'US',	'10019',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12123727597',	'+17028196450',	'+12123727597',	NULL,	NULL,	NULL,	NULL,	'NEW YORK',	'NY',	'CAefa2755d843eb83341863ad2404ca6e4',	'+17252223264',	'completed',	36,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE8051c8a422e120e984e7f75f94652280',	0,	0,	'',	''),
(1573,	'CA3e0f543c4349113a345c74e6b4db933d',	'',	'2018-01-15 17:17:06',	'US',	'',	'NV',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17029164542',	'+17029195831',	'+17029164542',	NULL,	NULL,	NULL,	NULL,	'',	'NV',	'CA3e0f543c4349113a345c74e6b4db933d',	'+17252223264',	'completed',	16,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REccd401e2277f732176e4841eda10350f',	0,	0,	'',	''),
(1574,	'CA464b58a08e9349830c30b55780ab2d9c',	'',	'2018-01-16 05:09:00',	'US',	'75202',	'TX',	'DALLAS',	'US',	'28360',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+12149221949',	'+19106182645',	NULL,	NULL,	NULL,	NULL,	'LUMBERTON',	'NC',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1575,	'CAca387db078741be2850fb918cbb4935b',	'',	'2018-01-16 20:52:20',	'US',	'',	'TX',	'',	'US',	'78501',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19568626925',	'+14696052596',	'+19568626925',	NULL,	NULL,	NULL,	NULL,	'MCALLEN',	'TX',	'CAca387db078741be2850fb918cbb4935b',	'+12147183718',	'completed',	216,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE071660826d9d81e1b114c3eb72aea2a5',	0,	0,	'',	''),
(1576,	'CA4fd84acf81f2826571153527da438e2e',	'',	'2018-01-16 21:31:24',	'US',	'',	'TX',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14697718663',	'+14697784620',	'+14697718663',	NULL,	NULL,	NULL,	NULL,	'',	'TX',	'CA4fd84acf81f2826571153527da438e2e',	'+12146953999',	'completed',	215,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REeccbf5182d4a249a757e237014e156fe',	0,	0,	'',	''),
(1577,	'CA2445302bd7bdff57f10c509a9ff74541',	'',	'2018-01-17 18:32:10',	'US',	'',	'TX',	'',	'US',	'75254',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19726896811',	'+18327064084',	'+19726896811',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CA2445302bd7bdff57f10c509a9ff74541',	'+18327156360',	'completed',	167,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE5deb799add2155ccf8ee75573ae393bf',	0,	0,	'',	''),
(1578,	'CA8396a45dce231af0d1386539f68d1866',	'',	'2018-01-17 18:38:32',	'US',	'',	'TX',	'',	'US',	'75254',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19726896811',	'+18327064084',	'+19726896811',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CA8396a45dce231af0d1386539f68d1866',	'+18327156360',	'completed',	39,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE7bcb130a9929e8092633ca5a42db1469',	0,	0,	'',	''),
(1579,	'CA34dda49ea4ddbba987b5836357426d09',	'',	'2018-01-17 19:11:20',	'US',	'77995',	'TX',	'YOAKUM',	'US',	'77097',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18327156360',	'+13612983529',	'+18327156360',	NULL,	NULL,	NULL,	NULL,	'HOUSTON',	'TX',	'CA34dda49ea4ddbba987b5836357426d09',	'+18327156360',	'completed',	16,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa24944be58a4e49097a7de7d3ca54638',	0,	0,	'',	''),
(1580,	'CA193c6b26e35e0a0777ac9d031afad839',	'',	'2018-01-17 19:13:25',	'US',	'77995',	'TX',	'YOAKUM',	'US',	'78401',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13614615311',	'+13612983529',	'+13614615311',	NULL,	NULL,	NULL,	NULL,	'CORPUS CHRISTI',	'TX',	'CA193c6b26e35e0a0777ac9d031afad839',	'+18327156360',	'completed',	34,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REedbd5b838dea23469ae3cd6ec5fbb782',	0,	0,	'',	''),
(1581,	'CA0918f51ca2546a230cb2721c508e1dfd',	'',	'2018-01-17 19:43:17',	'US',	'73106',	'OK',	'OKLAHOMA CITY',	'US',	'73167',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14052014241',	'+14052125687',	'+14052014241',	NULL,	NULL,	NULL,	NULL,	'OKLAHOMA CITY',	'OK',	'CA0918f51ca2546a230cb2721c508e1dfd',	'+14052014241',	'completed',	6,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE839817999615a86ff4200cc15a7143cf',	0,	0,	'',	''),
(1582,	'CAf1412c384e6596872b5b2c03a531d368',	'',	'2018-01-17 19:48:06',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75050',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12148457570',	'+19722036640',	'+12148457570',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CAf1412c384e6596872b5b2c03a531d368',	'+19728157325',	'completed',	31,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REbd77052da02c98c971b56e73e512c2e0',	0,	0,	'',	''),
(1583,	'CA19c4b801ba8c038792b6cb60d74ae4ee',	'',	'2018-01-17 20:53:59',	'US',	'74055',	'OK',	'OWASSO',	'US',	'74447',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19183662100',	'+19183763961',	'+19183662100',	NULL,	NULL,	NULL,	NULL,	'BIXBY',	'OK',	'CA19c4b801ba8c038792b6cb60d74ae4ee',	'+19188009881',	'completed',	58,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE9745524532b09e54b065e92d8717d47b',	0,	0,	'',	''),
(1584,	'CA91b3420a337f8df63fe1bbb1328b4816',	'',	'2018-01-17 23:39:16',	'US',	'75201',	'TX',	'DALLAS',	'US',	'98105',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14253290788',	'+14696190565',	'+14253290788',	NULL,	NULL,	NULL,	NULL,	'MOUNTLAKE TERRACE',	'WA',	'CA91b3420a337f8df63fe1bbb1328b4816',	'+12146953999',	'completed',	46,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE96da41982168ae0625f0eba61f5667dc',	0,	0,	'',	''),
(1585,	'CA39cf290eddce8983a4122e39fc6afbc3',	'',	'2018-01-18 15:48:15',	'US',	'75201',	'TX',	'DALLAS',	'US',	'75201',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14696194257',	'+14696190565',	'+14696194257',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CA39cf290eddce8983a4122e39fc6afbc3',	'+12146953999',	'completed',	19,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd1bc0cc9e8a295a840b5896e786437d9',	0,	0,	'',	''),
(1586,	'CAe7ff20517c818e4fc8970b113c1f27b6',	'',	'2018-01-18 17:06:19',	'US',	'',	'CA',	'',	'US',	'95818',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19168210799',	'+19168238779',	'+19168210799',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CAe7ff20517c818e4fc8970b113c1f27b6',	'+19166287355',	'completed',	32,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE109780a67fc0d3af851710ecfb7e23c0',	0,	0,	'',	''),
(1587,	'CAb2d5a02d6d1007403058f9ac10047ff1',	'',	'2018-01-18 19:22:47',	'US',	'',	'NV',	'',	'US',	'89106',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17022023249',	'+17029195831',	'+17022023249',	NULL,	NULL,	NULL,	NULL,	'LAS VEGAS',	'NV',	'CAb2d5a02d6d1007403058f9ac10047ff1',	'+17252223264',	'completed',	386,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3794b74d51cd7ad2bad7da7224d1beec',	0,	0,	'',	''),
(1588,	'CA1acc10f3d3d0c92483f2455930433f91',	'',	'2018-01-18 20:54:10',	'US',	'77995',	'TX',	'YOAKUM',	'US',	'60025',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18476863308',	'+13612983529',	'+18476863308',	NULL,	NULL,	NULL,	NULL,	'NORTHBROOK',	'IL',	'CA1acc10f3d3d0c92483f2455930433f91',	'+18327156360',	'completed',	54,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE2ba4e4038f044e5c4f24e466eea6e2db',	0,	0,	'',	''),
(1589,	'CA927322a271ffded28475445d925db9b0',	'',	'2018-01-19 14:53:02',	'US',	'77995',	'TX',	'YOAKUM',	'US',	'60025',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18476863308',	'+13612983529',	'+18476863308',	NULL,	NULL,	NULL,	NULL,	'NORTHBROOK',	'IL',	'CA927322a271ffded28475445d925db9b0',	'+18327156360',	'completed',	89,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa5c3dab54db06ab185d52112ab653f25',	0,	0,	'',	''),
(1590,	'CA11bbd50eca85dbff4033a9bf87cc8b9f',	'',	'2018-01-19 18:37:09',	'US',	'75202',	'TX',	'DALLAS',	'US',	'76018',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12146628447',	'+12149221949',	'+12146628447',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CA11bbd50eca85dbff4033a9bf87cc8b9f',	'+12183160029',	'completed',	1,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe5265039e8ddd2dfbc76eb529f89840c',	0,	0,	'',	''),
(1591,	'CA9bea52afddb24f4d86897c33a2dabb3c',	'',	'2018-01-19 18:37:32',	'US',	'75202',	'TX',	'DALLAS',	'US',	'76018',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12146628447',	'+12149221949',	'+12146628447',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CA9bea52afddb24f4d86897c33a2dabb3c',	'+12183160029',	'completed',	14,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE6b5ab3896a590bb432f7f0179ccf895a',	0,	0,	'',	''),
(1592,	'CA452142d9613e1a5e91bebb6704e2aaa8',	'',	'2018-01-19 18:40:03',	'US',	'75202',	'TX',	'DALLAS',	'US',	'76018',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12146628447',	'+12149221949',	'+12146628447',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CA452142d9613e1a5e91bebb6704e2aaa8',	'+12183160029',	'completed',	1309,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe47826ba253f2f6c60b2b1ca35e465f8',	0,	0,	'',	''),
(1593,	'CA7fa5ce9371c6b187438db3abe3334041',	'',	'2018-01-19 19:03:39',	'US',	'87828',	'NM',	'SOCORRO',	'US',	'87113',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15057965544',	'+15058352287',	'+15057965544',	NULL,	NULL,	NULL,	NULL,	'ALBUQUERQUE',	'NM',	'CA7fa5ce9371c6b187438db3abe3334041',	'+15053192181',	'completed',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REdc5a2802eca588420a8752a3954c2f0c',	0,	0,	'',	''),
(1594,	'CA1c01b52c7c9dbbf5b2a74277a0b75587',	'',	'2018-01-19 20:36:27',	'US',	'',	'NV',	'',	'US',	'89106',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17024392822',	'+17028196450',	'+17024392822',	NULL,	NULL,	NULL,	NULL,	'LAS VEGAS',	'NV',	'CA1c01b52c7c9dbbf5b2a74277a0b75587',	'+17252223264',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1595,	'CA0d08fbbc6a8bd6ec698cb75cfbc544c5',	'',	'2018-01-19 20:37:17',	'US',	'',	'NV',	'',	'US',	'89106',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17024392822',	'+17028196450',	'+17024392822',	NULL,	NULL,	NULL,	NULL,	'LAS VEGAS',	'NV',	'CA0d08fbbc6a8bd6ec698cb75cfbc544c5',	'+17252223264',	'completed',	120,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE7d7c554a4e1ca77102fe061bdd57c2d5',	0,	0,	'',	''),
(1596,	'CA6ab74d1c8794aa7be8bb21697a1d0748',	'',	'2018-01-19 22:45:11',	'US',	'75202',	'TX',	'DALLAS',	'US',	'20388',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12024558888',	'+12149221949',	'+12024558888',	NULL,	NULL,	NULL,	NULL,	'WASHINGTON',	'DC',	'CA6ab74d1c8794aa7be8bb21697a1d0748',	'+12183160029',	'completed',	20,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REba7a355663ba69773c36bae169c51cf2',	0,	0,	'',	''),
(1597,	'CA1fb147fd95a48671a4a0ecbe2fec21e9',	'',	'2018-01-19 22:50:38',	'US',	'75202',	'TX',	'DALLAS',	'US',	'75070',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12145787433',	'+12149221949',	'+12145787433',	NULL,	NULL,	NULL,	NULL,	'MC KINNEY',	'TX',	'CA1fb147fd95a48671a4a0ecbe2fec21e9',	'+12183160029',	'completed',	14,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE37920b115df3afb58630360f6399a8e6',	0,	0,	'',	''),
(1598,	'CA9ea38ed7e79643da491c27bb666028c1',	'',	'2018-01-20 00:25:41',	'US',	'75202',	'TX',	'DALLAS',	'US',	'29732',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18032422492',	'+12149221949',	'+18032422492',	NULL,	NULL,	NULL,	NULL,	'ROCK HILL',	'SC',	'CA9ea38ed7e79643da491c27bb666028c1',	'+12183160029',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1599,	'CA85626b56c8b3893b0165456cf6ba3df2',	'',	'2018-01-20 01:05:57',	'US',	'77577',	'TX',	'ALVIN',	'US',	'77097',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18327156360',	'+12813934601',	'+18327156360',	NULL,	NULL,	NULL,	NULL,	'HOUSTON',	'TX',	'CA85626b56c8b3893b0165456cf6ba3df2',	'+18327156360',	'completed',	29,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE5881eadc4abec9ab0954842848040918',	0,	0,	'',	''),
(1600,	'CA56b692039cc851101be29d446b7966e7',	'',	'2018-01-20 01:09:46',	'US',	'77577',	'TX',	'ALVIN',	'US',	'77097',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18327156360',	'+12813934540',	'+18327156360',	NULL,	NULL,	NULL,	NULL,	'HOUSTON',	'TX',	'CA56b692039cc851101be29d446b7966e7',	'+18327156360',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd0fe509f6ebcda91c73e4f8748271e7c',	0,	0,	'',	''),
(1601,	'CA67caa40d67a233c2839a1e3aaa3e49ac',	'',	'2018-01-20 01:13:16',	'US',	'75202',	'TX',	'DALLAS',	'US',	'20388',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12024558888',	'+12149221949',	'+12024558888',	NULL,	NULL,	NULL,	NULL,	'WASHINGTON',	'DC',	'CA67caa40d67a233c2839a1e3aaa3e49ac',	'+12183160029',	'completed',	27,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE9c44f7bd6d2f530d5d1a6a5e85fc0869',	0,	0,	'',	''),
(1602,	'CA9e17b3e10c4eb9d5a49c7115c7018971',	'',	'2018-01-20 01:14:41',	'US',	'75202',	'TX',	'DALLAS',	'US',	'20388',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12024558888',	'+12149221949',	'+12024558888',	NULL,	NULL,	NULL,	NULL,	'WASHINGTON',	'DC',	'CA9e17b3e10c4eb9d5a49c7115c7018971',	'+12183160029',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1603,	'CAfbd11deb2299d51941e3b91dfcfbf4e7',	'',	'2018-01-20 01:38:17',	'US',	'75202',	'TX',	'DALLAS',	'US',	'59903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14062509831',	'+12149221949',	'+14062509831',	NULL,	NULL,	NULL,	NULL,	'KALISPELL',	'MT',	'CAfbd11deb2299d51941e3b91dfcfbf4e7',	'+12147851535',	'completed',	47,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE136d1bda3413b5041d4f06eaea308ff6',	0,	0,	'',	''),
(1604,	'CAd31f6705d511707a0ee1cf05270f2d3b',	'',	'2018-01-20 01:39:53',	'US',	'75202',	'TX',	'DALLAS',	'US',	'59903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14062509831',	'+12149221949',	'+14062509831',	NULL,	NULL,	NULL,	NULL,	'KALISPELL',	'MT',	'CAd31f6705d511707a0ee1cf05270f2d3b',	'+12147851535',	'completed',	14,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE2d80eef37f20a0706b3b39ad14ef4a15',	0,	0,	'',	''),
(1605,	'CA412284f73c6ec308929ae824138ade3b',	'',	'2018-01-20 14:24:21',	'US',	'75202',	'TX',	'DALLAS',	'US',	'59601',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14068711391',	'+12149221949',	'+14068711391',	NULL,	NULL,	NULL,	NULL,	'HELENA',	'MT',	'CA412284f73c6ec308929ae824138ade3b',	'+12147851535',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REdd20ad2cc7967f5c260721729fadd153',	0,	0,	'',	''),
(1606,	'CA19d036641de36523b8a8fe175a956105',	'',	'2018-01-20 16:30:06',	'US',	'75202',	'TX',	'DALLAS',	'US',	'07503',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19734893761',	'+12149221949',	'+19734893761',	NULL,	NULL,	NULL,	NULL,	'NEWARK',	'NJ',	'CA19d036641de36523b8a8fe175a956105',	'+12147851535',	'completed',	68,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf352d066501f8419f3c5337a67c64ffb',	0,	0,	'',	''),
(1607,	'CA477eff42b1c9315ae0ddadf1c8afdf4f',	'',	'2018-01-20 19:37:54',	'US',	'',	'TX',	'',	'US',	'75056',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19724926131',	'+14695357756',	'+19724926131',	NULL,	NULL,	NULL,	NULL,	'CARROLLTON',	'TX',	'CA477eff42b1c9315ae0ddadf1c8afdf4f',	'+19402315995',	'completed',	77,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE5d63c6c0da8b79873e21569f0a5c610f',	0,	0,	'',	''),
(1608,	'CA1afacb52007db4bfd9be2d44c65e7a25',	'',	'2018-01-20 19:42:51',	'US',	'',	'TX',	'',	'US',	'75062',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12142836076',	'+14695357756',	'+12142836076',	NULL,	NULL,	NULL,	NULL,	'IRVING',	'TX',	'CA1afacb52007db4bfd9be2d44c65e7a25',	'+19402315995',	'completed',	134,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc83e2c69fb751278de18f5cf897e894a',	0,	0,	'',	''),
(1609,	'CA01c348eac3310cb942c066d120ce3ac5',	'',	'2018-01-20 19:45:34',	'US',	'',	'TX',	'',	'US',	'75062',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12142836076',	'+14695357756',	'+12142836076',	NULL,	NULL,	NULL,	NULL,	'IRVING',	'TX',	'CA01c348eac3310cb942c066d120ce3ac5',	'+19402315995',	'completed',	67,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4b0854255f7d8a309181f0a5eb5a8999',	0,	0,	'',	''),
(1610,	'CA86f9b38ebc65f9cb68e2dd18b75fa9fb',	'',	'2018-01-20 19:46:50',	'US',	'',	'TX',	'',	'US',	'75062',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12142836076',	'+14695357756',	'+12142836076',	NULL,	NULL,	NULL,	NULL,	'IRVING',	'TX',	'CA86f9b38ebc65f9cb68e2dd18b75fa9fb',	'+19402315995',	'completed',	14,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE1acb9e5811acd33ecbebc12cd0c29e39',	0,	0,	'',	''),
(1611,	'CAd3fc2ed541d16f29195be35260f128a3',	'',	'2018-01-20 19:48:23',	'US',	'',	'TX',	'',	'US',	'75062',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12142836076',	'+14695357756',	'+12142836076',	NULL,	NULL,	NULL,	NULL,	'IRVING',	'TX',	'CAd3fc2ed541d16f29195be35260f128a3',	'+19402315995',	'completed',	17,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3807357b786826142a6119466e4a56f5',	0,	0,	'',	''),
(1612,	'CAf04e3719fd6bc2dbc581fb3636e3cc22',	'',	'2018-01-20 19:51:17',	'US',	'',	'TX',	'',	'US',	'75062',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12142836076',	'+14695357756',	'+12142836076',	NULL,	NULL,	NULL,	NULL,	'IRVING',	'TX',	'CAf04e3719fd6bc2dbc581fb3636e3cc22',	'+19402315995',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1613,	'CA908661117973f9a71745595957fd5e19',	'',	'2018-01-20 19:51:35',	'US',	'',	'TX',	'',	'US',	'75062',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12142836076',	'+14695357756',	'+12142836076',	NULL,	NULL,	NULL,	NULL,	'IRVING',	'TX',	'CA908661117973f9a71745595957fd5e19',	'+19402315995',	'completed',	51,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE1a27ccda02a2e4145275b8e77b11de47',	0,	0,	'',	''),
(1614,	'CA150790cedbff45f2672665e139c0de96',	'',	'2018-01-20 20:51:20',	'US',	'92085',	'CA',	'VISTA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18084644474',	'+17604073880',	'+18084644474',	NULL,	NULL,	NULL,	NULL,	'',	'HI',	'CA150790cedbff45f2672665e139c0de96',	'+17602378044',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE11fbf07b646c65113fd69e3bc26656b2',	0,	0,	'',	''),
(1615,	'CA72d3cee72fd576eff514ac111e333387',	'',	'2018-01-21 20:10:09',	'US',	'75258',	'TX',	'DALLAS',	'US',	'75752',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19032880725',	'+12147613136',	'+19032880725',	NULL,	NULL,	NULL,	NULL,	'ATHENS',	'TX',	'CA72d3cee72fd576eff514ac111e333387',	'+12147096672',	'completed',	1471,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE82645e91021a20a38e5646c95630058d',	0,	0,	'',	''),
(1616,	'CAd6f584b6523fa5a579471c2c9ebbf8c8',	'',	'2018-01-21 21:32:07',	'US',	'75202',	'TX',	'DALLAS',	'US',	'59903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14062509831',	'+12149221949',	'+14062509831',	NULL,	NULL,	NULL,	NULL,	'KALISPELL',	'MT',	'CAd6f584b6523fa5a579471c2c9ebbf8c8',	'+12147851535',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE9e7d696615eb52d5e2f6c5dd88e0e4fe',	0,	0,	'',	''),
(1617,	'CAa9cc1e13c54ac69451140f9c53e701db',	'',	'2018-01-22 00:40:54',	'US',	'75202',	'TX',	'DALLAS',	'US',	'59903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14062509831',	'+12149221949',	'+14062509831',	NULL,	NULL,	NULL,	NULL,	'KALISPELL',	'MT',	'CAa9cc1e13c54ac69451140f9c53e701db',	'+12147851535',	'completed',	33,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE9a512ee25a686d9216ff3b574e84fb8f',	0,	0,	'',	''),
(1618,	'CA8cef3b9f5e0a26881dc10f66ec7a5eb2',	'',	'2018-01-22 19:20:47',	'US',	'75202',	'TX',	'DALLAS',	'US',	'76018',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12146628447',	'+12149221949',	'+12146628447',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CA8cef3b9f5e0a26881dc10f66ec7a5eb2',	'+12147851535',	'completed',	25,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd24a26ece0b40431349fdc277bb667ff',	0,	0,	'',	''),
(1619,	'CAdc9869cdc9849d243d381858003b74b1',	'',	'2018-01-22 19:21:39',	'US',	'75202',	'TX',	'DALLAS',	'US',	'75070',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12145787433',	'+12149221949',	'+12145787433',	NULL,	NULL,	NULL,	NULL,	'MC KINNEY',	'TX',	'CAdc9869cdc9849d243d381858003b74b1',	'+12147851535',	'completed',	26,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE6f1e6ff0029cb90d3664a9b776d8b9a1',	0,	0,	'',	''),
(1620,	'CA0178d4ff14acd72474a009239fa1b9c4',	'',	'2018-01-22 21:03:57',	'US',	'75202',	'TX',	'DALLAS',	'US',	'59903',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14062509831',	'+12149221949',	'+14062509831',	NULL,	NULL,	NULL,	NULL,	'KALISPELL',	'MT',	'CA0178d4ff14acd72474a009239fa1b9c4',	'+12147851535',	'completed',	33,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE5187c655f32283fc1194e2698c80b5b3',	0,	0,	'',	''),
(1621,	'CAf10f0cac5a5121d86eb085c7dbce59a9',	'',	'2018-01-22 21:35:00',	'US',	'75077',	'TX',	'LEWISVILLE',	'US',	'75041',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19726134488',	'+14693221354',	'+19726134488',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CAf10f0cac5a5121d86eb085c7dbce59a9',	'+12147183718',	'completed',	19,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4ebbc2808bccc64ba5d8f686eb146ca7',	0,	0,	'',	''),
(1622,	'CAa2aba5184340a12f9e8d51e71217e1aa',	'',	'2018-01-22 23:27:01',	'US',	'',	'TX',	'',	'US',	'77055',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18324726200',	'+18327064084',	'+18324726200',	NULL,	NULL,	NULL,	NULL,	'HOUSTON',	'TX',	'CAa2aba5184340a12f9e8d51e71217e1aa',	'+18327156360',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1623,	'CA824ed8e6848df50114ef3bab4866508d',	'',	'2018-01-23 16:59:45',	'US',	'75202',	'TX',	'DALLAS',	'US',	'77581',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12812243001',	'+12149221949',	'+12812243001',	NULL,	NULL,	NULL,	NULL,	'HOUSTON',	'TX',	'CA824ed8e6848df50114ef3bab4866508d',	'+12147851535',	'completed',	43,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE6d72e4366e55be94b272462428cfc365',	0,	0,	'',	''),
(1624,	'CA31cfa3532e812a98bb2ba9fc22e5a2ed',	'',	'2018-01-23 17:25:00',	'US',	'75254',	'TX',	'DALLAS',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14695186129',	'+19728611197',	'+14695186129',	NULL,	NULL,	NULL,	NULL,	'',	'TX',	'CA31cfa3532e812a98bb2ba9fc22e5a2ed',	'+12147183718',	'completed',	59,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd898b4e9083a3ad172cd95ecf02f10ee',	0,	0,	'',	''),
(1625,	'CAe9c48f2c77b48b5295c867180e4099aa',	'',	'2018-01-23 17:28:26',	'US',	'87828',	'NM',	'SOCORRO',	'US',	'87113',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15057982024',	'+15058352287',	'+15057982024',	NULL,	NULL,	NULL,	NULL,	'ALBUQUERQUE',	'NM',	'CAe9c48f2c77b48b5295c867180e4099aa',	'+15053192181',	'completed',	12,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE1c0aa38b4fab8d448d2b1937a4698950',	0,	0,	'',	''),
(1626,	'CA0b927409f65596d1a242ea8525bf84b8',	'',	'2018-01-23 22:12:10',	'US',	'95762',	'CA',	'FOLSOM',	'US',	'95816',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19165600028',	'+19162358117',	'+19165600028',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CA0b927409f65596d1a242ea8525bf84b8',	'+19163975518',	'completed',	6,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd77231eba6d61dfcc3660cc18f48429d',	0,	0,	'',	''),
(1627,	'CAba542a35000904647450424bb2bd5d08',	'',	'2018-01-23 22:57:03',	'US',	'',	'AZ',	'',	'US',	'85018',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16236066866',	'+16233001626',	'+16236066866',	NULL,	NULL,	NULL,	NULL,	'PHOENIX',	'AZ',	'CAba542a35000904647450424bb2bd5d08',	'+14802390652',	'completed',	46,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc1c37e9019636965ffeaf50c8d131ffd',	0,	0,	'',	''),
(1628,	'CAb5faba22de5e570362c88d07e36e4a76',	'',	'2018-01-23 23:22:44',	'US',	'',	'CA',	'',	'US',	'92103',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14422223216',	'+19166340519',	'+14422223216',	NULL,	NULL,	NULL,	NULL,	'SAN DIEGO',	'CA',	'CAb5faba22de5e570362c88d07e36e4a76',	'+19166287355',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REcbb46ba7e8f45b52a24129d4608fc73a',	0,	0,	'',	''),
(1629,	'CAf31e980123a571cb2568b8dbb2b866b8',	'',	'2018-01-24 14:22:28',	'US',	'',	'TX',	'',	'US',	'78241',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12103346000',	'+18329814887',	'+12103346000',	NULL,	NULL,	NULL,	NULL,	'SAN ANTONIO',	'TX',	'CAf31e980123a571cb2568b8dbb2b866b8',	'+13462347725',	'completed',	86,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REced5e5221c43cdac97442b004e0734ba',	0,	0,	'',	''),
(1630,	'CA23c95558bae1039988e086239949ed7f',	'',	'2018-01-24 14:55:16',	'US',	'',	'TX',	'',	'US',	'33128',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17862093341',	'+14695303089',	'+17862093341',	NULL,	NULL,	NULL,	NULL,	'MIAMI',	'FL',	'CA23c95558bae1039988e086239949ed7f',	'+14695853442',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE7a49253b261057ded0e87445b56449b4',	0,	0,	'',	''),
(1631,	'CA0ef86668a14386fea369cfa1355d3bc6',	'',	'2018-01-24 16:07:00',	'US',	'94586',	'CA',	'SUNOL',	'US',	'20388',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12024558888',	'+19252330542',	'+12024558888',	NULL,	NULL,	NULL,	NULL,	'WASHINGTON',	'DC',	'CA0ef86668a14386fea369cfa1355d3bc6',	'+14062509831',	'completed',	31,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE8fdcaed485de71ac11ab330c3ca3bef8',	0,	0,	'',	''),
(1632,	'CAd07481ae64e47268b32236d79ce9e92e',	'',	'2018-01-24 16:36:04',	'US',	'75202',	'TX',	'DALLAS',	'US',	'75251',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14692010694',	'+12149221949',	'+14692010694',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CAd07481ae64e47268b32236d79ce9e92e',	'+12147851535',	'completed',	43,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd91954a2271357f2ac317daeb23fa598',	0,	0,	'',	''),
(1633,	'CA3bd90c4d54a8f1449910c751d88235e6',	'',	'2018-01-24 17:46:34',	'US',	'',	'TX',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14694014832',	'+14695303089',	'+14694014832',	NULL,	NULL,	NULL,	NULL,	'',	'TX',	'CA3bd90c4d54a8f1449910c751d88235e6',	'+14695853442',	'completed',	153,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REcf95d275e8cb69d4b34a000efad8376e',	0,	0,	'',	''),
(1634,	'CA50e0ee70443046a5c02ac8a5565005ed',	'',	'2018-01-24 20:49:10',	'US',	'',	'AZ',	'',	'US',	'85016',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14806568851',	'+14807250833',	'+14806568851',	NULL,	NULL,	NULL,	NULL,	'PHOENIX',	'AZ',	'CA50e0ee70443046a5c02ac8a5565005ed',	'+14802390652',	'completed',	14,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE2b0e7e7885992ec41fc1d1114d763711',	0,	0,	'',	''),
(1635,	'CA81b42308f41deef114c68f8ac9d2017f',	'',	'2018-01-25 16:56:12',	'US',	'75254',	'TX',	'DALLAS',	'US',	'33128',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17862093341',	'+19728611197',	'+17862093341',	NULL,	NULL,	NULL,	NULL,	'MIAMI',	'FL',	'CA81b42308f41deef114c68f8ac9d2017f',	'+12147183718',	'completed',	56,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE663e39a947061d8aca423e23dc1e9916',	0,	0,	'',	''),
(1636,	'CAc1411b55035ba140a6996e7b5ff68e7d',	'',	'2018-01-25 17:33:36',	'US',	'75219',	'TX',	'DALLAS',	'US',	'60546',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17087352643',	'+19725213658',	'+17087352643',	NULL,	NULL,	NULL,	NULL,	'CICERO',	'IL',	'CAc1411b55035ba140a6996e7b5ff68e7d',	'+12146824990',	'completed',	14,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REddad0732e938f8129f43568441975868',	0,	0,	'',	''),
(1637,	'CA6ac8b2e4a6242277fb30e81900fabf9d',	'',	'2018-01-25 19:00:29',	'US',	'75258',	'TX',	'DALLAS',	'US',	'94949',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14152347308',	'+12147613136',	'+14152347308',	NULL,	NULL,	NULL,	NULL,	'IGNACIO',	'CA',	'CA6ac8b2e4a6242277fb30e81900fabf9d',	'+12147096672',	'completed',	168,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE06723bac6b426ff3f5f1dfe158271a96',	0,	0,	'',	''),
(1638,	'CAa8fefc9b9dc004ce6eab11228562fc52',	'',	'2018-01-25 21:11:34',	'US',	'75258',	'TX',	'DALLAS',	'US',	'33128',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17862093341',	'+12147613136',	'+17862093341',	NULL,	NULL,	NULL,	NULL,	'MIAMI',	'FL',	'CAa8fefc9b9dc004ce6eab11228562fc52',	'+12147096672',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE5ca834c1bdefa6c6d40fe9a062de5492',	0,	0,	'',	''),
(1639,	'CA39ac7c8d1c00bf93f89cbeea3933f9bf',	'',	'2018-01-25 22:18:29',	'US',	'88240',	'NM',	'JAL',	'US',	'88115',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15052735884',	'+15053955347',	'+15052735884',	NULL,	NULL,	NULL,	NULL,	'CAUSEY',	'NM',	'CA39ac7c8d1c00bf93f89cbeea3933f9bf',	'+15053192181',	'completed',	6,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf4f3069d3249d8fd10ff65fa56beec1d',	0,	0,	'',	''),
(1640,	'CA2b36a75664e1bf274adebaf33bbd8517',	'',	'2018-01-25 23:18:45',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16823044309',	'+19722036640',	'+16823044309',	NULL,	NULL,	NULL,	NULL,	'',	'TX',	'CA2b36a75664e1bf274adebaf33bbd8517',	'+19728157325',	'completed',	42,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3c6d343033c12ddc6f87a4df80e7d7fd',	0,	0,	'',	''),
(1641,	'CA6856b77a5c3059f8256897adab976742',	'',	'2018-01-26 02:38:58',	'US',	'88065',	'NM',	'SILVER CITY',	'US',	'87102',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15053220240',	'+15053880240',	'+15053220240',	NULL,	NULL,	NULL,	NULL,	'ALBUQUERQUE',	'NM',	'CA6856b77a5c3059f8256897adab976742',	'+15053192181',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe86939add0b72a99403058df4e67aadd',	0,	0,	'',	''),
(1642,	'CAc5608d2c4105683f45e604f3a6b730a2',	'',	'2018-01-26 03:57:46',	'US',	'88101',	'NM',	'CLOVIS',	'US',	'87123',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15052031326',	'+15052194134',	'+15052031326',	NULL,	NULL,	NULL,	NULL,	'ALBUQUERQUE',	'NM',	'CAc5608d2c4105683f45e604f3a6b730a2',	'+15053192181',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1643,	'CA407ef697009efcd660c3e6f4e8380128',	'',	'2018-01-26 03:59:09',	'US',	'88240',	'NM',	'JAL',	'US',	'87123',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15052031326',	'+15053955347',	'+15052031326',	NULL,	NULL,	NULL,	NULL,	'ALBUQUERQUE',	'NM',	'CA407ef697009efcd660c3e6f4e8380128',	'+15053192181',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1644,	'CAa0e46fe282c2e413fa9f990f20988ca4',	'',	'2018-01-26 04:00:03',	'US',	'87828',	'NM',	'SOCORRO',	'US',	'87123',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15052031326',	'+15058352287',	'+15052031326',	NULL,	NULL,	NULL,	NULL,	'ALBUQUERQUE',	'NM',	'CAa0e46fe282c2e413fa9f990f20988ca4',	'+15053192181',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1645,	'CAc5b5b1b1e0a0cc995aee71fe6af00ee8',	'',	'2018-01-26 04:01:06',	'US',	'88065',	'NM',	'SILVER CITY',	'US',	'87123',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15052031326',	'+15053880240',	'+15052031326',	NULL,	NULL,	NULL,	NULL,	'ALBUQUERQUE',	'NM',	'CAc5b5b1b1e0a0cc995aee71fe6af00ee8',	'+15053192181',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1646,	'CAa3482e228b75e05857d925434fa13f70',	'',	'2018-01-26 15:38:24',	'US',	'75258',	'TX',	'DALLAS',	'CA',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16477494087',	'+12147613136',	'+16477494087',	NULL,	NULL,	NULL,	NULL,	'Toronto',	'ON',	'CAa3482e228b75e05857d925434fa13f70',	'+12147096672',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd446abd0fac49a847faa7a34db57e1e5',	0,	0,	'',	''),
(1647,	'CA8dfb13ee75735a5e4db2d73d8a75c769',	'',	'2018-01-26 16:59:19',	'US',	'75244',	'TX',	'DALLAS',	'US',	'75235',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19728832626',	'+19729190409',	'+19728832626',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CA8dfb13ee75735a5e4db2d73d8a75c769',	'+19728157325',	'completed',	50,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE07a7d8235db6d9cb34e3423de5eca484',	0,	0,	'',	''),
(1648,	'CA0afcb3ba401edf2850e42065286d8df1',	'',	'2018-01-26 19:46:16',	'US',	'83001',	'WY',	'JACKSON',	'US',	'82055',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+13072014710',	'+13077429025',	NULL,	NULL,	NULL,	NULL,	'LARAMIE',	'WY',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1649,	'CA6e8143f0d73deaf0e4ad3f9ce42b0b4b',	'',	'2018-01-26 21:25:37',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75146',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19722744219',	'+19722036218',	'+19722744219',	NULL,	NULL,	NULL,	NULL,	'DESOTO',	'TX',	'CA6e8143f0d73deaf0e4ad3f9ce42b0b4b',	'+12147183718',	'completed',	25,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE53c0c3f578bf1c00800cfbfd55cec42e',	0,	0,	'',	''),
(1650,	'CAc7e14650a8c4b930e19899d41aa439bf',	'',	'2018-01-28 17:21:39',	'US',	'',	'TX',	'Houston',	'US',	'77070',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18329238608',	'+13462144636',	'+18329238608',	NULL,	NULL,	NULL,	NULL,	'HOUSTON',	'TX',	'CAc7e14650a8c4b930e19899d41aa439bf',	'+13462347725',	'completed',	245,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REce11f4a66b73c04092e80af908c78eed',	0,	0,	'',	''),
(1651,	'CA467b9610f40fc33ae709d5d5c0d47fef',	'',	'2018-01-28 23:08:14',	'US',	'92123',	'CA',	'SAN DIEGO',	'US',	'91980',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16194787051',	'+16194583722',	'+16194787051',	NULL,	NULL,	NULL,	NULL,	'CAMPO',	'CA',	'CA467b9610f40fc33ae709d5d5c0d47fef',	'+17602378044',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1652,	'CAa35696a27547ae1d33b5a091bfeccfca',	'',	'2018-01-28 23:33:15',	'US',	'92123',	'CA',	'SAN DIEGO',	'US',	'91980',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16194787051',	'+16194583722',	'+16194787051',	NULL,	NULL,	NULL,	NULL,	'CAMPO',	'CA',	'CAa35696a27547ae1d33b5a091bfeccfca',	'+17602378044',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1653,	'CA5a79f5f2603759e779b0b80ef7d8556a',	'',	'2018-01-29 14:45:44',	'US',	'77995',	'TX',	'YOAKUM',	'US',	'67530',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16206173206',	'+13612983529',	'+16206173206',	NULL,	NULL,	NULL,	NULL,	'GREAT BEND',	'KS',	'CA5a79f5f2603759e779b0b80ef7d8556a',	'+18327156360',	'completed',	587,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE6e1a35569f9727125f0fb6b6acb3d355',	0,	0,	'',	''),
(1654,	'CA07a44bb80be1048382f28111ff4530d5',	'',	'2018-01-29 18:00:21',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75247',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12147169707',	'+19722036640',	'+12147169707',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CA07a44bb80be1048382f28111ff4530d5',	'+19728157325',	'completed',	1186,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb90a37c5bc7e00978a4a3a954a62ff33',	0,	0,	'',	''),
(1655,	'CAbd1106489370d04e3a9ab1943522226a',	'',	'2018-01-29 18:59:51',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75182',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19722031037',	'+19722036218',	'+19722031037',	NULL,	NULL,	NULL,	NULL,	'SUNNYVALE',	'TX',	'CAbd1106489370d04e3a9ab1943522226a',	'+12147183718',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1656,	'CA8161cb604467ea69d9998e0d067435ec',	'',	'2018-01-29 23:46:02',	'US',	'75202',	'TX',	'DALLAS',	'US',	'30336',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14042107184',	'+12149221949',	'+14042107184',	NULL,	NULL,	NULL,	NULL,	'ATLANTA',	'GA',	'CA8161cb604467ea69d9998e0d067435ec',	'+12147851535',	'completed',	54,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe721151e96f852ac4d3a52c3b80f9316',	0,	0,	'',	''),
(1657,	'CA976c457549c1e945815aff607ecc0e2d',	'',	'2018-01-30 14:34:26',	'US',	'75202',	'TX',	'DALLAS',	'US',	'30336',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14042107184',	'+12149221949',	'+14042107184',	NULL,	NULL,	NULL,	NULL,	'ATLANTA',	'GA',	'CA976c457549c1e945815aff607ecc0e2d',	'+12147851535',	'completed',	27,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf89dc9b5c87ef37120b9f265f932f073',	0,	0,	'',	''),
(1658,	'CAa45abcd09ab1abf43cdffc216f4697a5',	'',	'2018-01-30 16:46:09',	'US',	'75202',	'TX',	'DALLAS',	'US',	'76018',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12146628447',	'+12149221949',	'+12146628447',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CAa45abcd09ab1abf43cdffc216f4697a5',	'+12147851535',	'completed',	57,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE2538e9b9d88946bc5d5341ff2702eaad',	0,	0,	'',	''),
(1659,	'CAb82bc4bcb9cebfa209e45ed53de90987',	'',	'2018-01-30 19:10:20',	'US',	'75234',	'TX',	'CARROLLTON',	'US',	'76053',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18175807276',	'+14695578827',	'+18175807276',	NULL,	NULL,	NULL,	NULL,	'FORT WORTH',	'TX',	'CAb82bc4bcb9cebfa209e45ed53de90987',	'+19402315995',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE123adca749272ad8b1553c37c18734d1',	0,	0,	'',	''),
(1660,	'CA983010eba499e761246ad417b9d3e11b',	'',	'2018-01-30 21:42:20',	'US',	'76210',	'TX',	'DENTON',	'US',	'75301',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14693630104',	'+19405357431',	'+14693630104',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CA983010eba499e761246ad417b9d3e11b',	'+16172334088',	'completed',	18,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE6a2f914d9c6fc38b36dbbc6c960ad876',	0,	0,	'',	''),
(1661,	'CA415aef600c71eee1c8884c14eb9a712d',	'',	'2018-01-30 21:43:45',	'US',	'76210',	'TX',	'DENTON',	'US',	'75301',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14693630104',	'+19405357431',	'+14693630104',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CA415aef600c71eee1c8884c14eb9a712d',	'+16172334088',	'completed',	1005,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REea3985692567f7d950e435a2af16eefc',	0,	0,	'',	''),
(1662,	'CA01e2206a5385d42b8e20bf1f78fb4bc2',	'',	'2018-01-30 22:12:34',	'US',	'92123',	'CA',	'SAN DIEGO',	'US',	'92153',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16192105595',	'+16194583722',	'+16192105595',	NULL,	NULL,	NULL,	NULL,	'SAN DIEGO',	'CA',	'CA01e2206a5385d42b8e20bf1f78fb4bc2',	'+17602378044',	'completed',	6,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc26e448bd3eb7139d13463d7d20bb489',	0,	0,	'',	''),
(1663,	'CAb36117327f885374ddee2bfaa1d88f80',	'',	'2018-01-30 23:54:30',	'US',	'',	'TX',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18327076610',	'+18327064084',	'+18327076610',	NULL,	NULL,	NULL,	NULL,	'',	'TX',	'CAb36117327f885374ddee2bfaa1d88f80',	'+18327156360',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1664,	'CAb58e341cc6bd04c76ff468fd038eea39',	'',	'2018-01-31 15:44:26',	'US',	'94550',	'CA',	'LIVERMORE',	'US',	'94043',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16502532000',	'+19252906687',	'+16502532000',	NULL,	NULL,	NULL,	NULL,	'MOUNTAIN VIEW',	'CA',	'CAb58e341cc6bd04c76ff468fd038eea39',	'+12096060026',	'completed',	12,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4a988791b68c9d4140c2fb227d616042',	0,	0,	'',	''),
(1665,	'CAa7e0e58245245d1b6b5171794b5932ff',	'',	'2018-01-31 19:13:03',	'US',	'',	'TX',	'',	'US',	'75115',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14693372478',	'+14693363241',	'+14693372478',	NULL,	NULL,	NULL,	NULL,	'DESOTO',	'TX',	'CAa7e0e58245245d1b6b5171794b5932ff',	'+14695853442',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE319107ac12e96ffd8ea0bd6d21bfdd00',	0,	0,	'',	''),
(1666,	'CA3af33f63c3696e95bb43d302bb34edc5',	'',	'2018-01-31 21:14:26',	'US',	'94550',	'CA',	'LIVERMORE',	'US',	'94043',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16502532000',	'+19252906687',	'+16502532000',	NULL,	NULL,	NULL,	NULL,	'MOUNTAIN VIEW',	'CA',	'CA3af33f63c3696e95bb43d302bb34edc5',	'+12096060026',	'completed',	47,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REbb868dd9acda8406fed02c3e2706eb11',	0,	0,	'',	''),
(1667,	'CA855496dda7969ced2dfa18c1561558ec',	'',	'2018-02-01 19:49:31',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75182',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19722035658',	'+19722036218',	'+19722035658',	NULL,	NULL,	NULL,	NULL,	'SUNNYVALE',	'TX',	'CA855496dda7969ced2dfa18c1561558ec',	'+12147183718',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1668,	'CA7bd3da157fb67e27c8491532cc962a4c',	'',	'2018-02-01 21:11:16',	'US',	'76210',	'TX',	'DENTON',	'US',	'75039',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19724325654',	'+19405357431',	'+19724325654',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CA7bd3da157fb67e27c8491532cc962a4c',	'+16172334088',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1669,	'CA1014a9b81e0c8347467f3f62fe7f6048',	'',	'2018-02-02 15:26:05',	'US',	'',	'TX',	'',	'US',	'75052',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12145189953',	'+14695357756',	'+12145189953',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CA1014a9b81e0c8347467f3f62fe7f6048',	'+19402315995',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REffae7e92a583196e684bfcd2b36fa4ca',	0,	0,	'',	''),
(1670,	'CAe834cf8f52d15d85b0baec2ff6deb5fb',	'',	'2018-02-02 16:11:38',	'US',	'75244',	'TX',	'DALLAS',	'US',	'75240',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12146692982',	'+19729190409',	'+12146692982',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CAe834cf8f52d15d85b0baec2ff6deb5fb',	'+19728157325',	'completed',	93,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE2b3675b5901a0a0479ce036831ae262c',	0,	0,	'',	''),
(1671,	'CAef8ba48417487b896efc2f848e1b0124',	'',	'2018-02-02 19:09:53',	'US',	'75254',	'TX',	'DALLAS',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14696202320',	'+19728611197',	'+14696202320',	NULL,	NULL,	NULL,	NULL,	'',	'TX',	'CAef8ba48417487b896efc2f848e1b0124',	'+12147183718',	'completed',	157,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc6939620fa05a3e7f270ca95e2eb85aa',	0,	0,	'',	''),
(1672,	'CA93af1e57439fa851f3380ef66b78621f',	'',	'2018-02-03 05:46:38',	'US',	'92029',	'CA',	'ESCONDIDO',	'US',	'33122',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+17603001459',	'+13054697228',	NULL,	NULL,	NULL,	NULL,	'NORTH MIAMI',	'FL',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1673,	'CA79e8a485bf2f140fd85b5e5512f53fbc',	'',	'2018-02-03 05:46:45',	'US',	'92029',	'CA',	'ESCONDIDO',	'US',	'33122',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+17603001459',	'+13054697228',	NULL,	NULL,	NULL,	NULL,	'NORTH MIAMI',	'FL',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1674,	'CAe25d29138a4d8db340379784b22586fb',	'',	'2018-02-05 02:27:28',	'US',	'92123',	'CA',	'SAN DIEGO',	'US',	'91980',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16194787051',	'+16194323549',	'+16194787051',	NULL,	NULL,	NULL,	NULL,	'CAMPO',	'CA',	'CAe25d29138a4d8db340379784b22586fb',	'+16198233047',	'completed',	4,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf63b8c0c243a7a1fd259abf3ef9f193a',	0,	0,	'',	''),
(1675,	'CAc0585550a69fbe7ae6602c8668ac6b8e',	'',	'2018-02-05 15:57:13',	'US',	'92085',	'CA',	'VISTA',	'US',	'92084',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17605978066',	'+17604073992',	'+17605978066',	NULL,	NULL,	NULL,	NULL,	'VISTA',	'CA',	'CAc0585550a69fbe7ae6602c8668ac6b8e',	'+17602378044',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1676,	'CAb051311c6e0a4e1a150c6e4dffa2c1d6',	'',	'2018-02-05 23:10:30',	'US',	'85034',	'AZ',	'PHOENIX',	'US',	'83110',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13072487130',	'+14802691941',	'+13072487130',	NULL,	NULL,	NULL,	NULL,	'AFTON',	'WY',	'CAb051311c6e0a4e1a150c6e4dffa2c1d6',	'+14803882032',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1677,	'CA01ba954e3fc6c0b04fdce0a985d873b5',	'',	'2018-02-05 23:38:27',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75182',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19722031774',	'+19722036218',	'+19722031774',	NULL,	NULL,	NULL,	NULL,	'SUNNYVALE',	'TX',	'CA01ba954e3fc6c0b04fdce0a985d873b5',	'+12147183718',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1678,	'CAe887eaf29bd5799cefa2c8f3b65416c0',	'',	'2018-02-06 14:34:04',	'US',	'77995',	'TX',	'YOAKUM',	'US',	'78217',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12104590703',	'+13612983529',	'+12104590703',	NULL,	NULL,	NULL,	NULL,	'SAN ANTONIO',	'TX',	'CAe887eaf29bd5799cefa2c8f3b65416c0',	'+18327156360',	'completed',	91,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE951868adb2e9cc2389d6d2ae904b2fc8',	0,	0,	'',	''),
(1679,	'CAb17d74908a7308c89465303abd4bdc75',	'',	'2018-02-07 00:15:46',	'US',	'30044',	'GA',	'ATLANTA',	'US',	'30125',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+16782493679',	'+16782464421',	NULL,	NULL,	NULL,	NULL,	'CEDARTOWN',	'GA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1680,	'CAafb753ec08163a89892e20fc8e0375ad',	'',	'2018-02-07 00:36:54',	'US',	'',	'NV',	'',	'US',	'80203',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17029847595',	'+17028307376',	'+17029847595',	NULL,	NULL,	NULL,	NULL,	'DENVER',	'NV',	'CAafb753ec08163a89892e20fc8e0375ad',	'+17252223264',	'completed',	1,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REce12d4b88e51cabfbd8181e389fc5d4c',	0,	0,	'',	''),
(1681,	'CA1a494dc5e66afd0f5d47782a85d69be0',	'',	'2018-02-07 18:44:47',	'US',	'77577',	'TX',	'ALVIN',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13463686115',	'+12813934540',	'+13463686115',	NULL,	NULL,	NULL,	NULL,	'Houston',	'TX',	'CA1a494dc5e66afd0f5d47782a85d69be0',	'+18327156360',	'completed',	1,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE78220681c0ecc30666bed99b86a0b4e6',	0,	0,	'',	''),
(1682,	'CA1d000bae80759e0e0468a2543f1c002c',	'',	'2018-02-07 20:18:49',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75230',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12143979029',	'+19722036640',	'+12143979029',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CA1d000bae80759e0e0468a2543f1c002c',	'+19728157325',	'completed',	111,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE0216e412ee661d539172080e7b98a0d4',	0,	0,	'',	''),
(1683,	'CA01e60567dfd4d4cf575ad84f2148cb92',	'',	'2018-02-07 21:42:35',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75240',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19724372888',	'+19722036640',	'+19724372888',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CA01e60567dfd4d4cf575ad84f2148cb92',	'+19728157325',	'completed',	27,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE8216ba480f9489c0cac8019a9672f4d5',	0,	0,	'',	''),
(1684,	'CAf4003634342200b655fc85274ccf78f1',	'',	'2018-02-07 22:50:09',	'US',	'85034',	'AZ',	'PHOENIX',	'US',	'99204',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15094977030',	'+14802691941',	'+15094977030',	NULL,	NULL,	NULL,	NULL,	'SPOKANE',	'WA',	'CAf4003634342200b655fc85274ccf78f1',	'+14803882032',	'completed',	2,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd31f3f0c93e720f9a88d1fb6e062e7ff',	0,	0,	'',	''),
(1685,	'CA032a1da1cdef26ba7c3261ec88db5f6b',	'',	'2018-02-08 15:20:09',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75025',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19722083084',	'+19722036218',	'+19722083084',	NULL,	NULL,	NULL,	NULL,	'PLANO',	'TX',	'CA032a1da1cdef26ba7c3261ec88db5f6b',	'+12147183718',	'completed',	4,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd865e0402b41e10d81dbd62b2f416c27',	0,	0,	'',	''),
(1686,	'CA6cb3eff74f5225420ce1221107ecb5c6',	'',	'2018-02-08 16:24:22',	'US',	'',	'TX',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14694048401',	'+14695303089',	'+14694048401',	NULL,	NULL,	NULL,	NULL,	'',	'TX',	'CA6cb3eff74f5225420ce1221107ecb5c6',	'+14695853442',	'completed',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb979dc25d6cb80a3a471730eb539efa4',	0,	0,	'',	''),
(1687,	'CAd46edcacc303ea7a130856d133b8f585',	'',	'2018-02-08 17:24:20',	'US',	'76248',	'TX',	'FORT WORTH',	'US',	'91301',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18184838863',	'+18179681164',	'+18184838863',	NULL,	NULL,	NULL,	NULL,	'AGOURA',	'CA',	'CAd46edcacc303ea7a130856d133b8f585',	'+18178814663',	'completed',	39,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE36d752dac556ff2c6ceaae698d101618',	0,	0,	'',	''),
(1688,	'CA54d01b4c805d107b6231965cbd16d152',	'',	'2018-02-08 18:40:58',	'US',	'76210',	'TX',	'DENTON',	'US',	'06906',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12035170588',	'+19402203619',	'+12035170588',	NULL,	NULL,	NULL,	NULL,	'STAMFORD',	'CT',	'CA54d01b4c805d107b6231965cbd16d152',	'+16172334088',	'completed',	4,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE5f35aedc5c04e7f177b1c79ea5cd62e8',	0,	0,	'',	''),
(1689,	'CA870e166ca383c174af5dc1324b94a565',	'',	'2018-02-08 23:01:45',	'US',	'88065',	'NM',	'SILVER CITY',	'US',	'88065',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15053886217',	'+15053880240',	'+15053886217',	NULL,	NULL,	NULL,	NULL,	'SILVER CITY',	'NM',	'CA870e166ca383c174af5dc1324b94a565',	'+15053192181',	'completed',	45,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE99c45f143224d5b741d7524706d393a0',	0,	0,	'',	''),
(1690,	'CAb870bd9c98e2f7ec76a01f85e4cb585a',	'',	'2018-02-08 23:03:12',	'US',	'88065',	'NM',	'SILVER CITY',	'US',	'88065',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15053886217',	'+15053880240',	'+15053886217',	NULL,	NULL,	NULL,	NULL,	'SILVER CITY',	'NM',	'CAb870bd9c98e2f7ec76a01f85e4cb585a',	'+15053192181',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1691,	'CAf546e8a8338d1fe67515d196e67d12fa',	'',	'2018-02-08 23:18:15',	'US',	'85034',	'AZ',	'PHOENIX',	'US',	'97333',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15413682279',	'+14802691941',	'+15413682279',	NULL,	NULL,	NULL,	NULL,	'CORVALLIS',	'OR',	'CAf546e8a8338d1fe67515d196e67d12fa',	'+14803882032',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1692,	'CAbff2eb3df1ddf1f1886f882eb97ca12f',	'',	'2018-02-09 03:07:16',	'US',	'92123',	'CA',	'SAN DIEGO',	'US',	'91980',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16194787051',	'+16194943688',	'+16194787051',	NULL,	NULL,	NULL,	NULL,	'CAMPO',	'CA',	'CAbff2eb3df1ddf1f1886f882eb97ca12f',	'+16198233047',	'completed',	4,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE01b32628464f7a50a4e25123efb41301',	0,	0,	'',	''),
(1693,	'CA3673afb6b0b8bfcc02eadf82531aac0b',	'',	'2018-02-09 04:07:59',	'US',	'94533',	'CA',	'BENICIA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12092680594',	'+17072101783',	'+12092680594',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA3673afb6b0b8bfcc02eadf82531aac0b',	'+19255840363',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1694,	'CA6797e2da517e8621de53b948cd2330cb',	'',	'2018-02-09 18:06:54',	'US',	'94509',	'CA',	'ANTIOCH',	'US',	'94509',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19252196595',	'+19252197932',	'+19252196595',	NULL,	NULL,	NULL,	NULL,	'ANTIOCH',	'CA',	'CA6797e2da517e8621de53b948cd2330cb',	'+19255840363',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1695,	'CA1581d42b244a3e717ad2d47a4de27827',	'',	'2018-02-09 23:14:36',	'US',	'85034',	'AZ',	'PHOENIX',	'US',	'57248',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16059837010',	'+14802691941',	'+16059837010',	NULL,	NULL,	NULL,	NULL,	'ARLINGTON',	'SD',	'CA1581d42b244a3e717ad2d47a4de27827',	'+14803882032',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1696,	'CA4fceb6d5e7bb925509aec0c6f83d351e',	'',	'2018-02-09 23:25:44',	'US',	'',	'NV',	'',	'US',	'89103',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17022122222',	'+17028196450',	'+17022122222',	NULL,	NULL,	NULL,	NULL,	'LAS VEGAS',	'NV',	'CA4fceb6d5e7bb925509aec0c6f83d351e',	'+17252223264',	'completed',	39,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REfc6fde63f7353ff7ad8fe9a0108bfc31',	0,	0,	'',	''),
(1697,	'CA4a8876f4706b1289df97de6019096c02',	'',	'2018-02-09 23:52:37',	'US',	'75201',	'TX',	'DALLAS',	'US',	'63124',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13147754110',	'+14696190565',	'+13147754110',	NULL,	NULL,	NULL,	NULL,	'LADUE',	'MO',	'CA4a8876f4706b1289df97de6019096c02',	'+12146953999',	'completed',	2,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4b7bd693c74ae9537db1b3d098fb12eb',	0,	0,	'',	''),
(1698,	'CAfdb19edfee38237f28097f02eb4f20e7',	'',	'2018-02-10 02:09:19',	'US',	'92122',	'CA',	'SAN DIEGO',	'US',	'91980',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16194787051',	'+16195548764',	'+16194787051',	NULL,	NULL,	NULL,	NULL,	'CAMPO',	'CA',	'CAfdb19edfee38237f28097f02eb4f20e7',	'+16198233047',	'completed',	2,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE6fdff2be91c7478cca5d0fe3e6a61b36',	0,	0,	'',	''),
(1699,	'CA7b4d7ddea1bd151973f625fbe4f8cd28',	'',	'2018-02-10 02:22:17',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'95037',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14087090949',	'+19722036640',	'+14087090949',	NULL,	NULL,	NULL,	NULL,	'GILROY',	'CA',	'CA7b4d7ddea1bd151973f625fbe4f8cd28',	'+19728157325',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1700,	'CA694ea3a33e051a65c5db78d0ca313c81',	'',	'2018-02-11 00:21:14',	'US',	'',	'CA',	'',	'',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+1611',	'+19166340519',	'+1611',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA694ea3a33e051a65c5db78d0ca313c81',	'+19166287355',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REbadce819d5323d2cfee6044ad3cd7222',	0,	0,	'',	''),
(1701,	'CA27939d4d28b32a678a271e26a12f7932',	'',	'2018-02-11 00:23:26',	'US',	'',	'CA',	'',	'US',	'95833',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19166287355',	'+19168238779',	'+19166287355',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CA27939d4d28b32a678a271e26a12f7932',	'+19166287355',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE0f5610bb684673f0c35c8a35c34477c1',	0,	0,	'',	''),
(1702,	'CA2b760c499aa685190510ae733c551ac6',	'',	'2018-02-11 18:42:25',	'US',	'94553',	'CA',	'MARTINEZ',	'US',	'94588',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19255184890',	'+19252319862',	'+19255184890',	NULL,	NULL,	NULL,	NULL,	'LIVERMORE',	'CA',	'CA2b760c499aa685190510ae733c551ac6',	'+19255840363',	'completed',	1438,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE1a0d551777e956b361cb5cde98db3d37',	0,	0,	'',	''),
(1703,	'CA632ffb63997d9514eb50af50d3a6e86c',	'',	'2018-02-12 15:17:20',	'US',	'77995',	'TX',	'YOAKUM',	'US',	'70503',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13375017205',	'+13612983529',	'+13375017205',	NULL,	NULL,	NULL,	NULL,	'LAFAYETTE',	'LA',	'CA632ffb63997d9514eb50af50d3a6e86c',	'+18327156360',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE1517a2d20a4983cc4f98a0de4ed210ef',	0,	0,	'',	''),
(1704,	'CA663d0cf30ea78a1b493c405208807e40',	'',	'2018-02-12 15:19:43',	'US',	'77995',	'TX',	'YOAKUM',	'US',	'70503',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13375017205',	'+13612983529',	'+13375017205',	NULL,	NULL,	NULL,	NULL,	'LAFAYETTE',	'LA',	'CA663d0cf30ea78a1b493c405208807e40',	'+18327156360',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1705,	'CA366048fdfff9bb31ddfde4baddd03d84',	'',	'2018-02-12 15:23:14',	'US',	'77995',	'TX',	'YOAKUM',	'US',	'70503',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13375017205',	'+13612983529',	'+13375017205',	NULL,	NULL,	NULL,	NULL,	'LAFAYETTE',	'LA',	'CA366048fdfff9bb31ddfde4baddd03d84',	'+18327156360',	'completed',	20,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE1f0809081e1c877aa76456d38db52042',	0,	0,	'',	''),
(1706,	'CAe2acc016501a751d675df496d132b373',	'',	'2018-02-12 15:26:45',	'US',	'77995',	'TX',	'YOAKUM',	'US',	'70503',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13375017205',	'+13612983529',	'+13375017205',	NULL,	NULL,	NULL,	NULL,	'LAFAYETTE',	'LA',	'CAe2acc016501a751d675df496d132b373',	'+18327156360',	'completed',	26,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe25001784879d493db960c6de6e573cf',	0,	0,	'',	''),
(1707,	'CAab6c44e858a18464ca5cd446009fb09d',	'',	'2018-02-12 17:03:18',	'US',	'95762',	'CA',	'FOLSOM',	'US',	'94514',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19254183036',	'+19162358117',	'+19254183036',	NULL,	NULL,	NULL,	NULL,	'BRENTWOOD',	'CA',	'CAab6c44e858a18464ca5cd446009fb09d',	'+19163975518',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1708,	'CA73c90e5e549a068efa50e870fd915117',	'',	'2018-02-12 21:47:15',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19165861538',	'+19165849538',	'+19165861538',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA73c90e5e549a068efa50e870fd915117',	'+19162243237',	'completed',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe7633fc7b777a6960d48725e3d3d503a',	0,	0,	'',	''),
(1709,	'CA873a3dcbfb1edba2ac3bbbbf5b68820f',	'',	'2018-02-13 14:09:13',	'US',	'74120',	'OK',	'TULSA',	'IN',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+914066191721',	'+19189927424',	'+914066191721',	NULL,	NULL,	NULL,	NULL,	'Hyderabad Loc',	'Hyderabad',	'CA873a3dcbfb1edba2ac3bbbbf5b68820f',	'+19188009881',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE33e46604bf120ea77795a4dabf403fb3',	0,	0,	'',	''),
(1710,	'CAd62fbb7e46e10ee601ba67fef9b584d6',	'',	'2018-02-13 14:47:19',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75010',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19722363510',	'+19722036218',	'+19722363510',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CAd62fbb7e46e10ee601ba67fef9b584d6',	'+12147183718',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1711,	'CA2478f4f6cb3b48e11289dbbcaef4eb97',	'',	'2018-02-13 16:29:41',	'US',	'92123',	'CA',	'SAN DIEGO',	'US',	'94043',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16502532000',	'+16194943688',	'+16502532000',	NULL,	NULL,	NULL,	NULL,	'MOUNTAIN VIEW',	'CA',	'CA2478f4f6cb3b48e11289dbbcaef4eb97',	'+16198233047',	'completed',	12,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE21bf7a38176309ba3f204aa4e75b18d4',	0,	0,	'',	''),
(1712,	'CAd4539b0794215a95f1b837c1e149a486',	'',	'2018-02-13 17:54:11',	'US',	'94105',	'CA',	'SAN FRANCISCO',	'US',	'94105',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14152126436',	'+14152125436',	'+14152126436',	NULL,	NULL,	NULL,	NULL,	'SAN FRANCISCO',	'CA',	'CAd4539b0794215a95f1b837c1e149a486',	'+15106893859',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1713,	'CA7d1a45288bba295c6ab2ebf55c9dfc05',	'',	'2018-02-13 18:58:53',	'US',	'92123',	'CA',	'SAN DIEGO',	'US',	'94043',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16502532000',	'+16194943688',	'+16502532000',	NULL,	NULL,	NULL,	NULL,	'MOUNTAIN VIEW',	'CA',	'CA7d1a45288bba295c6ab2ebf55c9dfc05',	'+16198233047',	'completed',	12,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf426ba9230bd62ac82b6f9d184732732',	0,	0,	'',	''),
(1714,	'CA5c9b5db6932bb5a8ab827bcccefdbfb2',	'',	'2018-02-13 19:16:25',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'67502',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16206157216',	'+19722036218',	'+16206157216',	NULL,	NULL,	NULL,	NULL,	'HUTCHINSON',	'KS',	'CA5c9b5db6932bb5a8ab827bcccefdbfb2',	'+12147183718',	'completed',	4,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REde536bf887fdf2b9808ba2dbb7fe9450',	0,	0,	'',	''),
(1715,	'CAd2574dc83340821ceac51aef66e8eb6e',	'',	'2018-02-13 19:42:07',	'US',	'75024',	'TX',	'PLANO',	'US',	'75402',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19032178547',	'+19728051470',	'+19032178547',	NULL,	NULL,	NULL,	NULL,	'GREENVILLE',	'TX',	'CAd2574dc83340821ceac51aef66e8eb6e',	'+12146824990',	'completed',	262,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4bb184e23ad3ac6af3097deb6bbdb662',	0,	0,	'',	''),
(1716,	'CAaae54af2d17fbd99e3e1c13ad4a78de6',	'',	'2018-02-13 20:34:16',	'US',	'92123',	'CA',	'SAN DIEGO',	'US',	'94043',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16502532000',	'+16194943688',	'+16502532000',	NULL,	NULL,	NULL,	NULL,	'MOUNTAIN VIEW',	'CA',	'CAaae54af2d17fbd99e3e1c13ad4a78de6',	'+16198233047',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc5ff898396fcd003395f33997f34ce8a',	0,	0,	'',	''),
(1717,	'CA9140b7a4c501e7562f2b8af7258d40bc',	'',	'2018-02-13 23:14:57',	'US',	'85034',	'AZ',	'PHOENIX',	'US',	'59711',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14067977255',	'+14802691941',	'+14067977255',	NULL,	NULL,	NULL,	NULL,	'ANACONDA',	'MT',	'CA9140b7a4c501e7562f2b8af7258d40bc',	'+14803882032',	'completed',	14,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc4ebb02b3ddad2ff4fa8932e8bfd14b2',	0,	0,	'',	''),
(1718,	'CAa5ece384761c1e6a81da2d707aa56abe',	'',	'2018-02-14 02:32:41',	'US',	'',	'NV',	'',	'US',	'92691',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19496978100',	'+17028196450',	'+19496978100',	NULL,	NULL,	NULL,	NULL,	'ANAHEIM',	'CA',	'CAa5ece384761c1e6a81da2d707aa56abe',	'+17252223264',	'completed',	1,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE567db6357a16dbcbb375f73aa1b14bc2',	0,	0,	'',	''),
(1719,	'CA910a39c22659b4592b2b4f0388b01e09',	'',	'2018-02-14 16:44:55',	'US',	'74120',	'OK',	'TULSA',	'IN',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+914066194416',	'+19189927424',	'+914066194416',	NULL,	NULL,	NULL,	NULL,	'Hyderabad Loc',	'Hyderabad',	'CA910a39c22659b4592b2b4f0388b01e09',	'+19188009881',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE43157124eed31133b7c48a265f44a95b',	0,	0,	'',	''),
(1720,	'CA520eb12630c5b7e60b4541b8a0f124df',	'',	'2018-02-14 17:26:56',	'US',	'73149',	'OK',	'OKLAHOMA CITY',	'US',	'95136',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14089788747',	'+14052469915',	'+14089788747',	NULL,	NULL,	NULL,	NULL,	'SAN JOSE',	'CA',	'CA520eb12630c5b7e60b4541b8a0f124df',	'+14052014241',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa09b3b6cb1b354b2ed1d120b61c1fe7c',	0,	0,	'',	''),
(1721,	'CAd3946d5ad4c5b5d33082ff6f1f2ab15b',	'',	'2018-02-14 18:24:10',	'',	'',	'',	'',	'',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+1914066194416',	'+19189927424',	'+1914066194416',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CAd3946d5ad4c5b5d33082ff6f1f2ab15b',	'+19188009881',	'completed',	20,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE28b5f54ec62c7fd5aa078c410e70316d',	0,	0,	'',	''),
(1722,	'CAc8819f27a39957527851756f5e7981eb',	'',	'2018-02-14 18:27:39',	'',	'',	'',	'',	'',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+1914066194416',	'+19189927424',	'+1914066194416',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CAc8819f27a39957527851756f5e7981eb',	'+19188009881',	'completed',	18,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE8c3196a774f40d8c33048eeb4cc0304f',	0,	0,	'',	''),
(1723,	'CA37cc62ffc06064dc7d7544247e5c83a2',	'',	'2018-02-14 18:55:17',	'US',	'75062',	'TX',	'IRVING',	'US',	'92130',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18587241024',	'+18172038813',	'+18587241024',	NULL,	NULL,	NULL,	NULL,	'SAN DIEGO',	'CA',	'CA37cc62ffc06064dc7d7544247e5c83a2',	'+12146628447',	'completed',	72,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE1479f0f2630b49014366dc15590fe69e',	0,	0,	'',	''),
(1724,	'CAee4ec401c1394dfb1bdebf0254f6e0a7',	'',	'2018-02-14 19:57:14',	'US',	'95619',	'CA',	'LINCOLN',	'US',	'94043',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16502532000',	'+19162956531',	'+16502532000',	NULL,	NULL,	NULL,	NULL,	'MOUNTAIN VIEW',	'CA',	'CAee4ec401c1394dfb1bdebf0254f6e0a7',	'+19163975518',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1725,	'CA3332e9ab634761d38be5b23fc2b2dc2f',	'',	'2018-02-14 22:51:20',	'US',	'92029',	'CA',	'ESCONDIDO',	'US',	'92069',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17606215543',	'+17603001459',	'+17606215543',	NULL,	NULL,	NULL,	NULL,	'SAN MARCOS',	'CA',	'CA3332e9ab634761d38be5b23fc2b2dc2f',	'+17602378044',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1726,	'CAb7c9107be7be522b2ce2793c657baf06',	'',	'2018-02-14 22:57:55',	'US',	'85034',	'AZ',	'PHOENIX',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13852639390',	'+14802691941',	'+13852639390',	NULL,	NULL,	NULL,	NULL,	'SALT LAKE CITY',	'UT',	'CAb7c9107be7be522b2ce2793c657baf06',	'+14803882032',	'completed',	68,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4ec2a430abdafdfd0b8e8220248da8a9',	0,	0,	'',	''),
(1727,	'CA58cda4e6bbb9e889357559f3f5dfbd5f',	'',	'2018-02-15 14:49:56',	'US',	'76227',	'TX',	'AUBREY',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19403150290',	'+19404881693',	'+19403150290',	NULL,	NULL,	NULL,	NULL,	'',	'TX',	'CA58cda4e6bbb9e889357559f3f5dfbd5f',	'+19727954260',	'completed',	25,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd9a88b37a2cd09709acf8e215bdf989b',	0,	0,	'',	''),
(1728,	'CA82e78b87f9da499c4556f3a27638d219',	'',	'2018-02-15 14:56:26',	'US',	'88101',	'NM',	'CLOVIS',	'US',	'87110',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15058168021',	'+15052194134',	'+15058168021',	NULL,	NULL,	NULL,	NULL,	'ALBUQUERQUE',	'NM',	'CA82e78b87f9da499c4556f3a27638d219',	'+15053192181',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1729,	'CA7c21fa3e32d7a7c7f13ac4438dee75c5',	'',	'2018-02-15 15:07:52',	'US',	'95619',	'CA',	'LINCOLN',	'US',	'94043',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16502532000',	'+19162956531',	'+16502532000',	NULL,	NULL,	NULL,	NULL,	'MOUNTAIN VIEW',	'CA',	'CA7c21fa3e32d7a7c7f13ac4438dee75c5',	'+19163975518',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1730,	'CA7f165ddfb2217a28acc5b0116c54bf06',	'',	'2018-02-15 19:46:34',	'US',	'95619',	'CA',	'LINCOLN',	'US',	'94043',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16502532000',	'+19162956531',	'+16502532000',	NULL,	NULL,	NULL,	NULL,	'MOUNTAIN VIEW',	'CA',	'CA7f165ddfb2217a28acc5b0116c54bf06',	'+19163975518',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE91635fabaeb0d571fb55e7cf4c84ea47',	0,	0,	'',	''),
(1731,	'CAd8355923073565cd8ba445e25e535896',	'',	'2018-02-15 19:58:39',	'US',	'85021',	'AZ',	'PHOENIX',	'US',	'85021',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16233777231',	'+16233779759',	'+16233777231',	NULL,	NULL,	NULL,	NULL,	'PHOENIX',	'AZ',	'CAd8355923073565cd8ba445e25e535896',	'+14802390652',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1732,	'CAe3a08326ff93022dfdeb051f7cf536e4',	'',	'2018-02-15 21:29:56',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75010',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19722363510',	'+19722036218',	'+19722363510',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CAe3a08326ff93022dfdeb051f7cf536e4',	'+12147183718',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1733,	'CA968d9743ca18823f6d56d73ce2d9dd81',	'',	'2018-02-15 22:01:37',	'US',	'',	'AZ',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16232335138',	'+16232330255',	'+16232335138',	NULL,	NULL,	NULL,	NULL,	'',	'AZ',	'CA968d9743ca18823f6d56d73ce2d9dd81',	'+14803882032',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf03d70f39712cf354cbbbb03a8d3873f',	0,	0,	'',	''),
(1734,	'CA77d35786ffbf61b827230ed00680e858',	'',	'2018-02-16 18:12:19',	'US',	'77995',	'TX',	'YOAKUM',	'US',	'78362',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13617755372',	'+13612983529',	'+13617755372',	NULL,	NULL,	NULL,	NULL,	'INGLESIDE',	'TX',	'CA77d35786ffbf61b827230ed00680e858',	'+18327156360',	'completed',	87,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE1340942b8e7c891e10fa3acf34ceefa9',	0,	0,	'',	''),
(1735,	'CA78abaff0cccc499aac2f2f48d8857817',	'',	'2018-02-16 20:46:30',	'US',	'73106',	'OK',	'OKLAHOMA CITY',	'US',	'73102',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14058758677',	'+14052125687',	'+14058758677',	NULL,	NULL,	NULL,	NULL,	'OKLAHOMA CITY',	'OK',	'CA78abaff0cccc499aac2f2f48d8857817',	'+14052014241',	'completed',	239,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE1f0d190c5236d4aa6e4dbdd3423d9199',	0,	0,	'',	''),
(1736,	'CA021d70708d8346d6f9e4df240160b3de',	'',	'2018-02-16 23:41:02',	'US',	'92122',	'CA',	'SAN DIEGO',	'US',	'02893',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14012193882',	'+16195548764',	'+14012193882',	NULL,	NULL,	NULL,	NULL,	'EAST GREENWICH',	'RI',	'CA021d70708d8346d6f9e4df240160b3de',	'+16198233047',	'completed',	49,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE799b702a66dab2d732d2719da3c62408',	0,	0,	'',	''),
(1737,	'CAd767f795977c9c7f18d89c602b267824',	'',	'2018-02-17 15:16:48',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'67206',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13163156855',	'+19722036218',	'+13163156855',	NULL,	NULL,	NULL,	NULL,	'WICHITA',	'KS',	'CAd767f795977c9c7f18d89c602b267824',	'+12147183718',	'completed',	3,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REde69d254dfa236beadaaa781e6781769',	0,	0,	'',	''),
(1738,	'CA603371b1c21bc90cd2cbdc5c7d076c03',	'',	'2018-02-17 16:22:38',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'39475',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16014360857',	'+19722036640',	'+16014360857',	NULL,	NULL,	NULL,	NULL,	'PURVIS',	'MS',	'CA603371b1c21bc90cd2cbdc5c7d076c03',	'+19728157325',	'completed',	41,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REcc26a9f4848b4222ac2f2edbd0e1a2e1',	0,	0,	'',	''),
(1739,	'CAfe059625feebf954a513653d4a98289b',	'',	'2018-02-17 19:15:27',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75182',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19722038354',	'+19722036218',	'+19722038354',	NULL,	NULL,	NULL,	NULL,	'SUNNYVALE',	'TX',	'CAfe059625feebf954a513653d4a98289b',	'+12147183718',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1740,	'CAafd4cb0e74ac7a0ebdb7616b45b1c9f8',	'',	'2018-02-19 13:45:10',	'US',	'',	'TX',	'',	'US',	'71463',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13184851905',	'+14695303089',	'+13184851905',	NULL,	NULL,	NULL,	NULL,	'OAKDALE',	'LA',	'CAafd4cb0e74ac7a0ebdb7616b45b1c9f8',	'+14695853442',	'completed',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE2a4519de2578fc4065b93960f7e369ef',	0,	0,	'',	''),
(1741,	'CAd434f4730d483137ef26cf096868661b',	'',	'2018-02-19 14:58:54',	'US',	'83001',	'WY',	'JACKSON',	'US',	'82005',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+13072014710',	'+13074326907',	NULL,	NULL,	NULL,	NULL,	'CHEYENNE',	'WY',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1742,	'CA75338f3e8d445f4362e2353512739d81',	'',	'2018-02-19 16:43:45',	'US',	'85034',	'AZ',	'PHOENIX',	'US',	'85034',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+14802691941',	'+14802692978',	NULL,	NULL,	NULL,	NULL,	'PHOENIX',	'AZ',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1743,	'CAde81ce1c1482b3ef9d9544ae03fd68f5',	'',	'2018-02-19 16:43:46',	'US',	'85034',	'AZ',	'PHOENIX',	'US',	'85034',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+14802691941',	'+14802692978',	NULL,	NULL,	NULL,	NULL,	'PHOENIX',	'AZ',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1744,	'CAbbea2825ecbfdc5133685fc37743eafd',	'',	'2018-02-19 16:43:46',	'US',	'85034',	'AZ',	'PHOENIX',	'US',	'85034',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14802692978',	'+14802691941',	'+14802692978',	NULL,	NULL,	NULL,	NULL,	'PHOENIX',	'AZ',	'CAbbea2825ecbfdc5133685fc37743eafd',	'+14803882032',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1745,	'CA3d82c4e5f56c23559944d7c868ed4104',	'',	'2018-02-19 20:18:27',	'US',	'75074',	'TX',	'PLANO',	'US',	'38261',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15028836070',	'+19727377035',	'+15028836070',	NULL,	NULL,	NULL,	NULL,	'UNION CITY',	'KY',	'CA3d82c4e5f56c23559944d7c868ed4104',	'+19729894711',	'completed',	53,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE8f6556299c4e74a4571835798396ed47',	0,	0,	'',	''),
(1746,	'CA5a33c7fe95bfdf2d7f4f21fbeb85465e',	'',	'2018-02-19 21:10:29',	'US',	'',	'TX',	'',	'US',	'77414',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19794295926',	'+18327064084',	'+19794295926',	NULL,	NULL,	NULL,	NULL,	'BAY CITY',	'TX',	'CA5a33c7fe95bfdf2d7f4f21fbeb85465e',	'+18327156360',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE8e24694fa0e23e560be3af36d0cb3c6d',	0,	0,	'',	''),
(1747,	'CAb632176a9d671be86f9908889cc7cd6d',	'',	'2018-02-20 02:24:09',	'US',	'92024',	'CA',	'ENCINITAS',	'US',	'92029',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17606445054',	'+17606421252',	'+17606445054',	NULL,	NULL,	NULL,	NULL,	'ESCONDIDO',	'CA',	'CAb632176a9d671be86f9908889cc7cd6d',	'+17602378044',	'completed',	16,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE62126325ee6212632bc9efb41907f625',	0,	0,	'',	''),
(1748,	'CAaccfd8f809bd9f0dd873103234859cc5',	'',	'2018-02-20 21:59:39',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15107074374',	'+19168238963',	'+15107074374',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAaccfd8f809bd9f0dd873103234859cc5',	'+19162243237',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE5531a83000b6940b85f1d141f83974a0',	0,	0,	'',	''),
(1749,	'CA29866d737ec820d1675d7376c8f4a1f3',	'',	'2018-02-20 23:05:18',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14697764292',	'+19722036640',	'+14697764292',	NULL,	NULL,	NULL,	NULL,	'',	'TX',	'CA29866d737ec820d1675d7376c8f4a1f3',	'+19728157325',	'completed',	2,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE016e40903e486086211a776a9114ca25',	0,	0,	'',	''),
(1750,	'CAbe8d01885674389cb2918ff9c9bd69dd',	'',	'2018-02-21 17:24:37',	'US',	'75024',	'TX',	'PLANO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18880020818',	'+19728051470',	'+18880020818',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CAbe8d01885674389cb2918ff9c9bd69dd',	'+12146824990',	'completed',	42,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE588d9f9075b8be0657a542e1bf31743d',	0,	0,	'',	''),
(1751,	'CA3f996bbabcff0275afadeabc5fe372ec',	'',	'2018-02-21 17:35:07',	'US',	'77995',	'TX',	'YOAKUM',	'US',	'78426',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13618162119',	'+13612983529',	'+13618162119',	NULL,	NULL,	NULL,	NULL,	'CORPUS CHRISTI',	'TX',	'CA3f996bbabcff0275afadeabc5fe372ec',	'+18327156360',	'completed',	164,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REbd3e6e67d4e9aa3f4175618ac805a46e',	0,	0,	'',	''),
(1752,	'CA22357736b06617cfc80b208ac706c894',	'',	'2018-02-21 18:11:24',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75235',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14693356174',	'+19722036640',	'+14693356174',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CA22357736b06617cfc80b208ac706c894',	'+19728157325',	'completed',	2052,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REed393e7a68379bb5e2f4177145484c02',	0,	0,	'',	''),
(1753,	'CA16ce39ab3cb41e3b9437b345b0428a97',	'',	'2018-02-21 20:10:50',	'US',	'',	'CA',	'',	'US',	'28301',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19108494234',	'+19168238779',	'+19108494234',	NULL,	NULL,	NULL,	NULL,	'FAYETTEVILLE',	'NC',	'CA16ce39ab3cb41e3b9437b345b0428a97',	'+19166287355',	'completed',	63,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REfc1076f3ae54cb325c537fdb7ce29272',	0,	0,	'',	''),
(1754,	'CA3532d8cf53e0dfb22ba351dabaf590ef',	'',	'2018-02-22 15:55:52',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14698632398',	'+19722036640',	'+14698632398',	NULL,	NULL,	NULL,	NULL,	'',	'TX',	'CA3532d8cf53e0dfb22ba351dabaf590ef',	'+19728157325',	'completed',	2,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE484390962a49c7053f26e381449df4ba',	0,	0,	'',	''),
(1755,	'CAd223f351744d5c8887f9270c5e99060a',	'',	'2018-02-22 17:06:09',	'US',	'95762',	'CA',	'FOLSOM',	'US',	'94514',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19254183036',	'+19162358117',	'+19254183036',	NULL,	NULL,	NULL,	NULL,	'BRENTWOOD',	'CA',	'CAd223f351744d5c8887f9270c5e99060a',	'+19163975518',	'completed',	44,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc75d0a07b511df2df6db2810a32ecd2d',	0,	0,	'',	''),
(1756,	'CA4bd0ccb1ffeb4807e79ef82d5a935676',	'',	'2018-02-22 21:28:55',	'US',	'75082',	'TX',	'DALLAS',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19723625222',	'+16193912090',	NULL,	NULL,	NULL,	NULL,	'POWAY',	'CA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1757,	'CA4331316a3845e5e457303a0f213e65c3',	'',	'2018-02-22 21:34:29',	'US',	'92029',	'CA',	'ESCONDIDO',	'US',	'92069',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17606215543',	'+17603001459',	'+17606215543',	NULL,	NULL,	NULL,	NULL,	'SAN MARCOS',	'CA',	'CA4331316a3845e5e457303a0f213e65c3',	'+17602378044',	'completed',	6,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3f798404d0a2a68679cf75ac228abff0',	0,	0,	'',	''),
(1758,	'CAdd884024a010dac3ee2cd66673aa7ff0',	'',	'2018-02-22 22:18:53',	'US',	'75082',	'TX',	'DALLAS',	'US',	'32617',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13526204402',	'+19723625222',	'+13526204402',	NULL,	NULL,	NULL,	NULL,	'OCALA',	'FL',	'CAdd884024a010dac3ee2cd66673aa7ff0',	'+12147183718',	'completed',	343,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf3879d058faeab676c21adb685ea3589',	0,	0,	'',	''),
(1759,	'CA8de8437bae8462dde932aa35ca8cbf8b',	'',	'2018-02-22 22:53:06',	'US',	'92122',	'CA',	'SAN DIEGO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19514288019',	'+16195548764',	'+19514288019',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA8de8437bae8462dde932aa35ca8cbf8b',	'+16198233047',	'completed',	3,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE14e5ad3763d4338c5e7574649cc3a90b',	0,	0,	'',	''),
(1760,	'CA3a46c4cff13ef350ed6ab7473802c379',	'',	'2018-02-23 17:35:13',	'US',	'73101',	'OK',	'OKLAHOMA CITY',	'US',	'73130',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14053063888',	'+14052252057',	'+14053063888',	NULL,	NULL,	NULL,	NULL,	'OKLAHOMA CITY',	'OK',	'CA3a46c4cff13ef350ed6ab7473802c379',	'+14052014241',	'completed',	33,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE0a1ef598ac7c8c71bea29c7f52998180',	0,	0,	'',	''),
(1761,	'CAddea9667e1eeb0454f68fa1bf6d52f0e',	'',	'2018-02-23 18:58:17',	'US',	'77901',	'TX',	'VICTORIA',	'US',	'77901',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13612105276',	'+13612103537',	'+13612105276',	NULL,	NULL,	NULL,	NULL,	'VICTORIA',	'TX',	'CAddea9667e1eeb0454f68fa1bf6d52f0e',	'+18327156360',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1762,	'CAc2ff3e533205a333ee04cc8def3e291f',	'',	'2018-02-23 18:59:15',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'70503',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13373033135',	'+19722036640',	'+13373033135',	NULL,	NULL,	NULL,	NULL,	'LAFAYETTE',	'LA',	'CAc2ff3e533205a333ee04cc8def3e291f',	'+19728157325',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE93127a131b43ce3290dd88db8c7749e9',	0,	0,	'',	''),
(1763,	'CA2597c26c74d7d60251967a05b03f74af',	'',	'2018-02-23 20:45:49',	'US',	'94509',	'CA',	'ANTIOCH',	'US',	'94509',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19252193774',	'+19252197932',	'+19252193774',	NULL,	NULL,	NULL,	NULL,	'ANTIOCH',	'CA',	'CA2597c26c74d7d60251967a05b03f74af',	'+19255840363',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1764,	'CAa22ae3e02777503a888c5ed97795e380',	'',	'2018-02-23 22:18:31',	'US',	'92122',	'CA',	'SAN DIEGO',	'US',	'92111',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16192159298',	'+16195548764',	'+16192159298',	NULL,	NULL,	NULL,	NULL,	'SAN DIEGO',	'CA',	'CAa22ae3e02777503a888c5ed97795e380',	'+16198233047',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1765,	'CA3503627e38d34649bb10d794f00bdc89',	'',	'2018-02-24 19:36:04',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'67203',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13168063982',	'+19722036640',	'+13168063982',	NULL,	NULL,	NULL,	NULL,	'WICHITA',	'KS',	'CA3503627e38d34649bb10d794f00bdc89',	'+19728157325',	'completed',	47,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE497550035c219f7af6453ac450800200',	0,	0,	'',	''),
(1766,	'CA266b7841cf081df2de2b272716103814',	'',	'2018-02-24 19:39:10',	'US',	'75024',	'TX',	'PLANO',	'US',	'67203',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13168063982',	'+19728051470',	'+13168063982',	NULL,	NULL,	NULL,	NULL,	'WICHITA',	'KS',	'CA266b7841cf081df2de2b272716103814',	'+12146824990',	'completed',	39,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc3bf800a9600e7b60f242b32e93dee69',	0,	0,	'',	''),
(1767,	'CA3e5d33cab76c0b269166f0c3e2fe7d23',	'',	'2018-02-26 03:04:18',	'US',	'74172',	'OK',	'TULSA',	'US',	'74146',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19186054615',	'+19186094615',	'+19186054615',	NULL,	NULL,	NULL,	NULL,	'TULSA',	'OK',	'CA3e5d33cab76c0b269166f0c3e2fe7d23',	'+19188009881',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1768,	'CA5d56e19d9e569fcdb18fc42a5ba273da',	'',	'2018-02-26 14:44:24',	'US',	'77995',	'TX',	'YOAKUM',	'US',	'78636',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18308682683',	'+13612983529',	'+18308682683',	NULL,	NULL,	NULL,	NULL,	'JOHNSON CITY',	'TX',	'CA5d56e19d9e569fcdb18fc42a5ba273da',	'+18327156360',	'completed',	29,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc254d48ef68f5b596b14ae4e6fa906f7',	0,	0,	'',	''),
(1769,	'CAfcf5f00cabb2e02beeb3baf3b406cc95',	'',	'2018-02-26 15:37:39',	'US',	'',	'OK',	'',	'US',	'73160',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14054458894',	'+14056731362',	'+14054458894',	NULL,	NULL,	NULL,	NULL,	'OKLAHOMA CITY',	'OK',	'CAfcf5f00cabb2e02beeb3baf3b406cc95',	'+14052014241',	'completed',	75,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE5e588b8d69946d9f0eb3237f853467ca',	0,	0,	'',	''),
(1770,	'CA93c20954a657432346d9e06805e7f7a8',	'',	'2018-02-26 21:14:25',	'US',	'75251',	'TX',	'DALLAS',	'US',	'97205',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15037444229',	'+19723854322',	'+15037444229',	NULL,	NULL,	NULL,	NULL,	'PORTLAND',	'OR',	'CA93c20954a657432346d9e06805e7f7a8',	'+12146628447',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REca97c4225b77e8eda8e3bfeaf3942154',	0,	0,	'',	''),
(1771,	'CA9a658e79ca7c1bee1b49aff33c0d4338',	'',	'2018-02-26 22:28:49',	'US',	'73149',	'OK',	'OKLAHOMA CITY',	'US',	'73005',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14052472508',	'+14052469915',	'+14052472508',	NULL,	NULL,	NULL,	NULL,	'ANADARKO',	'OK',	'CA9a658e79ca7c1bee1b49aff33c0d4338',	'+14052014241',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1772,	'CA490b2c154d52668aa3f68bdf660295a9',	'',	'2018-02-27 17:36:38',	'US',	'75201',	'TX',	'DALLAS',	'US',	'32216',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19043980080',	'+14696190565',	'+19043980080',	NULL,	NULL,	NULL,	NULL,	'JACKSONVILLE',	'FL',	'CA490b2c154d52668aa3f68bdf660295a9',	'+12146953999',	'completed',	38,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE2220f095c247ad5d43c4b36d5eb3adaf',	0,	0,	'',	''),
(1773,	'CAa53a4ab15254f77cd252bf8bdd619401',	'',	'2018-02-27 19:45:47',	'US',	'76248',	'TX',	'FORT WORTH',	'US',	'75234',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16823670546',	'+18179681164',	'+16823670546',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CAa53a4ab15254f77cd252bf8bdd619401',	'+18178814663',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE01bd19dfea699103659b8fa9830c625b',	0,	0,	'',	''),
(1774,	'CA55821440c7c1d070d8fe378cbe007c08',	'',	'2018-02-27 20:32:31',	'US',	'94108',	'CA',	'SAN FRANCISCO',	'US',	'94108',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15102306087',	'+15102300755',	'+15102306087',	NULL,	NULL,	NULL,	NULL,	'SAN FRANCISCO',	'CA',	'CA55821440c7c1d070d8fe378cbe007c08',	'+15106893859',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1775,	'CA1788c1489fa35241cd764feae493453a',	'',	'2018-02-27 22:37:23',	'US',	'85021',	'AZ',	'PHOENIX',	'US',	'85021',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16233770044',	'+16233779759',	'+16233770044',	NULL,	NULL,	NULL,	NULL,	'PHOENIX',	'AZ',	'CA1788c1489fa35241cd764feae493453a',	'+14802390652',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1776,	'CAab604d8f77e92c62241ddf21d5a2e3c2',	'',	'2018-02-28 15:51:26',	'US',	'85034',	'AZ',	'PHOENIX',	'US',	'31057',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14782357194',	'+14802691941',	'+14782357194',	NULL,	NULL,	NULL,	NULL,	'MARSHALLVILLE',	'GA',	'CAab604d8f77e92c62241ddf21d5a2e3c2',	'+14803882032',	'completed',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb2417be2bd47cdb1d514a90dac7a61c3',	0,	0,	'',	''),
(1777,	'CAf1dd1b0be5e8815d0cbf2f34d899de57',	'',	'2018-02-28 18:20:47',	'US',	'75024',	'TX',	'PLANO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14696426407',	'+19728051470',	'+14696426407',	NULL,	NULL,	NULL,	NULL,	'',	'TX',	'CAf1dd1b0be5e8815d0cbf2f34d899de57',	'+12146824990',	'completed',	6,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE05217ae0f6de94603a8596a91351e686',	0,	0,	'',	''),
(1778,	'CAb1089486e6e89d03caeb10ad32988148',	'',	'2018-02-28 18:22:45',	'US',	'73149',	'OK',	'OKLAHOMA CITY',	'US',	'43119',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16144021863',	'+14052469915',	'+16144021863',	NULL,	NULL,	NULL,	NULL,	'COLUMBUS',	'OH',	'CAb1089486e6e89d03caeb10ad32988148',	'+14052014241',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1779,	'CA8b5eaa56b0e876a14506f95e6e79be1f',	'',	'2018-02-28 19:58:25',	'US',	'',	'TX',	'',	'US',	'75115',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14696438279',	'+14695303089',	'+14696438279',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CA8b5eaa56b0e876a14506f95e6e79be1f',	'+14695853442',	'completed',	2,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE1e8308205cc1c3800761d3fa01d02fc4',	0,	0,	'',	''),
(1780,	'CA012f98dfbe6ef26655f7f9aeae1527ee',	'',	'2018-02-28 22:19:47',	'US',	'',	'AZ',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14807255663',	'+14807250833',	'+14807255663',	NULL,	NULL,	NULL,	NULL,	'',	'AZ',	'CA012f98dfbe6ef26655f7f9aeae1527ee',	'+14802390652',	'completed',	17,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd44e49c4322b72d937084f30851f1a11',	0,	0,	'',	''),
(1781,	'CAec95eb752c88b01b63341cd8abd7d9e1',	'',	'2018-02-28 22:48:10',	'US',	'76210',	'TX',	'DENTON',	'US',	'73401',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15802226936',	'+19402203090',	'+15802226936',	NULL,	NULL,	NULL,	NULL,	'ARDMORE',	'OK',	'CAec95eb752c88b01b63341cd8abd7d9e1',	'+19402315995',	'completed',	59,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4cf679cb342440220f64df69fbdb5e9c',	0,	0,	'',	''),
(1782,	'CAb927f5f9c8f1d0dfc99f2c9401646590',	'',	'2018-02-28 22:51:04',	'US',	'76210',	'TX',	'DENTON',	'US',	'73401',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15802226936',	'+19402203539',	'+15802226936',	NULL,	NULL,	NULL,	NULL,	'ARDMORE',	'OK',	'CAb927f5f9c8f1d0dfc99f2c9401646590',	'+19727954260',	'completed',	47,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE2b1ca5bc07639050564e963b21a68519',	0,	0,	'',	''),
(1783,	'CA58167f9903f19c2c337047ced5afe62a',	'',	'2018-02-28 23:30:53',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'67002',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13163616692',	'+19722036218',	'+13163616692',	NULL,	NULL,	NULL,	NULL,	'ANDOVER',	'KS',	'CA58167f9903f19c2c337047ced5afe62a',	'+12147183718',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1784,	'CA39546f1636e7782eec31476fd67ec0e9',	'',	'2018-03-01 15:26:13',	'US',	'76210',	'TX',	'DENTON',	'US',	'85237',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15202000526',	'+19402203356',	'+15202000526',	NULL,	NULL,	NULL,	NULL,	'WINKELMAN',	'AZ',	'CA39546f1636e7782eec31476fd67ec0e9',	'+19402315995',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE8f6f0027cc8f9aea18b119d624048e69',	0,	0,	'',	''),
(1785,	'CAe98d87a83c31165ed787f3351f5eb151',	'',	'2018-03-01 15:35:53',	'US',	'76226',	'TX',	'ARGYLE',	'US',	'77053',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17134346316',	'+19402948166',	'+17134346316',	NULL,	NULL,	NULL,	NULL,	'HOUSTON',	'TX',	'CAe98d87a83c31165ed787f3351f5eb151',	'+12146953999',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1786,	'CA29013bf4fd98849c6fd457bbf9eeb7aa',	'',	'2018-03-01 15:36:07',	'US',	'76226',	'TX',	'ARGYLE',	'US',	'77053',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17134346316',	'+19402948166',	'+17134346316',	NULL,	NULL,	NULL,	NULL,	'HOUSTON',	'TX',	'CA29013bf4fd98849c6fd457bbf9eeb7aa',	'+12146953999',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4dfeb80074a1c7f64bcc095a8a7d6030',	0,	0,	'',	''),
(1787,	'CA732dd78733f84607b647598fd4767270',	'',	'2018-03-01 17:19:39',	'US',	'85034',	'AZ',	'PHOENIX',	'US',	'85034',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14802694163',	'+14802691941',	'+14802694163',	NULL,	NULL,	NULL,	NULL,	'PHOENIX',	'AZ',	'CA732dd78733f84607b647598fd4767270',	'+14803882032',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1788,	'CA0c5397f8b44b6a2519998fe1b61b5cdd',	'',	'2018-03-01 18:45:07',	'US',	'85034',	'AZ',	'PHOENIX',	'US',	'85034',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14802694163',	'+14802691941',	'+14802694163',	NULL,	NULL,	NULL,	NULL,	'PHOENIX',	'AZ',	'CA0c5397f8b44b6a2519998fe1b61b5cdd',	'+14803882032',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1789,	'CAe4f761ba85c8c4e46a09031cc1806ffc',	'',	'2018-03-01 20:43:17',	'US',	'76210',	'TX',	'DENTON',	'US',	'76210',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19402201979',	'+19402203090',	'+19402201979',	NULL,	NULL,	NULL,	NULL,	'DENTON',	'TX',	'CAe4f761ba85c8c4e46a09031cc1806ffc',	'+19402315995',	'completed',	28,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3e696101cb2d1b754f39489c9dfd8ce0',	0,	0,	'',	''),
(1790,	'CAca5aa35025583b5314f79eb024b7584a',	'',	'2018-03-01 21:00:49',	'US',	'',	'TX',	'',	'US',	'75115',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14696438279',	'+14695303089',	'+14696438279',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CAca5aa35025583b5314f79eb024b7584a',	'+14695853442',	'completed',	28,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE947a8433164e573be9fd13bb9cdc3273',	0,	0,	'',	''),
(1791,	'CAaca34d9a91d7ee1938896e25c9f78b5e',	'',	'2018-03-01 21:49:35',	'US',	'83001',	'WY',	'JACKSON',	'US',	'92003',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+13072014710',	'+17606757371',	NULL,	NULL,	NULL,	NULL,	'CAMP PENDLETON',	'CA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1792,	'CA593e8b64e0d751738d66f296c001d8bc',	'',	'2018-03-01 22:00:41',	'US',	'83001',	'WY',	'JACKSON',	'US',	'92003',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+13072014710',	'+17606757371',	NULL,	NULL,	NULL,	NULL,	'CAMP PENDLETON',	'CA',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1793,	'CA93513aa344629daa4d678af977765688',	'',	'2018-03-01 23:10:57',	'US',	'75202',	'TX',	'DALLAS',	'US',	'85027',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16232348805',	'+12149221949',	'+16232348805',	NULL,	NULL,	NULL,	NULL,	'PHOENIX',	'AZ',	'CA93513aa344629daa4d678af977765688',	'+12147851535',	'completed',	55,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa3e84ecc0a6e302b29a009a1eb2be89e',	0,	0,	'',	''),
(1794,	'CA3b8b807132550babd7651ab7276aad94',	'',	'2018-03-02 00:20:31',	'US',	'',	'TX',	'',	'US',	'75050',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12149090685',	'+14695303089',	'+12149090685',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CA3b8b807132550babd7651ab7276aad94',	'+14695853442',	'completed',	334,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa755e865baf041dd2c6c770872c02959',	0,	0,	'',	''),
(1795,	'CAb95a65acd1d8f9829b7784202e6a3a0c',	'',	'2018-03-02 00:23:08',	'US',	'',	'NV',	'',	'US',	'89118',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17029148764',	'+17029195831',	'+17029148764',	NULL,	NULL,	NULL,	NULL,	'LAS VEGAS',	'NV',	'CAb95a65acd1d8f9829b7784202e6a3a0c',	'+17252223264',	'completed',	17,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REcc14e3d31602770d22d7ce037c3f81fb',	0,	0,	'',	''),
(1796,	'CAdcfb5ed3fed90b0b9a7bcce64e291c01',	'',	'2018-03-02 15:46:21',	'US',	'77995',	'TX',	'YOAKUM',	'US',	'67156',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16202627574',	'+13612983529',	'+16202627574',	NULL,	NULL,	NULL,	NULL,	'WINFIELD',	'KS',	'CAdcfb5ed3fed90b0b9a7bcce64e291c01',	'+18327156360',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3d9109ee0b0f635136e88364568af76e',	0,	0,	'',	''),
(1797,	'CAf01f720dbdb58621e5aa67cb5597a572',	'',	'2018-03-02 16:53:49',	'US',	'',	'TX',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18327069234',	'+18327064084',	'+18327069234',	NULL,	NULL,	NULL,	NULL,	'',	'TX',	'CAf01f720dbdb58621e5aa67cb5597a572',	'+18327156360',	'completed',	33,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf1db7df115785824351875d41d21cf30',	0,	0,	'',	''),
(1798,	'CAc31a18c1546dc594c11df189eedbeffb',	'',	'2018-03-02 18:10:28',	'US',	'',	'CA',	'',	'US',	'90402',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13108712495',	'+19168238963',	'+13108712495',	NULL,	NULL,	NULL,	NULL,	'BEVERLY HILLS',	'CA',	'CAc31a18c1546dc594c11df189eedbeffb',	'+19162243237',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE39075ab9295c2bad9dbab650bec1421c',	0,	0,	'',	''),
(1799,	'CA8707647b3d3c529e294e01b089f8bc96',	'',	'2018-03-02 19:38:53',	'US',	'75002',	'TX',	'ALLEN',	'US',	'75241',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12144316816',	'+19729546137',	'+12144316816',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CA8707647b3d3c529e294e01b089f8bc96',	'+19402315995',	'completed',	20,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REbc0bac8c2c2fc64eb46be5dc64769666',	0,	0,	'',	''),
(1800,	'CA8e91bc8a71957697823596c636eb6cf5',	'',	'2018-03-02 20:19:49',	'US',	'',	'OK',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18777657446',	'+14056731362',	'+18777657446',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA8e91bc8a71957697823596c636eb6cf5',	'+14052014241',	'completed',	47,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3a675326cda9032b3cab84b83a0372fc',	0,	0,	'',	''),
(1801,	'CA11b3a0e3a47fc5d035b4374ce1025f70',	'',	'2018-03-02 20:21:16',	'US',	'88065',	'NM',	'SILVER CITY',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18777657446',	'+15053880240',	'+18777657446',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA11b3a0e3a47fc5d035b4374ce1025f70',	'+15053192181',	'completed',	41,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb2e172c75ac29865ea764c2521fd654e',	0,	0,	'',	''),
(1802,	'CAe6da29b241fbe7decba6ed9b05cfcfe5',	'',	'2018-03-03 15:11:10',	'US',	'94553',	'CA',	'MARTINEZ',	'US',	'94514',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19256342735',	'+19252313411',	'+19256342735',	NULL,	NULL,	NULL,	NULL,	'BRENTWOOD',	'CA',	'CAe6da29b241fbe7decba6ed9b05cfcfe5',	'+19255840363',	'completed',	79,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE2a641830ee534262937779c6b6d871ee',	0,	0,	'',	''),
(1803,	'CAf3c7d03caab795117b63e558808bd078',	'',	'2018-03-03 19:31:32',	'US',	'75234',	'TX',	'CARROLLTON',	'US',	'76704',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18177566508',	'+14695578827',	'+18177566508',	NULL,	NULL,	NULL,	NULL,	'GRAPEVINE',	'TX',	'CAf3c7d03caab795117b63e558808bd078',	'+19402315995',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE174fd44e15901fca159e768037e8a638',	0,	0,	'',	''),
(1804,	'CA0c353caf1521814967aadba4f1f1e6a8',	'',	'2018-03-03 20:17:02',	'US',	'',	'TX',	'',	'US',	'76111',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18177026179',	'+16823053491',	'+18177026179',	NULL,	NULL,	NULL,	NULL,	'FORT WORTH',	'TX',	'CA0c353caf1521814967aadba4f1f1e6a8',	'+18178814663',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE2493f26428132e16e1b4479b541ce22f',	0,	0,	'',	''),
(1805,	'CA57ed0cdd44cf2c4903a97dff079c9ac7',	'',	'2018-03-04 00:03:15',	'US',	'76071',	'TX',	'AZLE',	'US',	'75442',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19726945069',	'+18178138165',	'+19726945069',	NULL,	NULL,	NULL,	NULL,	'CADDO MILLS',	'TX',	'CA57ed0cdd44cf2c4903a97dff079c9ac7',	'+18173042914',	'completed',	15,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE2b5a014094e5e9102b7d36b141b2088a',	0,	0,	'',	''),
(1806,	'CA5b9ec39effa0ab7a97472929f1755af4',	'',	'2018-03-04 21:29:54',	'US',	'',	'TX',	'',	'US',	'76180',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18177130526',	'+16828032153',	'+18177130526',	NULL,	NULL,	NULL,	NULL,	'FORT WORTH',	'TX',	'CA5b9ec39effa0ab7a97472929f1755af4',	'+18173042914',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1807,	'CAbfc557431df1c29e33f266e69c378434',	'',	'2018-03-05 18:25:56',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75007',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19723073552',	'+19722036218',	'+19723073552',	NULL,	NULL,	NULL,	NULL,	'CARROLLTON',	'TX',	'CAbfc557431df1c29e33f266e69c378434',	'+12147183718',	'no-answer',	3,	NULL,	0,	0,	'',	''),
(1808,	'CA1aca458c90e1cda142268879c70ae156',	'',	'2018-03-05 18:35:26',	'US',	'75152',	'TX',	'PALMER',	'US',	'75062',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14699958980',	'+14692146402',	'+14699958980',	NULL,	NULL,	NULL,	NULL,	'IRVING',	'TX',	'CA1aca458c90e1cda142268879c70ae156',	'+12146953999',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1809,	'CA21e2044a8d4fa3ea9be20fd17d347ced',	'',	'2018-03-05 18:39:10',	'US',	'85034',	'AZ',	'PHOENIX',	'US',	'85034',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14802697439',	'+14802691941',	'+14802697439',	NULL,	NULL,	NULL,	NULL,	'PHOENIX',	'AZ',	'CA21e2044a8d4fa3ea9be20fd17d347ced',	'+14803882032',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1810,	'CA0724290397bfd30e0853d00777f3f7bc',	'',	'2018-03-05 18:48:19',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75230',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12147664078',	'+19722036640',	'+12147664078',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CA0724290397bfd30e0853d00777f3f7bc',	'+19728157325',	'completed',	82,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE98ef661470511bedccf2a1a64cd051b1',	0,	0,	'',	''),
(1811,	'CAc2f6cf172e7965cb7325250f2f0802d8',	'',	'2018-03-05 20:00:41',	'US',	'73149',	'OK',	'OKLAHOMA CITY',	'US',	'73005',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14052475413',	'+14052469915',	'+14052475413',	NULL,	NULL,	NULL,	NULL,	'ANADARKO',	'OK',	'CAc2f6cf172e7965cb7325250f2f0802d8',	'+14052014241',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1812,	'CA9f9b52cb1d5316fec0be2e649bb9144d',	'',	'2018-03-05 20:00:42',	'US',	'73149',	'OK',	'OKLAHOMA CITY',	'US',	'73005',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14052475413',	'+14052469915',	'+14052475413',	NULL,	NULL,	NULL,	NULL,	'ANADARKO',	'OK',	'CA9f9b52cb1d5316fec0be2e649bb9144d',	'+14052014241',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1813,	'CA648b9186adaab97d9b85926720f3f1c4',	'',	'2018-03-05 20:00:44',	'US',	'73149',	'OK',	'OKLAHOMA CITY',	'US',	'73005',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14052475413',	'+14052469915',	'+14052475413',	NULL,	NULL,	NULL,	NULL,	'ANADARKO',	'OK',	'CA648b9186adaab97d9b85926720f3f1c4',	'+14052014241',	'completed',	4,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE2fb82560037a852d9a1742d63fcbd086',	0,	0,	'',	''),
(1814,	'CAb0cdb69cd244ee7140ffb63aaa5d5478',	'',	'2018-03-05 20:13:49',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'78767',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15124843574',	'+19722036218',	'+15124843574',	NULL,	NULL,	NULL,	NULL,	'AUSTIN',	'TX',	'CAb0cdb69cd244ee7140ffb63aaa5d5478',	'+12147183718',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1815,	'CA8d71ce305ac5354305b3c0f2e365bd0b',	'',	'2018-03-05 20:54:51',	'US',	'76210',	'TX',	'DENTON',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12134294001',	'+19402203619',	'+12134294001',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA8d71ce305ac5354305b3c0f2e365bd0b',	'+16172334088',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1816,	'CA19e20371782257cb2b94b0e6d6b710d3',	'',	'2018-03-06 15:33:38',	'US',	'30312',	'GA',	'ATLANTA',	'US',	'30312',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14044768576',	'+14044765368',	'+14044768576',	NULL,	NULL,	NULL,	NULL,	'ATLANTA',	'GA',	'CA19e20371782257cb2b94b0e6d6b710d3',	'+14042107184',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1817,	'CAca52c43c0e58caec81235e3380231161',	'',	'2018-03-06 17:46:40',	'US',	'75152',	'TX',	'PALMER',	'US',	'80021',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17208880025',	'+14692146402',	'+17208880025',	NULL,	NULL,	NULL,	NULL,	'DENVER',	'CO',	'CAca52c43c0e58caec81235e3380231161',	'+12146953999',	'completed',	95,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE88e55ad227f2080f8be0c06de0d22d2f',	0,	0,	'',	''),
(1818,	'CAdd795375d5f5df59be44b8ec095f1820',	'',	'2018-03-06 19:00:16',	'US',	'94509',	'CA',	'ANTIOCH',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18143770204',	'+19252197932',	'+18143770204',	NULL,	NULL,	NULL,	NULL,	'',	'PA',	'CAdd795375d5f5df59be44b8ec095f1820',	'+19255840363',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf29c35707a1ef7eb182b800b162b2b49',	0,	0,	'',	''),
(1819,	'CAbaedfe3a28b6aa76312b6616f93722d5',	'',	'2018-03-06 19:42:57',	'US',	'76111',	'TX',	'FORT WORTH',	'US',	'76009',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18174777540',	'+18178864375',	'+18174777540',	NULL,	NULL,	NULL,	NULL,	'MANSFIELD',	'TX',	'CAbaedfe3a28b6aa76312b6616f93722d5',	'+18173042914',	'completed',	206,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE45cab3ea7e37a267e333f37d53ad0411',	0,	0,	'',	''),
(1820,	'CAabe09dc5a1fd5bdfe9176d623321923f',	'',	'2018-03-06 21:08:59',	'US',	'75244',	'TX',	'DALLAS',	'US',	'75052',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12146793304',	'+19729190409',	'+12146793304',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CAabe09dc5a1fd5bdfe9176d623321923f',	'+19728157325',	'completed',	49,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd010aa5b86dec10889499c2aa423464d',	0,	0,	'',	''),
(1821,	'CA0192e4a5f25a4628daed4b0d38b3c5fa',	'',	'2018-03-06 22:49:28',	'US',	'85034',	'AZ',	'PHOENIX',	'US',	'85034',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14802693080',	'+14802691941',	'+14802693080',	NULL,	NULL,	NULL,	NULL,	'PHOENIX',	'AZ',	'CA0192e4a5f25a4628daed4b0d38b3c5fa',	'+14803882032',	'completed',	2,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE59af48b64b981efa75211e426a507107',	0,	0,	'',	''),
(1822,	'CAe990762385455e64ff52ae778e15794a',	'',	'2018-03-07 00:50:06',	'US',	'73101',	'OK',	'OKLAHOMA CITY',	'US',	'73089',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14053812375',	'+14052252057',	'+14053812375',	NULL,	NULL,	NULL,	NULL,	'TUTTLE',	'OK',	'CAe990762385455e64ff52ae778e15794a',	'+14052014241',	'completed',	14,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REcd6374917dfe2c67b6df6127b79c6007',	0,	0,	'',	''),
(1823,	'CAc23d937b57dce897092e4fc9a1a51160',	'',	'2018-03-07 15:27:09',	'US',	'77995',	'TX',	'YOAKUM',	'US',	'75007',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19728650201',	'+13612983529',	'+19728650201',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CAc23d937b57dce897092e4fc9a1a51160',	'+18327156360',	'completed',	26,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE8ebe1ca10f8fa44822d449c68ec6f023',	0,	0,	'',	''),
(1824,	'CA28763cf94a13f04cdfc1bf0dd1a7e6b1',	'',	'2018-03-07 15:50:10',	'US',	'88065',	'NM',	'SILVER CITY',	'US',	'87198',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15053853391',	'+15053880240',	'+15053853391',	NULL,	NULL,	NULL,	NULL,	'ALBUQUERQUE',	'NM',	'CA28763cf94a13f04cdfc1bf0dd1a7e6b1',	'+15053192181',	'completed',	14,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE6f673929639cc1e2b1ab844204489de6',	0,	0,	'',	''),
(1825,	'CAb4f513401a178a277df373ace469a193',	'',	'2018-03-07 16:07:18',	'US',	'75152',	'TX',	'PALMER',	'US',	'75062',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14699958980',	'+14692146402',	'+14699958980',	NULL,	NULL,	NULL,	NULL,	'IRVING',	'TX',	'CAb4f513401a178a277df373ace469a193',	'+12146953999',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1826,	'CA429f9247a8e435e7a92c51cbaf8781ee',	'',	'2018-03-07 17:35:45',	'US',	'75002',	'TX',	'ALLEN',	'US',	'75244',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12144580624',	'+19729546137',	'+12144580624',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CA429f9247a8e435e7a92c51cbaf8781ee',	'+19402315995',	'completed',	27,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf9908f9df1fc3f7c3aee5589aaab1d06',	0,	0,	'',	''),
(1827,	'CA11dc11fdc5cd8fb01fd39fce8aa9d0dc',	'',	'2018-03-07 18:30:56',	'US',	'',	'TX',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13467187170',	'+17133227812',	'+13467187170',	NULL,	NULL,	NULL,	NULL,	'Houston',	'TX',	'CA11dc11fdc5cd8fb01fd39fce8aa9d0dc',	'+13462347725',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE059bad50a916241b3530a1a0230331c4',	0,	0,	'',	''),
(1828,	'CA3bdef037fed5bfb40d73beca132d49e8',	'',	'2018-03-07 18:31:42',	'US',	'',	'TX',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13467187170',	'+18329814887',	'+13467187170',	NULL,	NULL,	NULL,	NULL,	'Houston',	'TX',	'CA3bdef037fed5bfb40d73beca132d49e8',	'+13462347725',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1829,	'CAbdfcf98756c9df4676e45befe0ea5005',	'',	'2018-03-07 19:13:08',	'US',	'94509',	'CA',	'ANTIOCH',	'US',	'94509',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19252191687',	'+19252197932',	'+19252191687',	NULL,	NULL,	NULL,	NULL,	'ANTIOCH',	'CA',	'CAbdfcf98756c9df4676e45befe0ea5005',	'+19255840363',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1830,	'CAdbc437446dc12f0844923e866d48679a',	'',	'2018-03-07 20:39:16',	'US',	'76210',	'TX',	'DENTON',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18777657446',	'+19402203619',	'+18777657446',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CAdbc437446dc12f0844923e866d48679a',	'+16172334088',	'completed',	39,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE156dcf6480175f808d4c1e34f9e90468',	0,	0,	'',	''),
(1831,	'CAbc6f8ebd6f7a0833da4f5de14cea6fd2',	'',	'2018-03-07 20:40:43',	'US',	'88101',	'NM',	'CLOVIS',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18777657446',	'+15052194134',	'+18777657446',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CAbc6f8ebd6f7a0833da4f5de14cea6fd2',	'+15053192181',	'completed',	22,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3a39220bf24d517358ffa139e0dcccde',	0,	0,	'',	''),
(1832,	'CAe8d1781da452d5120117fd9186c60656',	'',	'2018-03-07 20:41:17',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18777657446',	'+19166340519',	'+18777657446',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CAe8d1781da452d5120117fd9186c60656',	'+19166287355',	'completed',	40,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REdc0c4b17eea3c3d07fb6d6ac80140717',	0,	0,	'',	''),
(1833,	'CA192f33b227a2cd43c117c59af099da50',	'',	'2018-03-07 20:41:49',	'US',	'92123',	'CA',	'SAN DIEGO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18777657446',	'+16194323549',	'+18777657446',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA192f33b227a2cd43c117c59af099da50',	'+16198233047',	'completed',	17,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE5913af30dda349ad37711cfd5e960dc3',	0,	0,	'',	''),
(1834,	'CAba45e5828f5e5493a870851fd8ead5d5',	'',	'2018-03-07 20:42:33',	'US',	'95762',	'CA',	'FOLSOM',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18777657446',	'+19162358117',	'+18777657446',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CAba45e5828f5e5493a870851fd8ead5d5',	'+19163975518',	'completed',	45,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd089de05b862baea254dac8fc72bf5e2',	0,	0,	'',	''),
(1835,	'CA7231a4ebbf75a2805455fdd92db6abde',	'',	'2018-03-07 22:38:27',	'US',	'94553',	'CA',	'MARTINEZ',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18880021018',	'+19252319862',	'+18880021018',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA7231a4ebbf75a2805455fdd92db6abde',	'+19255840363',	'completed',	2,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4461f2befe80dc4d2251dd5f426cb0e6',	0,	0,	'',	''),
(1836,	'CAfb515df0748fbb65424f84247bfac247',	'',	'2018-03-08 02:29:03',	'US',	'88240',	'NM',	'JAL',	'US',	'87123',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15052031326',	'+15053955347',	'+15052031326',	NULL,	NULL,	NULL,	NULL,	'ALBUQUERQUE',	'NM',	'CAfb515df0748fbb65424f84247bfac247',	'+15053192181',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1837,	'CA000ea35b6943922a5686d380de1ef8a6',	'',	'2018-03-08 02:29:51',	'US',	'88101',	'NM',	'CLOVIS',	'US',	'87123',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15052031326',	'+15052194134',	'+15052031326',	NULL,	NULL,	NULL,	NULL,	'ALBUQUERQUE',	'NM',	'CA000ea35b6943922a5686d380de1ef8a6',	'+15053192181',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1838,	'CA2887d7b57fa5fa087c4d5ed38a27cad7',	'',	'2018-03-08 02:56:04',	'US',	'88065',	'NM',	'SILVER CITY',	'US',	'87123',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15052031326',	'+15053880240',	'+15052031326',	NULL,	NULL,	NULL,	NULL,	'ALBUQUERQUE',	'NM',	'CA2887d7b57fa5fa087c4d5ed38a27cad7',	'+15053192181',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1839,	'CA85a6c5b5ff4f73046793af2b45314e70',	'',	'2018-03-08 16:17:18',	'US',	'73149',	'OK',	'OKLAHOMA CITY',	'US',	'73005',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14052474392',	'+14052469915',	'+14052474392',	NULL,	NULL,	NULL,	NULL,	'ANADARKO',	'OK',	'CA85a6c5b5ff4f73046793af2b45314e70',	'+14052014241',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1840,	'CAd64777b87f6003bcd589e1891cd40836',	'',	'2018-03-08 18:21:54',	'US',	'75062',	'TX',	'IRVING',	'US',	'76105',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18172010914',	'+18172038813',	'+18172010914',	NULL,	NULL,	NULL,	NULL,	'FORT WORTH',	'TX',	'CAd64777b87f6003bcd589e1891cd40836',	'+12146628447',	'completed',	38,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa30c844e5b8ba1fe7108ad11c406958d',	0,	0,	'',	''),
(1841,	'CA45505610ac98200a45f6d769efada95c',	'',	'2018-03-08 18:25:33',	'US',	'75202',	'TX',	'DALLAS',	'US',	'76018',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12146628447',	'+12149221949',	'+12146628447',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CA45505610ac98200a45f6d769efada95c',	'+12147851535',	'completed',	26,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf9116d12ebadc4303ef908f1eb9dfa7c',	0,	0,	'',	''),
(1842,	'CA56be2e0ac36b143a481f7ea87cf97095',	'',	'2018-03-08 22:07:27',	'US',	'94553',	'CA',	'MARTINEZ',	'US',	'94513',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19257870281',	'+19252313287',	'+19257870281',	NULL,	NULL,	NULL,	NULL,	'CONCORD',	'CA',	'CA56be2e0ac36b143a481f7ea87cf97095',	'+19255840363',	'completed',	54,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE8706eaa14d44922664e701eded212604',	0,	0,	'',	''),
(1843,	'CAb6530257f17a1b7dd947d7d354ce7650',	'',	'2018-03-08 23:03:46',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'76262',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12144780543',	'+19722036640',	'+12144780543',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CAb6530257f17a1b7dd947d7d354ce7650',	'+19728157325',	'completed',	654,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc4e6dc84089e65979305ecfca8412457',	0,	0,	'',	''),
(1844,	'CA6e791f25ef5686f1d51ddcc1f310f61f',	'',	'2018-03-08 23:23:39',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'76262',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12144780543',	'+19722036640',	'+12144780543',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CA6e791f25ef5686f1d51ddcc1f310f61f',	'+19728157325',	'completed',	177,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE52d28a0d40bfe6f84370b34108197263',	0,	0,	'',	''),
(1845,	'CA2d7c9dc5908f1bb1f7701b3d7f556081',	'',	'2018-03-09 14:06:47',	'US',	'75002',	'TX',	'ALLEN',	'US',	'75062',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19729516960',	'+19729546137',	'+19729516960',	NULL,	NULL,	NULL,	NULL,	'IRVING',	'TX',	'CA2d7c9dc5908f1bb1f7701b3d7f556081',	'+19402315995',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1846,	'CA8183a432225ec9b3f11b4c02e3dcf056',	'',	'2018-03-09 14:07:01',	'US',	'75002',	'TX',	'ALLEN',	'US',	'75038',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19722526060',	'+19729546137',	'+19722526060',	NULL,	NULL,	NULL,	NULL,	'IRVING',	'TX',	'CA8183a432225ec9b3f11b4c02e3dcf056',	'+19402315995',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE732b93621d183350bee5283aaaf76933',	0,	0,	'',	''),
(1847,	'CA11c8371e86cdd9658cfb82dd171a8a5a',	'',	'2018-03-09 16:05:24',	'US',	'',	'TX',	'',	'US',	'83713',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12084720214',	'+17133227812',	'+12084720214',	NULL,	NULL,	NULL,	NULL,	'BOISE',	'ID',	'CA11c8371e86cdd9658cfb82dd171a8a5a',	'+13462347725',	'completed',	30,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE7c3b4bdcf175f24bd82162d3e4e40afb',	0,	0,	'',	''),
(1848,	'CAebb70edd13996c2248eea2a617c2d794',	'',	'2018-03-09 16:06:08',	'US',	'',	'TX',	'',	'US',	'83713',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12084720214',	'+18327064084',	'+12084720214',	NULL,	NULL,	NULL,	NULL,	'BOISE',	'ID',	'CAebb70edd13996c2248eea2a617c2d794',	'+18327156360',	'completed',	12,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE35e7665b4ea8c1b464c90201e4093d1d',	0,	0,	'',	''),
(1849,	'CA57f67c0e292ff9d780b5a80f6fa0027c',	'',	'2018-03-09 16:34:07',	'US',	'76071',	'TX',	'AZLE',	'US',	'76548',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12147961784',	'+18178138165',	'+12147961784',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CA57f67c0e292ff9d780b5a80f6fa0027c',	'+18173042914',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REfbc375bdc90b2a0076fd67e2d6d3855a',	0,	0,	'',	''),
(1850,	'CA552ebd0b0ecd27e602981475de9a6bc5',	'',	'2018-03-09 18:32:27',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19165824051',	'+19165849127',	'+19165824051',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA552ebd0b0ecd27e602981475de9a6bc5',	'+19166287355',	'completed',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE25a36ebc0b0d27835cee6b9f3b162471',	0,	0,	'',	''),
(1851,	'CA9ffffd64938cf39c525df6ffeba85014',	'',	'2018-03-09 19:11:49',	'US',	'75254',	'TX',	'DALLAS',	'US',	'75230',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12145276216',	'+19728611197',	'+12145276216',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CA9ffffd64938cf39c525df6ffeba85014',	'+12147183718',	'completed',	6,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE8a2921558154f273666289b9abcbd85c',	0,	0,	'',	''),
(1852,	'CAa17ca58a25f4e28b98d88a40c59b9da6',	'',	'2018-03-09 19:19:57',	'US',	'75082',	'TX',	'DALLAS',	'US',	'75062',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12144993065',	'+19723625222',	'+12144993065',	NULL,	NULL,	NULL,	NULL,	'IRVING',	'TX',	'CAa17ca58a25f4e28b98d88a40c59b9da6',	'+12147183718',	'completed',	52,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3a12634a1abb687d8e449e79c78fae2d',	0,	0,	'',	''),
(1853,	'CAb1eb8a408b9b82d3b91029e933cb75ec',	'',	'2018-03-09 21:26:51',	'US',	'92122',	'CA',	'SAN DIEGO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16193694058',	'+16195548764',	'+16193694058',	NULL,	NULL,	NULL,	NULL,	'SNDG SNDG',	'CA',	'CAb1eb8a408b9b82d3b91029e933cb75ec',	'+16198233047',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1854,	'CAe35d5feff69003d969a64ca2bef3ab41',	'',	'2018-03-09 23:53:16',	'US',	'87828',	'NM',	'SOCORRO',	'US',	'60645',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17732909384',	'+15058352287',	'+17732909384',	NULL,	NULL,	NULL,	NULL,	'CHICAGO',	'IL',	'CAe35d5feff69003d969a64ca2bef3ab41',	'+15053192181',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REaed42ff507928898db14426250466a15',	0,	0,	'',	''),
(1855,	'CA57229b8653f6925eefd851b23c994b7f',	'',	'2018-03-10 03:06:32',	'US',	'75182',	'TX',	'SUNNYVALE',	'CA',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15877005450',	'+19722036640',	'+15877005450',	NULL,	NULL,	NULL,	NULL,	'CALGARY',	'AB',	'CA57229b8653f6925eefd851b23c994b7f',	'+19728157325',	'completed',	453,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE6f16d19fdf22b56d1983d64399b85f6a',	0,	0,	'',	''),
(1856,	'CA75553fb2ff92d1af89302be7b29e5170',	'',	'2018-03-10 18:19:46',	'US',	'22306',	'MD',	'ALEXANDRIA',	'US',	'20695',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13013964127',	'+12403453492',	'+13013964127',	NULL,	NULL,	NULL,	NULL,	'WALDORF',	'MD',	'CA75553fb2ff92d1af89302be7b29e5170',	'+12024123578',	'completed',	51,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE655b1e5ad1c85b04333cb36f34d150a2',	0,	0,	'',	''),
(1857,	'CA5d3b97d3dd263ef49bc3e0a963777df2',	'',	'2018-03-10 19:28:01',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75182',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19722038073',	'+19722036218',	'+19722038073',	NULL,	NULL,	NULL,	NULL,	'SUNNYVALE',	'TX',	'CA5d3b97d3dd263ef49bc3e0a963777df2',	'+12147183718',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1858,	'CA25a8da81a129faddfad9baeccd9491de',	'',	'2018-03-10 21:00:40',	'US',	'92085',	'CA',	'VISTA',	'US',	'92211',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17605680170',	'+17604073880',	'+17605680170',	NULL,	NULL,	NULL,	NULL,	'PALM DESERT',	'CA',	'CA25a8da81a129faddfad9baeccd9491de',	'+17602378044',	'completed',	30,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE2412f83cf75d3610d9054aa2aea8f1ce',	0,	0,	'',	''),
(1859,	'CAdd8c9c8141cc817b90ea9336b5cd2855',	'',	'2018-03-11 15:30:24',	'US',	'92118',	'CA',	'CORONADO',	'US',	'91941',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16194033959',	'+16193136751',	'+16194033959',	NULL,	NULL,	NULL,	NULL,	'SAN DIEGO',	'CA',	'CAdd8c9c8141cc817b90ea9336b5cd2855',	'+16198233047',	'completed',	29,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe746dce3af5691a34336547a19e4fa6a',	0,	0,	'',	''),
(1860,	'CAc7ab9054a3b189920fc02b35e30993bb',	'',	'2018-03-11 22:58:43',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75063',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19724569188',	'+19722036218',	'+19724569188',	NULL,	NULL,	NULL,	NULL,	'IRVING',	'TX',	'CAc7ab9054a3b189920fc02b35e30993bb',	'+12147183718',	'completed',	6,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE9bbd2b4fc55b874ab36c9820692001a0',	0,	0,	'',	''),
(1861,	'CA9dff3ec5e11783344758db2b058051aa',	'',	'2018-03-12 14:37:56',	'US',	'',	'TX',	'',	'US',	'75601',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19039443964',	'+14695303089',	'+19039443964',	NULL,	NULL,	NULL,	NULL,	'LONGVIEW',	'TX',	'CA9dff3ec5e11783344758db2b058051aa',	'+14695853442',	'completed',	142,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc2e045a28a631efaae5ea35f32f7c749',	0,	0,	'',	''),
(1862,	'CA9129da58b79ee84b1c54e83522918a87',	'',	'2018-03-12 16:41:20',	'US',	'',	'TX',	'',	'US',	'64106',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18169124021',	'+14695356358',	'+18169124021',	NULL,	NULL,	NULL,	NULL,	'KANSAS CITY',	'MO',	'CA9129da58b79ee84b1c54e83522918a87',	'+19402315995',	'completed',	24,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd4acde89fb7f1c06dc16eb83a661c94e',	0,	0,	'',	''),
(1863,	'CA9f952fac2ede239411f22408b3695525',	'',	'2018-03-12 17:25:07',	'US',	'',	'TX',	'',	'US',	'75235',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12149628554',	'+14695303089',	'+12149628554',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CA9f952fac2ede239411f22408b3695525',	'+14695853442',	'completed',	37,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REdf4918830465da9dfade5c18c5087a50',	0,	0,	'',	''),
(1864,	'CAcf86c80a6efb5854d8a478df49770086',	'',	'2018-03-12 18:12:49',	'US',	'75062',	'TX',	'IRVING',	'US',	'76059',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18172025684',	'+18172032817',	'+18172025684',	NULL,	NULL,	NULL,	NULL,	'CLEBURNE',	'TX',	'CAcf86c80a6efb5854d8a478df49770086',	'+12146628447',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE32c391f97642fab9c0a049afa3d86dd5',	0,	0,	'',	''),
(1865,	'CAe8ff5a37390e87539eb2de64c8e3fe0c',	'',	'2018-03-12 18:24:57',	'',	'',	'',	'',	'',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+1732698456',	'+18178864375',	'+1732698456',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CAe8ff5a37390e87539eb2de64c8e3fe0c',	'+18173042914',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1866,	'CAeed40e3c6c596e5c7c97e630ffe9c3ca',	'',	'2018-03-12 19:16:35',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75063',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19724569188',	'+19722036218',	'+19724569188',	NULL,	NULL,	NULL,	NULL,	'IRVING',	'TX',	'CAeed40e3c6c596e5c7c97e630ffe9c3ca',	'+12147183718',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1867,	'CA7891411a345fb80366ee657f0986a430',	'',	'2018-03-12 19:46:38',	'US',	'',	'TX',	'',	'US',	'75019',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19723048880',	'+14697784620',	'+19723048880',	NULL,	NULL,	NULL,	NULL,	'LEWISVILLE',	'TX',	'CA7891411a345fb80366ee657f0986a430',	'+12146953999',	'completed',	16,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE7c0f98fb0433926fbb7e8ef7236321d4',	0,	0,	'',	''),
(1868,	'CAb4a2a1176bcf7c889b9d9844b3a53f09',	'',	'2018-03-12 19:59:36',	'US',	'95619',	'CA',	'LINCOLN',	'US',	'95619',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19162958114',	'+19162956335',	'+19162958114',	NULL,	NULL,	NULL,	NULL,	'LINCOLN',	'CA',	'CAb4a2a1176bcf7c889b9d9844b3a53f09',	'+19163975518',	'completed',	26,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3889dd25d98212f7189500abf10ce91f',	0,	0,	'',	''),
(1869,	'CA50b111522768d615d807b13d4b0a0c67',	'',	'2018-03-12 20:20:50',	'US',	'',	'TX',	'',	'US',	'91403',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19512088752',	'+14695303089',	'+19512088752',	NULL,	NULL,	NULL,	NULL,	'SHERMAN OAKS',	'CA',	'CA50b111522768d615d807b13d4b0a0c67',	'+14695853442',	'completed',	39,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE967dc709caa71286cfd7a0db4a627ccc',	0,	0,	'',	''),
(1870,	'CA7bc4f0aef7df07e8bfe61b33be42c84c',	'',	'2018-03-13 15:00:54',	'US',	'',	'TX',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14695348225',	'+14695356358',	'+14695348225',	NULL,	NULL,	NULL,	NULL,	'',	'TX',	'CA7bc4f0aef7df07e8bfe61b33be42c84c',	'+19402315995',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1871,	'CA258b1df63c8f158cdda0903d27bb7a0d',	'',	'2018-03-13 15:50:45',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19162982009',	'+19165849211',	'+19162982009',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA258b1df63c8f158cdda0903d27bb7a0d',	'+19164825834',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE37a61f53a7bea6a0e1b0d91a11015419',	0,	0,	'',	''),
(1872,	'CA8d3a27ccbbff8e350c95f05ac89d5e36',	'',	'2018-03-13 17:27:07',	'US',	'76111',	'TX',	'FORT WORTH',	'US',	'12571',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18457573745',	'+18178864375',	'+18457573745',	NULL,	NULL,	NULL,	NULL,	'TIVOLI',	'NY',	'CA8d3a27ccbbff8e350c95f05ac89d5e36',	'+18173042914',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE9b86291d4695cd8c4694336eff9f0527',	0,	0,	'',	''),
(1873,	'CA15aeb363482970c1c736cf9ba747be86',	'',	'2018-03-13 17:43:01',	'US',	'92122',	'CA',	'SAN DIEGO',	'US',	'92123',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16194800348',	'+16195548764',	'+16194800348',	NULL,	NULL,	NULL,	NULL,	'SAN DIEGO',	'CA',	'CA15aeb363482970c1c736cf9ba747be86',	'+16198233047',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1874,	'CA803561666f33bc8d5d348663c1ab22cc',	'',	'2018-03-13 18:03:49',	'US',	'76210',	'TX',	'DENTON',	'US',	'75038',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12145415830',	'+19402203090',	'+12145415830',	NULL,	NULL,	NULL,	NULL,	'IRVING',	'TX',	'CA803561666f33bc8d5d348663c1ab22cc',	'+19402315995',	'completed',	579,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE906531e01079b38bf249a1b931ce6760',	0,	0,	'',	''),
(1875,	'CA89c4c12195068b2391b89c59bf1d1e28',	'',	'2018-03-13 18:14:49',	'US',	'76210',	'TX',	'DENTON',	'US',	'75038',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12145415830',	'+19402203090',	'+12145415830',	NULL,	NULL,	NULL,	NULL,	'IRVING',	'TX',	'CA89c4c12195068b2391b89c59bf1d1e28',	'+19402315995',	'completed',	15,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE26f78b558d2d57f54334391e67e919fe',	0,	0,	'',	''),
(1876,	'CAd74c7970680bfcf0043e008f6d4d723e',	'',	'2018-03-13 18:20:09',	'US',	'75024',	'TX',	'PLANO',	'US',	'75051',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19728544959',	'+19728051470',	'+19728544959',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CAd74c7970680bfcf0043e008f6d4d723e',	'+12146824990',	'completed',	240,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE70b73041ee2fe2858a4cbdfbb4239533',	0,	0,	'',	''),
(1877,	'CAabe7a3eecaac2e56ed16b7125f31b1b7',	'',	'2018-03-14 13:27:50',	'US',	'30312',	'GA',	'ATLANTA',	'US',	'30016',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16787602240',	'+14044765368',	'+16787602240',	NULL,	NULL,	NULL,	NULL,	'COVINGTON',	'GA',	'CAabe7a3eecaac2e56ed16b7125f31b1b7',	'+14042107184',	'completed',	466,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REacc348d43c7c1adbe04ea7eeb7a1f8ee',	0,	0,	'',	''),
(1878,	'CA1793b1ed6b1f8f1612184982323f87c2',	'',	'2018-03-14 17:04:21',	'US',	'20817',	'MD',	'FORT WASHINGTON',	'US',	'20166',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12027061299',	'+13014337892',	'+12027061299',	NULL,	NULL,	NULL,	NULL,	'STERLING',	'DC',	'CA1793b1ed6b1f8f1612184982323f87c2',	'+12024123578',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1879,	'CA53dfe2e1d316324e97ade5710bc3b31f',	'',	'2018-03-14 17:58:10',	'US',	'75254',	'TX',	'DALLAS',	'US',	'75052',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12142351209',	'+19728611197',	'+12142351209',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CA53dfe2e1d316324e97ade5710bc3b31f',	'+12147183718',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1880,	'CA3f929bed737d7aa30df2f6d14f0ebdf8',	'',	'2018-03-14 17:58:45',	'US',	'75254',	'TX',	'DALLAS',	'US',	'75006',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12145146800',	'+19728611197',	'+12145146800',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CA3f929bed737d7aa30df2f6d14f0ebdf8',	'+12147183718',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4217a4264d532e9e26c156e1d638638e',	0,	0,	'',	''),
(1881,	'CA5b6eb8158a789fe82a946e27cb2d7b99',	'',	'2018-03-14 18:31:39',	'US',	'94553',	'CA',	'MARTINEZ',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19254465717',	'+19252313411',	'+19254465717',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA5b6eb8158a789fe82a946e27cb2d7b99',	'+19255840363',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1882,	'CA82b8092ec21bf5570dd0bec4b6b74813',	'',	'2018-03-15 15:50:12',	'US',	'75219',	'TX',	'DALLAS',	'US',	'64106',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18169124021',	'+19725213658',	'+18169124021',	NULL,	NULL,	NULL,	NULL,	'KANSAS CITY',	'MO',	'CA82b8092ec21bf5570dd0bec4b6b74813',	'+12146824990',	'completed',	101,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe944690b45b61fa3546ce15707716bdd',	0,	0,	'',	''),
(1883,	'CA74ce7d7977f17261d8a028b9bb98575d',	'',	'2018-03-15 16:05:04',	'US',	'92122',	'CA',	'SAN DIEGO',	'US',	'92123',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16193050615',	'+16195548764',	'+16193050615',	NULL,	NULL,	NULL,	NULL,	'SAN DIEGO',	'CA',	'CA74ce7d7977f17261d8a028b9bb98575d',	'+16198233047',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1884,	'CA7f9aa128034e428ffb5aebb026f50735',	'',	'2018-03-15 16:18:46',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'64106',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18169124021',	'+19722036640',	'+18169124021',	NULL,	NULL,	NULL,	NULL,	'KANSAS CITY',	'MO',	'CA7f9aa128034e428ffb5aebb026f50735',	'+19728157325',	'completed',	6,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE516e658c1e9eed105a23b6a51d7d3cdb',	0,	0,	'',	''),
(1885,	'CA7b475b6725514e2604af5d79d88c3352',	'',	'2018-03-15 16:26:11',	'US',	'29501',	'SC',	'FLORENCE',	'US',	'29466',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18432093105',	'+18432121085',	'+18432093105',	NULL,	NULL,	NULL,	NULL,	'CHARLESTON',	'SC',	'CA7b475b6725514e2604af5d79d88c3352',	'+18433756472',	'completed',	16,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3f4a1c465d87faf0a8c7b71f2fc5693b',	0,	0,	'',	''),
(1886,	'CAc0a49a5c01420f35ef220b8887967889',	'',	'2018-03-15 16:32:54',	'US',	'29483',	'SC',	'SUMMERVILLE',	'US',	'29530',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18433738286',	'+18433766611',	'+18433738286',	NULL,	NULL,	NULL,	NULL,	'SCRANTON',	'SC',	'CAc0a49a5c01420f35ef220b8887967889',	'+18433756472',	'completed',	4,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa40cc5107c67720b58bcce7107487714',	0,	0,	'',	''),
(1887,	'CAc97169106c6292abb2f924997060b7e5',	'',	'2018-03-15 18:58:39',	'US',	'88101',	'NM',	'CLOVIS',	'US',	'87198',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15054809069',	'+15052194134',	'+15054809069',	NULL,	NULL,	NULL,	NULL,	'ALBUQUERQUE',	'NM',	'CAc97169106c6292abb2f924997060b7e5',	'+15053192181',	'completed',	660,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE93ce008bbd44b62977311b4f15536ce1',	0,	0,	'',	''),
(1888,	'CAfdd48ec34b39e17389da719e2f522f29',	'',	'2018-03-15 22:14:56',	'US',	'',	'TX',	'',	'US',	'75077',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14694646852',	'+14695357756',	'+14694646852',	NULL,	NULL,	NULL,	NULL,	'LEWISVILLE',	'TX',	'CAfdd48ec34b39e17389da719e2f522f29',	'+19402315995',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1889,	'CAb96009652f280d789d407c2470fb667b',	'',	'2018-03-16 01:05:33',	'US',	'75234',	'TX',	'CARROLLTON',	'US',	'76704',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18177563967',	'+14695578827',	'+18177563967',	NULL,	NULL,	NULL,	NULL,	'GRAPEVINE',	'TX',	'CAb96009652f280d789d407c2470fb667b',	'+19402315995',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1890,	'CAb0d3bc51820f227a28aa9c91d5b1cf94',	'',	'2018-03-16 14:04:05',	'US',	'',	'OK',	'',	'US',	'73109',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14056375996',	'+14056731362',	'+14056375996',	NULL,	NULL,	NULL,	NULL,	'OKLAHOMA CITY',	'OK',	'CAb0d3bc51820f227a28aa9c91d5b1cf94',	'+14052014241',	'completed',	48,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE0c68fc6f78a3e1d96edc15c5bb0a051f',	0,	0,	'',	''),
(1891,	'CA090e5ee6aee8385ed9dfa85900a903a9',	'',	'2018-03-16 14:05:25',	'US',	'75152',	'TX',	'PALMER',	'US',	'75062',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14699958980',	'+14692146402',	'+14699958980',	NULL,	NULL,	NULL,	NULL,	'IRVING',	'TX',	'CA090e5ee6aee8385ed9dfa85900a903a9',	'+12146953999',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1892,	'CA8304538d6d9fc3183854358eda4452de',	'',	'2018-03-16 18:04:26',	'US',	'',	'TX',	'',	'US',	'64106',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18169124021',	'+16823053491',	'+18169124021',	NULL,	NULL,	NULL,	NULL,	'KANSAS CITY',	'MO',	'CA8304538d6d9fc3183854358eda4452de',	'+18178814663',	'completed',	2,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd59ce2c6f5370241ab3c677b9ae6f462',	0,	0,	'',	''),
(1893,	'CA1b5f6771094e75b16c35da00ad470c93',	'',	'2018-03-16 18:08:32',	'US',	'',	'TX',	'',	'US',	'64106',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18169124021',	'+16823074517',	'+18169124021',	NULL,	NULL,	NULL,	NULL,	'KANSAS CITY',	'MO',	'CA1b5f6771094e75b16c35da00ad470c93',	'+18173042914',	'completed',	370,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE81b8c6f5da6132bd419e3e6d50a6c125',	0,	0,	'',	''),
(1894,	'CA74ad3bfce7c017ba9a12dcf8d7ee0f15',	'',	'2018-03-16 19:28:04',	'US',	'76063',	'TX',	'MANSFIELD',	'US',	'76063',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18175928222',	'+18175928678',	'+18175928222',	NULL,	NULL,	NULL,	NULL,	'MANSFIELD',	'TX',	'CA74ad3bfce7c017ba9a12dcf8d7ee0f15',	'+18173042914',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1895,	'CA74b013a3f9595a11eb76eaf774e10ca5',	'',	'2018-03-16 19:37:25',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75052',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14693281752',	'+19722036640',	'+14693281752',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CA74b013a3f9595a11eb76eaf774e10ca5',	'+19728157325',	'completed',	1807,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE17feecef5b9a0a62c012f3cc569d0677',	0,	0,	'',	''),
(1896,	'CA53724bd71e996ad54b7110f979d86162',	'',	'2018-03-16 19:44:40',	'US',	'75082',	'TX',	'DALLAS',	'US',	'97420',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15414350766',	'+19723625222',	'+15414350766',	NULL,	NULL,	NULL,	NULL,	'COOS BAY',	'OR',	'CA53724bd71e996ad54b7110f979d86162',	'+12147183718',	'completed',	2293,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REeb55e0538f7707b570f25a5c9c1e449f',	0,	0,	'',	''),
(1897,	'CA2294c736d2e8404cd5b961c11bbd9b99',	'',	'2018-03-16 21:05:09',	'US',	'',	'TX',	'',	'US',	'75019',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19723048880',	'+14697784620',	'+19723048880',	NULL,	NULL,	NULL,	NULL,	'LEWISVILLE',	'TX',	'CA2294c736d2e8404cd5b961c11bbd9b99',	'+12146953999',	'completed',	19,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3cb476611178ff27f1660f35c37ac7a9',	0,	0,	'',	''),
(1898,	'CAbed64506c1229e2518a7f9181438bdbb',	'',	'2018-03-17 14:42:00',	'US',	'20817',	'MD',	'FORT WASHINGTON',	'US',	'20879',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13019798575',	'+13014337892',	'+13019798575',	NULL,	NULL,	NULL,	NULL,	'GAITHERSBURG',	'MD',	'CAbed64506c1229e2518a7f9181438bdbb',	'+12024123578',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1899,	'CA23bce54a53c5bea80f5cc588af0a8235',	'',	'2018-03-17 15:56:23',	'US',	'75029',	'TX',	'LEWISVILLE',	'US',	'72756',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14799366407',	'+14692932734',	'+14799366407',	NULL,	NULL,	NULL,	NULL,	'ROGERS',	'AR',	'CA23bce54a53c5bea80f5cc588af0a8235',	'+19402315995',	'completed',	44,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE33d675c612493bfbed7f213a68ab2e82',	0,	0,	'',	''),
(1900,	'CA72ba376688d7fbd1fbaa16ad67009f28',	'',	'2018-03-18 17:07:44',	'US',	'76248',	'TX',	'FORT WORTH',	'US',	'72205',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15017863823',	'+18179681164',	'+15017863823',	NULL,	NULL,	NULL,	NULL,	'LITTLE ROCK',	'AR',	'CA72ba376688d7fbd1fbaa16ad67009f28',	'+18178814663',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE0ce2bd9046e34c61c227260b9d5cdb33',	0,	0,	'',	''),
(1901,	'CA49042e2700b31ffe5995b712338371d4',	'',	'2018-03-18 18:14:51',	'US',	'74120',	'OK',	'TULSA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14692605353',	'+19189927424',	'+14692605353',	NULL,	NULL,	NULL,	NULL,	'',	'TX',	'CA49042e2700b31ffe5995b712338371d4',	'+19188009881',	'completed',	6,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE03d90a46571a4e4fa316616aa9f437e2',	0,	0,	'',	''),
(1902,	'CA3a0445638149f7c20644c03cf332ea83',	'',	'2018-03-18 21:24:55',	'US',	'77577',	'TX',	'ALVIN',	'US',	'78132',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18305159442',	'+12813934540',	'+18305159442',	NULL,	NULL,	NULL,	NULL,	'NEW BRAUNFELS',	'TX',	'CA3a0445638149f7c20644c03cf332ea83',	'+18327156360',	'completed',	14,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa4849f08563ebd8e491b90c170ec20d1',	0,	0,	'',	''),
(1903,	'CA89b79d459e3fb42b6731b8383cc46b28',	'',	'2018-03-19 13:37:12',	'US',	'76111',	'TX',	'FORT WORTH',	'US',	'75234',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14696848504',	'+18178864375',	'+14696848504',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CA89b79d459e3fb42b6731b8383cc46b28',	'+18173042914',	'completed',	23,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REcbb01222d63cbd87b79775b777858923',	0,	0,	'',	''),
(1904,	'CA0ee43393ec63651177290df3a6cc3e08',	'',	'2018-03-19 14:24:04',	'US',	'73149',	'OK',	'OKLAHOMA CITY',	'US',	'73149',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14052466623',	'+14052469915',	'+14052466623',	NULL,	NULL,	NULL,	NULL,	'OKLAHOMA CITY',	'OK',	'CA0ee43393ec63651177290df3a6cc3e08',	'+14052014241',	'completed',	34,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb8456c2ff2e29a018f407eadd6cb3ad5',	0,	0,	'',	''),
(1905,	'CA15f346d1d73c92c92e73ebcd3a60b7f9',	'',	'2018-03-19 15:51:55',	'US',	'73149',	'OK',	'OKLAHOMA CITY',	'US',	'73149',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14052466623',	'+14052469915',	'+14052466623',	NULL,	NULL,	NULL,	NULL,	'OKLAHOMA CITY',	'OK',	'CA15f346d1d73c92c92e73ebcd3a60b7f9',	'+14052014241',	'completed',	28,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc0845e77e40dff0bddc2d56ff4e561ad',	0,	0,	'',	''),
(1906,	'CA72dc3759c2ca5916f82104ea0b7a5301',	'',	'2018-03-19 15:57:01',	'US',	'73149',	'OK',	'OKLAHOMA CITY',	'US',	'73005',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+14052469915',	'+14052471680',	NULL,	NULL,	NULL,	NULL,	'ANADARKO',	'OK',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1907,	'CA5546047eaca80b947952ac039027c9be',	'',	'2018-03-19 15:57:02',	'US',	'73149',	'OK',	'OKLAHOMA CITY',	'US',	'73005',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14052471680',	'+14052469915',	'+14052471680',	NULL,	NULL,	NULL,	NULL,	'ANADARKO',	'OK',	'CA5546047eaca80b947952ac039027c9be',	'+14052014241',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1908,	'CA2cf7e3f1d56e39c46dc309fa9809e90c',	'',	'2018-03-19 17:37:32',	'US',	'76111',	'TX',	'FORT WORTH',	'US',	'64106',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18169124021',	'+18178864375',	'+18169124021',	NULL,	NULL,	NULL,	NULL,	'KANSAS CITY',	'MO',	'CA2cf7e3f1d56e39c46dc309fa9809e90c',	'+18173042914',	'completed',	37,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE94440b8d81c1b381449e02c5ff0470c0',	0,	0,	'',	''),
(1909,	'CAa3b94361e2bdd61eb68cee95d78e9b2c',	'',	'2018-03-19 17:52:53',	'US',	'94509',	'CA',	'ANTIOCH',	'US',	'94509',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19252199858',	'+19252197932',	'+19252199858',	NULL,	NULL,	NULL,	NULL,	'ANTIOCH',	'CA',	'CAa3b94361e2bdd61eb68cee95d78e9b2c',	'+19255840363',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1910,	'CA07aaa667b09b0756a0d4ab11aa568cf0',	'',	'2018-03-19 17:55:47',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'08069',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18565171244',	'+19722036659',	'+18565171244',	NULL,	NULL,	NULL,	NULL,	'PENNS GROVE',	'NJ',	'CA07aaa667b09b0756a0d4ab11aa568cf0',	'+12147183718',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1911,	'CAd1205621c108be3fdc9709589cc0880f',	'',	'2018-03-19 18:15:12',	'US',	'77577',	'TX',	'ALVIN',	'US',	'77081',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18325452773',	'+12813934601',	'+18325452773',	NULL,	NULL,	NULL,	NULL,	'HOUSTON',	'TX',	'CAd1205621c108be3fdc9709589cc0880f',	'+18327156360',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE027eedf44428ed646fa8a8fd19bdbb44',	0,	0,	'',	''),
(1912,	'CAfd890d0f712d53ab2c0f4c09c934bbe4',	'',	'2018-03-19 23:51:47',	'US',	'',	'AZ',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14805625290',	'+16233001626',	'+14805625290',	NULL,	NULL,	NULL,	NULL,	'',	'AZ',	'CAfd890d0f712d53ab2c0f4c09c934bbe4',	'+14802390652',	'completed',	100,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa02bd09815cabac1c53111bd84274b56',	0,	0,	'',	''),
(1913,	'CAc55f95113e5abe2b7ab738c2836caad8',	'',	'2018-03-20 00:31:09',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18582568206',	'+18582520630',	'+18582568206',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAc55f95113e5abe2b7ab738c2836caad8',	'+17602378044',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1914,	'CAccd81ab101b03b50185a92d5115a281a',	'',	'2018-03-20 10:57:01',	'US',	'76210',	'TX',	'DENTON',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19403011846',	'+19402203539',	'+19403011846',	NULL,	NULL,	NULL,	NULL,	'',	'TX',	'CAccd81ab101b03b50185a92d5115a281a',	'+19727954260',	'completed',	12,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd81e72605f926dc31c0e20b6ed1d5203',	0,	0,	'',	''),
(1915,	'CAf45b114157e833b24860aac44f00574f',	'',	'2018-03-20 11:04:57',	'US',	'76210',	'TX',	'DENTON',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19403011846',	'+19402203539',	'+19403011846',	NULL,	NULL,	NULL,	NULL,	'',	'TX',	'CAf45b114157e833b24860aac44f00574f',	'+19727954260',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa48d8dab4123ef5accf49b29fa73f00e',	0,	0,	'',	''),
(1916,	'CA807561f181cb14feae17042d1ac371d4',	'',	'2018-03-20 14:36:13',	'US',	'73149',	'OK',	'OKLAHOMA CITY',	'US',	'73149',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14052466623',	'+14052469915',	'+14052466623',	NULL,	NULL,	NULL,	NULL,	'OKLAHOMA CITY',	'OK',	'CA807561f181cb14feae17042d1ac371d4',	'+14052014241',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe60c6b497445b9b3b7f00001b076347d',	0,	0,	'',	''),
(1917,	'CAfc2c689894dd8488fe6563dd7d0efc4f',	'',	'2018-03-20 15:58:49',	'US',	'',	'TX',	'',	'US',	'77380',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17133771258',	'+17133227812',	'+17133771258',	NULL,	NULL,	NULL,	NULL,	'SPRING',	'TX',	'CAfc2c689894dd8488fe6563dd7d0efc4f',	'+13462347725',	'completed',	387,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd5b9e0464328e217617ff3058f40cf1d',	0,	0,	'',	''),
(1918,	'CA28a6d78ed2b980e0f19407e5dc9e514d',	'',	'2018-03-20 16:01:42',	'US',	'77995',	'TX',	'YOAKUM',	'US',	'78387',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13614243349',	'+13612983529',	'+13614243349',	NULL,	NULL,	NULL,	NULL,	'SINTON',	'TX',	'CA28a6d78ed2b980e0f19407e5dc9e514d',	'+18327156360',	'completed',	38,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE47d3b324a187a1c9743ff58c421f3af9',	0,	0,	'',	''),
(1919,	'CAb23e9b9385d1f1fb0d2e1f84d1c22ee5',	'',	'2018-03-20 16:06:13',	'US',	'77995',	'TX',	'YOAKUM',	'US',	'78387',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13614243349',	'+13612983529',	'+13614243349',	NULL,	NULL,	NULL,	NULL,	'SINTON',	'TX',	'CAb23e9b9385d1f1fb0d2e1f84d1c22ee5',	'+18327156360',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE08ebac69188c1dae7ead178977c04774',	0,	0,	'',	''),
(1920,	'CA6126fb8206d946ce1d67b1cb803b5868',	'',	'2018-03-20 16:52:45',	'US',	'77995',	'TX',	'YOAKUM',	'US',	'78387',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13614243349',	'+13612983529',	'+13614243349',	NULL,	NULL,	NULL,	NULL,	'SINTON',	'TX',	'CA6126fb8206d946ce1d67b1cb803b5868',	'+18327156360',	'completed',	12,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REac2663fe8c894bf3257c31d0f4dde813',	0,	0,	'',	''),
(1921,	'CAb564eb5459809c7480665901a20162d1',	'',	'2018-03-20 17:46:24',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'78006',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12106876421',	'+19722036218',	'+12106876421',	NULL,	NULL,	NULL,	NULL,	'SAN ANTONIO',	'TX',	'CAb564eb5459809c7480665901a20162d1',	'+12147183718',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1922,	'CAcfbcc532f71e1a754183e6de20c4a70c',	'',	'2018-03-20 18:50:34',	'US',	'20166',	'MD',	'STERLING',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19075092956',	'+12407022957',	'+19075092956',	NULL,	NULL,	NULL,	NULL,	'',	'AK',	'CAcfbcc532f71e1a754183e6de20c4a70c',	'+12024123578',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1923,	'CAae028958c51248ef4b0109acd276b226',	'',	'2018-03-21 16:39:56',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'65633',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14172034248',	'+19722036218',	'+14172034248',	NULL,	NULL,	NULL,	NULL,	'CRANE',	'MO',	'CAae028958c51248ef4b0109acd276b226',	'+12147183718',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1924,	'CAd4d17d4799726e34837a17c8947ded76',	'',	'2018-03-21 17:41:27',	'US',	'',	'TX',	'',	'US',	'78953',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19797162600',	'+17133227812',	'+19797162600',	NULL,	NULL,	NULL,	NULL,	'GIDDINGS',	'TX',	'CAd4d17d4799726e34837a17c8947ded76',	'+13462347725',	'completed',	362,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE5d9bea1f57dbffeb3effdf1c498585e1',	0,	0,	'',	''),
(1925,	'CA61771a9d47ce5c23ce381977b43c7b7e',	'',	'2018-03-21 19:08:33',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75182',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19722039239',	'+19722036218',	'+19722039239',	NULL,	NULL,	NULL,	NULL,	'SUNNYVALE',	'TX',	'CA61771a9d47ce5c23ce381977b43c7b7e',	'+12147183718',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1926,	'CA15a19c444e9b32c411e556c6440be93f',	'',	'2018-03-21 19:16:56',	'US',	'',	'TX',	'',	'US',	'53147',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12622156142',	'+14695356962',	'+12622156142',	NULL,	NULL,	NULL,	NULL,	'LAKE GENEVA',	'WI',	'CA15a19c444e9b32c411e556c6440be93f',	'+19402315995',	'completed',	761,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa907ebf6576b2175606a91e5ea2ed384',	0,	0,	'',	''),
(1927,	'CA2889f4b306690e988946f8383ca206ef',	'',	'2018-03-21 20:38:08',	'US',	'92123',	'CA',	'SAN DIEGO',	'US',	'92123',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16194581872',	'+16194583722',	'+16194581872',	NULL,	NULL,	NULL,	NULL,	'SAN DIEGO',	'CA',	'CA2889f4b306690e988946f8383ca206ef',	'+17602378044',	'completed',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REcc039b8773abd751521fa1dde08d5080',	0,	0,	'',	''),
(1928,	'CAa57cb73e0b581029be908c5bec9ae951',	'',	'2018-03-21 22:45:15',	'US',	'29483',	'SC',	'SUMMERVILLE',	'US',	'29590',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18433725666',	'+18433766611',	'+18433725666',	NULL,	NULL,	NULL,	NULL,	'KINGSTREE',	'SC',	'CAa57cb73e0b581029be908c5bec9ae951',	'+19733427183',	'completed',	63,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE5abd14b262665ea84037a9542961059c',	0,	0,	'',	''),
(1929,	'CA27c814f22ba896f7233a72633f0486c9',	'',	'2018-03-22 14:16:55',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75251',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14692014311',	'+19722036640',	'+14692014311',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CA27c814f22ba896f7233a72633f0486c9',	'+19728157325',	'completed',	1081,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE9cb5725cca6a30cd60b21b93c6d3bc84',	0,	0,	'',	''),
(1930,	'CAb77fa99a121eb602e2e7cb853722a033',	'',	'2018-03-22 15:09:01',	'US',	'85034',	'AZ',	'PHOENIX',	'US',	'85034',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14802693456',	'+14802691941',	'+14802693456',	NULL,	NULL,	NULL,	NULL,	'PHOENIX',	'AZ',	'CAb77fa99a121eb602e2e7cb853722a033',	'+14803882032',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1931,	'CA2ef7027eca30e9897c5da2ba5303e28c',	'',	'2018-03-22 18:18:48',	'US',	'75234',	'TX',	'DALLAS',	'US',	'75234',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14698887153',	'+14698888509',	'+14698887153',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CA2ef7027eca30e9897c5da2ba5303e28c',	'+12147183718',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE7395d65aab4658f40ab9959c400c5ec7',	0,	0,	'',	''),
(1932,	'CA556a69eb81bd72c0c91042030cb915d0',	'',	'2018-03-22 19:37:35',	'US',	'75024',	'TX',	'PLANO',	'US',	'75074',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19728061031',	'+19728051470',	'+19728061031',	NULL,	NULL,	NULL,	NULL,	'PLANO',	'TX',	'CA556a69eb81bd72c0c91042030cb915d0',	'+12146824990',	'completed',	36,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REbb2182b11f15452b6f9c0fb6c5c5ec89',	0,	0,	'',	''),
(1933,	'CAd85f91e291ada254fde808dc614a914d',	'',	'2018-03-22 21:30:52',	'US',	'77995',	'TX',	'YOAKUM',	'US',	'78217',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12104590703',	'+13612983529',	'+12104590703',	NULL,	NULL,	NULL,	NULL,	'SAN ANTONIO',	'TX',	'CAd85f91e291ada254fde808dc614a914d',	'+18327156360',	'completed',	117,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REcbe878acd435e666d3a05e0dd9ea0510',	0,	0,	'',	''),
(1934,	'CAd6457155c8ae20f0d2d97da5d4815759',	'',	'2018-03-23 22:49:23',	'US',	'',	'TX',	'Houston',	'US',	'77474',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19794720777',	'+13462144636',	'+19794720777',	NULL,	NULL,	NULL,	NULL,	'SEALY',	'TX',	'CAd6457155c8ae20f0d2d97da5d4815759',	'+13462347725',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1935,	'CA937d52064c0d5d9f2322a6ccb85e64aa',	'',	'2018-03-24 03:06:07',	'US',	'92123',	'CA',	'SAN DIEGO',	'US',	'92506',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19516809152',	'+16194323549',	'+19516809152',	NULL,	NULL,	NULL,	NULL,	'RIVERSIDE',	'CA',	'CA937d52064c0d5d9f2322a6ccb85e64aa',	'+16198233047',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE9eac99a050dbb5a842737830f696324b',	0,	0,	'',	''),
(1936,	'CAefd4849a188e2b0f365a809a251176b4',	'',	'2018-03-24 03:52:28',	'US',	'92123',	'CA',	'SAN DIEGO',	'US',	'92506',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19516809152',	'+16194583722',	'+19516809152',	NULL,	NULL,	NULL,	NULL,	'RIVERSIDE',	'CA',	'CAefd4849a188e2b0f365a809a251176b4',	'+17602378044',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1937,	'CA50c0fcb699ec9e289d30bbe78fc0e70a',	'',	'2018-03-24 15:44:50',	'US',	'75258',	'TX',	'DALLAS',	'US',	'78076',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19562655693',	'+12147613136',	'+19562655693',	NULL,	NULL,	NULL,	NULL,	'ZAPATA',	'TX',	'CA50c0fcb699ec9e289d30bbe78fc0e70a',	'+12147096672',	'completed',	36,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE477548862d575eb524c3046d6913429d',	0,	0,	'',	''),
(1938,	'CAb3f814333a7a00b89fd836e6ac8e4804',	'',	'2018-03-24 17:50:40',	'US',	'',	'NV',	'',	'US',	'89143',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17023251485',	'+17029195831',	'+17023251485',	NULL,	NULL,	NULL,	NULL,	'LAS VEGAS',	'NV',	'CAb3f814333a7a00b89fd836e6ac8e4804',	'+17252223264',	'completed',	51,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa77415be0fa354c28d1b2c8220481910',	0,	0,	'',	''),
(1939,	'CA2b53b3da5990528d3e2052a6afc023f6',	'',	'2018-03-24 20:32:07',	'US',	'76210',	'TX',	'DENTON',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14027021105',	'+19402203356',	'+14027021105',	NULL,	NULL,	NULL,	NULL,	'',	'NE',	'CA2b53b3da5990528d3e2052a6afc023f6',	'+19402315995',	'busy',	NULL,	NULL,	0,	0,	'',	''),
(1940,	'CA647ed40d4f312ee3b1d219477003ed2d',	'',	'2018-03-25 16:18:35',	'US',	'',	'AZ',	'',	'US',	'85308',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16023691023',	'+16233001626',	'+16023691023',	NULL,	NULL,	NULL,	NULL,	'PHOENIX',	'AZ',	'CA647ed40d4f312ee3b1d219477003ed2d',	'+14802390652',	'completed',	196,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE7cb81c77d59abdcceeab0262732f7de9',	0,	0,	'',	''),
(1941,	'CA94a7bda16b9ba34c1dadfc00efbd6966',	'',	'2018-03-26 00:24:53',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'82007',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19722036640',	'+13072213648',	NULL,	NULL,	NULL,	NULL,	'CHEYENNE',	'WY',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1942,	'CAa779c92437bdc03e530ce34096b8f83f',	'',	'2018-03-27 04:39:46',	'US',	'75202',	'TX',	'DALLAS',	'US',	'95386',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12096060026',	'+12149221949',	'+12096060026',	NULL,	NULL,	NULL,	NULL,	'MODESTO',	'CA',	'CAa779c92437bdc03e530ce34096b8f83f',	'+12147851535',	'completed',	30,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE0f5080bf57e9c17ae5b56388d650e763',	0,	0,	'',	''),
(1943,	'CA15714d9c635a4950b1d40486cd835837',	'',	'2018-03-27 18:08:58',	'US',	'75082',	'TX',	'DALLAS',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16193912068',	'+19723625222',	'+16193912068',	NULL,	NULL,	NULL,	NULL,	'POWAY',	'CA',	'CA15714d9c635a4950b1d40486cd835837',	'+12147183718',	'completed',	21,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3a20d85ae7f48700de8a9f9b90983737',	0,	0,	'',	''),
(1944,	'CA9768fcaa25ae7e1363183faa0f29447c',	'',	'2018-03-27 18:17:10',	'US',	'75244',	'TX',	'DALLAS',	'US',	'75025',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19729089742',	'+19729190409',	'+19729089742',	NULL,	NULL,	NULL,	NULL,	'ALLEN',	'TX',	'CA9768fcaa25ae7e1363183faa0f29447c',	'+19728157325',	'completed',	17,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE75a493af509385264d7064d605605720',	0,	0,	'',	''),
(1945,	'CA0bf627a3b569d197e50ee848e4e3f2d6',	'',	'2018-03-27 19:28:27',	'US',	'75254',	'TX',	'DALLAS',	'US',	'76065',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14695373858',	'+19728611197',	'+14695373858',	NULL,	NULL,	NULL,	NULL,	'MIDLOTHIAN',	'TX',	'CA0bf627a3b569d197e50ee848e4e3f2d6',	'+12147183718',	'completed',	166,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE563643732a8debc07f8997f4a958218e',	0,	0,	'',	''),
(1946,	'CA7b92e623f45517c964f356e6fcc2740b',	'',	'2018-03-27 19:38:17',	'US',	'75234',	'TX',	'CARROLLTON',	'US',	'76704',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18177566446',	'+14695578827',	'+18177566446',	NULL,	NULL,	NULL,	NULL,	'GRAPEVINE',	'TX',	'CA7b92e623f45517c964f356e6fcc2740b',	'+19402315995',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE0060a2e57f4a5571317196429255f743',	0,	0,	'',	''),
(1947,	'CA1e7a470b2bcd89c4f58d82b46b7080ec',	'',	'2018-03-27 20:48:51',	'US',	'',	'CA',	'',	'US',	'32792',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14076055047',	'+19166340519',	'+14076055047',	NULL,	NULL,	NULL,	NULL,	'WINTER PARK',	'FL',	'CA1e7a470b2bcd89c4f58d82b46b7080ec',	'+19166287355',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE97eb2cc1c2dadfd187b03c6d1e10a958',	0,	0,	'',	''),
(1948,	'CAfc8de9510ced526f55411351c5d71aed',	'',	'2018-03-27 20:50:47',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75247',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12543080030',	'+19722036640',	'+12543080030',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CAfc8de9510ced526f55411351c5d71aed',	'+19728157325',	'completed',	63,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REcbf5fc682386a627a7c471e40c57c0dd',	0,	0,	'',	''),
(1949,	'CA079ab21b533208b67aa91b18343271cd',	'',	'2018-03-27 21:01:47',	'US',	'',	'TX',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14695351139',	'+14695357756',	'+14695351139',	NULL,	NULL,	NULL,	NULL,	'',	'TX',	'CA079ab21b533208b67aa91b18343271cd',	'+19402315995',	'completed',	65,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE8a1745715afd0511ce8d8a2448c6bf41',	0,	0,	'',	''),
(1950,	'CA9155be3efaec5af980138a6ca918f3b5',	'',	'2018-03-27 21:42:54',	'US',	'',	'TX',	'',	'US',	'75052',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14697746355',	'+14695357756',	'+14697746355',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CA9155be3efaec5af980138a6ca918f3b5',	'+19402315995',	'completed',	782,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE80b120b6cf460a6a4f4cd1cecf889443',	0,	0,	'',	''),
(1951,	'CA38c3288065a78f966b5908726d06bfcf',	'',	'2018-03-28 13:14:27',	'US',	'',	'TX',	'',	'US',	'75007',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19728655627',	'+14695357756',	'+19728655627',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CA38c3288065a78f966b5908726d06bfcf',	'+19402315995',	'completed',	48,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REfa64cf4e4cd6003a182c66e9f1d7162a',	0,	0,	'',	''),
(1952,	'CAe96bd3884f177c01c15bac8f59eeccaa',	'',	'2018-03-28 19:38:29',	'US',	'75002',	'TX',	'ALLEN',	'US',	'90802',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15626767154',	'+19729546137',	'+15626767154',	NULL,	NULL,	NULL,	NULL,	'LONG BEACH',	'CA',	'CAe96bd3884f177c01c15bac8f59eeccaa',	'+19402315995',	'completed',	4,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE9ab2c9d092b2fe8f514638f91bd18924',	0,	0,	'',	''),
(1953,	'CA9aaab1881c0cab85e5c9f5de98b47a6f',	'',	'2018-03-28 22:02:54',	'US',	'29501',	'SC',	'FLORENCE',	'US',	'29577',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18432131003',	'+18432121085',	'+18432131003',	NULL,	NULL,	NULL,	NULL,	'MYRTLE BEACH',	'SC',	'CA9aaab1881c0cab85e5c9f5de98b47a6f',	'+19733427183',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1954,	'CA70530c6a51dc5963b2bcbaafea89e507',	'',	'2018-03-28 22:02:56',	'US',	'29501',	'SC',	'FLORENCE',	'US',	'29577',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18432131003',	'+18432121085',	'+18432131003',	NULL,	NULL,	NULL,	NULL,	'MYRTLE BEACH',	'SC',	'CA70530c6a51dc5963b2bcbaafea89e507',	'+19733427183',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1955,	'CA9cf05b91e82700bfab631e1d1637a3cb',	'',	'2018-03-28 22:42:28',	'US',	'76111',	'TX',	'FORT WORTH',	'US',	'76131',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18177034772',	'+18178864375',	'+18177034772',	NULL,	NULL,	NULL,	NULL,	'ARLINGTON',	'TX',	'CA9cf05b91e82700bfab631e1d1637a3cb',	'+18173042914',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1956,	'CAd4eecebeaa137963ee66264f56920572',	'',	'2018-03-29 16:30:29',	'US',	'94509',	'CA',	'ANTIOCH',	'US',	'94509',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19252192520',	'+19252197932',	'+19252192520',	NULL,	NULL,	NULL,	NULL,	'ANTIOCH',	'CA',	'CAd4eecebeaa137963ee66264f56920572',	'+19255840363',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1957,	'CAba158c320d7e193c6e566e6757d16360',	'',	'2018-03-29 16:48:35',	'US',	'94589',	'CA',	'VALLEJO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14707697697',	'+17075620480',	'+14707697697',	NULL,	NULL,	NULL,	NULL,	'ATLANTA',	'GA',	'CAba158c320d7e193c6e566e6757d16360',	'+15106893859',	'completed',	17,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE8c005455fb9fcb24b0081b20d44a5129',	0,	0,	'',	''),
(1958,	'CAfac40bc37d9276c033de1680d85ca2b7',	'',	'2018-03-29 17:39:14',	'US',	'',	'WI',	'',	'US',	'11801',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15164655604',	'+17159727336',	'+15164655604',	NULL,	NULL,	NULL,	NULL,	'HICKSVILLE',	'NY',	'CAfac40bc37d9276c033de1680d85ca2b7',	'+15126992965',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1959,	'CAb8d517f65321c84a5fb77d9b0dd191f3',	'',	'2018-03-30 11:53:09',	'US',	'20166',	'MD',	'STERLING',	'US',	'20166',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12407016460',	'+12407022957',	'+12407016460',	NULL,	NULL,	NULL,	NULL,	'STERLING',	'MD',	'CAb8d517f65321c84a5fb77d9b0dd191f3',	'+12024123578',	'completed',	311,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE0f0f83495affc4cdcea3a0a9ec276c4c',	0,	0,	'',	''),
(1960,	'CAef1e9abb3f89b46c1fa57f4238ed633f',	'',	'2018-03-30 14:18:21',	'US',	'92024',	'CA',	'ESCONDIDO',	'US',	'30601',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17066142272',	'+17605465526',	'+17066142272',	NULL,	NULL,	NULL,	NULL,	'ATHENS',	'GA',	'CAef1e9abb3f89b46c1fa57f4238ed633f',	'+17602378044',	'completed',	28,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE84d6ec90251a503debfdb9b8a7628b33',	0,	0,	'',	''),
(1961,	'CAc1627a14e3928b613b52e47527dc6c12',	'',	'2018-03-30 14:19:39',	'US',	'92024',	'CA',	'ESCONDIDO',	'US',	'30601',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17066142272',	'+17605465526',	'+17066142272',	NULL,	NULL,	NULL,	NULL,	'ATHENS',	'GA',	'CAc1627a14e3928b613b52e47527dc6c12',	'+17602378044',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1962,	'CA7dd7cb452aea2cdf345164b4130d110f',	'',	'2018-03-30 17:15:26',	'US',	'94509',	'CA',	'ANTIOCH',	'US',	'95070',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19252157071',	'+19252197932',	'+19252157071',	NULL,	NULL,	NULL,	NULL,	'LIVERMORE',	'CA',	'CA7dd7cb452aea2cdf345164b4130d110f',	'+19255840363',	'completed',	21,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE9bb71cbab051d5394b20fa783a6ff2c2',	0,	0,	'',	''),
(1963,	'CAdc27e87796de4b44137e76c488e9eaef',	'',	'2018-03-30 19:25:52',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19165873460',	'+19165849127',	'+19165873460',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAdc27e87796de4b44137e76c488e9eaef',	'+19166287355',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE03ba9495008769fc2a60ff0e2483d9a3',	0,	0,	'',	''),
(1964,	'CA97a6367954b6ac0e42db867ded1ffb43',	'',	'2018-03-30 19:41:59',	'US',	'',	'NV',	'',	'US',	'92673',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19493260156',	'+17028196450',	'+19493260156',	NULL,	NULL,	NULL,	NULL,	'LADERA RANCH',	'CA',	'CA97a6367954b6ac0e42db867ded1ffb43',	'+17252223264',	'completed',	39,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE9a40d0ec7fc05c3c77420424fd92ac96',	0,	0,	'',	''),
(1965,	'CA07fa3ad5e07e88669d131ecd7b84f2ec',	'',	'2018-03-30 21:20:19',	'US',	'',	'NV',	'',	'US',	'92673',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19493260156',	'+17028196450',	'+19493260156',	NULL,	NULL,	NULL,	NULL,	'LADERA RANCH',	'CA',	'CA07fa3ad5e07e88669d131ecd7b84f2ec',	'+17252223264',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE23c04b106e6a55c2157cf46ec76f1206',	0,	0,	'',	''),
(1966,	'CA3a30045bc0b5e034cd23c17e4036aee0',	'',	'2018-03-30 21:20:55',	'US',	'',	'NV',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18009165905',	'+17028196450',	'+18009165905',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA3a30045bc0b5e034cd23c17e4036aee0',	'+17252223264',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE81add33100421375e12be0480d5ad055',	0,	0,	'',	''),
(1967,	'CAadd1f282cdeb247a4aea8a4fdc05f33e',	'',	'2018-03-30 23:52:47',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19165875635',	'+19165849127',	'+19165875635',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAadd1f282cdeb247a4aea8a4fdc05f33e',	'+19166287355',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1968,	'CA9ae3cbf4f5e4bc44f3feb239fca07b61',	'',	'2018-03-31 15:43:13',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75201',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12148020499',	'+19722036640',	'+12148020499',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CA9ae3cbf4f5e4bc44f3feb239fca07b61',	'+19728157325',	'completed',	494,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb37f3a964bef16a86808778d56624daa',	0,	0,	'',	''),
(1969,	'CA4a9f3cff437df9bbe57db22fd2b4b3a6',	'',	'2018-03-31 16:26:34',	'US',	'76210',	'TX',	'DENTON',	'US',	'75002',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14693422058',	'+19402203619',	'+14693422058',	NULL,	NULL,	NULL,	NULL,	'ALLEN',	'TX',	'CA4a9f3cff437df9bbe57db22fd2b4b3a6',	'+16172334088',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1970,	'CA56842812625c6564e568f196903c08c5',	'',	'2018-04-01 02:33:08',	'US',	'',	'TX',	'',	'US',	'76002',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18174495429',	'+16823053491',	'+18174495429',	NULL,	NULL,	NULL,	NULL,	'ARLINGTON',	'TX',	'CA56842812625c6564e568f196903c08c5',	'+18178814663',	'completed',	19,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE1d6c8839391df2c9b3b9e464fd65ab6b',	0,	0,	'',	''),
(1971,	'CA1aad48ec5ea7b19371c6ff05482f8746',	'',	'2018-04-02 14:20:00',	'US',	'75024',	'TX',	'PLANO',	'US',	'75029',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14696711589',	'+19728051470',	'+14696711589',	NULL,	NULL,	NULL,	NULL,	'LEWISVILLE',	'TX',	'CA1aad48ec5ea7b19371c6ff05482f8746',	'+12146824990',	'completed',	194,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REdd1061e29cb9004eb7404bbc7a882927',	0,	0,	'',	''),
(1972,	'CA8cbae5a923e994bca41637de90f45719',	'',	'2018-04-02 15:19:22',	'US',	'75258',	'TX',	'DALLAS',	'US',	'80209',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17209412006',	'+12147613136',	'+17209412006',	NULL,	NULL,	NULL,	NULL,	'DENVER',	'CO',	'CA8cbae5a923e994bca41637de90f45719',	'+12147096672',	'completed',	17,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3ad56da3b43f37685a492a1c038c92a4',	0,	0,	'',	''),
(1973,	'CA68635cbc06135b395bc7e951a4041002',	'',	'2018-04-02 16:08:22',	'US',	'75230',	'TX',	'DALLAS',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12679308301',	'+12146922858',	'+12679308301',	NULL,	NULL,	NULL,	NULL,	'',	'PA',	'CA68635cbc06135b395bc7e951a4041002',	'+19725705808',	'completed',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REbd9ad6537c14472e8bef748affdcac78',	0,	0,	'',	''),
(1974,	'CAeef184a7b43843c19d7fa75fb67048ff',	'',	'2018-04-02 17:17:13',	'US',	'94509',	'CA',	'ANTIOCH',	'US',	'94588',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19252185753',	'+19252197932',	'+19252185753',	NULL,	NULL,	NULL,	NULL,	'PLEASANTON',	'CA',	'CAeef184a7b43843c19d7fa75fb67048ff',	'+19255840363',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE6746cd12de8496a07c72c5fed8a03cd1',	0,	0,	'',	''),
(1975,	'CA31233c3d58b369906ab0bcf47c2f91bb',	'',	'2018-04-02 18:00:38',	'US',	'94568',	'CA',	'PLEASANTON',	'US',	'94539',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19252011899',	'+19252042504',	'+19252011899',	NULL,	NULL,	NULL,	NULL,	'PLEASANTON',	'CA',	'CA31233c3d58b369906ab0bcf47c2f91bb',	'+19255840363',	'completed',	12,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4e3c155836fc302b769f37ef27e4e7be',	0,	0,	'',	''),
(1976,	'CAbbabc45ebfb5898757791cf7e0ad0cca',	'',	'2018-04-02 19:30:17',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75038',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19722520084',	'+19722036659',	'+19722520084',	NULL,	NULL,	NULL,	NULL,	'IRVING',	'TX',	'CAbbabc45ebfb5898757791cf7e0ad0cca',	'+12147183718',	'completed',	305,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc0f6bf7e02ccddc5799631c7e77a5a7d',	0,	0,	'',	''),
(1977,	'CA375e7d50e17f132ec2c7e2ff3a1ff2ff',	'',	'2018-04-02 21:13:31',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75252',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19728013976',	'+19722036218',	'+19728013976',	NULL,	NULL,	NULL,	NULL,	'PLANO',	'TX',	'CA375e7d50e17f132ec2c7e2ff3a1ff2ff',	'+12147183718',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1978,	'CAf7e9a311926ca5f973f9f59e3b072977',	'',	'2018-04-02 21:13:54',	'US',	'94509',	'CA',	'ANTIOCH',	'US',	'97232',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15033863632',	'+19252197932',	'+15033863632',	NULL,	NULL,	NULL,	NULL,	'PORTLAND',	'OR',	'CAf7e9a311926ca5f973f9f59e3b072977',	'+19255840363',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1979,	'CA4ea961af57b1c65a5002a6c0f733d79c',	'',	'2018-04-03 00:52:40',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75182',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19722037553',	'+19722036218',	'+19722037553',	NULL,	NULL,	NULL,	NULL,	'SUNNYVALE',	'TX',	'CA4ea961af57b1c65a5002a6c0f733d79c',	'+12147183718',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1980,	'CAabe3b2d199915c8beb95090988f0a1a6',	'',	'2018-04-03 14:27:22',	'US',	'75024',	'TX',	'PLANO',	'US',	'75201',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19726842140',	'+19728051470',	'+19726842140',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CAabe3b2d199915c8beb95090988f0a1a6',	'+12146824990',	'completed',	4,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE2a9d52510e1a390761432964bf23d10f',	0,	0,	'',	''),
(1981,	'CA591cdcfd7af1166e3f4fbbed3cab7ecb',	'',	'2018-04-03 16:06:09',	'US',	'75258',	'TX',	'DALLAS',	'US',	'60827',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17735469489',	'+12147613136',	'+17735469489',	NULL,	NULL,	NULL,	NULL,	'CHICAGO',	'IL',	'CA591cdcfd7af1166e3f4fbbed3cab7ecb',	'+12147096672',	'completed',	386,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE81b68f6cc753d8105da804e4bbc838b5',	0,	0,	'',	''),
(1982,	'CAb43bbe78931f66bb455811d2de1c26be',	'',	'2018-04-04 03:30:55',	'US',	'',	'AZ',	'',	'US',	'85308',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16233320850',	'+16232330255',	'+16233320850',	NULL,	NULL,	NULL,	NULL,	'PHOENIX',	'AZ',	'CAb43bbe78931f66bb455811d2de1c26be',	'+14803882032',	'completed',	157,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REbfddcafbc77d7cedcafbb536c9b99de6',	0,	0,	'',	''),
(1983,	'CAd148797d8b95c7d88a6f3a6a082e75d6',	'',	'2018-04-04 14:32:41',	'US',	'',	'TX',	'',	'US',	'94043',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16502532000',	'+14696091618',	'+16502532000',	NULL,	NULL,	NULL,	NULL,	'MOUNTAIN VIEW',	'CA',	'CAd148797d8b95c7d88a6f3a6a082e75d6',	'+12146953999',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1984,	'CA11735c8680f072fadc3424ce1cafb7e9',	'',	'2018-04-04 18:17:48',	'US',	'',	'TX',	'',	'US',	'94043',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16502532000',	'+14696091618',	'+16502532000',	NULL,	NULL,	NULL,	NULL,	'MOUNTAIN VIEW',	'CA',	'CA11735c8680f072fadc3424ce1cafb7e9',	'+12146953999',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1985,	'CAd168b4f46205dc5351ce0d3f6f416201',	'',	'2018-04-04 22:02:22',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'76210',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12144053124',	'+19722036640',	'+12144053124',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CAd168b4f46205dc5351ce0d3f6f416201',	'+19728157325',	'completed',	74,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE35ce130f4475c2e692e39abc9bdf6ac8',	0,	0,	'',	''),
(1986,	'CA052948e33f4d1172b9daa64813314bf6',	'',	'2018-04-04 22:04:48',	'US',	'75024',	'TX',	'PLANO',	'US',	'76210',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12144053124',	'+19728051470',	'+12144053124',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CA052948e33f4d1172b9daa64813314bf6',	'+12146824990',	'completed',	39,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE366c29fbc35c1f87c569ddf2da7d6f4a',	0,	0,	'',	''),
(1987,	'CA57ae661343a4f4a25d53e694b8577666',	'',	'2018-04-04 22:37:20',	'US',	'92122',	'CA',	'SAN DIEGO',	'US',	'92131',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16198578027',	'+16195548764',	'+16198578027',	NULL,	NULL,	NULL,	NULL,	'SAN DIEGO',	'CA',	'CA57ae661343a4f4a25d53e694b8577666',	'+16198233047',	'completed',	113,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc1355063521e4cfd59cb5ff79ba7c068',	0,	0,	'',	''),
(1988,	'CA0a9e208de49dc3ddb6722487f380b4e2',	'',	'2018-04-05 16:39:18',	'US',	'',	'TX',	'',	'US',	'94043',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16502532000',	'+14696091618',	'+16502532000',	NULL,	NULL,	NULL,	NULL,	'MOUNTAIN VIEW',	'CA',	'CA0a9e208de49dc3ddb6722487f380b4e2',	'+12146953999',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE89af415b72b83e823194dc2b11932493',	0,	0,	'',	''),
(1989,	'CA79503317f30f4301d53f8318e18c012e',	'',	'2018-04-05 16:56:15',	'US',	'76210',	'TX',	'DENTON',	'US',	'76266',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19403916658',	'+19402932113',	'+19403916658',	NULL,	NULL,	NULL,	NULL,	'DENTON',	'TX',	'CA79503317f30f4301d53f8318e18c012e',	'+12146953999',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE62f75349b7c5296477b671c60172af31',	0,	0,	'',	''),
(1990,	'CAc9217b3c1b43cb1c5ac24bc22e8fd53d',	'',	'2018-04-05 17:14:43',	'US',	'',	'TX',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18328629579',	'+18327064084',	'+18328629579',	NULL,	NULL,	NULL,	NULL,	'',	'TX',	'CAc9217b3c1b43cb1c5ac24bc22e8fd53d',	'+18327156360',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(1991,	'CA313869c286eca94c3a266aae04c12cd2',	'',	'2018-04-05 17:21:16',	'US',	'94105',	'CA',	'SAN FRANCISCO',	'US',	'94107',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14152184805',	'+14152125436',	'+14152184805',	NULL,	NULL,	NULL,	NULL,	'SAN FRANCISCO',	'CA',	'CA313869c286eca94c3a266aae04c12cd2',	'+15106893859',	'completed',	15,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REfa82bd0a580c43ca7411114d6c0705ff',	0,	0,	'',	''),
(1992,	'CAe99cbcb4e30be02c58d577bfbcbeb65a',	'',	'2018-04-05 19:05:08',	'US',	'92085',	'CA',	'VISTA',	'US',	'56425',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12183160029',	'+17604073880',	'+12183160029',	NULL,	NULL,	NULL,	NULL,	'BRAINERD',	'MN',	'CAe99cbcb4e30be02c58d577bfbcbeb65a',	'+17602378044',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE8a51fbbe6c6ac6438e7737d52d573d98',	0,	0,	'',	''),
(1993,	'CA5698a1339c8bb761b33dab496e378b0b',	'',	'2018-04-06 15:23:39',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'65633',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14172034248',	'+19722036218',	'+14172034248',	NULL,	NULL,	NULL,	NULL,	'CRANE',	'MO',	'CA5698a1339c8bb761b33dab496e378b0b',	'+12147183718',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE965c2d7ad9f0cf7c23d2491e82f48fec',	0,	0,	'',	''),
(1994,	'CA1cb7861543aa2954a8d83bd0e7211f44',	'',	'2018-04-06 18:14:49',	'US',	'88240',	'NM',	'JAL',	'US',	'88260',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15053984951',	'+15053955486',	'+15053984951',	NULL,	NULL,	NULL,	NULL,	'TATUM',	'NM',	'CA1cb7861543aa2954a8d83bd0e7211f44',	'+15056909386',	'completed',	2,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE453008c1862d557a06858d87766f6022',	0,	0,	'',	''),
(1995,	'CA0050f7211d75f186777f12f264aed642',	'',	'2018-04-06 19:07:41',	'US',	'75258',	'TX',	'DALLAS',	'US',	'60631',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17738773667',	'+12147613136',	'+17738773667',	NULL,	NULL,	NULL,	NULL,	'CHICAGO',	'IL',	'CA0050f7211d75f186777f12f264aed642',	'+12147096672',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE6076a307cf28e5fb333b158a0dd4c681',	0,	0,	'',	''),
(1996,	'CAcec0a1d4e58214d491d1f65ffdb6e709',	'',	'2018-04-06 19:08:42',	'US',	'75258',	'TX',	'DALLAS',	'US',	'60631',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17738773667',	'+12147613136',	'+17738773667',	NULL,	NULL,	NULL,	NULL,	'CHICAGO',	'IL',	'CAcec0a1d4e58214d491d1f65ffdb6e709',	'+12147096672',	'completed',	58,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE0b7ab7c10eb48db746f3049c92d319f0',	0,	0,	'',	''),
(1997,	'CAed63aaa5ced3c36c6a7c51d4c439de4e',	'',	'2018-04-06 20:40:20',	'US',	'76210',	'TX',	'DENTON',	'US',	'84043',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18016533743',	'+19402203619',	'+18016533743',	NULL,	NULL,	NULL,	NULL,	'LEHI',	'UT',	'CAed63aaa5ced3c36c6a7c51d4c439de4e',	'+16172334088',	'completed',	3,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc182c76c2c50e90c8dfff93250cfcfe0',	0,	0,	'',	''),
(1998,	'CA6590cf8e4e57e38bea4fc0ca5c3b5b01',	'',	'2018-04-06 21:27:27',	'US',	'',	'TX',	'Houston',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13467752208',	'+13462144636',	'+13467752208',	NULL,	NULL,	NULL,	NULL,	'Houston',	'TX',	'CA6590cf8e4e57e38bea4fc0ca5c3b5b01',	'+13462347725',	'completed',	621,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE227cda154ee087dd6cef90a0fe735c48',	0,	0,	'',	''),
(1999,	'CAea6e19cd9e968dbd528c83964ef675e4',	'',	'2018-04-07 01:19:01',	'US',	'94105',	'CA',	'SAN FRANCISCO',	'US',	'94121',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14152136503',	'+14152125436',	'+14152136503',	NULL,	NULL,	NULL,	NULL,	'SAN FRANCISCO',	'CA',	'CAea6e19cd9e968dbd528c83964ef675e4',	'+15106893859',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE97c4a143becc8444084db786f21f3625',	0,	0,	'',	''),
(2000,	'CA99265fcb69fe2ff842a5354e8b96580c',	'',	'2018-04-07 01:29:25',	'US',	'75234',	'TX',	'CARROLLTON',	'US',	'76704',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18177565414',	'+14695578827',	'+18177565414',	NULL,	NULL,	NULL,	NULL,	'GRAPEVINE',	'TX',	'CA99265fcb69fe2ff842a5354e8b96580c',	'+19402315995',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE15d5861f925e7307cc263f6fad4a80e2',	0,	0,	'',	''),
(2001,	'CA47aaa5af3f68551e898f9c76e46ce06f',	'',	'2018-04-07 15:39:52',	'US',	'30312',	'GA',	'ATLANTA',	'US',	'07086',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12012047056',	'+14044765368',	'+12012047056',	NULL,	NULL,	NULL,	NULL,	'WEEHAWKEN',	'NJ',	'CA47aaa5af3f68551e898f9c76e46ce06f',	'+14042107184',	'completed',	214,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE6890fbfc5f99c53abe0fa91588880975',	0,	0,	'',	''),
(2002,	'CAa445f795d64b350a316c61d04145d46c',	'',	'2018-04-07 15:44:07',	'US',	'30312',	'GA',	'ATLANTA',	'US',	'07086',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12012047056',	'+14044765368',	'+12012047056',	NULL,	NULL,	NULL,	NULL,	'WEEHAWKEN',	'NJ',	'CAa445f795d64b350a316c61d04145d46c',	'+14042107184',	'completed',	659,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3cd032ad82cb2903c0dbeb5d6f60b097',	0,	0,	'',	''),
(2003,	'CA8f84fe03022b00d576a3bd2e2f2029b2',	'',	'2018-04-07 18:36:48',	'US',	'',	'TX',	'Houston',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14155808290',	'+13462144636',	'+14155808290',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA8f84fe03022b00d576a3bd2e2f2029b2',	'+13462347725',	'completed',	122,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REee917a3843aab0e0aa5ac725975687c3',	0,	0,	'',	''),
(2004,	'CA58d35ceb383790142f81556b39747c4d',	'',	'2018-04-09 14:59:45',	'US',	'20817',	'MD',	'FORT WASHINGTON',	'US',	'20871',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13012566708',	'+13014337892',	'+13012566708',	NULL,	NULL,	NULL,	NULL,	'LAUREL',	'MD',	'CA58d35ceb383790142f81556b39747c4d',	'+12024123578',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2005,	'CAb2965cbe2238f5ff9673be612862ac21',	'',	'2018-04-09 16:29:49',	'US',	'75254',	'TX',	'DALLAS',	'US',	'75260',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12144292080',	'+19728611197',	'+12144292080',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CAb2965cbe2238f5ff9673be612862ac21',	'+12147183718',	'completed',	43,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE481166f8c500f71e3a89e7d613798708',	0,	0,	'',	''),
(2006,	'CA2a2d273578707a62f9b6c943d99f17ad',	'',	'2018-04-09 19:12:38',	'US',	'20744',	'MD',	'OXON HILL',	'US',	'20737',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13012674558',	'+13017476807',	'+13012674558',	NULL,	NULL,	NULL,	NULL,	'GREENBELT',	'MD',	'CA2a2d273578707a62f9b6c943d99f17ad',	'+12024123578',	'completed',	287,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE958a0f896b26508e931dcef8a2f1b596',	0,	0,	'',	''),
(2007,	'CA5df8abbc1280de70d1f34831b7e8b961',	'',	'2018-04-10 00:45:02',	'US',	'94509',	'CA',	'ANTIOCH',	'US',	'94509',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19252196253',	'+19252197932',	'+19252196253',	NULL,	NULL,	NULL,	NULL,	'ANTIOCH',	'CA',	'CA5df8abbc1280de70d1f34831b7e8b961',	'+19255840363',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2008,	'CAac6a6883b65f26fbe8db557d46a03b5a',	'',	'2018-04-10 15:14:36',	'US',	'',	'TX',	'',	'US',	'98109',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12062824100',	'+14695357756',	'+12062824100',	NULL,	NULL,	NULL,	NULL,	'SEATTLE',	'WA',	'CAac6a6883b65f26fbe8db557d46a03b5a',	'+19402315995',	'completed',	35,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE288a8d421e4f4c16ac6c37d8462a2950',	0,	0,	'',	''),
(2009,	'CA9f9867f04c94082bbc9aa6e1ab7a6d82',	'',	'2018-04-10 18:50:35',	'US',	'75258',	'TX',	'DALLAS',	'US',	'60631',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17738773667',	'+12147613136',	'+17738773667',	NULL,	NULL,	NULL,	NULL,	'CHICAGO',	'IL',	'CA9f9867f04c94082bbc9aa6e1ab7a6d82',	'+12147096672',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb3699c0e5f616f1f98a76e970107fb82',	0,	0,	'',	''),
(2010,	'CA173115aa5e5d730fd36df930b713e473',	'',	'2018-04-10 18:55:03',	'US',	'20166',	'MD',	'STERLING',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12407096091',	'+12407022957',	'+12407096091',	NULL,	NULL,	NULL,	NULL,	'',	'MD',	'CA173115aa5e5d730fd36df930b713e473',	'+12024123578',	'completed',	14,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf807e1aa8f33d32881b6419223af621a',	0,	0,	'',	''),
(2011,	'CA4bf37797f73a533ee16603233e6c6af6',	'',	'2018-04-10 18:57:07',	'US',	'76071',	'TX',	'AZLE',	'US',	'76040',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18172823428',	'+18178138258',	'+18172823428',	NULL,	NULL,	NULL,	NULL,	'FORT WORTH',	'TX',	'CA4bf37797f73a533ee16603233e6c6af6',	'+18173042914',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2012,	'CA93183aa42d1695884f5b4274f92c2859',	'',	'2018-04-10 19:32:36',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75007',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19723077175',	'+19722036218',	'+19723077175',	NULL,	NULL,	NULL,	NULL,	'CARROLLTON',	'TX',	'CA93183aa42d1695884f5b4274f92c2859',	'+12147183718',	'completed',	2,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe351dd8930b0dd719b3aedbfa59e3ca9',	0,	0,	'',	''),
(2013,	'CAe415b73a43cf6f3ced00b46b218d2b66',	'',	'2018-04-10 20:54:11',	'US',	'88101',	'NM',	'CLOVIS',	'US',	'87198',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15054806997',	'+15052194134',	'+15054806997',	NULL,	NULL,	NULL,	NULL,	'ALBUQUERQUE',	'NM',	'CAe415b73a43cf6f3ced00b46b218d2b66',	'+15053192181',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2014,	'CA3ae8fac39d9db262e77e35e71522a466',	'',	'2018-04-10 21:46:58',	'US',	'',	'AZ',	'',	'US',	'85220',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14803586118',	'+14803511764',	'+14803586118',	NULL,	NULL,	NULL,	NULL,	'APACHE JUNCTION',	'AZ',	'CA3ae8fac39d9db262e77e35e71522a466',	'+14803882032',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2015,	'CAe848f86f87282a7c5a914080e6aef2b0',	'',	'2018-04-11 02:05:03',	'US',	'29483',	'SC',	'SUMMERVILLE',	'US',	'29424',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18434940596',	'+18433766611',	'+18434940596',	NULL,	NULL,	NULL,	NULL,	'CHARLESTON',	'SC',	'CAe848f86f87282a7c5a914080e6aef2b0',	'+19733427183',	'completed',	49,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE861887ecada6689267c311221d5c6300',	0,	0,	'',	''),
(2016,	'CA068e79a4468931ccbae18a53ab38aab8',	'',	'2018-04-11 15:19:42',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75060',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19728701992',	'+19722036659',	'+19728701992',	NULL,	NULL,	NULL,	NULL,	'IRVING',	'TX',	'CA068e79a4468931ccbae18a53ab38aab8',	'+12147183718',	'completed',	94,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REea479d78ebe0739304ba01b25a71df1b',	0,	0,	'',	''),
(2017,	'CA10c8e6cda59b0c0aabc0f2115b28776f',	'',	'2018-04-11 17:37:38',	'US',	'75258',	'TX',	'DALLAS',	'US',	'60631',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17738773667',	'+12147613136',	'+17738773667',	NULL,	NULL,	NULL,	NULL,	'CHICAGO',	'IL',	'CA10c8e6cda59b0c0aabc0f2115b28776f',	'+12147096672',	'completed',	59,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE23b5f5a325aa70b7fdf6e6dc939a3b2a',	0,	0,	'',	''),
(2018,	'CA6c429a569fc846540607e5882834217c',	'',	'2018-04-11 19:36:17',	'US',	'75244',	'TX',	'DALLAS',	'US',	'75051',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12144701729',	'+19729190409',	'+12144701729',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CA6c429a569fc846540607e5882834217c',	'+19728157325',	'completed',	745,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE8002306797e71cd6652cd58525ec6c66',	0,	0,	'',	''),
(2019,	'CA476b2d0c6269b062bd6774077ff359e8',	'',	'2018-04-11 20:11:29',	'US',	'54023',	'WI',	'ROBERTS',	'US',	'54514',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17157697941',	'+17157609840',	'+17157697941',	NULL,	NULL,	NULL,	NULL,	'BUTTERNUT',	'WI',	'CA476b2d0c6269b062bd6774077ff359e8',	'+15126992965',	'completed',	6,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa8b664d3fc7afc48de422ed5e076ead2',	0,	0,	'',	''),
(2020,	'CA8627f39fdfdb3fca58b3beb127a610df',	'',	'2018-04-11 23:02:44',	'US',	'87828',	'NM',	'SOCORRO',	'US',	'63304',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16363522659',	'+15058352287',	'+16363522659',	NULL,	NULL,	NULL,	NULL,	'SAINT CHARLES',	'MO',	'CA8627f39fdfdb3fca58b3beb127a610df',	'+15053192181',	'completed',	1,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE70d480343bc08e9bc302fda35927f26c',	0,	0,	'',	''),
(2021,	'CA62a80eba14cfba1c96fb85c80cb3cb0f',	'',	'2018-04-11 23:06:50',	'US',	'',	'CA',	'',	'US',	'95670',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19165836573',	'+19165849211',	'+19165836573',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CA62a80eba14cfba1c96fb85c80cb3cb0f',	'+19164825834',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2022,	'CA8400017fa3bbdc37e6811211aa0f8ed6',	'',	'2018-04-12 15:01:13',	'US',	'94108',	'CA',	'SAN FRANCISCO',	'US',	'94611',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15104444525',	'+15102300755',	'+15104444525',	NULL,	NULL,	NULL,	NULL,	'OAKLAND',	'CA',	'CA8400017fa3bbdc37e6811211aa0f8ed6',	'+15106893859',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2023,	'CA593a6f9ff9825cabbd1e69c9812a3d0e',	'',	'2018-04-12 15:30:20',	'US',	'',	'TX',	'',	'US',	'75070',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19723476375',	'+14693536033',	'+19723476375',	NULL,	NULL,	NULL,	NULL,	'PROSPER',	'TX',	'CA593a6f9ff9825cabbd1e69c9812a3d0e',	'+18177847768',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2024,	'CAd5f7f4596dfd9a1f167dd917a255170f',	'',	'2018-04-12 15:31:41',	'US',	'75062',	'TX',	'IRVING',	'US',	'48329',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12488866161',	'+18172038813',	'+12488866161',	NULL,	NULL,	NULL,	NULL,	'WHITE LAKE',	'MI',	'CAd5f7f4596dfd9a1f167dd917a255170f',	'+12146628447',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE53b48080cb0929bd39642c5e817e9c9c',	0,	0,	'',	''),
(2025,	'CAe68ddc9503e9228c58ad43987881bed7',	'',	'2018-04-12 15:59:59',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'48642',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19896005065',	'+19722036640',	'+19896005065',	NULL,	NULL,	NULL,	NULL,	'MIDLAND',	'MI',	'CAe68ddc9503e9228c58ad43987881bed7',	'+19728157325',	'completed',	12,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE90db140eb8f9526133c0d17ddfa4d7b0',	0,	0,	'',	''),
(2026,	'CA294726301be51749bc25536982688af0',	'',	'2018-04-12 16:48:00',	'US',	'',	'TX',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14693530778',	'+14693536033',	'+14693530778',	NULL,	NULL,	NULL,	NULL,	'',	'TX',	'CA294726301be51749bc25536982688af0',	'+18177847768',	'failed',	NULL,	NULL,	0,	0,	'',	''),
(2027,	'CAf7128a9c65ca46bfba1fa98544687818',	'',	'2018-04-12 16:48:12',	'US',	'',	'TX',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14693530778',	'+14693536033',	'+14693530778',	NULL,	NULL,	NULL,	NULL,	'',	'TX',	'CAf7128a9c65ca46bfba1fa98544687818',	'+18177847768',	'failed',	NULL,	NULL,	0,	0,	'',	''),
(2028,	'CAc5d25d64b41aa897c2106477a064e9f5',	'',	'2018-04-12 17:12:41',	'US',	'77995',	'TX',	'YOAKUM',	'US',	'78259',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12102408734',	'+13612983529',	'+12102408734',	NULL,	NULL,	NULL,	NULL,	'SAN ANTONIO',	'TX',	'CAc5d25d64b41aa897c2106477a064e9f5',	'+18327156360',	'completed',	58,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE2a72aa7e27fcb1416c192207d0457fa4',	0,	0,	'',	''),
(2029,	'CAbccbb077abd60221baf31bbf2da75e4a',	'',	'2018-04-12 19:51:14',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19165845440',	'+19165849127',	'+19165845440',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CAbccbb077abd60221baf31bbf2da75e4a',	'+19166287355',	'completed',	17,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE10e5e386b283b7bc22267b316e5b3ff6',	0,	0,	'',	''),
(2030,	'CAb8e59aaf7e809acd6bc7eda01a8e321e',	'',	'2018-04-12 20:18:00',	'US',	'94108',	'CA',	'SAN FRANCISCO',	'US',	'94108',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15102306005',	'+15102300755',	'+15102306005',	NULL,	NULL,	NULL,	NULL,	'SAN FRANCISCO',	'CA',	'CAb8e59aaf7e809acd6bc7eda01a8e321e',	'+15106893859',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE1bbb97933ef0b38c4639f5246390c892',	0,	0,	'',	''),
(2031,	'CA978e06e559d1dc7f1dd437ce3682e7c1',	'',	'2018-04-12 20:53:43',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'77059',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18322407873',	'+19722036640',	'+18322407873',	NULL,	NULL,	NULL,	NULL,	'HOUSTON',	'TX',	'CA978e06e559d1dc7f1dd437ce3682e7c1',	'+19728157325',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE458456e9e2dc93be8d86ddaaa586198b',	0,	0,	'',	''),
(2032,	'CAe717ed0af2cae353ededef7a9adef4f9',	'',	'2018-04-12 20:56:57',	'US',	'75024',	'TX',	'PLANO',	'US',	'77059',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18322407873',	'+19728051470',	'+18322407873',	NULL,	NULL,	NULL,	NULL,	'HOUSTON',	'TX',	'CAe717ed0af2cae353ededef7a9adef4f9',	'+12146824990',	'completed',	140,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE56e6376bc61fda8519a6643c282481d1',	0,	0,	'',	''),
(2033,	'CAd0848c3aed3e6e0aa10c297543546564',	'',	'2018-04-12 22:28:12',	'US',	'74120',	'OK',	'TULSA',	'US',	'74103',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19188630013',	'+19189927424',	'+19188630013',	NULL,	NULL,	NULL,	NULL,	'TULSA',	'OK',	'CAd0848c3aed3e6e0aa10c297543546564',	'+19188009881',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE2527c144a29abdbb629278d5ee59bfff',	0,	0,	'',	''),
(2034,	'CAc16809d0c91b11f804a67145971965f2',	'',	'2018-04-12 22:29:14',	'US',	'74055',	'OK',	'OWASSO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18009168800',	'+19183763961',	'+18009168800',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CAc16809d0c91b11f804a67145971965f2',	'+19188009881',	'busy',	NULL,	NULL,	0,	0,	'',	''),
(2035,	'CA4f2727cfc2d4f814aff77df8493f3b5a',	'',	'2018-04-12 23:24:22',	'US',	'',	'CA',	'',	'US',	'94544',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15102099102',	'+15102108920',	'+15102099102',	NULL,	NULL,	NULL,	NULL,	'HAYWARD',	'CA',	'CA4f2727cfc2d4f814aff77df8493f3b5a',	'+15106893859',	'completed',	30,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE2193849d4eac89c87e5e168a57ca80e9',	0,	0,	'',	''),
(2036,	'CAb4cf4d84502d30d045884a56a1a42aae',	'',	'2018-04-13 13:02:30',	'US',	'29483',	'SC',	'SUMMERVILLE',	'US',	'29530',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18433738345',	'+18433766163',	'+18433738345',	NULL,	NULL,	NULL,	NULL,	'SCRANTON',	'SC',	'CAb4cf4d84502d30d045884a56a1a42aae',	'+19733427183',	'completed',	38,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE6caca496606342baf6722142b423fd34',	0,	0,	'',	''),
(2037,	'CAff5b2a954794096759f51cd31711f1a9',	'',	'2018-04-13 14:00:17',	'US',	'',	'TX',	'',	'US',	'75242',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14693483800',	'+14693536033',	'+14693483800',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CAff5b2a954794096759f51cd31711f1a9',	'+18177847768',	'failed',	NULL,	NULL,	0,	0,	'',	''),
(2038,	'CA18c23fde23dcc88862bc0084dcbf051d',	'',	'2018-04-13 16:58:20',	'US',	'',	'TX',	'',	'US',	'77417',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18323448792',	'+17133227812',	'+18323448792',	NULL,	NULL,	NULL,	NULL,	'ROSENBERG',	'TX',	'CA18c23fde23dcc88862bc0084dcbf051d',	'+13462347725',	'completed',	354,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd7f39c57aa315446ebffd28141731a07',	0,	0,	'',	''),
(2039,	'CAac24e867ce787ca5cff94b5c5c1d318e',	'',	'2018-04-13 18:37:25',	'US',	'94108',	'CA',	'SAN FRANCISCO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19413038657',	'+15102300755',	'+19413038657',	NULL,	NULL,	NULL,	NULL,	'',	'FL',	'CAac24e867ce787ca5cff94b5c5c1d318e',	'+15106893859',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2040,	'CAbb254c63e35dddd308130bee4ed6ecfd',	'',	'2018-04-13 22:44:24',	'US',	'77995',	'TX',	'YOAKUM',	'US',	'78390',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13615345670',	'+13612983529',	'+13615345670',	NULL,	NULL,	NULL,	NULL,	'TAFT',	'TX',	'CAbb254c63e35dddd308130bee4ed6ecfd',	'+18327156360',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2041,	'CA7e7e2cd2a734b3ecaf63eafc387ebf62',	'',	'2018-04-14 01:13:05',	'US',	'92123',	'CA',	'SAN DIEGO',	'US',	'92118',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16194352051',	'+16194323549',	'+16194352051',	NULL,	NULL,	NULL,	NULL,	'CORONADO',	'CA',	'CA7e7e2cd2a734b3ecaf63eafc387ebf62',	'+16198233047',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2042,	'CA426892b3d009e41976bfad919d0d46b6',	'',	'2018-04-14 15:42:19',	'US',	'',	'TX',	'',	'US',	'92806',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17147978575',	'+14696052596',	'+17147978575',	NULL,	NULL,	NULL,	NULL,	'ANAHEIM',	'CA',	'CA426892b3d009e41976bfad919d0d46b6',	'+12147183718',	'completed',	63,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE32102e05a1784b3fc5141d2b8c61bc4b',	0,	0,	'',	''),
(2043,	'CA4aa8d69c738ac9f66a7425883d93c1c8',	'',	'2018-04-14 22:32:58',	'US',	'29483',	'SC',	'SUMMERVILLE',	'US',	'29487',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18433434725',	'+18433766611',	'+18433434725',	NULL,	NULL,	NULL,	NULL,	'CHARLESTON',	'SC',	'CA4aa8d69c738ac9f66a7425883d93c1c8',	'+19733427183',	'completed',	22,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE7dd91541aecb601edb0d92e2c97e2b61',	0,	0,	'',	''),
(2044,	'CA0e52182709352c635ad9d046a37ba929',	'',	'2018-04-14 22:34:00',	'US',	'29483',	'SC',	'SUMMERVILLE',	'US',	'29487',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18433434725',	'+18433766611',	'+18433434725',	NULL,	NULL,	NULL,	NULL,	'CHARLESTON',	'SC',	'CA0e52182709352c635ad9d046a37ba929',	'+19733427183',	'completed',	18,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE11fa0677ba5938128d702f5543ddb1fe',	0,	0,	'',	''),
(2045,	'CA6928debc3e99b0c2174a05d8311b0679',	'',	'2018-04-15 03:26:49',	'US',	'20744',	'MD',	'OXON HILL',	'US',	'77510',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14097716933',	'+13012814540',	'+14097716933',	NULL,	NULL,	NULL,	NULL,	'GALVESTON',	'TX',	'CA6928debc3e99b0c2174a05d8311b0679',	'+12024123578',	'completed',	19,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf84c577d3d66d65f250825737f66042f',	0,	0,	'',	''),
(2046,	'CA66362759b25a5aaa143af257c5525547',	'',	'2018-04-15 20:47:09',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16822481915',	'+19722036659',	'+16822481915',	NULL,	NULL,	NULL,	NULL,	'',	'TX',	'CA66362759b25a5aaa143af257c5525547',	'+12147183718',	'completed',	262,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE67081122dff7debbf5b82d7a16dd24ab',	0,	0,	'',	''),
(2047,	'CA3ab87a2bdb99b72e24e963bb011597ef',	'',	'2018-04-15 20:52:58',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16822481915',	'+19722036659',	'+16822481915',	NULL,	NULL,	NULL,	NULL,	'',	'TX',	'CA3ab87a2bdb99b72e24e963bb011597ef',	'+12147183718',	'completed',	20,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REfad2bd8f2115eb6eb40cb05ecbe198c6',	0,	0,	'',	''),
(2048,	'CA610fca94a5db7247fb1ac51454bb8ed9',	'',	'2018-04-15 23:07:38',	'US',	'75024',	'TX',	'PLANO',	'US',	'75050',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19725135350',	'+19728051470',	'+19725135350',	NULL,	NULL,	NULL,	NULL,	'IRVING',	'TX',	'CA610fca94a5db7247fb1ac51454bb8ed9',	'+12146824990',	'completed',	19,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4b59e4ba8382463d507c1b4bc904e006',	0,	0,	'',	''),
(2049,	'CA19380f0482aadb5e6e695c217fc611b1',	'',	'2018-04-16 14:08:10',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75260',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12144292080',	'+19722036640',	'+12144292080',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CA19380f0482aadb5e6e695c217fc611b1',	'+19728157325',	'completed',	63,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE941c214bf7c32f4c9d84669da76933a6',	0,	0,	'',	''),
(2050,	'CA1f9c5aa617b294d323db389fb527a59b',	'',	'2018-04-16 15:08:36',	'US',	'74110',	'OK',	'TULSA',	'US',	'77069',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12818367071',	'+19186158825',	'+12818367071',	NULL,	NULL,	NULL,	NULL,	'HOUSTON',	'TX',	'CA1f9c5aa617b294d323db389fb527a59b',	'+19188009881',	'completed',	18,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE0def42319a2ddd97432b6033aa4a80c8',	0,	0,	'',	''),
(2051,	'CA47fbe7ec1e45d19827d780f34d4bc41c',	'',	'2018-04-16 16:39:50',	'US',	'20744',	'MD',	'OXON HILL',	'US',	'20744',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13012815308',	'+13012814442',	'+13012815308',	NULL,	NULL,	NULL,	NULL,	'OXON HILL',	'MD',	'CA47fbe7ec1e45d19827d780f34d4bc41c',	'+12024123578',	'completed',	14,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4402fd4ff4e8937c63f3442786214524',	0,	0,	'',	''),
(2052,	'CAb8252e5f8ae04aaa9ac13efef1315ba7',	'',	'2018-04-16 16:46:34',	'US',	'',	'CA',	'',	'US',	'28277',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17049468970',	'+19168273879',	'+17049468970',	NULL,	NULL,	NULL,	NULL,	'CHARLOTTE',	'NC',	'CAb8252e5f8ae04aaa9ac13efef1315ba7',	'+19163975518',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2053,	'CA36fef035a94fd007ed4bc7b6d778d980',	'',	'2018-04-16 18:11:13',	'US',	'75024',	'TX',	'PLANO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19407030790',	'+19728051470',	'+19407030790',	NULL,	NULL,	NULL,	NULL,	'',	'TX',	'CA36fef035a94fd007ed4bc7b6d778d980',	'+12146824990',	'completed',	1525,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa5995699bd45fd5b5a8055ea209152fa',	0,	0,	'',	''),
(2054,	'CA0f53649b01b135aeb55f2d65cc772c3a',	'',	'2018-04-16 20:41:18',	'',	'',	'',	'',	'',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+3035900',	'+19402224558',	'+3035900',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA0f53649b01b135aeb55f2d65cc772c3a',	'+12146628447',	'completed',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE7f743b8096d20234fbd1dfeb4978acce',	0,	0,	'',	''),
(2055,	'CA81f787b7e99449145df4938a2a67f835',	'',	'2018-04-17 14:17:42',	'US',	'76210',	'TX',	'DENTON',	'US',	'75247',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18067312530',	'+19402932113',	'+18067312530',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CA81f787b7e99449145df4938a2a67f835',	'+12146953999',	'completed',	1253,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE6d462e2bd8c66be8be63a3e0cf3df838',	0,	0,	'',	''),
(2056,	'CA7e373eccc2aa93f72263d7c33798c470',	'',	'2018-04-17 14:34:06',	'US',	'20744',	'MD',	'OXON HILL',	'US',	'20744',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13012818776',	'+13012814540',	'+13012818776',	NULL,	NULL,	NULL,	NULL,	'OXON HILL',	'MD',	'CA7e373eccc2aa93f72263d7c33798c470',	'+12024123578',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE6d387f21d6310ae2b4bf861a2718c678',	0,	0,	'',	''),
(2057,	'CAaf51865bd9595966c6c42c8b19be8e80',	'',	'2018-04-17 14:46:16',	'US',	'20166',	'MD',	'STERLING',	'US',	'20613',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12406818351',	'+12407022957',	'+12406818351',	NULL,	NULL,	NULL,	NULL,	'BRANDYWINE',	'MD',	'CAaf51865bd9595966c6c42c8b19be8e80',	'+12024123578',	'completed',	14,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf6670bcc408e66c376f657c0eb7d138a',	0,	0,	'',	''),
(2058,	'CA4ab5fde6ae87ed5505935f90897d618d',	'',	'2018-04-17 16:32:13',	'US',	'92118',	'CA',	'CORONADO',	'US',	'97850',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15419620131',	'+16193136751',	'+15419620131',	NULL,	NULL,	NULL,	NULL,	'LA GRANDE',	'OR',	'CA4ab5fde6ae87ed5505935f90897d618d',	'+16198233047',	'completed',	77,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE5209749bcbb51700b98cae15e54c30c1',	0,	0,	'',	''),
(2059,	'CA1284635d20c5d455fa3454c10f38e4dd',	'',	'2018-04-17 19:09:59',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75251',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19729910882',	'+19722036218',	'+19729910882',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CA1284635d20c5d455fa3454c10f38e4dd',	'+12147183718',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2060,	'CAd0d7e7998e49c3d61551962cf0a2d5f8',	'',	'2018-04-17 19:41:01',	'US',	'75024',	'TX',	'FRISCO',	'US',	'75252',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19723653966',	'+19723705421',	'+19723653966',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CAd0d7e7998e49c3d61551962cf0a2d5f8',	'+12146628447',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2061,	'CAfaa0fa9404ba16fb1fb435d7d9687cb1',	'',	'2018-04-17 20:48:52',	'US',	'',	'TX',	'',	'US',	'75248',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12143846787',	'+19402224558',	'+12143846787',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CAfaa0fa9404ba16fb1fb435d7d9687cb1',	'+12146628447',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa05cacfff4ff2f9a48794b8b1acdf82b',	0,	0,	'',	''),
(2062,	'CA040ca58f4e720ef430b804beb6c40602',	'',	'2018-04-17 21:59:19',	'US',	'29483',	'SC',	'SUMMERVILLE',	'US',	'29424',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18433779543',	'+18433766163',	'+18433779543',	NULL,	NULL,	NULL,	NULL,	'CHARLESTON',	'SC',	'CA040ca58f4e720ef430b804beb6c40602',	'+19733427183',	'completed',	57,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE5ef33f1aa7015cfd52767dc70311771d',	0,	0,	'',	''),
(2063,	'CA31923b6a0efb537e4802fd2afdb74434',	'',	'2018-04-17 22:36:28',	'US',	'94553',	'CA',	'MARTINEZ',	'US',	'92868',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17144648728',	'+19252318830',	'+17144648728',	NULL,	NULL,	NULL,	NULL,	'ORANGE',	'CA',	'CA31923b6a0efb537e4802fd2afdb74434',	'+19255840363',	'completed',	81,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE24d0ca50737eaf409fe1d4f0ec3d653d',	0,	0,	'',	''),
(2064,	'CAdf2a1918cfdb0f6d781a2c22bfc5e6ce',	'',	'2018-04-18 00:38:36',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'76528',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12542065789',	'+19722036659',	'+12542065789',	NULL,	NULL,	NULL,	NULL,	'GATESVILLE',	'TX',	'CAdf2a1918cfdb0f6d781a2c22bfc5e6ce',	'+12147183718',	'completed',	140,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE1565f0693920f2829bfa10dde273e710',	0,	0,	'',	''),
(2065,	'CA573d9b1fff7be06c256e3e75116b7547',	'',	'2018-04-18 17:24:17',	'US',	'75024',	'TX',	'PLANO',	'US',	'75201',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12145526092',	'+19728051470',	'+12145526092',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CA573d9b1fff7be06c256e3e75116b7547',	'+12146824990',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE841b7d78a26df8e8ccbea514e5f53465',	0,	0,	'',	''),
(2066,	'CAc845ea92c073c27f9c89f4dac100227f',	'',	'2018-04-18 18:45:26',	'US',	'83001',	'WY',	'JACKSON',	'US',	'82644',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+13072014710',	'+13072345570',	NULL,	NULL,	NULL,	NULL,	'CASPER',	'WY',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2067,	'CA77ea96f523ef2d6f4dbf3b45b70af067',	'',	'2018-04-18 18:57:18',	'US',	'75002',	'TX',	'ALLEN',	'US',	'78550',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19563127148',	'+19729544433',	'+19563127148',	NULL,	NULL,	NULL,	NULL,	'HARLINGEN',	'TX',	'CA77ea96f523ef2d6f4dbf3b45b70af067',	'+12147183718',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2068,	'CAbfdf9bb7db45b9bc127b660fc926ea2f',	'',	'2018-04-18 19:07:05',	'US',	'94509',	'CA',	'ANTIOCH',	'US',	'94509',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19252194599',	'+19252197932',	'+19252194599',	NULL,	NULL,	NULL,	NULL,	'ANTIOCH',	'CA',	'CAbfdf9bb7db45b9bc127b660fc926ea2f',	'+19255840363',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2069,	'CA671de3b8e78b7eab5750fdc2769ee5fb',	'',	'2018-04-18 20:04:38',	'US',	'94509',	'CA',	'ANTIOCH',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19252116581',	'+19252197932',	'+19252116581',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA671de3b8e78b7eab5750fdc2769ee5fb',	'+19255840363',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REbcf46ee3dda97b47c5d585ad103fb467',	0,	0,	'',	''),
(2070,	'CA62d5616debd073c4c8699eed2f2db251',	'',	'2018-04-18 22:25:57',	'US',	'94108',	'CA',	'SAN FRANCISCO',	'US',	'94108',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15102304816',	'+15102300755',	'+15102304816',	NULL,	NULL,	NULL,	NULL,	'SAN FRANCISCO',	'CA',	'CA62d5616debd073c4c8699eed2f2db251',	'+15106893859',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2071,	'CA5c82cf7e949f4ea688533afe4c9bcf8e',	'',	'2018-04-18 22:34:53',	'US',	'74110',	'OK',	'TULSA',	'US',	'07726',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17322526792',	'+19186158825',	'+17322526792',	NULL,	NULL,	NULL,	NULL,	'FREEHOLD',	'NJ',	'CA5c82cf7e949f4ea688533afe4c9bcf8e',	'+19188009881',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2072,	'CAfa178d17ebe58258d23720e88ad620a7',	'',	'2018-04-18 22:38:51',	'US',	'94553',	'CA',	'MARTINEZ',	'US',	'92868',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17144648728',	'+19252313411',	'+17144648728',	NULL,	NULL,	NULL,	NULL,	'ORANGE',	'CA',	'CAfa178d17ebe58258d23720e88ad620a7',	'+19255840363',	'completed',	27,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REdaae133d5ee99cd67f5dda2f5dd6b2ac',	0,	0,	'',	''),
(2073,	'CAa1a9380066d4706b5bc38d63df96f470',	'',	'2018-04-19 00:34:31',	'US',	'94553',	'CA',	'MARTINEZ',	'US',	'92868',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17144648728',	'+19252319862',	'+17144648728',	NULL,	NULL,	NULL,	NULL,	'ORANGE',	'CA',	'CAa1a9380066d4706b5bc38d63df96f470',	'+19255840363',	'completed',	71,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REdc20043b05fcd4d2b3203636e5993e8a',	0,	0,	'',	''),
(2074,	'CA007b1431320a8fd936a6acc3462e5427',	'',	'2018-04-19 03:38:22',	'US',	'',	'CA',	'',	'US',	'94583',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19256600099',	'+19166941672',	'+19256600099',	NULL,	NULL,	NULL,	NULL,	'PLEASANTON',	'CA',	'CA007b1431320a8fd936a6acc3462e5427',	'+19163975518',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2075,	'CA0f27bcd201a70be82bcd0455032642fe',	'',	'2018-04-19 16:40:26',	'US',	'88101',	'NM',	'CLOVIS',	'US',	'88101',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15052193011',	'+15052194134',	'+15052193011',	NULL,	NULL,	NULL,	NULL,	'CLOVIS',	'NM',	'CA0f27bcd201a70be82bcd0455032642fe',	'+15053192181',	'completed',	68,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4933e042c0770d12d664aba56ad0e3df',	0,	0,	'',	''),
(2076,	'CA5645b5e2e98c7265102fa72767f55b3e',	'',	'2018-04-19 17:19:44',	'US',	'75002',	'TX',	'ALLEN',	'US',	'75023',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14694432807',	'+19729546081',	'+14694432807',	NULL,	NULL,	NULL,	NULL,	'PLANO',	'TX',	'CA5645b5e2e98c7265102fa72767f55b3e',	'+19729546081',	'completed',	18,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc208a97e7df6aef29099f0d04d782d52',	0,	0,	'',	''),
(2077,	'CAd511f22314f8854d969b052580c8ddba',	'',	'2018-04-19 17:19:46',	'US',	'75002',	'TX',	'ALLEN',	'US',	'75023',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14694432807',	'+19729546081',	'+14694432807',	NULL,	NULL,	NULL,	NULL,	'PLANO',	'TX',	'CAd511f22314f8854d969b052580c8ddba',	'+19729546081',	'completed',	16,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc5263221054ec14d014c2414ec854088',	0,	0,	'',	''),
(2078,	'CAeb8428e32aa00bedf93e78b4919279ae',	'',	'2018-04-19 17:19:48',	'US',	'75002',	'TX',	'ALLEN',	'US',	'75023',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14694432807',	'+19729546081',	'+14694432807',	NULL,	NULL,	NULL,	NULL,	'PLANO',	'TX',	'CAeb8428e32aa00bedf93e78b4919279ae',	'+19729546081',	'completed',	15,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE03fb753b756751d5aae62a50f0452799',	0,	0,	'',	''),
(2079,	'CA139a7e776f54bda8aaa37cf44cc1d8f3',	'',	'2018-04-19 17:19:49',	'US',	'75002',	'TX',	'ALLEN',	'US',	'75023',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14694432807',	'+19729546081',	'+14694432807',	NULL,	NULL,	NULL,	NULL,	'PLANO',	'TX',	'CA139a7e776f54bda8aaa37cf44cc1d8f3',	'+19729546081',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe088546cf109c599482598affb9cccd2',	0,	0,	'',	''),
(2080,	'CAd68815f857a26844ca576395c3c6ae9b',	'',	'2018-04-19 17:19:51',	'US',	'75002',	'TX',	'ALLEN',	'US',	'75023',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14694432807',	'+19729546081',	'+14694432807',	NULL,	NULL,	NULL,	NULL,	'PLANO',	'TX',	'CAd68815f857a26844ca576395c3c6ae9b',	'+19729546081',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb1db25dac2506dcd91cba0e602385333',	0,	0,	'',	''),
(2081,	'CAb19c093e30c1ee09f2650b8c24965d9f',	'',	'2018-04-19 17:19:53',	'US',	'75002',	'TX',	'ALLEN',	'US',	'75023',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14694432807',	'+19729546081',	'+14694432807',	NULL,	NULL,	NULL,	NULL,	'PLANO',	'TX',	'CAb19c093e30c1ee09f2650b8c24965d9f',	'+19729546081',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE7b63f43555a5d01afc461d260fad5c85',	0,	0,	'',	''),
(2082,	'CA8bed9ba711eba8fb9cf4163c869e681c',	'',	'2018-04-19 17:19:55',	'US',	'75002',	'TX',	'ALLEN',	'US',	'75023',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14694432807',	'+19729546081',	'+14694432807',	NULL,	NULL,	NULL,	NULL,	'PLANO',	'TX',	'CA8bed9ba711eba8fb9cf4163c869e681c',	'+19729546081',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3f00226727052c70aa7b815788d7b96a',	0,	0,	'',	''),
(2083,	'CA6b2c396df359e4b70866934b80bb376b',	'',	'2018-04-19 17:19:57',	'US',	'75002',	'TX',	'ALLEN',	'US',	'75023',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14694432807',	'+19729546081',	'+14694432807',	NULL,	NULL,	NULL,	NULL,	'PLANO',	'TX',	'CA6b2c396df359e4b70866934b80bb376b',	'+19729546081',	'completed',	6,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE96ad9f9cb8622eaab4e409a79cf01c72',	0,	0,	'',	''),
(2084,	'CAee8dcd1c844efaf8438b2bb987745d69',	'',	'2018-04-19 17:19:58',	'US',	'75002',	'TX',	'ALLEN',	'US',	'75023',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14694432807',	'+19729546081',	'+14694432807',	NULL,	NULL,	NULL,	NULL,	'PLANO',	'TX',	'CAee8dcd1c844efaf8438b2bb987745d69',	'+19729546081',	'completed',	4,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE088cea7ea228d7006dc0c47246e78080',	0,	0,	'',	''),
(2085,	'CAe726b5cb328ffd2d67dc58e6c6147343',	'',	'2018-04-19 17:20:00',	'US',	'75002',	'TX',	'ALLEN',	'US',	'75023',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14694432807',	'+19729546081',	'+14694432807',	NULL,	NULL,	NULL,	NULL,	'PLANO',	'TX',	'CAe726b5cb328ffd2d67dc58e6c6147343',	'+19729546081',	'completed',	2,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE5c32e31cf4ad151229631369ab6e1f8a',	0,	0,	'',	''),
(2086,	'CA6d6245617f613e0535510b00f80c08ee',	'',	'2018-04-19 17:20:02',	'US',	'75002',	'TX',	'ALLEN',	'US',	'75023',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14694432807',	'+19729546081',	'+14694432807',	NULL,	NULL,	NULL,	NULL,	'PLANO',	'TX',	'CA6d6245617f613e0535510b00f80c08ee',	'+19729546081',	'failed',	NULL,	NULL,	0,	0,	'',	''),
(2087,	'CAa946a4f0f01ed35502a8bda4ffa8312e',	'',	'2018-04-19 18:17:23',	'US',	'',	'NV',	'',	'US',	'02199',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17812151594',	'+17029195831',	'+17812151594',	NULL,	NULL,	NULL,	NULL,	'BOSTON',	'MA',	'CAa946a4f0f01ed35502a8bda4ffa8312e',	'+17252223264',	'completed',	14,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf75f94ea0c292afd36d41f985368c6b8',	0,	0,	'',	''),
(2088,	'CA184ccbe6af039ef35eefa1b11b7161a0',	'',	'2018-04-19 19:49:10',	'US',	'94615',	'CA',	'OAKLAND',	'US',	'94615',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15105615685',	'+15102284588',	'+15105615685',	NULL,	NULL,	NULL,	NULL,	'OAKLAND',	'CA',	'CA184ccbe6af039ef35eefa1b11b7161a0',	'+15106893859',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc537f3fac055b328250b0bfb91fadac9',	0,	0,	'',	''),
(2089,	'CA7602b25c9b5277cdc5e393c8c817d0bd',	'',	'2018-04-19 22:05:18',	'US',	'75024',	'TX',	'PLANO',	'US',	'76704',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12542140066',	'+19728051470',	'+12542140066',	NULL,	NULL,	NULL,	NULL,	'WACO',	'TX',	'CA7602b25c9b5277cdc5e393c8c817d0bd',	'+12146824990',	'completed',	66,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE2d4b78782a42a89b942aaa353b8616b1',	0,	0,	'',	''),
(2090,	'CA6b30efe0bd8146f7c2c8021237702455',	'',	'2018-04-20 02:15:48',	'US',	'94568',	'CA',	'PLEASANTON',	'US',	'94509',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19252051140',	'+19252042504',	'+19252051140',	NULL,	NULL,	NULL,	NULL,	'ANTIOCH',	'CA',	'CA6b30efe0bd8146f7c2c8021237702455',	'+19255840363',	'completed',	23,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE127dff2515d148a4339d0e050486867c',	0,	0,	'',	''),
(2091,	'CA7b6bc253a33fda3ad51c16a883e4aa37',	'',	'2018-04-20 15:13:52',	'US',	'',	'TX',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14696146579',	'+14696172969',	'+14696146579',	NULL,	NULL,	NULL,	NULL,	'',	'TX',	'CA7b6bc253a33fda3ad51c16a883e4aa37',	'+16172334088',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2092,	'CA58837e2250ca0b01b2d256a97a9363d2',	'',	'2018-04-20 17:00:40',	'US',	'',	'CA',	'',	'AU',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+61435996943',	'+19166940377',	'+61435996943',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA58837e2250ca0b01b2d256a97a9363d2',	'+19162243237',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3880edbf6a44d078045295c783014cdd',	0,	0,	'',	''),
(2093,	'CA837ec2ae0875b6eacf4d9234b224f236',	'',	'2018-04-20 17:27:32',	'US',	'75202',	'TX',	'DALLAS',	'US',	'75460',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12147851535',	'+12149221949',	'+12147851535',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CA837ec2ae0875b6eacf4d9234b224f236',	'+12147851535',	'busy',	NULL,	NULL,	0,	0,	'',	''),
(2094,	'CA4c5de9fa76466992a8b68eec3d0163e2',	'',	'2018-04-20 17:27:35',	'US',	'75002',	'TX',	'ALLEN',	'US',	'75460',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12147851535',	'+19729546081',	'+12147851535',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CA4c5de9fa76466992a8b68eec3d0163e2',	'+19729546081',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2095,	'CAdc4dc5c76f531b2f8455f5b3f0ce2193',	'',	'2018-04-20 19:42:43',	'US',	'',	'TX',	'',	'US',	'70149',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15049196996',	'+14696052596',	'+15049196996',	NULL,	NULL,	NULL,	NULL,	'NEW ORLEANS',	'LA',	'CAdc4dc5c76f531b2f8455f5b3f0ce2193',	'+12147183718',	'completed',	180,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4d47a041a1b30489f37e53cecd525ee4',	0,	0,	'',	''),
(2096,	'CA8b84a7e58ec93ac84e3c6eb410377258',	'',	'2018-04-20 19:48:58',	'US',	'75062',	'TX',	'IRVING',	'US',	'76131',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18177032817',	'+18172032817',	'+18177032817',	NULL,	NULL,	NULL,	NULL,	'ARLINGTON',	'TX',	'CA8b84a7e58ec93ac84e3c6eb410377258',	'+12146628447',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2097,	'CAa3ec6e5fe81ddbb102ac9fa3dcc97b2f',	'',	'2018-04-21 00:33:20',	'US',	'76210',	'TX',	'DENTON',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14012006291',	'+19402203619',	'+14012006291',	NULL,	NULL,	NULL,	NULL,	'',	'RI',	'CAa3ec6e5fe81ddbb102ac9fa3dcc97b2f',	'+16172334088',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2098,	'CA584f901270b1f83fb36f31c131059b3e',	'',	'2018-04-21 18:12:46',	'US',	'77478',	'TX',	'SUGAR LAND',	'US',	'77002',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17135206523',	'+18325005830',	'+17135206523',	NULL,	NULL,	NULL,	NULL,	'HOUSTON',	'TX',	'CA584f901270b1f83fb36f31c131059b3e',	'+13462347725',	'completed',	34,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe78ef3ad808917c6f87577d630334315',	0,	0,	'',	''),
(2099,	'CA5099d8bcf5d1ea48dfc7164cb89c7c83',	'',	'2018-04-21 22:28:53',	'US',	'76071',	'TX',	'AZLE',	'US',	'71232',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+13187223356',	'+18178138258',	'+13187223356',	NULL,	NULL,	NULL,	NULL,	'BASKIN',	'LA',	'CA5099d8bcf5d1ea48dfc7164cb89c7c83',	'+18173042914',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2100,	'CAac96d19c0722c5d793e72a9dae256579',	'',	'2018-04-22 00:33:11',	'US',	'77995',	'TX',	'YOAKUM',	'US',	'77042',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17137052579',	'+13612983529',	'+17137052579',	NULL,	NULL,	NULL,	NULL,	'HOUSTON',	'TX',	'CAac96d19c0722c5d793e72a9dae256579',	'+18327156360',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2101,	'CA513a5ade279a7667bbfb3166629d83b5',	'',	'2018-04-22 01:16:47',	'US',	'92123',	'CA',	'SAN DIEGO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18002882020',	'+16194583722',	'+18002882020',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA513a5ade279a7667bbfb3166629d83b5',	'+17602378044',	'completed',	1,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE5f8fb4f75b067c397bc56a4f699f8abe',	0,	0,	'',	''),
(2102,	'CAb8e091c935b065070b3f9d35271511cc',	'',	'2018-04-22 15:12:15',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75052',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14695442839',	'+19722036640',	'+14695442839',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CAb8e091c935b065070b3f9d35271511cc',	'+19728157325',	'completed',	583,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE895c908152ea0dfb6c0757fc41b13752',	0,	0,	'',	''),
(2103,	'CA8702f16f1706da81fb51a1928f7136e4',	'',	'2018-04-22 21:27:48',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'80620',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19703017705',	'+19722036640',	'+19703017705',	NULL,	NULL,	NULL,	NULL,	'GREELEY',	'CO',	'CA8702f16f1706da81fb51a1928f7136e4',	'+19728157325',	'completed',	3,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc69f605037a51f60d782099781d6a425',	0,	0,	'',	''),
(2104,	'CAd69fdabc533a42e15c71cb1220a461a8',	'',	'2018-04-22 21:30:24',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'80620',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19704057709',	'+19722036640',	'+19704057709',	NULL,	NULL,	NULL,	NULL,	'GREELEY',	'CO',	'CAd69fdabc533a42e15c71cb1220a461a8',	'+19728157325',	'completed',	71,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe83e1b6e648864b83fdb5e00d7bcbd43',	0,	0,	'',	''),
(2105,	'CA5e94459f0adf002f60f6a2607089097c',	'',	'2018-04-23 15:01:10',	'US',	'20166',	'MD',	'STERLING',	'US',	'21770',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12407458085',	'+12407022957',	'+12407458085',	NULL,	NULL,	NULL,	NULL,	'DAMASCUS',	'MD',	'CA5e94459f0adf002f60f6a2607089097c',	'+12024123578',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2106,	'CAe3c2e63493635658a6422329e9ef861e',	'',	'2018-04-23 16:54:59',	'US',	'',	'CA',	'',	'US',	'95841',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19165083616',	'+19165070189',	'+19165083616',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CAe3c2e63493635658a6422329e9ef861e',	'+19164825834',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2107,	'CAeea1e33b4cf344b0f806e3e3f087a122',	'',	'2018-04-23 17:55:51',	'US',	'30312',	'GA',	'ATLANTA',	'US',	'30312',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14044764576',	'+14044765368',	'+14044764576',	NULL,	NULL,	NULL,	NULL,	'ATLANTA',	'GA',	'CAeea1e33b4cf344b0f806e3e3f087a122',	'+14042107184',	'completed',	22,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe92368ea3e0db45b23c8c21516d79aea',	0,	0,	'',	''),
(2108,	'CAbc7048c94483e370bc19004383fd4445',	'',	'2018-04-23 19:20:56',	'US',	'74172',	'OK',	'TULSA',	'US',	'74855',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14052799677',	'+19186094615',	'+14052799677',	NULL,	NULL,	NULL,	NULL,	'MEEKER',	'OK',	'CAbc7048c94483e370bc19004383fd4445',	'+19188009881',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE2060ac641bd0246c8ea8c101e5096fb7',	0,	0,	'',	''),
(2109,	'CA8067409180610fa26b48fa52c4fe7327',	'',	'2018-04-23 19:55:51',	'US',	'74110',	'OK',	'TULSA',	'US',	'74401',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19186169525',	'+19186158825',	'+19186169525',	NULL,	NULL,	NULL,	NULL,	'MUSKOGEE',	'OK',	'CA8067409180610fa26b48fa52c4fe7327',	'+19188009881',	'completed',	6,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE13b25abad32ee192897a1f3895b9d7e0',	0,	0,	'',	''),
(2110,	'CA58b50355a9af50ac929a83c802b98128',	'',	'2018-04-23 20:27:03',	'US',	'94509',	'CA',	'ANTIOCH',	'US',	'94588',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19252182011',	'+19252197932',	'+19252182011',	NULL,	NULL,	NULL,	NULL,	'PLEASANTON',	'CA',	'CA58b50355a9af50ac929a83c802b98128',	'+19255840363',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE58b841e6b7770924a60bcf84801f6d6a',	0,	0,	'',	''),
(2111,	'CAe92e53057a2112187dfcfc151281d6b4',	'',	'2018-04-23 21:35:13',	'US',	'94108',	'CA',	'SAN FRANCISCO',	'US',	'94108',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15102301816',	'+15102300755',	'+15102301816',	NULL,	NULL,	NULL,	NULL,	'SAN FRANCISCO',	'CA',	'CAe92e53057a2112187dfcfc151281d6b4',	'+15106893859',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2112,	'CAa7b08006d4628954e72b2bc11a244a5e',	'',	'2018-04-23 23:53:24',	'US',	'',	'CA',	'',	'US',	'95829',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19166911868',	'+19166941672',	'+19166911868',	NULL,	NULL,	NULL,	NULL,	'ELK GROVE',	'CA',	'CAa7b08006d4628954e72b2bc11a244a5e',	'+19163975518',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2113,	'CA0b8eabcd2beec65a33172b561f511a32',	'',	'2018-04-24 14:38:47',	'US',	'',	'TX',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14696782131',	'+14693536033',	'+14696782131',	NULL,	NULL,	NULL,	NULL,	'',	'TX',	'CA0b8eabcd2beec65a33172b561f511a32',	'+18177847768',	'failed',	NULL,	NULL,	0,	0,	'',	''),
(2114,	'CAae17b16b0e70901585ebdd386187684b',	'',	'2018-04-24 17:17:02',	'US',	'',	'CA',	'',	'US',	'39532',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12282071287',	'+19166340519',	'+12282071287',	NULL,	NULL,	NULL,	NULL,	'BILOXI',	'MS',	'CAae17b16b0e70901585ebdd386187684b',	'+19166287355',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb2cdd1cc3bc624b9279ec57f3ab1a1b2',	0,	0,	'',	''),
(2115,	'CA5414e8457f215ce5c11e09fe58dd7c03',	'',	'2018-04-24 19:51:25',	'US',	'76210',	'TX',	'DENTON',	'US',	'08902',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17323132412',	'+19402203539',	'+17323132412',	NULL,	NULL,	NULL,	NULL,	'NEW BRUNSWICK',	'NJ',	'CA5414e8457f215ce5c11e09fe58dd7c03',	'+19727954260',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2116,	'CA885edf92b5694ba2f96e001caabd484d',	'',	'2018-04-24 21:40:53',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'77320',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19366613251',	'+19722036640',	'+19366613251',	NULL,	NULL,	NULL,	NULL,	'HUNTSVILLE',	'TX',	'CA885edf92b5694ba2f96e001caabd484d',	'+19728157325',	'completed',	272,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE44072a4e5333e7a6aaa6beef11a972e9',	0,	0,	'',	''),
(2117,	'CA3a1449195e9a2c60ebd85ed460af568e',	'',	'2018-04-24 22:45:45',	'US',	'',	'NV',	'',	'US',	'89147',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17028102020',	'+17028196450',	'+17028102020',	NULL,	NULL,	NULL,	NULL,	'LAS VEGAS',	'NV',	'CA3a1449195e9a2c60ebd85ed460af568e',	'+17252223264',	'completed',	45,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE064bf981fe8577361a2a8c85a272f7f7',	0,	0,	'',	''),
(2118,	'CA75226e7f61721200615a6c88b5adf5bc',	'',	'2018-04-24 23:27:35',	'US',	'75244',	'TX',	'DALLAS',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18448065577',	'+19729190409',	'+18448065577',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA75226e7f61721200615a6c88b5adf5bc',	'+19728157325',	'completed',	50,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE6e5b63b8e7bd4e75248a4059c7de0573',	0,	0,	'',	''),
(2119,	'CA6fdf117636e34b2ddb153e826f424f34',	'',	'2018-04-24 23:27:35',	'US',	'75244',	'TX',	'DALLAS',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19729190409',	'+18448065577',	NULL,	NULL,	NULL,	NULL,	'',	'',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2120,	'CA0dbcea6475c65c504ae16ffe3b1eef50',	'',	'2018-04-24 23:54:43',	'US',	'92122',	'CA',	'SAN DIEGO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18448065577',	'+16195548764',	'+18448065577',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA0dbcea6475c65c504ae16ffe3b1eef50',	'+16198233047',	'completed',	39,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb4ed5ee70be85b86cbac6d04a9c04f81',	0,	0,	'',	''),
(2121,	'CA95fbb6d248dc001d75d3668bfba52ca0',	'',	'2018-04-24 23:54:44',	'US',	'92122',	'CA',	'SAN DIEGO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18448065577',	'+16195548764',	'+18448065577',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA95fbb6d248dc001d75d3668bfba52ca0',	'+16198233047',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2122,	'CAb56f07b44398b3bdbbbd031a6197df5e',	'',	'2018-04-25 00:10:22',	'US',	'76210',	'TX',	'DENTON',	'US',	'10010',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19179947738',	'+19402203619',	'+19179947738',	NULL,	NULL,	NULL,	NULL,	'NEW YORK',	'NY',	'CAb56f07b44398b3bdbbbd031a6197df5e',	'+16172334088',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2123,	'CA6141ae4627f0e7cc2353fca380f2b1ca',	'',	'2018-04-25 00:16:07',	'US',	'',	'TX',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18448065577',	'+14696091618',	'+18448065577',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA6141ae4627f0e7cc2353fca380f2b1ca',	'+12146953999',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2124,	'CA62cee0198d5de1d0b6bec9985af55ff7',	'',	'2018-04-25 00:16:07',	'US',	'',	'TX',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18448065577',	'+14696091618',	'+18448065577',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA62cee0198d5de1d0b6bec9985af55ff7',	'+12146953999',	'completed',	48,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE6b2d46722abf2143e05805720028774e',	0,	0,	'',	''),
(2125,	'CA6438bb218d591f6060239ce061a93915',	'',	'2018-04-25 03:44:20',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18448065577',	'+19165849538',	'+18448065577',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA6438bb218d591f6060239ce061a93915',	'+19162243237',	'completed',	9,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE7b14e3547ac850f926ca4dedd3b12815',	0,	0,	'',	''),
(2126,	'CAac8a1f4dd38ecfc6edd56bb8d38437f7',	'',	'2018-04-25 03:44:21',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18448065577',	'+19165849538',	'+18448065577',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CAac8a1f4dd38ecfc6edd56bb8d38437f7',	'+19162243237',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2127,	'CA6880837d1f4ba330e6a323fe0aa18b94',	'',	'2018-04-25 17:56:31',	'US',	'76210',	'TX',	'DENTON',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14123143867',	'+19402203619',	'+14123143867',	NULL,	NULL,	NULL,	NULL,	'',	'PA',	'CA6880837d1f4ba330e6a323fe0aa18b94',	'+16172334088',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2128,	'CA9a72f3fb7d70d67ba147c38b1fc6dd4a',	'',	'2018-04-25 18:34:58',	'US',	'',	'CA',	'',	'US',	'75058',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19032078283',	'+19168273879',	'+19032078283',	NULL,	NULL,	NULL,	NULL,	'GUNTER',	'TX',	'CA9a72f3fb7d70d67ba147c38b1fc6dd4a',	'+19163975518',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2129,	'CAb2b3e1bff04fa9c9ae68978d1bd07d6c',	'',	'2018-04-25 19:18:40',	'US',	'76071',	'TX',	'AZLE',	'US',	'76012',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18175386618',	'+18178138165',	'+18175386618',	NULL,	NULL,	NULL,	NULL,	'ARLINGTON',	'TX',	'CAb2b3e1bff04fa9c9ae68978d1bd07d6c',	'+18173042914',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REcd0b786ab1c7d1724899f6b9fa54ce3f',	0,	0,	'',	''),
(2130,	'CA93e840821fbef6da1b20f3bf3e2bcb88',	'',	'2018-04-25 19:47:57',	'US',	'92118',	'CA',	'CORONADO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18448065577',	'+16193136751',	'+18448065577',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA93e840821fbef6da1b20f3bf3e2bcb88',	'+16198233047',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2131,	'CAe4cc6be0d2d36d2bba66415546cf3657',	'',	'2018-04-25 19:47:57',	'US',	'92118',	'CA',	'CORONADO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18448065577',	'+16193136751',	'+18448065577',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CAe4cc6be0d2d36d2bba66415546cf3657',	'+16198233047',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2132,	'CA9d8297a29cf85f2d26a0ee913fb49043',	'',	'2018-04-25 22:43:44',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18448065577',	'+19166941672',	'+18448065577',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA9d8297a29cf85f2d26a0ee913fb49043',	'+19163975518',	'completed',	53,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE54ab4fefdeb9bdfc2043a7d1b1009917',	0,	0,	'',	''),
(2133,	'CA1cad7d27b477988f514b7f2b254eae31',	'',	'2018-04-25 22:43:44',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18448065577',	'+19166941672',	'+18448065577',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA1cad7d27b477988f514b7f2b254eae31',	'+19163975518',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2134,	'CA08fea94ea59a1289de9fdecf5298e3d3',	'',	'2018-04-25 22:50:56',	'US',	'20744',	'MD',	'OXON HILL',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18448065577',	'+13017476807',	'+18448065577',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA08fea94ea59a1289de9fdecf5298e3d3',	'+12024123578',	'completed',	39,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE8fa0796770c300a7c7a6351d81c02e01',	0,	0,	'',	''),
(2135,	'CAb1f3f1e31728122d7509d41ce14037a2',	'',	'2018-04-25 22:50:56',	'US',	'20744',	'MD',	'OXON HILL',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18448065577',	'+13017476807',	'+18448065577',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CAb1f3f1e31728122d7509d41ce14037a2',	'+12024123578',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2136,	'CA36bafbf7220c831abf7a0bc7172ed28d',	'',	'2018-04-26 13:29:56',	'US',	'30312',	'GA',	'ATLANTA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16614954124',	'+14044765368',	'+16614954124',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA36bafbf7220c831abf7a0bc7172ed28d',	'+14042107184',	'completed',	21,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE8f28a1dde3223ab95787e63042bf7c77',	0,	0,	'',	''),
(2137,	'CAf366abfab45b99d2175872fe6e31c9cc',	'',	'2018-04-26 13:35:57',	'US',	'76248',	'TX',	'FORT WORTH',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18448065577',	'+18179681164',	'+18448065577',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CAf366abfab45b99d2175872fe6e31c9cc',	'+18178814663',	'completed',	23,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe17d3f24596c17d66ee3be5990882486',	0,	0,	'',	''),
(2138,	'CAd4b3b53519082f14e2984d43bb78a8d8',	'',	'2018-04-26 13:35:57',	'US',	'76248',	'TX',	'FORT WORTH',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18448065577',	'+18179681164',	'+18448065577',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CAd4b3b53519082f14e2984d43bb78a8d8',	'+18178814663',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2139,	'CAd89f46cf2e7ce325d37f4accdd0a49a1',	'',	'2018-04-26 17:54:08',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'77320',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19366613251',	'+19722036640',	'+19366613251',	NULL,	NULL,	NULL,	NULL,	'HUNTSVILLE',	'TX',	'CAd89f46cf2e7ce325d37f4accdd0a49a1',	'+19728157325',	'completed',	6,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe0beaf9e023afc3c77a1468db8d0f346',	0,	0,	'',	''),
(2140,	'CA3eb2ba608048b7c9fa857b9695bc6d68',	'',	'2018-04-26 17:54:12',	'US',	'76210',	'TX',	'DENTON',	'US',	'68137',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14029359013',	'+19402203619',	'+14029359013',	NULL,	NULL,	NULL,	NULL,	'OMAHA',	'NE',	'CA3eb2ba608048b7c9fa857b9695bc6d68',	'+16172334088',	'completed',	56,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE73c3697d887c3d65f22ab67cac6ea1e0',	0,	0,	'',	''),
(2141,	'CA97ead43c520e27d3d669d111180aec10',	'',	'2018-04-26 17:56:02',	'US',	'75024',	'TX',	'PLANO',	'US',	'77320',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19366613251',	'+19728051470',	'+19366613251',	NULL,	NULL,	NULL,	NULL,	'HUNTSVILLE',	'TX',	'CA97ead43c520e27d3d669d111180aec10',	'+12146824990',	'completed',	45,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE434c6e07c7d5670f0263a0f6ac68e43c',	0,	0,	'',	''),
(2142,	'CA688fc94ee8c29c313b477aeea84c10a2',	'',	'2018-04-26 19:19:59',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19166964968',	'+19166941672',	'+19166964968',	NULL,	NULL,	NULL,	NULL,	'',	'CA',	'CA688fc94ee8c29c313b477aeea84c10a2',	'+19163975518',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2143,	'CA0af9e6a725dcb609830984bc3bc81945',	'',	'2018-04-26 19:28:22',	'US',	'29501',	'SC',	'FLORENCE',	'US',	'29576',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18432150850',	'+18432121085',	'+18432150850',	NULL,	NULL,	NULL,	NULL,	'MYRTLE BEACH',	'SC',	'CA0af9e6a725dcb609830984bc3bc81945',	'+19733427183',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2144,	'CA1588beafd5706e6186ee55265261b519',	'',	'2018-04-26 20:13:45',	'US',	'94509',	'CA',	'ANTIOCH',	'US',	'76424',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12544772740',	'+19252197932',	'+12544772740',	NULL,	NULL,	NULL,	NULL,	'BRECKENRIDGE',	'TX',	'CA1588beafd5706e6186ee55265261b519',	'+19255840363',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2145,	'CA0f8f9d4e094cc7a91f1552655e21a4d6',	'',	'2018-04-26 21:07:38',	'US',	'75234',	'TX',	'CARROLLTON',	'US',	'76704',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18177563018',	'+14695578827',	'+18177563018',	NULL,	NULL,	NULL,	NULL,	'GRAPEVINE',	'TX',	'CA0f8f9d4e094cc7a91f1552655e21a4d6',	'+19402315995',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE57f5fa6cc618e69fedfbdc9e74a608d9',	0,	0,	'',	''),
(2146,	'CAba6393039112807c035f9b29c4318e2d',	'',	'2018-04-26 21:36:32',	'US',	'77901',	'TX',	'VICTORIA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18448065577',	'+13612103537',	'+18448065577',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CAba6393039112807c035f9b29c4318e2d',	'+18327156360',	'completed',	56,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REac3164130a2890dd1d3d6e0b244f7551',	0,	0,	'',	''),
(2147,	'CA636e4657b81fc3a81dcd7f852e3e0dca',	'',	'2018-04-26 21:36:32',	'US',	'77901',	'TX',	'VICTORIA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+13612103537',	'+18448065577',	NULL,	NULL,	NULL,	NULL,	'',	'',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2148,	'CA0a4282f805b01c35cf5fc44417d9ff6b',	'',	'2018-04-26 22:34:44',	'US',	'94553',	'CA',	'MARTINEZ',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18448065577',	'+19252319862',	'+18448065577',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA0a4282f805b01c35cf5fc44417d9ff6b',	'+19255840363',	'completed',	50,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf47c2ec13febcace2a47018cd8dcb006',	0,	0,	'',	''),
(2149,	'CA9cdc9f32c316d2143cf47392604a0a4f',	'',	'2018-04-26 22:34:44',	'US',	'94553',	'CA',	'MARTINEZ',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18448065577',	'+19252319862',	'+18448065577',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA9cdc9f32c316d2143cf47392604a0a4f',	'+19255840363',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2150,	'CA77b9c8ace33985f76beb26adc82c3a57',	'',	'2018-04-26 22:42:01',	'US',	'76210',	'TX',	'DENTON',	'US',	'76645',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19727682860',	'+19402203090',	'+19727682860',	NULL,	NULL,	NULL,	NULL,	'FORT WORTH',	'TX',	'CA77b9c8ace33985f76beb26adc82c3a57',	'+19402315995',	'completed',	47,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REbb005b998831a87f75a23d6b3c4a85d0',	0,	0,	'',	''),
(2151,	'CA5a8138a0d62e6982119660b89fd81b6c',	'',	'2018-04-27 14:40:19',	'US',	'75002',	'TX',	'ALLEN',	'US',	'77093',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17136359103',	'+19729546080',	'+17136359103',	NULL,	NULL,	NULL,	NULL,	'HOUSTON',	'TX',	'CA5a8138a0d62e6982119660b89fd81b6c',	'+12147183718',	'completed',	24,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE1cb60649e3b8bb4b50570e4ecab0161d',	0,	0,	'',	''),
(2152,	'CA7a68d4a1bb58f8d7da23fa07dac6974f',	'',	'2018-04-27 17:31:49',	'US',	'94568',	'CA',	'PLEASANTON',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18448065577',	'+19252042504',	'+18448065577',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA7a68d4a1bb58f8d7da23fa07dac6974f',	'+19255840363',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2153,	'CA9d9be72b6a3c81c25fa4d564e49453fd',	'',	'2018-04-27 17:31:49',	'US',	'94568',	'CA',	'PLEASANTON',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18448065577',	'+19252042504',	'+18448065577',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA9d9be72b6a3c81c25fa4d564e49453fd',	'+19255840363',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2154,	'CAd74e439a6008d5f44718cc153b3c5757',	'',	'2018-04-27 18:30:35',	'US',	'85034',	'AZ',	'PHOENIX',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18448065577',	'+14802691941',	'+18448065577',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CAd74e439a6008d5f44718cc153b3c5757',	'+14803882032',	'completed',	31,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE32cb68d027f7d3d6ea4e5a9da9ff18fc',	0,	0,	'',	''),
(2155,	'CA06479f25a9e949a82fc8cb3d42d87aac',	'',	'2018-04-27 18:30:35',	'US',	'85034',	'AZ',	'PHOENIX',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18448065577',	'+14802691941',	'+18448065577',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA06479f25a9e949a82fc8cb3d42d87aac',	'+14803882032',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2156,	'CAd2e1a2c416b42c168609693764f0c1d7',	'',	'2018-04-27 19:44:20',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75052',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12147141588',	'+19722036640',	'+12147141588',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CAd2e1a2c416b42c168609693764f0c1d7',	'+19728157325',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2157,	'CAe03c00476f9bfe90f35bfb3296fa743d',	'',	'2018-04-27 20:06:35',	'US',	'30044',	'GA',	'ATLANTA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18448065577',	'+16782493679',	'+18448065577',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CAe03c00476f9bfe90f35bfb3296fa743d',	'+14042107184',	'completed',	33,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE0ee03a005283e6ee82aef62b25c77728',	0,	0,	'',	''),
(2158,	'CA8fe196540441c93c6c9f9a4f4af22b7b',	'',	'2018-04-27 20:06:35',	'US',	'30044',	'GA',	'ATLANTA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18448065577',	'+16782493679',	'+18448065577',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA8fe196540441c93c6c9f9a4f4af22b7b',	'+14042107184',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2159,	'CA4d3cb8524d12b66b9c37764e05ed7dd0',	'',	'2018-04-27 22:00:12',	'US',	'',	'NV',	'',	'US',	'89101',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17029113157',	'+17029195831',	'+17029113157',	NULL,	NULL,	NULL,	NULL,	'LAS VEGAS',	'NV',	'CA4d3cb8524d12b66b9c37764e05ed7dd0',	'+17252223264',	'completed',	59,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE470998e257f7d6b37f2d5e5ec72455bf',	0,	0,	'',	''),
(2160,	'CA85a6db77deca438d030b3c0a131dfd46',	'',	'2018-04-27 22:31:45',	'US',	'75002',	'TX',	'ALLEN',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18448065577',	'+19729546137',	'+18448065577',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA85a6db77deca438d030b3c0a131dfd46',	'+19402315995',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE5aaf61e9cef1f1617e6ac5634a296fbf',	0,	0,	'',	''),
(2161,	'CAcc98aa9bd4fbeb6609a0ef21de6c1fa9',	'',	'2018-04-27 22:31:45',	'US',	'75002',	'TX',	'ALLEN',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19729546137',	'+18448065577',	NULL,	NULL,	NULL,	NULL,	'',	'',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2162,	'CA63aafe89952cf0734b47bf14e81f6db5',	'',	'2018-04-28 00:02:51',	'US',	'30345',	'GA',	'ATLANTA',	'US',	'30336',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14042107184',	'+16782456062',	'+14042107184',	NULL,	NULL,	NULL,	NULL,	'ATLANTA',	'GA',	'CA63aafe89952cf0734b47bf14e81f6db5',	'+14042107184',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2163,	'CAf1de51cadb9f65fa06019110d9490b92',	'',	'2018-04-28 00:03:50',	'US',	'30345',	'GA',	'ATLANTA',	'US',	'30144',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17705916318',	'+16782456062',	'+17705916318',	NULL,	NULL,	NULL,	NULL,	'WOODSTOCK',	'GA',	'CAf1de51cadb9f65fa06019110d9490b92',	'+14042107184',	'completed',	4,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe1ee0dd6f2fc75586523c52e44cc6832',	0,	0,	'',	''),
(2164,	'CA45ad81f8ca52c2c02fb58b7fa8516dd9',	'',	'2018-04-28 00:07:26',	'US',	'74110',	'OK',	'TULSA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18448065577',	'+19186158825',	'+18448065577',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA45ad81f8ca52c2c02fb58b7fa8516dd9',	'+19188009881',	'completed',	50,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE994c2c57bb9d634ec77e7f3ac6beb300',	0,	0,	'',	''),
(2165,	'CAfc903ccea95138ee15b139e4002201f9',	'',	'2018-04-28 00:07:26',	'US',	'74110',	'OK',	'TULSA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18448065577',	'+19186158825',	'+18448065577',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CAfc903ccea95138ee15b139e4002201f9',	'+19188009881',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2166,	'CA234b990cf0e158c0ef2c6cc7911a60d4',	'',	'2018-04-28 00:14:59',	'US',	'76210',	'TX',	'DENTON',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18448065577',	'+19402203356',	'+18448065577',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA234b990cf0e158c0ef2c6cc7911a60d4',	'+19402315995',	'completed',	6,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE6e3e667cb2006249addaad614629610c',	0,	0,	'',	''),
(2167,	'CA1b254a180e8f94f93d69ea4b008084c5',	'',	'2018-04-28 00:14:59',	'US',	'76210',	'TX',	'DENTON',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+19402203356',	'+18448065577',	NULL,	NULL,	NULL,	NULL,	'',	'',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2168,	'CAd67dd5d1d625aaf3de0d9f1e4abcd6c1',	'',	'2018-04-28 01:04:47',	'US',	'74172',	'OK',	'TULSA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18448065577',	'+19186094615',	'+18448065577',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CAd67dd5d1d625aaf3de0d9f1e4abcd6c1',	'+19188009881',	'completed',	33,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE946d26d7f5ef916357996d0f1df8fd6b',	0,	0,	'',	''),
(2169,	'CA74e8610dc9deb32058d2ab55d23a6373',	'',	'2018-04-28 01:04:47',	'US',	'74172',	'OK',	'TULSA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18448065577',	'+19186094615',	'+18448065577',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA74e8610dc9deb32058d2ab55d23a6373',	'+19188009881',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE597edd9b29cb2f131c17fab83bdd92d2',	0,	0,	'',	''),
(2170,	'CA83674ca1bbd1be4536e83da1d283f0cc',	'',	'2018-04-28 02:47:57',	'US',	'94621',	'CA',	'OAKLAND',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18448065577',	'+15102395675',	'+18448065577',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA83674ca1bbd1be4536e83da1d283f0cc',	'+15106893859',	'completed',	41,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE1d1ecbfb9752bd6448db0cabdee42ed3',	0,	0,	'',	''),
(2171,	'CAe9727c66a53dd5c9a56056a0ffd81ef5',	'',	'2018-04-28 02:58:16',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18448065577',	'+18582520630',	'+18448065577',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CAe9727c66a53dd5c9a56056a0ffd81ef5',	'+17602378044',	'completed',	46,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REb716fe91ab49e1f759902fce84b9e569',	0,	0,	'',	''),
(2172,	'CA60d787df6b1a730b7b76c6d843b89b66',	'',	'2018-04-28 02:58:16',	'US',	'',	'CA',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18448065577',	'+18582520630',	'+18448065577',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA60d787df6b1a730b7b76c6d843b89b66',	'+17602378044',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2173,	'CA260ed2dc0e858509cb5452c2b6b52e79',	'',	'2018-04-28 17:28:48',	'US',	'',	'TX',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18448065577',	'+16823074517',	'+18448065577',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA260ed2dc0e858509cb5452c2b6b52e79',	'+18173042914',	'completed',	59,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE94d08607c8ca098aa417b3aeaa6ebf01',	0,	0,	'',	''),
(2174,	'CA3dec1bfcdcfce606a8ff0ace4b7158dc',	'',	'2018-04-28 17:28:49',	'US',	'',	'TX',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	NULL,	'+16823074517',	'+18448065577',	NULL,	NULL,	NULL,	NULL,	'',	'',	NULL,	NULL,	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2175,	'CAce05864ed8864c5a9f56682437e1d09f',	'',	'2018-04-28 18:53:29',	'US',	'76271',	'TX',	'TIOGA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18448065577',	'+19402027207',	'+18448065577',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CAce05864ed8864c5a9f56682437e1d09f',	'+12146628447',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2176,	'CA8314a415b8b37eb2fd5eae4b74c2d3c4',	'',	'2018-04-28 18:53:29',	'US',	'76271',	'TX',	'TIOGA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18448065577',	'+19402027207',	'+18448065577',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA8314a415b8b37eb2fd5eae4b74c2d3c4',	'+12146628447',	'completed',	49,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE7e66bd05fbdc674d93ff4e65928522cd',	0,	0,	'',	''),
(2177,	'CAf907b66f5cf814af8c20ec3eb58a1968',	'',	'2018-04-28 19:16:00',	'US',	'22306',	'MD',	'ALEXANDRIA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18448065577',	'+12403453492',	'+18448065577',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CAf907b66f5cf814af8c20ec3eb58a1968',	'+12024123578',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE5fa5111a075bc08dd16e359554ba4f9d',	0,	0,	'',	''),
(2178,	'CA35c0f3fb749ee12603b0a220c486c2c3',	'',	'2018-04-28 19:16:00',	'US',	'22306',	'MD',	'ALEXANDRIA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18448065577',	'+12403453492',	'+18448065577',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA35c0f3fb749ee12603b0a220c486c2c3',	'+12024123578',	'completed',	44,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE65c01249afdb83b01334ab071c7374a0',	0,	0,	'',	''),
(2179,	'CA3d8b6818d2a4237e6462feb477591c3f',	'',	'2018-04-28 19:33:57',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18163072214',	'+19722036218',	'+18163072214',	NULL,	NULL,	NULL,	NULL,	'',	'MO',	'CA3d8b6818d2a4237e6462feb477591c3f',	'+12147183718',	'completed',	8,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE8c1890ada3e36efeca4581d7005276c3',	0,	0,	'',	''),
(2180,	'CA7d39ee5043ccea54aa6876a6d76c1703',	'',	'2018-04-28 22:21:25',	'US',	'76271',	'TX',	'TIOGA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14694039139',	'+19402027207',	'+14694039139',	NULL,	NULL,	NULL,	NULL,	'',	'TX',	'CA7d39ee5043ccea54aa6876a6d76c1703',	'+12146628447',	'completed',	48,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE721079d8dffb069b8278ba33c27e5b7e',	0,	0,	'',	''),
(2181,	'CAdef55ff0324fc1939b544a0e99b794f3',	'',	'2018-04-28 23:36:20',	'US',	'76071',	'TX',	'AZLE',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18448065577',	'+18178138258',	'+18448065577',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CAdef55ff0324fc1939b544a0e99b794f3',	'+18173042914',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2182,	'CA29aa41bff680792e94d332f9ad97f97f',	'',	'2018-04-28 23:36:20',	'US',	'76071',	'TX',	'AZLE',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18448065577',	'+18178138258',	'+18448065577',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA29aa41bff680792e94d332f9ad97f97f',	'+18173042914',	'completed',	59,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE082af1f80c0b8c107508cfe966d126ac',	0,	0,	'',	''),
(2183,	'CA64aec5798e6caea6c5b2a68c2f6ba069',	'',	'2018-04-29 00:35:54',	'US',	'',	'CA',	'MODESTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18448065577',	'+12092523089',	'+18448065577',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA64aec5798e6caea6c5b2a68c2f6ba069',	'+12096060026',	'completed',	33,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REba9308e396036812feb67a170533e5fb',	0,	0,	'',	''),
(2184,	'CAdd1cbbfd4354e1b24153afa1935138b2',	'',	'2018-04-29 00:35:54',	'US',	'',	'CA',	'MODESTO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18448065577',	'+12092523089',	'+18448065577',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CAdd1cbbfd4354e1b24153afa1935138b2',	'+12096060026',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2185,	'CA10341e9eeec83f9d29b99f01d8233486',	'',	'2018-04-29 16:13:54',	'US',	'76210',	'TX',	'DENTON',	'US',	'19075',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12154025031',	'+19402203090',	'+12154025031',	NULL,	NULL,	NULL,	NULL,	'PHILADELPHIA',	'PA',	'CA10341e9eeec83f9d29b99f01d8233486',	'+19402315995',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2186,	'CA65b71f93d9bb62a413409dabdeb32593',	'',	'2018-04-29 19:00:16',	'US',	'94108',	'CA',	'SAN FRANCISCO',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18002255662',	'+15102300755',	'+18002255662',	NULL,	NULL,	NULL,	NULL,	'',	'',	'CA65b71f93d9bb62a413409dabdeb32593',	'+15106893859',	'completed',	13,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE9940d911b9466b2418f8529cb302f462',	0,	0,	'',	''),
(2187,	'CA87351f2dfe8f5ba457c95f27c3159c48',	'',	'2018-04-29 21:39:10',	'US',	'76271',	'TX',	'TIOGA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14694039139',	'+19402027207',	'+14694039139',	NULL,	NULL,	NULL,	NULL,	'',	'TX',	'CA87351f2dfe8f5ba457c95f27c3159c48',	'+12146628447',	'completed',	15,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REee4d16961fe7ae1f55592bc0ed3f9d78',	0,	0,	'',	''),
(2188,	'CA194a9fc71f32bbf13bc99b64c967adfb',	'',	'2018-04-30 16:17:04',	'US',	'',	'TX',	'',	'US',	'53205',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14145268200',	'+14696096722',	'+14145268200',	NULL,	NULL,	NULL,	NULL,	'MILWAUKEE',	'WI',	'CA194a9fc71f32bbf13bc99b64c967adfb',	'+19728157325',	'completed',	38,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE41f790168d575c330efca36594e0026d',	0,	0,	'',	''),
(2189,	'CA98c921138fd2e165fa9f5a9e3ddabd75',	'',	'2018-04-30 18:12:37',	'US',	'',	'NV',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17029163877',	'+17029195831',	'+17029163877',	NULL,	NULL,	NULL,	NULL,	'',	'NV',	'CA98c921138fd2e165fa9f5a9e3ddabd75',	'+17252223264',	'completed',	18,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE6fd88e305e309f269114e0753682eefe',	0,	0,	'',	''),
(2190,	'CA1822715a3d115d9acc31a820dd393518',	'',	'2018-04-30 18:14:32',	'US',	'',	'AZ',	'',	'US',	'85016',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16237481399',	'+16233001626',	'+16237481399',	NULL,	NULL,	NULL,	NULL,	'PHOENIX',	'AZ',	'CA1822715a3d115d9acc31a820dd393518',	'+14802390652',	'completed',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3afb12a9d101d6655772a1d3c4ab2c49',	0,	0,	'',	''),
(2191,	'CA7d7ba80c782de928018f2b7022369cf6',	'',	'2018-04-30 20:39:09',	'US',	'',	'CA',	'',	'US',	'95833',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19165036993',	'+19165070189',	'+19165036993',	NULL,	NULL,	NULL,	NULL,	'SACRAMENTO',	'CA',	'CA7d7ba80c782de928018f2b7022369cf6',	'+19164825834',	'completed',	1,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4f0a5e13fca6f6a131da6427d7f3e8dc',	0,	0,	'',	''),
(2192,	'CA78ade22b47b9224b168a45bab39c3400',	'',	'2018-04-30 21:35:08',	'US',	'91934',	'CA',	'BOULEVARD',	'US',	'91934',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16192025983',	'+16192028836',	'+16192025983',	NULL,	NULL,	NULL,	NULL,	'BOULEVARD',	'CA',	'CA78ade22b47b9224b168a45bab39c3400',	'+17602378044',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2193,	'CAdb77d8048f8fa2abb18fd6c89df1a395',	'',	'2018-04-30 21:48:07',	'US',	'76060',	'TX',	'KENNEDALE',	'US',	'77575',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17134179876',	'+18173306036',	'+17134179876',	NULL,	NULL,	NULL,	NULL,	'HOUSTON',	'TX',	'CAdb77d8048f8fa2abb18fd6c89df1a395',	'+18173042914',	'completed',	239,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE82e5a406cc5e930d0854ccba1cab6bbb',	0,	0,	'',	''),
(2194,	'CA327f89f1c5235c7ec0a54ee3e94a4753',	'',	'2018-04-30 22:20:17',	'US',	'',	'NV',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12162859256',	'+17028307376',	'+12162859256',	NULL,	NULL,	NULL,	NULL,	'',	'OH',	'CA327f89f1c5235c7ec0a54ee3e94a4753',	'+17252223264',	'completed',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REf7fcf58ac1d56f410fee90d630425712',	0,	0,	'',	''),
(2195,	'CAa9982cce90a5db9460af7af02d962395',	'',	'2018-04-30 22:22:40',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75201',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12145249570',	'+19722036218',	'+12145249570',	NULL,	NULL,	NULL,	NULL,	'DALLAS',	'TX',	'CAa9982cce90a5db9460af7af02d962395',	'+12147183718',	'completed',	292,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE765d7e9a43e9c22e7eee5e8421d4a046',	0,	0,	'',	''),
(2196,	'CAfe931bc02c41ffd074d0f984c90d5144',	'',	'2018-04-30 22:54:10',	'US',	'',	'TX',	'',	'US',	'77069',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18327040552',	'+18327064084',	'+18327040552',	NULL,	NULL,	NULL,	NULL,	'HOUSTON',	'TX',	'CAfe931bc02c41ffd074d0f984c90d5144',	'+18327156360',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2197,	'CAb717a6a084b0f76c8c9951da349210f3',	'',	'2018-04-30 23:48:56',	'US',	'76271',	'TX',	'TIOGA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14694039139',	'+19402027207',	'+14694039139',	NULL,	NULL,	NULL,	NULL,	'',	'TX',	'CAb717a6a084b0f76c8c9951da349210f3',	'+12146628447',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REc2dffd6150a1951a619b01d46fee616d',	0,	0,	'',	''),
(2198,	'CAf86d1f7f48c7d5142c02919326a4b54f',	'',	'2018-05-01 17:18:44',	'US',	'22306',	'MD',	'ALEXANDRIA',	'US',	'20015',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12022772862',	'+12403453492',	'+12022772862',	NULL,	NULL,	NULL,	NULL,	'WASHINGTON',	'DC',	'CAf86d1f7f48c7d5142c02919326a4b54f',	'+12024123578',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE13fe1662fb1625ac0091e5d264c7088e',	0,	0,	'',	''),
(2199,	'CAef0e6af7735a568c90985891b15285f3',	'',	'2018-05-01 18:31:59',	'US',	'29501',	'SC',	'FLORENCE',	'US',	'29424',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18432148894',	'+18432121085',	'+18432148894',	NULL,	NULL,	NULL,	NULL,	'CHARLESTON',	'SC',	'CAef0e6af7735a568c90985891b15285f3',	'+19733427183',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2200,	'CA8d55d3eef9b96123f20ba33e35c7582f',	'',	'2018-05-01 21:23:06',	'US',	'29501',	'SC',	'FLORENCE',	'US',	'29424',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18432148894',	'+18432121085',	'+18432148894',	NULL,	NULL,	NULL,	NULL,	'CHARLESTON',	'SC',	'CA8d55d3eef9b96123f20ba33e35c7582f',	'+19733427183',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2201,	'CA8defbda8aff6900d1a434c78c27d3f4d',	'',	'2018-05-01 22:24:05',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75182',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19722037152',	'+19722036218',	'+19722037152',	NULL,	NULL,	NULL,	NULL,	'SUNNYVALE',	'TX',	'CA8defbda8aff6900d1a434c78c27d3f4d',	'+12147183718',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2202,	'CA6f0d7dff1b9db12696d15ef9fefdc2a6',	'',	'2018-05-01 23:22:58',	'US',	'',	'CA',	'',	'US',	'95652',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19165859316',	'+19165849211',	'+19165859316',	NULL,	NULL,	NULL,	NULL,	'MCCLELLAN',	'CA',	'CA6f0d7dff1b9db12696d15ef9fefdc2a6',	'+19164825834',	'completed',	5,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE90de3e8f36ab95e1e288341e2ff29ee6',	0,	0,	'',	''),
(2203,	'CA38bf12a0e6dac6a8db0b8671a632fa92',	'',	'2018-05-02 02:06:04',	'US',	'94108',	'CA',	'SAN FRANCISCO',	'US',	'94805',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+15102362484',	'+15102300755',	'+15102362484',	NULL,	NULL,	NULL,	NULL,	'RICHMOND',	'CA',	'CA38bf12a0e6dac6a8db0b8671a632fa92',	'+15106893859',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REfc6a4dbb8999601d11bad9df382c8c6f',	0,	0,	'',	''),
(2204,	'CAe1cc7fb1b8990b462159053e3c524666',	'',	'2018-05-02 14:50:02',	'US',	'',	'TX',	'',	'US',	'75019',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19723048880',	'+14697784620',	'+19723048880',	NULL,	NULL,	NULL,	NULL,	'LEWISVILLE',	'TX',	'CAe1cc7fb1b8990b462159053e3c524666',	'+12146953999',	'completed',	10,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REe293bd6786cc9a2e06d97bcd9d254b63',	0,	0,	'',	''),
(2205,	'CA40e2b7a246ffe78c7bf3c605aa62f062',	'',	'2018-05-02 16:56:04',	'US',	'75024',	'TX',	'PLANO',	'US',	'75075',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14692351035',	'+19728051470',	'+14692351035',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CA40e2b7a246ffe78c7bf3c605aa62f062',	'+12146824990',	'completed',	144,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4b9278a0cd55bbaa31c01a789a0850d5',	0,	0,	'',	''),
(2206,	'CA6cf51afa20cf9ed2f3e241d625eb1760',	'',	'2018-05-02 16:57:37',	'US',	'76271',	'TX',	'TIOGA',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14694039139',	'+19402027207',	'+14694039139',	NULL,	NULL,	NULL,	NULL,	'',	'TX',	'CA6cf51afa20cf9ed2f3e241d625eb1760',	'+12146628447',	'completed',	195,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE4c901a46695821fdbaa0e79751307ccb',	0,	0,	'',	''),
(2207,	'CAacaad70a94e3d7fc2e2a6f9f880d66f4',	'',	'2018-05-02 17:38:49',	'US',	'',	'NV',	'',	'US',	'',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17029125247',	'+17029195831',	'+17029125247',	NULL,	NULL,	NULL,	NULL,	'',	'NV',	'CAacaad70a94e3d7fc2e2a6f9f880d66f4',	'+17252223264',	'completed',	90,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE18533339490fc7b247bfaae826f69b40',	0,	0,	'',	''),
(2208,	'CAdefabcd2857f5b433fb92592552f89d2',	'',	'2018-05-02 18:15:42',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'75060',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14692335669',	'+19722036218',	'+14692335669',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CAdefabcd2857f5b433fb92592552f89d2',	'+12147183718',	'completed',	23,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE3f9b0170be5abe73a18292f6e6b56c62',	0,	0,	'',	''),
(2209,	'CAd1b8c6c84c238c8581a0fac94a28b4c0',	'',	'2018-05-02 19:50:49',	'US',	'94568',	'CA',	'PLEASANTON',	'US',	'94568',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19252048163',	'+19252042504',	'+19252048163',	NULL,	NULL,	NULL,	NULL,	'PLEASANTON',	'CA',	'CAd1b8c6c84c238c8581a0fac94a28b4c0',	'+19255840363',	'completed',	19,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE36d8c66ea285555b19909d52f764e9e1',	0,	0,	'',	''),
(2210,	'CA97e5d8656e962df8dfb6da76128a6792',	'',	'2018-05-02 20:22:43',	'US',	'75082',	'TX',	'DALLAS',	'US',	'38703',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+16623476438',	'+19723626414',	'+16623476438',	NULL,	NULL,	NULL,	NULL,	'GREENVILLE',	'MS',	'CA97e5d8656e962df8dfb6da76128a6792',	'+12146628447',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2211,	'CA1c2d69bc5e2623731fc536caa4917bb5',	'',	'2018-05-02 20:28:18',	'US',	'',	'CA',	'',	'US',	'53159',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12622797069',	'+19168273879',	'+12622797069',	NULL,	NULL,	NULL,	NULL,	'GENOA CITY',	'WI',	'CA1c2d69bc5e2623731fc536caa4917bb5',	'+19163975518',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2212,	'CAc00f2f9e4f44d4d9d3d1447127c51cbb',	'',	'2018-05-02 21:17:33',	'US',	'',	'TX',	'',	'US',	'75052',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14693235638',	'+14695356358',	'+14693235638',	NULL,	NULL,	NULL,	NULL,	'GRAND PRAIRIE',	'TX',	'CAc00f2f9e4f44d4d9d3d1447127c51cbb',	'+19402315995',	'completed',	738,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE0e0fad742d39813be794992409078f2a',	0,	0,	'',	''),
(2213,	'CAa453338c25a2405fc535b1d7f607ac12',	'',	'2018-05-02 22:37:10',	'US',	'94553',	'CA',	'MARTINEZ',	'US',	'95112',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+14086487713',	'+19252319862',	'+14086487713',	NULL,	NULL,	NULL,	NULL,	'SAN JOSE',	'CA',	'CAa453338c25a2405fc535b1d7f607ac12',	'+19255840363',	'completed',	322,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REa135e27a99fc3c08e6abab7853007892',	0,	0,	'',	''),
(2214,	'CAcd48af9fc82e8e9248ed1e60463adf29',	'',	'2018-05-02 23:05:22',	'US',	'75182',	'TX',	'SUNNYVALE',	'US',	'64105',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18162030456',	'+19722036218',	'+18162030456',	NULL,	NULL,	NULL,	NULL,	'KANSAS CITY',	'MO',	'CAcd48af9fc82e8e9248ed1e60463adf29',	'+12147183718',	'completed',	11,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd347bd69d6160609948a8e0ecd1f90ec',	0,	0,	'',	''),
(2215,	'CAa208259f9b9205abfb2c069311bfde96',	'',	'2018-05-02 23:24:05',	'US',	'75077',	'TX',	'LEWISVILLE',	'US',	'76012',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18172099189',	'+14693221354',	'+18172099189',	NULL,	NULL,	NULL,	NULL,	'ARLINGTON',	'TX',	'CAa208259f9b9205abfb2c069311bfde96',	'+12147183718',	'completed',	789,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE43ee489e03efd2455c46673f3bf2161a',	0,	0,	'',	''),
(2216,	'CAd4fb0cb22905fabbd563346265d81737',	'',	'2018-05-02 23:57:52',	'US',	'',	'CA',	'',	'US',	'91950',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+18582548030',	'+18582520630',	'+18582548030',	NULL,	NULL,	NULL,	NULL,	'SAN DIEGO',	'CA',	'CAd4fb0cb22905fabbd563346265d81737',	'+17602378044',	'no-answer',	NULL,	NULL,	0,	0,	'',	''),
(2217,	'CA7c6a2a006aa64eb0071942c32b0da369',	'',	'2018-05-03 15:40:48',	'US',	'',	'TX',	'',	'US',	'77002',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17135201462',	'+14693536033',	'+17135201462',	NULL,	NULL,	NULL,	NULL,	'HOUSTON',	'TX',	'CA7c6a2a006aa64eb0071942c32b0da369',	'+18177847768',	'failed',	NULL,	NULL,	0,	0,	'',	''),
(2218,	'CA96aca9db603460b1e51ad63d0e6bfb25',	'',	'2018-05-03 17:13:50',	'US',	'',	'TX',	'',	'US',	'75024',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+12144071840',	'+14696052596',	'+12144071840',	NULL,	NULL,	NULL,	NULL,	'PLANO',	'TX',	'CA96aca9db603460b1e51ad63d0e6bfb25',	'+12147183718',	'completed',	282,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/RE950a0330042abf12f5ab2b902ed4906d',	0,	0,	'',	''),
(2219,	'CA43f7b0eec40f9832cc11db3605b93321',	'',	'2018-05-03 18:38:30',	'US',	'94553',	'CA',	'MARTINEZ',	'US',	'33705',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17279062069',	'+19252319862',	'+17279062069',	NULL,	NULL,	NULL,	NULL,	'SAINT PETERSBURG',	'FL',	'CA43f7b0eec40f9832cc11db3605b93321',	'+19255840363',	'completed',	7,	'https://api.twilio.com/2010-04-01/Accounts/AC71de92368dd931b9efbdde8b8ba7df87/Recordings/REd7eb4f5b5eff2d5628876f8e0241e4ac',	0,	0,	'',	''),
(2220,	'CA89e41f135b3880afeefc6207ea75d17e',	'',	'2018-05-03 18:50:04',	'US',	'',	'TX',	'',	'US',	'77002',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+17135201757',	'+14694343626',	'+17135201757',	NULL,	NULL,	NULL,	NULL,	'HOUSTON',	'TX',	'CA89e41f135b3880afeefc6207ea75d17e',	'+18177847768',	'failed',	NULL,	NULL,	0,	0,	'',	''),
(2221,	'CA4bb5fed1afc1471ec104b218b210be20',	'',	'2018-05-03 18:54:21',	'US',	'',	'CA',	'',	'US',	'74432',	'2010-04-01',	'inbound',	'ringing',	'AC71de92368dd931b9efbdde8b8ba7df87',	'+19186800504',	'+19166941672',	'+19186800504',	NULL,	NULL,	NULL,	NULL,	'MUSKOGEE',	'OK',	'CA4bb5f